import CJSImportProcessor from "../CJSImportProcessor";
import NameManager from "../NameManager";
import TokenProcessor from "../TokenProcessor";
import ReactHotLoaderTransformer from "./ReactHotLoaderTransformer";
import RootTransformer from "./RootTransformer";
import Transformer from "./Transformer";
/**
 * Class for editing import statements when we are transforming to commonjs.
 */
export default class CJSImportTransformer extends Transformer {
    readonly rootTransformer: RootTransformer;
    readonly tokens: TokenProcessor;
    readonly importProcessor: CJSImportProcessor;
    readonly nameManager: NameManager;
    readonly reactHotLoaderTransformer: ReactHotLoaderTransformer | null;
    readonly enableLegacyBabel5ModuleInterop: boolean;
    readonly isTypeScriptTransformEnabled: boolean;
    private hadExport;
    private hadNamedExport;
    private hadDefaultExport;
    private declarationInfo;
    constructor(rootTransformer: RootTransformer, tokens: TokenProcessor, importProcessor: CJSImportProcessor, nameManager: NameManager, reactHotLoaderTransformer: ReactHotLoaderTransformer | null, enableLegacyBabel5ModuleInterop: boolean, isTypeScriptTransformEnabled: boolean);
    getPrefixCode(): string;
    getSuffixCode(): string;
    process(): boolean;
    private processImportEquals;
    /**
     * Transform this:
     * import foo, {bar} from 'baz';
     * into
     * var _baz = require('baz'); var _baz2 = _interopRequireDefault(_baz);
     *
     * The import code was already generated in the import preprocessing step, so
     * we just need to look it up.
     */
    private processImport;
    /**
     * Erase this import, and return true if it was either of the form "import type" or contained only
     * "type" named imports. Such imports should not even do a side-effect import.
     *
     * The position should end at the import string.
     */
    private removeImportAndDetectIfType;
    private removeRemainingImport;
    private processIdentifier;
    processObjectShorthand(): boolean;
    processExport(): boolean;
    private processAssignment;
    /**
     * Process something like `a += 3`, where `a` might be an exported value.
     */
    private processComplexAssignment;
    /**
     * Process something like `++a`, where `a` might be an exported value.
     */
    private processPreIncDec;
    /**
     * Process something like `a++`, where `a` might be an exported value.
     * This starts at the `a`, not at the `++`.
     */
    private processPostIncDec;
    private processExportDefault;
    /**
     * Transform a declaration like `export var`, `export let`, or `export const`.
     */
    private processExportVar;
    /**
     * Determine if the export is of the form:
     * export var/let/const [varName] = [expr];
     * In other words, determine if function name inference might apply.
     */
    private isSimpleExportVar;
    /**
     * Transform an `export var` declaration initializing a single variable.
     *
     * For example, this:
     * export const f = () => {};
     * becomes this:
     * const f = () => {}; exports.f = f;
     *
     * The variable is unused (e.g. exports.f has the true value of the export).
     * We need to produce an assignment of this form so that the function will
     * have an inferred name of "f", which wouldn't happen in the more general
     * case below.
     */
    private processSimpleExportVar;
    /**
     * Transform normal declaration exports, including handling destructuring.
     * For example, this:
     * export const {x: [a = 2, b], c} = d;
     * becomes this:
     * ({x: [exports.a = 2, exports.b], c: exports.c} = d;)
     */
    private processComplexExportVar;
    /**
     * Transform this:
     * export function foo() {}
     * into this:
     * function foo() {} exports.foo = foo;
     */
    private processExportFunction;
    /**
     * Skip past a function with a name and return that name.
     */
    private processNamedFunction;
    /**
     * Transform this:
     * export class A {}
     * into this:
     * class A {} exports.A = A;
     */
    private processExportClass;
    /**
     * Transform this:
     * export {a, b as c};
     * into this:
     * exports.a = a; exports.c = b;
     *
     * OR
     *
     * Transform this:
     * export {a, b as c} from './foo';
     * into the pre-generated Object.defineProperty code from the ImportProcessor.
     *
     * For the first case, if the TypeScript transform is enabled, we need to skip
     * exports that are only defined as types.
     */
    private processExportBindings;
    private processExportStar;
    private shouldElideExportedIdentifier;
}
