import commonjs from '@rollup/plugin-commonjs';
import { nodeResolve } from '@rollup/plugin-node-resolve';
const pkg = require(process.env.PWD+'/package.json');
if(!pkg.dependencies) pkg.dependencies={};
const file = process.env.DEST_FILE ? process.env.DEST_FILE : pkg.exports && pkg.exports.require ? pkg.exports.require : 'index.cjs';

const config = {
	input: process.env.START_FILE,
	output: [{
		format: 'cjs',
		file: file,
		preferConst: true,
		interop: false,
		freeze: false,
		strict: false
	}],
	external: [
		...require('module').builtinModules,
	],
	plugins: [
        commonjs(),
        nodeResolve({
            moduleDirectories: ['node_modules', ...process.config.variables.node_relative_path.split(':').map((str) => process.config.variables.node_prefix + '/' + str)],
        }),
	]
}

export default config;
