/* Generated by Cython 0.10.3 on Sat Feb 28 00:25:36 2009 */

#define PY_SSIZE_T_CLEAN
#include "Python.h"
#include "structmember.h"
#ifndef PY_LONG_LONG
  #define PY_LONG_LONG LONG_LONG
#endif
#ifndef DL_EXPORT
  #define DL_EXPORT(t) t
#endif
#if PY_VERSION_HEX < 0x02040000
  #define METH_COEXIST 0
#endif
#if PY_VERSION_HEX < 0x02050000
  typedef int Py_ssize_t;
  #define PY_SSIZE_T_MAX INT_MAX
  #define PY_SSIZE_T_MIN INT_MIN
  #define PyInt_FromSsize_t(z) PyInt_FromLong(z)
  #define PyInt_AsSsize_t(o)   PyInt_AsLong(o)
  #define PyNumber_Index(o)    PyNumber_Int(o)
  #define PyIndex_Check(o)     PyNumber_Check(o)
#endif
#if PY_VERSION_HEX < 0x02060000
  #define Py_REFCNT(ob) (((PyObject*)(ob))->ob_refcnt)
  #define Py_TYPE(ob)   (((PyObject*)(ob))->ob_type)
  #define Py_SIZE(ob)   (((PyVarObject*)(ob))->ob_size)
  #define PyVarObject_HEAD_INIT(type, size) \
          PyObject_HEAD_INIT(type) size,
  #define PyType_Modified(t)

  typedef struct {
       void *buf;
       PyObject *obj;
       Py_ssize_t len;
       Py_ssize_t itemsize;
       int readonly;
       int ndim;
       char *format;
       Py_ssize_t *shape;
       Py_ssize_t *strides;
       Py_ssize_t *suboffsets;
       void *internal;
  } Py_buffer;

  #define PyBUF_SIMPLE 0
  #define PyBUF_WRITABLE 0x0001
  #define PyBUF_LOCK 0x0002
  #define PyBUF_FORMAT 0x0004
  #define PyBUF_ND 0x0008
  #define PyBUF_STRIDES (0x0010 | PyBUF_ND)
  #define PyBUF_C_CONTIGUOUS (0x0020 | PyBUF_STRIDES)
  #define PyBUF_F_CONTIGUOUS (0x0040 | PyBUF_STRIDES)
  #define PyBUF_ANY_CONTIGUOUS (0x0080 | PyBUF_STRIDES)
  #define PyBUF_INDIRECT (0x0100 | PyBUF_STRIDES)

#endif
#if PY_MAJOR_VERSION < 3
  #define __Pyx_BUILTIN_MODULE_NAME "__builtin__"
#else
  #define __Pyx_BUILTIN_MODULE_NAME "builtins"
#endif
#if PY_MAJOR_VERSION >= 3
  #define Py_TPFLAGS_CHECKTYPES 0
  #define Py_TPFLAGS_HAVE_INDEX 0
#endif
#if (PY_VERSION_HEX < 0x02060000) || (PY_MAJOR_VERSION >= 3)
  #define Py_TPFLAGS_HAVE_NEWBUFFER 0
#endif
#if PY_MAJOR_VERSION >= 3
  #define PyBaseString_Type            PyUnicode_Type
  #define PyString_Type                PyBytes_Type
  #define PyInt_Type                   PyLong_Type
  #define PyInt_Check(op)              PyLong_Check(op)
  #define PyInt_CheckExact(op)         PyLong_CheckExact(op)
  #define PyInt_FromString             PyLong_FromString
  #define PyInt_FromUnicode            PyLong_FromUnicode
  #define PyInt_FromLong               PyLong_FromLong
  #define PyInt_FromSize_t             PyLong_FromSize_t
  #define PyInt_FromSsize_t            PyLong_FromSsize_t
  #define PyInt_AsLong                 PyLong_AsLong
  #define PyInt_AS_LONG                PyLong_AS_LONG
  #define PyInt_AsSsize_t              PyLong_AsSsize_t
  #define PyInt_AsUnsignedLongMask     PyLong_AsUnsignedLongMask
  #define PyInt_AsUnsignedLongLongMask PyLong_AsUnsignedLongLongMask
  #define __Pyx_PyNumber_Divide(x,y)         PyNumber_TrueDivide(x,y)
#else
  #define __Pyx_PyNumber_Divide(x,y)         PyNumber_Divide(x,y)
  #define PyBytes_Type                 PyString_Type
#endif
#if PY_MAJOR_VERSION >= 3
  #define PyMethod_New(func, self, klass) PyInstanceMethod_New(func)
#endif
#if !defined(WIN32) && !defined(MS_WINDOWS)
  #ifndef __stdcall
    #define __stdcall
  #endif
  #ifndef __cdecl
    #define __cdecl
  #endif
#else
  #define _USE_MATH_DEFINES
#endif
#ifdef __cplusplus
#define __PYX_EXTERN_C extern "C"
#else
#define __PYX_EXTERN_C extern
#endif
#include <math.h>
#define __PYX_HAVE_API__fff2__glm__kalman
#include "numpy/arrayobject.h"
#include "fff_vector.h"
#include "fff_matrix.h"
#include "fff_base.h"
#include "fff_array.h"
#include "randomkit.h"
#include "fffpy.h"
#include "fff_glm_kalman.h"


#ifdef __GNUC__
#define INLINE __inline__
#elif _WIN32
#define INLINE __inline
#else
#define INLINE 
#endif

typedef struct {PyObject **p; char *s; long n; char is_unicode; char intern; char is_identifier;} __Pyx_StringTabEntry; /*proto*/



static int __pyx_skip_dispatch = 0;


/* Type Conversion Predeclarations */

#if PY_MAJOR_VERSION < 3
#define __Pyx_PyBytes_FromString PyString_FromString
#define __Pyx_PyBytes_AsString   PyString_AsString
#else
#define __Pyx_PyBytes_FromString PyBytes_FromString
#define __Pyx_PyBytes_AsString   PyBytes_AsString
#endif

#define __Pyx_PyBool_FromLong(b) ((b) ? (Py_INCREF(Py_True), Py_True) : (Py_INCREF(Py_False), Py_False))
static INLINE int __Pyx_PyObject_IsTrue(PyObject* x);
static INLINE PY_LONG_LONG __pyx_PyInt_AsLongLong(PyObject* x);
static INLINE unsigned PY_LONG_LONG __pyx_PyInt_AsUnsignedLongLong(PyObject* x);
static INLINE Py_ssize_t __pyx_PyIndex_AsSsize_t(PyObject* b);

#define __pyx_PyInt_AsLong(x) (PyInt_CheckExact(x) ? PyInt_AS_LONG(x) : PyInt_AsLong(x))
#define __pyx_PyFloat_AsDouble(x) (PyFloat_CheckExact(x) ? PyFloat_AS_DOUBLE(x) : PyFloat_AsDouble(x))

static INLINE unsigned char __pyx_PyInt_unsigned_char(PyObject* x);
static INLINE unsigned short __pyx_PyInt_unsigned_short(PyObject* x);
static INLINE char __pyx_PyInt_char(PyObject* x);
static INLINE short __pyx_PyInt_short(PyObject* x);
static INLINE int __pyx_PyInt_int(PyObject* x);
static INLINE long __pyx_PyInt_long(PyObject* x);
static INLINE signed char __pyx_PyInt_signed_char(PyObject* x);
static INLINE signed short __pyx_PyInt_signed_short(PyObject* x);
static INLINE signed int __pyx_PyInt_signed_int(PyObject* x);
static INLINE signed long __pyx_PyInt_signed_long(PyObject* x);
static INLINE long double __pyx_PyInt_long_double(PyObject* x);
#ifdef __GNUC__
/* Test for GCC > 2.95 */
#if __GNUC__ > 2 ||               (__GNUC__ == 2 && (__GNUC_MINOR__ > 95)) 
#define likely(x)   __builtin_expect(!!(x), 1)
#define unlikely(x) __builtin_expect(!!(x), 0)
#else /* __GNUC__ > 2 ... */
#define likely(x)   (x)
#define unlikely(x) (x)
#endif /* __GNUC__ > 2 ... */
#else /* __GNUC__ */
#define likely(x)   (x)
#define unlikely(x) (x)
#endif /* __GNUC__ */
    
static PyObject *__pyx_m;
static PyObject *__pyx_b;
static PyObject *__pyx_empty_tuple;
static int __pyx_lineno;
static int __pyx_clineno = 0;
static const char * __pyx_cfilenm= __FILE__;
static const char *__pyx_filename;
static const char **__pyx_f;

static char __pyx_mdoc[] = "\nIncremental (Kalman-like) filters for linear regression. \n\nAuthor: Alexis Roche, 2008.\n";

static void __Pyx_RaiseDoubleKeywordsError(
    const char* func_name, PyObject* kw_name); /*proto*/

static void __Pyx_RaiseArgtupleInvalid(const char* func_name, int exact,
    Py_ssize_t num_min, Py_ssize_t num_max, Py_ssize_t num_found); /*proto*/

static int __Pyx_ParseOptionalKeywords(PyObject *kwds, PyObject **argnames[],     PyObject *kwds2, PyObject *values[], Py_ssize_t num_pos_args,     const char* function_name); /*proto*/

static INLINE int __Pyx_SetItemInt(PyObject *o, Py_ssize_t i, PyObject *v, int is_unsigned) {
    int r;
    if (PyList_CheckExact(o) && 0 <= i && i < PyList_GET_SIZE(o)) {
        Py_DECREF(PyList_GET_ITEM(o, i));
        Py_INCREF(v);
        PyList_SET_ITEM(o, i, v);
        return 1;
    }
    else if (Py_TYPE(o)->tp_as_sequence && Py_TYPE(o)->tp_as_sequence->sq_ass_item && (likely(i >= 0) || !is_unsigned))
        r = PySequence_SetItem(o, i, v);
    else {
        PyObject *j = (likely(i >= 0) || !is_unsigned) ? PyInt_FromLong(i) : PyLong_FromUnsignedLongLong((sizeof(unsigned long long) > sizeof(Py_ssize_t) ? (1ULL << (sizeof(Py_ssize_t)*8)) : 0) + i);
        if (!j)
            return -1;
        r = PyObject_SetItem(o, j, v);
        Py_DECREF(j);
    }
    return r;
}

static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed,
    const char *name, int exact); /*proto*/

static PyObject *__Pyx_Import(PyObject *name, PyObject *from_list); /*proto*/

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name); /*proto*/

static PyTypeObject *__Pyx_ImportType(const char *module_name, const char *class_name, long size);  /*proto*/

static PyObject *__Pyx_ImportModule(const char *name); /*proto*/

static void __Pyx_AddTraceback(const char *funcname); /*proto*/

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t); /*proto*/

/* Type declarations */

typedef unsigned long __pyx_t_4fff2_3glm_6kalman_size_t;
/* Module declarations from numpy */

/* Module declarations from fff2.glm.kalman */

static PyTypeObject *__pyx_ptype_4fff2_3glm_6kalman_dtype = 0;
static PyTypeObject *__pyx_ptype_4fff2_3glm_6kalman_ndarray = 0;
static PyTypeObject *__pyx_ptype_4fff2_3glm_6kalman_flatiter = 0;
static PyTypeObject *__pyx_ptype_4fff2_3glm_6kalman_broadcast = 0;


/* Implementation of fff2.glm.kalman */
static char __pyx_k_1[] = "0.1";
static PyObject *__pyx_int_1;
static char __pyx_k_Y[] = "Y";
static PyObject *__pyx_kp_Y;
static char __pyx_k_X[] = "X";
static PyObject *__pyx_kp_X;
static char __pyx_k_axis[] = "axis";
static PyObject *__pyx_kp_axis;
static char __pyx_k_niter[] = "niter";
static PyObject *__pyx_kp_niter;
static char __pyx_k___version__[] = "__version__";
static PyObject *__pyx_kp___version__;
static char __pyx_k_numpy[] = "numpy";
static PyObject *__pyx_kp_numpy;
static char __pyx_k_np[] = "np";
static PyObject *__pyx_kp_np;
static char __pyx_k_shape[] = "shape";
static PyObject *__pyx_kp_shape;
static char __pyx_k_zeros[] = "zeros";
static PyObject *__pyx_kp_zeros;
static char __pyx_k_insert[] = "insert";
static PyObject *__pyx_kp_insert;
static char __pyx_k_reshape[] = "reshape";
static PyObject *__pyx_kp_reshape;
static PyObject *__pyx_kp_1;

/* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":69
 * # Standard Kalman filter
 * 
 * def ols(ndarray Y, ndarray X, int axis=0):             # <<<<<<<<<<<<<<
 *     """
 *     (beta, norm_var_beta, s2, dof) = ols(Y, X, axis=0).
 */

static PyObject *__pyx_pf_4fff2_3glm_6kalman_ols(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4fff2_3glm_6kalman_ols[] = "\n    (beta, norm_var_beta, s2, dof) = ols(Y, X, axis=0).\n\n    Ordinary least-square multiple regression using the Kalman filter.\n    Fit the N-dimensional array Y along the given axis in terms of the\n    regressors in matrix X. The regressors must be stored columnwise.\n\n    OUTPUT: a four-element tuple\n    beta -- array of parameter estimates\n    norm_var_beta -- normalized variance matrix of the parameter\n    estimates (data independent)\n    s2 -- array of squared scale\n    parameters to multiply norm_var_beta for the variance matrix of\n    beta.\n    dof -- scalar degrees of freedom.\n\n    REFERENCE:  Roche et al, ISBI 2004.\n    ";
static PyObject *__pyx_pf_4fff2_3glm_6kalman_ols(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyArrayObject *__pyx_v_Y = 0;
  PyArrayObject *__pyx_v_X = 0;
  int __pyx_v_axis;
  fff_vector *__pyx_v_y;
  fff_vector *__pyx_v_b;
  fff_vector *__pyx_v_s2;
  fff_matrix *__pyx_v_x;
  fff_glm_KF *__pyx_v_kfilt;
  __pyx_t_4fff2_3glm_6kalman_size_t __pyx_v_p;
  fffpy_multi_iterator *__pyx_v_multi;
  double __pyx_v_dof;
  PyObject *__pyx_v_dims;
  PyObject *__pyx_v_B;
  PyObject *__pyx_v_S2;
  PyObject *__pyx_v_VB;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_Y,&__pyx_kp_X,&__pyx_kp_axis,0};
  __pyx_self = __pyx_self;
  __pyx_v_axis = 0;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[3] = {0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_Y);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_X);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("ols", 0, 2, 3, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "ols") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_Y = ((PyArrayObject *)values[0]);
    __pyx_v_X = ((PyArrayObject *)values[1]);
    if (values[2]) {
      __pyx_v_axis = __pyx_PyInt_int(values[2]); if (unlikely((__pyx_v_axis == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
  } else {
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  3:
      __pyx_v_axis = __pyx_PyInt_int(PyTuple_GET_ITEM(__pyx_args, 2)); if (unlikely((__pyx_v_axis == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      case  2:
      __pyx_v_X = ((PyArrayObject *)PyTuple_GET_ITEM(__pyx_args, 1));
      __pyx_v_Y = ((PyArrayObject *)PyTuple_GET_ITEM(__pyx_args, 0));
      break;
      default: goto __pyx_L5_argtuple_error;
    }
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("ols", 0, 2, 3, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("fff2.glm.kalman.ols");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  __pyx_v_dims = Py_None; Py_INCREF(Py_None);
  __pyx_v_B = Py_None; Py_INCREF(Py_None);
  __pyx_v_S2 = Py_None; Py_INCREF(Py_None);
  __pyx_v_VB = Py_None; Py_INCREF(Py_None);
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_Y), __pyx_ptype_4fff2_3glm_6kalman_ndarray, 1, "Y", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_X), __pyx_ptype_4fff2_3glm_6kalman_ndarray, 1, "X", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":96
 * 
 *     # View on design matrix
 *     x = fff_matrix_fromPyArray(X)             # <<<<<<<<<<<<<<
 * 
 *     # Number of regressors
 */
  __pyx_v_x = fff_matrix_fromPyArray(__pyx_v_X);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":99
 * 
 *     # Number of regressors
 *     p = x.size2             # <<<<<<<<<<<<<<
 * 
 *     # Allocate output arrays B and S2
 */
  __pyx_v_p = __pyx_v_x->size2;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":102
 * 
 *     # Allocate output arrays B and S2
 *     dims = list(Y.shape)             # <<<<<<<<<<<<<<
 *     dims[axis] = p
 *     B = np.zeros(dims)
 */
  __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_Y), __pyx_kp_shape); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 102; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 102; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_1);
  __pyx_1 = 0;
  __pyx_1 = PyObject_Call(((PyObject *)((PyObject*)&PyList_Type)), ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 102; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  Py_DECREF(__pyx_v_dims);
  __pyx_v_dims = __pyx_1;
  __pyx_1 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":103
 *     # Allocate output arrays B and S2
 *     dims = list(Y.shape)
 *     dims[axis] = p             # <<<<<<<<<<<<<<
 *     B = np.zeros(dims)
 *     dims[axis] = 1
 */
  __pyx_2 = PyLong_FromUnsignedLong(__pyx_v_p); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 103; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__Pyx_SetItemInt(__pyx_v_dims, __pyx_v_axis, __pyx_2, 0) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 103; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":104
 *     dims = list(Y.shape)
 *     dims[axis] = p
 *     B = np.zeros(dims)             # <<<<<<<<<<<<<<
 *     dims[axis] = 1
 *     S2 = np.zeros(dims)
 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_np); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 104; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_kp_zeros); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 104; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyTuple_New(1); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 104; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_dims);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_dims);
  __pyx_3 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_1), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 104; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(((PyObject *)__pyx_1)); __pyx_1 = 0;
  Py_DECREF(__pyx_v_B);
  __pyx_v_B = __pyx_3;
  __pyx_3 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":105
 *     dims[axis] = p
 *     B = np.zeros(dims)
 *     dims[axis] = 1             # <<<<<<<<<<<<<<
 *     S2 = np.zeros(dims)
 * 
 */
  if (__Pyx_SetItemInt(__pyx_v_dims, __pyx_v_axis, __pyx_int_1, 0) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 105; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":106
 *     B = np.zeros(dims)
 *     dims[axis] = 1
 *     S2 = np.zeros(dims)             # <<<<<<<<<<<<<<
 * 
 *     # Allocate local structure
 */
  __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_kp_np); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 106; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_kp_zeros); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 106; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 106; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_dims);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_dims);
  __pyx_2 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 106; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  Py_DECREF(__pyx_v_S2);
  __pyx_v_S2 = __pyx_2;
  __pyx_2 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":109
 * 
 *     # Allocate local structure
 *     kfilt = fff_glm_KF_new(p)             # <<<<<<<<<<<<<<
 * 
 *     # Create a new array iterator
 */
  __pyx_v_kfilt = fff_glm_KF_new(__pyx_v_p);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":112
 * 
 *     # Create a new array iterator
 *     multi = fffpy_multi_iterator_new(3, axis, <void*>Y, <void*>B, <void*>S2)             # <<<<<<<<<<<<<<
 * 
 *     # Create views
 */
  __pyx_v_multi = fffpy_multi_iterator_new(3, __pyx_v_axis, ((void *)__pyx_v_Y), ((void *)__pyx_v_B), ((void *)__pyx_v_S2));

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":115
 * 
 *     # Create views
 *     y = multi.vector[0]             # <<<<<<<<<<<<<<
 *     b = multi.vector[1]
 *     s2 = multi.vector[2]
 */
  __pyx_v_y = (__pyx_v_multi->vector[0]);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":116
 *     # Create views
 *     y = multi.vector[0]
 *     b = multi.vector[1]             # <<<<<<<<<<<<<<
 *     s2 = multi.vector[2]
 * 
 */
  __pyx_v_b = (__pyx_v_multi->vector[1]);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":117
 *     y = multi.vector[0]
 *     b = multi.vector[1]
 *     s2 = multi.vector[2]             # <<<<<<<<<<<<<<
 * 
 *     # Loop
 */
  __pyx_v_s2 = (__pyx_v_multi->vector[2]);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":120
 * 
 *     # Loop
 *     while(multi.index < multi.size):             # <<<<<<<<<<<<<<
 *         fff_glm_KF_fit(kfilt, y, x)
 *         fff_vector_memcpy(b, kfilt.b)
 */
  while (1) {
    __pyx_4 = (__pyx_v_multi->index < __pyx_v_multi->size);
    if (!__pyx_4) break;

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":121
 *     # Loop
 *     while(multi.index < multi.size):
 *         fff_glm_KF_fit(kfilt, y, x)             # <<<<<<<<<<<<<<
 *         fff_vector_memcpy(b, kfilt.b)
 *         s2.data[0] = kfilt.s2
 */
    fff_glm_KF_fit(__pyx_v_kfilt, __pyx_v_y, __pyx_v_x);

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":122
 *     while(multi.index < multi.size):
 *         fff_glm_KF_fit(kfilt, y, x)
 *         fff_vector_memcpy(b, kfilt.b)             # <<<<<<<<<<<<<<
 *         s2.data[0] = kfilt.s2
 *         fffpy_multi_iterator_update(multi)
 */
    fff_vector_memcpy(__pyx_v_b, __pyx_v_kfilt->b);

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":123
 *         fff_glm_KF_fit(kfilt, y, x)
 *         fff_vector_memcpy(b, kfilt.b)
 *         s2.data[0] = kfilt.s2             # <<<<<<<<<<<<<<
 *         fffpy_multi_iterator_update(multi)
 * 
 */
    (__pyx_v_s2->data[0]) = __pyx_v_kfilt->s2;

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":124
 *         fff_vector_memcpy(b, kfilt.b)
 *         s2.data[0] = kfilt.s2
 *         fffpy_multi_iterator_update(multi)             # <<<<<<<<<<<<<<
 * 
 *     # Normalized variance (computed from the last item)
 */
    fffpy_multi_iterator_update(__pyx_v_multi);
  }

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":127
 * 
 *     # Normalized variance (computed from the last item)
 *     VB = fff_matrix_const_toPyArray(kfilt.Vb);             # <<<<<<<<<<<<<<
 *     dof = kfilt.dof
 * 
 */
  __pyx_1 = ((PyObject *)fff_matrix_const_toPyArray(__pyx_v_kfilt->Vb)); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 127; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_v_VB);
  __pyx_v_VB = __pyx_1;
  __pyx_1 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":128
 *     # Normalized variance (computed from the last item)
 *     VB = fff_matrix_const_toPyArray(kfilt.Vb);
 *     dof = kfilt.dof             # <<<<<<<<<<<<<<
 * 
 *     # Free memory
 */
  __pyx_v_dof = __pyx_v_kfilt->dof;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":131
 * 
 *     # Free memory
 *     fff_matrix_delete(x)             # <<<<<<<<<<<<<<
 *     fff_glm_KF_delete(kfilt)
 *     fffpy_multi_iterator_delete(multi)
 */
  fff_matrix_delete(__pyx_v_x);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":132
 *     # Free memory
 *     fff_matrix_delete(x)
 *     fff_glm_KF_delete(kfilt)             # <<<<<<<<<<<<<<
 *     fffpy_multi_iterator_delete(multi)
 * 
 */
  fff_glm_KF_delete(__pyx_v_kfilt);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":133
 *     fff_matrix_delete(x)
 *     fff_glm_KF_delete(kfilt)
 *     fffpy_multi_iterator_delete(multi)             # <<<<<<<<<<<<<<
 * 
 *     # Return
 */
  fffpy_multi_iterator_delete(__pyx_v_multi);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":136
 * 
 *     # Return
 *     return B, VB, S2, dof             # <<<<<<<<<<<<<<
 * 
 * 
 */
  __pyx_3 = PyFloat_FromDouble(__pyx_v_dof); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 136; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyTuple_New(4); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 136; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_B);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_B);
  Py_INCREF(__pyx_v_VB);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_VB);
  Py_INCREF(__pyx_v_S2);
  PyTuple_SET_ITEM(__pyx_2, 2, __pyx_v_S2);
  PyTuple_SET_ITEM(__pyx_2, 3, __pyx_3);
  __pyx_3 = 0;
  __pyx_r = ((PyObject *)__pyx_2);
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("fff2.glm.kalman.ols");
  __pyx_r = NULL;
  __pyx_L0:;
  Py_DECREF(__pyx_v_dims);
  Py_DECREF(__pyx_v_B);
  Py_DECREF(__pyx_v_S2);
  Py_DECREF(__pyx_v_VB);
  return __pyx_r;
}

/* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":139
 * 
 * 
 * def ar1(ndarray Y, ndarray X, int niter=2, int axis=0):             # <<<<<<<<<<<<<<
 *     """
 *     (beta, norm_var_beta, s2, dof, a) = ar1(Y, X, niter=2, axis=0)
 */

static PyObject *__pyx_pf_4fff2_3glm_6kalman_ar1(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4fff2_3glm_6kalman_ar1[] = "\n    (beta, norm_var_beta, s2, dof, a) = ar1(Y, X, niter=2, axis=0)\n\n    Refined Kalman filter -- enhanced Kalman filter to account for\n    noise autocorrelation using an AR(1) model. Pseudo-likelihood\n    multiple regression using the refined Kalman filter, a Kalman\n    variant based on a AR(1) error model.  Fit the N-dimensional array\n    Y along the given axis in terms of the regressors in matrix X. The\n    regressors must be stored columnwise.\n\n    OUTPUT: a five-element tuple\n    beta -- array of parameter estimates\n    norm_var_beta -- array of normalized variance matrices (which are data dependent\n    unlike in standard OLS regression)\n    s2 -- array of squared scale parameters to multiply norm_var_beta for the variance matrix of beta.\n    dof -- scalar degrees of freedom\n    a -- array of error autocorrelation estimates\n\n    REFERENCE:\n    Roche et al, MICCAI 2004.\n    ";
static PyObject *__pyx_pf_4fff2_3glm_6kalman_ar1(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyArrayObject *__pyx_v_Y = 0;
  PyArrayObject *__pyx_v_X = 0;
  int __pyx_v_niter;
  int __pyx_v_axis;
  fff_vector *__pyx_v_y;
  fff_vector *__pyx_v_b;
  fff_vector *__pyx_v_vb;
  fff_vector *__pyx_v_s2;
  fff_vector *__pyx_v_a;
  fff_vector __pyx_v_Vb_flat;
  fff_matrix *__pyx_v_x;
  fff_glm_RKF *__pyx_v_rkfilt;
  __pyx_t_4fff2_3glm_6kalman_size_t __pyx_v_p;
  __pyx_t_4fff2_3glm_6kalman_size_t __pyx_v_p2;
  fffpy_multi_iterator *__pyx_v_multi;
  double __pyx_v_dof;
  PyObject *__pyx_v_dims;
  PyObject *__pyx_v_B;
  PyObject *__pyx_v_VB;
  PyObject *__pyx_v_S2;
  PyObject *__pyx_v_A;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_Y,&__pyx_kp_X,&__pyx_kp_niter,&__pyx_kp_axis,0};
  __pyx_self = __pyx_self;
  __pyx_v_niter = 2;
  __pyx_v_axis = 0;
  if (unlikely(__pyx_kwds)) {
    PyObject* values[4] = {0,0,0,0};
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  4: values[3] = PyTuple_GET_ITEM(__pyx_args, 3);
      case  3: values[2] = PyTuple_GET_ITEM(__pyx_args, 2);
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_Y);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_X);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("ar1", 0, 2, 4, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "ar1") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_Y = ((PyArrayObject *)values[0]);
    __pyx_v_X = ((PyArrayObject *)values[1]);
    if (values[2]) {
      __pyx_v_niter = __pyx_PyInt_int(values[2]); if (unlikely((__pyx_v_niter == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    if (values[3]) {
      __pyx_v_axis = __pyx_PyInt_int(values[3]); if (unlikely((__pyx_v_axis == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
  } else {
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  4:
      __pyx_v_axis = __pyx_PyInt_int(PyTuple_GET_ITEM(__pyx_args, 3)); if (unlikely((__pyx_v_axis == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      case  3:
      __pyx_v_niter = __pyx_PyInt_int(PyTuple_GET_ITEM(__pyx_args, 2)); if (unlikely((__pyx_v_niter == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      case  2:
      __pyx_v_X = ((PyArrayObject *)PyTuple_GET_ITEM(__pyx_args, 1));
      __pyx_v_Y = ((PyArrayObject *)PyTuple_GET_ITEM(__pyx_args, 0));
      break;
      default: goto __pyx_L5_argtuple_error;
    }
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("ar1", 0, 2, 4, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("fff2.glm.kalman.ar1");
  return NULL;
  __pyx_L4_argument_unpacking_done:;
  __pyx_v_dims = Py_None; Py_INCREF(Py_None);
  __pyx_v_B = Py_None; Py_INCREF(Py_None);
  __pyx_v_VB = Py_None; Py_INCREF(Py_None);
  __pyx_v_S2 = Py_None; Py_INCREF(Py_None);
  __pyx_v_A = Py_None; Py_INCREF(Py_None);
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_Y), __pyx_ptype_4fff2_3glm_6kalman_ndarray, 1, "Y", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (unlikely(!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_X), __pyx_ptype_4fff2_3glm_6kalman_ndarray, 1, "X", 0))) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 139; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":170
 * 
 *     # View on design matrix
 *     x = fff_matrix_fromPyArray(X)             # <<<<<<<<<<<<<<
 * 
 *     # Number of regressors
 */
  __pyx_v_x = fff_matrix_fromPyArray(__pyx_v_X);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":173
 * 
 *     # Number of regressors
 *     p = x.size2             # <<<<<<<<<<<<<<
 *     p2 = p*p
 * 
 */
  __pyx_v_p = __pyx_v_x->size2;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":174
 *     # Number of regressors
 *     p = x.size2
 *     p2 = p*p             # <<<<<<<<<<<<<<
 * 
 *     # Allocate output arrays B and S2
 */
  __pyx_v_p2 = (__pyx_v_p * __pyx_v_p);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":177
 * 
 *     # Allocate output arrays B and S2
 *     dims = list(Y.shape)             # <<<<<<<<<<<<<<
 *     dims[axis] = p
 *     B = np.zeros(dims)
 */
  __pyx_1 = PyObject_GetAttr(((PyObject *)__pyx_v_Y), __pyx_kp_shape); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 177; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 177; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_1);
  __pyx_1 = 0;
  __pyx_1 = PyObject_Call(((PyObject *)((PyObject*)&PyList_Type)), ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 177; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  Py_DECREF(__pyx_v_dims);
  __pyx_v_dims = __pyx_1;
  __pyx_1 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":178
 *     # Allocate output arrays B and S2
 *     dims = list(Y.shape)
 *     dims[axis] = p             # <<<<<<<<<<<<<<
 *     B = np.zeros(dims)
 *     dims[axis] = p2
 */
  __pyx_2 = PyLong_FromUnsignedLong(__pyx_v_p); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 178; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__Pyx_SetItemInt(__pyx_v_dims, __pyx_v_axis, __pyx_2, 0) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 178; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":179
 *     dims = list(Y.shape)
 *     dims[axis] = p
 *     B = np.zeros(dims)             # <<<<<<<<<<<<<<
 *     dims[axis] = p2
 *     VB = np.zeros(dims)
 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_np); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyObject_GetAttr(__pyx_1, __pyx_kp_zeros); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyTuple_New(1); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_dims);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_dims);
  __pyx_3 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_1), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 179; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(((PyObject *)__pyx_1)); __pyx_1 = 0;
  Py_DECREF(__pyx_v_B);
  __pyx_v_B = __pyx_3;
  __pyx_3 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":180
 *     dims[axis] = p
 *     B = np.zeros(dims)
 *     dims[axis] = p2             # <<<<<<<<<<<<<<
 *     VB = np.zeros(dims)
 *     dims[axis] = 1
 */
  __pyx_2 = PyLong_FromUnsignedLong(__pyx_v_p2); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 180; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__Pyx_SetItemInt(__pyx_v_dims, __pyx_v_axis, __pyx_2, 0) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 180; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":181
 *     B = np.zeros(dims)
 *     dims[axis] = p2
 *     VB = np.zeros(dims)             # <<<<<<<<<<<<<<
 *     dims[axis] = 1
 *     S2 = np.zeros(dims)
 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_np); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyObject_GetAttr(__pyx_1, __pyx_kp_zeros); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_2 = PyTuple_New(1); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_dims);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_dims);
  __pyx_1 = PyObject_Call(__pyx_3, ((PyObject *)__pyx_2), NULL); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 181; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(((PyObject *)__pyx_2)); __pyx_2 = 0;
  Py_DECREF(__pyx_v_VB);
  __pyx_v_VB = __pyx_1;
  __pyx_1 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":182
 *     dims[axis] = p2
 *     VB = np.zeros(dims)
 *     dims[axis] = 1             # <<<<<<<<<<<<<<
 *     S2 = np.zeros(dims)
 *     A = np.zeros(dims)
 */
  if (__Pyx_SetItemInt(__pyx_v_dims, __pyx_v_axis, __pyx_int_1, 0) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 182; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":183
 *     VB = np.zeros(dims)
 *     dims[axis] = 1
 *     S2 = np.zeros(dims)             # <<<<<<<<<<<<<<
 *     A = np.zeros(dims)
 * 
 */
  __pyx_3 = __Pyx_GetName(__pyx_m, __pyx_kp_np); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 183; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyObject_GetAttr(__pyx_3, __pyx_kp_zeros); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 183; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_1 = PyTuple_New(1); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 183; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_dims);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_dims);
  __pyx_3 = PyObject_Call(__pyx_2, ((PyObject *)__pyx_1), NULL); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 183; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(((PyObject *)__pyx_1)); __pyx_1 = 0;
  Py_DECREF(__pyx_v_S2);
  __pyx_v_S2 = __pyx_3;
  __pyx_3 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":184
 *     dims[axis] = 1
 *     S2 = np.zeros(dims)
 *     A = np.zeros(dims)             # <<<<<<<<<<<<<<
 * 
 *     # Allocate local structure
 */
  __pyx_2 = __Pyx_GetName(__pyx_m, __pyx_kp_np); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 184; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_kp_zeros); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 184; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 184; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_dims);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_dims);
  __pyx_2 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 184; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  Py_DECREF(__pyx_v_A);
  __pyx_v_A = __pyx_2;
  __pyx_2 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":187
 * 
 *     # Allocate local structure
 *     rkfilt = fff_glm_RKF_new(p)             # <<<<<<<<<<<<<<
 * 
 *     # Create a new array iterator
 */
  __pyx_v_rkfilt = fff_glm_RKF_new(__pyx_v_p);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":190
 * 
 *     # Create a new array iterator
 *     multi = fffpy_multi_iterator_new(5, axis, <void*>Y, <void*>B, <void*>VB, <void*>S2, <void*>A)             # <<<<<<<<<<<<<<
 * 
 *     # Create views
 */
  __pyx_v_multi = fffpy_multi_iterator_new(5, __pyx_v_axis, ((void *)__pyx_v_Y), ((void *)__pyx_v_B), ((void *)__pyx_v_VB), ((void *)__pyx_v_S2), ((void *)__pyx_v_A));

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":193
 * 
 *     # Create views
 *     y = multi.vector[0]             # <<<<<<<<<<<<<<
 *     b = multi.vector[1]
 *     vb = multi.vector[2]
 */
  __pyx_v_y = (__pyx_v_multi->vector[0]);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":194
 *     # Create views
 *     y = multi.vector[0]
 *     b = multi.vector[1]             # <<<<<<<<<<<<<<
 *     vb = multi.vector[2]
 *     s2 = multi.vector[3]
 */
  __pyx_v_b = (__pyx_v_multi->vector[1]);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":195
 *     y = multi.vector[0]
 *     b = multi.vector[1]
 *     vb = multi.vector[2]             # <<<<<<<<<<<<<<
 *     s2 = multi.vector[3]
 *     a = multi.vector[4]
 */
  __pyx_v_vb = (__pyx_v_multi->vector[2]);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":196
 *     b = multi.vector[1]
 *     vb = multi.vector[2]
 *     s2 = multi.vector[3]             # <<<<<<<<<<<<<<
 *     a = multi.vector[4]
 * 
 */
  __pyx_v_s2 = (__pyx_v_multi->vector[3]);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":197
 *     vb = multi.vector[2]
 *     s2 = multi.vector[3]
 *     a = multi.vector[4]             # <<<<<<<<<<<<<<
 * 
 *     # Loop
 */
  __pyx_v_a = (__pyx_v_multi->vector[4]);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":200
 * 
 *     # Loop
 *     while(multi.index < multi.size):             # <<<<<<<<<<<<<<
 *         fff_glm_RKF_fit(rkfilt, niter, y, x)
 *         fff_vector_memcpy(b, rkfilt.b)
 */
  while (1) {
    __pyx_4 = (__pyx_v_multi->index < __pyx_v_multi->size);
    if (!__pyx_4) break;

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":201
 *     # Loop
 *     while(multi.index < multi.size):
 *         fff_glm_RKF_fit(rkfilt, niter, y, x)             # <<<<<<<<<<<<<<
 *         fff_vector_memcpy(b, rkfilt.b)
 *         Vb_flat = fff_vector_view(rkfilt.Vb.data, p2, 1) # rkfilt.Vb contiguous by construction
 */
    fff_glm_RKF_fit(__pyx_v_rkfilt, __pyx_v_niter, __pyx_v_y, __pyx_v_x);

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":202
 *     while(multi.index < multi.size):
 *         fff_glm_RKF_fit(rkfilt, niter, y, x)
 *         fff_vector_memcpy(b, rkfilt.b)             # <<<<<<<<<<<<<<
 *         Vb_flat = fff_vector_view(rkfilt.Vb.data, p2, 1) # rkfilt.Vb contiguous by construction
 *         fff_vector_memcpy(vb, &Vb_flat)
 */
    fff_vector_memcpy(__pyx_v_b, __pyx_v_rkfilt->b);

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":203
 *         fff_glm_RKF_fit(rkfilt, niter, y, x)
 *         fff_vector_memcpy(b, rkfilt.b)
 *         Vb_flat = fff_vector_view(rkfilt.Vb.data, p2, 1) # rkfilt.Vb contiguous by construction             # <<<<<<<<<<<<<<
 *         fff_vector_memcpy(vb, &Vb_flat)
 *         s2.data[0] = rkfilt.s2
 */
    __pyx_v_Vb_flat = fff_vector_view(__pyx_v_rkfilt->Vb->data, __pyx_v_p2, 1);

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":204
 *         fff_vector_memcpy(b, rkfilt.b)
 *         Vb_flat = fff_vector_view(rkfilt.Vb.data, p2, 1) # rkfilt.Vb contiguous by construction
 *         fff_vector_memcpy(vb, &Vb_flat)             # <<<<<<<<<<<<<<
 *         s2.data[0] = rkfilt.s2
 *         a.data[0] = rkfilt.a
 */
    fff_vector_memcpy(__pyx_v_vb, (&__pyx_v_Vb_flat));

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":205
 *         Vb_flat = fff_vector_view(rkfilt.Vb.data, p2, 1) # rkfilt.Vb contiguous by construction
 *         fff_vector_memcpy(vb, &Vb_flat)
 *         s2.data[0] = rkfilt.s2             # <<<<<<<<<<<<<<
 *         a.data[0] = rkfilt.a
 *         fffpy_multi_iterator_update(multi)
 */
    (__pyx_v_s2->data[0]) = __pyx_v_rkfilt->s2;

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":206
 *         fff_vector_memcpy(vb, &Vb_flat)
 *         s2.data[0] = rkfilt.s2
 *         a.data[0] = rkfilt.a             # <<<<<<<<<<<<<<
 *         fffpy_multi_iterator_update(multi)
 * 
 */
    (__pyx_v_a->data[0]) = __pyx_v_rkfilt->a;

    /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":207
 *         s2.data[0] = rkfilt.s2
 *         a.data[0] = rkfilt.a
 *         fffpy_multi_iterator_update(multi)             # <<<<<<<<<<<<<<
 * 
 *     # Dof
 */
    fffpy_multi_iterator_update(__pyx_v_multi);
  }

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":210
 * 
 *     # Dof
 *     dof = rkfilt.dof             # <<<<<<<<<<<<<<
 * 
 *     # Free memory
 */
  __pyx_v_dof = __pyx_v_rkfilt->dof;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":213
 * 
 *     # Free memory
 *     fff_matrix_delete(x)             # <<<<<<<<<<<<<<
 *     fff_glm_RKF_delete(rkfilt)
 *     fffpy_multi_iterator_delete(multi)
 */
  fff_matrix_delete(__pyx_v_x);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":214
 *     # Free memory
 *     fff_matrix_delete(x)
 *     fff_glm_RKF_delete(rkfilt)             # <<<<<<<<<<<<<<
 *     fffpy_multi_iterator_delete(multi)
 * 
 */
  fff_glm_RKF_delete(__pyx_v_rkfilt);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":215
 *     fff_matrix_delete(x)
 *     fff_glm_RKF_delete(rkfilt)
 *     fffpy_multi_iterator_delete(multi)             # <<<<<<<<<<<<<<
 * 
 *     # Reshape variance array
 */
  fffpy_multi_iterator_delete(__pyx_v_multi);

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":218
 * 
 *     # Reshape variance array
 *     dims[axis] = p             # <<<<<<<<<<<<<<
 *     dims.insert(axis+1, p)
 *     VB = VB.reshape(dims)
 */
  __pyx_1 = PyLong_FromUnsignedLong(__pyx_v_p); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 218; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (__Pyx_SetItemInt(__pyx_v_dims, __pyx_v_axis, __pyx_1, 0) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 218; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":219
 *     # Reshape variance array
 *     dims[axis] = p
 *     dims.insert(axis+1, p)             # <<<<<<<<<<<<<<
 *     VB = VB.reshape(dims)
 * 
 */
  __pyx_3 = PyObject_GetAttr(__pyx_v_dims, __pyx_kp_insert); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 219; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_2 = PyInt_FromLong((__pyx_v_axis + 1)); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 219; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyLong_FromUnsignedLong(__pyx_v_p); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 219; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_5 = PyTuple_New(2); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 219; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  PyTuple_SET_ITEM(__pyx_5, 0, __pyx_2);
  PyTuple_SET_ITEM(__pyx_5, 1, __pyx_1);
  __pyx_2 = 0;
  __pyx_1 = 0;
  __pyx_2 = PyObject_Call(__pyx_3, ((PyObject *)__pyx_5), NULL); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 219; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(((PyObject *)__pyx_5)); __pyx_5 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":220
 *     dims[axis] = p
 *     dims.insert(axis+1, p)
 *     VB = VB.reshape(dims)             # <<<<<<<<<<<<<<
 * 
 *     # Return
 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_VB, __pyx_kp_reshape); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 220; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_3 = PyTuple_New(1); if (unlikely(!__pyx_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 220; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_dims);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_dims);
  __pyx_5 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_3), NULL); if (unlikely(!__pyx_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 220; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(((PyObject *)__pyx_3)); __pyx_3 = 0;
  Py_DECREF(__pyx_v_VB);
  __pyx_v_VB = __pyx_5;
  __pyx_5 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":223
 * 
 *     # Return
 *     return B, VB, S2, dof, A             # <<<<<<<<<<<<<<
 * 
 * 
 */
  __pyx_2 = PyFloat_FromDouble(__pyx_v_dof); if (unlikely(!__pyx_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 223; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_1 = PyTuple_New(5); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 223; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_INCREF(__pyx_v_B);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_B);
  Py_INCREF(__pyx_v_VB);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_VB);
  Py_INCREF(__pyx_v_S2);
  PyTuple_SET_ITEM(__pyx_1, 2, __pyx_v_S2);
  PyTuple_SET_ITEM(__pyx_1, 3, __pyx_2);
  Py_INCREF(__pyx_v_A);
  PyTuple_SET_ITEM(__pyx_1, 4, __pyx_v_A);
  __pyx_2 = 0;
  __pyx_r = ((PyObject *)__pyx_1);
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("fff2.glm.kalman.ar1");
  __pyx_r = NULL;
  __pyx_L0:;
  Py_DECREF(__pyx_v_dims);
  Py_DECREF(__pyx_v_B);
  Py_DECREF(__pyx_v_VB);
  Py_DECREF(__pyx_v_S2);
  Py_DECREF(__pyx_v_A);
  return __pyx_r;
}

static struct PyMethodDef __pyx_methods[] = {
  {"ols", (PyCFunction)__pyx_pf_4fff2_3glm_6kalman_ols, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4fff2_3glm_6kalman_ols},
  {"ar1", (PyCFunction)__pyx_pf_4fff2_3glm_6kalman_ar1, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4fff2_3glm_6kalman_ar1},
  {0, 0, 0, 0}
};

static void __pyx_init_filenames(void); /*proto*/

#if PY_MAJOR_VERSION >= 3
static struct PyModuleDef __pyx_moduledef = {
    PyModuleDef_HEAD_INIT,
    "kalman",
    __pyx_mdoc, /* m_doc */
    -1, /* m_size */
    __pyx_methods /* m_methods */,
    NULL, /* m_reload */
    NULL, /* m_traverse */
    NULL, /* m_clear */
    NULL /* m_free */
};
#endif

static __Pyx_StringTabEntry __pyx_string_tab[] = {
  {&__pyx_kp_Y, __pyx_k_Y, sizeof(__pyx_k_Y), 1, 1, 1},
  {&__pyx_kp_X, __pyx_k_X, sizeof(__pyx_k_X), 1, 1, 1},
  {&__pyx_kp_axis, __pyx_k_axis, sizeof(__pyx_k_axis), 1, 1, 1},
  {&__pyx_kp_niter, __pyx_k_niter, sizeof(__pyx_k_niter), 1, 1, 1},
  {&__pyx_kp___version__, __pyx_k___version__, sizeof(__pyx_k___version__), 1, 1, 1},
  {&__pyx_kp_numpy, __pyx_k_numpy, sizeof(__pyx_k_numpy), 1, 1, 1},
  {&__pyx_kp_np, __pyx_k_np, sizeof(__pyx_k_np), 0, 1, 1},
  {&__pyx_kp_shape, __pyx_k_shape, sizeof(__pyx_k_shape), 1, 1, 1},
  {&__pyx_kp_zeros, __pyx_k_zeros, sizeof(__pyx_k_zeros), 1, 1, 1},
  {&__pyx_kp_insert, __pyx_k_insert, sizeof(__pyx_k_insert), 1, 1, 1},
  {&__pyx_kp_reshape, __pyx_k_reshape, sizeof(__pyx_k_reshape), 1, 1, 1},
  {&__pyx_kp_1, __pyx_k_1, sizeof(__pyx_k_1), 0, 0, 0},
  {0, 0, 0, 0, 0, 0}
};
static int __Pyx_InitCachedBuiltins(void) {
  return 0;
  return -1;
}

static int __Pyx_InitGlobals(void) {
  __pyx_int_1 = PyInt_FromLong(1); if (unlikely(!__pyx_int_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  if (__Pyx_InitStrings(__pyx_string_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  return 0;
  __pyx_L1_error:;
  return -1;
}

#if PY_MAJOR_VERSION < 3
PyMODINIT_FUNC initkalman(void); /*proto*/
PyMODINIT_FUNC initkalman(void)
#else
PyMODINIT_FUNC PyInit_kalman(void); /*proto*/
PyMODINIT_FUNC PyInit_kalman(void)
#endif
{
  PyObject *__pyx_1 = 0;
  __pyx_empty_tuple = PyTuple_New(0); if (unlikely(!__pyx_empty_tuple)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  /*--- Library function declarations ---*/
  __pyx_init_filenames();
  /*--- Initialize various global constants etc. ---*/
  if (unlikely(__Pyx_InitGlobals() < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  /*--- Module creation code ---*/
  #if PY_MAJOR_VERSION < 3
  __pyx_m = Py_InitModule4("kalman", __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  #else
  __pyx_m = PyModule_Create(&__pyx_moduledef);
  #endif
  if (!__pyx_m) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  #if PY_MAJOR_VERSION < 3
  Py_INCREF(__pyx_m);
  #endif
  __pyx_b = PyImport_AddModule(__Pyx_BUILTIN_MODULE_NAME);
  if (!__pyx_b) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  if (PyObject_SetAttrString(__pyx_m, "__builtins__", __pyx_b) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  /*--- Builtin init code ---*/
  if (unlikely(__Pyx_InitCachedBuiltins() < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_skip_dispatch = 0;
  /*--- Global init code ---*/
  /*--- Function export code ---*/
  /*--- Type init code ---*/
  __pyx_ptype_4fff2_3glm_6kalman_dtype = __Pyx_ImportType("numpy", "dtype", sizeof(PyArray_Descr)); if (unlikely(!__pyx_ptype_4fff2_3glm_6kalman_dtype)) {__pyx_filename = __pyx_f[1]; __pyx_lineno = 74; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_ptype_4fff2_3glm_6kalman_ndarray = __Pyx_ImportType("numpy", "ndarray", sizeof(PyArrayObject)); if (unlikely(!__pyx_ptype_4fff2_3glm_6kalman_ndarray)) {__pyx_filename = __pyx_f[1]; __pyx_lineno = 79; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_ptype_4fff2_3glm_6kalman_flatiter = __Pyx_ImportType("numpy", "flatiter", sizeof(PyArrayIterObject)); if (unlikely(!__pyx_ptype_4fff2_3glm_6kalman_flatiter)) {__pyx_filename = __pyx_f[1]; __pyx_lineno = 88; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_ptype_4fff2_3glm_6kalman_broadcast = __Pyx_ImportType("numpy", "broadcast", sizeof(PyArrayMultiIterObject)); if (unlikely(!__pyx_ptype_4fff2_3glm_6kalman_broadcast)) {__pyx_filename = __pyx_f[1]; __pyx_lineno = 94; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  /*--- Type import code ---*/
  /*--- Function import code ---*/
  /*--- Execution code ---*/

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":10
 * """
 * 
 * __version__ = '0.1'             # <<<<<<<<<<<<<<
 * 
 * 
 */
  if (PyObject_SetAttr(__pyx_m, __pyx_kp___version__, __pyx_kp_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 10; __pyx_clineno = __LINE__; goto __pyx_L1_error;}

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":63
 * 
 * # Initialize numpy
 * fffpy_import_array()             # <<<<<<<<<<<<<<
 * import_array()
 * import numpy as np
 */
  fffpy_import_array();

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":64
 * # Initialize numpy
 * fffpy_import_array()
 * import_array()             # <<<<<<<<<<<<<<
 * import numpy as np
 * 
 */
  import_array();

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":65
 * fffpy_import_array()
 * import_array()
 * import numpy as np             # <<<<<<<<<<<<<<
 * 
 * # Standard Kalman filter
 */
  __pyx_1 = __Pyx_Import(__pyx_kp_numpy, 0); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 65; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  if (PyObject_SetAttr(__pyx_m, __pyx_kp_np, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 65; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "d:\home\ar203069\bzr\nipy\fff2\fff2\glm\kalman.pyx":139
 * 
 * 
 * def ar1(ndarray Y, ndarray X, int niter=2, int axis=0):             # <<<<<<<<<<<<<<
 *     """
 *     (beta, norm_var_beta, s2, dof, a) = ar1(Y, X, niter=2, axis=0)
 */
  #if PY_MAJOR_VERSION < 3
  return;
  #else
  return __pyx_m;
  #endif
  __pyx_L1_error:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("fff2.glm.kalman");
  #if PY_MAJOR_VERSION >= 3
  return NULL;
  #endif
}

static const char *__pyx_filenames[] = {
  "kalman.pyx",
  "numpy.pxi",
};

/* Runtime support code */

static void __pyx_init_filenames(void) {
  __pyx_f = __pyx_filenames;
}

static void __Pyx_RaiseDoubleKeywordsError(
    const char* func_name,
    PyObject* kw_name)
{
    PyErr_Format(PyExc_TypeError,
        #if PY_MAJOR_VERSION >= 3
        "%s() got multiple values for keyword argument '%U'", func_name, kw_name);
        #else
        "%s() got multiple values for keyword argument '%s'", func_name,
        PyString_AS_STRING(kw_name));
        #endif
}

static void __Pyx_RaiseArgtupleInvalid(
    const char* func_name,
    int exact,
    Py_ssize_t num_min,
    Py_ssize_t num_max,
    Py_ssize_t num_found)
{
    Py_ssize_t num_expected;
    const char *number, *more_or_less;

    if (num_found < num_min) {
        num_expected = num_min;
        more_or_less = "at least";
    } else {
        num_expected = num_max;
        more_or_less = "at most";
    }
    if (exact) {
        more_or_less = "exactly";
    }
    number = (num_expected == 1) ? "" : "s";
    PyErr_Format(PyExc_TypeError,
        #if PY_VERSION_HEX < 0x02050000
            "%s() takes %s %d positional argument%s (%d given)",
        #else
            "%s() takes %s %zd positional argument%s (%zd given)",
        #endif
        func_name, more_or_less, num_expected, number, num_found);
}

static int __Pyx_ParseOptionalKeywords(
    PyObject *kwds,
    PyObject **argnames[],
    PyObject *kwds2,
    PyObject *values[],
    Py_ssize_t num_pos_args,
    const char* function_name)
{
    PyObject *key = 0, *value = 0;
    Py_ssize_t pos = 0;
    PyObject*** name;
    PyObject*** first_kw_arg = argnames + num_pos_args;

    while (PyDict_Next(kwds, &pos, &key, &value)) {
        #if PY_MAJOR_VERSION < 3
        if (unlikely(!PyString_CheckExact(key)) && unlikely(!PyString_Check(key))) {
        #else
        if (unlikely(!PyUnicode_CheckExact(key)) && unlikely(!PyUnicode_Check(key))) {
        #endif
            goto invalid_keyword_type;
        } else {
            name = argnames;
            while (*name && (**name != key)) name++;
            if (*name) {
                if (name < first_kw_arg) goto arg_passed_twice;
                values[name-argnames] = value;
            } else {
                for (name = first_kw_arg; *name; name++) {
                    #if PY_MAJOR_VERSION >= 3
                    if (PyUnicode_GET_SIZE(**name) == PyUnicode_GET_SIZE(key) &&
                        PyUnicode_Compare(**name, key) == 0) break;
                    #else
                    if (PyString_GET_SIZE(**name) == PyString_GET_SIZE(key) &&
                        strcmp(PyString_AS_STRING(**name),
                               PyString_AS_STRING(key)) == 0) break;
                    #endif
                }
                if (*name) {
                    values[name-argnames] = value;
                } else {
                    /* unexpected keyword found */
                    for (name=argnames; name != first_kw_arg; name++) {
                        if (**name == key) goto arg_passed_twice;
                        #if PY_MAJOR_VERSION >= 3
                        if (PyUnicode_GET_SIZE(**name) == PyUnicode_GET_SIZE(key) &&
                            PyUnicode_Compare(**name, key) == 0) goto arg_passed_twice;
                        #else
                        if (PyString_GET_SIZE(**name) == PyString_GET_SIZE(key) &&
                            strcmp(PyString_AS_STRING(**name),
                                   PyString_AS_STRING(key)) == 0) goto arg_passed_twice;
                        #endif
                    }
                    if (kwds2) {
                        if (unlikely(PyDict_SetItem(kwds2, key, value))) goto bad;
                    } else {
                        goto invalid_keyword;
                    }
                }
            }
        }
    }
    return 0;
arg_passed_twice:
    __Pyx_RaiseDoubleKeywordsError(function_name, **name);
    goto bad;
invalid_keyword_type:
    PyErr_Format(PyExc_TypeError,
        "%s() keywords must be strings", function_name);
    goto bad;
invalid_keyword:
    PyErr_Format(PyExc_TypeError,
    #if PY_MAJOR_VERSION < 3
        "%s() got an unexpected keyword argument '%s'",
        function_name, PyString_AsString(key));
    #else
        "%s() got an unexpected keyword argument '%U'",
        function_name, key);
    #endif
bad:
    return -1;
}


static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed,
    const char *name, int exact)
{
    if (!type) {
        PyErr_Format(PyExc_SystemError, "Missing type object");
        return 0;
    }
    if (none_allowed && obj == Py_None) return 1;
    else if (exact) {
        if (Py_TYPE(obj) == type) return 1;
    }
    else {
        if (PyObject_TypeCheck(obj, type)) return 1;
    }
    PyErr_Format(PyExc_TypeError,
        "Argument '%s' has incorrect type (expected %s, got %s)",
        name, type->tp_name, Py_TYPE(obj)->tp_name);
    return 0;
}

static PyObject *__Pyx_Import(PyObject *name, PyObject *from_list) {
    PyObject *__import__ = 0;
    PyObject *empty_list = 0;
    PyObject *module = 0;
    PyObject *global_dict = 0;
    PyObject *empty_dict = 0;
    PyObject *list;
    __import__ = PyObject_GetAttrString(__pyx_b, "__import__");
    if (!__import__)
        goto bad;
    if (from_list)
        list = from_list;
    else {
        empty_list = PyList_New(0);
        if (!empty_list)
            goto bad;
        list = empty_list;
    }
    global_dict = PyModule_GetDict(__pyx_m);
    if (!global_dict)
        goto bad;
    empty_dict = PyDict_New();
    if (!empty_dict)
        goto bad;
    module = PyObject_CallFunction(__import__, "OOOO",
        name, global_dict, empty_dict, list);
bad:
    Py_XDECREF(empty_list);
    Py_XDECREF(__import__);
    Py_XDECREF(empty_dict);
    return module;
}

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name) {
    PyObject *result;
    result = PyObject_GetAttr(dict, name);
    if (!result)
        PyErr_SetObject(PyExc_NameError, name);
    return result;
}

#ifndef __PYX_HAVE_RT_ImportType
#define __PYX_HAVE_RT_ImportType
static PyTypeObject *__Pyx_ImportType(const char *module_name, const char *class_name,
    long size)
{
    PyObject *py_module = 0;
    PyObject *result = 0;
    PyObject *py_name = 0;

    py_module = __Pyx_ImportModule(module_name);
    if (!py_module)
        goto bad;
    #if PY_MAJOR_VERSION < 3
    py_name = PyString_FromString(class_name);
    #else
    py_name = PyUnicode_FromString(class_name);
    #endif
    if (!py_name)
        goto bad;
    result = PyObject_GetAttr(py_module, py_name);
    Py_DECREF(py_name);
    py_name = 0;
    Py_DECREF(py_module);
    py_module = 0;
    if (!result)
        goto bad;
    if (!PyType_Check(result)) {
        PyErr_Format(PyExc_TypeError, 
            "%s.%s is not a type object",
            module_name, class_name);
        goto bad;
    }
    if (((PyTypeObject *)result)->tp_basicsize != size) {
        PyErr_Format(PyExc_ValueError, 
            "%s.%s does not appear to be the correct type object",
            module_name, class_name);
        goto bad;
    }
    return (PyTypeObject *)result;
bad:
    Py_XDECREF(py_module);
    Py_XDECREF(result);
    return 0;
}
#endif

#ifndef __PYX_HAVE_RT_ImportModule
#define __PYX_HAVE_RT_ImportModule
static PyObject *__Pyx_ImportModule(const char *name) {
    PyObject *py_name = 0;
    PyObject *py_module = 0;

    #if PY_MAJOR_VERSION < 3
    py_name = PyString_FromString(name);
    #else
    py_name = PyUnicode_FromString(name);
    #endif
    if (!py_name)
        goto bad;
    py_module = PyImport_Import(py_name);
    Py_DECREF(py_name);
    return py_module;
bad:
    Py_XDECREF(py_name);
    return 0;
}
#endif

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(const char *funcname) {
    PyObject *py_srcfile = 0;
    PyObject *py_funcname = 0;
    PyObject *py_globals = 0;
    PyObject *empty_string = 0;
    PyCodeObject *py_code = 0;
    PyFrameObject *py_frame = 0;

    #if PY_MAJOR_VERSION < 3
    py_srcfile = PyString_FromString(__pyx_filename);
    #else
    py_srcfile = PyUnicode_FromString(__pyx_filename);
    #endif
    if (!py_srcfile) goto bad;
    if (__pyx_clineno) {
        #if PY_MAJOR_VERSION < 3
        py_funcname = PyString_FromFormat( "%s (%s:%d)", funcname, __pyx_cfilenm, __pyx_clineno);
        #else
        py_funcname = PyUnicode_FromFormat( "%s (%s:%d)", funcname, __pyx_cfilenm, __pyx_clineno);
        #endif
    }
    else {
        #if PY_MAJOR_VERSION < 3
        py_funcname = PyString_FromString(funcname);
        #else
        py_funcname = PyUnicode_FromString(funcname);
        #endif
    }
    if (!py_funcname) goto bad;
    py_globals = PyModule_GetDict(__pyx_m);
    if (!py_globals) goto bad;
    #if PY_MAJOR_VERSION < 3
    empty_string = PyString_FromStringAndSize("", 0);
    #else
    empty_string = PyBytes_FromStringAndSize("", 0);
    #endif
    if (!empty_string) goto bad;
    py_code = PyCode_New(
        0,            /*int argcount,*/
        #if PY_MAJOR_VERSION >= 3
        0,            /*int kwonlyargcount,*/
        #endif
        0,            /*int nlocals,*/
        0,            /*int stacksize,*/
        0,            /*int flags,*/
        empty_string, /*PyObject *code,*/
        __pyx_empty_tuple,  /*PyObject *consts,*/
        __pyx_empty_tuple,  /*PyObject *names,*/
        __pyx_empty_tuple,  /*PyObject *varnames,*/
        __pyx_empty_tuple,  /*PyObject *freevars,*/
        __pyx_empty_tuple,  /*PyObject *cellvars,*/
        py_srcfile,   /*PyObject *filename,*/
        py_funcname,  /*PyObject *name,*/
        __pyx_lineno,   /*int firstlineno,*/
        empty_string  /*PyObject *lnotab*/
    );
    if (!py_code) goto bad;
    py_frame = PyFrame_New(
        PyThreadState_GET(), /*PyThreadState *tstate,*/
        py_code,             /*PyCodeObject *code,*/
        py_globals,          /*PyObject *globals,*/
        0                    /*PyObject *locals*/
    );
    if (!py_frame) goto bad;
    py_frame->f_lineno = __pyx_lineno;
    PyTraceBack_Here(py_frame);
bad:
    Py_XDECREF(py_srcfile);
    Py_XDECREF(py_funcname);
    Py_XDECREF(empty_string);
    Py_XDECREF(py_code);
    Py_XDECREF(py_frame);
}

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t) {
    while (t->p) {
        #if PY_MAJOR_VERSION < 3
        if (t->is_unicode && (!t->is_identifier)) {
            *t->p = PyUnicode_DecodeUTF8(t->s, t->n - 1, NULL);
        } else if (t->intern) {
            *t->p = PyString_InternFromString(t->s);
        } else {
            *t->p = PyString_FromStringAndSize(t->s, t->n - 1);
        }
        #else  /* Python 3+ has unicode identifiers */
        if (t->is_identifier || (t->is_unicode && t->intern)) {
            *t->p = PyUnicode_InternFromString(t->s);
        } else if (t->is_unicode) {
            *t->p = PyUnicode_FromStringAndSize(t->s, t->n - 1);
        } else {
            *t->p = PyBytes_FromStringAndSize(t->s, t->n - 1);
        }
        #endif
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

/* Type Conversion Functions */

static INLINE Py_ssize_t __pyx_PyIndex_AsSsize_t(PyObject* b) {
  Py_ssize_t ival;
  PyObject* x = PyNumber_Index(b);
  if (!x) return -1;
  ival = PyInt_AsSsize_t(x);
  Py_DECREF(x);
  return ival;
}

static INLINE int __Pyx_PyObject_IsTrue(PyObject* x) {
   if (x == Py_True) return 1;
   else if (x == Py_False) return 0;
   else return PyObject_IsTrue(x);
}

static INLINE PY_LONG_LONG __pyx_PyInt_AsLongLong(PyObject* x) {
    if (PyInt_CheckExact(x)) {
        return PyInt_AS_LONG(x);
    }
    else if (PyLong_CheckExact(x)) {
        return PyLong_AsLongLong(x);
    }
    else {
        PY_LONG_LONG val;
        PyObject* tmp = PyNumber_Int(x); if (!tmp) return (PY_LONG_LONG)-1;
        val = __pyx_PyInt_AsLongLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}

static INLINE unsigned PY_LONG_LONG __pyx_PyInt_AsUnsignedLongLong(PyObject* x) {
    if (PyInt_CheckExact(x)) {
        long val = PyInt_AS_LONG(x);
        if (unlikely(val < 0)) {
            PyErr_SetString(PyExc_TypeError, "Negative assignment to unsigned type.");
            return (unsigned PY_LONG_LONG)-1;
        }
        return val;
    }
    else if (PyLong_CheckExact(x)) {
        return PyLong_AsUnsignedLongLong(x);
    }
    else {
        PY_LONG_LONG val;
        PyObject* tmp = PyNumber_Int(x); if (!tmp) return (PY_LONG_LONG)-1;
        val = __pyx_PyInt_AsUnsignedLongLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}


static INLINE unsigned char __pyx_PyInt_unsigned_char(PyObject* x) {
    if (sizeof(unsigned char) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        unsigned char val = (unsigned char)long_val;
        if (unlikely((val != long_val)  || (long_val < 0))) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to unsigned char");
            return (unsigned char)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE unsigned short __pyx_PyInt_unsigned_short(PyObject* x) {
    if (sizeof(unsigned short) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        unsigned short val = (unsigned short)long_val;
        if (unlikely((val != long_val)  || (long_val < 0))) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to unsigned short");
            return (unsigned short)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE char __pyx_PyInt_char(PyObject* x) {
    if (sizeof(char) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        char val = (char)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to char");
            return (char)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE short __pyx_PyInt_short(PyObject* x) {
    if (sizeof(short) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        short val = (short)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to short");
            return (short)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE int __pyx_PyInt_int(PyObject* x) {
    if (sizeof(int) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        int val = (int)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to int");
            return (int)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE long __pyx_PyInt_long(PyObject* x) {
    if (sizeof(long) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        long val = (long)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to long");
            return (long)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE signed char __pyx_PyInt_signed_char(PyObject* x) {
    if (sizeof(signed char) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        signed char val = (signed char)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to signed char");
            return (signed char)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE signed short __pyx_PyInt_signed_short(PyObject* x) {
    if (sizeof(signed short) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        signed short val = (signed short)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to signed short");
            return (signed short)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE signed int __pyx_PyInt_signed_int(PyObject* x) {
    if (sizeof(signed int) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        signed int val = (signed int)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to signed int");
            return (signed int)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE signed long __pyx_PyInt_signed_long(PyObject* x) {
    if (sizeof(signed long) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        signed long val = (signed long)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to signed long");
            return (signed long)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

static INLINE long double __pyx_PyInt_long_double(PyObject* x) {
    if (sizeof(long double) < sizeof(long)) {
        long long_val = __pyx_PyInt_AsLong(x);
        long double val = (long double)long_val;
        if (unlikely((val != long_val) )) {
            PyErr_SetString(PyExc_OverflowError, "value too large to convert to long double");
            return (long double)-1;
        }
        return val;
    }
    else {
        return __pyx_PyInt_AsLong(x);
    }
}

