/* main processing window
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#include "ip.h"

/* 
#define DEBUG
 */

static iDialogClass *parent_class = NULL;

static void
prefs_destroy( GtkObject *object )
{
	Prefs *prefs;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_PREFS( object ) );

	prefs = PREFS( object );

#ifdef DEBUG
	printf( "prefs_destroy\n" );
#endif /*DEBUG*/

	/* My instance destroy stuff.
	 */
	FREESID( prefs->destroy_sid, prefs->ws );
	IM_FREEF( g_source_remove, prefs->auto_layout_timeout );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static gboolean
prefs_auto_layout_timeout_cb( Prefs *prefs )
{
	prefs->auto_layout_timeout = 0;

	model_layout( MODEL( prefs->ws ) );

	return( FALSE );
}

static void
prefs_show( GtkWidget *widget )
{
	Prefs *prefs = PREFS( widget );

	GTK_WIDGET_CLASS( parent_class )->show( widget );

	if( !prefs->done_auto_layout ) {
		prefs->done_auto_layout = TRUE;

		/* Yuk. We autolayout some time after the window is shown,
		 * very unreliable. Unfortunately we can't layout until all of
		 * the widget have their final size, and that's done in an
		 * idle loop with no clear "size allocation now finished" 
		 * event to link to

			FIXME ... there must be a better way to do this. Maybe
			schedule a layout 200ms after every size_allocate on a
			columnview?

		 */
		prefs->auto_layout_timeout = g_timeout_add( 2000, 
			(GSourceFunc) prefs_auto_layout_timeout_cb, prefs );
	}
}

static void
prefs_popdown( iWindow *iwnd, void *client, iWindowNotifyFn nfn, void *sys ) 
{ 
	Prefs *prefs = PREFS( iwnd );
	Filemodel *filemodel = FILEMODEL( prefs->ws );

	/* Force a recalc, in case we've changed the autorecalc settings. Also
	 * does a scan on any widgets.
	 */
	symbol_recalculate_all_force();

	if( filemodel ) {
		if( filemodel->modified &&
			!filemodel_save_all( filemodel, filemodel->filename ) ) 
			nfn( sys, IWINDOW_ERROR );
		else 
			filemodel_set_modified( filemodel, FALSE );
	}

	nfn( sys, IWINDOW_TRUE );
}

void 
prefs_revert_ok_cb( iWindow *iwnd, void *client, 
	iWindowNotifyFn nfn, void *sys ) 
{
	Prefs *prefs = PREFS( client );
	Filemodel *filemodel = FILEMODEL( prefs->ws );
	
	if( filemodel->filename ) {
		(void) unlinkf( "%s", filemodel->filename );
		main_reload();
		symbol_recalculate_all();
	}

	nfn( sys, IWINDOW_TRUE );
}

void 
prefs_revert_cb( iWindow *iwnd, void *client, iWindowNotifyFn nfn, void *sys ) 
{
	Prefs *prefs = PREFS( iwnd );

	box_yesno( GTK_WIDGET( iwnd ),
		prefs_revert_ok_cb, iwindow_true_cb, prefs,
		nfn, sys,
		_( "Revert to Defaults" ), 
		_( "Revert to installation defaults?" ),
		_( "Would you like to reset all preferences to their factory "
		"settings? This will delete any changes you have ever made "
		"to your preferences and may take a few seconds." ) );
}

static void
prefs_build( GtkWidget *widget )
{
	Prefs *prefs = PREFS( widget );
	GtkWidget *work;

#ifdef DEBUG
	printf( "prefs_build: 0x%x\n", (unsigned int) prefs );
#endif /*DEBUG*/

	iwindow_set_title( IWINDOW( prefs ), _( "Preferences" ) );
	idialog_set_callbacks( IDIALOG( prefs ), 
		NULL, prefs_popdown, NULL, prefs );
	idialog_add_ok( IDIALOG( prefs ), 
		prefs_revert_cb, _( "Revert to Defaults" ) );
	idialog_add_ok( IDIALOG( prefs ), iwindow_true_cb, GTK_STOCK_CLOSE );

	/* Call all builds in superclasses.
	 */
	IWINDOW_CLASS( parent_class )->build( widget );

	work = IDIALOG( prefs )->work;

	prefs->wsview = WORKSPACEVIEW( model_view_new( MODEL( prefs->ws ) ) );
	view_link( VIEW( prefs->wsview ), MODEL( prefs->ws ), NULL );
	gtk_box_pack_start( GTK_BOX( work ), 
		GTK_WIDGET( prefs->wsview ), TRUE, TRUE, 0 );
	gtk_window_set_default_size( GTK_WINDOW( prefs ), 665, 480 );
	gtk_widget_show( GTK_WIDGET( prefs->wsview ) );
}

static void
prefs_class_init( PrefsClass *class )
{
	GtkObjectClass *gobject_class = (GtkObjectClass *) class;
	GtkWidgetClass *widget_class = (GtkWidgetClass *) class;
	iWindowClass *iwindow_class = (iWindowClass *) class;

	parent_class = g_type_class_peek_parent( class );

	gobject_class->destroy = prefs_destroy;

	widget_class->show = prefs_show;

	iwindow_class->build = prefs_build;

	/* Create signals.
	 */

	/* Init methods.
	 */
}

static void
prefs_init( Prefs *prefs )
{
	prefs->ws = NULL;
	prefs->destroy_sid = 0;
	prefs->auto_layout_timeout = 0;
	prefs->done_auto_layout = FALSE;
}

GType
prefs_get_type( void )
{
	static GType type = 0;

	if( !type ) {
		static const GTypeInfo info = {
			sizeof( PrefsClass ),
			NULL,           /* base_init */
			NULL,           /* base_finalize */
			(GClassInitFunc) prefs_class_init,
			NULL,           /* class_finalize */
			NULL,           /* class_data */
			sizeof( Prefs ),
			32,             /* n_preallocs */
			(GInstanceInitFunc) prefs_init,
		};

		type = g_type_register_static( TYPE_IDIALOG, 
			"Prefs", &info, 0 );
	}

	return( type );
}

static void
prefs_workspace_destroy_cb( Workspace *ws, Prefs *prefs )
{
	prefs->destroy_sid = 0;
	prefs->ws = NULL;

	iwindow_kill( IWINDOW( prefs ) );
}

static void
prefs_link( Prefs *prefs, Workspace *ws )
{
	assert( !prefs->ws );

	prefs->ws = ws;
	prefs->ws->mode = WORKSPACE_MODE_NOEDIT;
	prefs->destroy_sid = g_signal_connect( ws, "destroy",
		G_CALLBACK( prefs_workspace_destroy_cb ), prefs );
}

Prefs *
prefs_new( void )
{
	Symbol *wsg_sym = main_workspacegroup->sym;
	Symbol *ws_sym = SYMBOL( icontainer_child_lookup( 
		ICONTAINER( wsg_sym->expr->compile ), "Preferences" ) );
	Prefs *prefs;

	if( !ws_sym ) {
		/* Probably failed to load prefs on startup for some reason.
		 */
		error_top( _( "Unable to display preferences." ) );
		error_sub( _( "No preferences workspace was found. "
			"Preferences probably failed to load when "
			"%s started." ),
			PACKAGE );
		return( NULL );
	}

	prefs = PREFS( g_object_new( TYPE_PREFS, NULL ) );
	prefs_link( prefs, ws_sym->ws );

	return( prefs );
}

gboolean
prefs_set( const char *name, const char *fmt, ... )
{
	Watch *watch;

	if( (watch = watch_find( main_watchgroup, name )) ) {
		va_list args;

		va_start( args, fmt );
		watch_vset( watch, fmt, args );
		va_end( args );
	}

	return( TRUE );
}
