/* an input fontname ... put/get methods
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
fontname_finalize( GObject *gobject )
{
	Fontname *fontname = FONTNAME( gobject );

	IM_FREE( fontname->value );

	G_OBJECT_CLASS( parent_class )->finalize( gobject );
}

static xmlNode *
fontname_save( Model *model, xmlNode *xnode )
{
	Fontname *fontname = FONTNAME( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_prop( xthis, "value", "%s", fontname->value ) )
			return( NULL );
	}

	return( xthis );
}

static gboolean
fontname_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Fontname *fontname = FONTNAME( model );
	char buf[MAX_STRSIZE];

	assert( IS_RHS( parent ) );

	if( get_sprop( xnode, "value", buf, MAX_STRSIZE ) ) {
		classmodel_set_edited( CLASSMODEL( model ), TRUE );
		SETSTR( fontname->value, buf );
	}

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

/* Update Fontname from heap.
 */
static gboolean
fontname_class_get( Classmodel *classmodel, PElement *root )
{
	Fontname *fontname = FONTNAME( classmodel );
	char caption[MAX_STRSIZE];
	char value[MAX_STRSIZE];

	if( !class_get_member_string( root, 
		MEMBER_CAPTION, caption, MAX_STRSIZE ) ||
		!class_get_member_string( root, 
			MEMBER_VALUE, value, MAX_STRSIZE ) )
		return( FALSE );
	iobject_set( IOBJECT( classmodel ), NULL, caption );
	SETSTR( fontname->value, value );

	return( TRUE );
}

/* Make a new "fn value" application.
 */
static gboolean
fontname_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *heap = reduce_context->heap;
	Fontname *fontname = FONTNAME( classmodel );
	PElement rhs;

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( heap, out, &rhs ) ||
		!heap_string_new( heap, 
			IOBJECT( classmodel )->caption, &rhs ) ||
		!heap_appl_add( heap, out, &rhs ) ||
		!heap_string_new( heap, fontname->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
fontname_class_init( FontnameClass *class )
{
	GObjectClass *gobject_class = (GObjectClass *) class;
	ModelClass *model_class = (ModelClass *) class;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) class;

	parent_class = g_type_class_peek_parent( class );

	gobject_class->finalize = fontname_finalize;

	model_class->view_new = fontnameview_new;
	model_class->save = fontname_save;
	model_class->load = fontname_load;

	classmodel_class->class_get = fontname_class_get;
	classmodel_class->class_new = fontname_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( class ) );
}

static void
fontname_init( Fontname *fontname )
{
	/* Overridden later. Just something sensible.
	 */
	fontname->value = NULL;

	iobject_set( IOBJECT( fontname ), CLASS_FONTNAME, NULL );
}

GType
fontname_get_type( void )
{
	static GType type = 0;

	if( !type ) {
		static const GTypeInfo info = {
			sizeof( FontnameClass ),
			NULL,           /* base_init */
			NULL,           /* base_finalize */
			(GClassInitFunc) fontname_class_init,
			NULL,           /* class_finalize */
			NULL,           /* class_data */
			sizeof( Fontname ),
			32,             /* n_preallocs */
			(GInstanceInitFunc) fontname_init,
		};

		type = g_type_register_static( TYPE_CLASSMODEL, 
			"Fontname", &info, 0 );
	}

	return( type );
}

Classmodel *
fontname_new( Rhs *rhs )
{
	Fontname *fontname;

	fontname = FONTNAME( g_object_new( TYPE_FONTNAME, NULL ) );
	icontainer_child_add( ICONTAINER( rhs ), ICONTAINER( fontname ), -1 );

	return( CLASSMODEL( fontname ) );
}
