/* Group workspacegroup files together.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static SymbolClass *parent_class = NULL;

static void
workspacegroup_destroy( GtkObject *object )
{
	Workspacegroup *wsg;

#ifdef DEBUG
	printf( "workspacegroup_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_WORKSPACEGROUP( object ) );

	wsg = WORKSPACEGROUP( object );

	wsg->current = NULL;

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static xmlNode *
workspacegroup_save( Model *model, xmlNode *xnode )
{
	return( MODEL_CLASS( parent_class )->save( model, xnode ) );
}

static void
workspacegroup_child_add( Model *parent, Model *child, int pos )
{
	Workspacegroup *wsg = WORKSPACEGROUP( parent );
	Workspace *ws = WORKSPACE( child );

	MODEL_CLASS( parent_class )->child_add( parent, child, pos );

	if( ws->ontop )
		workspacegroup_set_current( wsg, ws );
}

static void
workspacegroup_child_remove( Model *parent, Model *child )
{
	Workspacegroup *wsg = WORKSPACEGROUP( parent );
	Workspace *ws = WORKSPACE( child );

	/* Are we removing the current workspace? 
	 */
	if( wsg->current == ws ) 
		workspacegroup_set_current( wsg, NULL );

	MODEL_CLASS( parent_class )->child_remove( parent, child );
}

static void
workspacegroup_class_init( WorkspacegroupClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;

	parent_class = gtk_type_class( TYPE_SYMBOL );

	object_class->destroy = workspacegroup_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = workspacegroupview_new;
	model_class->child_add = workspacegroup_child_add;
	model_class->child_remove = workspacegroup_child_remove;
	model_class->save = workspacegroup_save;
}

static void
workspacegroup_init( Workspacegroup *wsg )
{
	wsg->current = NULL;
}

GtkType
workspacegroup_get_type( void )
{
	static GtkType workspacegroup_type = 0;

	if( !workspacegroup_type ) {
		static const GtkTypeInfo info = {
			"Workspacegroup",
			sizeof( Workspacegroup ),
			sizeof( WorkspacegroupClass ),
			(GtkClassInitFunc) workspacegroup_class_init,
			(GtkObjectInitFunc) workspacegroup_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		workspacegroup_type = gtk_type_unique( TYPE_SYMBOL, &info );
	}

	return( workspacegroup_type );
}

static void
workspacegroup_link( Workspacegroup *wsg, const char *name )
{
	Symbol *sym = SYMBOL( wsg );

	symbol_link( sym, symbol_root->expr->compile->locals, name );
	sym->type = SYM_WORKSPACEGROUP;
	sym->expr = expr_new( sym );
	(void) compile_new_root( sym->expr );
	symbol_made( sym );
}

Workspacegroup *
workspacegroup_new( const char *name )
{
	Workspacegroup *wsg;

	if( stable_find( symbol_root->expr->compile->locals, name ) ) {
		ierrors( "workspacegroup \"%s\" already exists", name );
		return( NULL );
	}

	wsg = gtk_type_new( TYPE_WORKSPACEGROUP );

	workspacegroup_link( wsg, name );

	return( wsg );
}

void
workspacegroup_set_current( Workspacegroup *wsg, Workspace *ws )
{
	assert( wsg );
	assert( !ws || g_slist_find( MODEL( wsg )->children, ws ) );

	if( wsg->current != ws ) {
		if( wsg->current ) {
			wsg->current->ontop = FALSE;
			model_changed( MODEL( wsg->current ) );
		}

		wsg->current = ws;

		if( wsg->current ) {
			wsg->current->ontop = TRUE;
			mainw_next_error_refresh();
			model_changed( MODEL( wsg->current ) );
		}

		model_changed( MODEL( wsg ) );
	}
}

/* Make sure we have a current workspace. If there aren't any, make one.
 */
void
workspacegroup_pick( Workspacegroup *wsg )
{
	if( !wsg->current ) {
		if( MODEL( wsg )->children ) {
			GSList *children = MODEL( wsg )->children;

			workspacegroup_set_current( wsg, 
				WORKSPACE( g_slist_last( children )->data ) );
		}
		else {
			Workspace *ws = workspace_new( wsg, "untitled" );

			model_set( MODEL( ws ), NULL, "default workspace" );

			workspacegroup_set_current( wsg, ws );
		}
	}
}

/* Done button hit.
 */
static void
workspacegroup_done_cb( iWindow *iwnd, void *client, 
	iWindowNotifyFn nfn, void *sys )
{
	Workspacegroup *wsg = WORKSPACEGROUP( client );
	Stringset *ss = STRINGSET( iwnd );
	StringsetChild *name = stringset_child_get( ss, "Name" );
	StringsetChild *caption = stringset_child_get( ss, "Caption" );

	Workspace *ws;

	char name_text[1024];
	char caption_text[1024];

	if( !get_geditable_name( name->entry, name_text, 1024 ) ||
		!get_geditable_string( caption->entry, caption_text, 1024 ) ) {
		nfn( sys, IWINDOW_ERROR );
		return;
	}

	if( !(ws = workspace_new( wsg, name_text )) ) {
		nfn( sys, IWINDOW_ERROR );
		return;
	}

	model_set( MODEL( ws ), NULL, caption_text );
	workspacegroup_set_current( wsg, ws );

	nfn( sys, IWINDOW_TRUE );
}

/* Make up a new workspace name.
 */
static char *
workspacegroup_name_new( void )
{
	SymTable *tab = SYMBOL( main_workspacegroup )->expr->compile->locals;

	char buf[ 256 ];
	int i;

	/* Search for one not in use.
	 */
	for( i = 0; ; i++ ) {
		number_to_string( i, buf );
		if( !stable_find( tab, buf ) )
			return( im_strdup( NULL, buf ) );
	}
}

void
workspacegroup_new_edit( Workspacegroup *wsg )
{
	GtkWidget *ss = stringset_new();
	char *name;

	name = workspacegroup_name_new();
	stringset_child_new( STRINGSET( ss ), 
		"Name", name, "Set workspace name here" );
	FREE( name );
	stringset_child_new( STRINGSET( ss ), 
		"Caption", "", "Set workspace caption here" );

	iwindow_set_title( IWINDOW( ss ), "New workspace" );
	idialog_set_callbacks( IDIALOG( ss ), 
		iwindow_true_cb, NULL, NULL, NULL, wsg );
	idialog_add_ok( IDIALOG( ss ), 
		workspacegroup_done_cb, "Create" );
	idialog_set_parent( IDIALOG( ss ), mainw_window );
	iwindow_build( IWINDOW( ss ) );

	gtk_widget_show( ss );
}

