/* Watch stuff in the prefs workspace.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your watch) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static GSList *watch_all = NULL;

static GtkObjectClass *watch_parent_class = NULL;

static void
watch_destroy( GtkObject *object )
{
	Watch *watch;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_WATCH( object ) );

	watch = WATCH( object );

#ifdef DEBUG
	printf( "watch_destroy: %s\n", NN( watch->name ) );
#endif /*DEBUG*/

	/* My instance destroy stuff.
	 */
	watch_all = g_slist_remove( watch_all, watch );
	FREESID( watch->destroy_sid, watch->row );
	FREESID( watch->changed_sid, watch->row );
	watch->row = NULL;
	FREE( watch->name );

	GTK_OBJECT_CLASS( watch_parent_class )->destroy( object );
}

static void
watch_class_init( WatchClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	WatchClass *watch_class = (WatchClass *) klass;

	watch_parent_class = gtk_type_class( GTK_TYPE_OBJECT );

	object_class->destroy = watch_destroy;

	watch_class->update = NULL;
	watch_class->get_value = NULL;
}

static void
watch_init( Watch *watch )
{
	watch->name = NULL;
	watch->row = NULL;
	watch->ok = FALSE;
	watch->destroy_sid = 0;
	watch->changed_sid = 0;

	watch_all = g_slist_prepend( watch_all, watch );
}

GtkType
watch_get_type( void )
{
	static GtkType watch_type = 0;

	if( !watch_type ) {
		static const GtkTypeInfo info = {
			"Watch",
			sizeof( Watch ),
			sizeof( WatchClass ),
			(GtkClassInitFunc) watch_class_init,
			(GtkObjectInitFunc) watch_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		watch_type = gtk_type_unique( GTK_TYPE_OBJECT, &info );
	}

	return( watch_type );
}

static void
watch_link( Watch *watch, const char *name )
{
	SETSTR( watch->name, name );
}

/* The row we are watching has changed.
 */
static void
watch_changed_cb( Row *row, Watch *watch )
{
	watch->ok = WATCH_CLASS( 
		GTK_OBJECT( watch )->klass )->update( watch );
}

/* Make sure we're linked to the thing we watch.
 */
static void
watch_attach( Watch *watch )
{
	SymTable *stab;
	const char *name = watch->name;

	Symbol *pref_ws, *pref_sym;

	if( watch->row )
		return;

	if( !main_workspacegroup )
		return;

	stab = SYMBOL( main_workspacegroup )->expr->compile->locals;

	if( !(pref_ws = stable_find( stab, "Preferences" )) ||
		!(pref_sym = stable_find( 
			pref_ws->expr->compile->locals, name )) ||
		!pref_sym->expr->row )
		return;

	watch->row = pref_sym->expr->row;
	watch->destroy_sid = 
		gtk_signal_connect_object( GTK_OBJECT( watch->row ), "destroy",
			GTK_SIGNAL_FUNC( gtk_object_destroy ), 
			GTK_OBJECT( watch ) );
	watch->changed_sid = 
		gtk_signal_connect( GTK_OBJECT( watch->row ), "changed",
			GTK_SIGNAL_FUNC( watch_changed_cb ), watch );
}

static void *
watch_test_name( Watch *watch, const char *name )
{
	if( watch->name && strcmp( watch->name, name ) == 0 )
		return( watch );
	
	return( NULL );
}

static Watch *
watch_find( const char *name )
{
	return( (Watch *)(slist_map( watch_all,	
		(SListMapFn) watch_test_name, (void *) name )) );
}

static gboolean
watch_get( Watch *watch, void **out )
{
#ifdef DEBUG
	printf( "watch_get\n" );
#endif /*DEBUG*/

	watch_attach( watch );

	if( !watch->row )
		return( FALSE );

	if( !watch->ok )
		watch->ok = WATCH_CLASS( 
			GTK_OBJECT( watch )->klass )->update( watch );

	if( !watch->ok )
		return( FALSE );

	*out = WATCH_CLASS( GTK_OBJECT( watch )->klass )->get_value( watch );

	return( TRUE );
}

static WatchClass *watch_double_parent_class = NULL;

static void
watch_double_destroy( GtkObject *object )
{
	WatchDouble *watch_double;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_WATCH_DOUBLE( object ) );

#ifdef DEBUG
	printf( "watch_double_destroy\n" );
#endif /*DEBUG*/

	watch_double = WATCH_DOUBLE( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( watch_double_parent_class )->destroy( object );
}

static gboolean
watch_double_update( Watch *watch )
{
	WatchDouble *watch_double = WATCH_DOUBLE( watch );
	PElement *root = &watch->row->expr->root;

#ifdef DEBUG
	printf( "watch_double_update\n" );
#endif /*DEBUG*/

	if( !PEISREAL( root ) ) {
		ierrors( "watch_double_update: not real!" );

		return( FALSE );
	}

	watch_double->value = PEGETREAL( root );

	return( TRUE );
}

static void *
watch_double_get_value( Watch *watch )
{
	WatchDouble *watch_double = WATCH_DOUBLE( watch );

	return( (void *) &watch_double->value );
}

static void
watch_double_class_init( WatchDoubleClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	WatchClass *watch_class = (WatchClass *) klass;

	watch_double_parent_class = gtk_type_class( TYPE_WATCH );

	object_class->destroy = watch_double_destroy;

	watch_class->update = watch_double_update;
	watch_class->get_value = watch_double_get_value;
}

static void
watch_double_init( WatchDouble *watch_double )
{
#ifdef DEBUG
	printf( "watch_double_init\n" );
#endif /*DEBUG*/

	watch_double->value = -1.0;
}

GtkType
watch_double_get_type( void )
{
	static GtkType watch_double_type = 0;

	if( !watch_double_type ) {
		static const GtkTypeInfo info = {
			"WatchDouble",
			sizeof( WatchDouble ),
			sizeof( WatchDoubleClass ),
			(GtkClassInitFunc) watch_double_class_init,
			(GtkObjectInitFunc) watch_double_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		watch_double_type = 
			gtk_type_unique( TYPE_WATCH, &info );
	}

	return( watch_double_type );
}

static Watch *
watch_double_new( const char *name )
{
	WatchDouble *watch_double = gtk_type_new( TYPE_WATCH_DOUBLE );

	watch_link( WATCH( watch_double ), name );

	return( WATCH( watch_double ) );
}

double 
watch_double_get( const char *name, double fallback )
{
	Watch *watch = watch_find( name );
	void *value;

	if( !watch )
		watch = watch_double_new( name );

	assert( IS_WATCH_DOUBLE( watch ) );

	if( !watch_get( watch, &value ) ) 
		return( fallback );

	return( *((double *) value) );
}

static WatchClass *watch_int_parent_class = NULL;

static void
watch_int_destroy( GtkObject *object )
{
	WatchInt *watch_int;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_WATCH_INT( object ) );

#ifdef DEBUG
	printf( "watch_int_destroy\n" );
#endif /*DEBUG*/

	watch_int = WATCH_INT( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( watch_int_parent_class )->destroy( object );
}

static gboolean
watch_int_update( Watch *watch )
{
	WatchInt *watch_int = WATCH_INT( watch );
	PElement *root = &watch->row->expr->root;

#ifdef DEBUG
	printf( "watch_int_update\n" );
#endif /*DEBUG*/

	if( !PEISREAL( root ) ) {
		ierrors( "watch_int_update: not real!" );

		return( FALSE );
	}

	watch_int->value = IM_RINT( PEGETREAL( root ) );

	return( TRUE );
}

static void *
watch_int_get_value( Watch *watch )
{
	WatchInt *watch_int = WATCH_INT( watch );

	return( (void *) &watch_int->value );
}

static void
watch_int_class_init( WatchIntClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	WatchClass *watch_class = (WatchClass *) klass;

	watch_int_parent_class = gtk_type_class( TYPE_WATCH );

	object_class->destroy = watch_int_destroy;

	watch_class->update = watch_int_update;
	watch_class->get_value = watch_int_get_value;
}

static void
watch_int_init( WatchInt *watch_int )
{
#ifdef DEBUG
	printf( "watch_int_init\n" );
#endif /*DEBUG*/

	watch_int->value = -1;
}

GtkType
watch_int_get_type( void )
{
	static GtkType watch_int_type = 0;

	if( !watch_int_type ) {
		static const GtkTypeInfo info = {
			"WatchInt",
			sizeof( WatchInt ),
			sizeof( WatchIntClass ),
			(GtkClassInitFunc) watch_int_class_init,
			(GtkObjectInitFunc) watch_int_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		watch_int_type = 
			gtk_type_unique( TYPE_WATCH, &info );
	}

	return( watch_int_type );
}

static Watch *
watch_int_new( const char *name )
{
	WatchInt *watch_int = gtk_type_new( TYPE_WATCH_INT );

	watch_link( WATCH( watch_int ), name );

	return( WATCH( watch_int ) );
}

int
watch_int_get( const char *name, int fallback )
{
	Watch *watch = watch_find( name );
	void *value;

	if( !watch )
		watch = watch_int_new( name );

	assert( IS_WATCH_INT( watch ) );

	if( !watch_get( watch, &value ) ) 
		return( fallback );

	return( *((int *) value) );
}

static WatchClass *watch_path_parent_class = NULL;

static void
watch_path_destroy( GtkObject *object )
{
	WatchPath *watch_path;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_WATCH_PATH( object ) );

#ifdef DEBUG
	printf( "watch_path_destroy\n" );
#endif /*DEBUG*/

	watch_path = WATCH_PATH( object );

	/* My instance destroy stuff.
	 */
	FREEF( slist_free_all, watch_path->value );

	GTK_OBJECT_CLASS( watch_path_parent_class )->destroy( object );
}

static gboolean
watch_path_update( Watch *watch )
{
	WatchPath *watch_path = WATCH_PATH( watch );
	PElement *root = &watch->row->expr->root;
	GSList *value;

#ifdef DEBUG
	printf( "watch_path_update\n" );
#endif /*DEBUG*/

	value = NULL;
	if( !heap_get_lstring( root, &value ) )
		return( FALSE );

	FREEF( slist_free_all, watch_path->value );
	watch_path->value = value;

	return( TRUE );
}

static void *
watch_path_get_value( Watch *watch )
{
	WatchPath *watch_path = WATCH_PATH( watch );

	return( (void *) &watch_path->value );
}

static void
watch_path_class_init( WatchPathClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	WatchClass *watch_class = (WatchClass *) klass;

	watch_path_parent_class = gtk_type_class( TYPE_WATCH );

	object_class->destroy = watch_path_destroy;

	watch_class->update = watch_path_update;
	watch_class->get_value = watch_path_get_value;
}

static void
watch_path_init( WatchPath *watch_path )
{
#ifdef DEBUG
	printf( "watch_path_init\n" );
#endif /*DEBUG*/

	watch_path->value = NULL;
}

GtkType
watch_path_get_type( void )
{
	static GtkType watch_path_type = 0;

	if( !watch_path_type ) {
		static const GtkTypeInfo info = {
			"WatchPath",
			sizeof( WatchPath ),
			sizeof( WatchPathClass ),
			(GtkClassInitFunc) watch_path_class_init,
			(GtkObjectInitFunc) watch_path_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		watch_path_type = 
			gtk_type_unique( TYPE_WATCH, &info );
	}

	return( watch_path_type );
}

static Watch *
watch_path_new( const char *name )
{
	WatchPath *watch_path = gtk_type_new( TYPE_WATCH_PATH );

	watch_link( WATCH( watch_path ), name );

	return( WATCH( watch_path ) );
}

GSList *
watch_path_get( const char *name, GSList *fallback )
{
	Watch *watch = watch_find( name );
	void *value;

	if( !watch )
		watch = watch_path_new( name );

	assert( IS_WATCH_PATH( watch ) );

	if( !watch_get( watch, &value ) ) 
		return( fallback );
	
	return( *((GSList **) value) );
}

static WatchClass *watch_bool_parent_class = NULL;

static void
watch_bool_destroy( GtkObject *object )
{
	WatchBool *watch_bool;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_WATCH_BOOL( object ) );

#ifdef DEBUG
	printf( "watch_bool_destroy\n" );
#endif /*DEBUG*/

	watch_bool = WATCH_BOOL( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( watch_bool_parent_class )->destroy( object );
}

static gboolean
watch_bool_update( Watch *watch )
{
	WatchBool *watch_bool = WATCH_BOOL( watch );
	PElement *root = &watch->row->expr->root;

#ifdef DEBUG
	printf( "watch_bool_update\n" );
#endif /*DEBUG*/

	if( !PEISBOOL( root ) ) {
		ierrors( "watch_bool_update: not bool!" );

		return( FALSE );
	}

	watch_bool->value = PEGETBOOL( root );

	return( TRUE );
}

static void *
watch_bool_get_value( Watch *watch )
{
	WatchBool *watch_bool = WATCH_BOOL( watch );

	return( (void *) &watch_bool->value );
}

static void
watch_bool_class_init( WatchBoolClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	WatchClass *watch_class = (WatchClass *) klass;

	watch_bool_parent_class = gtk_type_class( TYPE_WATCH );

	object_class->destroy = watch_bool_destroy;

	watch_class->update = watch_bool_update;
	watch_class->get_value = watch_bool_get_value;
}

static void
watch_bool_init( WatchBool *watch_bool )
{
#ifdef DEBUG
	printf( "watch_bool_init\n" );
#endif /*DEBUG*/

	watch_bool->value = FALSE;
}

GtkType
watch_bool_get_type( void )
{
	static GtkType watch_bool_type = 0;

	if( !watch_bool_type ) {
		static const GtkTypeInfo info = {
			"WatchBool",
			sizeof( WatchBool ),
			sizeof( WatchBoolClass ),
			(GtkClassInitFunc) watch_bool_class_init,
			(GtkObjectInitFunc) watch_bool_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		watch_bool_type = 
			gtk_type_unique( TYPE_WATCH, &info );
	}

	return( watch_bool_type );
}

static Watch *
watch_bool_new( const char *name )
{
	WatchBool *watch_bool = gtk_type_new( TYPE_WATCH_BOOL );

	watch_link( WATCH( watch_bool ), name );

	return( WATCH( watch_bool ) );
}

gboolean 
watch_bool_get( const char *name, gboolean fallback )
{
	Watch *watch = watch_find( name );
	void *value;

	if( !watch )
		watch = watch_bool_new( name );

	assert( IS_WATCH_BOOL( watch ) );

	if( !watch_get( watch, &value ) ) 
		return( fallback );

	return( *((gboolean *) value) );
}

static WatchClass *watch_string_parent_class = NULL;

static void
watch_string_destroy( GtkObject *object )
{
	WatchString *watch_string;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_WATCH_STRING( object ) );

#ifdef DEBUG
	printf( "watch_string_destroy\n" );
#endif /*DEBUG*/

	watch_string = WATCH_STRING( object );

	/* My instance destroy stuff.
	 */
	FREE( watch_string->value );

	GTK_OBJECT_CLASS( watch_string_parent_class )->destroy( object );
}

static gboolean
watch_string_update( Watch *watch )
{
	WatchString *watch_string = WATCH_STRING( watch );
	PElement *root = &watch->row->expr->root;
	char value[1024];

#ifdef DEBUG
	printf( "watch_string_update\n" );
#endif /*DEBUG*/

	if( !heap_get_string( root, value, 1024 ) )
		return( FALSE );

	SETSTR( watch_string->value, value );

	return( TRUE );
}

static void *
watch_string_get_value( Watch *watch )
{
	WatchString *watch_string = WATCH_STRING( watch );

	return( (void *) &watch_string->value );
}

static void
watch_string_class_init( WatchStringClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	WatchClass *watch_class = (WatchClass *) klass;

	watch_string_parent_class = gtk_type_class( TYPE_WATCH );

	object_class->destroy = watch_string_destroy;

	watch_class->update = watch_string_update;
	watch_class->get_value = watch_string_get_value;
}

static void
watch_string_init( WatchString *watch_string )
{
#ifdef DEBUG
	printf( "watch_string_init\n" );
#endif /*DEBUG*/

	watch_string->value = NULL;
}

GtkType
watch_string_get_type( void )
{
	static GtkType watch_string_type = 0;

	if( !watch_string_type ) {
		static const GtkTypeInfo info = {
			"WatchString",
			sizeof( WatchString ),
			sizeof( WatchStringClass ),
			(GtkClassInitFunc) watch_string_class_init,
			(GtkObjectInitFunc) watch_string_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		watch_string_type = 
			gtk_type_unique( TYPE_WATCH, &info );
	}

	return( watch_string_type );
}

static Watch *
watch_string_new( const char *name )
{
	WatchString *watch_string = gtk_type_new( TYPE_WATCH_STRING );

	watch_link( WATCH( watch_string ), name );

	return( WATCH( watch_string ) );
}

const char * 
watch_string_get( const char *name, const char *fallback )
{
	Watch *watch = watch_find( name );
	void *value;

	if( !watch )
		watch = watch_string_new( name );

	assert( IS_WATCH_STRING( watch ) );

	if( !watch_get( watch, &value ) ) 
		return( fallback );

	return( *((const char **) value) );
}

