/* a subcolumn 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* 
#define DEBUG
 */

#include "ip.h"

static HeapmodelClass *parent_class = NULL;

static gboolean
subcolumn_row_pred_none( Row *row )
{
	return( FALSE );
}

/* No params, no super.
 */
static gboolean
subcolumn_row_pred_members( Row *row )
{
	if( is_system( row->sym ) )
		return( FALSE );

	if( is_super( row->sym ) )
		return( FALSE );

	if( row->sym->type == SYM_PARAM )
		return( FALSE );

	return( TRUE );
}

static gboolean
subcolumn_row_pred_params( Row *row )
{
	return( row->sym->type == SYM_PARAM );
}

/* Everything but empty superclasses.
 */
static gboolean
subcolumn_row_pred_super( Row *row )
{
	if( is_super( row->sym ) && PEISELIST( &row->expr->root ) )
		return( FALSE );

	return( TRUE );
}

/* Array of these guys control member visibility, scol->vislevel indexes this
 * array, one of preds from vislevel down has to be TRUE for the row to be
 * visible.
 */
const SubcolumnVisibility subcolumn_visibility[] = {
	{ "none", subcolumn_row_pred_none },
	{ "members", subcolumn_row_pred_members },
	{ "params", subcolumn_row_pred_params },
	{ "super", subcolumn_row_pred_super }
};
const int subcolumn_nvisibility = IM_NUMBER( subcolumn_visibility );

/* Map down a Subcolumn.
 */
void *
subcolumn_map( Subcolumn *scol, row_map_fn fn, void *a, void *b )
{
	return( model_map( MODEL( scol ), (model_map_fn) fn, a, b ) );
}

static void
subcolumn_destroy( GtkObject *object )
{
	Subcolumn *scol;

#ifdef DEBUG
	printf( "subcolumn_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_SUBCOLUMN( object ) );

	scol = SUBCOLUMN( object );

	scol->col = NULL;
	scol->scol = NULL;
	scol->top_col = NULL;

	heap_unregister_element( reduce_context->hi, &scol->base );
	scol->base.type = ELEMENT_NOVAL;

	scol->this = NULL;
	scol->super = NULL;

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Stuff we track during class instance display update.
 */
typedef struct {
	Subcolumn *scol;		/* Enclosing column */
	GSList *notused;		/* List of row we've not used */
} ClassRefreshInfo;

/* Test for row represents a sym.
 */
static void *
subcolumn_test_sym( Row *row, Symbol *sym )
{
	if( row->sym == sym )
		return( row );

	return( NULL );
}

/* Test for row has a zombie of the same name.
 */
static void *
subcolumn_test_row_name( Row *row, Symbol *sym )
{
	if( !row->sym && strcmp( MODEL( row )->name, MODEL( sym )->name ) == 0 )
		return( row );

	return( NULL );
}

/* Refresh one line of a subcolumn.
 */
static void
subcolumn_class_new_heap_sub( ClassRefreshInfo *cri,
	Symbol *sym, PElement *value )
{
	Row *row;

#ifdef DEBUG
	BufInfo buf;
	char txt[200];

	buf_init_static( &buf, txt, 200 );
	symbol_qualified_name( sym, &buf );
	printf( "subcolumn_class_new_heap_sub: %s\n", buf_all( &buf ) );
#endif /*DEBUG*/

	/* Do we have a row for this symbol?
	 */
	if( (row = (Row *) slist_map( cri->notused, 
		(SListMapFn) subcolumn_test_sym, sym )) ) {
		/* Update it.
		 */
		heapmodel_new_heap( HEAPMODEL( row ), value );

		cri->notused = g_slist_remove( cri->notused, row );
	}
	else if( (row = (Row *) slist_map( cri->notused, 
		(SListMapFn) subcolumn_test_row_name, sym )) ) {
		/* There's a blank row of the same name, left for us by XML 
		 * load. Update the row with the correct symbol.
		 */
		row_link_symbol( row, sym, NULL );
		heapmodel_new_heap( HEAPMODEL( row ), value );

		cri->notused = g_slist_remove( cri->notused, row );
	}
	else {
		row = row_new( cri->scol, sym, value );
		heapmodel_new_heap( HEAPMODEL( row ), value );
	}
}

#ifdef DEBUG
static void *
subcolumn_class_dump_tiny_row( Row *row )
{
	row_name_print( row );
	printf( " " );

	return( NULL );
}
#endif /*DEBUG*/

/* A new scrap of heap for a subcolumn.
 */
static gboolean
subcolumn_class_new_heap( Subcolumn *scol, PElement *root )
{
	PElement instance = *root;

	Expr *expr;
	Row *row;
	gboolean result;
	PElement base, member;
	HeapNode *p;
	ClassRefreshInfo cri;

	/* Must be a class display.
	 */
	assert( !scol->istop );
	row = HEAPMODEL( scol )->row;
	expr = row->expr;

#ifdef DEBUG
	printf( "subcolumn_class_new_heap: " );
	row_name_print( row );
	printf( "\n" );
#endif /*DEBUG*/

	/* Can loop here for some recursive classes.
	 */
	if( mainw_countdown_animate( 99 ) )
		return( FALSE );

	/* No displays for system rows.
	 */
	if( is_system( row->sym ) )
		return( TRUE );

	/* If we are the top of a class instance display, get a new serial.
	 * As we recurse down refreshing our contents, this should stop 
	 * circular structures looping the browser.

	 	FIXME ... clear flags for a whole class, then do a complete
		redisplay? more reliable, but even slower :-(

	 */
	if( scol->scol->istop )
		heap_serial_new( reduce_context->hi );

	/* Is it a class with a typecheck member? Go through
	 * that. Do an isclass first to force eval.
	 */
	if( !heap_isclass( &instance, &result ) )
		return( FALSE );
	if( result &&
		class_get_member( &instance, MEMBER_CHECK, &member ) ) {
#ifdef DEBUG
		printf( "subcolumn_class_new_heap: invoking arg checker\n" );
#endif 

		/* Force eval of the typecheck member.
		 */
		if( !heap_isclass( &member, &result ) || !result )
			return( FALSE );
	}

	/* Have we already displayed this class?
	 */
	if( (PEGETVAL( &instance )->flgs & FLAG_SERIAL) == 
		reduce_context->hi->serial ) {
		/* 
		
			FIXME ... display something here? "circular"?

		 */
		return( TRUE );
	}
	SETSERIAL( PEGETVAL( &instance )->flgs, reduce_context->hi->serial );

	/* Note the heap root ... if this is the top of a row tree, then we
	 * clone the class and use that private copy.
	 */
	PEPOINTE( &base, &(SUBCOLUMN( scol ))->base );
	PEPUTPE( &base, &instance );
	PEPUTPE( &expr->root, &base );

	/* Init rebuild params. We make a list of all the existing
	 * row objects for this class display, and every time we
	 * manage to reuse one of them, we knock it off the list. At the
	 * end, remove all unused rows.
	 */
	cri.scol = scol;
	cri.notused = g_slist_copy( MODEL( scol )->children );

#ifdef DEBUG
	printf( "subcolumn_class_new_heap: existing rows: " );
	model_map( MODEL( scol ), 
		(model_map_fn) subcolumn_class_dump_tiny_row, NULL, NULL );
	printf( "\n" );
#endif /*DEBUG*/

	/* Loop along the members, updating row entries.
	 */
	PEGETCLASSMEMBER( &member, &base );

	if( PEISNODE( &member ) )
		for( p = PEGETVAL( &member ); p; p = GETRIGHT( p ) ) {
			PElement s, v;
			HeapNode *hn;
			Symbol *sym;

			/* Get the sym/value pair.
			 */
			hn = GETLEFT( p );
			PEPOINTLEFT( hn, &s );
			PEPOINTRIGHT( hn, &v );
			sym = SYMBOL( PEGETSYMREF( &s ) );

			/* We don't make rows for the default constructor, or
			 * for ".name". These things don't change, so there's
			 * no point (and the default constructor has no text
			 * equivalent anyway).
			 */
			if( strcmp( MODEL( sym )->name, MEMBER_NAME ) == 0 )
				continue;
			if( is_member( sym ) && strcmp( MODEL( sym )->name, 
				MODEL( symbol_get_parent( sym ) )->name ) == 0 )
				continue;

			/* Display!
			 */
			subcolumn_class_new_heap_sub( &cri, sym, &v );
		}

	/* Remove all the rows we've not used. 
	 */
	slist_map( cri.notused, (SListMapFn) object_destroy, NULL );
	FREEF( g_slist_free, cri.notused );

	return( TRUE );
}

static void *
subcolumn_new_heap( Heapmodel *heapmodel, PElement *root )
{
	Subcolumn *scol = SUBCOLUMN( heapmodel );

	/* New heap for a class display? CLear known_private, we've no idea
	 * where this heap came from.
	 */
	if( scol == scol->top_scol )
		scol->known_private = FALSE;

	/* A bunch of locals? Update them all.
	 */
	if( !scol->istop && !subcolumn_class_new_heap( scol, root ) )
		return( scol );

	return( HEAPMODEL_CLASS( parent_class )->new_heap( heapmodel, root ) );
}

static void
subcolumn_child_remove( Model *parent, Model *child )
{
	Subcolumn *scol = SUBCOLUMN( parent );
	Row *row = ROW( child );

	/* top_col can be NULL during destroy.
	 */
	if( scol->istop && scol->top_col ) {
		Workspace *ws = scol->top_col->ws;

		filemodel_set_modified( FILEMODEL( ws ), TRUE );
	}

	MODEL_CLASS( parent_class )->child_remove( parent, child );

	if( scol->this == row )
		scol->this = NULL;
	if( scol->super == row )
		scol->super = NULL;
}

static void
subcolumn_child_add( Model *parent, Model *child, int pos )
{
	Subcolumn *scol = SUBCOLUMN( parent );
	Row *row = ROW( child );

	/* May not have a symbol yet during ws load.
	 *
	 * Can't use is_this()/is_super(), not everything has been built yet.
	 * We don't do this often, so strcmp() it.
	 */
	const char *name = 
		row->sym ? MODEL( row->sym )->name : MODEL( row )->name;

	if( strcmp( name, MEMBER_THIS ) == 0 ) 
		scol->this = row;

	if( strcmp( name, MEMBER_SUPER ) == 0 ) 
		scol->super = row;

	MODEL_CLASS( parent_class )->child_add( parent, child, pos );
}

/* If this is a top-level subcolumn, get the enclosing column.
 */
static Column *
subcolumn_get_column( Subcolumn *scol )
{
	assert( scol->istop );

	return( COLUMN( MODEL( scol )->parent ) );
}

/* If this is a nested subcolumn, get the enclosing subcolumn.
 */
static Subcolumn *
subcolumn_get_subcolumn( Subcolumn *scol )
{
	Rhs *rhs;
	Row *row;
	Subcolumn *escol;

	assert( !scol->istop );

	rhs = HEAPMODEL( scol )->rhs;
	row = HEAPMODEL( rhs )->row;
	escol = row->scol;

	return( escol );
}

/* Return the enclosing column for a Subcolumn.
 */
static Column *
subcolumn_get_top_column( Subcolumn *scol )
{
	if( !scol->istop ) 
		return( subcolumn_get_top_column( 
			subcolumn_get_subcolumn( scol ) ) );

	return( subcolumn_get_column( scol ) );
}

/* Return the enclosing subcolumn ... but not the istop one. Ie. the enclosing
 * subcolumn which has the base for this class tree.
 */
static Subcolumn *
subcolumn_get_top_subcolumn( Subcolumn *scol )
{
	Subcolumn *enclosing;

	if( scol->istop )
		return( NULL );

	enclosing = subcolumn_get_subcolumn( scol );
	if( enclosing->istop )
		return( scol );
	else 
		return( subcolumn_get_top_subcolumn( enclosing ) );
}

static void
subcolumn_parent_add( Model *child, Model *parent )
{
	Subcolumn *scol = SUBCOLUMN( child );

	MODEL_CLASS( parent_class )->parent_add( child, parent );

	assert( IS_COLUMN( parent ) || IS_RHS( parent ) );
	assert( !IS_COLUMN( parent ) || 
		g_slist_length( parent->children ) == 1 );

	scol->istop = IS_COLUMN( parent );

	/* For sub-columns, default to nothing visible.
	 */
	if( !scol->istop )
		scol->vislevel = 0;

	/* Update context pointers.
	 */
	if( scol->istop )
		scol->col = subcolumn_get_column( scol );
	else
		scol->col = NULL;

	if( !scol->istop )
		scol->scol = subcolumn_get_subcolumn( scol );
	else
		scol->scol = NULL;

	scol->top_col = subcolumn_get_top_column( scol );
	scol->top_scol = subcolumn_get_top_subcolumn( scol );

	/* Top level subcolumns default to display on, others to display off.
	 */
	MODEL( scol )->display = scol->istop;
}

static gboolean
subcolumn_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Subcolumn *scol = SUBCOLUMN( model );

	if( !IS_COLUMN( parent ) && !IS_RHS( parent ) ) {
		ierrors( "subcolumn_load: can only add a subcolumn to a "
			"column or to a rhs" );
		return( FALSE );
	}

	if( !get_iprop( xnode, "vislevel", &scol->vislevel ) )
		return( FALSE );

	if( !MODEL_CLASS( parent_class )->load( model, state, parent, xnode ) )
		return( FALSE );

	return( TRUE );
}

static xmlNode *
subcolumn_save( Model *model, xmlNode *xnode )
{
	Subcolumn *scol = SUBCOLUMN( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( !set_prop( xthis, "vislevel", "%d", scol->vislevel ) )
		return( NULL );

	return( xthis );
}

static void
subcolumn_class_init( SubcolumnClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	HeapmodelClass *heapmodel_class = (HeapmodelClass *) klass;

	parent_class = gtk_type_class( TYPE_HEAPMODEL );

	object_class->destroy = subcolumn_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = subcolumnview_new;
	model_class->child_remove = subcolumn_child_remove;
	model_class->child_add = subcolumn_child_add;
	model_class->parent_add = subcolumn_parent_add;
	model_class->load = subcolumn_load;
	model_class->save = subcolumn_save;

	heapmodel_class->new_heap = subcolumn_new_heap;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( klass ) );
}

static void
subcolumn_init( Subcolumn *scol )
{
#ifdef DEBUG
	printf( "subcolumn_init\n" );
#endif /*DEBUG*/

	scol->col = NULL;
	scol->scol = NULL;
	scol->top_col = NULL;

        scol->vislevel = subcolumn_nvisibility - 1;

	scol->base.type = ELEMENT_NOVAL;
	heap_register_element( reduce_context->hi, &scol->base );
	scol->known_private = FALSE;

	scol->this = NULL;
	scol->super = NULL;
}

GtkType
subcolumn_get_type( void )
{
	static GtkType subcolumn_type = 0;

	if( !subcolumn_type ) {
		static const GtkTypeInfo info = {
			"Subcolumn",
			sizeof( Subcolumn ),
			sizeof( SubcolumnClass ),
			(GtkClassInitFunc) subcolumn_class_init,
			(GtkObjectInitFunc) subcolumn_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		subcolumn_type = gtk_type_unique( TYPE_HEAPMODEL, &info );
	}

	return( subcolumn_type );
}

static void
subcolumn_link( Subcolumn *scol, Rhs *rhs, Column *col )
{
	assert( rhs == NULL || col == NULL );

	/* parent_add() sets istop for us.
	 */
	if( rhs ) 
		model_child_add( MODEL( rhs ), MODEL( scol ), -1 );
	else 
		model_child_add( MODEL( col ), MODEL( scol ), -1 );
}

Subcolumn *
subcolumn_new( Rhs *rhs, Column *col )
{
	Subcolumn *scol = gtk_type_new( TYPE_SUBCOLUMN );

	subcolumn_link( scol, rhs, col );

	return( scol );
}

void
subcolumn_set_vislevel( Subcolumn *scol, int vislevel )
{
	scol->vislevel = IM_CLIP( 0, vislevel, subcolumn_nvisibility - 1 );

#ifdef DEBUG
	printf( "subcolumn_set_vislevel: %d\n", scol->vislevel );
#endif /*DEBUG*/

	model_changed( MODEL( scol ) );
}

/* Make sure we have a private copy of the graph for this tree of stuff.
 */
gboolean
subcolumn_make_private( Subcolumn *scol )
{
	Subcolumn *top_scol = scol->top_scol;
	PElement base;

	if( !top_scol || top_scol->known_private )
		return( TRUE );

#ifdef DEBUG
{
	Row *row = HEAPMODEL( top_scol )->row;

	printf( "subcolumn_make_private: cloning " );
	row_name_print( row );
	printf( "\n" );
}
#endif /*DEBUG*/

	/* Clone from the class args and rebuild our tree.
	 */
	PEPOINTE( &base, &top_scol->base );
	if( !class_clone_args( reduce_context->hi, &base, &base ) ||
		heapmodel_new_heap( HEAPMODEL( top_scol ), &base ) )
		return( FALSE );

	top_scol->known_private = TRUE;

	return( TRUE );
}

