/* an input slider ... put/get methods
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
slider_destroy( GtkObject *object )
{
	Slider *slider;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_SLIDER( object ) );

	slider = SLIDER( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Widgets for slider edit.
 */
typedef struct _SliderEdit {
	iDialog *idlg;

	Slider *slider;

	GtkWidget *from;
	GtkWidget *to;
	GtkWidget *value;
} SliderEdit;

/* Done button hit.
 */
static void
slider_done_cb( iWindow *iwnd, void *client, iWindowNotifyFn nfn, void *sys )
{
	SliderEdit *eds = (SliderEdit *) client;
	Classmodel *classmodel = CLASSMODEL( eds->slider );

	/* Parse values.
	 */
	if( !get_geditable_double( eds->from, &eds->slider->from ) ||
		!get_geditable_double( eds->to, &eds->slider->to ) ||
		!get_geditable_double( eds->value, &eds->slider->value ) ) {
		nfn( sys, IWINDOW_ERROR );
		return;
	}

	/* Rebuild object.
	 */
	classmodel_update( classmodel );
	symbol_recalculate_all();

	nfn( sys, IWINDOW_TRUE );
}

/* Build the insides of slider edit.
 */
static void
slider_buildedit( iDialog *idlg, GtkWidget *work, SliderEdit *eds )
{
	Slider *slider = eds->slider;

        GtkWidget *hb;
        GtkWidget *frame;
        GtkWidget *inv;

        hb = gtk_hbox_new( FALSE, 2 );
        gtk_container_set_border_width( GTK_CONTAINER( hb ), 2 );
        eds->from = build_glabeltext( hb, "Minimum:" );
	idialog_init_entry( idlg, eds->from,
		"Lower slider value", "%g", slider->from );
        eds->to = build_glabeltext( hb, "Maximum:" );
	idialog_init_entry( idlg, eds->to,
		"Upper slider value", "%g", slider->to );
	frame = build_glabelframe( hb, "Range" );
        gtk_box_pack_start( GTK_BOX( work ), frame, TRUE, TRUE, 2 );

        hb = gtk_hbox_new( TRUE, 2 );
        eds->value = build_glabeltext( hb, "Value:" );
	idialog_init_entry( idlg, eds->value,
		"Set slider value here", "%g", slider->value );
        inv = gtk_label_new( "" );
        gtk_box_pack_start( GTK_BOX( hb ), inv, TRUE, TRUE, 2 );
        gtk_box_pack_start( GTK_BOX( work ), hb, TRUE, TRUE, 2 );

        gtk_widget_show_all( work );
}

/* Pop up a slider edit box.
 */
static void 
slider_edit( GtkWidget *parent, Model *model )
{
	Slider *slider = SLIDER( model );
	SliderEdit *eds = IM_NEW( NULL, SliderEdit );
	GtkWidget *idlg;

	eds->slider = slider;

	idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), "Edit slider" );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) slider_buildedit, eds, NULL, NULL );
	idialog_set_callbacks( IDIALOG( idlg ), 
		iwindow_true_cb, NULL, NULL, idialog_free_client, eds );
	idialog_add_ok( IDIALOG( idlg ), slider_done_cb, "Set slider" );
	idialog_set_parent( IDIALOG( idlg ), parent );
	iwindow_build( IWINDOW( idlg ) );

	gtk_widget_show( GTK_WIDGET( idlg ) );
}

static xmlNode *
slider_save( Model *model, xmlNode *xnode )
{
	Slider *slider = SLIDER( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_prop( xthis, "from", "%g", slider->from ) ||
			!set_prop( xthis, "to", "%g", slider->to ) ||
			!set_prop( xthis, "value", "%g", slider->value ) ) 
			return( NULL );
	}

	return( xthis );
}

static gboolean
slider_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Slider *slider = SLIDER( model );

#ifdef DEBUG
	printf( "slider_load: " );
	row_name_print( HEAPMODEL( slider )->row );
	printf( "\n" );
#endif /*DEBUG*/

	if( !IS_RHS( parent ) ) {
		ierrors( "slider_load: can only add a slider to a Rhs" );
		return( FALSE );
	}

	if( get_dprop( xnode, "from", &slider->from ) &&
		get_dprop( xnode, "to", &slider->to ) &&
		get_dprop( xnode, "value", &slider->value ) )
		classmodel_set_edited( CLASSMODEL( model ), TRUE );

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

/* Update Slider from heap.
 */
static gboolean
slider_class_get( Classmodel *classmodel, PElement *root )
{
	Slider *slider = SLIDER( classmodel );

	if( !class_get_member_real( root, MEMBER_FROM, &slider->from ) ||
		!class_get_member_real( root, MEMBER_TO, &slider->to ) ||
		!class_get_member_real( root, MEMBER_VALUE, &slider->value ) )
		return( FALSE );

#ifdef DEBUG
	printf( "slider_class_get: " );
	row_name_print( HEAPMODEL( slider )->row );
	printf( " from=%g, to=%g, value=%g\n", 
		slider->from, slider->to, slider->value );
#endif /*DEBUG*/

	return( TRUE );
}

/* Make a new "fn from to value" application.
 */
static gboolean
slider_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *hi = reduce_context->hi;
	Slider *slider = SLIDER( classmodel );

	PElement rhs;

#ifdef DEBUG
	printf( "slider_class_new: " );
	row_name_print( HEAPMODEL( slider )->row );
	printf( " from=%g, to=%g, value=%g\n", 
		slider->from, slider->to, slider->value );
#endif /*DEBUG*/

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( hi, out, &rhs ) ||
		!heap_real_new( hi, slider->from, &rhs ) ||
		!heap_appl_add( hi, out, &rhs ) ||
		!heap_real_new( hi, slider->to, &rhs ) ||
		!heap_appl_add( hi, out, &rhs ) ||
		!heap_real_new( hi, slider->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
slider_class_init( SliderClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) klass;

	parent_class = gtk_type_class( TYPE_CLASSMODEL );

	object_class->destroy = slider_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = sliderview_new;
	model_class->edit = slider_edit;
	model_class->save = slider_save;
	model_class->load = slider_load;

	classmodel_class->class_get = slider_class_get;
	classmodel_class->class_new = slider_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( klass ) );
}

static void
slider_init( Slider *slider )
{
	/* Overridden later. Just something sensible.
	 */
        slider->from = 0;
	slider->to = 255;
	slider->value = 128;

	model_set( MODEL( slider ), CLASS_SLIDER, NULL );
}

GtkType
slider_get_type( void )
{
	static GtkType slider_type = 0;

	if( !slider_type ) {
		static const GtkTypeInfo info = {
			"Slider",
			sizeof( Slider ),
			sizeof( SliderClass ),
			(GtkClassInitFunc) slider_class_init,
			(GtkObjectInitFunc) slider_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		slider_type = gtk_type_unique( TYPE_CLASSMODEL, &info );
	}

	return( slider_type );
}

Classmodel *
slider_new( Rhs *rhs )
{
	Slider *slider = gtk_type_new( TYPE_SLIDER );

	model_child_add( MODEL( rhs ), MODEL( slider ), -1 );

	return( CLASSMODEL( slider ) );
}
