/* Decls for paintboxview.c ... widgets in the paint bar
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* Update children during paint.
 */
#define PAINTBOX_RECOMP (watch_bool_get( "PAINTBOX_RECOMP", TRUE ))

/* Default font.
 */
#define PAINTBOX_FONT (watch_string_get( "PAINTBOX_FONT", \
	"-*-times-medium-r-normal--24-*-*-*-*-*-*-*" ))

/* Max undo steps ... -1 == unlimited.
 */
#define PAINTBOX_MAX_UNDO (watch_int_get( "PAINTBOX_MAX_UNDO", -1 ))

/* Paint tools.
 */
typedef enum _PaintboxTool {
	PAINTBOX_DROPPER = 0,		/* Ink dropper */
	PAINTBOX_PEN,			/* Pen */
	PAINTBOX_LINE,			/* Line drawing tool */
	PAINTBOX_RECT,			/* Rectangle tool */
	PAINTBOX_FLOOD,			/* Flood-fill tool */
	PAINTBOX_BLOB,			/* Blob flood-fill tool */
	PAINTBOX_TEXT,			/* Text tool */
	PAINTBOX_SMUDGE			/* Smudge tool */
} PaintboxTool;

/* Paint nibs.
 */
typedef enum _PaintboxNib {
	PAINTBOX_1ROUND = 0,
	PAINTBOX_2ROUND,
	PAINTBOX_3ROUND,
	PAINTBOX_4ROUND,
	PAINTBOX_5ROUND,
	PAINTBOX_6ROUND,
	PAINTBOX_10ROUND,
	PAINTBOX_2ITALIC,
	PAINTBOX_3ITALIC,
	PAINTBOX_4ITALIC,
	PAINTBOX_5ITALIC,
	PAINTBOX_6ITALIC,
	PAINTBOX_10ITALIC
} PaintboxNib;

extern iWindowShape paintboxview_shape[];

#define TYPE_PAINTBOXVIEW (paintboxview_get_type())
#define PAINTBOXVIEW( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_PAINTBOXVIEW, Paintboxview ))
#define PAINTBOXVIEW_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_PAINTBOXVIEW, PaintboxviewClass ))
#define IS_PAINTBOXVIEW( obj ) (GTK_CHECK_TYPE( (obj), TYPE_PAINTBOXVIEW ))
#define IS_PAINTBOXVIEW_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_PAINTBOXVIEW ))

struct _Paintboxview {
	GtkFrame parent_class;

	/* The image we are painting on.
	 */
	Imageview *iv;

	/* Keep model stuff on iv->conv.
	 */
	guint conv_changed_sid;
	guint conv_destroy_sid;

	/* Spot undo/redo changes on iv->conv->ii.
	 */
	guint ii_undo_changed_sid;
	guint ii_destroy_sid;
	Imageinfo *ii;		/* The ii we attached the signals to */

	GtkWidget *undo;
	GtkWidget *redo;
	GtkWidget *clear;
	GtkWidget *tool;
	GtkWidget *nib;
	GtkWidget *ink;
	GtkWidget *font;
	GtkWidget *text;
};

typedef struct _PaintboxviewClass {
	GtkFrameClass parent_class;

	/* My methods.
	 */
} PaintboxviewClass;

GtkType paintboxview_get_type( void );
Paintboxview *paintboxview_new( Imageview *iv );
