/* Imagepresent widget stuff.
 */

/*

    Copyright (C) 1991-2001 The Natoinal Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#define TYPE_IMAGEPRESENT (imagepresent_get_type())
#define IMAGEPRESENT(obj) GTK_CHECK_CAST( obj, \
	imagepresent_get_type(), Imagepresent )
#define IMAGEPRESENT_CLASS(klass)  GTK_CHECK_CLASS_CAST( klass, \
	imagepresent_get_type(), ImagepresentClass )
#define IS_IMAGEPRESENT(obj) GTK_CHECK_TYPE( obj, imagepresent_get_type() )

/* States we can be in ... modal stuff, scarey.
 */
typedef enum _ImagepresentState {
	IMAGEPRESENT_STATE_SELECT = 0,	/* Pointer */
	IMAGEPRESENT_STATE_PAN,		/* Hand panner */
	IMAGEPRESENT_STATE_MAGIN,	/* Zoom in */
	IMAGEPRESENT_STATE_MAGOUT,	/* Zoom out */
	IMAGEPRESENT_STATE_PAINT,       /* Painting */
	IMAGEPRESENT_STATE_LAST	
} ImagepresentState;

/* Track an image view canvas in one of these.
 */
struct _Imagepresent {
	GtkVBox parent_class;	/* Main layout vbox */

	/* Context.
	 */
	Iimage *iimage;		/* Iimage we represent, if any */

	/* Sub-widgets.
	 */
	Imagedisplay *id;	/* Image we display */
	GtkHScrollbar *hbar;	/* Scrollbars */
	GtkVScrollbar *vbar;
	GtkHRuler *hrule;	/* Rulers */
	GtkVRuler *vrule;
	GtkEventBox *heb;	/* EventBoxes holding rulers */
	GtkEventBox *veb;
	GtkTooltips *tooltips;
	GtkAccelGroup *group;	/* Popup menu stuff */
	GtkWidget *menu;
	GtkWidget *tool[IMAGEPRESENT_STATE_LAST];

	/* Need to spot changes to our conversion.
	 */
	guint conv_changed_sid;
	Imageinfo *last_paint_ii;

	/* Input state, and a saved state during temp actions.
	 */
	ImagepresentState state;
	ImagepresentState save_state; 
	iWindowCursorContext *cntxt;

	/* Panning stuff.
	 */
	guint dx, dy;		/* Drag start position */

	/* Display state of widgets.
	 */
	gboolean show_rulers;	/* Rulers shown/not */

	/* Last known mouse position, mouse in window.
	 */
	int last_x, last_y;
	gboolean inside;

	/* Background scroll stuff.
	 */
	gint scroll_timeout;
	int u, v;

	/* Rubberbanding.
	 */
	Regionview *regionview;	/* region rubberband display */
	Rect floating;		/* rubberband area */

	/* Painting stuff.
	 */
	int paint_last_x;
	int paint_last_y;

	/* Regionviews drawing on us. Used for snap-to-guide stuff.
	 */
	GSList *regionviews;
};

/* Class structure.
 */
typedef struct _ImagepresentClass {
	/* Our parent.
	 */
	GtkVBoxClass parent_class;

	/* Signals.
	 */
	void (*changed)( Imagepresent * );
} ImagepresentClass;

void imagepresent_set_state( Imagepresent *ip, ImagepresentState state );

gboolean imagepresent_snap_point( Imagepresent *ip, 
	int x, int y, int *sx, int *sy );
gboolean imagepresent_snap_rect( Imagepresent *ip, Rect *in, Rect *out );

void imagepresent_paint_recalc( Imagepresent *ip );

guint imagepresent_get_type( void );
Imagepresent *imagepresent_new( Iimage *iimage, Conversion *conv );

void imagepresent_set_position( Imagepresent *ip, int x, int w );
void imagepresent_rulers( Imagepresent *ip, gboolean show );

void imagepresent_scroll_start( Imagepresent *ip, int u, int v );
void imagepresent_scroll_stop( Imagepresent *ip );
