/* an image class object in a workspace
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
iimage_instance_destroy( IimageInstance *instance )
{
	FREEF( imageinfo_destroy_nonheap, instance->image );
}

static void
iimage_instance_init( IimageInstance *instance )
{
	instance->image = NULL;
}

static gboolean
iimage_instance_update( IimageInstance *instance, PElement *root )
{
	Imageinfo *image;

	if( !class_get_member_image( root, MEMBER_VALUE, &image ) )
		return( FALSE );

	FREEF( imageinfo_destroy_nonheap, instance->image );
	instance->image = image;
	if( image )
		imageinfo_dup_nonheap( image );

#ifdef DEBUG
	printf( "iimage_instance_update: ii = 0x%x\n", (unsigned int) image );
#endif /*DEBUG*/

	return( TRUE );
}

static void
iimage_destroy( GtkObject *object )
{
	Iimage *iimage;

#ifdef DEBUG
	printf( "iimage_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_IIMAGE( object ) );

	iimage = IIMAGE( object );

	/* My instance destroy stuff.
	 */
	iimage_instance_destroy( &iimage->instance );

	FREEF( g_slist_free, iimage->views );

	slist_map( iimage->classmodels, 
		(SListMapFn) classmodel_iimage_unlink, iimage );
	assert( !iimage->classmodels );

	buf_destroy( &iimage->caption );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void
iimage_edit( GtkWidget *parent, Model *model )
{
        Iimage *iimage = IIMAGE( model );

	if( iimage->instance.image ) {
		Imageview *iv;

		iv = imageview_new( iimage );
		gtk_widget_show( GTK_WIDGET( iv ) );
	}
}

static xmlNode *
iimage_save( Model *model, xmlNode *xnode )
{
        Iimage *iimage = IIMAGE( model );
	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	/* We always rebuild the value from the expr ... don't save.
	 */
	if( !set_prop( xthis, "window_x", "%d", iimage->window_x ) ||
		!set_prop( xthis, "window_y", "%d", iimage->window_y ) ||
		!set_prop( xthis, "window_width", 
			"%d", iimage->window_width ) ||
		!set_prop( xthis, "window_height", 
			"%d", iimage->window_height ) ||
		!set_prop( xthis, "image_left", "%d", iimage->image_left ) ||
		!set_prop( xthis, "image_top", "%d", iimage->image_top ) ||
		!set_prop( xthis, "image_mag", "%d", iimage->image_mag ) ||
		!set_prop( xthis, "show_status", 
			bool_to_char( iimage->show_status ) ) ||
		!set_prop( xthis, "show_paintbox", 
			bool_to_char( iimage->show_paintbox ) ) ||
		!set_prop( xthis, "show_convert", 
			bool_to_char( iimage->show_convert ) ) ||
		!set_prop( xthis, "show_rulers", 
			bool_to_char( iimage->show_rulers ) ) ||
		!set_prop( xthis, "scale", "%g", iimage->scale ) ||
		!set_prop( xthis, "offset", "%g", iimage->offset ) )
		return( NULL );

	return( xthis );
}

static gboolean
iimage_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
        Iimage *iimage = IIMAGE( model );

	if( !IS_RHS( parent ) ) {
		ierrors( "iimage_load: can only add an iimage to a rhs" );
		return( FALSE );
	}

	(void) get_iprop( xnode, "window_x", &iimage->window_x );
	(void) get_iprop( xnode, "window_y", &iimage->window_y );
	(void) get_iprop( xnode, "window_width", &iimage->window_width );
	(void) get_iprop( xnode, "window_height", &iimage->window_height );
	(void) get_iprop( xnode, "image_left", &iimage->image_left );
	(void) get_iprop( xnode, "image_top", &iimage->image_top );
	(void) get_iprop( xnode, "image_mag", &iimage->image_mag );
	(void) get_bprop( xnode, "show_status", &iimage->show_status );
	(void) get_bprop( xnode, "show_paintbox", &iimage->show_paintbox );
	(void) get_bprop( xnode, "show_convert", &iimage->show_convert );
	(void) get_bprop( xnode, "show_rulers", &iimage->show_rulers );
	(void) get_dprop( xnode, "scale", &iimage->scale );
	(void) get_dprop( xnode, "offset", &iimage->offset );

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

static void *
iimage_update_model( Heapmodel *heapmodel )
{
	Iimage *iimage = IIMAGE( heapmodel );
	Expr *expr = HEAPMODEL( iimage )->row->expr;

#ifdef DEBUG
	printf( "iimage_update_model: " );
	row_name_print( HEAPMODEL( iimage )->row );
	printf( "\n" );
#endif /*DEBUG*/

	/* Parent will update our instance.
	 */
	if( HEAPMODEL_CLASS( parent_class )->update_model( heapmodel ) )
		return( heapmodel );

	/* Remake the caption.
	 */
	buf_rewind( &iimage->caption );

	/* Try to display the class name for the object ... fall back to
	 * CLASS_IMAGE if we can't find anything.
	 */
	if( expr && PEISCLASS( &expr->root ) ) 
		symbol_qualified_name( 
			PEGETCLASSCOMPILE( &expr->root )->sym,
			&iimage->caption );
	else
		buf_appends( &iimage->caption, CLASS_IMAGE );
	buf_appends( &iimage->caption, " " );

	if( iimage->instance.image )
		imageinfo_info( iimage->instance.image, &iimage->caption );

	/* Various things (eg. statusview) need the updated caption ... 
	 * signal another change.
	 */
	model_changed( MODEL( iimage ) );

	return( NULL );
}

/* Need to implement _update_heap(), as not all model fields are directly
 * editable ... some are set only from expr. See also iregion.c.
 */
static void *
iimage_update_heap( Heapmodel *heapmodel )
{
	Expr *expr = heapmodel->row->expr;
        Iimage *iimage = IIMAGE( heapmodel );
	IimageInstance *instance = &iimage->instance;

	PElement pe;

#ifdef DEBUG
	printf( "iimage_update_heap: " );
	row_name_print( HEAPMODEL( iimage )->row );
	printf( "\n" );
#endif /*DEBUG*/

	/* Read the heap into the model, over the top of the unapplied edits.
	 */
	if( !class_get_exact( &expr->root, MODEL( heapmodel )->name, &pe ) )
		return( FALSE );
	if( !iimage_instance_update( instance, &pe ) )
		return( heapmodel );

	/* Classmodel _update_heap() will do _instance_new() from the fixed up
	 * model.
	 */
	return( HEAPMODEL_CLASS( parent_class )->update_heap( heapmodel ) );
}

/* Update Iimage from heap.
 */
static gboolean
iimage_class_get( Classmodel *classmodel, PElement *root )
{
        Iimage *iimage = IIMAGE( classmodel );
	IimageInstance *instance = &iimage->instance;

#ifdef DEBUG
	printf( "iimage_class_get: " );
	row_name_print( HEAPMODEL( iimage )->row );
	printf( "\n" );
#endif /*DEBUG*/

	if( !iimage_instance_update( instance, root ) )
		return( FALSE );

	return( CLASSMODEL_CLASS( parent_class )->class_get( 
		classmodel, root ) );
}

/* Make a new "fn value" application.
 */
static gboolean
iimage_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *hi = reduce_context->hi;
        Iimage *iimage = IIMAGE( classmodel );
	IimageInstance *instance = &iimage->instance;

	PElement rhs;

#ifdef DEBUG
	printf( "iimage_class_new: " );
	row_name_print( HEAPMODEL( iimage )->row );
	printf( "\n" );
#endif /*DEBUG*/

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( hi, out, &rhs ) ||
		!heap_image_new( hi, instance->image, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
iimage_graphic_save_cb( iWindow *iwnd, 
	void *client, iWindowNotifyFn nfn, void *sys )
{
	Filesel *filesel = FILESEL( iwnd );
	const char *filename = filesel_get_filename( filesel );
	Iimage *iimage = IIMAGE( client );
	IimageInstance *instance = &iimage->instance;

	char buf[NAMELEN];

	strcpy( buf, filename );
	filesel_add_mode( buf );

	if( !imageinfo_write( instance->image, buf ) ) {
		nfn( sys, IWINDOW_ERROR );
		return;
	}

	nfn( sys, IWINDOW_TRUE );
}

static void
iimage_graphic_save( GtkWidget *parent, Classmodel *classmodel )
{
	Iimage *iimage = IIMAGE( classmodel );
	IimageInstance *instance = &iimage->instance;
	GtkWidget *filesel = filesel_new();
	BufInfo buf;
	char txt[100];

	buf_init_static( &buf, txt, 100 );
	row_qualified_name( HEAPMODEL( iimage )->row, &buf );
	iwindow_set_title( IWINDOW( filesel ), 
		"Save Image %s", buf_all( &buf ) );
	filesel_set_flags( FILESEL( filesel ), TRUE, TRUE );
	filesel_set_type( FILESEL( filesel ), 
		filesel_type_image, IMAGE_FILE_TYPE ); 
	idialog_set_parent( IDIALOG( filesel ), parent );
	filesel_set_done( FILESEL( filesel ), 
		iimage_graphic_save_cb, classmodel );
	iwindow_build( IWINDOW( filesel ) );

	if( instance->image && instance->image->name )
		filesel_set_filename( FILESEL( filesel ), 
			instance->image->name );

	gtk_widget_show( GTK_WIDGET( filesel ) );
}

gboolean
iimage_replace( Iimage *iimage, const char *filename )
{
	Row *row = HEAPMODEL( iimage )->row;
	iText *itext = ITEXT( HEAPMODEL( iimage )->rhs->itext );
	char txt[MAX_STRSIZE];
	BufInfo buf;

	buf_init_static( &buf, txt, MAX_STRSIZE );
	buf_appends( &buf, "Image_file \"" );
	buf_appendsc( &buf, filename );
	buf_appends( &buf, "\"" );

	itext_set_formula( itext, buf_all( &buf ) );
	itext_set_edited( itext, TRUE );
	(void) expr_dirty( row->expr, link_serial_new() );

	symbol_recalculate_all();

	return( TRUE );
}

static void
iimage_graphic_replace_cb( iWindow *iwnd, 
	void *client, iWindowNotifyFn nfn, void *sys )
{
	Filesel *filesel = FILESEL( iwnd );
	const char *filename = filesel_get_filename( filesel );
	Iimage *iimage = IIMAGE( client );

	(void) iimage_replace( iimage, filename );

	nfn( sys, IWINDOW_TRUE );
}

static void
iimage_graphic_replace( GtkWidget *parent, Classmodel *classmodel )
{
	Iimage *iimage = IIMAGE( classmodel );
	IimageInstance *instance = &iimage->instance;
	GtkWidget *filesel = filesel_new();
	BufInfo buf;
	char txt[100];

	buf_init_static( &buf, txt, 100 );
	row_qualified_name( HEAPMODEL( iimage )->row, &buf );
	iwindow_set_title( IWINDOW( filesel ), 
		"Replace Image", buf_all( &buf ) );
	filesel_set_flags( FILESEL( filesel ), TRUE, FALSE );
	filesel_set_type( FILESEL( filesel ), 
		filesel_type_image, IMAGE_FILE_TYPE ); 
	idialog_set_parent( IDIALOG( filesel ), parent );
	filesel_set_done( FILESEL( filesel ), 
		iimage_graphic_replace_cb, classmodel );
	iwindow_build( IWINDOW( filesel ) );

	if( instance->image && instance->image->name )
		filesel_set_filename( FILESEL( filesel ), 
			instance->image->name );

	gtk_widget_show( GTK_WIDGET( filesel ) );
}

static void
iimage_class_init( IimageClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	HeapmodelClass *heapmodel_class = (HeapmodelClass *) klass;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) klass;

	parent_class = gtk_type_class( TYPE_CLASSMODEL );

	object_class->destroy = iimage_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = iimageview_new;
	model_class->edit = iimage_edit;
	model_class->save = iimage_save;
	model_class->load = iimage_load;

	heapmodel_class->update_model = iimage_update_model;
	heapmodel_class->update_heap = iimage_update_heap;

	classmodel_class->class_get = iimage_class_get;
	classmodel_class->class_new = iimage_class_new;
	classmodel_class->graphic_save = iimage_graphic_save;
	classmodel_class->graphic_replace = iimage_graphic_replace;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( klass ) );
}

static void
iimage_init( Iimage *iimage )
{
	iimage_instance_init( &iimage->instance );

	iimage->classmodels = NULL;

	iimage->views = NULL;

	iimage->window_x = -1;
	iimage->window_y = -1;
	iimage->window_width = -1;
	iimage->window_height = -1;
	iimage->image_left = -1;
	iimage->image_top = -1;
	iimage->image_mag = -1;

	iimage->show_status = FALSE;
	iimage->show_paintbox = FALSE;
	iimage->show_convert = FALSE;
	iimage->show_rulers = FALSE;

	iimage->scale = -1.0;
	iimage->offset = -1.0;

	buf_init_dynamic( &iimage->caption, MAX_LINELENGTH );

	model_set( MODEL( iimage ), CLASS_IMAGE, NULL );
}

GtkType
iimage_get_type( void )
{
	static GtkType iimage_type = 0;

	if( !iimage_type ) {
		static const GtkTypeInfo info = {
			"Iimage",
			sizeof( Iimage ),
			sizeof( IimageClass ),
			(GtkClassInitFunc) iimage_class_init,
			(GtkObjectInitFunc) iimage_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		iimage_type = gtk_type_unique( TYPE_CLASSMODEL, &info );
	}

	return( iimage_type );
}

Classmodel *
iimage_new( Rhs *rhs )
{
	Iimage *iimage = gtk_type_new( TYPE_IIMAGE );

	model_child_add( MODEL( rhs ), MODEL( iimage ), -1 );

	return( CLASSMODEL( iimage ) );
}
