/* run the display for an arrow in a workspace 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
iarrowview_destroy( GtkObject *object )
{
	Iarrowview *iarrowview;

#ifdef DEBUG
	printf( "iarrowview_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_IARROWVIEW( object ) );

	iarrowview = IARROWVIEW( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void 
iarrowview_refresh( View *view )
{
	Iarrowview *iarrowview = IARROWVIEW( view );
	Iarrow *iarrow = IARROW( view->model );

#ifdef DEBUG
	printf( "iarrowview_refresh: " );
	row_name_print( HEAPMODEL( iarrow )->row );
	printf( "\n" );
#endif /*DEBUG*/

	set_glabel( iarrowview->label, "%s", buf_all( &iarrow->caption ) );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
iarrowview_class_init( IarrowviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = iarrowview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->refresh = iarrowview_refresh;
}

static void
iarrowview_single_cb( GtkWidget *wid, Iarrowview *iarrowview )
{
	Iarrow *iarrow = IARROW( VIEW( iarrowview )->model );

	row_select( HEAPMODEL( iarrow )->row );
}

static void
iarrowview_double_cb( GtkWidget *wid, Iarrowview *iarrowview )
{
	Iarrow *iarrow = IARROW( VIEW( iarrowview )->model );

	if( CLASSMODEL( iarrow )->iimages ) 
		/* Don't pop the edit method ... instead, open an image view
		 * for the image that the arrow is defined on.
		 */
		(void) imageview_new_area( 
			IIMAGE( CLASSMODEL( iarrow )->iimages->data ),
			&iarrow->instance.area );
	else
		model_edit( wid, MODEL( iarrow ) );
}

static void
iarrowview_init( Iarrowview *iarrowview )
{
	GtkWidget *eb;

#ifdef DEBUG
	printf( "iarrowview_init\n" );
#endif /*DEBUG*/

        eb = gtk_event_box_new();
        gtk_box_pack_start( GTK_BOX( iarrowview ), eb, FALSE, FALSE, 0 );
	iarrowview->label = gtk_label_new( "" );
        gtk_misc_set_alignment( GTK_MISC( iarrowview->label ), 0, 0.5 );
        gtk_misc_set_padding( GTK_MISC( iarrowview->label ), 2, 0 );
        gtk_container_add( GTK_CONTAINER( eb ), iarrowview->label );
	set_name( eb, "caption_widget" );

        doubleclick_add( GTK_WIDGET( eb ), FALSE,
                iarrowview_single_cb, iarrowview, 
		iarrowview_double_cb, iarrowview );

        gtk_widget_show_all( GTK_WIDGET( iarrowview ) );
}

GtkType
iarrowview_get_type( void )
{
	static GtkType iarrowview_type = 0;

	if( !iarrowview_type ) {
		static const GtkTypeInfo info = {
			"Iarrowview",
			sizeof( Iarrowview ),
			sizeof( IarrowviewClass ),
			(GtkClassInitFunc) iarrowview_class_init,
			(GtkObjectInitFunc) iarrowview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		iarrowview_type = gtk_type_unique( TYPE_VIEW, &info );
	}

	return( iarrowview_type );
}

View *
iarrowview_new( void )
{
	Iarrowview *iarrowview = gtk_type_new( TYPE_IARROWVIEW );

	return( VIEW( iarrowview ) );
}
