/* base class for models of heap classes
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ModelClass *parent_class = NULL;

/* Trigger the new_heap method for a heapmodel.
 */
void *
heapmodel_new_heap( Heapmodel *heapmodel, PElement *root )
{
	HeapmodelClass *klass;

	if( !heapmodel )
		return( NULL );

	klass = HEAPMODEL_CLASS( GTK_OBJECT( heapmodel )->klass );

	if( klass->new_heap ) {
		void *res;
		
		res = klass->new_heap( heapmodel, root );

		return( res );
	}

	return( NULL );
}

/* Trigger the update_model method for a heapmodel.
 */
void *
heapmodel_update_model( Heapmodel *heapmodel )
{
	HeapmodelClass *klass;

	if( !heapmodel )
		return( NULL );

	klass = HEAPMODEL_CLASS( GTK_OBJECT( heapmodel )->klass );

#ifdef DEBUG
	printf( "heapmodel_update_model: %s ",
		OBJECT_CLASS_NAME( heapmodel ) );
	row_name_print( heapmodel->row );
	printf( " modified = %d\n", heapmodel->modified );
#endif /*DEBUG*/

	if( klass->update_model && !heapmodel->modified ) {
		void *res;

		res = klass->update_model( heapmodel );

		return( res );
	}

	return( NULL );
}

/* Trigger the update_heap method for a model.
 */
void *
heapmodel_update_heap( Heapmodel *heapmodel )
{
	HeapmodelClass *klass;

	if( !heapmodel )
		return( NULL );

	klass = HEAPMODEL_CLASS( GTK_OBJECT( heapmodel )->klass );

	if( klass->update_heap && heapmodel->modified ) {
		void *res;

		res = klass->update_heap( heapmodel );

		return( res );
	}

	return( NULL );
}

/* Trigger the clear_edited method for a heapmodel.
 */
void *
heapmodel_clear_edited( Heapmodel *heapmodel )
{
	HeapmodelClass *klass;

	if( !heapmodel )
		return( NULL );

	klass = HEAPMODEL_CLASS( GTK_OBJECT( heapmodel )->klass );

	if( klass->clear_edited )
		return( klass->clear_edited( heapmodel ) );

	return( NULL );
}

static void
heapmodel_destroy( GtkObject *object )
{
	Heapmodel *heapmodel;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_HEAPMODEL( object ) );

	heapmodel = HEAPMODEL( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static Rhs *
heapmodel_get_rhs( Heapmodel *heapmodel )
{
	Model *p;

	/* Search for the enclosing RHS ... may not be one if (eg.) this is a
	 * top-level row.
	 */
	for( p = MODEL( heapmodel )->parent; p; p = p->parent )
		if( IS_RHS( p ) )
			return( RHS( p ) );

	return( NULL );
}

static Row *
heapmodel_get_row( Heapmodel *heapmodel )
{
	Rhs *rhs;

	if( IS_RHS( heapmodel ) )
		return( ROW( MODEL( heapmodel )->parent ) );
	else if( (rhs = heapmodel_get_rhs( heapmodel )) )
		return( HEAPMODEL( rhs )->row );
	else
		return( NULL );
}

static void
heapmodel_parent_add( Model *child, Model *parent )
{
	Heapmodel *heapmodel = HEAPMODEL( child );

	assert( IS_HEAPMODEL( parent ) || IS_FILEMODEL( parent ) ); 

	MODEL_CLASS( parent_class )->parent_add( child, parent );

	/* Update our context.
	 */
	heapmodel->rhs = heapmodel_get_rhs( heapmodel );
	heapmodel->row = heapmodel_get_row( heapmodel );
}

static void *
heapmodel_real_new_heap( Heapmodel *heapmodel, PElement *root )
{
	model_changed( MODEL( heapmodel ) );

	return( NULL );
}

static void *
heapmodel_real_update_model( Heapmodel *heapmodel )
{
	model_changed( MODEL( heapmodel ) );

	return( NULL );
}

static void *
heapmodel_real_update_heap( Heapmodel *heapmodel )
{
	assert( heapmodel->modified );

	heapmodel_set_modified( heapmodel, FALSE );

	return( NULL );
}

static void *
heapmodel_real_clear_edited( Heapmodel *heapmodel )
{
	return( NULL );
}

static void
heapmodel_class_init( HeapmodelClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	HeapmodelClass *heapmodel_class = (HeapmodelClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;

	parent_class = gtk_type_class( TYPE_MODEL );

	object_class->destroy = heapmodel_destroy;

	/* Init methods.
	 */
	model_class->parent_add = heapmodel_parent_add;

	heapmodel_class->new_heap = heapmodel_real_new_heap;
	heapmodel_class->update_heap = heapmodel_real_update_heap;
	heapmodel_class->update_model = heapmodel_real_update_model;
	heapmodel_class->clear_edited = heapmodel_real_clear_edited;
}

static void
heapmodel_init( Heapmodel *heapmodel )
{
        heapmodel->row = NULL;
        heapmodel->rhs = NULL;

	heapmodel->modified = FALSE;
}

GtkType
heapmodel_get_type( void )
{
	static GtkType heapmodel_type = 0;

	if( !heapmodel_type ) {
		static const GtkTypeInfo info = {
			"Heapmodel",
			sizeof( Heapmodel ),
			sizeof( HeapmodelClass ),
			(GtkClassInitFunc) heapmodel_class_init,
			(GtkObjectInitFunc) heapmodel_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		heapmodel_type = gtk_type_unique( TYPE_MODEL, &info );
	}

	return( heapmodel_type );
}

void
heapmodel_set_modified( Heapmodel *heapmodel, gboolean modified )
{
	if( heapmodel->modified != modified ) {
#ifdef DEBUG
		printf( "heapmodel_set_modified: " );
		row_name_print( heapmodel->row );
		printf( " %s\n", bool_to_char( modified ) );
#endif /*DEBUG*/

		heapmodel->modified = modified;
		model_changed( MODEL( heapmodel ) );
	}
}
