/* Declarations for ifileselect.c
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

/* Suffix sets we support.
 */
extern GtkFileSelection2FileType *filesel_type_workspace[];
extern GtkFileSelection2FileType *filesel_type_image[];
extern GtkFileSelection2FileType *filesel_type_matrix[];
extern GtkFileSelection2FileType *filesel_type_definition[];
extern GtkFileSelection2FileType *filesel_type_any[];

/* Subclass off gtkfilesel2.c to make one of our fileselectors.
 */
#define TYPE_FILESEL (filesel_get_type())
#define FILESEL( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_FILESEL, Filesel ))
#define FILESEL_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_FILESEL, FileselClass ))
#define IS_FILESEL( obj ) (GTK_CHECK_TYPE( (obj), TYPE_FILESEL ))
#define IS_FILESEL_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_FILESEL ))

typedef struct _Filesel {
	GtkFileSelection2 parent;

        /* Widgets.
         */
        GtkWidget *space;               /* Space available */
        GtkWidget *info;                /* File info */

	/* State. 
	 */
	gboolean incr;			/* True for increment filename */
	gboolean imls;			/* True if this is image load/save */
	gboolean save;			/* True if this is a save dialog */
	struct _Browse *browse;		/* Browse window */
	GtkFileSelection2FileType **type;
	int default_type;

	iWindowFn done_cb;		/* On OK */
	void *client;
} Filesel;

typedef struct _FileselClass {
	GtkFileSelection2Class parent_class;

	/* My methods.
	 */
} FileselClass;

typedef void *(*FileselMapFn)( Filesel *, const char *, void *, void * );

void filesel_add_mode( char *filename );

GtkType filesel_get_type( void );
GtkWidget *filesel_new( void );

gboolean filesel_set_filename( Filesel *filesel, const char *name );
const char *filesel_get_filename( Filesel *filesel );
void *filesel_map_filename_multi( Filesel *filesel,
	FileselMapFn fn, void *a, void *b );
char *filesel_get_dir( Filesel *filesel, char *buf );
const char *filesel_get_name( Filesel *filesel );

void filesel_set_done( Filesel *filesel, iWindowFn done_cb, void *client );
void filesel_set_type( Filesel *filesel, 
	GtkFileSelection2FileType **type, int default_type );
void filesel_set_flags( Filesel *filesel, gboolean imls, gboolean save );
