/* an input filename ... put/get methods
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
filename_destroy( GtkObject *object )
{
	Filename *filename;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_FILENAME( object ) );

	filename = FILENAME( object );

	/* My instance destroy stuff.
	 */
	FREE( filename->value );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void
filename_edit_ok( iWindow *iwnd, 
	void *client, iWindowNotifyFn nfn, void *sys )
{
	Filesel *filesel = FILESEL( iwnd );
	Filename *filename = FILENAME( client );

	SETSTR( filename->value, filesel_get_filename( filesel ) );
	classmodel_update( CLASSMODEL( filename ) );
	symbol_recalculate_all();

	nfn( sys, IWINDOW_TRUE );
}

/* Pop up a filename edit box.
 */
static void 
filename_edit( GtkWidget *parent, Model *model )
{
	Filename *filename = FILENAME( model );
	GtkWidget *filesel = filesel_new();

	iwindow_set_title( IWINDOW( filesel ), "Select file" );
	filesel_set_flags( FILESEL( filesel ), TRUE, FALSE );
	filesel_set_type( FILESEL( filesel ), filesel_type_any, 0 );
	idialog_set_parent( IDIALOG( filesel ), parent );
	filesel_set_done( FILESEL( filesel ), filename_edit_ok, filename );
	iwindow_build( IWINDOW( filesel ) );
	filesel_set_filename( FILESEL( filesel ), filename->value );

	gtk_widget_show( GTK_WIDGET( filesel ) );
}

static xmlNode *
filename_save( Model *model, xmlNode *xnode )
{
	Filename *filename = FILENAME( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_prop( xthis, "value", "%s", filename->value ) )
			return( NULL );
	}

	return( xthis );
}

static gboolean
filename_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Filename *filename = FILENAME( model );
	char buf[NAMELEN];

	if( !IS_RHS( parent ) ) {
		ierrors( "filename_load: can only add a filename to a Rhs" );
		return( FALSE );
	}

	if( get_sprop( xnode, "value", buf, NAMELEN ) ) {
		classmodel_set_edited( CLASSMODEL( model ), TRUE );
		SETSTR( filename->value, buf );
	}

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

/* Update Filename from heap.
 */
static gboolean
filename_class_get( Classmodel *classmodel, PElement *root )
{
	Filename *filename = FILENAME( classmodel );
	char buf[NAMELEN];

	if( !class_get_member_string( root, MEMBER_VALUE, buf, NAMELEN ) )
		return( FALSE );
	SETSTR( filename->value, buf );

	return( TRUE );
}

/* Make a new "fn value" application.
 */
static gboolean
filename_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *hi = reduce_context->hi;
	Filename *filename = FILENAME( classmodel );
	PElement rhs;

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( hi, out, &rhs ) ||
		!heap_string_new( hi, filename->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
filename_class_init( FilenameClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ModelClass *model_class = (ModelClass *) klass;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) klass;

	parent_class = gtk_type_class( TYPE_CLASSMODEL );

	object_class->destroy = filename_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = filenameview_new;
	model_class->edit = filename_edit;
	model_class->save = filename_save;
	model_class->load = filename_load;

	classmodel_class->class_get = filename_class_get;
	classmodel_class->class_new = filename_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( klass ) );
}

static void
filename_init( Filename *filename )
{
	/* Overridden later. Just something sensible.
	 */
	filename->value = NULL;

	model_set( MODEL( filename ), CLASS_FILENAME, NULL );
}

GtkType
filename_get_type( void )
{
	static GtkType filename_type = 0;

	if( !filename_type ) {
		static const GtkTypeInfo info = {
			"Filename",
			sizeof( Filename ),
			sizeof( FilenameClass ),
			(GtkClassInitFunc) filename_class_init,
			(GtkObjectInitFunc) filename_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		filename_type = gtk_type_unique( TYPE_CLASSMODEL, &info );
	}

	return( filename_type );
}

Classmodel *
filename_new( Rhs *rhs )
{
	Filename *filename = gtk_type_new( TYPE_FILENAME );

	model_child_add( MODEL( rhs ), MODEL( filename ), -1 );

	return( CLASSMODEL( filename ) );
}
