/*
 * ngtcp2
 *
 * Copyright (c) 2022 ngtcp2 contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef NGTCP2_CRYPTO_PICOTLS_H
#define NGTCP2_CRYPTO_PICOTLS_H

#include <ngtcp2/ngtcp2.h>

#include <picotls.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @struct
 *
 * :type:`ngtcp2_crypto_picotls_ctx` contains per-connection state
 * of Picotls objects and must be an object to bet set to
 * `ngtcp2_conn_set_tls_native_handle`.
 */
typedef struct ngtcp2_crypto_picotls_ctx {
  /**
   * :member:`ptls` is a pointer to ptls_t object.
   */
  ptls_t *ptls;
  /**
   * :member:`handshake_properties` is a set of configurations used
   * during this particular TLS handshake.
   */
  ptls_handshake_properties_t handshake_properties;
  /**
   * :member:`alert` is a TLS alert generated by the local endpoint.
   */
  uint8_t alert;
} ngtcp2_crypto_picotls_ctx;

/**
 * @function
 *
 * `ngtcp2_crypto_picotls_ctx_init` initializes the object pointed by
 * |cptls|.  |cptls| must not be NULL.
 */
NGTCP2_EXTERN void
ngtcp2_crypto_picotls_ctx_init(ngtcp2_crypto_picotls_ctx *cptls);

/**
 * @function
 *
 * `ngtcp2_crypto_picotls_from_epoch` translates |epoch| to
 * :type:`ngtcp2_crypto_level`.  This function is only available for
 * Picotls backend.
 */
NGTCP2_EXTERN ngtcp2_crypto_level
ngtcp2_crypto_picotls_from_epoch(size_t epoch);

/**
 * @function
 *
 * `ngtcp2_crypto_picotls_from_ngtcp2_crypto_level` translates
 * |crypto_level| to epoch.  This function is only available for
 * Picotls backend.
 */
NGTCP2_EXTERN size_t ngtcp2_crypto_picotls_from_ngtcp2_crypto_level(
    ngtcp2_crypto_level crypto_level);

#ifdef __cplusplus
}
#endif

#endif /* NGTCP2_CRYPTO_PICOTLS_H */
