/* Copyright (C) 2004 Per Johansson
	
	This file is part of netGo.

    netGo is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    netGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with netGo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qstring.h>
#include <qmessagebox.h>
#include <qvaluevector.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qsettings.h>

#include "profile.h"

// Allocate memory for this static variable and make it global.
QValueVector<Profile> Profile::profiles;

// Default constructor for class-Profile.
Profile::Profile()
{
}

// Function for importing all the profiles from the
// textfile (profiles.txt) and saving each of them in a vector.
void Profile::fetchProfiles()
{
	// Clear the vector containing the profiles before importing new.
	profiles.clear();
	
	// Create a QSettings object so we can fetch the profiles.
	QSettings settings;
	settings.insertSearchPath(QSettings::Unix, QDir::homeDirPath() + "/.qt");
	
	// Save all the profile names in a stringlist.
	QStringList list = settings.subkeyList("/netgo/profiles");
	
	// Loop through the stringlist and save every 
	// profile and its settings in an object (for runtime storing).
	for (QStringList::iterator it = list.begin(); it != list.end(); it++) 
	{
		// Create an object to save the profile and its settings in.
		Profile temp;
		
		// Enter the appropriate key group.
		settings.resetGroup();
		settings.beginGroup("/netgo/profiles/" + *it);
		
		// Import all settings to the object.
		temp.name = *it;
		temp.iface = settings.readEntry("interface");
		temp.ip = settings.readEntry("ip");
		temp.netmask = settings.readEntry("netmask");
		temp.gw = settings.readEntry("gateway");
		temp.ns1 = settings.readEntry("ns1");
		temp.ns2 = settings.readEntry("ns2");
		temp.search = settings.readEntry("search");
		temp.mode = settings.readEntry("mode");
		temp.essid = settings.readEntry("essid");
		temp.key = settings.readEntry("key");
		temp.keyType = settings.readEntry("key type");	
		temp.scriptPath = settings.readEntry("script");
		int pos = temp.scriptPath.findRev("/");
		temp.script = temp.scriptPath.mid(pos+1, 100);
		
		// Insert the object/profile in the profile vector.
		profiles.push_back(temp);
	}
}

// Debug-function for dumping info about a profile.
void Profile::dumpProfiles()
{
	int i;
	for (i=0; i<profiles.size(); i++) 
		qWarning("\n\nName: " + profiles.at(i).name);
}
