/********************************************************************************
 *                              Nepenthes
 *                        - finest collection -
 *
 *
 *
 * Copyright (C) 2005  Paul Baecher & Markus Koetter
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact nepenthesdev@users.sourceforge.net  
 *
 *******************************************************************************/

 /* $Id: sch_dcom_oc192_bind.cpp 2001 2005-09-27 13:54:35Z common $ */

#include <netinet/in.h>

#include "LogManager.hpp"
#include "Message.hpp"
#include "sch_dcom_oc192_bind.hpp"
#include "Socket.hpp"
#include "Nepenthes.hpp"
#include "Utilities.hpp"
#include "DialogueFactoryManager.hpp"
#include "SocketManager.hpp"


#ifdef STDTAGS 
#undef STDTAGS 
#endif
#define STDTAGS l_sc | l_hlr

using namespace nepenthes;

OC192Bind::OC192Bind(ShellcodeManager *shellcodemanager)
{
	m_ShellcodeManager = shellcodemanager;
	m_ShellcodeHandlerName = "OC192Bind";
	m_ShellcodeHandlerDescription = "handles oc192 dcom bindshell";
	m_pcre = NULL;
}

OC192Bind::~OC192Bind()
{

}

bool OC192Bind::Init()
{
	logPF();
	const char *oc192bindpcre = //".*(\\x46\\x00\\x58\\x00\\x4E\\x00\\x42\\x00\\x46\\x00\\x58\\x00\\x46\\x00\\x58\\x00\\x4E\\x00\\x42\\x00\\x46\\x00\\x58\\x00\\x46\\x00\\x58\\x00\\x46\\x00\\x58\\x00\\x46\\x00\\x58\\x00.*\\x6a\\x6d\\xca\\xdd\\xe4\\xf0\\x90\\x80\\x2f\\xa2\\x04).*";
"\\x46\\x00\\x58\\x00\\x4E\\x00\\x42\\x00\\x46\\x00\\x58\\x00\\x46\\x00\\x58\\x00"
"\\x4E\\x00\\x42\\x00\\x46\\x00\\x58\\x00\\x46\\x00\\x58\\x00\\x46\\x00\\x58\\x00"
"\\x46\\x00\\x58\\x00....\\xCC\\xE0\\xFD\\x7F\\xCC\\xE0\\xFD\\x7F"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90"
"\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\xEB\\x19\\x5E\\x31\\xC9\\x81\\xE9\\x89\\xFF"
"\\xFF\\xFF\\x81\\x36\\x80\\xBF\\x32\\x94\\x81\\xEE\\xFC\\xFF\\xFF\\xFF\\xE2\\xF2"
"\\xEB\\x05\\xE8\\xE2\\xFF\\xFF\\xFF\\x03\\x53\\x06\\x1F\\x74\\x57\\x75\\x95\\x80"
"\\xBF\\xBB\\x92\\x7F\\x89\\x5A\\x1A\\xCE\\xB1\\xDE\\x7C\\xE1\\xBE\\x32\\x94\\x09"
"\\xF9\\x3A\\x6B\\xB6\\xD7\\x9F\\x4D\\x85\\x71\\xDA\\xC6\\x81\\xBF\\x32\\x1D\\xC6"
"\\xB3\\x5A\\xF8\\xEC\\xBF\\x32\\xFC\\xB3\\x8D\\x1C\\xF0\\xE8\\xC8\\x41\\xA6\\xDF"
"\\xEB\\xCD\\xC2\\x88\\x36\\x74\\x90\\x7F\\x89\\x5A\\xE6\\x7E\\x0C\\x24\\x7C\\xAD"
"\\xBE\\x32\\x94\\x09\\xF9\\x22\\x6B\\xB6\\xD7\\xDD\\x5A\\x60\\xDF\\xDA\\x8A\\x81"
"\\xBF\\x32\\x1D\\xC6\\xAB\\xCD\\xE2\\x84\\xD7\\xF9\\x79\\x7C\\x84\\xDA\\x9A\\x81"
"\\xBF\\x32\\x1D\\xC6\\xA7\\xCD\\xE2\\x84\\xD7\\xEB\\x9D\\x75\\x12\\xDA\\x6A\\x80"
"\\xBF\\x32\\x1D\\xC6\\xA3\\xCD\\xE2\\x84\\xD7\\x96\\x8E\\xF0\\x78\\xDA\\x7A\\x80"
"\\xBF\\x32\\x1D\\xC6\\x9F\\xCD\\xE2\\x84\\xD7\\x96\\x39\\xAE\\x56\\xDA\\x4A\\x80"
"\\xBF\\x32\\x1D\\xC6\\x9B\\xCD\\xE2\\x84\\xD7\\xD7\\xDD\\x06\\xF6\\xDA\\x5A\\x80"
"\\xBF\\x32\\x1D\\xC6\\x97\\xCD\\xE2\\x84\\xD7\\xD5\\xED\\x46\\xC6\\xDA\\x2A\\x80"
"\\xBF\\x32\\x1D\\xC6\\x93\\x01\\x6B\\x01\\x53\\xA2\\x95\\x80\\xBF\\x66\\xFC\\x81"
"\\xBE\\x32\\x94\\x7F\\xE9\\x2A\\xC4\\xD0\\xEF\\x62\\xD4\\xD0\\xFF\\x62\\x6B\\xD6"
"\\xA3\\xB9\\x4C\\xD7\\xE8\\x5A\\x96(....)\\x4C\\xD5\\x24\\xC5\\xD3"
"\\x40\\x64\\xB4\\xD7\\xEC\\xCD\\xC2\\xA4\\xE8\\x63\\xC7\\x7F\\xE9\\x1A\\x1F\\x50"
"\\xD7\\x57\\xEC\\xE5\\xBF\\x5A\\xF7\\xED\\xDB\\x1C\\x1D\\xE6\\x8F\\xB1\\x78\\xD4"
"\\x32\\x0E\\xB0\\xB3\\x7F\\x01\\x5D\\x03\\x7E\\x27\\x3F\\x62\\x42\\xF4\\xD0\\xA4"
"\\xAF\\x76\\x6A\\xC4\\x9B\\x0F\\x1D\\xD4\\x9B\\x7A\\x1D\\xD4\\x9B\\x7E\\x1D\\xD4"
"\\x9B\\x62\\x19\\xC4\\x9B\\x22\\xC0\\xD0\\xEE\\x63\\xC5\\xEA\\xBE\\x63\\xC5\\x7F"
"\\xC9\\x02\\xC5\\x7F\\xE9\\x22\\x1F\\x4C\\xD5\\xCD\\x6B\\xB1\\x40\\x64\\x98\\x0B"
"\\x77\\x65\\x6B\\xD6\\x93\\xCD\\xC2\\x94\\xEA\\x64\\xF0\\x21\\x8F\\x32\\x94\\x80"
"\\x3A\\xF2\\xEC\\x8C\\x34\\x72\\x98\\x0B\\xCF\\x2E\\x39\\x0B\\xD7\\x3A\\x7F\\x89"
"\\x34\\x72\\xA0\\x0B\\x17\\x8A\\x94\\x80\\xBF\\xB9\\x51\\xDE\\xE2\\xF0\\x90\\x80"
"\\xEC\\x67\\xC2\\xD7\\x34\\x5E\\xB0\\x98\\x34\\x77\\xA8\\x0B\\xEB\\x37\\xEC\\x83"
"\\x6A\\xB9\\xDE\\x98\\x34\\x68\\xB4\\x83\\x62\\xD1\\xA6\\xC9\\x34\\x06\\x1F\\x83"
"\\x4A\\x01\\x6B\\x7C\\x8C\\xF2\\x38\\xBA\\x7B\\x46\\x93\\x41\\x70\\x3F\\x97\\x78"
"\\x54\\xC0\\xAF\\xFC\\x9B\\x26\\xE1\\x61\\x34\\x68\\xB0\\x83\\x62\\x54\\x1F\\x8C"
"\\xF4\\xB9\\xCE\\x9C\\xBC\\xEF\\x1F\\x84\\x34\\x31\\x51\\x6B\\xBD\\x01\\x54\\x0B"
"\\x6A\\x6D\\xCA\\xDD\\xE4\\xF0\\x90\\x80\\x2F\\xA2\\x04";
    


//	logInfo("pcre is %s \n",oc192bindpcre);
    
	const char * pcreEerror;
	int32_t pcreErrorPos;
	if((m_pcre = pcre_compile(oc192bindpcre, PCRE_DOTALL, &pcreEerror, &pcreErrorPos, 0)) == NULL)
	{
		logCrit("OC192Bind could not compile pattern \n\t\"%s\"\n\t Error:\"%s\" at Position %u", 
				oc192bindpcre, pcreEerror, pcreErrorPos);
		return false;
	}
	return true;
}

bool OC192Bind::Exit()
{
	if(m_pcre != NULL)
    	free(m_pcre);
	return true;

}

sch_result OC192Bind::handleShellcode(Message **msg)
{
	logPF();
	logSpam("Shellcode is %i bytes long \n",(*msg)->getSize());
	char *shellcode = (*msg)->getMsg();
	uint32_t len = (*msg)->getSize();



	int32_t ovec[10 * 3];
	int32_t matchCount; 

	if ((matchCount = pcre_exec(m_pcre, 0, (char *) shellcode, len, 0, 0, ovec, sizeof(ovec)/sizeof(int32_t))) > 0)
	{
		uint32_t lport;
		uint16_t sport;
		const char *match;
		

		pcre_get_substring((char *)shellcode, ovec, matchCount, 1, &match);
		memcpy(&lport, match, 4);
		lport ^= 0x9432BF80;
		memcpy(&sport,(char *)&lport+1,2);
		sport = ntohs(sport);
		pcre_free_substring(match);

		logInfo("Detected oc192 listenshell shellcode, :%u \n", sport);

		Socket *socket;
		if ((socket = g_Nepenthes->getSocketMgr()->bindTCPSocket(0,sport,60,30)) == NULL)
		{
			logCrit("%s","Could not bind socket %u \n",sport);
			return SCH_DONE;
		}

		DialogueFactory *diaf;
		if ((diaf = g_Nepenthes->getFactoryMgr()->getFactory("WinNTShell DialogueFactory")) == NULL)
		{
			logCrit("%s","No WinNTShell DialogueFactory availible \n");
			return SCH_DONE;
		}

		socket->addDialogueFactory(diaf);
		return SCH_DONE;
	}
	return SCH_NOTHING;
}
