/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "db.mysql/frontend/db_alter_script.h"

class SourceSelectPage : public WizardPage
{
private:
  DataSourceSelector _left;
  DataSourceSelector _right;

  void left_changed()
  {
    if (_left.model_radio->get_active())
      _right.model_radio->set_enabled(false);
    else
      _right.model_radio->set_enabled(true);

    _left.file_selector.set_enabled(_left.file_radio->get_active());
  }
  
  void right_changed()
  {
    if (_right.model_radio->get_active())
      _left.model_radio->set_enabled(false);
    else
      _left.model_radio->set_enabled(true);

    _right.file_selector.set_enabled(_right.file_radio->get_active());
  }
  
  virtual bool advance()
  {
    const char *sources[]= {
      "model", "server", "file"
    };
    
    values().gset("left_source", sources[get_left_source()]);
    values().gset("right_source", sources[get_right_source()]);
    values().gset("left_source_file", _left.file_selector.get_filename());
    values().gset("right_source_file", _right.file_selector.get_filename());

    if (get_left_source() == DataSourceSelector::FileSource
      && !g_file_test(_left.file_selector.get_filename().c_str(), G_FILE_TEST_EXISTS))
      return false;
      
    if (get_right_source() == DataSourceSelector::FileSource
      && !g_file_test(_right.file_selector.get_filename().c_str(), G_FILE_TEST_EXISTS))
      return false;
        
    return true;
  }


public:
  SourceSelectPage(WizardForm *form)
    : WizardPage(form, "source")
  {
    set_title(_("Select Sources to Compare"));
    set_short_title(_("Select Sources"));

    add(&_left.panel, false, false);
    _left.panel.set_title(_("Source for Left Catalog"));
    _left.model_radio->set_enabled(false);
    _left.server_radio->set_active(true);
    
    _left.set_change_slot(boost::bind(&SourceSelectPage::left_changed, this));
    _right.set_change_slot(boost::bind(&SourceSelectPage::right_changed, this));
    
    _right.model_radio->set_active(true);
    
    _left.file_source_selected();
    _right.file_source_selected();
    
    add(&_right.panel, false, false);
    _right.panel.set_title(_("Source for Right Catalog"));
  }

  DataSourceSelector::SourceType get_left_source() { return _left.get_source(); }
  DataSourceSelector::SourceType get_right_source() { return _right.get_source(); }
};
