/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "tut_stdafx.h"

#include "grt/grt_modules_tree.h"
#include "grtpp_module_cpp.h"
#include "grtpp_module_lua.h"

namespace modinsp {
#include "test_modules.h"
};

using namespace modinsp;
using namespace grt;
using namespace bec;

#include "grt_values_test_data.h"


BEGIN_TEST_DATA_CLASS(be_inspector_modules)
public:
  GRT grt;
END_TEST_DATA_CLASS;

TEST_MODULE(be_inspector_modules, "grt modules inspector backends");

TEST_FUNCTION(1)
{ // load modules

  ModuleLoader *loader;

  loader= new LuaModuleLoader(&grt);
  ensure("init lua loader", loader != NULL);

  grt.add_module_loader(loader);

  InterfaceImplBase::Register<SampleInterface1Impl>(&grt);
  InterfaceImplBase::Register<SampleInterface2Impl>(&grt);


  // load a lua module
  grt.load_module("../../library/grt/unit-tests/lua_module.lua", false);

  // register some C++ modules
  grt.get_native_module<SampleModule1Impl>();
  grt.get_native_module<SampleModule2Impl>();

  //ensure("register dynamic C++ module", false);

  // load a java module
  //ensure("load java module", false);

  ensure_equals("module count", grt.get_modules().size(), 3U);
}


TEST_FUNCTION(2)
{
  ModulesTreeBE tree(&grt);
  NodeId node, snode;
  unsigned int c;
  std::string s;
  bool flag;

  c= tree.count_children(tree.get_root());
  ensure_equals("tree count", c, 3U);
  
  grt.get_native_module<SampleModule3Impl>();
  tree.refresh();

  c= tree.count_children(tree.get_root());
  ensure_equals("tree count", c, 4U);

  
  node= tree.get_child(tree.get_root(), 0);
  tree.expand_node(node);
  
  flag= tree.get_field(node, ModulesTreeBE::Name, s);
  ensure("module[0] name", flag);
  ensure_equals("module[0] name", s, "LuaModuleTest");

  c= tree.count_children(node);
  ensure_equals("module[0] child count", c, 27U);

  

  node= tree.get_child(tree.get_root(), 1);
  tree.expand_node(node);
  
  flag= tree.get_field(node, ModulesTreeBE::Name, s);
  ensure("module[1] name", flag);
  ensure_equals("module[1] name", s, "SampleModule1");

//  flag= tree.get_field(node, ModulesTreeBE::Description, s);
//  ensure("module[1] description", flag);
//  ensure_equals("module[1] description", s, "\n\n\n");

  c= tree.count_children(node);
  ensure_equals("module[1] child count", c, 2U);

  snode= tree.get_child(node, 0);
  flag= tree.get_field(snode, ModulesTreeBE::Name, s);
  ensure("module[1][0] name", flag);
  ensure_equals("module[1][0] name", s, "getNumber");

//  flag= tree.get_field(snode, ModulesTreeBE::Description, s);
//  ensure("module[1][0] description", flag);
//  ensure_equals("module[1][0] description", s, "\n\n\n");

}


END_TESTS
