//
//  MWorkerManager.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on Tue Jun 22 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "MWorkerManager.h"
#import "MMySQLWorker.h"
#import "MPtrArray.h"

NSString *MConnectionDidFinishNotification= @"MConnectionDidFinishNotification";
NSString *MWorkerDidFinishNotification= @"MWorkerDidFinishNotification";
NSString *MQueryDidFinishNotification= @"MQueryDidFinishNotification";

static MWorkerManager *instance= nil;
static int lastTID= 0;

@implementation MWorkerManager

+ (MWorkerManager*)manager
{
  if (instance==nil)
    instance= [[MWorkerManager alloc] init];

  return instance;
}


- (id)init
{
  self= [super init];
  if (self != nil)
  {
    _freeWorkers= [[NSMutableArray alloc] init];
    _workerConnections= [[NSMutableDictionary alloc] init];
    
    _transferAreaLock= [[NSLock alloc] init];
    _transferArea= [[NSMutableDictionary alloc] init];
  }
  return self;
}

- (MMySQLWorker*)createWorker
{
  id worker;
  NSPort *port1;
  NSPort *port2;
  NSConnection *connection;
  NSArray *portArray;
  
  port1= [NSPort port];
  port2= [NSPort port];
  connection= [[NSConnection alloc] initWithReceivePort: port1
                                               sendPort: port2];
  portArray= [NSArray arrayWithObjects: port2, port1, nil];
  [NSThread detachNewThreadSelector: @selector(connectWithPorts:)
                           toTarget: [MMySQLWorker class]
                         withObject: portArray];
  
  // busy wait until the thread does setRootObject:
  while ([connection rootProxy]==nil) ;
  
  worker= [connection rootProxy];
  [worker setManager: self
                 tag: lastTID++];
  
  [_workerConnections setObject: connection 
                         forKey: [NSNumber numberWithInt: [worker tag]]];
 
  NSLog(@"Started a new worker thread");
  
  return worker;
}

- (MMySQLWorker*)worker
{
  MMySQLWorker *w;
  
  if ([_freeWorkers count] == 0)
    w= [[self createWorker] retain];
  else
  {
    w= [_freeWorkers objectAtIndex: [_freeWorkers count]-1];
    [_freeWorkers removeLastObject];
  }
 
  return w;
}

- (void)workerFinished: (MMySQLWorker*)aWorker
{
  [[_workerConnections objectForKey: [NSNumber numberWithInt: [aWorker tag]]]
      removeRequestMode: NSModalPanelRunLoopMode];
  [_freeWorkers addObject: aWorker];
}

- (MDataToken)putData: (id)data
{
  NSParameterAssert(![data isProxy]);
  
  [_transferAreaLock lock];
  [_transferArea setObject: data forKey: [NSNumber numberWithInt:_token]];
  [_transferAreaLock unlock];
  return _token++;
}

- (NSNumber*)putDataNumber: (id)data
{
  return [NSNumber numberWithInt:[self putData:data]];
}

- (id)getData: (MDataToken)token
{
  NSNumber *number= [NSNumber numberWithInt: token];
  return [self getDataWithNumber:number];
}

- (id)getDataWithNumber: (NSNumber*)token
{
  [_transferAreaLock lock];
  id data= [[[_transferArea objectForKey: token] retain] autorelease];
  [_transferArea removeObjectForKey: token];
  [_transferAreaLock unlock];
  return data;
}


- (void)notifyConnection: (MDataToken)token
{
  NSDictionary *dict= [self getData: token];
  [[NSNotificationCenter defaultCenter] postNotificationName: MConnectionDidFinishNotification
                                                      object: self
                                                    userInfo: dict];
}


- (void)notifyFinished: (NSString*)identifier
                result: (MDataToken)result
{
  NSDictionary *dict;
  id a;
  
  dict= [NSDictionary dictionaryWithObjectsAndKeys: 
    a=[self getData:result], @"result",
    identifier, @"identifier", nil];

  NSLog(@"enter notifyFinished %@ %@", identifier, [a className]);
  
  [[NSNotificationCenter defaultCenter] postNotificationName: MWorkerDidFinishNotification
                                                      object: self
                                                    userInfo: dict];  
}

- (oneway void)connectToInstance: (MYX_USER_CONNECTION*)info
{
  MMySQLWorker *worker;
    
  NSLog(@"connect before");
  worker= [self worker];
  
  // make it work when its in a modal loop
  [[_workerConnections objectForKey: [NSNumber numberWithInt: [worker tag]]]
                     addRequestMode: NSModalPanelRunLoopMode];
  
  NSLog(@"connect start");
  [worker performConnectTo: [self putData:[NSValue valueWithPointer:info]]];
}


- (void)performSelector: (SEL)sel
                 target: (id)anObject
               argument: (id)argument
             identifier: (NSString*)identifier
{
  MMySQLWorker *worker= [self worker];
  NSLog(@"worker manager will request %@", identifier);
  [worker performSelector: sel
                   target: anObject
                 argument: argument
               identifier: identifier];
}


- (void*)performCallbackAndWait: (MCallback1)cback
                       argument: (void*)arg1
                          mysql: (MYSQL*)mysql;
{
  MMySQLWorker *worker= [self worker];
  MPtrArray *args= [[MPtrArray alloc] init];
  MDataToken tok;
  NSLog(@"worker manager will do a callback");
  
  [args addPointer:cback];
  [args addPointer:mysql];
  [args addPointer:arg1];
  NSLog(@"will call %i", [args count]);
  tok= [worker performCallback1AndWait:[self putData:args]];
  [args release];
  if (tok >= 0)
    return [self getData: tok];
  else
    return nil;
}

@end
