program MySQLQueryBrowser;

uses
  gnugettext in '..\..\..\mysql-gui-common\source\windows\gnugettext.pas',
  Forms,
  SHDocVw,
  SysUtils,
  Main in 'Main.pas' {MainForm},
  AuxFuncs in '..\..\..\mysql-gui-common\source\windows\AuxFuncs.pas',
  AuxLists in '..\..\..\mysql-gui-common\source\windows\AuxLists.pas',
  MyxError in '..\..\..\mysql-gui-common\source\windows\MyxError.pas',
  myx_public_interface in '..\..\..\mysql-gui-common\library\public_interface\windows\myx_public_interface.pas',
  MySQLConnection in '..\..\..\mysql-gui-common\source\windows\MySQLConnection.pas',
  MySQLResultSet in '..\..\..\mysql-gui-common\source\windows\MySQLResultSet.pas',
  Sections in '..\..\..\mysql-gui-common\source\windows\Sections.pas',
  InstanceSections in '..\..\..\mysql-gui-common\source\windows\InstanceSections.pas',
  SchemataTreeView in '..\..\..\mysql-gui-common\source\windows\SchemataTreeView.pas' {SchemataFrame: TFrame},
  AdvancedEdit in '..\..\..\mysql-gui-common\source\windows\AdvancedEdit.pas' {AdvancedEditFrame: TFrame},
  ConnectToInstance in '..\..\..\mysql-gui-common\source\windows\ConnectToInstance.pas' {ConnectToInstanceForm},
  Options in '..\..\..\mysql-gui-common\source\windows\Options.pas',
  OptionsEditor in '..\..\..\mysql-gui-common\source\windows\OptionsEditor.pas' {OptionsForm},
  Toolbar in '..\..\..\mysql-gui-common\source\windows\Toolbar.pas',
  TabHeader in '..\..\..\mysql-gui-common\source\windows\TabHeader.pas' {TabHeaderFrame: TFrame},
  ApplicationDataModule in 'ApplicationDataModule.pas' {ApplicationDM: TDataModule},
  QueryBrowserOptionPages in 'QueryBrowserOptionPages.pas' {QueryBrowserOptionPagesForm},
  QueryBrowser in 'QueryBrowser.pas' {QueryBrowserForm},
  MySQLResultSetControls in '..\..\..\mysql-gui-common\source\windows\MySQLResultSetControls.pas',
  TableDrag in 'TableDrag.pas' {TableDragForm},
  myx_qb_public_interface in '..\..\library\public_interface\windows\myx_qb_public_interface.pas',
  EditorTable in '..\..\..\mysql-gui-common\source\windows\EditorTable.pas',
  EditorTableVTFKEdit in '..\..\..\mysql-gui-common\source\windows\EditorTableVTFKEdit.pas',
  EditorTableVTEdit in '..\..\..\mysql-gui-common\source\windows\EditorTableVTEdit.pas',
  CommonFuncs in '..\..\..\mysql-gui-common\source\windows\CommonFuncs.pas',
  SchemaSelection in '..\..\..\mysql-gui-common\source\windows\SchemaSelection.pas' {SchemaSelectionForm},
  About in '..\..\..\mysql-gui-common\source\windows\About.pas' {AboutForm},
  AuxApplicationFuncs in '..\..\..\mysql-gui-common\source\windows\AuxApplicationFuncs.pas',
  MySQLResultSetFieldViewer in '..\..\..\mysql-gui-common\source\windows\MySQLResultSetFieldViewer.pas' {MySQLResultSetFieldViewerForm},
  MySQLCommonFuncs in '..\..\..\mysql-gui-common\source\windows\MySQLCommonFuncs.pas',
  SqlCmdPanel in 'SqlCmdPanel.pas',
  RegExTextImporter in 'RegExTextImporter.pas' {RegExTextImporterForm},
  RegExpr in '..\..\..\mysql-gui-common\source\windows\LibInterfaceMapper\RegExpr.pas',
  TextSearch in '..\..\..\mysql-gui-common\source\windows\TextSearch.pas' {TextSearchForm},
  ScriptPanel in 'ScriptPanel.pas',
  SQLErrorGrid in '..\..\..\mysql-gui-common\source\windows\SQL Controls\Source\SQLErrorGrid.pas',
  AppInstanceMgmt in '..\..\..\mysql-gui-common\source\windows\AppInstanceMgmt.pas';

{$R *.res}

//Include Common Resource with PNG images, ...
{$R ..\..\..\mysql-gui-common\res\windows\mysqlcommon.res}

//Include Resource with PNG images, ...
{$R ..\..\res\windows\mysqlqb.RES}

//Enable WindowsXP look'n'feel
{$R ..\..\..\mysql-gui-common\res\windows\WindowsXP.res}

var
  ConnectionResult: integer;

begin
  //Create Common Options
  MYXCommonOptions := TMYXCommonOptions.Create;
  MYXCommonOptionProvider := MYXCommonOptions;

  // Add extra domain for runtime library translations
  AddDomainForResourceString('delphi');
  TP_GlobalIgnoreClass(TWebBrowser);

  // Force program to use user defined instead of the current Windows settings
  UseLanguage('en'); //MYXCommonOptions.Language);

  //Create Application Data Module
  ApplicationDM := TApplicationDM.Create(nil);

  ApplicationDM.LoadOptions;

  //Application Title
  Application.Title := 'MySQL Query Browser';
  Application.HelpFile := '';
  Application.Initialize;

  //Check Common Commandline parameter
  CheckCommonCommandlineParameter;

  //Check Commandline parameter
  ApplicationDM.CheckCommandlineParameter;

  Application.CreateForm(TMainForm, MainForm);

  if (ApplicationDM.Options.Embedded) then
    ConnectionResult := MainForm.MySQLConn.ConnectToEmbedded
  else
  begin
    myx_mysql_embedded_prevent_start;

    if (ApplicationDM.Options.StartScriptFile <> '') then
      ConnectionResult := 1
    else
      ConnectionResult := MainForm.MySQLConn.ConnectToServer(True, True, True);
  end;

  if (ConnectionResult = 1) then
  begin
    RegisterApplication(Application, MainForm.MySQLConn.GetConnectionCaption(False));
    try
      MainForm.PrepareGUI;

      Application.Run;
    finally
      UnregisterApplication(Application);
    end;
  end;

  Application.ProcessMessages;
end.

