#ifndef SCHEMA_H
#define SCHEMA_H

#include <qlistview.h>
#include <mysql.h>
#include <qmap.h>

#define FLAG_EXPAND	1
#define FLAG_COLLAPSE	-1

struct table_value
{
	char table[255];
	int value;
};

class Schema: public QListView 
{
Q_OBJECT

public:
	Schema(MYSQL *, const QString &, const QString &, QWidget *widget = 0, const char *name =0);
	~Schema();

private slots:
	void slot_expand(QListViewItem *);
	void slot_collapse(QListViewItem *);
	void slot_pressed(int, QListViewItem *, const QPoint &, int);


public slots:
	void slot_schema();

private:
	void set_table(QListViewItem *);
	void set_field(QListViewItem *);

	MYSQL *mysql;
	QString host;
	QString user;

	// save node's status
	QMap<QString, bool> status;
	int user_flag;

public:
	// save table's status
	QMap<QString, QMap<QString, struct table_value> > table_map;
};

#endif
