/*
   Copyright (C) 2003 MySQL AB
    All rights reserved. Use is subject to license terms.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*/


#define DBTUP_C
#define DBTUP_DEBUG_CPP
#include "Dbtup.hpp"
#include <RefConvert.hpp>
#include <ndb_limits.h>
#include <pc.hpp>
#include <signaldata/DropTab.hpp>
#include <signaldata/DumpStateOrd.hpp>
#include <signaldata/EventReport.hpp>
#include <Vector.hpp>

#include <signaldata/DbinfoScan.hpp>
#include <signaldata/TransIdAI.hpp>
#include <ndbinfo.h>
#include <dbinfo/ndbinfo_tableids.h>


/* **************************************************************** */
/* ---------------------------------------------------------------- */
/* ------------------------ DEBUG MODULE -------------------------- */
/* ---------------------------------------------------------------- */
/* **************************************************************** */
void Dbtup::execDEBUG_SIG(Signal* signal) 
{
  PagePtr regPagePtr;
  jamEntry();
  regPagePtr.i = signal->theData[0];
  c_page_pool.getPtr(regPagePtr);
}//Dbtup::execDEBUG_SIG()

#ifdef TEST_MR
#include <time.h>

void startTimer(struct timespec *tp)
{
  clock_gettime(CLOCK_REALTIME, tp);
}//startTimer()

int stopTimer(struct timespec *tp)
{
  double timer_count;
  struct timespec theStopTime;
  clock_gettime(CLOCK_REALTIME, &theStopTime);
  timer_count = (double)(1000000*((double)theStopTime.tv_sec - (double)tp->tv_sec)) + 
                (double)((double)((double)theStopTime.tv_nsec - (double)tp->tv_nsec)/(double)1000);
  return (int)timer_count;
}//stopTimer()

#endif // end TEST_MR

struct Chunk {
  Uint32 pageId;
  Uint32 pageCount;
};

void Dbtup::execDBINFO_SCANREQ(Signal* signal)
{
  jamEntry();
  DbinfoScanReq req= *(DbinfoScanReq*)signal->theData;
  const Uint32 reqlength= signal->getLength();

  char buf[1024];
  struct dbinfo_row r;
  struct dbinfo_ratelimit rl;

  dbinfo_ratelimit_init(&rl, &req);

  if(req.tableId == NDBINFO_POOLS_TABLEID)
  {
    struct {
      const char* poolname;
      Uint32 free;
      Uint32 size;
    } pools[] =
        {
          {"Scan Lock",
           c_scanLockPool.getNoOfFree(),
           c_scanLockPool.getSize() },
          {"Scan Operation",
           c_scanOpPool.getNoOfFree(),
           c_scanOpPool.getSize() },
          {"Trigger",
           c_triggerPool.getNoOfFree(),
           c_triggerPool.getSize() },
          {"Stored Proc",
           c_storedProcPool.getNoOfFree(),
           c_storedProcPool.getSize() },
          {"Build Index",
           c_buildIndexPool.getNoOfFree(),
           c_buildIndexPool.getSize() },
          {"Operation",
           c_operation_pool.getNoOfFree(),
           c_operation_pool.getSize() },
          {"Page",
           c_page_pool.getNoOfFree(),
           c_page_pool.getSize() },
          { NULL, 0, 0}
        };

    for(int i=0; pools[i].poolname; i++)
    {
      dbinfo_write_row_init(&r, buf, sizeof(buf));
      dbinfo_write_row_column_uint32(&r, getOwnNodeId());
      const char *blockname= "DBTUP";
      dbinfo_write_row_column(&r, blockname, strlen(blockname));
      dbinfo_write_row_column(&r, pools[i].poolname, strlen(pools[i].poolname));
      dbinfo_write_row_column_uint32(&r, pools[i].free);
      dbinfo_write_row_column_uint32(&r, pools[i].size);
      dbinfo_send_row(signal, r, rl, req.apiTxnId, req.senderRef);
    }
  }

  DbinfoScanConf *conf= (DbinfoScanConf*)signal->getDataPtrSend();
  memcpy(conf,&req, reqlength * sizeof(Uint32));
  conf->requestInfo &= ~(DbinfoScanConf::MoreData);
  sendSignal(DBINFO_REF, GSN_DBINFO_SCANCONF,
             signal, DbinfoScanConf::SignalLengthWithCursor, JBB);
  ndbout_c("DBTUP done doing DBINFO");
}

#ifdef VM_TRACE
static Uint32 fc_left = 0, fc_right = 0, fc_remove = 0;
#endif

void
Dbtup::execDUMP_STATE_ORD(Signal* signal)
{
  Uint32 type = signal->theData[0];
  DumpStateOrd * const dumpState = (DumpStateOrd *)&signal->theData[0];

#if 0
  if (type == 100) {
    RelTabMemReq * const req = (RelTabMemReq *)signal->getDataPtrSend();
    req->primaryTableId = 2;
    req->secondaryTableId = RNIL;
    req->userPtr = 2;
    req->userRef = DBDICT_REF;
    sendSignal(cownref, GSN_REL_TABMEMREQ, signal,
               RelTabMemReq::SignalLength, JBB);
    return;
  }//if
  if (type == 101) {
    RelTabMemReq * const req = (RelTabMemReq *)signal->getDataPtrSend();
    req->primaryTableId = 4;
    req->secondaryTableId = 5;
    req->userPtr = 4;
    req->userRef = DBDICT_REF;
    sendSignal(cownref, GSN_REL_TABMEMREQ, signal,
               RelTabMemReq::SignalLength, JBB);
    return;
  }//if
  if (type == 102) {
    RelTabMemReq * const req = (RelTabMemReq *)signal->getDataPtrSend();
    req->primaryTableId = 6;
    req->secondaryTableId = 8;
    req->userPtr = 6;
    req->userRef = DBDICT_REF;
    sendSignal(cownref, GSN_REL_TABMEMREQ, signal,
               RelTabMemReq::SignalLength, JBB);
    return;
  }//if
  if (type == 103) {
    DropTabFileReq * const req = (DropTabFileReq *)signal->getDataPtrSend();
    req->primaryTableId = 2;
    req->secondaryTableId = RNIL;
    req->userPtr = 2;
    req->userRef = DBDICT_REF;
    sendSignal(cownref, GSN_DROP_TABFILEREQ, signal,
               DropTabFileReq::SignalLength, JBB);
    return;
  }//if
  if (type == 104) {
    DropTabFileReq * const req = (DropTabFileReq *)signal->getDataPtrSend();
    req->primaryTableId = 4;
    req->secondaryTableId = 5;
    req->userPtr = 4;
    req->userRef = DBDICT_REF;
    sendSignal(cownref, GSN_DROP_TABFILEREQ, signal,
               DropTabFileReq::SignalLength, JBB);
    return;
  }//if
  if (type == 105) {
    DropTabFileReq * const req = (DropTabFileReq *)signal->getDataPtrSend();
    req->primaryTableId = 6;
    req->secondaryTableId = 8;
    req->userPtr = 6;
    req->userRef = DBDICT_REF;
    sendSignal(cownref, GSN_DROP_TABFILEREQ, signal,
               DropTabFileReq::SignalLength, JBB);
    return;
  }//if
#endif
#ifdef ERROR_INSERT
  if (type == DumpStateOrd::EnableUndoDelayDataWrite) {
    ndbout << "Dbtup:: delay write of datapages for table = " 
	   << dumpState->args[1]<< endl;
    c_errorInsert4000TableId = dumpState->args[1];
    SET_ERROR_INSERT_VALUE(4000);
    return;
  }//if
#endif
#if defined VM_TRACE
  if (type == 1211 || type == 1212 || type == 1213){
    Uint32 seed = (Uint32)time(0);
    if (signal->getLength() > 1)
      seed = signal->theData[1];
    ndbout_c("Startar modul test av Page Manager (seed: 0x%x)", seed);
    srand(seed);

    Vector<Chunk> chunks;
    const Uint32 LOOPS = 1000;
    Uint32 sum_req = 0;
    Uint32 sum_conf = 0;
    Uint32 sum_loop = 0;
    Uint32 max_loop = 0;
    for(Uint32 i = 0; i<LOOPS; i++){

      // Case
      Uint32 c = (rand() % 3);
      Resource_limit rl;
      m_ctx.m_mm.get_resource_limit(RG_DATAMEM, rl);
      const Uint32 free = rl.m_max - rl.m_curr;
      
      Uint32 alloc = 0;
      if(free <= 1){
	c = 0;
	alloc = 1;
      } else 
	alloc = 1 + (rand() % (free - 1));
      
      if(chunks.size() == 0 && c == 0){
	c = 1 + rand() % 2;
      }
      
      if (type == 1211)
        ndbout_c("loop=%d case=%d free=%d alloc=%d", i, c, free, alloc);

      if (type == 1213)
      {
        c = 1;
        alloc = 2 + (sum_conf >> 3) + (sum_conf >> 4);
      }
      switch(c){ 
      case 0:{ // Release
	const int ch = rand() % chunks.size();
	Chunk chunk = chunks[ch];
	chunks.erase(ch);
	returnCommonArea(chunk.pageId, chunk.pageCount);
      }
	break;
      case 2: { // Seize(n) - fail
	alloc += free;
	// Fall through
        sum_req += free;
        goto doalloc;
      }
      case 1: { // Seize(n) (success)
        sum_req += alloc;
    doalloc:
	Chunk chunk;
	allocConsPages(alloc, chunk.pageCount, chunk.pageId);
	ndbrequire(chunk.pageCount <= alloc);
	if(chunk.pageCount != 0){
	  chunks.push_back(chunk);
	  if(chunk.pageCount != alloc) {
	    if (type == 1211)
              ndbout_c("  Tried to allocate %d - only allocated %d - free: %d",
                       alloc, chunk.pageCount, free);
	  }
	} else {
	  ndbout_c("  Failed to alloc %d pages with %d pages free",
		   alloc, free);
	}
	
        sum_conf += chunk.pageCount;
        Uint32 tot = fc_left + fc_right + fc_remove;
        sum_loop += tot;
        if (tot > max_loop)
          max_loop = tot;

	for(Uint32 i = 0; i<chunk.pageCount; i++){
	  PagePtr pagePtr;
	  pagePtr.i = chunk.pageId + i;
	  c_page_pool.getPtr(pagePtr);
	}

	if(alloc == 1 && free > 0)
	  ndbrequire(chunk.pageCount == alloc);
      }
	break;
      }
    }
    while(chunks.size() > 0){
      Chunk chunk = chunks.back();
      returnCommonArea(chunk.pageId, chunk.pageCount);      
      chunks.erase(chunks.size() - 1);
    }

    ndbout_c("Got %u%% of requested allocs, loops : %u 100*avg: %u max: %u",
             (100 * sum_conf) / sum_req, sum_loop, 100*sum_loop / LOOPS,
             max_loop);
  }
#endif

  if (signal->theData[0] == DumpStateOrd::SchemaResourceSnapshot)
  {
    RSS_OP_SNAPSHOT_SAVE(cnoOfFreeFragoprec);
    RSS_OP_SNAPSHOT_SAVE(cnoOfFreeFragrec);
    RSS_OP_SNAPSHOT_SAVE(cnoOfFreeTabDescrRec);
    return;
  }

  if (signal->theData[0] == DumpStateOrd::SchemaResourceCheckLeak)
  {
    RSS_OP_SNAPSHOT_CHECK(cnoOfFreeFragoprec);
    RSS_OP_SNAPSHOT_CHECK(cnoOfFreeFragrec);
    RSS_OP_SNAPSHOT_CHECK(cnoOfFreeTabDescrRec);
    return;
  }
}//Dbtup::execDUMP_STATE_ORD()

/* ---------------------------------------------------------------- */
/* ---------      MEMORY       CHECK        ----------------------- */
/* ---------------------------------------------------------------- */
void Dbtup::execMEMCHECKREQ(Signal* signal) 
{
  TablerecPtr regTabPtr;
  regTabPtr.i = 2;
  ptrCheckGuard(regTabPtr, cnoOfTablerec, tablerec);
  if(tablerec && regTabPtr.p->tableStatus == DEFINED)
    validate_page(regTabPtr.p, 0);

#if 0
  const Dbtup::Tablerec& tab = *tup->tabptr.p;

  PagePtr regPagePtr;
  Uint32* data = &signal->theData[0];

  jamEntry();
  BlockReference blockref = signal->theData[0];
  Uint32 i;
  for (i = 0; i < 25; i++) {
    jam();
    data[i] = 0;
  }//for
  for (i = 0; i < 16; i++) {
    regPagePtr.i = cfreepageList[i];
    jam();
    while (regPagePtr.i != RNIL) {
      jam();
      ptrCheckGuard(regPagePtr, cnoOfPage, cpage);
      regPagePtr.i = regPagePtr.p->next_page;
      data[0]++;
    }//while
  }//for
  sendSignal(blockref, GSN_MEMCHECKCONF, signal, 25, JBB);
#endif
}//Dbtup::memCheck()

// ------------------------------------------------------------------------
// Help function to be used when debugging. Prints out a tuple page.
// printLimit is the number of bytes that is printed out from the page. A 
// page is of size 32768 bytes as of March 2003.
// ------------------------------------------------------------------------
void Dbtup::printoutTuplePage(Uint32 fragid, Uint32 pageid, Uint32 printLimit) 
{
  PagePtr tmpPageP;
  FragrecordPtr tmpFragP;
  TablerecPtr tmpTableP;

  c_page_pool.getPtr(tmpPageP, pageid);

  tmpFragP.i = fragid;
  ptrCheckGuard(tmpFragP, cnoOfFragrec, fragrecord);

  tmpTableP.i = tmpFragP.p->fragTableId;
  ptrCheckGuard(tmpTableP, cnoOfTablerec, tablerec);

  ndbout << "Fragid: " << fragid << " Pageid: " << pageid << endl
	 << "----------------------------------------" << endl;

  ndbout << "PageHead : ";
  ndbout << endl;
}//Dbtup::printoutTuplePage

#ifdef VM_TRACE
NdbOut&
operator<<(NdbOut& out, const Dbtup::Operationrec& op)
{
  out << "[Operationrec " << hex << &op;
  // table
  out << " [fragmentPtr " << hex << op.fragmentPtr << "]";
  // type
  out << " [op_type " << dec << op.op_struct.op_type << "]";
  out << " [delete_insert_flag " << dec;
  out << op.op_struct.delete_insert_flag << "]";
  // state
  out << " [tuple_state " << dec << op.op_struct.tuple_state << "]";
  out << " [trans_state " << dec << op.op_struct.trans_state << "]";
  out << " [in_active_list " << dec << op.op_struct.in_active_list << "]";
  // links
  out << " [prevActiveOp " << hex << op.prevActiveOp << "]";
  out << " [nextActiveOp " << hex << op.nextActiveOp << "]";
  // tuples
  out << " [tupVersion " << hex << op.tupVersion << "]";
  out << " [m_tuple_location " << op.m_tuple_location << "]";
  out << " [m_copy_tuple_location " << op.m_copy_tuple_location << "]";
  out << "]";
  return out;
}

// uses global tabptr
NdbOut&
operator<<(NdbOut& out, const Dbtup::Th& th)
{
  // ugly
  Dbtup* tup = (Dbtup*)globalData.getBlock(DBTUP);
  const Dbtup::Tablerec& tab = *tup->tabptr.p;
  unsigned i = 0;
  out << "[Th " << hex << &th;
  out << " [op " << hex << th.data[i++] << "]";
  out << " [version " << hex << (Uint16)th.data[i++] << "]";
  if (tab.m_bits & Dbtup::Tablerec::TR_Checksum)
    out << " [checksum " << hex << th.data[i++] << "]";
  out << " [nullbits";
  for (unsigned j = 0; j < tab.m_offsets[Dbtup::MM].m_null_words; j++)
    out << " " << hex << th.data[i++];
  out << "]";
  out << " [data";
  while (i < tab.m_offsets[Dbtup::MM].m_fix_header_size)
    out << " " << hex << th.data[i++];
  out << "]";
  out << "]";
  return out;
}
#endif

#ifdef VM_TRACE
template class Vector<Chunk>;
#endif
// uses global tabptr

NdbOut&
operator<<(NdbOut& out, const Local_key & key)
{
  out << "[ m_page_no: " << dec << key.m_page_no 
      << " m_file_no: " << dec << key.m_file_no 
      << " m_page_idx: " << dec << key.m_page_idx << "]";
  return out;
}

static
NdbOut&
operator<<(NdbOut& out, const Dbtup::Tablerec::Tuple_offsets& off)
{
  out << "[ null_words: " << (Uint32)off.m_null_words
      << " null off: " << (Uint32)off.m_null_offset
      << " disk_off: " << off.m_disk_ref_offset
      << " fixheadsz: " << off.m_fix_header_size
      << " max_var_off: " << off.m_max_var_offset
      << " ]";

  return out;
}

NdbOut&
operator<<(NdbOut& out, const Dbtup::Tablerec& tab)
{
  out << "[ total_rec_size: " << tab.total_rec_size
      << " checksum: " << !!(tab.m_bits & Dbtup::Tablerec::TR_Checksum)
      << " attr: " << tab.m_no_of_attributes
      << " disk: " << tab.m_no_of_disk_attributes 
      << " mm: " << tab.m_offsets[Dbtup::MM]
      << " [ fix: " << tab.m_attributes[Dbtup::MM].m_no_of_fixsize
      << " var: " << tab.m_attributes[Dbtup::MM].m_no_of_varsize << "]"
    
      << " dd: " << tab.m_offsets[Dbtup::DD]
      << " [ fix: " << tab.m_attributes[Dbtup::DD].m_no_of_fixsize
      << " var: " << tab.m_attributes[Dbtup::DD].m_no_of_varsize << "]"
      << " ]"  << endl;
  return out;
}

NdbOut&
operator<<(NdbOut& out, const AttributeDescriptor& off)
{
  Uint32 word;
  memcpy(&word, &off, 4);
  return out;
}

#include "AttributeOffset.hpp"

NdbOut&
operator<<(NdbOut& out, const AttributeOffset& off)
{
  Uint32 word;
  memcpy(&word, &off, 4);
  out << "[ offset: " << AttributeOffset::getOffset(word)
      << " nullpos: " << AttributeOffset::getNullFlagPos(word);
  if(AttributeOffset::getCharsetFlag(word))
    out << " charset: %d" << AttributeOffset::getCharsetPos(word);
  out << " ]";
  return out;
}

