<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## Desc: Allows the setting of a printer friendly version for a design 
## $Source: /home/cvsroot/xtras/site/extensions/printer_friendly_pages/printer_friendly_pages.inc,v $
## $Revision: 2.2.2.1 $
## $Author: dchong $
## $Date: 2003/01/13 05:46:04 $
#######################################################################
global $INCLUDE_PATH;
include_once("$INCLUDE_PATH/site_extension.inc");
include_once("$INCLUDE_PATH/html_image.inc");
include_once("$INCLUDE_PATH/site_design.inc");
#---------------------------------------------------------------------#

class Site_Extension_Printer_Friendly_Pages extends Site_Extension {
	
	# Variables
	var $designid = 0; # the design that we are using for the printable version
	var $site_design;  # Unserialized

	var $excluded_pageids;  # an array of pageids that are not printer friendly pages 

	 ##############################
	# Constructor
	function Site_Extension_Printer_Friendly_Pages($siteid) {
		return Site_Extension::Site_Extension($siteid);
	}

	 #############################################
	# Some other things we don't want serialized
	function __sleep() {
		$result = Site_Extension::__sleep();
		array_remove_element("site_design",$result);
		return $result;
	}

	 ######################################################################
	# Create a new record in the databse and load it into this object
	function create($siteid) {
		if(!$siteid = Site_Extension::create($siteid)) {
			return false;
		}
		$id = $this->load($siteid);
		return $id;
	}

	 ###################################################
	# Loads the details, from cache or database
	function load($siteid) {
		if ($siteid <= 0 && !($siteid = $this->id)) { 
			$this->_set_error("Attempt to load site extension without a valid siteid.",__FILE__,__LINE__);
		}

		 ###############################################
		# Check the cache - but remember where mum is !
		$loaded = $this->load_from_cache($siteid);

		if ($loaded) return $siteid;
		
		 ########################
		# Load from the database
		$db = &$this->get_db();

		list($this->id,
			 $this->designid
			 ) = $db->single_row("SELECT siteid, designid FROM $this->table_name WHERE siteid='$siteid'");

		# remove this, just to make sure
		unset($this->excluded_pageids);

		$this->set_generated_information();

		 ####################################
		# Create a new record if none exists
		if (!$this->id) {
			return $this->create($siteid);
		}

		 ############################
		# Save to the cache
		$this->save_to_cache($siteid);
	
		return $siteid;

	}#end load()

	   ###########################################################
	  # Duplicates the extension for a site
	 # must replicate 2 tables. tricky one is 
	# xtra_site_extension_printer_friendly_pages_excluded_pages, as it deals with new pageids
	function dupe($new_siteid) {
		global $DUPE_MESSAGE, $DUPE_MAP;
	 
		if (!$new_siteid)   {
			$DUPE_MESSAGE .= 'Printer Friendly Pages duplication failed for this site. \n';
			return false;
		}

		$design    = &$this->get_design();
		$design_ok = $design->dupe_customisation($new_siteid.".".$this->id.".".get_class($this));

		$db = &$this->get_db();
		# First do the one entry for xtras_site_extenions_Printer_Friendly_Pages
		$sql = "INSERT INTO $this->table_name 
				(siteid, designid) 
				VALUES 
				('$new_siteid', '$this->designid')";
		$db->insert($sql);
		
		# Next duplicate entries in xtra_site_extension_printer_friendly_pages_excluded_pages, 
		# carefully referenceing the correct pageid drawn from $DUPE_MAP
		$excluded_pageids = &$this->get_excluded_pageids();
			
		foreach($excluded_pageids as $pageid) {
			$db->insert("INSERT INTO ".$this->table_name."_excluded_pages (pageid,siteid) VALUES ('".$DUPE_MAP[page][$pageid]."','$new_siteid')");
		}

		return true;
	}


	 #######################################################
	# deletes ALL database info relating to extension
	function delete()   {
		$db = &$this->get_db();

		# Let's kill our customised design
		$design = &$this->get_design();
		$design->delete_customisation();

		delete_directory($this->data_path);
		$this->clear_cache($this->id);

		$sql = "DELETE FROM ".$this->table_name."_excluded_pages WHERE siteid='$this->id'";
		$db->delete($sql);

		$sql = "DELETE FROM ".$this->table_name." WHERE siteid='$this->id'";
		return $db->delete($sql);
	}

	 #########################
	# Changes the site design
	function set_design($designid) {
		if(!$designid)
			return "Unable to set new design: ID not are specified";
		if($designid == $this->designid)
			return "";

		$message = "";

		# if there is an existing design try and convert it
		if ($this->designid) {
			$design = &$this->get_design();
			$message .= $design->convert_customisation($designid);
			# conversion succeeded
			if ($designid == $design->id) { 
				$this->site_design = &$design;
			}

		}#end if

		$this->designid = $designid;
		$design = &$this->get_design();

		$db = &$this->get_db();
		$sql = "UPDATE $this->table_name
				SET designid = '".$this->designid."'
				WHERE siteid='$this->id'";
		$db->update($sql);

		$design = &$this->get_design();
		$message .= "Design set to '$design->name'";
		$this->clear_cache();
		return $message;

	}#end set_design()


	 ################################################
	# Returns a reference to this sites design object
	function &get_design() {
		if(get_class($this->site_design) != "site_design") {
			global $INCLUDE_PATH;
			include_once("$INCLUDE_PATH/site_design.inc");
			$this->site_design =& new Site_Design($this->designid, $this->id.".".get_class($this), $this->data_path, $this->get_file_href());
		}
		return $this->site_design;

	}#end get_design()

	function set_excluded_pageids($excluded_pageids, $delete_pagelink) {

		# do we havbe to do anything ?
		if (count($excluded_pageids) + count($delete_pagelink))	{
			$whats_there = &$this->get_excluded_pageids();
			$excluded_pageids = array_unique(array_merge($excluded_pageids,$whats_there));

			if (count($delete_pagelink))	{
				$excluded_pageids = array_diff($excluded_pageids,$delete_pagelink);
			}

			if (!equal_arrays($whats_there,$excluded_pageids)) {
				$db = $this->get_db();
				$db->delete("DELETE FROM ".$this->table_name."_excluded_pages WHERE siteid = '$this->id'");
				
				foreach($excluded_pageids as $pageid) {
					$db->insert("INSERT INTO ".$this->table_name."_excluded_pages (siteid,pageid) VALUES ('$this->id', '$pageid')");
				}
				# unset the excluded_pageids so we get a fresh batch to next time
				unset($this->excluded_pageids);
				return "Excluded Pages Updated";
			}
		}

	}#end set_excluded_pageids()

	 ############################################
	# returns an array of excluded pageids
	function &get_excluded_pageids() {

		if (!isset($this->excluded_pageids)) {
			$db = &$this->get_db();
			$this->excluded_pageids = $db->single_column("SELECT pageid FROM ".$this->table_name."_excluded_pages WHERE siteid = '$this->id'");
		}#end if
		return $this->excluded_pageids;

	}#end get_excluded_pageids()

	 ##########################################################
	# Prints the backend for the user
	function print_backend() {
		global $SESSION;

		$db = &$this->get_db();
		$site = &$this->get_site();

		 ###################################
		# Setup the backend a little
		$backend = &$this->setup_backend();
		# set these here so they are taken across to the site design if necessary
		$backend->set_hidden_field("design_edit");

		$site_designs = &$this->web_system->get_site_design_list();
		$site = &$this->web_system->get_site($this->id);

		if ($site_designs[$this->designid] && in_array($this->designid, $site->allowed_designids)) {
			$backend->set_tab("site_extension_printer_friendly_pages_custom_design", $_SERVER['PHP_SELF']."?siteid=".$this->id."&extension_edit=".$this->codename."&design_edit=1", "Custom Design", "Customise the design used on the printer friendly page","xtra");
		}
		
		 ####################################################################
		# SECUIRTY - Only let in those who have permission to work on a site
		if (!$site->admin_access()) {
			$SESSION->login_screen($backend->title,"You are not an administrator of this site.");
		}

		 ##########################################################
		# Display the edit interface for the design if asked for
		global $design_edit;
		if($design_edit) {
			$backend->set_active_tab("site_extension_printer_friendly_pages_custom_design");
			$design = &$this->get_design();
			$design->print_user_backend($_SERVER['PHP_SELF']."?siteid=".$this->id."&extension_edit=".$this->codename."&design_edit=1");
			return;
		}

		 #########################################
		# Process a submitted form
		global $action;
		switch($action) {

			case "Commit":
				global $designid;
				$backend->add_message($this->set_design($designid));
				global $excluded_pageids, $delete_pagelink;
				$backend->add_message($this->set_excluded_pageids($excluded_pageids, $delete_pagelink));

			break;

	  	}#end switch


		 #######################
		# Die on no ID
		if(!$this->id) return;

		$backend->print_header();

		$backend->open_section("");
		
		$backend->open_field("Design");
		$designs = array();
		foreach($site->allowed_designids as $designid) {
			$designs[$designid] = $site_designs[$designid];
		}
		asort($designs);
		echo combo_box("designid", $designs, $this->designid, "class=data"); 
	
		if ($site_designs[$this->designid] && in_array($this->designid, $site->allowed_designids)) {
			$backend->open_field("Customise '".$site_designs[$this->designid]."' ?");
			$backend->print_icon_button("javascript: document.edit.design_edit.value='1'; document.edit.submit();","Customise the current design","page");
		}#end if

		// Do page linking part
		$backend->open_section("Currently Excluded From");
		$backend->open_field("","top");
		$excluded_pageids = &$this->get_excluded_pageids();
		if (!count($excluded_pageids)) {
			echo "Every Page in this site is set to have a printable version";
		} else {
			$page_index = &$site->get_page_index();
			?>
			<table width="95%" cellpadding=2 border=0>
				<tr>
					<td class="data"><b>Page Lineage</b></td>
					<td width="2%" class="data"><span style="font-size:9pt; color:red;"><b>Delete</b></span></td>
				</tr>
			<?
			foreach($excluded_pageids as $tmp_page_id) {
				$page = &$this->web_system->get_page($tmp_page_id);
				$page_lineage = array_keys($page->get_lineage());
				$echo_str = '';
				foreach($page_lineage as $pageid) {
					if ($pageid == $page->id) break;
					//$page_link = &$this->web_system->get_val("page_link", $pageid);
					$echo_str .= '<span style="font-size:8pt">'.$page_index[$pageid][name].'</style> : ';
				}#end foreach
				echo '<tr bgcolor="#d0d0e0">
						<td>'.$echo_str.'<b><i>'.$page_index[$tmp_page_id][name].'</i></b></td>
						<td align=center><input type=checkbox name=delete_pagelink[] value="'.$tmp_page_id.'"></td>
					  </tr>';
			}#end foreach
			?>
			</table>
			<?
		}#end if
		# Now do option to add new ones
		$backend->open_section("Exclude Other Pages");
		$backend->open_field("Exclude Pages","top");
		echo $this->web_system->page_multiple_combo_box("excluded_pageids","");

		$backend->open_section("<input type=button value=Commit onclick=\"if(confirm('Commit this information to the system?')){form.action.value='Commit';form.submit();}\" class=field>");

		$backend->print_footer();

	}#end print_backend()

	 ###########################################################
	# Let's print the frontend using our own customised design
	function print_frontend() {

		# make sure that this page is not on the excluded list
		$page = &$this->get_page();
		if (!in_array($page->id, $this->get_excluded_pageids())) {
			$design = &$this->get_design();
			# OK the current pageid should have been setup in web so let's just try to paint the page
			if(!$page->id) { # Aww, no specific page
				$site = &$this->get_site();
				$page = &$this->get_page($site->index_pageid);
			}
			if(!$page->id) {
				$frontend = &$this->web_system->get_frontend();
				$frontend->page_not_found();
				return;
			}
			#so the page exists, let's paint it's template
			$template = $page->get_template();
			$design->paint($template);
			exit();
		}

	}#end print_frontend()

}#end class
?>
