<?  ##############################################
   ### SQUIZLIB ------------------------------###
  ##- Page Template Xtra ------ PHP4 ---------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## $Source: /home/cvsroot/squizlib/jupload/jupload.inc,v $
## $Revision: 1.7.2.2 $
## $Author: sagland $
## $Date: 2002/11/12 04:49:30 $
#######################################################################
global $INCLUDE_DIR;
#---------------------------------------------------------------------#

 ###########################################################################
# Returns a reference to a global jupload object, you really only need one
function &get_jupload($id) {
	global $JUPLOADS;
	if(!get_class($JUPLOADS[$id]) == 'juploads') {
		$JUPLOADS[$id] = new JUpload($id);
	}
	return $JUPLOADS[$id];
}

$JUPLOADS = array();


 #########################################################################
# Class for presenting and managing a Java-based bulk-uploading inferface
class JUpload extends Object {
		 
	 ###################################
	# Variables
	var $id;   # ID, unique to others in current script, provided by calling code
	var $old_code; # Code, unique to every jupload ever (theoretically), generated by the previous incarnation of this script and found in the post vars.
	var $new_code; # Code, unique to every jupload ever (theoretically), generated by us.

	 #############
	# Constructor
	function JUpload ($id) {
		global $$id;

		$this->id       = $id;
		$this->old_code = $$id; 
		$this->new_code = random_password(30);
	

		 #########################################
		# Every hour, go through the directories
		# and remove any timed-out ones.
		$path = $this->upload_path();
		if(file_to_string("$path/.jupload_timeout") < time()) {
			$dir = opendir($path);
			while($dirname = readdir($dir)) {
				if($dirname[0] == '.') continue;
				if(is_dir("$path/$dirname")) {
					if(file_to_string("$path/$dirname/.jupload_timeout") < time()) {
						delete_directory("$path/$dirname");
					}
				} else {
					unlink("$path/$dirname");
				}
			}
			string_to_file(time() + 3600, "$path/.jupload_timeout");
		}
	}

	 ###############################################
	# Grabs the path from the MySOurce configuration
	function applet_path() {
		$config = &get_config('MySource');
		return $config->jupload_path;
	}

	 ##########################################
	# Returns the path to the upload directory
	function upload_path() {
		global $DATA_PATH;
		if(!file_exists($path = "$DATA_PATH/juploads")) {
			create_directory($path);
		}
		return $path;
	}

	 ##############################################
	# Returns the path to the new upload directory
	function new_upload_path() {
		if(!file_exists($path = $this->upload_path()."/$this->new_code")) {
			create_directory($path);
			chmod($path,0777);
			# Set the timeout to a day from now.
			string_to_file(time() + 86400, "$path/.jupload_timeout");
		}
		return $path;
	}

	 ##############################################
	# Returns the path to the old upload directory
	function old_upload_path() {
		if(!$this->old_code || !file_exists($path = $this->upload_path()."/$this->old_code")) {
			return;
		}
		return $path;
	}


	 ###############################################
	# Checks to see if a path has been set up in the MySource configuration
	function active() {
		return strlen($this->applet_path());
	}

	 ######################################################
	# Prints the upload interface, given a unique id string
	function print_interface() {
		if(!$this->active()) {
			echo("[JUpload Bulk File Uploader is not configured.]");
			return;
		}
		echo("<input type=hidden name=\"$this->id\" value=\"$this->new_code\">");
		?>
		<script language="javascript"><!--
			var _info = navigator.userAgent; var _ns = false;
			var _ie = (_info.indexOf("MSIE") > 0 && _info.indexOf("Win") > 0 && _info.indexOf("Windows 3.1") < 0);
		//--></script>
		<comment><script language="javascript1.1"><!--
			var _ns = (navigator.appName.indexOf("Netscape") >= 0 && ((_info.indexOf("Win") > 0 && _info.indexOf("Win16") < 0 && java.lang.System.getProperty("os.version").indexOf("3.5") < 0) || (_info.indexOf("Sun") > 0) || (_info.indexOf("Linux") > 0)));
		//--></script></comment>
		<script language="javascript"><!--
			if (_ie == true) document.writeln('<OBJECT classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93" WIDTH = 500 HEIGHT = 150  codebase="http://java.sun.com/getjava/installer.html"><NOEMBED><XMP>');
			else if (_ns == true) document.writeln('<EMBED type="application/x-java-applet;version=1.1.2" java_CODE = "FileUploadApplet.class" java_CODEBASE = "<?=$this->applet_path()?>" java_ARCHIVE = "jupload_applet.jar" WIDTH = 500 HEIGHT = 150   pluginspage="http://java.sun.com/getjava/installer.html"><NOEMBED><XMP>');
		//--></script>
		<applet WIDTH=500 HEIGHT=150 ></XMP>
		<PARAM NAME = CODE VALUE = "jupload.jar" >
		<PARAM NAME=CODE VALUE = "FileUploadApplet.class" >
		<PARAM NAME=CODEBASE VALUE="<?=$this->applet_path()?>" >
		<!--<PARAM NAME=ARCHIVE VALUE="jupload_applet.jar" >-->
		<PARAM NAME="type" VALUE="application/x-java-applet;version=1.1.2">
		<PARAM NAME="servletURL" VALUE="<?=$this->applet_path()?>">
		<PARAM NAME="targetDir" VALUE="<?=$this->new_upload_path()?>/">
		<PARAM NAME="servletErr" VALUE="Servlet not found or not running.">
		<PARAM NAME="targetDirErr" VALUE="Target directory specified doesn't exist.">
		</APPLET>
		</NOEMBED></EMBED></OBJECT>
		<?
	}

	 ###############################################################
	# Prints only a hidden field enough so that if the form is 
	# committed, the old code is remmebered. useful for preserving
	# a bulk upload that you might work on for more than
	# on form submission
	# Shouldn't be used in conjuction with "print_interface"
	function print_remember_field() {
		echo("<input type=hidden name=\"$this->id\" value=\"$this->old_code\">");
	}


	 #####################################################
	# Returns a list of the files that have been uploaded
	function get_file_list() {
		$files = array();
		if($dir = opendir($path = $this->old_upload_path())) {
			while($file = readdir($dir)) {
				if($file[0] == '.' || is_dir("$path/$file") || is_link("$path/$file")) continue;
				$files[] = $file;
			}
		}
		return $files;
	}

	 ###################################################
	# Moves a file out into the filesystem somewhere
	function move_file($file, $new_location) {
		if(file_exists($filename = $this->old_upload_path()."/$file")) {
			return rename($filename,$new_location);
		}
		return;
	}

	 ###################################################
	# Copies a file out into the filesystem somewhere
	# since its only copied, it can be copied again
	function copy_file($file, $new_location) {
		if(file_exists($filename = $this->old_upload_path()."/$file")) {
			return copy($filename,$new_location);
		}
		return;
	}

	 ########################
	# Deletes/rejects a file
	function delete_file($file) {
		if(file_exists($filename = $this->old_upload_path()."/$file")) {
			return unlink($filename);
		}
		return;
	}


	 ###################################################################
	# Moves a file from the filesystem somewhere INTO the upload thing
	function unmove_file($file, $new_filename) {
		if(file_exists($file)) {
			return rename($file,$this->old_upload_path()."/$new_filename");
		}
		return;
	}

	 ##################################################################
	# Copies a file from the filesystem somewhere INTO the upload thing
	# since its only copied, it can be copied again
	function uncopy_file($file, $new_filename) {
		if(file_exists($file)) {
			return copy($file,$this->old_upload_path()."/$new_filename");
		}
		return;
	}

	 
	 ################################################
	# Assuming the processing is all done, this will
	# clear up the old path like it was never there
	function clean_up() {
		if($this->old_code && file_exists($this->old_upload_path())) {
			delete_directory($this->old_upload_path());
			$this->old_code = '';
		}
	}

}#end class


?>
