<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: include/page.inc
## Desc: Functions for dealing with "page"s in the system
## $Source: /home/cvsroot/mysource/include/page.inc,v $
## $Revision: 2.68.2.30 $
## $Author: bvial $
## $Date: 2003/01/24 01:21:36 $
#######################################################################
#---------------------------------------------------------------------#


  #######################################
 # Global variables
#######################################################
global $PAGE_STATUSES, $PAGE_STATUS_COLOUR;
$PAGE_STATUSES = array (
	'L' => 'Live',
	'R' => 'SafeEditing, but Live',
	'P' => 'Pending Approval',
	'U' => 'Under Construction',
	'D' => 'Disabled',
	'A' => 'Archived',
	'E' => 'Up for Review'
);
  ###############################
 # Colour Scheme for page statii
$PAGE_STATUS_COLOUR = array (
	'L' => '99ee99', # Live					- Green
	'R' => 'ee9999', # Live, To be Replaced	- Red
	'P' => 'bb77bb', # Pending Approval		- Purple
	'U' => '9999ee', # Under Construction	- bluey/green
	'D' => 'bbbb77', # Disabled				- yellow/brown
	'A' => 'bbbbbb', # Archived				- Grey
	'E' => 'a7e8ef', # Up for Review		- yellow
);


 ###################################################################
# This class represents a web page. A Page is one of the core
# units of the MySource Web system.
class Page extends WebObject {

	var $site;      # A reference to the site this page belongs to
	var $data_path; # Directory where this page keeps its files.

	# Administrative
	var $id;
	var $siteid;
	var $parentid;

	# Descriptive
	var $name;
	var $short_name;
	var $imageid;     # a file to be used as the image
	var $description;
	var $keywords;

	# Multilingual
	var $default_languages;
	var $default_charset;

	# Order amoung peers
	var $orderno;

	# Dirs in URLs that will find this page
	var $dirs;

	# Template
	var $template;      # The template code
	var $page_template; # Instantiated (when necessary)

	# Security - read
	var $public = 1;              # Can people who aren't logged in view this site?
	var $access_grants = array(); # A list of access groupids granted access to this page

	var $replaceid = 0;

	# Secuirty - write
	var $editorids = array(); # People authorized to edit this page (not including site amins/editors)
	var $readonly_editorids = array(); # People authorised to view the page when it isn't live but can't change anything

	var $adminids = array(); # People authorized to administer this page (not including site admins/editors)

	# The files in a nicely accessible array
	var $file_index;

	var $create_date; # Timestamp of the day this page was created
	var $last_update; # Timestamp of the last time anything was changed on the site.

	# Runtime
	var $url_leftovers; # Dangling directories on the end of the URL, might be useful for the page template

	var $next_action; # When we next have to run an action change

	var $visible; # Is this page visible in the menu
	var $ssl;	# Is this page to be SSL encrypted

	# Designid and potentially loaded unserialized design object
	var $designid = 0; # if no design inherits from parent
	var $site_design;  # Unserialized

	var $_page_backend;  # an object holding the current page_backend for this site


	 ##############################
	# Constructor
	function Page($pageid) {
		WebObject::WebObject();
		 #################################################
		# Load the information if an id is specified
		if ($pageid) {
			return $this->load($pageid);
		}
	}

	 #########################################################
	# perform some actions before the object is serialised
	function __sleep() {
		$result = WebObject::__sleep();
		array_remove_element('_page_backend',$result);
		array_remove_element('site_design',$result);
		array_remove_element('data_path',$result);
		return $result;
	}#end __sleep()


	 ######################################################################
	# Create a new site record in the database and load it into this object
	function create($name,$template,$siteid,$parentid,$status='U') {
		$db = &$this->get_db();
		if (!$name)
			return Array(MYSOURCE_ERROR_CODE_ERROR, 'Unable to create page: please specify a name.');
		if (!$siteid)
			return Array(MYSOURCE_ERROR_CODE_ERROR, 'Unable to create page: invalid siteid.');
		# Verify site's existance
		$site = &$this->get_site($siteid);
		if(!$site->id)
			return Array(MYSOURCE_ERROR_CODE_ERROR, 'Unable to create page: site could not be found.');
		$index = &$site->get_page_index();

		# Verify parent's existance
		if($parentid) {
			$parent_data = &$index[$parentid];
			if(!$parent_data['pageid'])
				return Array(MYSOURCE_ERROR_CODE_ERROR, 'Unable to create page: specified parent could not be found in site.');
		} else $parent_data = &$index[($parentid = 0)];

		$orderno = count($parent_data['childids']) + 1;

		# Let's do it
		if (!$pageid = $db->insert("INSERT INTO page (name,short_name,siteid,parentid,orderno,create_date,last_update) VALUES ('".addslashes($name)."','".addslashes($name)."','$siteid','$parentid','$orderno',now(),now())"))
			return Array(MYSOURCE_ERROR_CODE_ERROR, 'Unable to create page: database error.');

		$site->clear_page_index();
		$index = &$site->get_page_index();

		# Okay, we have a page record.. inform the web system
		# lets pack stuff into it.
		$this->load($pageid);
		$this->web_system->register_new_page($this->id,$this);

		# Make a directories.
		if (!create_directory($this->data_path)) {
			$this->delete();
			return Array(MYSOURCE_ERROR_CODE_ERROR, 'Unable to create page directory.');
		}

		# Create a directory for the thumbs & templates in the web path
		# - assume this'll work if we got this far
		create_directory($this->data_path.'/thumbs');
		create_directory($this->data_path.'/template');
		create_directory($this->data_path.'/site_design');
		$message = "Page $name created.\n";

		# Set up the template
		$this->template = '';
		$message .= $this->set_template($template)."\n";

		list($tmp_message,$relocation) = $this->add_status($status);
		$message .= $tmp_message."\n";

		# Inherit parent's access permissions
		if($this->parentid) {
			$message .= $this->set_public($parent_data['public'])."\n";
			$message .= $this->set_visible($parent_data['visible'])."\n";
			$message .= $this->set_ssl($parent_data['ssl'])."\n";
			$message .= $this->update_access_grants($parent_data['access_grants'])."\n";
		} else {
			$message .= $this->set_public($site->public)."\n";
			$message .= $this->set_visible(1)."\n";
			$message .= $this->update_access_grants($site->access_grants)."\n";
		}

		# Register a virtual path
		$message .= $this->update_dirs(array(strtolower($name)))."\n";

		$this->clear_cache();

		return Array(MYSOURCE_ERROR_CODE_NONE, ereg_replace("[\n]+","\n",$message));
	}



	 ################################################
	# Loads all the site information into the object
	function load($pageid) {
		$pageid = abs((int)$pageid);
		$session = &get_mysource_session();

		if (!$pageid && !($pageid = $this->id)) { # Tries "re"loading
			$this->_set_error('Attempt to load page without a valid pageid.',__FILE__,__LINE__);
			return;
		}

		 #################
		# Check the cache
		if ($this->load_from_cache($pageid)) {
			$this->data_path = get_data_path($this->effective_unrestricted(), 'page/'.$this->id);
			if($this->next_action <= date('Y-m-d H:i:s') && $this->next_action != '0000-00-00 00:00:00') {
				$this->clear_cache();
				$this->load($this->id);
			}
			# If this page status is safe edit, then we have to load page set to replace us as it may want to delete us.
			if($this->status($this->id) == 'R') {
				$db = &$this->get_db();
				if($pid = $db->single_element("SELECT pageid FROM page WHERE replaceid='$this->id' AND next_action < now() AND next_action != '0000-00-00 00:00:00'")) {
					$p = &$this->get_page($pid);
					$this->clear_cache();
					$this->load($this->id);
				}
			}
			return $pageid;
		}

		 #######################################
		# Okay, no cache load from the database
		$db = &$this->get_db();
		list(
			$this->id,
			$this->siteid,
			$this->parentid,
			$this->orderno,
			$this->name,
			$this->short_name,
			$this->description,
			$this->keywords,
			$this->template,
			$this->public,
			$this->replaceid,
			$this->default_languages,
			$this->default_charset,
			$this->create_date,
			$this->last_update,
			$this->next_action,
			$this->visible,
			$this->ssl,
			$this->designid,
			$this->imageid
		) = $db->single_row("SELECT pageid, siteid, parentid, orderno, name, short_name, description, keywords, template, public, replaceid, default_languages, default_charset, create_date, last_update, next_action, visible, ssl, designid, imageid FROM page WHERE pageid='$pageid'");


		if($this->id != $pageid) {
			return;
		}

		# Lets set the data path before and after changing statuses
		$this->data_path = get_data_path($this->effective_unrestricted(), 'page/'.$this->id);

		 ##################
		# Load more stuff!
		$this->dirs  = $db->single_column("SELECT dir FROM page_dir WHERE pageid='$this->id'");

		$this->access_grants  = $db->single_column("SELECT groupid FROM page_access_grant WHERE pageid='$this->id'");
		$this->editorids      = $db->single_column("SELECT userid FROM page_editor WHERE pageid='$this->id' AND readonly=0");
		$this->readonly_editorids = $db->single_column("SELECT userid FROM page_editor WHERE pageid='$this->id' AND readonly > 0");
		$this->adminids = $db->single_column("SELECT userid FROM page_admin WHERE pageid='$this->id'");
		// parameters is serialized
		$this->adminids_parameters = $db->associative_array("SELECT userid, parameters
															 FROM page_admin
														     WHERE pageid='$this->id'");

		 ##################################################
		# Get information on the files linked to this page
		$this->file_index = $db->single_column("SELECT fileid FROM file WHERE pageid='$this->id' ORDER BY orderno");

		# Set the appropriate status for this page
		if($this->next_action <= date('Y-m-d H:i:s') && $this->next_action != '0000-00-00 00:00:00') {
			$actions = &$this->get_actions('',$this->next_action,date('Y-m-d H:i:s'));
			foreach($actions as $date => $data) {
				$next_action = $this->get_next_action_date($date);
				$this->set_next_action($next_action);
				if($data[action] == 'status') {
					$last_status = $this->get_last_status($date);
					$this->process_status_change($data['action_value'],$last_status);
					$db->insert("INSERT INTO page_action (pageid,date,action,action_value,userid) VALUES ('$this->id',now(),'status','".$data['action_value']." ','".$session->user->id."')");
				} elseif($data['action'] == 'parentid') {
					$this->move(0,$data['action_value']);
				}
			}

			$site = &$this->get_site();
			$site->clear_page_index();
			$this->restrict_data_path();
		}

		# Remember where we put things
		$this->data_path = get_data_path($this->effective_unrestricted(), 'page/'.$this->id);

		 ###################
		# Save to the cache
		$this->save_to_cache($this->id);

		return $pageid;

	}


	 ###################################################################################
	# Returns effective info - context sensitive to where the page is in the hierarchy
	function effective_public() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		return $index[$this->id]['effective_public'];
	}

	 ###################################################################################
	# Returns effective info - context sensitive to where the page is in the hierarchy
	function parent_public() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		if($this->parentid) return $index[$this->parentid]['effective_public'];
		return $site->public;
	}

	 ###################################################################################
	# Returns effective info - context sensitive to where the page is in the hierarchy
	function effective_access_grants() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		return $index[$this->id]['effective_access_grants'];
	}

	 ###################################################################################
	# Returns effective info - context sensitive to where the page is in the hierarchy
	function parent_access_grants() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		if($this->parentid) return $index[$this->parentid]['effective_access_grants'];
		return $site->access_grants;
	}

	 ##################################################################################
	# Returns the pages current status, which is stored in the site index
	function status($pageid) {
		if(!$pageid) $pageid = $this->id;
		$site = &$this->get_site();
		$index = &$site->get_page_index();
		return $index[$pageid]['status'];
	}

	 ###################################################################################
	# Returns effective info - context sensitive to where the page is in the hierarchy
	function effective_status() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		return $index[$this->id]['effective_status'];
	}

	 ############################
	# Is the page live or not?
	function live() {
		return in_array($this->effective_status(),array('L','R','E'));
	}

	 #######################################################
	# Should the page have its access unrestricted or not?
	function effective_unrestricted() {
		return $this->live() && $this->effective_public();
	}


	 ###################################################################################
	# Returns effective info - context sensitive to where the page is in the hierarchy
	function parent_status() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		if($this->parentid) return $index[$this->parentid]['effective_status'];
		return 'L';
	}

     ###################################################################################
	# Returns effective info - context sensitive to where the page is in the hierarchy
	function effective_visible() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		return $index[$this->id]['effective_visible'];
	}

	 ###################################################################################
	# Returns effective info - context sensitive to where the page is in the hierarchy
	function parent_visible() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		if($this->parentid) return $index[$this->parentid]['effective_visible'];
		return true;
	}

	 ################################################
	# Returns a pointer to this page's site
	function &get_site($siteid=0) {
		if(!$siteid) $siteid = $this->siteid;
		return $this->web_system->get_site($siteid);
	}


	 #############################
	# Returns a pointer to a page
	function &get_page($pageid=0) {
		if(!$pageid) return $this; # Idiot
		return $this->web_system->get_page($pageid);
	}


	 ##########################################
	# Returns a URL that'll point to this page
	function get_url($start_query_string=false,$force_secure) {

		$url = $this->web_system->get_page_url($this->siteid,$this->id,$force_secure);
		if ($start_query_string) {
			# if there is a question mark then append an '&' otherwise append a '?'
			$url .= (strchr($url, '?')) ? '&' : '?';
		}#end if
		return $url;
	}

	 ####################################################
	# Returns a relative HREF to this page on the front
	function get_href($start_query_string=false) {
		$href = $this->web_system->get_page_href($this->siteid,$this->id);
		if ($start_query_string) {
			# if there is a question mark then append an '&' otherwise append a '?'
			$href .= (strchr($href, '?')) ? '&' : '?';
		}#end if
		return $href;
	}

	 #########################################################################
	# Returns a href to a file associated with this site (e.g. a custom image)
	function get_file_href($filename='',$abs=false) {
		# if we are public then anyone can view our files so no piping
		if ($this->effective_unrestricted()) {
			return data_href("page/$this->id/$filename",'',$abs);
		} else {
			$site = &$this->get_site();
			return (($abs)?$site->get_url(true)."mysource_action=send_file&type=page&s=$this->siteid&p=$this->id&file=$filename": $site->get_href(true)."mysource_action=send_file&type=page&s=$this->siteid&p=$this->id&file=$filename");
		}
	}


	 #############################################
	# Returns a the href to this object's backend
	function get_backend_href() {
		global $EDIT_DIR;
		return "$EDIT_DIR/page.php?p=$this->id";
	}

	 #############################################
	# Returns a the url to this object's backend
	function get_backend_url() {
		$system_config = &get_system_config();
		$site = &$this->get_site($this->siteid);
		return rtrim($site->get_url(),'/')."/$system_config->backend_suffix/page.php?p=$this->id";
	}

	 ###################################################
	# Returns a reference the a page template object
	function &get_template() {
		$class_name = 'page_template_'.$this->template;
		if(get_class($this->page_template) != $class_name) {
			global $XTRAS_PATH;
			include_once("$XTRAS_PATH/page/templates/$this->template/$this->template.inc");
			$this->page_template = new $class_name($this->id);
		}
		return $this->page_template;
	}

	 ##########################################
	# Return a reference to a file object
	function &get_file($fileid) {
		return $this->web_system->get_file($fileid);
	}

	 ##########################################
	# Changes the name of the page
	function set_name($name,$short_name) {
		if(!$short_name) $short_name = $name;
		if(!$name) return 'Your page must have a name.';
		if(!$short_name) return 'Your page must have a short name.';
		if($name == $this->name && $short_name == $this->short_name) return '';
		$db = &$this->get_db();
		$this->name = $name;
		$this->short_name = $short_name;
		$db->update("UPDATE page SET name='".addslashes($this->name)."', short_name='".addslashes($this->short_name)."' WHERE pageid='$this->id'");
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		return "Page renamed to '$this->name' (shortened to '$this->short_name').";
	}


	 ##########################################
	# Changes the description of the page
	function set_description($description) {
		if($description == $this->description) return '';
		$db = &$this->get_db();
		$this->description = $description;
		$db->update("UPDATE page SET description='".addslashes($this->description)."' WHERE pageid='$this->id'");
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		return "Description updated for page '$this->name'.";
	}


	 ####################################
	# Changes the keyword set for a page
	function set_keywords($keywords, $process_duplicates) {
		if($keywords == $this->keywords && !$process_duplicates) return '';
		if($process_duplicates) {
			$keywords = retrieve_keywords($keywords,"$this->name $this->short_name $this->description");
			if($keywords == $this->keywords) return '';
		}
		$db = &$this->get_db();
		$this->keywords = $keywords;
		$db->update("UPDATE page SET keywords='".addslashes($this->keywords)."' WHERE pageid='$this->id'");
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		return "Keywords updated for page '$this->name'.";
	}


	 ##########################################
	# Changes the default languages of the site
	function set_default_languages($default_languages) {
		if($default_languages == $this->default_languages) return '';
		$db = &$this->get_db();
		$this->default_languages = $default_languages;
		$db->update("UPDATE page SET default_languages='".addslashes($this->default_languages)."' WHERE pageid='$this->id'");
		$this->clear_cache();
		if($this->default_languages) {
			$languages_config = &get_config('languages');
			$desc = $languages_config->name_list($this->default_languages);
		} else {
			$desc = 'System Default';
		}
		return "Default languages for page '$this->name' set to: $desc.";
	}


	 ##########################################
	# Changes the default languages of the site
	function set_default_charset($default_charset) {
		if($default_charset == $this->default_charset) return '';
		$db = &$this->get_db();
		$this->default_charset = $default_charset;
		$db->update("UPDATE page SET default_charset='".addslashes($this->default_charset)."' WHERE pageid='$this->id'");
		$this->clear_cache();
		if($this->default_charset) {
			$charsets_config = &get_config('charsets');
			return "Default character set for site '$this->name' set to {$charsets_config->charsets[$this->default_charset]}.";
		} else {
			return "Default character set for page '$this->name' set to the System Default.";
		}
	}


	 #########################################################
	# Returns the effective default character set of the site
	function &get_effective_default_charset() {
		if($this->default_charset) {
			return $this->default_charset;
		} else {
			$site = &$this->get_site();
			return $site->get_effective_default_charset();
		}
	}

	 #########################
	# Changes the page template
	function set_template($new_template) {
		if(!$new_template) return 'Unable to set new template: not specified';
		if($new_template == $this->template) return '';
		if($this->template) {
			$template = &$this->get_template();
			$message = $template->change($new_template);
		} else {
			global $XTRAS, $XTRAS_PATH;
			if(!$XTRAS->name('page/templates',$new_template)) return "New template not found for page '$this->name'.";
			include_once("$XTRAS_PATH/page/templates/$new_template/$new_template.inc");
			$class_name = 'page_template_'.$new_template;
			$this->page_template = new $class_name(0,$this->web_system);
			$message .= $this->page_template->create($this->id)."\n";
		}
		$this->template = $new_template;
		$db = &$this->get_db();
		$db->update("UPDATE page SET template='$this->template' WHERE pageid='$this->id'");
		$this->clear_cache();
		return $message;
	}

	 ########################################
	# Sets whether the page is hidden or not
	function set_visible($visible) {
		if($visible) $visible=1;
		if($visible == $this->visible) return '';
		$this->visible = $visible;
		$db = &$this->get_db();
		$db->update("UPDATE page SET visible='$visible' WHERE pageid='$this->id'");
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		return "Page '$this->name' is ".(($visible)?"now":"no longer")." visible in the menu.";
	}

	 ##############################################
	# Sets whether the page is SSl encrypted or not
	function set_ssl($ssl) {
		if($ssl) $ssl=1;
		else $ssl=0;
		if($ssl == $this->ssl) return '';
		$this->ssl = $ssl;
		$db = &$this->get_db();
		$db->update("UPDATE page SET ssl='$ssl' WHERE pageid='$this->id'");
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		return "Page '$this->name' is ".(($ssl)?"now":"no longer")." SSL encrypted.";
	}

	 ####################################################
	# Set the last status that this page has used
	function set_next_action($next_action) {
		$db = &$this->get_db();
		$this->next_action = $next_action;
		$db->update("UPDATE page SET next_action='$next_action' WHERE pageid='$this->id'");
		$this->clear_cache();
		return "Next action change set to $next_action for page '$this->name'.";
	}


	 #######################################################
	# Get actions for this page
	# Can be restricted by type, and date range
	function &get_actions($action,$startdate,$enddate) {
		$db = &$this->get_db();
		$sql = "SELECT date,action,action_value FROM page_action WHERE pageid='$this->id' AND 1=1".(($action)?" AND action='$action'":'').(($startdate)?" AND date >= '$startdate'":'').(($enddate)?" AND date <= '$enddate'":'').' ORDER BY date';
		return $db->associative_array($sql);
	}

	 #############################################################
	# Given a datetime.....return the next status
	function get_next_status($datetime) {
		if(!$datetime) $datetime = date('Y-m-d H:i:s');
		$statii = &$this->get_actions('status');
		$dates = array_keys($statii);
		if(!is_array($dates)||!count($dates)) return '';
		foreach($dates as $date) {
			if($date > $datetime) {
				return $statii[$date]['action_value'];
			}
		}
		return '';
	}

	 ###################################################
	# Given a datetime..return the status before this
	function get_last_status($datetime) {
		if(!$datetime) $datetime = date('Y-m-d H:i:s');
		$statii = &$this->get_actions('status');
		$dates = array_keys($statii);
		if(!is_array($dates)||!count($dates)) return '';
		rsort($dates);
		foreach($dates as $date) {
			if($datetime > $date) {
				return $statii[$date]['action_value'];
			}
		}
		return '';
	}

	 #############################################
	# Given a datetime...return the next parentid
	function get_next_parentid($datetime) {
		if(!$datetime) $datetime = date('Y-m-d H:i:s');
		$parentids = &$this->get_actions('parentid');
		$dates = array_keys($parentids);
		if(!is_array($dates)||!count($dates)) return '';
		foreach($dates as $date) {
			if($date > $datetime) {
				return $parentids[$date]['action_value'];
			}
		}
		return '';
	}

	 ###################################################
	# Given a datetime...return the parentid before this
	function get_last_parentid($datetime) {
		if(!$datetime) $datetime = date('Y-m-d H:i:s');
		$parentids = &$this->get_actions('parentid');
		$dates = array_keys(array_reverse($parentids));
		if(!is_array($dates)||!count($dates)) return '';
		rsort($dates);
		foreach($dates as $date) {
			if($datetime > $date) {
				return $parentids[$date]['action_value'];
			}
		}
		return '';
	}
	 #############################################################
	# Given a datetime.....return the date of the next status
	function get_next_action_date($datetime) {
		if(!$datetime) $datetime = date('Y-m-d H:i:s');
		$actions = &$this->get_actions();
		$dates = array_keys($actions);
		if(!$dates) return '';
		foreach($dates as $date) {
			if($date > $datetime) {
				return $date;
			}
		}
		return '';
	}

	 #############################################################
	# Given a datetime..return the date of the status before this
	function get_last_action_date($datetime) {
		if(!$datetime) $datetime = date('Y-m-d H:i:s');
		$actions = &$this->get_actions();
		$dates = array_keys(array_reverse($actions));
		if(!$dates) return '';
		foreach($dates as $date) {
			if($datetime > $date) {
				return $date;
			}
		}
		return '';
	}

	 #######################################
	# Add a status of the page
	# This can be in the future or right now
	function add_status($new_status,$datetime='') {
		global $PAGE_STATUSES;
		$new_status = strtoupper($new_status);
		if(!$PAGE_STATUSES[$new_status]) return Array('Unrecognised status. Unable to change.', 0);
		$db = &$this->get_db();
		$session = &get_mysource_session();

		$next_status = $this->get_next_status($datetime);
		$last_status = $this->get_last_status($datetime);

		$reject_future = false;
		$reject_past   = false;

		switch($new_status) {
			case 'L':
				if(in_array($next_status,array('P'))) $reject_future = true;
				break;
			case 'U':
				if(in_array($last_status,array('R'))) $reject_past = true;
				elseif(in_array($next_status,array('E'))) $reject_past = true;
				break;
			case 'D':
				if(in_array($last_status,array('R'))) $reject_past = true;
				elseif(in_array($next_status,array('P','R','E'))) $reject_future = true;
				break;
			case 'A':
				if(in_array($last_status,array('R'))) $reject_past = true;
				elseif(in_array($next_status,array('P','R','E'))) $reject_future = true;
				break;
			case 'P':
				if($last_status == 'R' || $last_status == 'L' || $last_status == 'D' || $last_status == 'A' || $last_status == 'E') $reject_past = true;
				elseif(in_array($next_status,array('R','E'))) $reject_future = true;
				break;
			case 'R':
				if(in_array($last_status,array('P','U','D','A','E'))) $reject_past = true;
				elseif(in_array($next_status,array('P','U','D','A','E')))   $reject_future = true;
				break;
			case 'E':
				if(in_array($last_status,array('P','U','D','R','A'))) $reject_past = true;
				elseif(in_array($next_status,array('P','R'))) $reject_future = true;
				break;
		}

		# If an error message is generated, then lets return it
		if($reject_past)       return Array('Cannot set the status to '.$PAGE_STATUSES[$new_status].' as this page '.(($datetime)?'will be':'is').' '.$PAGE_STATUSES[$last_status], 0);
		elseif($reject_future) return Array('Cannot set the status to '.$PAGE_STATUSES[$new_status].' as this page is about to be '.$PAGE_STATUSES[$next_status], 0);

		$site = &$this->get_site();

		# If no datetime, then lets change the status now
		if(!$datetime) {
			list($result,$message,$redirect_pageid) = $this->process_status_change($new_status,$last_status);
			if($result) {
				$db->insert("INSERT INTO page_action (pageid,date,action,action_value,userid) VALUES ('$this->id',now(),'status','".$new_status." ','".$session->user->id."')");
				$message .= "Page '$this->name' status set to {$PAGE_STATUSES[$new_status]}.";
			}
		} else {
			if($datetime <= date('Y-m-d H:i:s')) return array('Unable to add past status.','');;
			$statii = &$this->get_actions('status');
			if($statii[str_replace(':[0-9][0-9]$','',$datetime)]) return array('A future status is already set this for this time.');
			$db->insert("INSERT INTO page_action (pageid,date,action,action_value,userid,log) VALUES ('$this->id','$datetime','status','".$new_status."','".$session->user->id."','')");
			$next_action = $this->get_next_action_date(date('Y-m-d H:i:s'));
			$this->set_next_action($next_action);
			$message = "Future status {$PAGE_STATUSES[$new_status]} added to this page '$this->name'.";
		}
		$site->clear_page_index();
		$this->restrict_data_path();
		$this->clear_cache();
		return array($message,$redirect_pageid);
	}

	 ########################
	# Remove a future status
	function remove_status($datetime) {
		global $PAGE_STATUSES;
		$db = &$this->get_db();
		if($datetime <= date('Y-m-d H:i:s')) 'Unable to delete past status.';
		# There are some rules which prevent you from changin statuses willy nilly....
		$next_status = $this->get_next_status($datetime);
		$last_status = $this->get_last_status($datetime);

		switch($last_status) {
			case 'L':
				if(in_array($next_status,array('P'))) $reject = true;
				break;
			case 'U':
				if(in_array($last_status,array('R','E'))) $reject = true;
				break;
			case 'D':
				if(in_array($next_status,array('P','R','E'))) $reject = true;
				break;
			case 'A':
				if(in_array($next_status,array('P','R','E'))) $reject = true;
				break;
			case 'P':
				if(in_array($next_status,array('R','E'))) $reject = true;
				break;
			case 'R':
				if(in_array($next_status,array('P','U','D','A','E')))   $reject = true;
				break;
		}

		# If an error message is generated, then lets return it
		if($reject) return 'Cannot remove this status as this page will then have a status of '.$PAGE_STATUSES[$last_status].' before it is set to go '.$PAGE_STATUSES[$next_status];

		if($db->delete("DELETE FROM page_action WHERE pageid='$this->id' AND date='$datetime' AND action='status'")) {
			$next_action = $this->get_next_action_date(date('Y-m-d H:i:s'));
			$this->set_next_action($next_action);
			$this->clear_cache();
			return 'Future page status deleted.';
		} else return 'Unable to delete future page status.';
	}

	 ######################################################
	# Changes the pages status - can get complicated
	# Return true if the status was changed, otherwise false
	function process_status_change($new_status,$old_status) {
		global $PAGE_STATUSES;
		# If no old status passed in then lets use the pages current status
		if(!$old_status) $old_status = $this->status();
		# If we are not changing status, then return, else process the status change and set the last used status
		if($old_status == $new_status) return array(false,'Status already set to '.$PAGE_STATUSES[$new_status]);
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		$session = &get_mysource_session();

		switch($new_status) {
			case 'U': # Under construction
				return array(true);
				break;
			case 'P': # Pending

				$t = $this->web_system->master_email;

				# Lets try and mail all the site administrators
				$users_system= &get_users_system();
				$admin_mail = "The page at:\n\n\t".$this->get_url()."\n\nhas had it's status changed to '".$PAGE_STATUSES[$new_status]."'.\n\nYou can now go to the backend at:\n\n\t".$this->web_system->get_backend_url()."/".$this->get_backend_href()."\n\nand process the page accordingly.";
				//send email to site admins
				if (count($site->adminids_parameters)) {
					while(list($id, $unserialized)=each($site->adminids_parameters)) {
						$parameters = unserialize($unserialized);
						$user = $users_system->get_user($id);
						if (array_key_exists('email_adminids',$parameters)) $email_flag = $parameters['email_adminids'];
						else $email_flag=0;
						if ($email_flag) {
							if($user->email) {
								mail($user->email,'MySource Page Status Change',$admin_mail,'From: '.$session->user->email);
							}
						}
					}
				}
				// turning off the feature to email super admins indefinetely or at least until the parameter thing is sorted out
				/*else {
					mail($this->web_system->master_email,"MySource Page Status Change",$admin_mail,"from: ".$session->user->email);
					}*/
				//send email to page admins
				if (count($this->adminids_parameters)) {
					while(list($id, $unserialized)=each($this->adminids_parameters)) {
						$parameters = unserialize($unserialized);
						$user = $users_system->get_user($id);
						if (array_key_exists('email_adminids',$parameters)) $email_flag = $parameters['email_adminids'];
						else $email_flag=0;
						if ($email_flag) {
							if($user->email) {
								mail($user->email,'MySource Page Status Change',$admin_mail,'From: '.$session->user->email);
							}
						}
					}
				}
				return array(true);
				break;
			case 'L': # Live
				if($old_status == 'R') { # Cancelling a SafeEdit!
					$db = &$this->get_db();
					if($replacementid = $db->single_element("SELECT pageid FROM page WHERE replaceid='$this->id'")) {
						# We may not get in here, that's okay .. see the elseif for a reason
						$replacement_page = &$this->get_page($replacementid);
						$message .= $replacement_page->delete()."\n";
						return array(false,trim(ereg_replace("[\r\n]+","\n",$message)),$this->id);
					}
				} elseif($this->replaceid) { # Replacing a SafeEdit!
					# First steal the SafeEdited page's subpages! Mwaha
					$replaceid = $this->replaceid; # We need to remember this
					$subpageids = $index[$replaceid]['childids'];
					foreach($subpageids as $subpageid) {
						$subpage = &$this->get_page($subpageid);
						$message .= $subpage->move(0,$this->id)."\n";
					}
					# And now steal
					# The page we're deleting can't find us, and won't take us down with it.
					$message .= $this->set_replaceid(0)."\n";
					if($doomed_page = &$this->get_page($replaceid)) {
						# Steal its identity just before we kill it
						$grabbed_dirs = $doomed_page->dirs;
						$message .= $doomed_page->delete(true)."\n";
					} # else.. its gone.. oh, no use crying over spilt milk
					# Now we take over its ID
					$message .= $this->newid($replaceid)."\n";
					$message .= $this->update_dirs($grabbed_dirs)."\n"; # heh heh heh!
					return array(true,trim(ereg_replace("[\r\n]+","\n",$message)),$replaceid);
				}
				return array(true);
				break;
			case 'R': # Live, to be Replaced
				$dupe_message = $session->get_var('dupe_message');
				# NOTE: we don't want the to dupe the page dirs as well because
				#       when we make the Under Construction page live it will replace our original set
				#       of page dirs with its own which have been incremented
				$replacementid = $this->dupe(0,$this->parentid, true, true, true);
				#(parentid,siteid,ignore_subpages,ignore_page_dirs,ignore_max_pages)
				$message .= $dupe_message."\n";
				$replacement_page = &$this->get_page($replacementid);
				$message .= $replacement_page->set_replaceid($this->id)."\n";
				$message .= $replacement_page->add_editorid($session->user->id)."\n";
				$message .= $replacement_page->set_orderno($this->orderno)."\n";
				$replacement_page->clear_cache();
				return array(true,trim(ereg_replace("[\r\n]+","\n",$message)),$replacement_page->id);
				break;
			case 'D': # Disabled
				if($this->replaceid) return array(false,'This page is a designated SafeEdit replacement page and cannot be disabled. Please cancel the SafeEdit.');
				return array(true);
				break;
			case 'A': # Archived
				if($this->replaceid) return array(false,'This page is a designated SafeEdit replacement page and cannot be archived. Please cancel the SafeEdit.');
				return array(true);
				break;
			case 'E': # Up for Review
				# Lets try and mail all the site administrators
				$users_system= &get_users_system();
				$admin_mail = "The page at:\n\n\t".$this->get_url()."\n\nhas had it's status changed to '".$PAGE_STATUSES[$new_status]."'.\n\nYou can now go to the backend at:\n\n\t".$this->web_system->get_backend_url()."/".$this->get_backend_href()."\n\nand process the page accordingly.";
				//send email to site admins
				if (count($site->adminids_parameters)) {
					while(list($id, $unserialized)=each($site->adminids_parameters)) {
						$parameters = unserialize($unserialized);
						$user = $users_system->get_user($id);
						if (array_key_exists('email_adminids',$parameters)) $email_flag = $parameters['email_adminids'];
						else $email_flag=0;
						if ($email_flag) {
							if($user->email) {
								mail($user->email,'MySource Page Status Change',$admin_mail,'From: '.$session->user->email);
							}
						}
					}
				}
				// turning off the feature to email super admins indefinetely or at least until the parameter thing is sorted out
				//else mail($this->web_system->master_email,"MySource Page Status Change",$admin_mail,"from: ".$session->user->email);
				//send email to page admins
				if (count($this->adminids_parameters)) {
					while(list($id, $unserialized)=each($this->adminids_parameters)) {
						$parameters = unserialize($unserialized);
						$user = $users_system->get_user($id);
						if (array_key_exists('email_adminids',$parameters)) $email_flag = $parameters['email_adminids'];
						else $email_flag=0;
						if ($email_flag) {
							if($user->email) {
								mail($user->email,'MySource Page Status Change',$admin_mail,'From: '.$session->user->email);
							}
						}
					}
				}
				return array(true);
				break;
			default:
				return array(false);
				break;
		}
	}

	 #################################################################################
	# Sets the replacement id - the page that this page wll replace when it goes live
	function set_replaceid($replaceid) {
		$replaceid = max(0,(int) $replaceid);
		if($replaceid == $this->replaceid) return '';
		$this->replaceid = $replaceid;
		$db = &$this->get_db();
		$db->update("UPDATE page SET replaceid='$replaceid' WHERE pageid='$this->id'");
		if($replaceid) {
			return "Page ID $this->id marked as replacement.";
		} else {
			return "Page '$this->name' has replaced SafeEdited page.";
		}
	}


	 ################################################################
	# Explicitly sets the orderno of a page - usually done elsewhere
	function set_orderno($orderno) {
		if($orderno == $this->orderno) return '';
		$this->orderno = $orderno;
		$db = &$this->get_db();
		$db->update("UPDATE page SET orderno='$orderno' WHERE pageid='$this->id'");
		return "Page '$this->name' been reordered.";
	}


	 ###########################################
	# Update the list URLs pointing to this site
	function update_dirs($new_dirs) {
		array_clear_blanks($new_dirs);

		$db = &$this->get_db();
		# Remove the old ones
		foreach($this->dirs as $dir) {
			if(!in_array($dir,$new_dirs)) {
				$message .= $this->_remove_dir($dir)."\n";
			}
		}
		$dir_count = 0;
		$old_this_dirs = $this->dirs;
		$this->dirs = array();
		foreach($new_dirs as $dir) {
			# Um this needs more useful checking too
			if(in_array($dir,$old_this_dirs)) {
				if($db->update("UPDATE page_dir SET orderno='$dir_count' WHERE dir='".addslashes($dir)."' AND pageid='$this->id'")) {
					$reordered = true;
				}
				$this->dirs[] = $dir;
			} else {
				$message .= $this->_add_dir($dir,$dir_count)."\n";
			}
			$dir_count++;
		}

		if($reordered) $message .= "Virtual paths reordered on page '$this->name'.\n";
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		return trim($message);
	}


	 #############################################
	# Sets a dir as pointing to a particular page
	# SHOULD NEVER BE CALLED EXCEPT BY UPDATE_DIRS (above)
	function _add_dir($dir,$orderno) {
		# Check this thing out
		$dir = ereg_replace("[ \t\n\r]+","_",$dir); # Spaces! Grr!
		# http://www.w3.org/Addressing/URL/5_URI_BNF.html
		$dir = ereg_replace("[^a-zA-Z0-9\$\-\_\@\.\&\!\*\(\)\,]","",$dir);
		$dir = str_replace("\\","",$dir); # Backslashes! GRR!
		if(!$dir) return "";
		$site = &$this->get_site();
		$site_index = &$site->get_page_index();
		$unique = false;
		while(!$unique) {
			$unique = true;
			foreach($site_index[$this->parentid]['childids'] as $siblingid) {
				if(in_array($dir,$site_index[$siblingid]['dirs'])) { # Already exists!
					$dir = increment_filename($dir);
					$unique = false;
					break;
				}
			}
		}
		$db = &$this->get_db();
		if($this->web_system->register_page_dir($this->siteid,$this->id,$dir)) {
			if ($db->insert("INSERT INTO page_dir (pageid,dir,orderno) VALUES('$this->id','".addslashes($dir)."','$orderno')")) {
				$this->dirs[] = $dir;
				$site_index[$this->id]['dirs'] = $this->dirs;
				return "Added virtual path '$dir' to page '$this->name.'";
			}
			$this->web_system->unregister_page_dir($this->siteid,$this->id,$dir);
		}
		return "Could not add the virtual path '$dir' to page '$this->name'.";
	}


	 #####################################################
	# Stops a URL from pointing to a particular site
	# SHOULD NEVER BE CALLED EXCEPT BY UPDATE_DIRS (above)
	function _remove_dir($dir) {
		if(!$dir) return '';
		$db = &$this->get_db();
		for(reset($this->dirs); is_int($i = key($this->dirs)); next($this->dirs)) {
			if($dir == $this->dirs[$i]) {
				unset($this->dirs[$i]);
				$removed = 1;
				break;
			}
		}
		if ($removed && $db->delete("DELETE FROM page_dir WHERE pageid='$this->id' AND dir='".addslashes($dir)."'")) {
			$this->web_system->unregister_page_dir($this->siteid,$this->id,$dir);
			return "Removed virtual path '$dir' from page '$this->name'.";
		}
		return "Could not remove the virtual path '$dir' from page '$this->name'.";
	}

	 ########################################################
	# Okay, lets add a future move the the page action table
 	function add_parentid($parentid,$datetime) {
		if(!$parentid && $parentid != '0') return '';
		if($parentid == $this->id) return 'You can\'t make a page a subpage of itself.';

		$last_parentid = $this->get_last_parentid($datetime);
		$last_parent = &$this->get_page($last_parentid);

		if($last_parentid == $parentid) return 'You tried to move a page to the same position.';
		$subpageids = $last_parent->get_all_subpageids();
		if(in_array($parentid,$subpageids)) return 'You tried move a page underneath one of its subpages.';
		$db = &$this->get_db();
		$site = &$this->get_site();
		if($datetime <= date('Y-m-d H:i:s')) return 'Unable to add future page parentid in the past.';
		$parentids = &$this->get_actions('parentid');
		if($parentids[str_replace(':[0-9][0-9]$','',$datetime)]) return 'A future page parentid is already set this for this time.';

		$session = &get_mysource_session();
		$db->insert("INSERT INTO page_action (pageid,date,action,action_value,userid,log) VALUES ('$this->id','$datetime','parentid','$parentid','".$session->user->id."','')");
		$next_action = $this->get_next_action_date(date('Y-m-d H:i:s'));
		$this->set_next_action($next_action);
		$site->clear_page_index();
		$this->clear_cache();
		return 'Future page parentid added.';

	}

	 ############################################
	# Remove future parentid from this page
	function remove_parentid($datetime) {
		$db = &$this->get_db();
		if($datetime <= date('Y-m-d H:i:s')) 'Unable to delete past page parentid.';
		if($db->delete("DELETE FROM page_action WHERE pageid='$this->id' AND date='$datetime' AND action='parentid'")) {
			$next_action = $this->get_next_action_date(date('Y-m-d H:i:s'));
			$this->set_next_action($next_action);
			$this->clear_cache();
			return 'Future page parentid deleted.';
		} else return 'Unable to delete future page parentid.';
	}

	 #############################################################
	# Sets the parentid, and siteid - essentially moves the page.
	function move($siteid,$parentid) {
		$parentid = max(0,(int) $parentid);
		if(!$siteid) $siteid = $this->siteid;
		if($parentid == $this->parentid && $this->siteid == $siteid) return '';
		$subpageids = $this->get_all_subpageids();
		if($this->id == $parentid) return 'You can\'t make a page a subpage of itself. This would destroy the very fabric of the space-time contiuum.';
		if(in_array($parentid,$subpageids)) return 'You tried move a page underneath one of its subpages. This would have been terribly confusing, so it hasn\'t happened.';
		$site  = &$this->get_site();

		$from = '';
		$to   = '';

		# Okay, before we do this, let's unregister all our urls
		$old_dirs = $this->dirs;
		$this->update_dirs();

		if($siteid != $this->siteid) {
			# if this page is particpating in SafeEditing, then can't move to another site
			if ($this->status() == 'R' || $this->replaceid) {
				return 'You can\'t move this page to another site, it is participating in a SafeEdit';
			}
			$new_site  = &$this->get_site($siteid);
			# Update all the siteids
			$db = &$this->get_db();
			$pageids = $subpageids;
			array_push($pageids, (int) $this->id);
			$db->update("UPDATE page SET siteid='$siteid' WHERE pageid IN ('".implode("','", $pageids)."')");

			# Clear the caches of the kids for them
			foreach($subpageids as $subpageid) $this->clear_cache($subpageid);
			$from = "site $site->name, ";
			$to   = "site $new_site->name, ";
			$new_site->clear_page_index();
		} else {
			$new_site = &$site;
		}
		$site->clear_page_index();
		$index     = &$site->get_page_index();
		$new_index = &$new_site->get_page_index();
		if(!isset($new_index[$parentid])) return "Page '$this->name' could not be moved - specified parent does not exist in site.";
		if($this->parentid) $from .= "beneath page '" . $index[$this->parentid]['short_name']."'";
		else                $from .= "at the site root";
		if($parentid)       $to   .= "beneath page '" . $new_index[$parentid]['short_name']."'";
		else                $to   .= "at the site root";
		$this->parentid = $parentid;
		$this->siteid   = $siteid;
		$db = &$this->get_db();
		$db->update("UPDATE page SET parentid='$parentid' WHERE pageid='$this->id'");
		$new_site->clear_page_index();
		$this->restrict_data_path();
		$this->clear_cache();
		# Remember what our directory names were
		$this->update_dirs($old_dirs); # If there are any clashes, they should be handled
		return "Page '$this->name' has been moved from $from, to $to.";
	}


	 #################################################
	# Returns a list of the childids of this page
	function get_subpageids() {
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		return $index[$this->id]['childids'];
	}

	 #################################################
	# Returns a list of ALL the childids of this page
	function get_all_subpageids($pageid) {
		if(!$pageid) $pageid = $this->id;
		$site  = &$this->get_site();
		$index = &$site->get_page_index();
		$result = $index[$pageid]['childids'];
		foreach($index[$pageid]['childids'] as $childid) {
			$result = array_merge($result,$this->get_all_subpageids($childid));
		}
		return ($result) ? $result : Array();
	}


	 ########################################
	# Sets whether the site is public or not
	function set_public($public) {
		$public = (int) $public;
		if($public == $this->public) return '';
		$this->public = $public;
		$db = &$this->get_db();
		$db->update("UPDATE page SET public='$public' WHERE pageid='$this->id'");
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		$this->restrict_data_path();
		return "Page '$this->name' is ".(($public)?"now":"no longer")." available to the public.";
	}


	 ###########################################
	# Update the list of allowed grants
	function update_access_grants($new_grants) {
		list($a,$r) = array_compare($new_grants, $this->access_grants);
		foreach($a as $add) {
			$message .= $this->add_access_grant($add)."\n"; }
		foreach($r as $rem) {
			$message .= $this->remove_access_grant($rem)."\n";}
		return trim($message);
	}

	 #######################################
	# Adds a new access grant
	function add_access_grant($groupid) {
		if(!$groupid) return 'Access group not specified for access granting.';
		if(in_array($groupid,$this->access_grants)) return '';
		$site = &$this->get_site();
		$name = $site->access_groups[$groupid];
		if(!$name) {
			$general_access_groups = &$this->web_system->get_general_access_group_list();
			$name = $general_access_groups[$groupid];
		}
		if(!$name) $name = $groupid;
		$this->access_grants[] = $groupid;
		$db = &$this->get_db();
		if (!$db->insert("INSERT INTO page_access_grant (groupid, pageid) VALUES ('$groupid','$this->id')")) {
			return "Unable to grant access to $name: database error.";
		}
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		return "Access granted to access group '$name' on page '$this->name'.";
	}


	 #######################################
	# Removes an access grant
	function remove_access_grant($groupid) {
		if(!$groupid) return 'Access group not specified for access denying.';
		if(!in_array($groupid,$this->access_grants)) return '';
		$site = &$this->get_site();
		$name = $site->access_groups[$groupid];
		if(!$name) {
			$general_access_groups = &$this->web_system->get_general_access_group_list();
			$name = $general_access_groups[$groupid];
		}
		if(!$name) $name = $groupid;
		$db = &$this->get_db();
		foreach($this->access_grants as $k => $id) {
			if ($id == $groupid) {
				unset($this->access_grants[$k]);
				break;
			}
		}
		if (!$db->delete("DELETE FROM page_access_grant WHERE groupid='$groupid' AND pageid='$this->id'")) {
			return "Unable to deny access to $name: database error.";
		}
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		return "Access denied to access group '$name' on page '$this->name'.";
	}


	function update_editorids($new_editorids, $new_readonly_editorids) {
		list($a,$r) = array_compare($new_editorids, $this->editorids);
		list($a2,$r2) = array_compare($new_readonly_editorids, $this->readonly_editorids);
		foreach($r as $rem)
			$message .= $this->remove_editorid($rem)."\n";
		foreach($r2 as $rem)
			$message .= $this->remove_editorid($rem)."\n";
		foreach($a as $add)
			$message .= $this->add_editorid($add)."\n";
		foreach($a2 as $add)
			$message .= $this->add_editorid($add,1)."\n";
		return trim($message);
	}


	 ########################
	# Adds a new site editor
	function add_editorid($userid, $readonly = 0) {
		if(!$userid) return 'Editor ID not specified for assignment.';
		if(in_array($userid,$this->editorids)||in_array($userid,$this->readonly_editorids)||in_array($userid, $this->adminids)) return '';
		$db = &$this->get_db();
		if($readonly) $this->readonly_editorids[] = $userid;
		else          $this->editorids[] = $userid;
		$readonly = (int) $readonly;
		if (!$db->insert("INSERT INTO page_editor (userid, pageid, readonly) VALUES ('$userid','$this->id','$readonly')")) {
			return 'Unable to add page editor: database error.';
		}
		$this->clear_cache();
		$users_system = &get_users_system();
		$editor = &$users_system->get_user($userid);
		$session = &get_mysource_session();
		if($session->user->id == $userid) $session->editor_pages[$this->siteid][] = $this->id;
		return $editor->name()." assigned as ".(($readonly)?"read-only ":"read/write ")."page editor for '$this->name'.";
	}


	 ############################
	# Removes a new site editor
	function remove_editorid($userid) {
		if(!$userid) return 'Editor ID not specified for removal.';
		if(!in_array($userid,$this->editorids)&&!in_array($userid,$this->readonly_editorids)) return '';
		$db = &$this->get_db();
		foreach($this->editorids as $k => $id) {
			if ($id == $userid) {
				unset($this->editorids[$k]);
				break;
			}
		}
		foreach($this->readonly_editorids as $k => $id) {
			if ($id == $userid) {
				$readonly = 1;
				unset($this->readonly_editorids[$k]);
				break;
			}
		}
		if (!$db->delete("DELETE FROM page_editor WHERE userid='$userid' AND pageid='$this->id'")) {
			return 'Unable to remove page editor: database error.';
		}
		$this->clear_cache();
		$users_system = &get_users_system();
		$editor = &$users_system->get_user($userid);
		return $editor->name()."'s  ".(($readonly)?"read-only ":"read/write ")."page editor privelidges have been revoked for '$this->name'.";
	}


	 #######################################
	# update the parameters
		/*
		  Want a standard way to update parameters?, look no further. Pass me the name of the
		  parameter and an array with all userids that had the parameter checkbox CHECKED. I'll
		  loop through them, compare them to the previous values and update if necessary. I might
		  need a bit of tweaking if you want me to work with other form elements.
		*/

	function update_parameter_adminids($parameter_name , $positives) {

		$users_system = &get_users_system();
		$db = &$this->get_db();
		$message = '';

		while(list($id, $params)=each($this->adminids_parameters)) {
			$parameters = unserialize($params);
			//get current value
			if (array_key_exists($parameter_name,$parameters)) $current = $parameters[email_adminids];
			else $current=0;
			//get checked ids
			if (in_array($id,$positives)) $checked = 1;
			else $checked=0;
			//compare and change if necessary
			if ($current!=$checked) {
				$parameters[$parameter_name] = $checked;
				$serialized_params = serialize($parameters);
				$this->adminids_parameters[$id] = $serialized_params;
				$db->update("UPDATE page_admin SET parameters='".addslashes($serialized_params)."' where userid='$id' AND pageid='$this->id'");
				$username = &$users_system->get_user($id);
				$message .= "$parameter_name for ".$username->name()." is now set to ".(($checked)?"on<BR>\n":"off<BR>\n");
			}
		}
		$this->clear_cache();
		return $message;
	}



	 #####################################
	# Updates list of page administrators
	function update_adminids($new_adminids) {
		list($a,$r) = array_compare($new_adminids, $this->adminids);
		foreach($r as $rem)
			$message .= $this->remove_adminid($rem)."\n";
		foreach($a as $add)
			$message .= $this->add_adminid($add)."\n";
		return trim($message);
	}


	 ################################
	# Adds a new page administrator
	function add_adminid($userid) {
		if(!$userid) return 'Administrator ID not specified for assignment.';
		//preset some parameters
		$preset_parameters ='';
		$preset_parameters[email_adminids] = 1;
		$parameters = serialize($preset_parameters);
		$db = &$this->get_db();
        $this->adminids[] = $userid;
		$this->adminids_parameters[$userid] = $parameters;
		if (!$db->insert("INSERT INTO page_admin (userid, pageid, parameters) VALUES ('$userid','$this->id','".addslashes($parameters)."')")) {
			return 'Unable to add page administrator: database error.';
		}
		$this->clear_cache();
		$users_system = &get_users_system();
		$administrator = &$users_system->get_user($userid);
		return $administrator->name()." assigned as page administrator for '$this->name'.";
	}


	 ###################################
	# Removes a new page administrator
	function remove_adminid($userid) {
		if(!$userid) return 'Administrator ID not specified for removal.';
		if(!in_array($userid,$this->adminids)) return '';
		$db = &$this->get_db();
		foreach($this->adminids as $k => $id) {
			if ($id == $userid) {
				unset($this->adminids[$k]);
				break;
			}
		}
		if (!$db->delete("DELETE FROM page_admin WHERE userid='$userid' AND pageid='$this->id'")) {
			return 'Unable to remove page administrator: database error.';
		}
		$this->clear_cache();
		$users_system = &get_users_system();
		$administrator = &$users_system->get_user($userid);
		return $administrator->name()."'s page administrator privelidges have been revoked for '$this->name'.";
	}



	  ##############################################
	 # Mark a page as updated, and delete its cache
	function updated() {
		$db = &$this->get_db();
		$db->update("UPDATE page SET last_update=now() WHERE pageid='$this->id'");
		$this->last_update = date('Y-m-d h:i:s');
		$this->clear_cache();
		$site = &$this->get_site();
		$site->updated();
	}


	  ############################################################################
	 # Returns an array of pageids representing trunk-to-twig the pages parentage
	function &get_lineage($short_name=true) {
		$name = ($short_name) ? 'short_name' : 'name';
		if(!isset($this->lineage)) {
			$site = &$this->get_site();
			$index= &$site->get_page_index();
			$pageid = $this->id;
			$result = array();
			$result[$pageid] = $index[$pageid][$name];
			while ($pageid = $index[$pageid]['parentid']) {
				$result[$pageid] = $index[$pageid][$name];
			}
			$this->lineage = array_reverse($result,1);
		}
		return $this->lineage;
	}


	 ######################################################
	# Duplicates a page and potentionally all its subpages
	function dupe($siteid, $parentid=-1, $ignore_subpages=false, $ignore_page_dirs=false, $ignore_max_pages=false, $num_pages=false, $remap=true, &$dupe_map, &$dupe_message) {
		$session = &get_mysource_session();
		if (!count($dupe_map)) $dupe_map = $session->get_var('dupe_map');
		if (trim($dupe_message) == '') $dupe_message = $session->get_var('dupe_message');
		
		if(!$siteid) $siteid = $this->siteid;
		if($parentid < 0) $parentid = $this->parentid;

		if ($ignore_max_pages) {
			# create the page without checking if this would
			# go beyond the max pages limit for the site
			$new_page = new Page(0,$this->web_system);
			$new_page->create($this->name,$this->template,$siteid,$parentid)."\n";
		} else {
			$site = &$this->get_site($siteid);
			list($error_code, $msg, $new_pageid) = $site->create_page($this->name,$this->template,$parentid);
			if ($error_code) {
				$dupe_message = $msg;
				$session->set_var('dupe_message', $dupe_message);
				return;
			}
			$new_page = &$this->get_page($new_pageid);
		}

		if(!$new_page->id) {
			$dupe_message .= "Page duping failed for page '$this->name'.\n";
			$session->set_var('dupe_message', $dupe_message);
			return;
		}

		$new_page->set_name($this->name,$this->short_name);
		$new_page->set_description($this->description);
		$new_page->set_keywords($this->keywords);

		$new_page->set_default_languages($this->default_languages);
		$new_page->set_default_charset($this->default_charset);

		$new_page->set_public($this->public);
		$new_page->set_visible($this->visible);
		$new_page->set_ssl($this->ssl);

		$new_access_grants = $this->access_grants;
		foreach($new_access_grants as $k => $id) {
			if($newid = $dupe_map['access_group'][$id]) $new_access_grants[$k] = $newid;
		}
		$new_page->update_access_grants($new_access_grants);

		# dupe page and admin ids
		$new_page->update_adminids($this->adminids);
		$new_page->update_editorids($this->editorids,$this->readonly_editorids);

		if (copy_directory($this->data_path, $new_page->data_path)) {
			$dupe_message .= "Page '$this->name' data directory copied successfully.\n";
		} else {
			$dupe_message .= "Page '$this->name' data directory could not be copied!\n";
		}

		# Dupe files
		foreach($this->file_index as $fileid) {
			$file = &$this->get_file($fileid);
			$file->dupe($new_page->id, $dupe_map, $dupe_message);
		}

		# now that we have duped the files link up the imageid
		$new_page->set_image($dupe_map['file'][$this->imageid]);


		# Duplicate the design
		if ($this->designid) {
    		$design = &$this->get_design();
    		$dupe_message .= $new_page->set_design($this->designid)."\n";
    		if ($design->save_customisation($new_page->id.".".get_class($this))) {
    			   $dupe_message .= "Design Customisation Duped.\n";
    		}
		}#end if

		# Dupe the page template
		$template = &$this->get_template();
		$template->dupe($new_page->id, $remap);


		 #######################################
		# if we want the page dirs add them
		if(!$ignore_page_dirs) {
			# Give the new page some directorys
			$new_page->update_dirs($this->dirs);
		}

		 ###################################
		# dupe the subpages as well?
		if (!$ignore_subpages) {
			if ($num_pages === false) {
				# Dupe everything
				$this->dupe_pages($siteid,$new_page->id,false,$dupe_map,$dupe_message);
			} else {
				# we will handle the rest ourselves
				# so just return the id of the new
				# parent page
				$session->set_var('dupe_map', $dupe_map);
				$session->set_var('dupe_message', $dupe_message);
				return $new_page->id;
			}
		}

		$this->dupe_remap($dupe_map);
		$this->dupe_cleanup($new_page->id);

		$session->set_var('dupe_map', $dupe_map);
		$session->set_var('dupe_message', $dupe_message);

		return $new_page->id;
	}



	function dupe_pages($siteid,$new_pageid,$num_pages=false,&$dupe_map,&$dupe_message) {
		$session = &get_mysource_session();
		if (trim($dupe_message) == '') $dupe_message = $session->get_var('dupe_message');
		if (!count($dupe_map)) $dupe_map = $session->get_var('dupe_map');

		if ($num_pages === false) {
			# Dupe everything

			# Get the subpages
			$subpageids = $this->get_subpageids();
			foreach($subpageids as $pageid) {
				# This should handle all the subpages and their files etc.
				$page = &$this->web_system->get_page($pageid);
				$dupeid .= $page->dupe($siteid,$new_pageid,false,false,false,false,true,$dupe_map);
				$dupe_map['page'][$pageid] = $dupeid;
				$this->web_system->forget_page($pageid); # so we don't blow the memory out
			}
		} else {

			$index = &$this->get_all_subpageids();
			foreach ($index as $pageid) {
				if ($pageid <= 0) continue;
				if ($pageid == $this->id) continue;
				if (isset($dupe_map['page'][$pageid])) {
					# page already duped
					continue;
				}

				if ($num_pages <= 0) {
					# we are done
					$session->set_var('dupe_map', $dupe_map);
					return;
				}

				$page = &$this->web_system->get_page($pageid);

				# check the dupe map to find out
				# what the new parentid is
				if ($page->parentid == $this->id) {
					$new_parentid = $new_pageid;
				} else {
					$new_parentid = $dupe_map['page'][$page->parentid];
					if (!$new_parentid) {
						# the parent hasnt been duped yet
						continue;
					}
				}

				$dupeid = $page->dupe($siteid,$new_parentid,true,false,false,false,false,$dupe_map,$dupe_message); # ignore subpages
				$dupe_map['page'][$pageid] = $dupeid;
				$this->web_system->forget_page($pageid); # so we don't blow the memory out
				$num_pages--;
			}
			$session->set_var('dupe_map', $dupe_map);
			$session->set_var('dupe_message', $dupe_message);
		}
	}


	function dupe_remap($num_pages=false, &$dupe_map) {
		$session  = &get_mysource_session();
		if (!count($dupe_map)) $dupe_map = $session->get_var('dupe_map');
	
		if ($num_pages === false) {
			# Remap everything

			# Get the subpages
			$subpageids = $this->get_subpageids();
			foreach($subpageids as $pageid) {
				# This should handle all the subpages and their files etc.
				$page = &$this->web_system->get_page($pageid);
				$template = $page->get_template();
				$template->remap_link_ids($dupe_map);
				$this->web_system->forget_page($pageid); # so we don't blow the memory out
			}
		} else {
			$index = &$this->get_all_subpageids();
			foreach ($index as $pageid) {
				if ($pageid <= 0) continue;
				if ($num_pages <= 0) return;

				$dupe_pageid = $dupe_map['page'][$pageid];
				if (!$dupe_pageid) continue;
				$page = &$this->web_system->get_page($dupe_pageid);
				$template = $page->get_template();
				$template->remap_link_ids($dupe_map);
				$this->web_system->forget_page($dupe_pageid); # so we don't blow the memory out
				$num_pages--;
			}
		}
	}



	function dupe_cleanup($new_pageid, &$dupe_message) {
		$session = &get_mysource_session();
		if (trim($dupe_message) == '') $dupe_message = $session->get_var('dupe_message');
		if (!count($dupe_map)) $dupe_map = $session->get_var('dupe_map');

		$new_page = &$this->get_page($new_pageid);
		$new_page->clear_cache();
		$dupe_message .= "Page '$this->name' duplicated.\n";
	}


	 #############################################
	# What do YOU think is does?
	function delete($preserve_replacement=false, $num_pages=false) {
		if($this->status() == 'R' && !$preserve_replacement) {
			list($tmp_message) = $this->add_status('L'); # This will also delete the replacement page.. mwahaha;
			$message .= $tmp_message."\n";
		}

		$site = &$this->get_site();

		if ($num_pages === false) {
			# Delete everything at once

			# Delete subpages first
			$subpageids = $this->get_subpageids();
			foreach($subpageids as $pageid) {

				# This should handle all the subpages and their files etc.
				$page = &$this->web_system->get_page($pageid);
				$message .= $page->delete()."\n";
			}

			$message .= $this->delete_cleanup();

		} else {
			# only delete $num_pages pages from the site
			$index = $this->get_all_subpageids();
			$site_index = $site->get_page_index();
			foreach ($index as $pageid) {
				if ($pageid <= 0) continue;
				if (is_array($site_index[$pageid]['childids'])) continue;
				$page = &$this->web_system->get_page($pageid);
				$message .= $page->delete()."\n";
				$num_pages--;
				if ($num_pages <= 0) {
					# we are done
					$site->clear_page_index();
					return ereg_replace("[\n]+","\n",$message);
				}
			}
		}

		$site->clear_page_index();
		return ereg_replace("[\n]+","\n",$message);
	}


	 #############################################
	# Deletes everything except the subpages
	function delete_cleanup() {

		# Remove virtual paths
		$this->update_dirs(array());

		# Delete all the file attachments
		foreach($this->file_index as $fileid) {
			$file = &$this->get_file($fileid);
			$message .= $file->delete()."\n";
		}

		 ####################################
		# Okay, lets fuck our directory off
		delete_directory($this->data_path);

		 #####################################
		# Let's kill our customised design
		if ($this->designid) {
    		$design = &$this->get_design();
    		$design->delete_customisation();
		}#end if

		# Delete the temaplte
		$template = &$this->get_template();
		$message .= $template->delete()."\n";

		# Grants, grants and more grants
		$this->update_access_grants(array());
		$this->update_editorids(array(),array());
		$this->update_adminids(array());

		$db = &$this->get_db();
		$db->delete("DELETE FROM page WHERE pageid='$this->id'");
		$db->delete("DELETE FROM page_action WHERE pageid='$this->id'");

		# Uh oh, WE'RE CANCELLING A SafeEdit REPLACEMENT
		if($this->replaceid > 0) {
			$replaced_page = &$this->get_page($this->replaceid);
			if($replaced_page->id) {
				list($tmp_message) = $replaced_page->add_status('L');
				$message .= $tmp_message."\nSafeEdit cancelled.\n";
			}
		} # OR

		$message .= "Page '$this->name' deleted.\n";
		$site = &$this->get_site();
		$site->clear_page_index();
		$this->clear_cache();
		unset($this);
		return ereg_replace("[\n]+","\n",$message);
	}



	   ##############################################
	  # Changes the page ID of an entire page.
	 # This is for the SafeEdit function
	############################################################
	# I have a bad feeling about this, but it seems necessary :)
	function newid ($newid) {
		$newid = (int) $newid;

		# Remember where we should be found
		$dirs = $this->dirs;
		$this->update_dirs(array());
		$this->clear_cache();

		# The page
		$db = &$this->get_db();
		if(!$db->update("UPDATE page SET pageid='$newid' WHERE pageid='$this->id'")) {
			return "Unable to change ID fror page '$this->name'.";
		}

		$site = &$this->get_site();
		$site->clear_page_index();

		# The subpages
		$db->update("UPDATE page SET parentid='$newid' WHERE parentid='$this->id'");
		$subpageids = $this->get_subpageids();
		foreach($subpagesids as $subpageid) {
			$this->clear_cache($subpageid);
		}

		# Update the template information for page
		$template = &$this->get_template();
		$template->newid($newid);


		# The files - TO DO
		$db->update("UPDATE file SET pageid='$newid' WHERE pageid='$this->id'");
		foreach($this->file_index as $fileid) {
			$file = &$this->get_file($fileid);
			$file->clear_cache();
		}

		# The readers
		$db->update("UPDATE page_access_grant SET pageid='$newid' WHERE pageid='$this->id'");

		# The writers
		$db->update("UPDATE page_editor SET pageid='$newid' WHERE pageid='$this->id'");
		$db->update("UPDATE page_admin  SET pageid='$newid' WHERE pageid='$this->id'");


		# The file system
		$new_data_path = get_data_path($this->effective_unrestricted(), 'page/'.$newid);
		if (!rename($this->data_path,$new_data_path)) {
			report_error(__FILE__,__LINE__,"Unable to rename page folder ($this->data_path --> $new_data_path) while changing pageid.");
			$this->id = $newid;
			$this->delete();
		}
		$this->data_path = $new_data_path;

		$this->id = $newid;

		# Refresh the virtual paths
		$this->update_dirs($dirs);

		$this->clear_cache();
		return "Page '$this->name''s ID has been changed to $this->id";
	}

	 ######################################################
	# The the current user an read/write admin of this page?
	function admin_access() {
		$site = &$this->get_site();
		$session = &get_mysource_session();
		if ($site->admin_access()) return true;
		return in_array($session->user->id,$this->adminids);
	}

	 ######################################################
	# The the current user an read/write editor of this page?
	function editor_access() {
		$site = &$this->get_site();
		$session = &get_mysource_session();
		if ($this->admin_access() || $site->editor_access()) return true;
		return in_array($session->user->id,$this->editorids);
	}


	 #####################################################
	# The the current user a read-only editor of this page
	# (read/write access also acceptable)
	function readonly_editor_access() {
		$session = &get_mysource_session();
		if ($this->editor_access()) return true;
		return in_array($session->user->id,$this->readonly_editorids) && !in_array($this->effective_status(),array('D','A'));
	}

	  ################
	 # Write-access?
	function write_access() {
		$site = &$this->get_site();
		switch($this->effective_status()) {
			# Only admins may edit live, upfroreview or pending-approval pages
			case 'L': case 'E': case 'P': return $this->admin_access();
			# Editors may only edit Under Consturction ages
			case 'U': return $this->editor_access();
			# These statuses are off limits to all
			case 'D': case 'A': case 'R': default: return false;
		}
	}

	  #########################################
	 # Can the current user delete this page?
	function delete_access() {
		$site = &$this->get_site();
		return (
			($site->admin_access() && $this->effective_status() != 'R') # Admins can, sure
			|| (
				$site->editor_access() # Editors can, yes, but only of fhte page is U or P
				&&  ($this->effective_status() == 'U' || $this->effective_status() == 'P')
				&& !count($this->get_subpageids()) # Also not subpages !
			)
		);
	}


	 ################################################################
	# If the person allowed to view information about/on this page?
	function read_access() {
		if($this->readonly_editor_access()) return true;
		$site = &$this->get_site();
		return $site->page_read_access($this->id);
	}



	 ##############################################################################
	# Determines what rights the current user has when it comes to status-changing
	function change_status_access() {
		# Determine the options they have for changing the page status
		$site = &$this->get_site();
		switch($this->status() ) {
			case 'L':
				if($this->editor_access()) {
					$change_status['R'] = 'SafeEdit';
					$change_status['E'] = 'Up for Review';
				}
				if ($this->admin_access()) {
					$change_status['U'] = 'Place under construction';
					$change_status['D'] = 'Disable';
					$change_status['A'] = 'Archive';
				}
				break;
			case 'R':
				if($this->editor_access()) {
					$change_status['L'] = 'Cancel SafeEdit';
				}
				break;
			case 'P':
				if($this->admin_access()) {
					$change_status['L'] = 'Approve and make live';
					$change_status['U'] = 'Reject and place under construction';
					$change_status['D'] = 'Reject and disable';
					$change_status['A'] = 'Reject and archive';
				}
				if($this->editor_access() && !$this->admin_access()) {
					$change_status['U'] = 'Keep working';
				}
				break;
			case 'U':
				if($this->admin_access()) {
					$change_status['L'] = 'Make live';
					$change_status['P'] = 'Place in pending approval';
					$change_status['D'] = 'Disable';
					$change_status['A'] = 'Archive';
				}
				if($this->editor_access() && !$this->admin_access()) {
					$change_status['P'] = 'Apply for approval';
				}
				break;
			case 'D':
				if($this->admin_access()) {
					$change_status['L'] = 'Enable and make live';
				}
				if($this->editor_access()) {
					$change_status['U'] = 'Enable for working';
				}
				break;
			case 'A':
				if($this->admin_access()) {
					$change_status['L'] = 'Restore and make live';
				}
				if($this->editor_access()) {
					$change_status['U'] = 'Restore for working';
				}
				break;
			case 'E':
				if($this->admin_access()) {
					$change_status['L'] = 'Approve and make live';
					$change_status['U'] = 'Reject and place under constuction';
					$change_status['D'] = 'Reject and disable';
					$change_status['A'] = 'Reject and archive';
				}
				if($this->editor_access() && !$this->admin_access()) {
					$change_status['L'] = 'Remove Review Status';
				}
				break;
			default:
				break;

		}
		return $change_status;
	}

	  ###################################################
	 # Print a link to an image on this page
	function image_tag($file,$alt,$width,$height,$extra,$pageid=0) {

		if ($pageid && $pageid != $this->pageid) {
			$page = &$this->get_page($pageid);
			if ($page->id) {
				return $page->image_tag($file,$alt,$width,$height,$extra);
			}
		}

		# if directories are involved split the name from the dir
		$dirs = (strstr($file, '/')) ? dirname($file) : '';

		$src = $this->data_path.'/'.$file;
		$rel = $this->get_file_href($dirs);

		return $this->web_system->image_tag($src,$rel,$alt,$width,$height,$extra);
	}

	  ###################################################
	 # From the src ( without the extension ) returns the file name of
	# the image that exists
	function get_image($file,$pageid=0) {

		if ($pageid && $pageid != $this->pageid) {
			$page = &$this->get_page($pageid);
			if ($page->id) {
				return $page->get_image($file);
			}
		}
		return get_image($this->data_path.'/'.$file);
	}


	###########################################################################
	# FRONTEND STUFF
	# If passed in an access reject, then we are printing out a forbidden 403 page
	function print_frontend($force_send=false,$abs=false) {
		$system_config = &get_system_config();
		$session = &get_mysource_session();
		if(!$this->read_access()) {
			$access_reject_message = $session->get_var('access_reject_message');
			if(!$access_reject_message) $access_reject_message = 'Access to this page is restricted.';
			$session->login_screen($this->name, $access_reject_message);
		}

		if($fileid = $this->web_system->current_fileid && !$force_send) { # Ooh, someone wants a file on this page -- CHANGED
			# Actually, lets just send files through anyway
			$file = $this->web_system->get_file();
			send_cacheable_file($file->data_path.'/'.$file->filename);
			# if we are meant to log file hits, then do so
			if ($system_config->log_visitors) {
				$this->web_system->db->insert("INSERT INTO log_file_hit (fileid,sessionid,hit_time,userid) VALUES('$file->id','".session_id()."',now(),'".$session->user->id."')");
			}#end if

			return;
		} else { # Just send the page if we're at the right spot
			$this->url_leftovers = ''; # Danglin directories on the end of our URL
			if($force_send || $this->web_system->verify_page_url($this->id,$this->web_system->current_url(),$this->url_leftovers)) {
				$template = &$this->get_template();

				if($this->default_charset)
					header("Content-type: text/html; charset=$this->default_charset");
				if($this->default_languages)
					header("Content-language: $this->default_languages");

				# Should we worry about caching?
				if($system_config->moderate_caching && $template->moderate_caching()) {
					# Ensure this page (or file) doesn't get cached along the line
					header('Last-Modified: ' . gmdate('D, d M Y H:i:s',$this->get_last_update_timestamp()) . ' GMT');
					header('Expires: '.gmdate('r',time()-86400).' GMT'); # Date in the past
					header('Cache-Control: no-cache, must-revalidate'); # HTTP/1.1
					header('Pragma: no-cache');
				}
				# Okay then, send it through
				# Let the template take care of itself
				$template->print_frontend($abs);

				# if we are meant to log page hits, then do so
				if ($system_config->log_visitors) {
					$db = &$this->get_db();
					$db->insert("INSERT INTO log_page_hit (pageid,sessionid,hit_time,userid) VALUES('$this->id', '".session_id()."', now(), '".$session->user->id."')");
				}#end if
			} else {
				header('Location: '.$this->get_url());
			}
		}
	}

	 ##############################################################
	# depending on our effective publicness restrict the data path
	function restrict_data_path() {

		restrict_data_path($this->effective_unrestricted(), 'page/'.$this->id);

		# update the data path to represent our new status
		$this->data_path = get_data_path($this->effective_unrestricted(), 'page/'.$this->id);

		$subpageids = $this->get_subpageids();
		foreach($subpageids as $pageid) {
			 ###########################################################
			# This should handle all the subpages
			$page = &$this->get_page($pageid);
			$page->restrict_data_path();
			$this->web_system->forget_page($pageid); # so we don't blow the memory out
		}

	}#end restrict_data_path()

	 ###############################################################
	# return the UNIX timestamp for the last_update of this page
	function get_last_update_timestamp() {
		$db = &$this->get_db();
		return $db->datetime_to_timestamp($this->last_update);
	}

	 ################################################
	# sets the site design that this page has
	function set_design($designid) {
		if (!$designid && !$this->designid) return '';
		if ($designid == $this->designid)   return '';

		$message = '';

		# we're removing our design
		if (!$designid) {
			$design = &$this->get_design();
			if ($design->delete_customisation($designid)) {
				$this->designid = 0;
				$message .= "Design Customisation Removed\n";
			}
		# else we must be setting a design
		} else {

			# if there is an existing design try and convert it
			if ($this->designid) {
				$design = &$this->get_design();
				$message .= $design->convert_customisation($designid);
				# conversion succeeded
				if ($designid == $design->id) {
					$this->site_design = &$design;
				}

			}#end if

			$this->designid = $designid;
			$design = &$this->get_design();

			$message .= "Design set to '$design->name'";

		}#end if

		$db = &$this->get_db();
		$sql = "UPDATE page
				SET designid = '$this->designid'
				WHERE pageid='$this->id'";
		$db->update($sql);

		# because the effective_design_pageid is setup by the site's page index we need to clear that array
		$site = &$this->get_site();
		$site->clear_page_index();

		$this->clear_cache();
		return $message;

	}#end set_design()

	 #####################################################################
	# Returns a reference to the design object that this page should use
	function &get_design($abs=false) {

		if(get_class($this->site_design) != 'site_design') {

			# if we have a designid use our design
			if ($this->designid) {
    			global $INCLUDE_PATH;
    			include_once("$INCLUDE_PATH/site_design.inc");
    			$this->site_design =& new Site_Design($this->designid, $this->id.'.'.get_class($this), $this->data_path.'/site_design', $this->get_file_href('site_design/',$abs),$abs);

			# must be something further up the hierarchy
			} else {
        		$site   = &$this->get_site();
        		$index  = &$site->get_page_index();
				# if there is a page above us that has our design get it
        		if ($pageid = $index[$this->id]['effective_design_pageid']) {
    				$page = &$this->get_page($pageid);
					$this->site_design = &$page->get_design($abs);
				# the good old site will have a design for us
				} else {
					$this->site_design = &$site->get_design($abs);
				}#end if

			}#end if
		}#end if
		return $this->site_design;

	}#end get_design()

	 ##########################################
	# sets the image of the page
	function set_image($imageid) {
		if($imageid == $this->imageid) return '';

		# if they are trying to set the image, check it exists
		if ($imageid) {
			$file = &$this->get_file($imageid);
			# if not an file tell them to go away
			if (!$file->id) return Array(MYSOURCE_ERROR_CODE_ERROR, 'Unable to set the Page Image, the id you passed was not a file');
			# if not an image tell them to go away
			if (!is_image($file->filename)) return Array(MYSOURCE_ERROR_CODE_ERROR, 'Unable to set the Page Image, the file you selected is not an image');
		}

		$db = &$this->get_db();
		$this->imageid = $imageid;
		$db->update("UPDATE page SET imageid='".addslashes($this->imageid)."' WHERE pageid='$this->id'");
		$this->clear_cache();
		return Array(MYSOURCE_ERROR_CODE_NONE, 'Image '.(($this->imageid) ? 'unset' : 'set to '.$file->filename).' for page "'.$this->name.'".');
	}#end set_image()


	#########################################################################################
	#BACKEND STUFF

	 ###############################################
	# Returns a reference to the page_backend object,
	# this may already be setup by the page.
	function &_get_page_backend() {

		if (!$this->_page_backend || get_class($this->_page_backend) != 'page_backend') {
			global $INCLUDE_PATH;
			include_once("$INCLUDE_PATH/page_backend.inc");
			$this->_page_backend = new Page_Backend($this);
		}
		return $this->_page_backend;
	}

	 #########################################################################
	# Some Aliases for fns in page_Backend()
	function &setup_backend() {
		$sb = &$this->_get_page_backend();
		return $sb->setup_backend();
	}
	function print_backend() {
		$sb = &$this->_get_page_backend();
		$sb->print_backend();
	}

}#end class

?>
