<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: include/general.inc
## Desc: General misc everyday handy non-specific functions
## $Source: /home/cvsroot/mysource/include/general.inc,v $
## $Revision: 2.9.2.11 $
## $Author: bvial $
## $Date: 2003/01/24 01:21:36 $
#######################################################################

#---------------------------------------------------------------------#


/**
* Function to print an error message 
*
* If we are viewing the frontend, the error is hidden in
* the source for the page and an email is sent to the
* adminstrator
*
* @param string file	The file the error occured in
* @param string line	The line the error occured on
* @param string message The error message you want displayed
*
* @returns void
* @access public
*/
function report_error($file, $line, $message) {
	# Strip out the file path begining
	global $SYSTEM_ROOT, $IN_BACKEND;
	$file = str_replace($SYSTEM_ROOT, '', $file);
	$message = str_replace($SYSTEM_ROOT, '', $message);

	if (!$IN_BACKEND) {
		global $REPORTING_ERROR;

		if ($REPORTING_ERROR) return;
		$REPORTING_ERROR = true;

		$url = $_SERVER['HTTP_HOST'].str_replace('index.php', '', $_SERVER['PHP_SELF']);
		$date = date('F j, Y, g:i a');
		$msg = "MYSOURCE ERROR:\nDATE-TIME: $date\nURL: $url\nFILE: $file     LINE: $line\n$message\nEND ERROR";
		echo "\n\n<!-- $msg -->\n\n";

		$to_email = trim(strtolower(getenv('MySource_ReportErrorEmail')));
		if ($to_email == '') {
			# the environment variable is not set
			# so we will use the mysource web master email
			global $INCLUDE_PATH;
			include_once("$INCLUDE_PATH/config.inc");
			$conf = &get_config('MySource');
			$to_email = $conf->webmaster_email;
		}

		if (trim($to_email) != '') mail($to_email, 'MySource Error', $msg, "From: errors@".$_SERVER['HTTP_HOST']);
		$REPORTING_ERROR = false;
		return;
	}

	?>
	</script></table></table></table></table><br>
	<table bgcolor=#ffffff cellspacing=0 border=1 bordercolor=#ff0000>
		<tr>
			<td bgcolor=#993333>
				<font face=arial color=white size=-1>M<small>Y</small>S<small>OURCE</small> E<small>RROR</small>
			</td>
		</tr>
		<tr>
			<td>
				<table bgcolor=#dddddd cellpadding=2 cellspacing=0 border=0>
					<tr>
						<td><font face=arial color=red size=-1><b>File:</b></td>
						<td><font face=courier size=-1><?=$file?></td>
						<td align=right><font face=arial color=red size=-1><b>Line: </b><font face=courier color=black size=-1><?=$line?></td>
					</tr>
					<tr>
						<td valign=top><font face=arial color=red size=-1><b>Msg:</b></td>
						<td colspan=2 bgcolor=#eeeeee><font face=courier size=-1><?=$message?></td>
					</tr>
				</table>
			</td>
		</tr>
	</table><br>
	<?
}


 ############################################################
# Pipes a file through, hopefully with the correct mime/type
function send_cacheable_file($path, $alt_filename="", $alt_mimetype="", $allow_relative_backpaths = false) {
	if(!$allow_relative_backpaths) { # This can be set to true, developer MUST ensure no user-inputted data is used in the pathname
		$path = ereg_replace("^\.\.\/|\/\.\.\/",'',$path);
	}
	if(!file_exists($path)) {
		report_error(__FILE__,__LINE__, "Unable to send file, file doesn't exist: $path");
		return;
	}
	$file_types_config = &get_config("File_Types");
	$file = substr(strrchr($path,"/"),1);
	if ($alt_mimetype) {
		$type = $alt_mimetype;
	} elseif (!$type = &$file_types_config->mime_types[get_file_type($file)]) {
		$type = "text/plain";
	}
	$system_config = &get_system_config();
	$expires = (($system_config->max_idle_time)?$system_config->max_idle_time:86400); # Give 'em a day
	header("Cache-Control:");
	header("Pragma: cache");
	header("Expires: ". gmdate("D, d M Y H:i:s",time()+$expires) . " GMT");
	header("Content-Type: $type");
	header("Content-Disposition: inline; filename=".(($alt_filename)?$alt_filename:$file).";");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s",filemtime($path)) . " GMT");
	header("Content-Length: ".filesize($path));
	readfile($path);
}


 ###############################################
# Allows external code to check whether the user
# has turned the jukebox on or off
# Requires the session to be started
function mysource_jukebox() {
	$session = &get_mysource_session();
	if($_REQUEST['mysource_action'] == "jukebox") {
		if($session->get_var("jukebox")) {
			$session->unset_var("jukebox");
		} else {
			$session->set_var("jukebox",$mysource_action);
		}
	}
	return ($session->get_var("jukebox") == "jukebox");
}

 ########################################################
# Returns some mysource data for debugging purposes.
# standard is to start name with mysource_ and serialized values
# with mysource_serialized.
function &get_mysource_debug() {
	global $XTRAS;
	$system_config = &get_system_config();
	$web_system = &get_web_system();
	$mysource_debug = array("mysource_version"=>MYSOURCE_VERSION,
		"mysource_name"=>MYSOURCE_NAME,
		"mysource_long_name"=>MYSOURCE_LONG_NAME,
		"mysource_url"=>MYSOURCE_URL,
		"mysource_required_php_version"=>MYSOURCE_REQUIRED_PHP_VERSION,
		"mysource_php_version"=>phpversion(),
		"mysource_php_mysql_support"=>((function_exists(mysql))?"True":"False"),
		"mysource_required_mysql_version"=>MYSOURCE_REQUIRED_MYSQL_VERSION,
		"mysource_mysql_version"=>$web_system->db->server_version(),
		"mysource_serialized_xtras"=>serialize($XTRAS->register),
		"mysource_serialized_system_config"=>serialize($system_config)
	);
	return $mysource_debug;
}

function print_headers($headers) {
	foreach($headers as $name => $value) {
		# Validate header name and value here ( see http rfc)
		header("$name: $value");
	}
}

 ##################################################################
# Returns the prefix for making a HREF to the web directory
$WEB_URL  = '';
$WEB_HREF = '';
function web_href($src="", $start_query_string=false,$abs=false) {
	global $IN_BACKEND;
	if($abs) {
		global $WEB_URL;
		$result = &$WEB_URL;
	} else {
		global $WEB_HREF;
		$result = &$WEB_HREF;
	}
	if (!$result) {
		if ($IN_BACKEND) {
			# We make an assumption here that the edit directory is 
			# always going to be one directory above the web directory
			if($abs) {
				$result = url_protocol().'://'.$_SERVER['HTTP_HOST'].dirname(dirname($_SERVER['PHP_SELF']));
			} else {
				$result = dirname(dirname($_SERVER['PHP_SELF']));
			}
		} else {
			$web = &get_web_system();
			$site = &$web->get_site();
			if(!$site->id) {
				$db = &$web->get_db();
				$site = &$web->get_site($db->single_element("SELECT siteid FROM site"));
			}
			if($site->id) {
				if($abs) {
					$result = $site->get_url();
				} else {
					$result = $site->get_href();
				}
			} else {
				if($abs) {
					$result = url_protocol().'://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']);
				} else {
					$result = dirname($_SERVER['PHP_SELF']);
				}
			}
		}#end if IN_BACKEND
		$result.= ((substr($result, -1) != "/") ? "/" : "");
	}#end if

	if ($start_query_string) {
		# if there is a question mark then append an '&' otherwise append a '?'
		# also if the last char is a slash don't need to add another one
		$href = $result;
		$href .= (strchr($result, "?")) ? "&" : ((substr($result, -1) == "/") ? "" : "/")."?";
	} else {
		$href = &$result;
	}#end if
	return $href.$src;

}#end web_href()

 ####################################################
# Returns the prefix for making a HREF to a lib file
$LIB_URL  = '';
$LIB_HREF = '';
function lib_href($filename="",$abs=false) {
	if($abs) {
		global $LIB_URL;
		$result = &$LIB_URL;
	} else {
		global $LIB_HREF;
		$result = &$LIB_HREF;
	}
	if (!$result) $result = web_href("__lib/",false,$abs);
	return $result.$filename;
}#end lib_href()

 #########################################################
# Returns the prefix for making a HREF to a squizlib file
$SQUIZLIB_URL  = '';
$SQUIZLIB_HREF = '';
function squizlib_href($squizlib_dir, $filename="",$abs=false) {
	if($abs) {
		global $SQUIZLIB_URL;
		$result = &$SQUIZLIB_URL;
	} else {
		global $SQUIZLIB_HREF;
		$result = &$SQUIZLIB_HREF;
	}
	if (!$result) $result = web_href("__squizlib/",$abs);
	return $result."$squizlib_dir/$filename";
}#end squizlib_href()

 #################################################################
# Returns the prefix for making a HREF to the data directory file
$DATA_URL  = '';
$DATA_HREF = '';
function data_href($filename='', $web_href='',$abs=false) {
	if ($web_href) {
		return $web_href.((substr($web_href, -1) != '/') ? '/' : '').'__data/'.$filename;
	} else {
		if($abs) {
			global $DATA_URL;
			if (!$DATA_URL) $DATA_URL = web_href('__data/','',1);
			return $DATA_URL.$filename;
		} else {
			global $DATA_HREF;
			if (!$DATA_HREF) $DATA_HREF = web_href('__data/');
			return $DATA_HREF.$filename;
		}
	}
}#end data_href()

 ########################################################
# restricts or unrestricts a directory in the data path
function restrict_data_path($unrestricted, $dir) {

	$from_dir = get_data_path(!$unrestricted, $dir);
	$to_dir   = get_data_path($unrestricted,  $dir);

	# if the from dir doesn't exist, but the to dir does, then assume that we don't need to do anything
	if (!is_dir($from_dir) && is_dir($to_dir)) {
		return true;
	# if the from dir doesn't exist, leave screaming
	} elseif (!is_dir($from_dir)) {
		report_error(__FILE__, __LINE__, "Unable to move '$from_dir' to '$to_dir', '$from_dir' doesn't exist");
		return false;
	# if there is already something called the same as the to dir, leave screaming
	} elseif (file_exists($to_dir)) {
		report_error(__FILE__, __LINE__, "Unable to move '$from_dir' to '$to_dir', '$to_dir' already exists");
		return false;
	} else {
		# make sure that the parent of the to directory exists, other wise the rename will fail
		create_directory(dirname($to_dir));
		# try and rename from_dir to to_dir
		if (rename($from_dir, $to_dir)) {
			return true;
		} else {
			report_error(__FILE__, __LINE__, "Unable to move '$from_dir' to '$to_dir', rename failed");
			return false;
		}#end if
	} #end if

}#end restrict_data_path()

  ########################################################
 # returns the path for the dir depending on whether it 
# is restricted or not
function get_data_path($unrestricted, $dir){
	global $DATA_PATH;
	return $DATA_PATH.'/'.(($unrestricted) ? "un" : "").'restricted/'.$dir;
}#end get_data_path()

  ##############################################################
 # returns the static path for the dir depending
function get_static_data_path($dir){
	global $DATA_PATH;
	return $DATA_PATH.'/static/'.$dir;
}#end get_static_data_path()


/**
* Prints the status popup window.
*
* This is a nice little progress bar window you can call from your code when you need to do a heap 
* of processing that would otherwise time out. It also has the added benefit of letting the user
* know how much processing has been done. 
*
*<br>See country of origin and extract keywords wizards for examples. 
*
* @param int		$percent		Percentage (as a number) of processing that is complete.
* @param string		$process_url	URL to submit to 
* @param boolean	$start			Flag to indicate the start of processing (and the progress bar)
* @param boolean	$finish			Flag to indicate finishing the processing (and the progress bar)
* @param string		$title			Title that appears in the status bar of the popup window
* @param string		$status_message	Message to display underneath the progress bar (e.g. 1 of n pages complete)
* @returns string 
* @access public
*/ 
function status_popup($percent,$process_url,$start,$finish,$colour,$title='',$status_message='') {
	if ($percent > 100) $percent = 100;
	if($start && $finish) {
		$s = "<script>popup = window.open('$process_url','status','toolbar=no,location=no,menubar=no,resizable=no,width=400,height=100,nominimize,nomaximize,norestore,scrollbars=no'); popup.document.write(\"<html><head><title>$title</title><script language=\\\"Javascript\\\">window.opener.location='$process_url';window.close();</script></head><body bgcolor=#e0e0e0><table width=100%><tr><td><span style=\\\"font-size: 11px; color: #000000; font-family: verdana; font-weight: bold;\\\">100% completed</span></td></tr><tr bgcolor=$colour><td width=100% bgcolor=\\\"$colour\\\">&nbsp;</td></tr><tr><td align=right><span style=\\\"font-size: 10px; color: #000000; font-family: verdana; font-weight: bold;\\\">$status_message</span></td></tr></table></body></html>\");popup.focus();</script>";
	} elseif($start) {
		$s = "<script>popup = window.open('$process_url','status','toolbar=no,location=no,menubar=no,resizable=no,width=400,height=100,nominimize,nomaximize,norestore,scrollbars=no'); popup.focus();</script>";
	} elseif($finish) {
		$s = "<html><head><title>$title</title><script language=\"Javascript\">".(($process_url) ? "window.opener.location='$process_url';" : '')."window.close();</script></head><body bgcolor=#e0e0e0><table width=100%><tr><td><span style=\"font-size: 11px; color: #000000; font-family: verdana; font-weight: bold;\">100% completed</span></td></tr><tr bgcolor=#ffffff><td width=100% bgcolor=$colour>&nbsp;</td></tr><tr><td align=right><span style=\"font-size: 10px; color: #000000; font-family: verdana; font-weight: bold;\">$status_message</span></td></tr></table></body></html>";
	} elseif ($percent == 100) {
		$s = "<html><head><title>$title</title></head><body bgcolor=#e0e0e0><table width=100%><tr><td><span style=\"font-size: 11px; color: #000000; font-family: verdana; font-weight: bold;\">$percent% completed</span></td></tr><tr bgcolor=#ffffff><td width=\"$percent%\" bgcolor=\"$colour\">&nbsp;</td></tr><tr><td align=right><span style=\"font-size: 10px; color: #000000; font-family: verdana; font-weight: bold;\">$status_message</span></td></tr></table></body></html><script>function move() { window.location='$process_url'; }</script><script>window.load = move();</script>";
	} else {
		$s = "<html><head><title>$title</title></head><body bgcolor=#e0e0e0><table width=100%><tr><td colspan=2><span style=\"font-size: 11px; color: #000000; font-family: verdana; font-weight: bold;\">$percent% completed</span></td></tr><tr bgcolor=#ffffff><td width=\"$percent%\" bgcolor=\"$colour\">&nbsp;</td><td>&nbsp;</td></tr><tr><td align=right colspan=2><span style=\"font-size: 10px; color: #000000; font-family: verdana; font-weight: bold;\">$status_message</span></td></tr></table></body></html><script>function move() { window.location='$process_url'; }</script><script>window.load = move();</script>";
	}
	return $s;
}

?>