/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class FileUploadProgress
extends JFrame {
    static final int TENTH_OF_SECOND = 100;
    static final String SERVLETPATH = "servlet/FileDownloadServlet";
    static final String TARGETPATH = "uploadedfiles";
    private Timer timer;
    private String newline = "\n";
    Vector fileWithPath;
    URL codeBase;
    int totalFileByte;
    URL toURL;
    FileUploadTask task;
    ParamData paramData;
    JLabel fromLabel;
    JLabel fromFileLabel;
    JLabel toLabel;
    JLabel toFileLabel;
    JLabel byteSentLabel;
    JLabel byteFileSentLabel;
    JLabel totalByteSentLabel;
    JLabel totalByteFileSentLabel;
    JLabel progFileLabel;
    JProgressBar fileProgressBar;
    DefaultBoundedRangeModel fileProgModel;
    JLabel totalProgLabel;
    JProgressBar totalProgressBar;

    public FileUploadProgress(Vector vector, ParamData paramData) {
        super("File Upload Progress");
        Object object;
        this.paramData = paramData;
        this.codeBase = paramData.getServletURL();
        this.setToURL(this.codeBase);
        this.fileWithPath = vector;
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 10;
        container.setLayout(gridBagLayout);
        this.fromLabel = new JLabel(" From   ");
        this.fromLabel.setPreferredSize(new Dimension(93, 17));
        this.fromLabel.setMaximumSize(new Dimension(93, 17));
        this.fromLabel.setMinimumSize(new Dimension(93, 17));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.fromLabel, gridBagConstraints);
        container.add(this.fromLabel);
        this.fromFileLabel = new JLabel();
        this.fromFileLabel.setPreferredSize(new Dimension(375, 20));
        this.fromFileLabel.setMaximumSize(new Dimension(375, 20));
        this.fromFileLabel.setMinimumSize(new Dimension(375, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.fromFileLabel, gridBagConstraints);
        container.add(this.fromFileLabel);
        this.toLabel = new JLabel(" To   ");
        this.toLabel.setPreferredSize(new Dimension(93, 17));
        this.toLabel.setMaximumSize(new Dimension(93, 17));
        this.toLabel.setMinimumSize(new Dimension(93, 17));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.toLabel, gridBagConstraints);
        container.add(this.toLabel);
        this.toFileLabel = new JLabel(this.paramData.getTargetDir() + " directory on the Server.");
        this.toFileLabel.setPreferredSize(new Dimension(375, 20));
        this.toFileLabel.setMaximumSize(new Dimension(375, 20));
        this.toFileLabel.setMinimumSize(new Dimension(375, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.toFileLabel, gridBagConstraints);
        container.add(this.toFileLabel);
        this.byteSentLabel = new JLabel(" Byte Sent   ");
        this.byteSentLabel.setPreferredSize(new Dimension(93, 17));
        this.byteSentLabel.setMaximumSize(new Dimension(93, 17));
        this.byteSentLabel.setMinimumSize(new Dimension(93, 17));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.byteSentLabel, gridBagConstraints);
        container.add(this.byteSentLabel);
        this.byteFileSentLabel = new JLabel();
        this.byteFileSentLabel.setPreferredSize(new Dimension(375, 20));
        this.byteFileSentLabel.setMaximumSize(new Dimension(375, 20));
        this.byteFileSentLabel.setMinimumSize(new Dimension(375, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.byteFileSentLabel, gridBagConstraints);
        container.add(this.byteFileSentLabel);
        this.totalByteSentLabel = new JLabel(" Total Byte Sent   ");
        this.totalByteSentLabel.setPreferredSize(new Dimension(93, 17));
        this.totalByteSentLabel.setMaximumSize(new Dimension(93, 17));
        this.totalByteSentLabel.setMinimumSize(new Dimension(93, 17));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.totalByteSentLabel, gridBagConstraints);
        container.add(this.totalByteSentLabel);
        this.totalByteFileSentLabel = new JLabel();
        this.totalByteFileSentLabel.setPreferredSize(new Dimension(375, 20));
        this.totalByteFileSentLabel.setMaximumSize(new Dimension(375, 20));
        this.totalByteFileSentLabel.setMinimumSize(new Dimension(375, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.totalByteFileSentLabel, gridBagConstraints);
        container.add(this.totalByteFileSentLabel);
        this.progFileLabel = new JLabel(" Time Left   ");
        this.progFileLabel.setPreferredSize(new Dimension(93, 17));
        this.progFileLabel.setMaximumSize(new Dimension(93, 17));
        this.progFileLabel.setMinimumSize(new Dimension(93, 17));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.progFileLabel, gridBagConstraints);
        container.add(this.progFileLabel);
        this.fileProgModel = new DefaultBoundedRangeModel();
        this.fileProgressBar = new JProgressBar(this.fileProgModel);
        this.fileProgressBar.setPreferredSize(new Dimension(375, 15));
        this.fileProgressBar.setMaximumSize(new Dimension(375, 15));
        this.fileProgressBar.setMinimumSize(new Dimension(375, 15));
        this.fileProgressBar.setStringPainted(true);
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.fileProgressBar, gridBagConstraints);
        container.add(this.fileProgressBar);
        this.totalProgLabel = new JLabel(" Total Time Left   ");
        this.totalProgLabel.setPreferredSize(new Dimension(93, 17));
        this.totalProgLabel.setMaximumSize(new Dimension(93, 17));
        this.totalProgLabel.setMinimumSize(new Dimension(93, 17));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.totalProgLabel, gridBagConstraints);
        container.add(this.totalProgLabel);
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            object = new Long(((File)vector.elementAt(n2)).length());
            n += ((Long)object).intValue();
            ++n2;
        }
        this.setTotalFileByte(n);
        this.totalProgressBar = new JProgressBar(0, this.getTotalFileByte());
        this.totalProgressBar.setPreferredSize(new Dimension(375, 15));
        this.totalProgressBar.setMaximumSize(new Dimension(375, 15));
        this.totalProgressBar.setMinimumSize(new Dimension(375, 15));
        this.totalProgressBar.setValue(0);
        this.totalProgressBar.setStringPainted(true);
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.totalProgressBar, gridBagConstraints);
        container.add(this.totalProgressBar);
        this.pack();
        object = this.getGraphicsConfiguration();
        Rectangle rectangle = ((GraphicsConfiguration)object).getBounds();
        int n3 = 500;
        int n4 = 210;
        this.setBounds(rectangle.width / 2 - n3 / 2, rectangle.height / 2 - n4 / 2, n3, n4);
        this.setResizable(false);
        this.setVisible(true);
        this.task = new FileUploadTask(this, vector, this.fileProgModel, this.getToURL(), this.paramData);
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileUploadProgress.this.fromFileLabel.setText(FileUploadProgress.this.task.getFromFile());
                FileUploadProgress.this.byteFileSentLabel.setText(Integer.toString(FileUploadProgress.this.task.getEachIncrementByte()) + " of " + Integer.toString(FileUploadProgress.this.task.getEachFileByte()));
                FileUploadProgress.this.totalByteFileSentLabel.setText(Integer.toString(FileUploadProgress.this.task.getTotalIncrementByte()) + " of " + Integer.toString(FileUploadProgress.this.getTotalFileByte()));
                FileUploadProgress.this.totalProgressBar.setValue(FileUploadProgress.this.task.getTotalIncrementByte());
                if (FileUploadProgress.this.task.done()) {
                    FileUploadProgress.this.timer.stop();
                }
            }
        });
        this.task.go();
        this.timer.start();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Closing down");
                FileUploadProgress.this.stopUpload();
                FileUploadProgress.this.timer.stop();
                FileUploadProgress.this.dispose();
            }
        });
    }

    public void stopUpload() {
        this.task.stopUpload();
        this.timer.stop();
    }

    public void setTotalFileByte(int n) {
        this.totalFileByte = n;
    }

    public int getTotalFileByte() {
        return this.totalFileByte;
    }

    public void setToURL(URL uRL) {
        try {
            this.toURL = new URL(uRL.toString() + SERVLETPATH);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URL getToURL() {
        return this.toURL;
    }
}

