/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class FileUploadApplet
extends JApplet
implements ActionListener {
    String[] columnNames = new String[]{"File(0)", "Size(0.0 Mb)", "Last Modified"};
    Object[][] data = new Object[][]{{"File1", "Size1", "Date1"}, {"File2", "Size2", "Date2"}};
    int numRow = 0;
    JFileChooser fc;
    JButton addFileButton;
    JButton removeFileButton;
    JButton uploadFileButton;
    FileTableModel model;
    File currentDir;
    JTable table;
    DefaultTableColumnModel tableColumnModel;
    JTableHeader tableHeader;
    JScrollPane scrollPane;
    ListSelectionModel lsm;
    Vector fileWithPath;
    private boolean ALLOW_COLUMN_SELECTION = false;
    private boolean ALLOW_ROW_SELECTION = true;
    private boolean inAnApplet = true;
    URL testURL;
    static String tmpURL;
    ParamData paramData = new ParamData();

    public FileUploadApplet() {
        this(true);
    }

    public FileUploadApplet(boolean bl) {
        this.inAnApplet = bl;
        if (bl) {
            this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        }
    }

    public void init() {
        if (this.getParameter("servletErr") != null) {
            this.paramData.setServletURLErr(this.getParameter("servletErr"));
        }
        if (this.getParameter("servletURL") != null) {
            try {
                this.paramData.setServletURL(new URL(this.getParameter("servletURL")));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.getParameter("targetDir") != null) {
            this.paramData.setTargetDir(this.getParameter("targetDir"));
        }
        if (this.getParameter("targetDirErr") != null) {
            this.paramData.setTargetDirErr(this.getParameter("targetDirErr"));
        }
        this.setContentPane(this.makeContentPane());
    }

    public Container makeContentPane() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Can't read system properties.", "Error", 0);
        }
        this.fileWithPath = new Vector();
        this.model = new FileTableModel(this.columnNames, this.numRow);
        this.table = new JTable(this.model);
        this.tableColumnModel = (DefaultTableColumnModel)this.table.getColumnModel();
        this.tableHeader = this.table.getTableHeader();
        this.tableHeader.setReorderingAllowed(false);
        this.table.setGridColor(Color.white);
        this.scrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 70));
        this.lsm = this.table.getSelectionModel();
        this.lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.addFileButton = new JButton("Add File");
        this.addFileButton.setToolTipText("Click this button to select file for upload.");
        this.addFileButton.addActionListener(this);
        this.addFileButton.setActionCommand("addfile");
        this.removeFileButton = new JButton("Remove File");
        this.removeFileButton.setToolTipText("Click this button to romove a selected file.");
        this.removeFileButton.addActionListener(this);
        this.removeFileButton.setActionCommand("remfile");
        this.uploadFileButton = new JButton("Upload File");
        this.uploadFileButton.setToolTipText("Click this button to upload the selected file/s.");
        this.uploadFileButton.addActionListener(this);
        this.uploadFileButton.setActionCommand("uploadfile");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.white);
        jPanel.add((Component)this.scrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.addFileButton, "North");
        jPanel2.add((Component)this.removeFileButton, "Center");
        jPanel2.add((Component)this.uploadFileButton, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        return jPanel3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TableColumn tableColumn = this.tableColumnModel.getColumn(0);
        if (actionEvent.getActionCommand().equals("addfile")) {
            this.fc = this.currentDir == null ? new JFileChooser() : new JFileChooser(this.currentDir);
            this.fc.setMultiSelectionEnabled(true);
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                this.currentDir = this.fc.getCurrentDirectory();
                System.out.println(this.currentDir.toString());
                File[] fileArray = this.fc.getSelectedFiles();
                int n2 = 0;
                while (n2 < fileArray.length) {
                    Long l = new Long(fileArray[n2].length());
                    if (this.setSizeInHeader(l.intValue())) {
                        Date date = new Date(fileArray[n2].lastModified());
                        Object[] objectArray = new Object[]{fileArray[n2].getName(), l.toString(), date.toString()};
                        this.model.addRow(objectArray);
                        this.fileWithPath.addElement(fileArray[n2]);
                    } else {
                        JOptionPane.showMessageDialog(this, "Can't add file " + fileArray[n2].getName() + " as it exceeds the maximum 10Mb file/s size limit.", "Error", 0);
                    }
                    ++n2;
                }
            } else if (n == -1) {
                JOptionPane.showMessageDialog(this, "Can't open dialog box to access file system.", "Error", 0);
            }
        } else if (actionEvent.getActionCommand().equals("remfile")) {
            int n;
            int n3 = this.table.getSelectedRows().length;
            int n4 = this.model.getRowCount();
            while ((n = this.lsm.getMinSelectionIndex()) != -1) {
                this.model.removeRow(n);
                this.fileWithPath.removeElementAt(n);
                boolean bl = this.setSizeInHeader(0);
            }
            if (n4 == 0) {
                JOptionPane.showMessageDialog(this, "No file/s present in the list. Click 'Add File' to add a file.", "Information", 1);
            } else if (n3 == 0) {
                JOptionPane.showMessageDialog(this, "Select file/s in the list to remove.", "Information", 1);
            }
        } else if (this.model.getRowCount() > 0) {
            if (this.inAnApplet) {
                FileUploadProgress fileUploadProgress = new FileUploadProgress(this.fileWithPath, this.paramData);
            } else {
                try {
                    this.paramData.setServletURL(new URL(tmpURL));
                    this.paramData.setServletURLErr("Servlet not found or not running.");
                    this.paramData.setTargetDir("c:/jakarta-tomcat-3.2.3_new/webapps/jupload/WEB-INF/uploadedfiles/");
                    this.paramData.setTargetDirErr("Target directory specified doesn't exist.");
                }
                catch (Exception exception) {
                    System.out.println(tmpURL);
                    System.out.println(exception.toString());
                    System.exit(0);
                }
                FileUploadProgress fileUploadProgress = new FileUploadProgress(this.fileWithPath, this.paramData);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No file/s present in the list for upload", "Information", 1);
        }
        tableColumn.setHeaderValue("File(" + this.model.getRowCount() + ")");
        this.tableHeader.resizeAndRepaint();
    }

    public boolean setSizeInHeader(int n) {
        int n2 = 0xA00000;
        TableColumn tableColumn = this.tableColumnModel.getColumn(1);
        int n3 = n;
        int n4 = 0;
        while (n4 < this.model.getRowCount()) {
            n3 += Integer.parseInt((String)this.model.getValueAt(n4, 1));
            ++n4;
        }
        if (n3 < n2) {
            String string = new String();
            if (n3 != 0) {
                string = Float.toString(new Integer(n3).floatValue() / 1048576.0f);
                string = string.substring(0, string.lastIndexOf(".") + 3);
            } else {
                string = Float.toString(new Integer(n3).floatValue());
            }
            tableColumn.setHeaderValue("Size(" + string + " Mb)");
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray != null) {
                tmpURL = new String(stringArray[0]);
            }
        }
        catch (Exception exception) {
            System.out.println("Please provide host server address on which the FileDownloadServlet is running as an argument e.g. http://hostservername.com.au");
            System.exit(0);
        }
        JFrame jFrame = new JFrame("File Upload Applet");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        FileUploadApplet fileUploadApplet = new FileUploadApplet(false);
        jFrame.setContentPane(fileUploadApplet.makeContentPane());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

