#include <stdbool.h>
#include <pthread.h>

#ifndef _MXALLOWD_INCLUDED
#define _MXALLOWD_INCLUDED

struct mailserver_list {
	char *ip_address;
	struct mailserver_list *next;
};

#ifdef _MXALLOWD_INTERNAL
int allow_time = 3600,
    queue_num = -1;
bool to_stdout = false,
     rdns_whitelist = true,
     quiet = false,
     stay_in_foreground = false;
struct mailserver_list 	*fake_mailservers = NULL,
			*real_mailservers = NULL;
unsigned long blocked_attempts = 0,
	      successful_connects = 0,
	      direct_to_fake = 0;
char *configfile = "/etc/mxallowd.conf";
pthread_mutex_t resolv_thread_mutex;
pthread_cond_t resolv_new_cond;
#else
extern int allow_time;
extern int queue_num;
extern bool to_stdout, quiet, rdns_whitelist;
extern struct mailserver_list *fake_mailservers, *real_mailservers;
extern unsigned long blocked_attempts, successful_connects, direct_to_fake;
extern pthread_mutex_t resolv_thread_mutex;
extern pthread_cond_t resolv_new_cond;
#endif

void add_mailserver(struct mailserver_list**, char*);
bool is_included(struct mailserver_list*, char*);
void handle_sighup(int);
void handle_sigusr1(int);
void print_help(char*);
#endif
