/***************************************************************************
                          item.cpp  -  description
                             -------------------
    begin                : Fri Mar 16 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "item.h"
#include <iostream.h>

Mp3ListItem::Mp3ListItem(QListView* parent, int mp3id, int length) :
          QListViewItem(parent), mp3id(mp3id), length(length)
{
}

Mp3ListItem::Mp3ListItem(QListViewItem* parent, int mp3id, int length) :
          QListViewItem(parent), mp3id(mp3id), length(length)
{
}

Mp3ListItem::~Mp3ListItem()
{
}

int Mp3ListItem::getMp3id() const
{
     return mp3id;
}

int Mp3ListItem::getLength() const
{
     return length;
}

Mp3ListItem* Mp3ListItem::itemBelow()
{
/*if (QListViewItem::itemBelow() && !(QListViewItem::itemBelow()->isSelectable()))
	{
		//cerr << "Parent Item " << text(2)<< endl;
     return (Mp3ListItem*) (QListViewItem::itemBelow()->QListViewItem::itemBelow());
	}
	else
	{
		//cerr << "Child Item" << endl;
		return (Mp3ListItem*) QListViewItem::itemBelow();
	 }*/
     return (Mp3ListItem*) QListViewItem::itemBelow();

}

Mp3ListItem* Mp3ListItem::itemAbove()
{
	/*if (QListViewItem::itemAbove() && !(QListViewItem::itemAbove()->isSelectable()))
	{
		//cerr << "Parent Item " << text(2)<< endl;
     return (Mp3ListItem*) (QListViewItem::itemAbove()->QListViewItem::itemAbove());
	}
	else
	{
		//cerr << "Child Item" << endl;
		return (Mp3ListItem*) QListViewItem::itemAbove();
	 }*/
return (Mp3ListItem*) QListViewItem::itemAbove();
}

/******************************************************************************
*                                                                             *
*                      PLListItem Class Methods                               *
*                                                                             *
******************************************************************************/

PLListItem::PLListItem(QListView* parent, int mp3id, const char* file, int length) :
          QListViewItem(parent), mp3id(mp3id), file(file),length(length)
{
}

PLListItem::PLListItem(QListView* parent, PLListItem* after, int mp3id, const char* file, int length) :
          QListViewItem(parent, after), mp3id(mp3id), file(file),length(length)
{
}

PLListItem::~PLListItem()
{
}

int PLListItem::getMp3id() const
{
     return mp3id;
}
/*
const QString PLListItem::getTitle() const
{
     return title;
}

const QString PLListItem::getArtist() const
{
     return artist;
}
 */
int PLListItem::getLength() const
{
     return length;
}

PLListItem* PLListItem::itemBelow()
{
     return (PLListItem*) QListViewItem::itemBelow();
}

PLListItem* PLListItem::itemAbove()
{
     return (PLListItem*) QListViewItem::itemAbove();
}

const char* PLListItem::getFileN() const
{
     return file;
}
