# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.poblesec.link import Link
from twisted.internet import defer

from elisa.core.utils.i18n import install_translation

from elisa.plugins.poblesec.sections_menu import main_menu_decorate

_ = install_translation('poblesec')

def pictures_decorator(controller):
    controller_path = "/poblesec/pictures_menu"
    label = _("Pictures")
    icon = "elisa.plugins.poblesec.pictures_section"
    dfr = main_menu_decorate(controller, controller_path, label, icon)
    return dfr

def photo_lib_decorator(controller):
    link = Link()
    link.controller_path = '/poblesec/database/photo/list'
    link.label = _('Library')
    controller.model.append(link)
    return defer.succeed(None)

def photo_albums_decorator(controller):
    albums = Link()
    albums.controller_path = '/poblesec/database/photo/albums'
    albums.label = _('Albums')
    controller.model.append(albums)
    return defer.succeed(None)

def photo_date_decorator(controller):
    times = Link()
    times.controller_path = '/poblesec/database/photo/by_date'
    times.label = _('Date')
    controller.model.append(times)
    return defer.succeed(None)
