# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

import pgm
from drawable import Drawable

class Quad(Drawable, pgm.Image):
    """
    Quad node of the scenegraph.
    """

    def __init__(self):
        pgm.Image.__init__(self)
        Drawable.__init__(self)

    def set_color(self, color):
        self.bg_color = color

    def get_color(self):
        return self.bg_color

    color = property(fget=get_color, fset=set_color)
