// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnu.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar		(marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004 Novell, Inc
//
// TODO:
//   (1) Figure out why error productions dont work.  `type-declaration' is a
//       great spot to put an `error' because you can reproduce it with this input:
//	 "public X { }"
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer  current_namespace;
		TypeContainer   current_container;
		DeclSpace	current_class;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariableDeclaration current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;

		///
		/// An out-of-band stack.
		///
		static Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		static public int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		static List<Parameter> parameters_bucket = new List<Parameter> (6);
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		UsingsBag ubag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedOpenLocation, savedCloseLocation;
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }

  /* An EOF token */
  public int eof_token;

  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_alias_directive",
//t    "using_directive : using_namespace_directive",
//t    "using_alias_directive : USING IDENTIFIER ASSIGN namespace_or_type_name SEMICOLON",
//t    "using_alias_directive : USING error",
//t    "using_namespace_directive : USING namespace_name SEMICOLON",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE qualified_identifier $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon",
//t    "qualified_identifier : IDENTIFIER",
//t    "qualified_identifier : qualified_identifier DOT IDENTIFIER",
//t    "qualified_identifier : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "namespace_name : namespace_or_type_name",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_target : error",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_name",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : IDENTIFIER COLON opt_named_modifier expression",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$8 type_declaration_name $$9 opt_class_base opt_type_parameter_constraints_clauses $$10 struct_body $$11 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$12 :",
//t    "struct_body : OPEN_BRACE $$12 opt_struct_member_declarations CLOSE_BRACE",
//t    "opt_struct_member_declarations :",
//t    "opt_struct_member_declarations : struct_member_declarations",
//t    "struct_member_declarations : struct_member_declaration",
//t    "struct_member_declarations : struct_member_declarations struct_member_declaration",
//t    "struct_member_declaration : constant_declaration",
//t    "struct_member_declaration : field_declaration",
//t    "struct_member_declaration : method_declaration",
//t    "struct_member_declaration : property_declaration",
//t    "struct_member_declaration : event_declaration",
//t    "struct_member_declaration : indexer_declaration",
//t    "struct_member_declaration : operator_declaration",
//t    "struct_member_declaration : constructor_declaration",
//t    "struct_member_declaration : type_declaration",
//t    "struct_member_declaration : destructor_declaration",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "$$21 :",
//t    "$$22 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$21 opt_formal_parameter_list CLOSE_PARENS $$22 opt_type_parameter_constraints_clauses",
//t    "$$23 :",
//t    "$$24 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID method_declaration_name OPEN_PARENS $$23 opt_formal_parameter_list CLOSE_PARENS $$24 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$25 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER ASSIGN $$25 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$26 :",
//t    "$$27 :",
//t    "$$28 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$26 OPEN_BRACE $$27 accessor_declarations $$28 CLOSE_BRACE",
//t    "$$29 :",
//t    "$$30 :",
//t    "$$31 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$29 opt_formal_parameter_list CLOSE_BRACKET OPEN_BRACE $$30 accessor_declarations $$31 CLOSE_BRACE",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$32 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$32 accessor_body",
//t    "$$33 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$33 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$34 :",
//t    "$$35 :",
//t    "$$36 :",
//t    "$$37 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$34 type_declaration_name $$35 opt_class_base opt_type_parameter_constraints_clauses $$36 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$37 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$38 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$38 operator_body",
//t    "operator_body : block",
//t    "operator_body : SEMICOLON",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$39 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$39 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$40 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$40 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$41 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$41 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$42 :",
//t    "$$43 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$42 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$43 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$44 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$44 opt_argument_list CLOSE_PARENS",
//t    "$$45 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$45 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : error",
//t    "$$46 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$46 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$47 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$47 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$48 :",
//t    "$$49 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$48 event_accessor_declarations $$49 CLOSE_BRACE",
//t    "opt_event_initializer :",
//t    "$$50 :",
//t    "opt_event_initializer : ASSIGN $$50 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$51 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$51 event_variable_initializer",
//t    "$$52 :",
//t    "event_variable_initializer : $$52 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$53 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$53 event_accessor_block",
//t    "$$54 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$54 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "$$55 :",
//t    "$$56 :",
//t    "$$57 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$55 OPEN_BRACE $$56 opt_enum_member_declarations $$57 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$58 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$58 ASSIGN constant_expression",
//t    "$$59 :",
//t    "$$60 :",
//t    "$$61 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$59 opt_formal_parameter_list CLOSE_PARENS $$60 opt_type_parameter_constraints_clauses $$61 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_name : member_name",
//t    "namespace_or_type_name : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_name : type_name",
//t    "member_name : namespace_or_type_name DOT IDENTIFIER opt_type_argument_list",
//t    "type_name : IDENTIFIER opt_type_argument_list",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$62 :",
//t    "type_declaration_name : IDENTIFIER $$62 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : VOID",
//t    "simple_type : type_expression",
//t    "simple_type : VOID",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_name opt_nullable",
//t    "type_expression : namespace_or_type_name pointer_stars",
//t    "type_expression : builtin_types opt_nullable",
//t    "type_expression : builtin_types pointer_stars",
//t    "type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "base_type_name : error",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : IDENTIFIER opt_type_argument_list",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : builtin_types DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : BASE DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "expression_list : expression",
//t    "expression_list : expression_list COMMA expression",
//t    "expression_list : expression_list error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$63 :",
//t    "new_expr_type : $$63 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameter : IDENTIFIER ASSIGN variable_initializer",
//t    "anonymous_type_parameter : IDENTIFIER",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "$$64 :",
//t    "typeof_expression : TYPEOF $$64 open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : unbound_type_name",
//t    "typeof_type_expression : error",
//t    "unbound_type_name : IDENTIFIER generic_dimension",
//t    "unbound_type_name : qualified_alias_member IDENTIFIER generic_dimension",
//t    "unbound_type_name : unbound_type_name DOT IDENTIFIER",
//t    "unbound_type_name : unbound_type_name DOT IDENTIFIER generic_dimension",
//t    "unbound_type_name : namespace_or_type_name DOT IDENTIFIER generic_dimension",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$65 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$65 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$66 :",
//t    "anonymous_method_signature : OPEN_PARENS $$66 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : cast_expression",
//t    "unary_expression : await_expression",
//t    "cast_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "await_expression : AWAIT unary_expression",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : parenthesized_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS type",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type IDENTIFIER",
//t    "lambda_parameter : parameter_type IDENTIFIER",
//t    "lambda_parameter : IDENTIFIER",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "lambda_expression_body : lambda_expression_body_simple",
//t    "lambda_expression_body : block",
//t    "$$67 :",
//t    "lambda_expression_body_simple : $$67 expression_or_error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$68 :",
//t    "lambda_expression : IDENTIFIER ARROW $$68 lambda_expression_body",
//t    "$$69 :",
//t    "$$70 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$69 opt_lambda_parameter_list CLOSE_PARENS ARROW $$70 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "$$71 :",
//t    "$$72 :",
//t    "$$73 :",
//t    "$$74 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$71 type_declaration_name $$72 opt_class_base opt_type_parameter_constraints_clauses $$73 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$74 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : COLON type_list",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "opt_type_parameter_constraints_clauses : error",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$75 :",
//t    "block : OPEN_BRACE $$75 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$76 :",
//t    "block_prepared : OPEN_BRACE $$76 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$77 :",
//t    "labeled_statement : IDENTIFIER COLON $$77 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_types opt_nullable",
//t    "variable_type_simple : builtin_types pointer_stars",
//t    "variable_type_simple : VOID pointer_stars",
//t    "variable_type_simple : VOID",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "$$78 :",
//t    "block_variable_declaration : variable_type IDENTIFIER $$78 opt_local_variable_initializer opt_variable_declarators SEMICOLON",
//t    "$$79 :",
//t    "block_variable_declaration : CONST variable_type IDENTIFIER $$79 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA IDENTIFIER",
//t    "variable_declarator : COMMA IDENTIFIER ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA IDENTIFIER ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "$$80 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$80 opt_switch_sections CLOSE_BRACE",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "$$81 :",
//t    "switch_section : switch_labels $$81 statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "$$82 :",
//t    "for_statement : FOR open_parens_any $$82 for_statement_cont",
//t    "for_statement_cont : opt_for_initializer SEMICOLON opt_for_condition SEMICOLON opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_cont : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$83 :",
//t    "for_initializer : variable_type IDENTIFIER $$83 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type IN expression CLOSE_PARENS",
//t    "$$84 :",
//t    "foreach_statement : FOREACH open_parens_any type IDENTIFIER IN expression CLOSE_PARENS $$84 embedded_statement",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "goto_statement : GOTO IDENTIFIER SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "yield_statement : IDENTIFIER RETURN opt_expression SEMICOLON",
//t    "yield_statement : IDENTIFIER BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : IDENTIFIER",
//t    "catch_clause : CATCH block",
//t    "$$85 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$85 block_prepared",
//t    "catch_clause : CATCH open_parens_any error",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$86 :",
//t    "unsafe_statement : UNSAFE $$86 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "$$87 :",
//t    "$$88 :",
//t    "fixed_statement : FIXED open_parens_any variable_type IDENTIFIER $$87 using_or_fixed_variable_initializer opt_variable_declarators CLOSE_PARENS $$88 embedded_statement",
//t    "$$89 :",
//t    "$$90 :",
//t    "using_statement : USING open_parens_any variable_type IDENTIFIER $$89 using_or_fixed_variable_initializer opt_variable_declarators CLOSE_PARENS $$90 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST IDENTIFIER IN expression",
//t    "first_from_clause : FROM_FIRST type IDENTIFIER IN expression",
//t    "nested_from_clause : FROM IDENTIFIER IN expression",
//t    "nested_from_clause : FROM type IDENTIFIER IN expression",
//t    "$$91 :",
//t    "from_clause : FROM IDENTIFIER IN $$91 expression",
//t    "$$92 :",
//t    "from_clause : FROM type IDENTIFIER IN $$92 expression",
//t    "query_body : opt_query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : opt_query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : error",
//t    "$$93 :",
//t    "select_or_group_clause : SELECT $$93 expression",
//t    "$$94 :",
//t    "$$95 :",
//t    "select_or_group_clause : GROUP $$94 expression $$95 BY expression",
//t    "opt_query_body_clauses :",
//t    "opt_query_body_clauses : query_body_clauses",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$96 :",
//t    "let_clause : LET IDENTIFIER ASSIGN $$96 expression",
//t    "$$97 :",
//t    "where_clause : WHERE $$97 expression",
//t    "$$98 :",
//t    "$$99 :",
//t    "$$100 :",
//t    "join_clause : JOIN IDENTIFIER IN $$98 expression ON $$99 expression EQUALS $$100 expression opt_join_into",
//t    "$$101 :",
//t    "$$102 :",
//t    "$$103 :",
//t    "join_clause : JOIN type IDENTIFIER IN $$101 expression ON $$102 expression EQUALS $$103 expression opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO IDENTIFIER",
//t    "$$104 :",
//t    "orderby_clause : ORDERBY $$104 orderings",
//t    "orderings : order_by",
//t    "$$105 :",
//t    "orderings : order_by COMMA $$105 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$106 :",
//t    "orderings_then_by : orderings_then_by COMMA $$106 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$107 :",
//t    "opt_query_continuation : INTO IDENTIFIER $$107 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$108 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$108 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$109 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$109 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$110 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$110 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF","ASYNC","AWAIT","GET",
    "SET","LAST_KEYWORD","OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET",
    "CLOSE_BRACKET","OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON",
    "SEMICOLON","TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT",
    "BITWISE_AND","BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR",
    "DOUBLE_COLON","OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT",
    "OP_LE","OP_GE","OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN",
    "OP_DIV_ASSIGN","OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

  int yyExpectingState;
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
	protected bool use_global_stacks;
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 380 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 381 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 398 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 436 "cs-parser.jay"
  {
	  	syntax_error (GetLocation (yyVals[-1+yyTop]), "`alias' expected");   /* TODO: better*/
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 27:
  case_27();
  break;
case 32:
  case_32();
  break;
case 41:
  case_41();
  break;
case 42:
#line 625 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 50:
  case_50();
  break;
case 51:
  case_51();
  break;
case 52:
  case_52();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
  case_57();
  break;
case 58:
#line 717 "cs-parser.jay"
  { yyVal = "event"; }
  break;
case 59:
#line 718 "cs-parser.jay"
  { yyVal = "return"; }
  break;
case 60:
  case_60();
  break;
case 61:
#line 735 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 62:
  case_62();
  break;
case 63:
#line 749 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 64:
  case_64();
  break;
case 66:
#line 770 "cs-parser.jay"
  { yyVal = null; }
  break;
case 67:
#line 774 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 68:
#line 779 "cs-parser.jay"
  { yyVal = null; }
  break;
case 69:
  case_69();
  break;
case 70:
  case_70();
  break;
case 71:
  case_71();
  break;
case 72:
  case_72();
  break;
case 73:
#line 823 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 75:
#line 831 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 76:
  case_76();
  break;
case 77:
  case_77();
  break;
case 78:
#line 856 "cs-parser.jay"
  { yyVal = null; }
  break;
case 79:
#line 860 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 80:
#line 864 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 95:
  case_95();
  break;
case 96:
#line 905 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 97:
  case_97();
  break;
case 98:
  case_98();
  break;
case 99:
  case_99();
  break;
case 100:
  case_100();
  break;
case 101:
#line 937 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 102:
  case_102();
  break;
case 103:
#line 949 "cs-parser.jay"
  {
		lbag.AppendToMember (current_class, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 118:
  case_118();
  break;
case 119:
  case_119();
  break;
case 122:
#line 1018 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 123:
#line 1022 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 124:
  case_124();
  break;
case 125:
#line 1038 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 126:
  case_126();
  break;
case 127:
  case_127();
  break;
case 130:
  case_130();
  break;
case 131:
  case_131();
  break;
case 132:
  case_132();
  break;
case 133:
  case_133();
  break;
case 134:
#line 1117 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 136:
  case_136();
  break;
case 137:
  case_137();
  break;
case 140:
#line 1147 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 141:
#line 1151 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 142:
  case_142();
  break;
case 143:
#line 1164 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 144:
  case_144();
  break;
case 147:
#line 1183 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 148:
#line 1187 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 149:
  case_149();
  break;
case 150:
#line 1203 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 151:
  case_151();
  break;
case 152:
  case_152();
  break;
case 155:
  case_155();
  break;
case 156:
  case_156();
  break;
case 157:
  case_157();
  break;
case 158:
#line 1260 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 159:
#line 1264 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 160:
  case_160();
  break;
case 161:
#line 1305 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 162:
#line 1309 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 163:
  case_163();
  break;
case 164:
  case_164();
  break;
case 166:
#line 1385 "cs-parser.jay"
  { yyVal = null; }
  break;
case 167:
#line 1389 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 169:
  case_169();
  break;
case 170:
  case_170();
  break;
case 171:
  case_171();
  break;
case 172:
  case_172();
  break;
case 173:
  case_173();
  break;
case 174:
  case_174();
  break;
case 175:
  case_175();
  break;
case 176:
#line 1448 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 177:
#line 1452 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 178:
  case_178();
  break;
case 179:
  case_179();
  break;
case 180:
  case_180();
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
  case_183();
  break;
case 184:
#line 1527 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 185:
  case_185();
  break;
case 186:
#line 1568 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
  case_190();
  break;
case 191:
  case_191();
  break;
case 192:
  case_192();
  break;
case 193:
  case_193();
  break;
case 194:
  case_194();
  break;
case 195:
  case_195();
  break;
case 196:
  case_196();
  break;
case 197:
  case_197();
  break;
case 198:
#line 1666 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 199:
  case_199();
  break;
case 200:
  case_200();
  break;
case 201:
  case_201();
  break;
case 202:
  case_202();
  break;
case 203:
  case_203();
  break;
case 204:
#line 1720 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 205:
  case_205();
  break;
case 206:
#line 1750 "cs-parser.jay"
  {
		  lexer.PropertyParsing = false;
	  }
  break;
case 207:
  case_207();
  break;
case 212:
  case_212();
  break;
case 213:
  case_213();
  break;
case 214:
  case_214();
  break;
case 215:
  case_215();
  break;
case 216:
  case_216();
  break;
case 218:
  case_218();
  break;
case 219:
  case_219();
  break;
case 220:
#line 1892 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 221:
  case_221();
  break;
case 222:
  case_222();
  break;
case 223:
  case_223();
  break;
case 224:
  case_224();
  break;
case 225:
#line 1925 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 230:
#line 1942 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 231:
#line 1946 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 236:
#line 1954 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 237:
#line 1958 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 238:
#line 1962 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 239:
#line 1968 "cs-parser.jay"
  {
	  }
  break;
case 240:
  case_240();
  break;
case 242:
#line 1995 "cs-parser.jay"
  { yyVal = null; }
  break;
case 244:
  case_244();
  break;
case 245:
#line 2011 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 246:
  case_246();
  break;
case 248:
#line 2057 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; }
  break;
case 249:
#line 2058 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; }
  break;
case 250:
#line 2059 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; }
  break;
case 251:
#line 2060 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; }
  break;
case 252:
#line 2061 "cs-parser.jay"
  { yyVal = Operator.OpType.True; }
  break;
case 253:
#line 2062 "cs-parser.jay"
  { yyVal = Operator.OpType.False; }
  break;
case 254:
#line 2064 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; }
  break;
case 255:
#line 2065 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; }
  break;
case 256:
#line 2067 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; }
  break;
case 257:
#line 2068 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; }
  break;
case 258:
#line 2069 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; }
  break;
case 259:
#line 2070 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; }
  break;
case 260:
#line 2071 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; }
  break;
case 261:
#line 2072 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; }
  break;
case 262:
#line 2073 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; }
  break;
case 263:
#line 2074 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; }
  break;
case 264:
#line 2075 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; }
  break;
case 265:
#line 2076 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; }
  break;
case 266:
#line 2077 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; }
  break;
case 267:
#line 2078 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; }
  break;
case 268:
#line 2079 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; }
  break;
case 269:
#line 2080 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; }
  break;
case 270:
#line 2087 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 271:
  case_271();
  break;
case 272:
#line 2106 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 273:
  case_273();
  break;
case 274:
  case_274();
  break;
case 275:
  case_275();
  break;
case 276:
  case_276();
  break;
case 277:
  case_277();
  break;
case 278:
  case_278();
  break;
case 279:
  case_279();
  break;
case 281:
#line 2209 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 284:
#line 2221 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 285:
  case_285();
  break;
case 286:
#line 2231 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 287:
  case_287();
  break;
case 288:
  case_288();
  break;
case 289:
  case_289();
  break;
case 290:
  case_290();
  break;
case 291:
  case_291();
  break;
case 292:
  case_292();
  break;
case 293:
  case_293();
  break;
case 294:
  case_294();
  break;
case 295:
  case_295();
  break;
case 297:
#line 2340 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 298:
  case_298();
  break;
case 301:
#line 2357 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 302:
#line 2361 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 303:
  case_303();
  break;
case 304:
#line 2374 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 305:
  case_305();
  break;
case 306:
  case_306();
  break;
case 307:
#line 2399 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 310:
  case_310();
  break;
case 311:
  case_311();
  break;
case 312:
  case_312();
  break;
case 313:
  case_313();
  break;
case 314:
  case_314();
  break;
case 315:
  case_315();
  break;
case 316:
  case_316();
  break;
case 317:
  case_317();
  break;
case 319:
  case_319();
  break;
case 320:
  case_320();
  break;
case 321:
  case_321();
  break;
case 322:
  case_322();
  break;
case 324:
  case_324();
  break;
case 325:
  case_325();
  break;
case 328:
#line 2554 "cs-parser.jay"
  {
	  	lbag.AddLocation (yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 330:
  case_330();
  break;
case 331:
  case_331();
  break;
case 332:
  case_332();
  break;
case 333:
  case_333();
  break;
case 334:
#line 2612 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 335:
  case_335();
  break;
case 336:
#line 2632 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 337:
  case_337();
  break;
case 339:
  case_339();
  break;
case 341:
  case_341();
  break;
case 343:
  case_343();
  break;
case 344:
  case_344();
  break;
case 346:
  case_346();
  break;
case 347:
  case_347();
  break;
case 348:
  case_348();
  break;
case 349:
  case_349();
  break;
case 350:
#line 2730 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 351:
  case_351();
  break;
case 352:
  case_352();
  break;
case 354:
  case_354();
  break;
case 355:
  case_355();
  break;
case 356:
  case_356();
  break;
case 357:
  case_357();
  break;
case 358:
  case_358();
  break;
case 359:
  case_359();
  break;
case 361:
  case_361();
  break;
case 362:
  case_362();
  break;
case 363:
  case_363();
  break;
case 364:
  case_364();
  break;
case 365:
  case_365();
  break;
case 367:
#line 2848 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 368:
#line 2855 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 370:
  case_370();
  break;
case 372:
  case_372();
  break;
case 374:
  case_374();
  break;
case 376:
#line 2893 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 377:
  case_377();
  break;
case 378:
#line 2913 "cs-parser.jay"
  {
		yyVal = new ComposedCast (((MemberName) yyVals[-1+yyTop]).GetTypeExpression (), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 379:
  case_379();
  break;
case 380:
#line 2922 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 381:
#line 2926 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 382:
  case_382();
  break;
case 383:
  case_383();
  break;
case 384:
  case_384();
  break;
case 385:
  case_385();
  break;
case 386:
#line 2964 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 387:
#line 2965 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 388:
#line 2966 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 389:
#line 2967 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 390:
#line 2968 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 391:
#line 2969 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 393:
#line 2974 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 394:
#line 2975 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 395:
#line 2976 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 396:
#line 2977 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 397:
#line 2978 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 398:
#line 2979 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 399:
#line 2980 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 400:
#line 2981 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 401:
#line 2982 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 422:
  case_422();
  break;
case 423:
  case_423();
  break;
case 427:
#line 3029 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 428:
#line 3033 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 429:
#line 3034 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 434:
  case_434();
  break;
case 435:
#line 3067 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
	  }
  break;
case 436:
  case_436();
  break;
case 437:
  case_437();
  break;
case 438:
  case_438();
  break;
case 439:
  case_439();
  break;
case 440:
#line 3099 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 441:
  case_441();
  break;
case 442:
#line 3107 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 443:
  case_443();
  break;
case 444:
  case_444();
  break;
case 445:
#line 3123 "cs-parser.jay"
  { yyVal = null; }
  break;
case 447:
  case_447();
  break;
case 448:
  case_448();
  break;
case 449:
#line 3146 "cs-parser.jay"
  { yyVal = null; }
  break;
case 450:
#line 3150 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 451:
  case_451();
  break;
case 452:
  case_452();
  break;
case 453:
  case_453();
  break;
case 454:
  case_454();
  break;
case 455:
#line 3182 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 456:
  case_456();
  break;
case 457:
  case_457();
  break;
case 458:
  case_458();
  break;
case 461:
#line 3210 "cs-parser.jay"
  { yyVal = null; }
  break;
case 463:
  case_463();
  break;
case 464:
  case_464();
  break;
case 465:
  case_465();
  break;
case 466:
  case_466();
  break;
case 467:
  case_467();
  break;
case 468:
#line 3262 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 472:
  case_472();
  break;
case 473:
  case_473();
  break;
case 474:
  case_474();
  break;
case 475:
  case_475();
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
  case_479();
  break;
case 480:
  case_480();
  break;
case 481:
  case_481();
  break;
case 482:
  case_482();
  break;
case 483:
#line 3349 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 485:
#line 3357 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 486:
  case_486();
  break;
case 487:
  case_487();
  break;
case 488:
#line 3377 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 489:
#line 3384 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 490:
  case_490();
  break;
case 491:
  case_491();
  break;
case 492:
  case_492();
  break;
case 493:
  case_493();
  break;
case 494:
  case_494();
  break;
case 495:
  case_495();
  break;
case 496:
  case_496();
  break;
case 497:
#line 3450 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 498:
  case_498();
  break;
case 499:
  case_499();
  break;
case 502:
#line 3477 "cs-parser.jay"
  { yyVal = null; }
  break;
case 504:
  case_504();
  break;
case 505:
  case_505();
  break;
case 506:
  case_506();
  break;
case 507:
  case_507();
  break;
case 508:
  case_508();
  break;
case 509:
  case_509();
  break;
case 513:
  case_513();
  break;
case 514:
  case_514();
  break;
case 515:
  case_515();
  break;
case 516:
#line 3553 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 517:
#line 3557 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 518:
#line 3564 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 519:
#line 3568 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
  case_522();
  break;
case 523:
  case_523();
  break;
case 524:
#line 3612 "cs-parser.jay"
  {
	  	lexer.TypeOfParsing = true;
	  }
  break;
case 525:
  case_525();
  break;
case 528:
  case_528();
  break;
case 529:
  case_529();
  break;
case 530:
  case_530();
  break;
case 531:
  case_531();
  break;
case 532:
  case_532();
  break;
case 533:
  case_533();
  break;
case 534:
  case_534();
  break;
case 535:
  case_535();
  break;
case 536:
  case_536();
  break;
case 537:
  case_537();
  break;
case 538:
  case_538();
  break;
case 539:
  case_539();
  break;
case 540:
#line 3726 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 541:
  case_541();
  break;
case 542:
#line 3742 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 544:
#line 3750 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 545:
  case_545();
  break;
case 546:
  case_546();
  break;
case 548:
#line 3776 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 549:
#line 3780 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 552:
  case_552();
  break;
case 553:
#line 3797 "cs-parser.jay"
  {
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	 }
  break;
case 555:
#line 3809 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 556:
#line 3813 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 557:
#line 3817 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 558:
#line 3821 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 559:
#line 3825 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 560:
#line 3829 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 562:
  case_562();
  break;
case 563:
  case_563();
  break;
case 564:
  case_564();
  break;
case 566:
  case_566();
  break;
case 567:
#line 3861 "cs-parser.jay"
  {
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 568:
  case_568();
  break;
case 569:
#line 3870 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 570:
#line 3874 "cs-parser.jay"
  {
		yyVal = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 572:
  case_572();
  break;
case 573:
  case_573();
  break;
case 575:
  case_575();
  break;
case 576:
  case_576();
  break;
case 577:
  case_577();
  break;
case 578:
  case_578();
  break;
case 580:
  case_580();
  break;
case 581:
  case_581();
  break;
case 583:
  case_583();
  break;
case 585:
  case_585();
  break;
case 587:
  case_587();
  break;
case 589:
  case_589();
  break;
case 591:
  case_591();
  break;
case 593:
  case_593();
  break;
case 595:
  case_595();
  break;
case 596:
#line 3998 "cs-parser.jay"
  {
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 600:
  case_600();
  break;
case 601:
  case_601();
  break;
case 602:
  case_602();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
  case_606();
  break;
case 607:
  case_607();
  break;
case 608:
  case_608();
  break;
case 609:
  case_609();
  break;
case 610:
  case_610();
  break;
case 611:
  case_611();
  break;
case 612:
#line 4093 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 613:
  case_613();
  break;
case 616:
#line 4108 "cs-parser.jay"
  {
		start_block (lexer.Location);
	  }
  break;
case 617:
  case_617();
  break;
case 619:
  case_619();
  break;
case 620:
  case_620();
  break;
case 621:
  case_621();
  break;
case 622:
  case_622();
  break;
case 623:
  case_623();
  break;
case 624:
  case_624();
  break;
case 630:
#line 4170 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 631:
  case_631();
  break;
case 632:
  case_632();
  break;
case 633:
  case_633();
  break;
case 635:
#line 4199 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 636:
#line 4212 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 637:
  case_637();
  break;
case 638:
  case_638();
  break;
case 639:
  case_639();
  break;
case 640:
  case_640();
  break;
case 641:
#line 4251 "cs-parser.jay"
  { yyVal = null; }
  break;
case 642:
#line 4253 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 643:
  case_643();
  break;
case 646:
  case_646();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 649:
  case_649();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
  case_653();
  break;
case 654:
  case_654();
  break;
case 655:
  case_655();
  break;
case 656:
  case_656();
  break;
case 657:
  case_657();
  break;
case 658:
  case_658();
  break;
case 659:
  case_659();
  break;
case 660:
  case_660();
  break;
case 661:
  case_661();
  break;
case 663:
#line 4373 "cs-parser.jay"
  {
		current_container.AddBasesForPart (current_class, (List<FullNamedExpression>) yyVals[0+yyTop]);
	 }
  break;
case 665:
#line 4381 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 666:
  case_666();
  break;
case 667:
  case_667();
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
  case_670();
  break;
case 671:
  case_671();
  break;
case 672:
  case_672();
  break;
case 673:
  case_673();
  break;
case 674:
#line 4470 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 675:
#line 4474 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 676:
#line 4481 "cs-parser.jay"
  {
		yyVal = Variance.None;
	  }
  break;
case 677:
  case_677();
  break;
case 678:
#line 4495 "cs-parser.jay"
  {
		yyVal = Variance.Covariant;
	  }
  break;
case 679:
#line 4499 "cs-parser.jay"
  {
		yyVal = Variance.Contravariant;
	  }
  break;
case 680:
  case_680();
  break;
case 681:
#line 4524 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 682:
  case_682();
  break;
case 683:
  case_683();
  break;
case 684:
  case_684();
  break;
case 685:
  case_685();
  break;
case 690:
#line 4568 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 691:
#line 4572 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 693:
  case_693();
  break;
case 696:
#line 4596 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 697:
#line 4600 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 726:
  case_726();
  break;
case 727:
  case_727();
  break;
case 728:
  case_728();
  break;
case 729:
  case_729();
  break;
case 730:
  case_730();
  break;
case 733:
  case_733();
  break;
case 734:
  case_734();
  break;
case 735:
  case_735();
  break;
case 736:
  case_736();
  break;
case 737:
#line 4744 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 738:
#line 4748 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 739:
  case_739();
  break;
case 741:
  case_741();
  break;
case 742:
#line 4769 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 743:
  case_743();
  break;
case 744:
  case_744();
  break;
case 745:
  case_745();
  break;
case 746:
  case_746();
  break;
case 748:
  case_748();
  break;
case 749:
  case_749();
  break;
case 754:
  case_754();
  break;
case 755:
  case_755();
  break;
case 756:
#line 4858 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 757:
  case_757();
  break;
case 762:
  case_762();
  break;
case 764:
  case_764();
  break;
case 765:
  case_765();
  break;
case 766:
  case_766();
  break;
case 767:
#line 4908 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 768:
#line 4912 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 769:
#line 4913 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 770:
  case_770();
  break;
case 771:
  case_771();
  break;
case 772:
  case_772();
  break;
case 775:
  case_775();
  break;
case 776:
  case_776();
  break;
case 777:
#line 4981 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 778:
  case_778();
  break;
case 779:
  case_779();
  break;
case 781:
  case_781();
  break;
case 782:
  case_782();
  break;
case 783:
  case_783();
  break;
case 784:
#line 5025 "cs-parser.jay"
  {
		current_block = current_block.CreateSwitchBlock (lexer.Location);
	  }
  break;
case 785:
#line 5029 "cs-parser.jay"
  {
		yyVal = new SwitchSection ((List<SwitchLabel>) yyVals[-2+yyTop], current_block);
	  }
  break;
case 786:
  case_786();
  break;
case 787:
  case_787();
  break;
case 788:
  case_788();
  break;
case 789:
#line 5058 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 794:
  case_794();
  break;
case 795:
  case_795();
  break;
case 796:
  case_796();
  break;
case 797:
#line 5097 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 798:
  case_798();
  break;
case 799:
  case_799();
  break;
case 800:
#line 5125 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 802:
  case_802();
  break;
case 803:
  case_803();
  break;
case 805:
#line 5146 "cs-parser.jay"
  { yyVal = null; }
  break;
case 807:
#line 5151 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 811:
  case_811();
  break;
case 812:
  case_812();
  break;
case 813:
  case_813();
  break;
case 814:
  case_814();
  break;
case 821:
  case_821();
  break;
case 822:
  case_822();
  break;
case 823:
  case_823();
  break;
case 824:
  case_824();
  break;
case 825:
  case_825();
  break;
case 826:
  case_826();
  break;
case 827:
  case_827();
  break;
case 828:
  case_828();
  break;
case 829:
  case_829();
  break;
case 832:
#line 5306 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 833:
  case_833();
  break;
case 834:
  case_834();
  break;
case 835:
  case_835();
  break;
case 836:
  case_836();
  break;
case 837:
  case_837();
  break;
case 840:
#line 5359 "cs-parser.jay"
  {
		yyVal = new Catch ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 841:
  case_841();
  break;
case 842:
#line 5378 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 843:
  case_843();
  break;
case 844:
#line 5396 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 845:
#line 5403 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 846:
  case_846();
  break;
case 847:
#line 5413 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 848:
  case_848();
  break;
case 849:
  case_849();
  break;
case 850:
  case_850();
  break;
case 851:
  case_851();
  break;
case 852:
  case_852();
  break;
case 853:
  case_853();
  break;
case 854:
  case_854();
  break;
case 855:
  case_855();
  break;
case 856:
#line 5496 "cs-parser.jay"
  {
		report.Error (210, lexer.Location, "You must provide an initializer in a fixed or using statement declaration");
	  }
  break;
case 857:
  case_857();
  break;
case 858:
  case_858();
  break;
case 859:
  case_859();
  break;
case 860:
  case_860();
  break;
case 861:
  case_861();
  break;
case 862:
  case_862();
  break;
case 863:
  case_863();
  break;
case 864:
  case_864();
  break;
case 865:
  case_865();
  break;
case 866:
#line 5596 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 867:
  case_867();
  break;
case 868:
#line 5611 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 869:
  case_869();
  break;
case 870:
  case_870();
  break;
case 872:
  case_872();
  break;
case 873:
#line 5656 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 874:
  case_874();
  break;
case 875:
  case_875();
  break;
case 876:
  case_876();
  break;
case 877:
  case_877();
  break;
case 881:
  case_881();
  break;
case 887:
#line 5715 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 888:
  case_888();
  break;
case 889:
#line 5734 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 890:
  case_890();
  break;
case 891:
  case_891();
  break;
case 892:
  case_892();
  break;
case 893:
  case_893();
  break;
case 894:
  case_894();
  break;
case 895:
  case_895();
  break;
case 896:
  case_896();
  break;
case 897:
  case_897();
  break;
case 898:
  case_898();
  break;
case 900:
#line 5878 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 901:
#line 5885 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 902:
  case_902();
  break;
case 904:
  case_904();
  break;
case 905:
  case_905();
  break;
case 907:
  case_907();
  break;
case 908:
  case_908();
  break;
case 909:
#line 5931 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 910:
  case_910();
  break;
case 911:
  case_911();
  break;
case 912:
#line 5948 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 913:
  case_913();
  break;
case 914:
  case_914();
  break;
case 916:
  case_916();
  break;
case 917:
  case_917();
  break;
case 920:
  case_920();
  break;
case 921:
  case_921();
  break;
case 929:
#line 6072 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 930:
#line 6079 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 931:
  case_931();
  break;
case 932:
  case_932();
  break;
case 933:
#line 6096 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], new MemberName (MemberCache.IndexerNameAlias));
	  }
  break;
case 934:
#line 6100 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 935:
  case_935();
  break;
case 936:
  case_936();
  break;
case 937:
  case_937();
  break;
case 938:
  case_938();
  break;
case 940:
#line 6136 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 942:
#line 6144 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 943:
#line 6148 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 944:
#line 6155 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 946:
  case_946();
  break;
case 947:
  case_947();
  break;
case 948:
  case_948();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 388 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");
		}
	  }

void case_8()
#line 400 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 420 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias"){
			syntax_error (lt.Location, "`alias' expected");
		} else if (lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (lt.Location, "external alias");
		} else {
			lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop]; 
			current_namespace.AddUsingExternalAlias (lt.Value, lt.Location, report);
			ubag.AddExternAlias  (GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]), lt, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 446 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 451 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_19()
#line 459 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		current_namespace.AddUsingAlias (lt.Value, (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		ubag.AddUsingAlias (GetLocation (yyVals[-4+yyTop]), lt, GetLocation (yyVals[-2+yyTop]), (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
		  }

void case_20()
#line 470 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_21()
#line 478 "cs-parser.jay"
{
		current_namespace.AddUsing ((MemberName) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		ubag.AddUsing (GetLocation (yyVals[-2+yyTop]), (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_22()
#line 491 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		MemberName name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file.NamespaceContainer)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		current_namespace = new NamespaceContainer (name, module, current_namespace, file);
		module.AddTypesContainer (current_namespace);
		current_class = current_namespace.SlaveDeclSpace;
		current_container = current_class.PartialContainer;
		
		ubag.DeclareNamespace (GetLocation (yyVals[-1+yyTop]), name);
	  }

void case_23()
#line 522 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
		ubag.OpenNamespace (GetLocation (yyVals[0+yyTop]));
	  }

void case_24()
#line 528 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_namespace, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_namespace, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		current_namespace = current_namespace.Parent;
		current_class = current_namespace.SlaveDeclSpace;
		current_container = current_class.PartialContainer;
		ubag.CloseNamespace (GetLocation (yyVals[-1+yyTop]));
		ubag.EndNamespace (GetLocation (yyVals[-1+yyTop]));
	  }

void case_25()
#line 544 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_26()
#line 549 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location);		
	  }

void case_27()
#line 554 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_32()
#line 572 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[0+yyTop];

		if (name.TypeArguments != null)
			syntax_error (lexer.Location, "namespace name expected");

		yyVal = name;
	  }

void case_41()
#line 604 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file.NamespaceContainer);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_50()
#line 654 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
		lbag.AddLocation (yyVal, savedOpenLocation, savedCloseLocation);
	  }

void case_51()
#line 660 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		if (attrs == null)
			attrs = new Attributes (sect);
		else
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_52()
#line 673 "cs-parser.jay"
{
		lexer.parsing_attribute_section = true;
		savedOpenLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_53()
#line 678 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_54()
#line 686 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_55()
#line 693 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
	  
		current_attr_target = null;
		lexer.parsing_attribute_section = false;
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
 	  }

void case_56()
#line 705 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_57()
#line 713 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (lt.Value, lt.Location);
	  }

void case_60()
#line 720 "cs-parser.jay"
{
		if (yyToken == Token.IDENTIFIER) {
			Error_SyntaxError (yyToken);
			yyVal = null;
		} else {
			string name = GetTokenName (yyToken);
			yyVal = CheckAttributeTarget (name, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_62()
#line 737 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		attrs.Add ((Attribute) yyVals[0+yyTop]);

		yyVal = attrs;
	  }

void case_64()
#line 751 "cs-parser.jay"
{
		--lexer.parsing_block;
		MemberName mname = (MemberName) yyVals[-2+yyTop];
		if (mname.IsGeneric) {
			report.Error (404, lexer.Location,
				      "'<' unexpected: attributes cannot be generic");
		}

		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];
		ATypeNameExpression expr = mname.GetTypeExpression ();
		yyVal = new Attribute (current_attr_target, expr, arguments, mname.Location, lexer.IsEscapedIdentifier (mname));
	  }

void case_69()
#line 781 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_70()
#line 787 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_71()
#line 793 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
	  }

void case_72()
#line 808 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (o[1], GetLocation (yyVals[-1+yyTop]));
	  }

void case_76()
#line 833 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_77()
#line 843 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
	  }

void case_95()
#line 890 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_97()
#line 907 "cs-parser.jay"
{ 
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		push_current_class (new Struct (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
	  }

void case_98()
#line 913 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]));
	  }

void case_99()
#line 924 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_100()
#line 930 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[0+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_102()
#line 942 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_118()
#line 984 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_class, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_container.AddConstant ((Const) current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_119()
#line 997 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_124()
#line 1027 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_126()
#line 1040 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_127()
#line 1046 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_130()
#line 1061 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_class, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_container.AddField (current_field);
		yyVal = current_field;
	  }

void case_131()
#line 1076 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_132()
#line 1089 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_class, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_container.AddField (current_field);
	  }

void case_133()
#line 1100 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_136()
#line 1123 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_137()
#line 1129 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_142()
#line 1156 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_144()
#line 1166 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_149()
#line 1192 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_151()
#line 1205 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_152()
#line 1211 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_155()
#line 1221 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_156()
#line 1230 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Add it early in the case of body being eof for full aot*/
		current_container.AddMethod ((Method) yyVals[0+yyTop]);
	  }

void case_157()
#line 1238 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface && method.Block != null) {
			report.Error (531, method.Location, "`{0}': interface members cannot have a definition", method.GetSignatureForError ());
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_160()
#line 1266 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		GenericMethod generic = null;
		if (name.TypeArguments != null) {
			generic = new GenericMethod (current_namespace, current_class, name,
						     (FullNamedExpression) yyVals[-7+yyTop], current_local_parameters);

			generic.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		} else if (yyVals[0+yyTop] != null) {
			report.Error (80, GetLocation (yyVals[0+yyTop]),
				"Constraints are not allowed on non-generic declarations");
		}

		Method method = new Method (current_class, generic, (FullNamedExpression) yyVals[-7+yyTop], (Modifiers) yyVals[-8+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-9+yyTop]);
				     
		if (yyVals[0+yyTop] != null && ((method.ModFlags & Modifiers.OVERRIDE) != 0 || method.IsExplicitImpl)) {
			report.Error (460, method.Location,
				"`{0}': Cannot specify constraints for overrides and explicit interface implementation methods",
				method.GetSignatureForError ());
		}

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_163()
#line 1311 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		if (yyVals[-1+yyTop] != null && name.TypeArguments == null)
			report.Error (80, lexer.Location,
				      "Constraints are not allowed on non-generic declarations");

		Method method;
		GenericMethod generic = null;
		if (name.TypeArguments != null) {
			generic = new GenericMethod (current_namespace, current_class, name,
				new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-7+yyTop])),
				current_local_parameters);

			generic.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		}

		var modifiers = (Modifiers) yyVals[-9+yyTop];


		const Modifiers invalid_partial_mod = Modifiers.AccessibilityMask | Modifiers.ABSTRACT | Modifiers.EXTERN |
			Modifiers.NEW | Modifiers.OVERRIDE | Modifiers.SEALED | Modifiers.VIRTUAL;

		if ((modifiers & invalid_partial_mod) != 0) {
			report.Error (750, name.Location, "A partial method cannot define access modifier or " +
       			"any of abstract, extern, new, override, sealed, or virtual modifiers");
			modifiers &= ~invalid_partial_mod;
		}

		if ((current_class.ModFlags & Modifiers.PARTIAL) == 0) {
			report.Error (751, name.Location, "A partial method must be declared within a " +
       			"partial class or partial struct");
		}
		
		modifiers |= Modifiers.PARTIAL | Modifiers.PRIVATE;
		
		method = new Method (current_class, generic, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-7+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-10+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		/* TODO: lbag, push void*/
		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-8+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_164()
#line 1366 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		Method method = new Method (current_class, null, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_169()
#line 1395 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, lbag.GetLocations (pars_list));
	  }

void case_170()
#line 1401 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);

		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  }

void case_171()
#line 1408 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_172()
#line 1414 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  }

void case_173()
#line 1421 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_174()
#line 1431 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  }

void case_175()
#line 1437 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_178()
#line 1454 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_179()
#line 1462 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_180()
#line 1471 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			lbag.AppendTo (pars, GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_181()
#line 1495 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_182()
#line 1504 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_183()
#line 1514 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_185()
#line 1529 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_188()
#line 1574 "cs-parser.jay"
{
		yyVal = yyVals[0+yyTop];
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_189()
#line 1579 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_190()
#line 1603 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
	  		
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_191()
#line 1610 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
	  
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_192()
#line 1617 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
	  			
		yyVal = Parameter.Modifier.This;
	  }

void case_193()
#line 1630 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
	  }

void case_194()
#line 1635 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
	  }

void case_195()
#line 1642 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_196()
#line 1650 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
	  }

void case_197()
#line 1655 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
	  }

void case_199()
#line 1671 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_200()
#line 1682 "cs-parser.jay"
{
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_201()
#line 1687 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_class, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_container.AddProperty ((Property)current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_202()
#line 1701 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_203()
#line 1708 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		current_property = null;
	  }

void case_205()
#line 1722 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-6+yyTop];
		Indexer indexer = new Indexer (current_class, type,
			(MemberName)yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (ParametersCompiled) yyVals[-2+yyTop], (Attributes) yyVals[-8+yyTop]);
			
		current_property = indexer;

  		current_container.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-6+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-4+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
	  }

void case_207()
#line 1752 "cs-parser.jay"
{ 
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		lbag.AppendToMember (current_property, GetLocation (yyVals[-1+yyTop]));
		current_property = null;		
	  }

void case_212()
#line 1768 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_213()
#line 1782 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lbag.AddMember (current_property.Get, GetModifierLocations ());
		lexer.PropertyParsing = false;
	  }

void case_214()
#line 1804 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}		
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_215()
#line 1825 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lbag.AddMember (current_property.Set, GetModifierLocations ());
		lexer.PropertyParsing = false;
	  }

void case_216()
#line 1852 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_218()
#line 1874 "cs-parser.jay"
{
		lbag.AppendToMember (lbag.LastMember, GetLocation (yyVals[0+yyTop]));
	  	yyVal = null;
	  }

void case_219()
#line 1879 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_221()
#line 1894 "cs-parser.jay"
{
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		push_current_class (new Interface (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_222()
#line 1901 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  }

void case_223()
#line 1912 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_224()
#line 1918 "cs-parser.jay"
{
	    lbag.AppendToMember (current_class, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_240()
#line 1970 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_class, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_container.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
		}
		
		current_local_parameters = null;
	  }

void case_244()
#line 2001 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_246()
#line 2013 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count > 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			} else if (p_count != 2) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_271()
#line 2089 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_273()
#line 2108 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_274()
#line 2123 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_275()
#line 2129 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_276()
#line 2139 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_container.AddConstructor (c);

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_277()
#line 2158 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_278()
#line 2167 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];  
		
		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_279()
#line 2178 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-6+yyTop];
		var mods = (Modifiers) yyVals[-7+yyTop];
		ConstructorInitializer ci = (ConstructorInitializer) yyVals[0+yyTop];

		Constructor c = new Constructor (current_class, lt.Value, mods,
			(Attributes) yyVals[-8+yyTop], current_local_parameters, ci, lt.Location);
		
		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
			if (ci != null) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			
			}
		}
		
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = c;
	  }

void case_285()
#line 2223 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_287()
#line 2233 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_288()
#line 2239 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_289()
#line 2247 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_290()
#line 2256 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_class, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_container.AddMethod (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_291()
#line 2281 "cs-parser.jay"
{
		current_event_field = new EventField (current_class, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_container.AddEvent (current_event_field);
		
		if (current_event_field.MemberName.Left != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_292()
#line 2295 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_event_field = null;
	  }

void case_293()
#line 2308 "cs-parser.jay"
{
		current_event = new EventProperty (current_class, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_container.AddEvent (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_294()
#line 2316 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_295()
#line 2323 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_298()
#line 2342 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_303()
#line 2366 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_305()
#line 2376 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_306()
#line 2385 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_310()
#line 2406 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_311()
#line 2411 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_312()
#line 2416 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_313()
#line 2424 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_314()
#line 2436 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_315()
#line 2452 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_316()
#line 2464 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_317()
#line 2480 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_319()
#line 2492 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_320()
#line 2497 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_class (new Enum (current_namespace, current_class, (TypeExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], MakeName (name), (Attributes) yyVals[-6+yyTop]), null);
	  }

void case_321()
#line 2509 "cs-parser.jay"
{
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_322()
#line 2515 "cs-parser.jay"
{
		if (doc_support)
			current_class.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-1+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_324()
#line 2532 "cs-parser.jay"
{
	 	var te = yyVals[0+yyTop] as TypeExpression;
		if (te == null || !EnumSpec.IsValidUnderlyingType (te.Type)) {
			Enum.Error_1008 (GetLocation (yyVals[0+yyTop]), report);
			yyVal = null;
		} else {
			yyVal = yyVals[0+yyTop];
		}
	 }

void case_325()
#line 2542 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_330()
#line 2560 "cs-parser.jay"
{
	  	lbag.AddLocation (yyVals[-2+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_331()
#line 2568 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_class, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_class).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_332()
#line 2581 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_333()
#line 2589 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_class, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_class).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_335()
#line 2614 "cs-parser.jay"
{
		valid_param_mod = 0;

		MemberName name = MakeName ((MemberName) yyVals[-4+yyTop]);
		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_namespace, current_class, (FullNamedExpression) yyVals[-5+yyTop],
					     (Modifiers) yyVals[-7+yyTop], name, p, (Attributes) yyVals[-8+yyTop]);

		ubag.PushTypeDeclaration (del);
		ubag.PopTypeDeclaration ();
		current_container.AddDelegate (del);
		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_337()
#line 2634 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		current_delegate.SetParameterInfo ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_339()
#line 2652 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_341()
#line 2663 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberName (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
	  }

void case_343()
#line 2674 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));		
	  }

void case_344()
#line 2683 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_346()
#line 2695 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");	  
	  
		yyVal = yyVals[-1+yyTop];
	  }

void case_347()
#line 2702 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_348()
#line 2710 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_349()
#line 2716 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_351()
#line 2732 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_352()
#line 2741 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeArguments != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_354()
#line 2752 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_355()
#line 2761 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeContainer.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_356()
#line 2766 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName ((MemberName) yyVals[-1+yyTop], TypeContainer.DefaultIndexerName, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_357()
#line 2774 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_358()
#line 2780 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		
		yyVal = new MemberName (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_359()
#line 2788 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_361()
#line 2798 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_362()
#line 2809 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression)yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_363()
#line 2815 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression)yyVals[0+yyTop]);
		yyVal = type_args;
		lbag.AddLocation (yyVals[0+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_364()
#line 2825 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
		yyVal = new TypeParameterName (lt.Value, (Attributes)yyVals[-2+yyTop], (Variance) yyVals[-1+yyTop], lt.Location);
  	  }

void case_365()
#line 2830 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameterName ("", null, lexer.Location);
  	  }

void case_370()
#line 2864 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_372()
#line 2873 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_374()
#line 2882 "cs-parser.jay"
{
	  	report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_377()
#line 2898 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-1+yyTop];

		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast (name.GetTypeExpression (), (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			if (name.Left == null && name.Name == "var")
				yyVal = new VarExpr (name.Location);
			else
				yyVal = name.GetTypeExpression ();
		}
	  }

void case_379()
#line 2915 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_382()
#line 2931 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_383()
#line 2937 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_384()
#line 2946 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_385()
#line 2953 "cs-parser.jay"
{
	  	Error_TypeExpected (lexer.Location);
		yyVal = null;
	  }

void case_422()
#line 3015 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_423()
#line 3019 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_434()
#line 3060 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_436()
#line 3072 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_437()
#line 3078 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_438()
#line 3084 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_439()
#line 3090 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_441()
#line 3100 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_443()
#line 3108 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_444()
#line 3116 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_447()
#line 3129 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = CollectionOrObjectInitializers.Empty;
	  		/* TODO: lbag*/
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  	}
	  }

void case_448()
#line 3139 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_451()
#line 3155 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_452()
#line 3161 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_453()
#line 3166 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_454()
#line 3174 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_456()
#line 3183 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_457()
#line 3191 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = null;
		else
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_458()
#line 3198 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = null;
	  }

void case_463()
#line 3216 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_464()
#line 3222 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_465()
#line 3232 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_466()
#line 3247 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[0+yyTop]), "An argument is missing");
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_467()
#line 3252 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_472()
#line 3273 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_473()
#line 3278 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_474()
#line 3283 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_475()
#line 3288 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_477()
#line 3300 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_478()
#line 3308 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_479()
#line 3314 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_480()
#line 3320 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_481()
#line 3328 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_482()
#line 3334 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_486()
#line 3362 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_487()
#line 3367 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_490()
#line 3389 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_491()
#line 3402 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_492()
#line 3414 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_493()
#line 3422 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_494()
#line 3429 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_495()
#line 3436 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_496()
#line 3441 "cs-parser.jay"
{
		Error_SyntaxError (1526, yyToken, "Unexpected symbol");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_498()
#line 3452 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_499()
#line 3460 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_504()
#line 3483 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_505()
#line 3489 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_506()
#line 3498 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_507()
#line 3504 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_508()
#line 3510 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_509()
#line 3515 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_513()
#line 3530 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_514()
#line 3538 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_515()
#line 3543 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_520()
#line 3573 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_521()
#line 3580 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_522()
#line 3594 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_523()
#line 3600 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_525()
#line 3614 "cs-parser.jay"
{
	  	lexer.TypeOfParsing = false;
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_528()
#line 3625 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_529()
#line 3633 "cs-parser.jay"
{  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_530()
#line 3639 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_531()
#line 3647 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-2+yyTop], lt.Value, lt.Location);		
	  }

void case_532()
#line 3653 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);		
	  }

void case_533()
#line 3659 "cs-parser.jay"
{
		var te = ((MemberName) yyVals[-3+yyTop]).GetTypeExpression ();
		if (te.HasTypeArguments)
			Error_TypeExpected (GetLocation (yyVals[0+yyTop]));

		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (te, lt.Value, (int) yyVals[0+yyTop], lt.Location);		
	  }

void case_534()
#line 3671 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_535()
#line 3681 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");

		yyVal = lt;		
	  }

void case_536()
#line 3692 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_537()
#line 3700 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_538()
#line 3708 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_539()
#line 3716 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_541()
#line 3728 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_545()
#line 3752 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	savedOpenLocation = GetLocation (yyVals[-3+yyTop]);
	  	savedCloseLocation = GetLocation (yyVals[-2+yyTop]);
	  }

void case_546()
#line 3762 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_552()
#line 3787 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_562()
#line 3835 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_563()
#line 3840 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_564()
#line 3845 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_566()
#line 3854 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_568()
#line 3863 "cs-parser.jay"
{
	  	/* Shift/Reduce conflict*/
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
  	  }

void case_572()
#line 3880 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_573()
#line 3885 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_575()
#line 3894 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_576()
#line 3899 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_577()
#line 3904 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_578()
#line 3909 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_580()
#line 3918 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_581()
#line 3923 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_583()
#line 3932 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_585()
#line 3941 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_587()
#line 3950 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_589()
#line 3959 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_591()
#line 3968 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_593()
#line 3977 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_595()
#line 3988 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_597()
#line 4000 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_598()
#line 4005 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_599()
#line 4010 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_600()
#line 4015 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_601()
#line 4020 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_602()
#line 4025 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_603()
#line 4030 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_604()
#line 4035 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_605()
#line 4040 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_606()
#line 4045 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_607()
#line 4053 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);

		yyVal = pars;
	  }

void case_608()
#line 4060 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		yyVal = pars;
	  }

void case_609()
#line 4074 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_610()
#line 4080 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_611()
#line 4086 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_613()
#line 4094 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
	  }

void case_617()
#line 4110 "cs-parser.jay"
{
		Block b = end_block (lexer.Location);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_619()
#line 4121 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	
		yyVal = EmptyExpression.Null;
	  }

void case_620()
#line 4129 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), GetLocation (yyVals[-1+yyTop]));
	  }

void case_621()
#line 4135 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_622()
#line 4140 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "lambda expressions");
	  
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }

void case_623()
#line 4147 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]));
	  }

void case_624()
#line 4152 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_631()
#line 4175 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_632()
#line 4180 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_633()
#line 4185 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_637()
#line 4214 "cs-parser.jay"
{
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		Class c = new Class (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_class (c, yyVals[-3+yyTop]);
	  }

void case_638()
#line 4225 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]));

		if (doc_support) {
			current_container.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  }

void case_639()
#line 4237 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_640()
#line 4243 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_643()
#line 4258 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
	  }

void case_646()
#line 4268 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_647()
#line 4287 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container == module)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_648()
#line 4295 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_649()
#line 4300 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_650()
#line 4305 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_651()
#line 4310 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_652()
#line 4315 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_653()
#line 4320 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_654()
#line 4325 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_655()
#line 4330 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_656()
#line 4335 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_657()
#line 4340 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_658()
#line 4345 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_659()
#line 4350 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_660()
#line 4355 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_661()
#line 4362 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_666()
#line 4383 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_667()
#line 4391 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_668()
#line 4397 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_669()
#line 4416 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_670()
#line 4424 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_671()
#line 4430 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_672()
#line 4456 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_673()
#line 4463 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_677()
#line 4483 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");

		yyVal = yyVals[0+yyTop];
	  }

void case_680()
#line 4517 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_682()
#line 4529 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_683()
#line 4534 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_684()
#line 4543 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_685()
#line 4548 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_693()
#line 4575 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_726()
#line 4639 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_727()
#line 4644 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_728()
#line 4649 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_729()
#line 4657 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_730()
#line 4665 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);

		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_733()
#line 4678 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_734()
#line 4694 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_735()
#line 4724 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_736()
#line 4735 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_739()
#line 4750 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_741()
#line 4759 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_743()
#line 4774 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_744()
#line 4781 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		lbag.AppendTo (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_745()
#line 4787 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstantDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_746()
#line 4794 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_748()
#line 4808 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_749()
#line 4813 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_754()
#line 4835 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_755()
#line 4844 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_757()
#line 4860 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_762()
#line 4878 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_764()
#line 4891 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_765()
#line 4896 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_766()
#line 4904 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_770()
#line 4922 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			Expression.Error_InvalidExpressionStatement (report, GetLocation (yyVals[0+yyTop]));
			s = EmptyExpressionStatement.Instance;
		}

		yyVal = new StatementExpression (s);
	  }

void case_771()
#line 4935 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		ExpressionStatement s;

	        s = new OptionalAssign (new SimpleName ("$retval", lexer.Location), expr, lexer.Location);
		yyVal = new StatementExpression (s);
	  }

void case_772()
#line 4943 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_775()
#line 4957 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_776()
#line 4966 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_778()
#line 4983 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, (List<SwitchSection>) yyVals[-1+yyTop], GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_779()
#line 4992 "cs-parser.jay"
{
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
		yyVal = new List<SwitchSection> ();
	  }

void case_781()
#line 5001 "cs-parser.jay"
{
		var sections = new List<SwitchSection> (4);

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_782()
#line 5008 "cs-parser.jay"
{
		var sections = (List<SwitchSection>) yyVals[-1+yyTop];

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_783()
#line 5015 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new List<SwitchSection> ();
	  }

void case_786()
#line 5034 "cs-parser.jay"
{
		var labels = new List<SwitchLabel> (2);

		labels.Add ((SwitchLabel) yyVals[0+yyTop]);
		yyVal = labels;
	  }

void case_787()
#line 5041 "cs-parser.jay"
{
		var labels = (List<SwitchLabel>) (yyVals[-1+yyTop]);
		labels.Add ((SwitchLabel) yyVals[0+yyTop]);

		yyVal = labels;
	  }

void case_788()
#line 5051 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_794()
#line 5070 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_795()
#line 5082 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_796()
#line 5090 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
	  }

void case_798()
#line 5106 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		For f = new For ((Statement) yyVals[-6+yyTop], (BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, current_block.StartLocation, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-5+yyTop]));
	  }

void case_799()
#line 5118 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_802()
#line 5131 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_803()
#line 5138 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_811()
#line 5162 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AppendTo (sl, GetLocation (yyVals[-1+yyTop]));
	  	}
	  		
		yyVal = sl;
	  }

void case_812()
#line 5178 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-5+yyTop]), "Type and identifier are both required in a foreach statement");
		yyVal = null;
	  }

void case_813()
#line 5183 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_814()
#line 5192 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_821()
#line 5215 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_822()
#line 5223 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_823()
#line 5231 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_824()
#line 5237 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_825()
#line 5242 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_826()
#line 5250 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_827()
#line 5258 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_828()
#line 5266 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_829()
#line 5282 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_833()
#line 5308 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (Block) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_834()
#line 5313 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]), true), (Block) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_835()
#line 5318 "cs-parser.jay"
{
		report.Error (1524, GetLocation (yyVals[-2+yyTop]), "Expected catch or finally");
		yyVal = null;
	  }

void case_836()
#line 5326 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_837()
#line 5333 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		if (l [0].IsGeneral) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		} else {
			if (c.IsGeneral)
				l.Insert (0, c);
			else
				l.Add (c);
		}
		
		yyVal = l;
	  }

void case_841()
#line 5361 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch (current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_843()
#line 5380 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_846()
#line 5408 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_848()
#line 5418 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_849()
#line 5429 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_850()
#line 5439 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_851()
#line 5444 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_852()
#line 5457 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_853()
#line 5467 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_854()
#line 5472 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_855()
#line 5482 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		yyVal = u;
	  }

void case_857()
#line 5498 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		yyVal = current_variable;
	  }

void case_858()
#line 5509 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_859()
#line 5521 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_860()
#line 5532 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_861()
#line 5539 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_862()
#line 5548 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop])));
	  }

void case_863()
#line 5556 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (
			new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
			}
		);
	  }

void case_864()
#line 5571 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop])));
	  }

void case_865()
#line 5579 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (
			new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
			}
		);
	  }

void case_867()
#line 5598 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_869()
#line 5613 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_870()
#line 5630 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_872()
#line 5646 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_874()
#line 5658 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_875()
#line 5665 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_876()
#line 5673 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_877()
#line 5680 "cs-parser.jay"
{
		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-3+yyTop], linq_clause_blocks.Pop (), (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_881()
#line 5697 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_888()
#line 5717 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_890()
#line 5736 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_891()
#line 5746 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_892()
#line 5754 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_893()
#line 5762 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_894()
#line 5770 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_895()
#line 5808 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_896()
#line 5816 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_897()
#line 5824 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_898()
#line 5832 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_902()
#line 5887 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_904()
#line 5898 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_905()
#line 5905 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_907()
#line 5914 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_908()
#line 5921 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_910()
#line 5933 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_911()
#line 5938 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_913()
#line 5950 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_914()
#line 5955 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_916()
#line 5965 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_917()
#line 5981 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_920()
#line 6008 "cs-parser.jay"
{ 
		current_container = new Class (current_namespace, current_class, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);
		current_class = current_container;

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		Method method = new Method (
			current_class,
			null, /* generic*/
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			new MemberName ("Host"),
			pars,
			null /* attributes */);
			
		current_container.AddMethod (method);			

		oob_stack.Push (method);
		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_921()
#line 6038 "cs-parser.jay"
{
		--lexer.parsing_block;
		Method method = (Method) oob_stack.Pop ();

		method.Block = (ToplevelBlock) end_block(lexer.Location);

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_931()
#line 6081 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_932()
#line 6087 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_935()
#line 6102 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], new MemberName (MemberCache.IndexerNameAlias));
	  }

void case_936()
#line 6107 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_937()
#line 6115 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_938()
#line 6123 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_946()
#line 6161 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_947()
#line 6167 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_948()
#line 6176 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   14,   15,   15,
   16,   21,   22,   19,   20,   20,   20,   24,   24,   25,
   25,   18,    7,    7,    6,    6,   23,   23,    8,    8,
   26,   26,   27,   27,   27,   27,   27,    9,    9,   10,
   10,   35,   33,   38,   34,   34,   36,   36,   36,   36,
   37,   37,   42,   39,   40,   41,   41,   43,   43,   43,
   43,   43,   44,   44,   48,   45,   47,   49,   49,   49,
   50,   50,   51,   51,   52,   52,   52,   52,   52,   52,
   52,   52,   52,   52,   52,   65,   67,   70,   71,   29,
   29,   73,   69,   72,   72,   74,   74,   75,   75,   75,
   75,   75,   75,   75,   75,   75,   75,   78,   53,   79,
   79,   80,   80,   81,   83,   77,   77,   82,   82,   88,
   54,   92,   54,   54,   87,   95,   87,   89,   89,   96,
   96,   97,   98,   97,   93,   93,   99,   99,  100,  101,
   91,   91,   94,   94,   94,  104,   55,  107,  108,  102,
  109,  110,  102,  102,  103,  103,  106,  106,  113,  113,
  113,  113,  113,  113,  113,  113,  113,  113,  114,  114,
  117,  117,  117,  120,  117,  118,  118,  121,  121,  122,
  122,  122,  115,  115,  115,  123,  123,  123,  116,  125,
  127,  128,   56,  130,  131,  132,   58,  126,  126,  126,
  126,  126,  136,  133,  137,  134,  135,  135,  135,  138,
  139,  140,  142,   30,   30,  141,  141,  143,  143,  144,
  144,  144,  144,  144,  144,  144,  144,  144,  147,   59,
  146,  146,  148,  148,  151,  145,  145,  150,  150,  150,
  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,
  150,  150,  150,  150,  150,  150,  150,  150,  150,  153,
  152,  154,  152,  152,  152,   60,  157,  159,  155,  156,
  156,  158,  158,  163,  161,  164,  161,  161,  165,   61,
  167,   57,  170,  171,   57,  166,  173,  166,  168,  168,
  174,  174,  175,  176,  175,  177,  172,  169,  169,  169,
  169,  169,  181,  178,  182,  179,  180,  180,  184,  186,
  187,   31,  183,  183,  183,  185,  185,  185,  188,  188,
  189,  190,  189,  191,  192,  193,   32,  194,  194,   17,
   17,  195,  195,  198,  197,  197,  197,  199,  199,  201,
   64,  124,  105,  105,  129,  129,  202,  202,  202,  200,
  200,  203,  203,  204,  204,  206,  206,   86,   76,   76,
   90,   90,  119,  119,  149,  149,  207,  207,  207,  207,
  207,  211,  211,  212,  212,  210,  210,  210,  210,  210,
  210,  210,  213,  213,  213,  213,  213,  213,  213,  213,
  213,  214,  214,  214,  214,  214,  214,  214,  214,  214,
  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
  214,  215,  215,  215,  216,  216,  216,  236,  236,  237,
  237,  238,  238,  218,  218,  235,  235,  235,  235,  235,
  235,  235,  235,  220,  239,  239,  240,  240,  241,  241,
  243,  243,  243,  244,  244,  244,  244,  244,  245,  245,
  162,  162,  249,  249,  249,  249,  249,  251,  251,  250,
  250,  252,  252,  252,  252,  253,  221,  248,  248,  248,
  254,  254,  255,  255,  222,  223,  223,  224,  225,  226,
  226,  217,  217,  217,  217,  217,  260,  256,  227,  261,
  261,  262,  262,  263,  263,  264,  264,  264,  264,  257,
  257,  208,  208,  259,  259,  265,  265,  258,  258,   85,
   85,  266,  266,  267,  228,  268,  268,  268,  269,  269,
  269,  269,  269,  270,  196,  229,  230,  231,  232,  272,
  233,  271,  271,  274,  273,  219,  275,  275,  275,  275,
  275,  277,  278,  276,  276,  276,  276,  276,  276,  276,
  279,  279,  279,  279,  280,  280,  280,  280,  280,  280,
  281,  281,  281,  282,  282,  282,  282,  282,  283,  283,
  283,  284,  284,  285,  285,  286,  286,  287,  287,  288,
  288,  289,  289,  290,  290,  291,  291,  291,  291,  291,
  291,  291,  291,  291,  291,  291,  292,  292,  293,  293,
  293,  294,  294,  295,  295,  298,  296,  297,  297,  300,
  299,  301,  302,  299,   46,   46,  246,  246,  246,  246,
  234,  234,  234,   84,  304,  305,  306,  307,  308,   28,
   63,   63,   62,   62,  111,  111,  309,  309,  309,  309,
  309,  309,  309,  309,  309,  309,  309,  309,  309,  309,
  309,   66,   66,   68,   68,   68,  310,  310,  311,  312,
  312,  313,  313,  313,  313,  205,  205,  314,  314,  316,
  112,  317,  317,  318,  160,  315,  315,  319,  319,  320,
  320,  320,  320,  324,  324,  325,  325,  325,  322,  322,
  322,  322,  322,  322,  322,  322,  322,  322,  322,  322,
  322,  326,  326,  326,  326,  326,  326,  326,  326,  326,
  326,  326,  326,  326,  340,  340,  340,  340,  327,  341,
  323,  342,  342,  343,  343,  343,  343,  343,  343,  209,
  209,  344,  346,  321,  349,  321,  345,  345,  345,  347,
  347,  352,  352,  353,  353,  348,  348,  350,  350,  354,
  354,  355,  351,  351,  351,  328,  328,  339,  339,  356,
  357,  357,  329,  329,  358,  358,  361,  359,  360,  360,
  362,  362,  362,  365,  363,  364,  364,  366,  366,  330,
  330,  330,  330,  367,  368,  372,  369,  371,  371,  373,
  373,  377,  376,  376,  374,  374,  375,  375,  379,  378,
  378,  370,  380,  370,  331,  331,  331,  331,  331,  331,
  381,  382,  383,  383,  383,  384,  385,  386,  386,  387,
  387,  332,  332,  332,  332,  388,  388,  390,  390,  389,
  391,  389,  389,  333,  334,  392,  337,  335,  394,  395,
  338,  396,  397,  336,  336,  393,  393,  303,  303,  303,
  303,  398,  398,  400,  400,  402,  401,  403,  401,  399,
  399,  399,  407,  405,  408,  409,  405,  404,  404,  410,
  410,  411,  411,  411,  411,  411,  416,  412,  417,  413,
  418,  419,  420,  414,  422,  423,  424,  414,  421,  421,
  426,  415,  425,  429,  425,  428,  431,  428,  427,  427,
  427,  430,  430,  430,  406,  432,  406,    3,    3,  433,
    3,    3,  434,  434,  247,  247,  242,  242,    5,  435,
  435,  435,  435,  439,  435,  435,  435,  435,  436,  436,
  437,  440,  437,  438,  438,  441,  441,  442,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    1,    5,    2,
    3,    0,    0,   11,    1,    3,    1,    0,    1,    0,
    1,    1,    0,    1,    0,    1,    0,    1,    1,    2,
    1,    1,    1,    1,    1,    1,    1,    0,    1,    1,
    2,    0,    3,    0,    6,    3,    1,    1,    1,    1,
    1,    3,    0,    3,    1,    0,    3,    0,    1,    1,
    3,    3,    1,    1,    0,    4,    4,    0,    1,    1,
    0,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    0,    0,    0,   13,
    5,    0,    4,    0,    1,    1,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    0,    9,    0,
    1,    1,    2,    3,    0,    3,    1,    1,    1,    0,
    8,    0,    9,    6,    0,    0,    3,    0,    1,    1,
    2,    2,    0,    5,    0,    1,    1,    2,    3,    0,
    4,    2,    1,    1,    1,    0,    3,    0,    0,   10,
    0,    0,   11,    8,    1,    1,    0,    1,    1,    3,
    3,    3,    5,    3,    5,    1,    1,    1,    1,    3,
    4,    6,    4,    0,    7,    0,    1,    1,    2,    1,
    1,    1,    4,    6,    4,    1,    2,    2,    1,    0,
    0,    0,   10,    0,    0,    0,   13,    1,    2,    1,
    2,    1,    0,    5,    0,    5,    1,    1,    1,    0,
    0,    0,    0,   15,    5,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    5,
    1,    1,    1,    1,    0,    7,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    7,    0,    7,    2,    2,    2,    0,    0,    9,    1,
    1,    0,    1,    0,    6,    0,    6,    1,    0,    8,
    0,    9,    0,    0,   10,    0,    0,    3,    0,    1,
    1,    2,    2,    0,    5,    0,    2,    2,    2,    1,
    1,    1,    0,    5,    0,    5,    1,    1,    0,    0,
    0,   12,    0,    2,    2,    0,    1,    2,    1,    3,
    2,    0,    5,    0,    0,    0,   13,    0,    1,    1,
    3,    1,    4,    2,    0,    3,    2,    1,    3,    0,
    3,    1,    1,    3,    1,    2,    3,    4,    4,    0,
    3,    1,    3,    3,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    2,    2,    2,    2,    2,
    2,    1,    3,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    3,    3,    4,    4,    4,    3,    3,
    4,    3,    4,    4,    0,    1,    3,    4,    0,    1,
    1,    3,    2,    3,    1,    2,    3,    2,    1,    1,
    0,    1,    1,    3,    3,    2,    2,    1,    1,    1,
    1,    2,    2,    4,    3,    1,    4,    1,    3,    2,
    1,    3,    1,    1,    1,    4,    3,    2,    2,    6,
    3,    7,    4,    3,    7,    3,    0,    2,    4,    1,
    2,    0,    1,    1,    3,    3,    1,    1,    1,    0,
    1,    1,    2,    2,    3,    1,    2,    0,    1,    2,
    4,    1,    3,    0,    5,    1,    1,    1,    2,    3,
    3,    4,    4,    1,    2,    4,    4,    4,    4,    0,
    4,    0,    1,    0,    4,    4,    1,    2,    2,    1,
    1,    4,    2,    1,    2,    2,    2,    2,    2,    2,
    1,    3,    3,    3,    1,    3,    3,    3,    3,    3,
    1,    3,    3,    1,    3,    3,    3,    3,    1,    3,
    3,    1,    3,    1,    3,    1,    3,    1,    3,    1,
    3,    1,    3,    1,    5,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    1,    3,    3,    2,
    1,    0,    1,    1,    1,    0,    2,    1,    1,    0,
    4,    0,    0,    7,    1,    1,    1,    1,    1,    1,
    6,    4,    4,    1,    1,    0,    0,    0,    0,   15,
    0,    1,    0,    1,    1,    2,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    0,    2,    0,    1,    1,    1,    2,    4,    1,
    3,    1,    3,    1,    1,    0,    1,    1,    1,    0,
    4,    1,    1,    0,    4,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    4,    1,    2,    2,    2,    2,    2,    2,    1,    1,
    2,    1,    0,    6,    0,    7,    0,    2,    1,    0,
    1,    1,    2,    2,    4,    0,    2,    0,    1,    1,
    2,    4,    1,    5,    2,    2,    2,    2,    2,    1,
    1,    1,    1,    1,    5,    7,    0,    8,    0,    1,
    1,    2,    1,    0,    3,    1,    2,    3,    1,    1,
    1,    1,    1,    5,    7,    0,    4,    7,    1,    0,
    1,    0,    5,    1,    0,    1,    0,    1,    1,    1,
    3,    6,    0,    9,    1,    1,    1,    1,    1,    1,
    2,    2,    3,    4,    3,    3,    3,    4,    3,    0,
    1,    3,    4,    5,    3,    1,    2,    0,    1,    2,
    0,    7,    3,    2,    2,    0,    3,    5,    0,    0,
   10,    0,    0,   10,    5,    0,    2,    2,    2,    2,
    2,    4,    5,    4,    5,    0,    5,    0,    6,    3,
    2,    1,    0,    3,    0,    0,    6,    0,    1,    1,
    2,    1,    1,    1,    1,    1,    0,    5,    0,    3,
    0,    0,    0,   12,    0,    0,    0,   13,    0,    2,
    0,    3,    1,    0,    4,    1,    0,    4,    1,    2,
    2,    1,    2,    2,    0,    0,    4,    2,    3,    0,
    4,    2,    2,    3,    0,    1,    1,    1,    2,    2,
    2,    4,    3,    0,    7,    4,    4,    3,    1,    3,
    0,    0,    4,    0,    1,    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0,  918,    0,    0,  922,    0,
    0,   15,   17,   18,  388,  394,  401,  389,  391,    0,
  390,    0,  397,  399,  386,    0,  393,  395,  387,  398,
  400,  396,  350,  939,    0,  392,  929,    0,   10,    1,
    0,    0,    0,   12,    0,  772,    0,    0,    0,    0,
    0,    0,    0,    0,  429,    0,    0,    0,    0,    0,
    0,    0,  427,    0,    0,    0,  485,    0,  428,    0,
  524,    0,  846,    0,    0,    0,  630,    0,    0,    0,
    0,    0,    0,  680,    0,  729,    0,    0,    0,    0,
    0,    0,    0,    0,  426,    0,  622,    0,  771,  712,
    0,    0,    0,    0,  403,  404,    0,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,  418,
  419,  420,  421,  424,  425,  626,  554,    0,  550,  551,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  627,  625,  628,  629,  696,  698,    0,  694,  697,
  713,  715,  716,  717,  718,  719,  720,  721,  722,  723,
  724,  714,    0,    0,    0,  773,  774,  790,  791,  792,
  793,  815,  816,  817,  818,  819,  820,    0,    0,    0,
   20,    0,    0,    0,  340,    0,  342,  926,   16,  919,
    0,    0,  253,  252,  249,  254,  255,  248,  267,  266,
  259,  260,  256,  258,  257,  261,  250,  251,  262,  263,
  269,  268,  264,  265,    0,    0,  942,    0,  931,    0,
  930,    3,   52,    0,    0,    0,   42,   39,   41,   43,
   44,   45,   46,   47,   50,   13,    0,    0,    0,  821,
  430,  431,  844,    0,    0,    0,    0,    0,  405,    0,
  822,    0,  544,  540,  543,  728,  770,  699,  726,  725,
  727,  700,  701,  702,  703,  704,  705,  706,  707,  708,
  709,  710,  711,    0,    0,    0,  796,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  831,
    0,  402,    0,    0,    0,    0,    0,    0,  845,    0,
    0,    0,  742,  738,    0,    0,    0,    0,    0,    0,
  369,    0,    0,    0,    0,    0,    0,    0,  553,    0,
    0,  549,  555,  556,  548,  560,  559,  557,  558,    0,
    0,  620,  730,  535,    0,  423,  422,    0,    0,    0,
    0,  339,    0,  736,  737,    0,  488,  489,    0,    0,
    0,  734,  735,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  921,  695,  743,
  733,    0,  768,  769,  872,  889,    0,    0,    0,  901,
  860,  858,  882,    0,    0,  880,  883,  884,  885,  886,
  861,  859,    0,    0,    0,  344,    0,   21,    0,    0,
    0,  938,    0,  351,    0,    0,    0,  940,    0,    0,
   40,  652,  658,  650,    0,  647,  657,  651,  649,  648,
  655,  653,  654,  660,  656,  659,  661,    0,    0,  645,
   51,  487,    0,    0,  483,  484,    0,  481,    0,  745,
    0,    0,    0,    0,  766,  767,    0,    0,    0,  634,
    0,  825,  823,  635,    0,    0,  509,    0,    0,    0,
  500,    0,  504,  514,  516,    0,  496,    0,    0,    0,
    0,    0,  491,    0,  494,    0,  498,  371,  826,    0,
    0,  827,  835,    0,    0,    0,  836,    0,    0,  847,
    0,    0,  741,    0,  381,    0,  377,  378,    0,  376,
  379,  380,    0,    0,    0,  561,    0,    0,  693,    0,
    0,  688,  690,  691,  692,  434,  435,  829,    0,    0,
    0,  347,  348,    0,  191,  190,  192,    0,    0,    0,
    0,  373,    0,  607,    0,    0,  439,    0,  442,    0,
  440,    0,    0,    0,    0,    0,    0,  468,  471,    0,
    0,  463,  470,  469,    0,  596,  597,  598,  599,  600,
  601,  602,  603,  604,  606,  605,  562,  564,  563,  569,
  570,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  593,    0,    0,  513,
    0,    0,    0,    0,    0,    0,    0,  873,  875,  871,
    0,  881,    0,    0,  341,  936,  937,  365,    0,    0,
  362,    0,    0,  188,    0,    0,  946,  932,  934,   60,
   58,   59,    0,    0,   53,    0,    0,   61,   63,   27,
   25,    0,    0,    0,  642,    0,  646,  438,    0,  486,
    0,  537,    0,  546,  178,  199,    0,    0,  168,    0,
    0,    0,  179,  541,    0,  849,  799,    0,  810,  797,
    0,  801,    0,    0,    0,  824,    0,    0,    0,  499,
    0,  515,  517,    0,    0,  455,    0,    0,  451,    0,
    0,  478,    0,  519,  493,    0,  155,  520,  153,  154,
  522,    0,  536,    0,  840,    0,  833,    0,  837,  528,
    0,    0,    0,  366,    0,  526,    0,    0,  538,    0,
  852,    0,  864,    0,  862,    0,    0,  632,  633,  682,
  683,  681,  689,  828,  615,  621,  614,    0,  731,    0,
  346,  610,    0,    0,    0,  552,  443,  437,  441,  436,
  539,  477,  476,  473,  472,    0,  467,  432,  433,  444,
    0,    0,  749,    0,    0,  890,  866,    0,  891,    0,
  887,    0,  902,    0,    0,    0,    0,  870,   19,  343,
  679,  678,    0,  677,    0,  361,  948,  189,  943,    0,
    0,   54,    0,    0,    0,    0,    0,    0,  368,    0,
  636,    0,    0,   80,   79,    0,  482,    0,    0,    0,
    0,    0,  545,    0,    0,    0,    0,    0,  802,    0,
    0,    0,    0,    0,  848,  506,  505,  458,    0,    0,
  927,  928,  447,  453,    0,  456,    0,  480,    0,    0,
    0,    0,    0,  777,  843,    0,  834,  534,  529,    0,
    0,  525,    0,  855,    0,  794,  865,  863,    0,  619,
  618,  617,  349,  609,  608,  623,  475,    0,  465,  464,
  595,    0,  763,  748,    0,    0,    0,  752,    0,  868,
    0,  895,    0,  910,  911,  904,  874,  876,  916,  364,
  363,  947,    0,    0,   62,   56,    0,   64,   26,   23,
    0,    0,  319,    0,  225,    0,  101,    0,   77,  757,
  128,  129,    0,    0,    0,  760,  197,  198,    0,    0,
    0,    0,  171,  180,  172,  174,    0,    0,    0,    0,
  806,    0,  811,  812,    0,    0,  457,  459,  460,  454,
  448,  452,    0,  511,    0,  479,  490,  446,  523,  521,
    0,  839,    0,    0,  530,    0,    0,  631,    0,  474,
    0,    0,  744,  753,  867,    0,    0,    0,  888,    0,
    0,    0,  935,    0,    0,    0,   69,   70,   73,   74,
    0,  334,  325,  324,    0,  637,  221,   97,    0,  746,
  761,  183,    0,  195,    0,    0,    0,  795,  857,    0,
    0,    0,  813,  776,  495,  492,  783,    0,  789,    0,
    0,  781,    0,  786,  841,  533,  532,    0,  624,    0,
    0,  869,  892,    0,    0,    0,  906,    0,  917,    0,
   75,   67,    0,    0,    0,  320,    0,    0,    0,    0,
    0,  184,    0,  175,  173,  850,  803,    0,    0,  808,
    0,    0,  778,  782,    0,  787,    0,  853,    0,  755,
    0,  896,  913,  914,  907,  877,   55,    0,   71,   72,
    0,    0,    0,    0,    0,    0,    0,  762,  182,    0,
  194,    0,    0,  814,  788,    0,  684,  842,    0,  764,
    0,    0,    0,   76,    0,    0,  335,    0,  321,    0,
  329,  385,  384,    0,  382,  666,    0,  638,    0,  667,
  222,   98,  185,  851,  798,    0,  854,  893,    0,  908,
    0,    0,    0,    0,    0,    0,    0,    0,  668,    0,
    0,    0,    0,  897,   29,   24,  336,    0,    0,  330,
  383,    0,    0,    0,  102,   99,  685,    0,    0,    0,
    0,  322,  674,    0,  675,  672,    0,  670,   95,    0,
   94,    0,    0,   83,   85,   86,   87,   88,   89,   90,
   91,   92,   93,  156,    0,    0,  238,  230,  231,  232,
  233,  234,  235,  236,  237,    0,    0,  228,    0,    0,
    0,  894,    0,  337,  333,    0,    0,    0,  639,   84,
    0,  281,  276,  280,    0,  223,  229,  116,  108,  109,
  110,  111,  112,  113,  114,  115,  117,    0,    0,  106,
  100,  900,  898,  673,  671,    0,    0,    0,    0,    0,
    0,    0,  289,    0,    0,  239,    0,    0,  247,    0,
  166,  157,  165,    0,  103,  107,    0,    0,  275,    0,
    0,  274,    0,    0,    0,    0,  355,    0,  353,    0,
    0,  200,    0,    0,    0,    0,    0,  640,  224,  118,
    0,  352,    0,    0,    0,    0,  132,    0,    0,    0,
    0,    0,    0,  158,    0,    0,  204,    0,  356,    0,
  242,  241,  240,    0,    0,  293,    0,  272,  134,    0,
  270,  161,    0,    0,  136,    0,  357,    0,    0,  201,
    0,    0,    0,  354,  245,  127,  125,    0,    0,  297,
    0,    0,    0,    0,    0,    0,    0,  278,    0,    0,
    0,    0,  140,    0,    0,    0,    0,  358,  359,    0,
    0,    0,    0,    0,  122,  312,    0,  294,    0,    0,
  306,    0,    0,    0,  301,    0,  152,    0,    0,    0,
    0,  147,    0,    0,  290,    0,  137,    0,  131,  141,
  159,  164,  212,    0,  202,    0,    0,    0,    0,  126,
    0,  119,  123,    0,    0,    0,  308,    0,  309,  298,
    0,    0,  292,  302,  273,    0,    0,  133,  148,  271,
  162,  288,    0,  279,  283,  143,    0,    0,    0,  209,
  211,  205,  246,  124,  313,  315,  295,    0,    0,  307,
  304,  151,  149,    0,    0,    0,    0,  160,  213,  215,
  203,    0,    0,    0,  306,  163,  284,  286,  144,    0,
    0,  206,  317,  318,  314,  316,  305,    0,    0,  219,
  218,  217,  214,  216,    0,    0,    0,  207,  285,  287,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   50,    9,   51,   10,   11,   52,  234,  677,  424,
   12,   13,   53,   22,   23,   24,  319,  194,  237,  662,
  817, 1001, 1116, 1463,  814,  238,  239,  240,  241,  242,
  243,  244,  245,  655,  439,  656,  657,  914,  658,  659,
  918,  815,  996,  997,  998,  267,  579, 1088,  826, 1182,
 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191, 1192,
 1193,  458,  666, 1279,  928, 1095, 1059, 1128, 1166, 1151,
 1210, 1238, 1209, 1239, 1240, 1123, 1338, 1315, 1363, 1364,
 1365,  930, 1361,  931,  720, 1255, 1326, 1302, 1351,  507,
 1344, 1320, 1380,  893, 1349, 1352, 1353, 1447, 1381, 1382,
 1378, 1194, 1262, 1221, 1280,  678, 1328, 1427, 1346, 1444,
  459,  268,  679,  680,  681,  682,  683,  642,  560, 1100,
  643,  644,  832, 1282, 1306, 1395, 1356, 1429, 1283, 1331,
 1452, 1475, 1396, 1397, 1473, 1460, 1461,  926, 1058, 1150,
 1206, 1264, 1207, 1208, 1256, 1313, 1286, 1257,  321,  225,
 1360, 1259, 1345, 1342, 1195, 1223, 1276, 1424, 1386, 1108,
 1425,  580, 1468, 1469, 1275, 1341, 1317, 1373, 1368, 1339,
 1405, 1410, 1371, 1374, 1375, 1455, 1411, 1369, 1370, 1465,
 1453, 1454,  923, 1005, 1119, 1093, 1144, 1120, 1121, 1158,
 1055, 1142, 1170,  527,  195,  111,  426,  197,  554,  434,
  226, 1294,  640,  641,  803,  819,  322,  401,  525,  301,
 1124, 1125,   46,  113,  302,  115,  116,  117,  118,  119,
  120,  121,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  254,  780,  967,  503,
  707,  853,  708,  709,  960,  136,  200,  713,  581,  582,
  583,  584,  774,  467,  468,  296,  965,  715,  402,  298,
  490,  491,  492,  493,  496,  722,  308,  737,  738,  869,
  264,  473,  265,  472,  137,  138,  139,  140,  141,  142,
  143,  144,  145,  146,  147,  148,  149,  150,  151,  152,
  153,  563,  564,  565,  756,  757,  882,  758,  154,  550,
  348,  979,  155,  485,  924, 1057, 1148, 1260,  460, 1129,
 1130, 1177, 1178,  804,  540,  330,  752, 1136,  541,  542,
  269,  270,  271,  158,  159,  160,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  172,  284,
  551,  173,  174,  315,  785,  619,  896,  829,  673,  934,
  894,  897,  898,  935,  936,  285,  175,  176,  177, 1030,
  971, 1031, 1032, 1033, 1075, 1034,  178,  179,  180,  181,
  690,  478,  691,  952, 1068,  692,  950,  693, 1070, 1071,
  182,  183,  184,  185,  186,  187,  303,  516,  517,  973,
 1077,  311,  949,  838, 1102,  875, 1109,  188,  412,  189,
  413,  899,  986,  414,  631,  798,  795,  796,  991,  415,
  416,  417,  418,  419,  420,  903,  621,  901, 1081, 1153,
 1212,  988, 1112, 1169,  793,  627,  794, 1046,  990, 1047,
 1113,  992,   17,   19,   47,   48,  229,  645,  811,  435,
  646,  647,
  };
  protected static readonly short [] yySindex = {         -140,
    0, -179, -122, -206, -107,11604,    0,  -77,    0,    0,
 -107, -206,    0,    0, -106,    0, 6451, -107,    0, -173,
 -255,    0,    0,    0,    0,    0,    0,    0,    0,   22,
    0,   41,    0,    0,    0, 4973,    0,    0,    0,    0,
    0,    0,    0,    0,  125,    0,    0,  160,    0,    0,
  -77,   70, -107,    0,  114,    0,  130,  248,  124,11086,
  283,  180,   82, 6608,    0,  180,  180,  180, -159,  180,
  180,  227,    0,10105,  180,  180,    0,10105,    0,  297,
    0,  124,    0,  180,  463,  180,    0, 8157,11654,  299,
  180,  180,10909,    0,10105,    0,10785,10785,10785,10785,
10785,10785,10785,10785,    0,  294,    0,11678,    0,    0,
  260,  375,  308,  118,    0,    0,  565,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1011,    0,    0,
  669,   98,  289,  605,  382,  567,  569,  594,  590,  439,
  619,    0,    0,    0,    0,    0,    0, 3339,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  603,  670, -270,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -189, -186,   70,
    0,  396,  652,  666,    0,  629,    0,    0,    0,    0,
11678,11678,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  704,  672,    0,  680,    0, -160,
    0,    0,    0,   70,12518,   70,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  845,  701,10241,    0,
    0,    0,    0,10105,  180,  180,  281,  308,    0,  709,
    0,11678,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  784,  117,11086,    0,11678,10105,  759,
  779,10105,10105, 4541,  429, -196,  799,11732,   40,    0,
  788,    0,  812,11678,10105,  825,  461,  180,    0,10105,
  297, 9561,    0,    0,  463,10105,  463, -205,  416,  728,
    0,  670,  118,  -69,  757,10105,10105,10105,    0, 6765,
 -299,    0,    0,    0,    0,    0,    0,    0,    0,  827,
10105,    0,    0,    0,  682,    0,    0,11509,  197,  839,
  807,    0,  317,    0,    0,  354,    0,    0,  806,10241,
 9289,    0,    0,10785,10105,10105,10105,10105,10105,10105,
10105,10105,10105,10105,10105,10785,10785,10785,11678,11678,
10785,10785,10785,10785,10785,10785,10785,10785,10785,10785,
10785,10785,10785,10785,10785,10785,10105,    0,    0,    0,
    0,  670,    0,    0,    0,    0,11749,11803,  808,    0,
    0,    0,    0,  -24,  714,    0,    0,    0,    0,    0,
    0,    0,   70,   70,  811,    0,  816,    0,  807,  704,
  704,    0, -146,    0,  528,  704,  869,    0, -180,12518,
    0,    0,    0,    0, -156,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  101,12548,    0,
    0,    0,  807,  206,    0,    0,  592,    0,  873,    0,
  876, -100,  297,  180,    0,    0,  834, 7688, -246,    0,
  878,    0,    0,    0,  895,  901,    0,  369,    0,  910,
    0,  906,    0,    0,    0,  598,    0, 7824,  610,10105,
  799, 9289,    0, 7236,    0,  463,    0,    0,    0,  913,
  921,    0,    0,  124,  297,   61,    0, 4222,  922,    0,
  923,  858,    0,  924,    0,10105,    0,    0, 1005,    0,
    0,    0,10105, 1006,  928,    0,  931,  932,    0, -283,
 6765,    0,    0,    0,    0,    0,    0,    0,  929,  297,
 6765,    0,    0, -262,    0,    0,    0,  463,  197,  889,
11827,    0,  935,    0,  939,10785,    0,  -96,    0,  247,
    0,  807,  615,10105,10105,  941, 1059,    0,    0,   50,
  942,    0,    0,    0,  669,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  669,  669,   98,   98,  289,  289,  289,  289,  605,
  605,  382,  567,  569,  594,  590,    0,  944, -197,    0,
10105,  -26,  899,   13,  903,  948,10105,    0,    0,    0,
  964,    0,  481,  807,    0,    0,    0,    0,  586,  274,
    0,11827,  528,    0,  950,  960,    0,    0,    0,    0,
    0,    0,  197,  652,    0,  962,  961,    0,    0,    0,
    0,  969,11877,  925,    0,  233,    0,    0,  110,    0,
10241,    0,  966,    0,    0,    0,  628,  973,    0,  974,
  975,  977,    0,    0,10105,    0,    0,  938,    0,    0,
  981,    0,  979,10105, 1064,    0, 6608, 6608, 7983,    0,
 4541,    0,    0, 9697, -252,    0, -282, -184,    0,  930,
  937,    0, -141,    0,    0,  991,    0,    0,    0,    0,
    0,  992,    0, 1001,    0, 4381,    0,  297,    0,    0,
  463,  394,  427,    0,  951,    0,  998,  999,    0, 6608,
    0, 6608,    0,10105,    0,10105,11678,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 8140,    0,11678,
    0,    0,  955,11509, 1031,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 9153,    0,    0,    0,    0,
 9425,10105,    0, 7393, 1002,    0,    0, 1081,    0, 1083,
    0,  761,    0, 1004,10105,10105,  963,    0,    0,    0,
    0,    0,  965,    0, -146,    0,    0,    0,    0,  528,
  528,    0,  811, 1012, 1013,  967, 1019,  925,    0, 1014,
    0, 1132, 1134,    0,    0,10105,    0, 9833, 1021,  628,
11827,11678,    0,  -50, 1137, 1140, 1027, 1022,    0,10105,
10105, 1028,10105, 1122,    0,    0,    0,    0,   60, 9969,
    0,    0,    0,    0, 7529,    0, 1149,    0,  670,10105,
 1056, 7983, 1060,    0,    0, 1009,    0,    0,    0, 1015,
  489,    0, 1018,    0, 1022,    0,    0,    0, 1052,    0,
    0,    0,    0,    0,    0,    0,    0,  561,    0,    0,
    0,11732,    0,    0, 1020, 1053, 1002,    0,10105,    0,
10105,    0,10105,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1061,  811,    0,    0,10377,    0,    0,    0,
 1066, 7253,    0,  925,    0,  925,    0,  925,    0,    0,
    0,    0, 1024, 1067, 1021,    0,    0,    0, -155, -152,
 1070, 1074,    0,    0,    0,    0, 1073, 7983, 1002, -197,
    0, 1078,    0,    0, 1085, 6608,    0,    0,    0,    0,
    0,    0, 1080,    0,  799,    0,    0,    0,    0,    0,
 -187,    0, 1086,  489,    0, 1034, 1002,    0,  297,    0,
 1036, 1079,    0,    0,    0,10105, 1114,10105,    0,10105,
 1111,  292,    0,  961,  184,  623,    0,    0,    0,    0,
 -206,    0,    0,    0, 1096,    0,    0,    0, 1084,    0,
    0,    0,  547,    0, 1087, 1210, 1211,    0,    0, 1097,
 1002,10105,    0,    0,    0,    0,    0,10105,    0, 1102,
 -203,    0, -203,    0,    0,    0,    0, 1099,    0,10105,
 7393,    0,    0, 1125,  896, 1100,    0,10105,    0, 1103,
    0,    0,10377, -107, -100,    0, 1101, 1101, 1101, 9833,
 1105,    0,10105,    0,    0,    0,    0, 1106,  979,    0,
 6608, 1107,    0,    0, 6765,    0, 1110,    0, 1113,    0,
10105,    0,    0,    0,    0,    0,    0,10105,    0,    0,
   70, 1109,   70, 7410, -145, -145, -145,    0,    0,10105,
    0, 6608, 6608,    0,    0, 6765,    0,    0, 6608,    0,
 1136,10105,10105,    0,   70, 1117,    0, 1069,    0, 1116,
    0,    0,    0, 1120,    0,    0, 1071,    0, 1156,    0,
    0,    0,    0,    0,    0, 6765,    0,    0, 1164,    0,
 1112, -145,    0, 1145,   70, 7410, 1139, 1148,    0, 1151,
 1152, 1153,10105,    0,    0,    0,    0, 1135, 1112,    0,
    0,11580,  -79,   70,    0,    0,    0, 1167,10105, 1144,
10105,    0,    0, 1166,    0,    0, 1165,    0,    0,12548,
    0, 1170,  -79,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  462,12548,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1172,   70,    0,   70, 1112,
 1123,    0, 1167,    0,    0, 1173,11580,11325,    0,    0,
  479,    0,    0,    0,11357,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1174,   70,    0,
    0,    0,    0,    0,    0,11678,11678,  336,11732,  337,
  463, 1207,    0,  197, 9089,    0, 1242,    0,    0, 1112,
    0,    0,    0, 1112,    0,    0, 1131, 1133,    0,11678,
 -151,    0,11678, 1133, 1138, 1184,    0,  197,    0, 1186,
 9021,    0, 1189, 1141,  -76,  509, 4973,    0,    0,    0,
  197,    0, 1193, 1143, 1191, 1187,    0, 1195, 1198, 1199,
 -100, 1190, 1202,    0, 1201, 1209,    0,  807,    0,  654,
    0,    0,    0, 1206, -192,    0, 1197,    0,    0, 1212,
    0,    0, 1213, 1215,    0, 1208,    0, -100, -100,    0,
 -100, 1216, 1217,    0,    0,    0,    0, 1219,  -48,    0,
 1220, -100, 1327, 1221, -100, -100,  479,    0, 7983, 1179,
 1222, 1208,    0, 1224, 1228,   26, 1214,    0,    0, -100,
 9833, 1183, 1227, 1219,    0,    0,12548,    0,   70,   70,
    0, 1188, 1229, 1220,    0, 1232,    0,10105, 1192, 1233,
 1221,    0, 1236, 1239,    0, -182,    0, 1237,    0,    0,
    0,    0,    0,12548,    0,   26,   26, 1247, 1245,    0,
 -192,    0,    0,   20, 1251,12548,    0,12548,    0,    0,
 7983, 1240,    0,    0,    0, 1252, 1212,    0,    0,    0,
    0,    0, -144,    0,    0,    0, -145,  844, 1256,    0,
    0,    0,    0,    0,    0,    0,    0, 1311, 1368,    0,
    0,    0,    0, -145, 1261, 1262, 7983,    0,    0,    0,
    0,   26,  529,  529,    0,    0,    0,    0,    0, -198,
 -198,    0,    0,    0,    0,    0,    0, 9289, 9289,    0,
    0,    0,    0,    0, 1266, 1264, 1265,    0,    0,    0,
  };
  protected static readonly short [] yyRindex = {         2824,
    0,    0, 6922, 2824,    0,    0,    0, 1638,    0,    0,
 2977, 1029,    0,    0,    0,    0,    0, 2977,    0,    0,
   43,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1640,    0,    0, 1640,    0,    0,
 1638, 3020, 2871,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1274,    0,    0,    0,    0,    0,    0,    0,
    0,11901,    0, 1268,    0,    0,    0, 1268,    0,    0,
    0,    0,    0,    0,  249,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3651,    0,    0,    0,    0,
    0,  288, 4539, 3810,    0,    0, 4380,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 4695,    0,    0,
 4763, 5107, 5311, 5651, 5855, 5991, 6127,  758, 6263, 1178,
  519,    0,    0,    0,    0,    0,    0,   43,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1230,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  911,  911, 3087,
    0,  505, 1269,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1640,  252,    0,    0,    0,    0,
    0,    0,    0, 3150,  290, 3197,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3426,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1278,    0,    0,    0,    0, 3426,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1935,    0, 2484,  380, 2065,    0,
    0, 2212, 2065,  380,    0,    0,    0,    0,    0, -242,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1268,    0,    0,    0,    0,    0,    0, 1270, 2337,    0,
 3426,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   77,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1318,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   52,    0,    0,    0,    0,    0,
    0,    0, 3260, 2642,    0,    0,    0,    0, 1782, 1640,
 1640,    0, -124,    0, 7705, 1640, 1647,    0,    0,  201,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  278,11018,    0,
    0,    0, 3426, 3969,    0,    0,    0,    0,    0,    0,
    0,11401,    0,    0,    0,    0,    0, 1273,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  854, 1033,    0,
    0, 1282,    0,    0,    0,    0,    0,  -40,    0,    0,
 3903, 1280,    0,    0,    0,  284,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1486,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    7,    0,    0,    0,    0,    0,    0,    0,    0, 8297,
    0,    0,    0,    0,    0,    0,    0,   47,  419,    0,
    0,    0, 1283,    0,    0,    0,    0, 3426,    0, 3426,
    0, 4062,    0,    0,    0,  -35,    0,    0,    0,    0,
   92,    0,    0,    0, 4867,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 4935, 5039, 5175, 5243, 5379, 5447, 5515, 5583, 5719,
 5787, 5923, 6059, 6195,  830, 6319,    0,    0,  632,    0,
    0,  380,    0,  380,    0,    0,    0,    0,    0,    0,
 2299,    0,    0, 1782,    0,    0,    0,    0, 1241,    0,
    0,    0,11955,    0,    0,  645,    0,    0,    0,    0,
    0,    0,  706, -249,    0,    0, 1288,    0,    0,    0,
    0, 1293,    0,    0,    0,    0,    0,    0,10513,    0,
    0,    0,  644,    0,    0,    0,11972,    0,    0,  663,
  691,  702,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1285,    0,    0,    0,    0,    0,    0,    0,
 1295,    0,    0,    0, 3492,    0,    0,   18,    0,   67,
 3585,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1307,    0,    0,    0,    0,    0,    0,    0,    0,
  258,  478,  551,    0,    0,    0,    0, 1304,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   97,    0,    0,    0, 1301,    0,    0,    0,    0,    0,
    0,  366,    0,  562,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -124,    0,    0,    0,    0,11972,
 8000,    0, 1308,    0,  622,    0,    0,    0,    0, 1312,
    0, 1277, 1291,    0,    0,    0,    0,    0, 1306,12026,
    0,    0,    0,11477,    0,    0,    0,  770,    0, 1322,
    0,    0,    0, 1653,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3744,    0,
 4221, 1315,    0,    0,    0, 1360,    0,    0,    0,    0,
  478,    0,    0,    0,  770,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  591,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  773,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1357,    0,    0,    0,    0,    0,
  781,  792,    0,    0,    0,    0,    0,    0, 1363,  632,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3903,    0,    0,    0,    0,    0,
 1316,    0,    0,  478,    0,  885, 1363,    0, 8297,    0,
  456,  631,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  139,    0, 1288, 2402,    0,    0,    0,    0,    0,
12068,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  656,    0,  678,    0,    0,    0,    0,    0,
 1301, 1365,    0,    0,    0,    0,    0,    0,    0,    0,
 1319,    0, 7079,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  468,  593,    0,    0,    0,    0,
    0,    0,    0,12144,11401,    0,   73,   73,   73,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  950,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
12249,    0, -278,    0, 1372, 1372, 1372,    0,    0,    0,
    0,    0,    0,    0,    0, -219,    0,    0,    0,    0,
    0,    0,    0,    0,12292,    0,    0,    0,    0, 1376,
    0,    0,    0,  147,    0,    0,    0,    0,  554,    0,
    0,    0,    0,    0,    0, 1377,    0,    0,    0,    0,
 2934, 1364,  365,    0,  217,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 2761,    0,
    0,    0, 8457, 8853,    0,    0,    0,  688,    0,    0,
    0,    0,    0,    0,    0,    0,  395,    0,    0,11183,
    0,    0, 8556,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,11251,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 8947,    0, 8655, 2761,
    0,    0,  688,    0,    0,    0,    0,  278,    0,    0,
    0,    0,    0,    0,  278,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 8754,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 4669,  306,    0, 8989,    0,    0,    0, 9059,    0, 2761,
    0,    0,    0, 2761,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  868,    0, 1379,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  908,    0,  602,    0,    0,    0,    0,    0,    0,    0,
11401,  794,    0,    0,    0,    0,    0, 1375,    0,  718,
    0,    0,    0,    0,    0,    0,  815,    0,    0,    0,
    0,    0,    0,    0,    0, 1373,    0,11401,11401,    0,
11433,    0,    0,    0,    0,    0,    0, 1382,12478,    0,
 1391,11401,10649, 1392,11401,11401,    0,    0,    0,    0,
    0, 1393,    0,    0,    0,12448,    0,    0,    0,11401,
    0,    0,    0, 1394,    0,    0,  105,    0,10940,12410,
    0,    0,    0, 1396,    0,    0,    0,    0,    0,    0,
 1403,    0,    0,    0,    0,  583,    0,  818,    0,    0,
    0,    0,    0,  898,    0,12334,12372,    0,    0,    0,
    0,    0,    0,    0,    0, 1440,    0, 1517,    0,    0,
    0,  819,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  588,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  588,    0,    0,    0,    0,    0,    0,
    0,12448,10821,12186,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1280, 1280,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1732,    0,    0,    0,   -2,   -9, -178,  -42, 1735,
    0, 1772, 1786,  568,    0,    0,   -7,    0,    0,    0,
    0,    0,    0, -780, -685, -216, -600,    0,    0,    0,
    0,    0, -190,    0,    0,    0,  879,    0,  982,    0,
    0,    0,    0,  739,  741,  -17, -229,    0,    0,    0,
    0,  613, -662, -625, -592, -518, -515, -471, -465, -453,
-1096,-1093,    0,    1,    0,  211,    0,-1034,    0,    0,
    0,    0,    0,    0,  558,  -74,  397,    0,    0,    0,
  435,-1025,    0, -273, -291, 1146,    0,    0,    0, -859,
  384,    0,    0, -493,    0,    0,  451,    0,    0,  425,
    0,    0,  460,    0, -391, -931,    0,    0,    0,    0,
  570,  -14,    0,    0,  988,  990,  994, 1155, -523,    0,
    0, -312, 1003,  566,    0, -940,    0,    0,    0,    0,
    0,    0,    0,    0,  368,    0,    0,    0,    0,    0,
    0,    0,    0,  630,    0,    0,    0,    0, -301,  548,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  641,
    0, -494,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  383,    0,    0,  465,    0,    0,  470,  472,  388,
    0,    0,    0,    0,    0,    0,    0,    0,  698,    0,
    0,    0,    0,  -58,    0,  318,  -55,    0,    0,  534,
    0,  595,    0, 1043,    0, 1333, -293, -269,  -62,  162,
    0,  710,    0,  -39,   54,    0,    0,   -5,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -263,    0,  129,    0,    0, -327,
    0,    0,    0,  997,    0, -300, -134, 1154, 1091,    0,
 1088,    0, 1284, 1495, 1200,    0,    0,  909, 1788,    0,
    0,    0,    0, 1160,    0,    0,    0,    0,    0, -504,
    0,    0,    0,    0, 1775, 1115,    0,    0,  480,  904,
  752,  902, 1482, 1483, 1484, 1487, 1481,    0, 1488,    0,
    0,    0, 1118,    0,  907,    0,    0,    0,    0,    0,
    0,    0,    0, -286,    0,    0,    0,    0, -442,    0,
  751,    0,  668,    0,  747,    0,    0,    0,  813, -519,
  -16, -305,  -13,    0, 1729,    0,   25,    0,   27,   58,
   90,  106,  115,  119,  120,  121,  134,  144,    0, -658,
    0,  -32,    0,    0,  940,    0, -455,    0,    0,    0,
  848,    0,  995,    0,  956, -449,    0,    0,    0,    0,
    0,    0,  862,    0,    0,  861,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  874,    0,    0,
    0,    0,    0,    0,    0,    0,  -37,    0, 1381,    0,
    0,    0, 1023,    0,    0,    0,    0,    0, -170,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1480,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  686,    0,    0,    0,    0,    0,    0,    0,    0,  787,
    0,    0,    0,    0,    0,    0,   31, 1090,    0,    0,
    0, 1092,
  };
  protected static readonly short [] yyTable = {           109,
  156,   18,  110,  157,  508,  505,   44,  716,  190,  235,
  721,  423,  193,  320,  325,  481,  667,  441,  422,  466,
  258,  753,  314,  398,  544,  535,  501,  260,  689,  524,
  489,  759,  981,  350, 1098,  561,  863,  763,  844,  845,
  306,  161,  925,  162,  253,  461,  562,  694,  785,  355,
  347,  363,  530,  354,  259,  362,  300, 1470,  783,  497,
  300, 1131, 1132, 1336, 1028,  307,  405,  309, 1027,  405,
  114,  854,  546, 1422,  163,  650,   14,  331,  231,   20,
 1028,  874,  191,  876,  750,  851, 1218,  259,  526,  326,
  342,  259,  259,  259,  259,  259,  259,  259,  259,  660,
 1012,  651, 1225, 1014, 1296,  403,  164, 1157,  289,  638,
 1126,  760, 1237,  114,  858,    1,  290,  114,  807, 1445,
   65,   65,  165, 1092,   65,  686,  430,  431,  850,  547,
  466,  166,  620,  652,   16,  167,  168,  169,  344,   48,
  109,  156, 1237,  110,  157,  751,  852,  235,  785,  406,
  170,    2,  406,  761,  407,  675,  408,  407,  404,  408,
  171,  345,  409,  410,  437,  409,  410,   45,   94,   48,
  498,  695,  499,  198,  251,  346, 1179, 1471,  112,   49,
 1446,   48,  161,  784,  162,  344,  686,  471, 1337,  855,
  262,  440, 1423, 1127,  286,  287,  288,  710,  292,  293,
    6,  347,  785,  304,  305,  846,  441, 1366,  345,  714,
  310,  114,  312,  479,  316,  163,  734,    2, 1029,  327,
  328,  112,  233,  252,  533,  112,  500,   20,  859,  510,
  438,  465,  860,  461, 1029,  544,  469,  653,   15,  411,
  676,  361,  421,  347,  192,  544,  258,  164, 1309,  323,
  323,  360,  523,  477,  258,  432,  528,   43,  291,  562,
  532,  661, 1013,  165,  531, 1015, 1297,  787,  233,  323,
  553,  480,  166, 1404,  484,  486,  167,  168,  169,  522,
  259, 1393, 1435,    3,    4,    5,    6,  511,  259,  233,
  941,  170,  519,   48,  521,  567,  520, 1024,  484,  925,
 1428,  171,  374,  549,  600,  601,  789,  939, 1050,  537,
  538,   55, 1438,  543, 1439,  858,  545,  345,  233,  112,
  233,  344,  925,  300,  628,  629,  201,  449,  662,  514,
  808,  767,  623,  625, 1436, 1400,  630,  196,  630,  114,
  562, 1310,  465,  578,  345,  202,  728,  586,  587,  588,
  589,  590,  591,  592,  593,  594,  595,  596,  259,  379,
 1156,  734,  323,  323,  344,  114,  975,  643,  969, 1324,
  259,  259,  259,  635,  687,  259,  259,  663, 1172,  618,
  235,  664,  342,  114,  310,  450,  361,  345,  449, 1271,
  639,  953, 1448,  630,  233,  380, 1354, 1355,  837, 1357,
  879,  879,  663,  344,  630,  196,  196,  668,  347, 1456,
 1376,  662, 1104, 1383, 1384,  824,  374,  633,  374,  643,
  374,  778,  825,  323,  502,  196,  345,  957, 1399, 1241,
  344,  654,  347,  860,  925,  687,  518,  489,  233,  662,
  925,  466,  665, 1134, 1135,  688,  450,  112,  461,  323,
 1137,  561,  263,  345, 1019, 1430, 1431,    6,  684,  323,
  636,  637,  562,  462,  374,  323,  648,  346,  466, 1036,
  466, 1037,  643,  112,  352,  381,  382,  643,  779, 1288,
  879,  643,  712, 1289,  578,  663,  719,  878,  878,  246,
   94,  112,  475, 1020,  251,  227,  643,  228,  247,  725,
  727, 1198,  248,  313,  821,  461,  323,  360,  743,  323,
  733, 1462,  768,  663,  770,  745,  771,  937,  196,  196,
  462, 1038,  959,  643,  543,  466,  342,  545,  822,  562,
  227,  114,  230,  968,  543,  755,  932,  545, 1199,  372,
  323,  323,  643,  252, 1198,  476, 1229,  405,  342,  641,
  251,  889,  249,  951,  710,  823,  773,  773,  669,  340,
  259,  643, 1181, 1197, 1051, 1067,  643,  878,  323,  323,
  643, 1200,  689,  641,  344,  856, 1229,  642,  800,  196,
  669, 1199, 1181, 1230,  328,  643,  753,  344,  199,  964,
  360, 1269, 1272,  294,  114,  295,  344,  345,  508,  252,
  641,  642,  685,  786,  114,  196, 1197,  341, 1228,  792,
  345,  346,  643, 1230, 1200,  196, 1231,  739,  360,  345,
  199,  196,  360,  250,  360,  360,  360,  360,  642,  367,
  406,  643,  360,  346,   48,  407,  342,  408, 1228,  112,
 1270, 1273,  726,  409,  410, 1201, 1231,  805, 1202,  347,
  372,  866,  372,  465,  372,  372,  338,  372,  261,  372,
  345,  258,  196,   94,  820,  196,  739,  484,  343,  326,
  528,  344,  879,  714,  769,  367,  842,  351,  251,  323,
  356,  719,  383,  384,  344,  883,  712, 1000, 1201,  806,
 1232, 1202, 1203, 1233,  345,  259,  196,  196, 1204,  357,
  358,  372,  112,  372,  909,  338,  372,  345,  346,  909,
 1205,  909,  112,  867,  909,  909,  513,  909,  909,  359,
 1232,  346,  323, 1233,  196,  196,  877,  252,  878,  514,
  360,  352,  331,  669,  568, 1203,  345, 1234,  331,  909,
  881, 1204,  196, 1235,  569,  332,  515,  353,  345,  699,
  114,  114,  345, 1205, 1072, 1236,  196,  940,  578,  344,
  313,  669,  639,  578,  891,  345,  719, 1234,  932,  544,
  669,  570,  352, 1235,  594,  345,  425,  907,  908,  389,
  390,  571,  345,  352,  344, 1236,  344,  345,  427, 1101,
  611,  345,  611,  114,  909,  114,  346,  345,  494,  870,
  544,  313,  495,  323,  345,  654,  912,  345,  929,  345,
  480,  912,  313,  912,  868,  635,  912,  912,  921,  912,
  912, 1049,  484, 1000,  323,  955, 1133,  765, 1107,  765,
  544,  765,  958,  555,  345,  735,  345, 1222,  667,  395,
  556,  912,  966,  585,  719,   94,  345, 1004,  313,  345,
  345,  396,  557,  427, 1261, 1387,  799,  594,  112,  112,
  602,  603,  594,  345,  594,  594,  594,  594,  594,  594,
  594,  594,  594,  594,  594,   94, 1292,  345,  196,  801,
  345,  985, 1299,  987, 1311,  989,  594,  323,  594, 1305,
  594,  802,  594,  594,  594,   94,  912, 1215,  441,  999,
  903,  112,  345,  112, 1155,  903,  654,  903,  323,  868,
  903,  903, 1115,  903,  903, 1061, 1258, 1440,  800,  338,
  665,  323,  338, 1258, 1006,  323, 1007, 1062, 1008,  665,
  719,  905,  980,  555,  781,  830,  905,  552,  905,  347,
  556,  905,  905,  364,  905,  905,   25,  594,   26,  282,
  391,   27,  557, 1459,  664,  508,   28,  392,  282,  196,
   29,  670,  751,  664,  755,  671,  751,  702, 1042,   31,
 1044,  703, 1045, 1476, 1477,  291,   33,  291,  393,  711,
  196,   34,  291,  495,  772,   35,  385,  386,  671,  394,
  903,   66,  323,  323, 1052,   66, 1053,   37, 1054,   38,
  387,  388,  754,   39,  754,  747,  754,  747,  397,  114,
  480,   40,   41,  588,  945,   42,  945,  756,  317,  756,
  400,  905, 1079,  719,  427,  181,  899,  181,   36,  181,
 1086,  899,  169,  899,  169,  999,  899,  899,  295,  899,
  899,  428,  480,  196, 1091,  480,  429,  193,  235,  193,
 1118,  193,  406,  323,  376,  377,  378,  407,  543,  408,
  176,  545,  176, 1111,  196,  409,  410,  345,  433,  932,
 1114,  177,  235,  177,  227,  345,  345,  196,  345,  345,
   57,  196,  480,  323,  360,  589,  433, 1176,  360,  543,
  345,  360,  545,  360, 1139, 1045,  588,  436,  360,  349,
  462,  588, 1118,  588,  588,  588,  588,  588,  588,  588,
  588,  588,  588,  588,  904,  905,  899,  112,  463,  543,
 1180, 1196,  545,  474,  114,  588,  470,  588,  114,  588,
  196,  588,  588,  588,  482, 1168,  606,  607,  608,  609,
 1180,  856, 1176,  856,   68,  529,   68,  588,  196,  196,
  199, 1213,  199,  480,  483,  114,  114,  588,  588,  114,
  353,  170,  114,  170, 1196,  504, 1180,  135,  589,  135,
  588, 1267, 1268,  589,  534,  589,  589,  589,  589,  589,
  589,  589,  589,  589,  589,  589,  588,  509,  296,  114,
  296,  142,  303,  142,  303, 1295, 1180,  589, 1298,  589,
  512,  589,  548,  589,  589,  589, 1263, 1449, 1450,  196,
  566,  332,  333,  334,  335,  336,  337,  338,  339,  589,
  345,  507, 1303,  572,  345,  626,  345,  507,  349,  589,
  589,  196,  112,  634,  350, 1303,  112,  649,  350,  196,
  345,  130,  589,  130,  672,  345,  345,  674,  130, 1083,
 1084,  686, 1332,  696, 1333,  323,  531,  531,  589,  878,
  878,  643,  643,  112,  112,  345,  697,  112, 1096, 1097,
  112, 1312,  698,  345,  350,  741,  345,  700,  350,  701,
  345,  350,  350,  350,  723,   36,  604,  605,  350,   36,
  610,  611,  724,  739,  740,  742, 1367,  112,  744,  746,
   36,  747,  748,  749,  754,   36,  762,  323,  764,   36,
  765,  776,   36, 1394,  777,  781,  788,  512,  782,  797,
  790,  809,  350,  323,   36,   36, 1406, 1408,  791,   36,
   36,  719, 1263,  810,  813,   36,  812,   36,   36,   36,
   36,  816,   43,  480,  833,   36,  828,  834,  835,   36,
  836,   36,  841, 1394, 1394,  839,  840,  843,  198,  857,
 1416,   36,  861,   36,   36,  862,   36,  864,  871,  872,
   36,  873,  884,  886,  900,  895,  902,  906,  323,  323,
  909,  916,  910,  917,  919,  920,  323,  925,  922,  927,
   36,  365,  945,  719,  933,  946,   36,   36,  947,  954,
  508,  956,  948,  424,  963,  424,  508,  323,  323, 1394,
  323,  196,  366,  367,  368,  369,  370,  371,  372,  373,
  374,  375,  498,  978,  424,  424,  972,  970,  983,  719,
  993,  323,  974,  592,  323,  976, 1002,  982, 1464, 1464,
  536, 1009, 1010, 1016,  424, 1472, 1472, 1017, 1018, 1025,
  578,  578,  424, 1022,  868,  424, 1023, 1035, 1040, 1041,
 1043, 1048, 1056,  196, 1060, 1064, 1065, 1063, 1066, 1073,
 1078, 1082, 1087, 1085, 1099, 1094, 1107, 1103,  536,  196,
 1117, 1105, 1110, 1138, 1141,  832, 1143, 1155, 1147, 1145,
  597,  598,  599, 1146, 1127,  536,  536,  536,  536,  536,
  536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
  536, 1154, 1159, 1162, 1163, 1171,  592, 1164, 1165, 1214,
 1167,  592, 1211,  592,  592,  592,  592,  592,  592,  592,
  592,  592,  592,  592,  196,  196, 1216, 1219, 1217, 1226,
 1242, 1265,  196, 1274, 1244,  592, 1287,  592, 1290,  592,
 1291,  592,  592,  592, 1301, 1300, 1304, 1307, 1308, 1316,
 1310, 1318, 1319,  196,  196, 1321,  196,  592, 1322, 1323,
 1325, 1329, 1284,  512, 1327, 1330, 1335, 1340,  512,  512,
 1343, 1350, 1377, 1398, 1347, 1284, 1348,  196, 1358, 1359,
  196, 1284, 1362, 1372, 1379, 1391, 1388, 1389, 1284, 1392,
 1401,  512, 1402, 1415, 1413, 1412,  592, 1420, 1418, 1417,
 1421,  512,  536, 1432,  512,  512, 1433, 1426, 1437,  512,
 1441, 1442,  512, 1451,  512, 1436,  512,  512,  512,  512,
 1435, 1457, 1458, 1478,  512, 1479, 1480,    9,  512,  941,
  542,  612,  512,  830,   32,  502,  933,  732,  800,  503,
  512,  461,  775,  512,  613,  512,  512,   30,  676,   22,
  804,  512,  501,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,   30,  527,  750,   31,  323,  512,
  766,  758,   31,  779,  512,  512,  780,  512,  512,  512,
  512,  512,  512,  512,  220,  512,  512,  805,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,   96,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  838,  759,  512,  750,  512,  807,  512,  664,  664,
  512,  832,  832,  327,  686,  352,  512,  345,  138,  832,
  832,  832,  832,  832,  643,  832,  832,  120,  832,  832,
  832,  832,  832,  832,  832,  832,  299,  145,  139,  121,
  832,  300,  832,  832,  832,  832,  832,  832,  146,  643,
  832,  345,  232,   54,  832,  832,  236,  832,  832,  832,
   21, 1089,  994, 1090,  915, 1220, 1266, 1434, 1403,  832,
 1443,  832, 1390,  832,  832, 1419, 1385,  832,  818,  832,
  832,  832,  832,  832,  832,  832,  832,  832,  832,  832,
  832,  942,  832,  943, 1281,  832,  832,  944, 1474,  832,
  832,  831,  938, 1293, 1314, 1224, 1227, 1467, 1414, 1409,
 1407, 1466, 1160, 1334,  832,  832,  832,  911,  832, 1285,
  736,  962,  832,  832,  573, 1161,  832,  849,  775,  297,
  847,  832,  832,  832,  832,  832,  888,  329,  890,  832,
  827,  832,  612, 1026,  613,  616,  614,  832,  832, 1149,
  615,  885, 1152,  617, 1245, 1039,  399, 1106, 1080, 1021,
 1011,  984, 1074, 1076,  632, 1069,  729,  977, 1243, 1140,
  913,  912,  832,  832,  832,  832,    0,  832,  775,  775,
    0,    0,    0,    0,  832,    0,  775,  775,  775,  775,
  775,    0,  775,  775,    0,  775,  775,  775,  775,  775,
  775,  775,    0,    0,  740,    0,    0,  775,    0,  775,
  775,  775,  775,  775,  775,    0,    0,  775,    0,    0,
    0,  775,  775,    0,  775,  775,  775,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  775,    0,  775,  536,
  775,  775,    0,    0,  775,    0,  775,  775,  775,  775,
  775,  775,  775,  775,  775,  775,  775,  775,    0,  775,
    0,    0,  775,  775,    0,    0,  775,  775,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  775,  775,  775,    0,  775,    0,    0,    0,  775,
  775,    0,    0,  775,    0,    0,    0,    0,  775,  775,
  775,  775,  775,    0,    0,    0,  775,  345,  775,    0,
    0,    0,  345,  345,  775,  775,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  338,  345,    0,    0,    0,  775,
  775,  775,  775,    0,  775,  345,    0,    0,  345,  345,
    0,  775,    0,  345,    0,    0,  345,    0,  345,    0,
  345,  345,  345,  345,    0,    0,    0,    0,  345,    0,
    0,    0,  345,    0,    0,    0,  345,    0,    0,    0,
    0,    0,    0,    0,  345,    0,    0,  345,    0,  345,
  345,    0,    0,    0,    0,  345,    0,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,    0,
    0,    0,    0,  345,    0,    0,    0,    0,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,    0,  345,
  345,    0,    0,  345,  345,  345,  345,  345,    0,    0,
  345,  345,    0,    0,    0,  345,  345,  345,  345,  345,
  345,  345,  345,    0,    0,    0,    0,    0,    0,    0,
  740,    0,    0,    0,  345,  740,  740,  345,    0,  345,
    0,  345,    0,    0,  345,    0,    0,    0,    0,    0,
  345,  375,    0,    0,    0,    0,    0,    0,  740,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  740,    0,
    0,  740,  740,    0,    0,    0,  740,    0,    0,  740,
    0,  740,    0,  740,  740,  740,  740,    0,    0,    0,
    0,  740,    0,    0,    0,  740,    0,    0,    0,  740,
    0,    0,    0,    0,    0,    0,    0,  740,    0,    0,
  740,    0,  740,  740,    0,    0,    0,    0,  740,    0,
  740,  740,  740,  740,  740,  740,  740,  740,  740,  740,
  740,    0,    0,    0,    0,    0,  740,    0,    0,    0,
    0,  740,  740,  740,  740,  740,  740,    0,  740,  740,
  740,    0,  740,  740,    0,    0,  740,  740,  740,  740,
  338,    0,    0,  740,  740,  338,  338,    0,  740,  740,
  740,  740,  740,  740,  740,  740,  345,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  740,  338,    0,
  740,    0,  740,    0,  740,    0,    0,  740,  338,    0,
    0,  338,  338,  740,    0,    0,  338,    0,    0,  338,
    0,  338,    0,  338,  338,  338,  338,    0,    0,    0,
    0,  338,    0,    0,    0,  338,    0,    0,    0,  338,
    0,    0,    0,    0,    0,    0,    0,  338,    0,    0,
  338,    0,  338,  338,    0,    0,    0,    0,  338,    0,
  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
  338,    0,    0,    0,    0,    0,  338,    0,    0,    0,
    0,  338,  338,  338,  338,  338,  338,    0,  338,  338,
  338,    0,  338,  338,    0,    0,  338,  338,  338,  338,
    0,    0,    0,  338,  338,    0,    0,    0,  338,  338,
  338,  338,  338,  338,  338,  338,    0,  375,    0,    0,
    0,    0,  375,  375,    0,    0,    0,  338,    0,    0,
  338,    0,  338,  370,  338,    0,    0,  338,    0,    0,
    0,    0,    0,  338,    0,  375,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  375,    0,    0,  375,  375,
    0,    0,    0,  375,    0,    0,  375,    0,  375,    0,
  375,  375,  375,  375,    0,    0,    0,    0,  375,    0,
    0,    0,  375,    0,    0,    0,  375,    0,    0,    0,
    0,    0,    0,    0,  375,    0,    0,  375,    0,  375,
  375,    0,    0,    0,  915,  375,    0,  375,  375,  375,
  375,  375,  375,  375,  375,  375,  375,  375,    0,    0,
    0,    0,    0,  375,    0,    0,    0,    0,  375,  375,
    0,  375,  375,  375,    0,  375,  375,  375,    0,  375,
  375,    0,  345,  375,  375,  375,  375,    0,  345,    0,
  375,  375,    0,    0,    0,  375,  375,  375,  375,  375,
  375,  375,  375,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  375,    0,    0,  375,    0,  375,
  345,    0,    0,    0,  345,    0,    0,  915,    0,    0,
  375,   49,  915,    0,  915,  915,  915,  915,  915,  915,
  915,  915,  915,  915,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  345,    0,    0,  915,    0,  915,    0,
  915,    0,  915,  915,  915,  345,    0,    0,    0,    0,
  345,    0,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,    0,    0,    0,    0,    0,  345,
    0,    0,    0,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,    0,  345,  345,    0,    0,  345,  345,
  345,  345,  345,    0,    0,  345,  345,  915,    0,    0,
  345,  345,  345,  345,  345,  345,  345,  345,    0,  370,
    0,    0,    0,    0,    0,  370,    0,    0,    0,  345,
    0,    0,  345,    0,  345,    0,  345,    0,    0,  345,
   28,    0,    0,    0,    0,  345,    0,    0,    0,    0,
    0,    0,  345,  345,  345,  345,    0,  370,    0,  345,
  345,  370,    0,  345,  345,  345,  345,  345,  345,  345,
  345,  345,    0,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,    0,    0,    0,    0,    0,
    0,  345,  370,   35,  345,    0,    0,  370,    0,  370,
  370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  370,  370,    0,  370,  370,  370,    0,  370,  370,  370,
    0,  370,  370,    0,    0,  370,  370,  370,  370,    0,
   34,    0,  370,  370,    0,    0,    0,  370,  370,  370,
  370,  370,  370,  370,  370,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  370,    0,   49,  370,
    0,  370,   49,    0,   49,    0,   49,    0,   49,    0,
    0,   49,  370,   49,   49,    0,   49,    0,   49,    0,
   49,    0,   49,   49,   49,   49,    0,    0,   49,   49,
    0,    0,    0,   28,   49,   49,   49,   49,   49,    0,
    0,   49,   49,   49,    0,   49,    0,   49,   49,   49,
   49,   49,   49,   49,   49,    0,   49,   49,   49,   49,
    0,    0,   49,   49,   49,    0,   49,    0,    0,    0,
    0,   49,   49,    0,   49,   49,   33,   49,   49,   49,
    0,    0,    0,   49,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   49,    0,   49,   49,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   28,   28,   49,    5,
    0,   28,    0,    0,    0,   28,    0,   28,    0,    0,
   28,    0,   28,   28,    0,   28,    0,   28,    0,   28,
    0,   28,   28,   28,   28,    0,    0,   28,   28,    0,
    0,    0,    0,   28,    0,   28,   28,   28,    0,   49,
   28,   28,   28,    0,   28,    0,    0,   28,    0,   28,
   28,   28,   28,    0,    0,    0,   28,   28,   28,    0,
   35,   28,   28,   28,   35,    0,  923,    0,    0,    0,
   28,   28,    0,   28,   28,   35,   28,   28,   28,    0,
   35,    0,   28,    0,   35,    0,    0,   35,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   35,
   35,    0,   28,    0,   35,   35,    0,   34,   28,   28,
   35,   34,   35,   35,   35,   35,    0,   28,    0,    0,
   35,    0,   34,    0,   35,    0,   35,   34,    0,   48,
    0,   34,    0,    0,   34,    0,   35,    0,   35,   35,
    0,   35,    0,    0,    0,   35,   34,   34,    0,    0,
    0,   34,   34,    0,    0,    0,    0,   34,   28,   34,
   34,   34,   34,    0,    0,   35,    0,   34,    0,    0,
   28,   34,   35,   34,   28,    0,    7,    0,    0,    0,
    0,    0,    0,   34,    0,   28,   34,    0,   34,    0,
   28,    0,   34,    0,   28,    0,    0,   28,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   28,
   28,    0,   34,   33,   28,   28,    0,   33,   34,   34,
   28,    0,   28,   28,   28,   28,    0,    0,   33,    0,
   28,    0,    0,   33,   28,    0,   28,   33,    0,  924,
   33,    0,    0,    0,    0,    0,   28,    0,    0,   28,
    0,   28,   33,   33,    0,   28,    5,   33,   33,    0,
   48,    0,    0,   33,    0,   33,   33,   33,   33,    0,
    0,   48,    0,   33,    0,   28,   48,   33,    0,   33,
   48,   28,   28,   48,    0,    0,    0,    0,    0,   33,
    0,    0,   33,    0,   33,   48,   48,    0,   33,    0,
   48,   48,    0,    0,    0,    0,   48,    0,   48,   48,
   48,   48,    0,    0,    0,    0,   48,    0,   33,    0,
   48,    0,   48,  923,    0,   33,    0,   48,    0,    0,
    0,    0,   48,    0,    0,   48,    0,   48,   48,    0,
    0,   48,    0,   48,    0,    0,    0,   48,    0,    0,
   48,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   48,   48,   48,    0,    0,    0,   48,   48,    0,
    0,    0,    0,   48,    0,   48,   48,   48,   48,    0,
    0,    0,    0,   48,    0,    0,   48,   48,    0,   48,
   48,    0,    0,    0,    0,    0,    0,    0,    0,   48,
    0,   48,   48,    0,   48,    0,   48,    0,   48,    0,
   48,    0,    0,   48,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   48,   48,    0,   48,    0,
   48,   48,    0,    7,    0,    0,   48,   49,   48,   48,
   48,   48,    0,    0,    0,    0,   48,    0,   49,    0,
   48,    0,   48,   49,    0,    0,    0,   49,    0,    0,
   49,    0,   48,    0,    0,   48,    0,   48,    0,    0,
    0,   48,   49,   49,    0,    0,    0,   49,   49,    0,
    0,    0,    0,   49,    0,   49,   49,   49,   49,    0,
    0,   48,    0,   49,    0,    0,  924,   49,    0,   49,
   48,    0,    0,    0,    0,    0,    0,    0,    0,   49,
    0,   48,   49,    0,   49,    0,   48,    0,   49,    0,
   48,    0,    0,   48,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   48,   48,    0,   49,    0,
   48,   48,    0,    0,    0,    0,   48,    0,   48,   48,
   48,   48,    0,    0,    0,    0,   48,    0,    0,    0,
   48,    0,   48,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   48,    0,   56,   48,    0,   48,    0,    0,
    0,   48,   57,   25,   58,   26,    0,    0,   27,   59,
    0,   60,   61,   28,   62,   63,   64,   29,    0,    0,
    0,   48,    0,   65,    0,   66,   31,   67,   68,   69,
   70,    0,    0,   33,    0,    0,    0,   71,   34,    0,
   72,   73,   35,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   74,    0,   37,    0,   38,   75,    0,    0,
   39,    0,   76,   77,   78,   79,   80,   81,   40,   41,
   82,   83,   42,   84,    0,   85,    0,    0,   86,   87,
    0,  345,   88,   89,    0,    0,    0,  345,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
    0,   93,    0,    0,    0,   94,    0,    0,    0,   95,
    0,    0,    0,    0,   96,   97,   98,   99,  100,    0,
    0,    0,  101,  345,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  345,    0,    0,
    0,    0,    0,  345,    0,  105,  106,  107,  108,    0,
    0,    0,    0,    0,  345,    0,    0,  198,    0,  345,
    0,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,    0,    0,    0,    0,    0,    0,  345,
    0,    0,    0,  345,  345,  345,  345,  345,  345,  345,
  345,  345,    0,  345,  345,    0,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,    0,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,    0,
  514,    0,    0,  345,    0,  345,  514,    0,  345,    0,
    0,    0,    0,    0,  345,    0,    0,    0,    0,  345,
    0,    0,  345,    0,  345,  345,    0,    0,    0,  345,
  345,    0,    0,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  514,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  345,  345,    0,    0,    0,    0,    0,
    0,  345,  345,    0,  345,    0,    0,    0,    0,    0,
  345,    0,    0,  514,    0,    0,    0,    0,  514,    0,
  514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
  514,    0,    0,    0,    0,    0,    0,    0,  345,    0,
    0,  514,  514,  514,  514,  514,  514,  514,  514,  514,
  514,    0,  514,  514,    0,  514,  514,  514,  514,  514,
  514,  514,  514,  514,  514,    0,  514,  514,  514,  514,
  514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
  514,  514,  514,  514,  514,  514,  514,  514,    0,  510,
    0,    0,    0,    0,  514,  510,    0,  345,    0,    0,
    0,    0,    0,  514,    0,    0,    0,    0,    0,  345,
    0,  345,    0,  345,    0,    0,  345,    0,  345,  345,
    0,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  510,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,    0,    0,    0,    0,  345,    0,
  345,  402,    0,  345,    0,    0,    0,    0,    0,  345,
    0,    0,  510,    0,    0,    0,    0,  510,    0,  510,
  510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
    0,    0,    0,    0,    0,    0,    0,  402,    0,    0,
  510,  510,    0,  510,  510,  510,  510,  510,  510,  510,
    0,  510,  510,    0,  510,  510,  510,  510,  510,  510,
  510,  510,  510,  510,    0,  510,  510,  510,  510,  510,
  510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
  510,  510,  510,  510,  510,  510,  510,    0,  518,    0,
    0,    0,    0,  510,  518,    0,  510,    0,    0,    0,
    0,    0,  510,    0,    0,    0,    0,    0,  338,    0,
  402,  402,  402,  402,    0,  402,    0,  402,  402,    0,
  402,  402,  402,  402,  402,    0,  402,  402,  402,  402,
  518,  402,  402,  402,  402,  402,  402,  402,  402,  402,
  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
  402,  402,  402,    0,    0,    0,    0,  338,    0,  402,
  345,    0,  402,    0,    0,    0,    0,    0,  402,    0,
    0,  518,    0,    0,    0,    0,  518,    0,  518,  518,
  518,  518,  518,  518,  518,  518,  518,  518,  518,    0,
    0,    0,    0,    0,    0,    0,  345,    0,    0,    0,
  518,    0,  518,  518,  518,  518,  518,  518,  518,    0,
  518,  518,    0,  518,  518,  518,  518,  518,  518,  518,
  518,  518,  518,    0,  518,  518,  518,  518,  518,  518,
  518,  518,  518,  518,  518,  518,  518,  518,  518,  518,
  518,  518,  518,  518,  518,  518,    0,  345,    0,    0,
    0,    0,  518,  345,    0,  518,    0,    0,    0,    0,
    0,  518,    0,    0,    0,    0,    0,    0,  345,  345,
  345,  345,  345,    0,    0,    0,  345,  345,    0,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,    0,    0,    0,    0,    0,    0,  345,    0,
    0,  345,    0,    0,    0,    0,    0,  345,    0,    0,
  345,    0,    0,    0,    0,  345,    0,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  345,
    0,  345,  345,  345,  345,  345,  345,  345,    0,  345,
  345,    0,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,    0,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,    0,  445,  730,    0,    0,
    0,  345,  445,    0,  345,    0,   25,    0,   26,    0,
  345,   27,    0,    0,    0,    0,   28,    0,    0,    0,
   29,    0,    0,    0,    0,    0,    0,    0,    0,   31,
    0,    0,    0,    0,    0,    0,   33,    0,  445,    0,
    0,   34,    0,    0,    0,   35,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   37,    0,   38,
    0,    0,    0,   39,    0,    0,    0,    0,    0,    0,
    0,   40,   41,    0,    0,   42,    0,    0,  731,  445,
    0,    0,    0,    0,  445,    0,  445,  445,  445,  445,
  445,  445,  445,  445,  445,  445,  445,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  445,    0,
  445,  445,  445,  445,  445,  445,  445,    0,  445,  445,
    0,  445,  445,  445,  445,  445,  445,  445,  445,  445,
  445,    0,  445,  445,  445,  445,  445,  445,  445,  445,
  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,
  445,  445,  445,  445,    0,  405,  865,    0,    0,  732,
  445,  405,    0,  445,    0,   25,    0,   26,    0,  445,
   27,    0,    0,    0,    0,   28,    0,    0,    0,   29,
    0,    0,    0,    0,    0,    0,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,  405,    0,    0,
   34,    0,    0,    0,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,    0,
    0,    0,   39,    0,    0,    0,    0,    0,    0,    0,
   40,   41,    0,    0,   42,    0,    0,  317,  405,    0,
    0,    0,    0,  405,    0,  405,  405,  405,  405,  405,
  405,  405,  405,  405,  405,  405,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  405,    0,  405,
  405,  405,  405,  405,  405,  405,    0,  405,    0,    0,
  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,
    0,  405,  405,  405,  405,  405,  405,  405,  405,  405,
  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,
  405,  405,  405,    0,  547,    0,  487,    0,  349,  405,
  547,    0,  405,    0,   57,   25,    0,   26,  405,    0,
   27,  255,    0,    0,    0,   28,   62,   63,    0,   29,
    0,    0,    0,    0,    0,   65,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,  547,    0,    0,    0,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  256,    0,   42,    0,    0,  547,    0,    0,
    0,    0,  547,    0,  547,  547,  547,  547,  547,  547,
  547,  547,  547,  547,  547,    0,    0,    0,    0,   90,
   91,   92,    0,    0,    0,    0,  547,    0,  547,    0,
  547,   95,  547,  547,  547,    0,  547,  547,    0,  547,
  547,  547,  547,  547,  547,  547,  547,  547,  547,  367,
    0,    0,  547,  547,  547,  547,  547,  547,  547,  547,
  547,  547,  547,  547,  547,  547,  547,  547,  547,  547,
  561,  547,  367,    0,    0,    0,  561,  105,  488,    0,
    0,    0,    0,    0,    0,  367,    0,  547,    0,    0,
  367,    0,    0,  244,    0,  367,    0,  367,  367,  367,
  367,    0,    0,    0,    0,  367,    0,    0,    0,  367,
    0,    0,  561,  367,    0,    0,    0,    0,    0,    0,
    0,  367,    0,    0,  367,    0,  367,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  565,    0,
    0,    0,    0,    0,  565,    0,    0,    0,    0,    0,
  367,    0,    0,  561,    0,    0,    0,    0,  561,    0,
  561,  561,  561,  561,  561,  561,  561,  561,  561,  561,
  561,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  565,    0,  561,    0,  561,    0,  561,    0,  561,  561,
  561,    0,  561,  561,    0,    0,  561,  561,  561,  561,
  561,  561,  561,  561,  561,    0,  367,    0,  561,  561,
  561,  561,  561,  561,  561,  561,    0,    0,    0,    0,
    0,  565,    0,    0,    0,    0,  565,  561,  565,  565,
  565,  565,  565,  565,  565,  565,  565,  565,  565,    0,
    0,    0,  568,  561,    0,    0,    0,    0,  568,    0,
  565,    0,  565,    0,  565,    0,  565,  565,  565,    0,
  565,  565,    0,    0,  565,  565,  565,  565,    0,    0,
    0,  565,  565,    0,    0,    0,  565,  565,  565,  565,
  565,  565,  565,  565,  568,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  565,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  566,  565,    0,    0,    0,    0,  566,    0,    0,    0,
    0,    0,    0,    0,    0,  568,    0,    0,    0,    0,
  568,    0,  568,  568,  568,  568,  568,  568,  568,  568,
  568,  568,  568,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  566,    0,  568,    0,  568,    0,  568,    0,
  568,  568,  568,    0,  568,  568,    0,    0,  568,  568,
  568,  568,    0,    0,    0,  568,  568,  203,    0,    0,
  568,  568,  568,  568,  568,  568,  568,  568,    0,    0,
    0,    0,    0,  566,    0,    0,    0,    0,  566,  568,
  566,  566,  566,  566,  566,  566,  566,  566,  566,  566,
  566,    0,    0,    0,  567,  568,    0,    0,    0,  204,
  567,    0,  566,    0,  566,    0,  566,    0,  566,  566,
  566,    0,  566,  566,    0,    0,  566,  566,  566,  566,
    0,    0,    0,  566,  566,    0,    0,    0,  566,  566,
  566,  566,  566,  566,  566,  566,  567,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  566,    0,  205,
  206,  207,  208,    0,  209,  210,  211,  212,  213,  214,
  215,  216,  571,  566,  217,  218,  219,  220,  221,  222,
  223,  224,    0,    0,    0,    0,    0,  567,    0,    0,
    0,    0,  567,    0,  567,  567,  567,  567,  567,  567,
  567,  567,  567,  567,  567,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  567,    0,  567,    0,
  567,    0,  567,  567,  567,    0,  567,  567,    0,    0,
  567,  567,  567,  567,    0,    0,    0,  567,  567,    0,
  572,    0,  567,  567,  567,  567,  567,  567,  567,  567,
    0,    0,    0,    0,    0,  571,    0,    0,    0,    0,
  571,  567,  571,  571,  571,  571,  571,  571,  571,  571,
  571,  571,  571,    0,    0,    0,    0,  567,    0,    0,
    0,    0,    0,    0,  571,    0,  571,    0,  571,    0,
  571,  571,  571,    0,    0,    0,    0,    0,  571,  571,
  571,  571,    0,    0,    0,  571,  571,    0,  573,    0,
  571,  571,  571,  571,  571,  571,  571,  571,    0,    0,
    0,    0,    0,  572,    0,    0,    0,    0,  572,  571,
  572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
  572,    0,    0,    0,    0,  571,    0,    0,    0,    0,
    0,    0,  572,    0,  572,    0,  572,    0,  572,  572,
  572,    0,    0,    0,    0,    0,  572,  572,  572,  572,
    0,    0,    0,  572,  572,    0,  574,    0,  572,  572,
  572,  572,  572,  572,  572,  572,    0,    0,    0,    0,
    0,  573,    0,    0,    0,    0,  573,  572,  573,  573,
  573,  573,  573,  573,  573,  573,  573,  573,  573,    0,
    0,    0,    0,  572,    0,    0,    0,    0,    0,    0,
  573,    0,  573,    0,  573,    0,  573,  573,  573,    0,
    0,    0,    0,    0,  573,  573,  573,  573,    0,    0,
    0,  573,  573,    0,  575,    0,  573,  573,  573,  573,
  573,  573,  573,  573,    0,    0,    0,    0,    0,  574,
    0,    0,    0,    0,  574,  573,  574,  574,  574,  574,
  574,  574,  574,  574,  574,  574,  574,    0,    0,    0,
    0,  573,    0,    0,    0,    0,    0,    0,  574,    0,
  574,    0,  574,    0,  574,  574,  574,    0,    0,    0,
    0,    0,  574,  574,  574,  574,    0,    0,    0,  574,
  574,    0,  576,    0,    0,    0,  574,  574,  574,  574,
  574,  574,    0,    0,    0,    0,    0,  575,    0,    0,
    0,    0,  575,  574,  575,  575,  575,  575,  575,  575,
  575,  575,  575,  575,  575,    0,    0,    0,    0,  574,
    0,    0,    0,    0,    0,    0,  575,    0,  575,    0,
  575,    0,  575,  575,  575,    0,    0,    0,    0,    0,
  575,  575,  575,  575,    0,    0,    0,  575,  575,    0,
  577,    0,    0,    0,  575,  575,  575,  575,  575,  575,
    0,    0,    0,    0,    0,  576,    0,    0,    0,    0,
  576,  575,  576,  576,  576,  576,  576,  576,  576,  576,
  576,  576,  576,    0,    0,    0,    0,  575,    0,    0,
    0,    0,    0,    0,  576,    0,  576,    0,  576,    0,
  576,  576,  576,    0,    0,    0,    0,    0,  576,  576,
  576,  576,    0,    0,    0,  576,  576,    0,  578,    0,
    0,    0,  576,  576,  576,  576,  576,  576,    0,    0,
    0,    0,    0,  577,    0,    0,    0,    0,  577,  576,
  577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
  577,    0,    0,    0,    0,  576,    0,    0,    0,    0,
    0,    0,  577,    0,  577,    0,  577,    0,  577,  577,
  577,    0,    0,    0,    0,    0,  577,  577,  577,  577,
    0,    0,    0,  577,  577,    0,  579,    0,    0,    0,
  577,  577,  577,  577,  577,  577,    0,    0,    0,    0,
    0,  578,    0,    0,    0,    0,  578,  577,  578,  578,
  578,  578,  578,  578,  578,  578,  578,  578,  578,    0,
    0,    0,    0,  577,    0,    0,    0,    0,    0,    0,
  578,    0,  578,    0,  578,    0,  578,  578,  578,    0,
    0,    0,    0,    0,  578,  578,  578,  578,    0,    0,
    0,  578,  578,    0,  580,    0,    0,    0,  578,  578,
  578,  578,  578,  578,    0,    0,    0,    0,    0,  579,
    0,    0,    0,    0,  579,  578,  579,  579,  579,  579,
  579,  579,  579,  579,  579,  579,  579,    0,    0,    0,
    0,  578,    0,    0,    0,    0,    0,    0,  579,    0,
  579,    0,  579,    0,  579,  579,  579,    0,    0,    0,
    0,    0,    0,    0,  579,  579,    0,    0,    0,  579,
  579,    0,  581,    0,    0,    0,    0,    0,  579,  579,
  579,  579,    0,    0,    0,    0,    0,  580,    0,    0,
    0,    0,  580,  579,  580,  580,  580,  580,  580,  580,
  580,  580,  580,  580,  580,    0,    0,    0,    0,  579,
    0,    0,    0,    0,    0,    0,  580,    0,  580,    0,
  580,    0,  580,  580,  580,    0,    0,    0,    0,    0,
    0,    0,  580,  580,    0,    0,    0,  580,  580,    0,
  582,    0,    0,    0,    0,    0,  580,  580,  580,  580,
    0,    0,    0,    0,    0,  581,    0,    0,    0,    0,
  581,  580,  581,  581,  581,  581,  581,  581,  581,  581,
  581,  581,  581,    0,    0,    0,    0,  580,    0,    0,
    0,    0,    0,    0,  581,    0,  581,    0,  581,    0,
  581,  581,  581,    0,    0,    0,    0,    0,    0,    0,
  581,  581,    0,    0,    0,  581,  581,    0,  583,    0,
    0,    0,    0,    0,  581,  581,  581,  581,    0,    0,
    0,    0,    0,  582,    0,    0,    0,    0,  582,  581,
  582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
  582,    0,    0,    0,    0,  581,    0,    0,    0,    0,
    0,    0,  582,    0,  582,    0,  582,    0,  582,  582,
  582,    0,    0,    0,    0,    0,    0,    0,  582,  582,
    0,    0,    0,  582,  582,    0,  584,    0,    0,    0,
    0,    0,    0,    0,  582,  582,    0,    0,    0,    0,
    0,  583,    0,    0,    0,    0,  583,  582,  583,  583,
  583,  583,  583,  583,  583,  583,  583,  583,  583,    0,
    0,    0,    0,  582,    0,    0,    0,    0,    0,    0,
  583,    0,  583,    0,  583,    0,  583,  583,  583,    0,
    0,    0,    0,    0,    0,    0,  583,  583,    0,    0,
    0,  583,  583,    0,  585,    0,    0,    0,    0,    0,
    0,    0,  583,  583,    0,    0,    0,    0,    0,  584,
    0,    0,    0,    0,  584,  583,  584,  584,  584,  584,
  584,  584,  584,  584,  584,  584,  584,    0,    0,    0,
    0,  583,    0,    0,    0,    0,    0,    0,  584,    0,
  584,    0,  584,    0,  584,  584,  584,    0,    0,    0,
    0,    0,    0,    0,    0,  584,    0,    0,    0,  584,
  584,    0,  586,    0,    0,    0,    0,    0,    0,    0,
  584,  584,    0,    0,    0,    0,    0,  585,    0,    0,
    0,    0,  585,  584,  585,  585,  585,  585,  585,  585,
  585,  585,  585,  585,  585,    0,    0,    0,    0,  584,
    0,    0,    0,    0,    0,    0,  585,    0,  585,    0,
  585,    0,  585,  585,  585,    0,    0,    0,    0,    0,
    0,    0,    0,  585,    0,    0,    0,  585,  585,    0,
  587,    0,    0,    0,    0,    0,    0,    0,  585,  585,
    0,    0,    0,    0,    0,  586,    0,    0,    0,    0,
  586,  585,  586,  586,  586,  586,  586,  586,  586,  586,
  586,  586,  586,    0,    0,    0,    0,  585,    0,    0,
    0,    0,    0,    0,  586,    0,  586,    0,  586,    0,
  586,  586,  586,    0,    0,    0,    0,    0,    0,    0,
    0,  586,    0,    0,    0,    0,  586,    0,  590,    0,
    0,    0,    0,    0,    0,    0,  586,  586,    0,    0,
    0,    0,    0,  587,    0,    0,    0,    0,  587,  586,
  587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
  587,    0,    0,    0,    0,  586,    0,    0,    0,    0,
    0,    0,  587,    0,  587,    0,  587,    0,  587,  587,
  587,    0,    0,    0,  591,    0,    0,    0,    0,  587,
    0,    0,    0,    0,  587,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  587,  587,    0,    0,    0,    0,
    0,  590,    0,    0,    0,    0,  590,  587,  590,  590,
  590,  590,  590,  590,  590,  590,  590,  590,  590,    0,
    0,    0,    0,  587,    0,    0,    0,    0,    0,    0,
  590,    0,  590,    0,  590,    0,  590,  590,  590,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  590,    0,    0,    0,    0,  591,    0,    0,
    0,    0,  591,  590,  591,  591,  591,  591,  591,  591,
  591,  591,  591,  591,  591,  590,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  591,    0,  591,    0,
  591,  590,  591,  591,  591,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   56,    0,  591,    0,
    0,    0,    0,    0,   57,   25,   58,   26,    0,  591,
   27,   59,    0,   60,   61,   28,   62,   63,   64,   29,
    0,  591,    0,    0,    0,   65,    0,   66,   31,   67,
   68,   69,   70,    0,    0,   33,    0,  591,    0,   71,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   74,    0,   37,    0,   38,   75,
    0,    0,   39,    0,   76,   77,   78,   79,   80,   81,
   40,   41,   82,   83,   42,   84,    0,   85,    0,    0,
   86,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,    0,   93,    0,    0,    0,   94,    0,    0,
    0,   95,    0,    0,    0,    0,   96,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  266,    0,    0,    0,  105,  106,  107,
  108,   57,   25,   58,   26,    0,    0,   27,   59,    0,
   60,   61,   28,   62,   63,   64,   29,    0,    0,    0,
    0,    0,   65,    0,   66,   31,   67,   68,   69,   70,
    0,    0,   33,    0,    0,    0,   71,   34,    0,   72,
   73,   35,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   74,    0,   37,    0,   38,   75,    0,    0,   39,
    0,   76,   77,   78,   79,   80,   81,   40,   41,   82,
   83,   42,   84,    0,   85,    0,    0,   86,   87,    0,
    0,   88,   89,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,    0,
   93,    0,    0,    0,   94,    0,    0,    0,   95,    0,
    0,    0,    0,   96,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  539,    0,    0,    0,  105,  106,  107,  108,   57,   25,
   58,   26,    0,    0,   27,   59,    0,   60,   61,   28,
   62,   63,   64,   29,    0,    0,    0,    0,    0,   65,
    0,   66,   31,   67,   68,   69,   70,    0,    0,   33,
    0,    0,    0,   71,   34,    0,   72,   73,   35,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   74,    0,
   37,    0,   38,   75,    0,    0,   39,    0,   76,   77,
   78,   79,   80,   81,   40,   41,   82,   83,   42,   84,
    0,   85,    0,    0,   86,   87,    0,    0,   88,   89,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   90,   91,   92,    0,   93,    0,    0,
    0,   94,    0,    0,    0,   95,    0,    0,    0,    0,
   96,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  920,    0,    0,
    0,  105,  106,  107,  108,  920,  920,  920,  920,    0,
    0,  920,  920,    0,  920,  920,  920,  920,  920,  920,
  920,    0,    0,    0,    0,    0,  920,    0,  920,  920,
  920,  920,  920,  920,    0,    0,  920,    0,    0,    0,
  920,  920,    0,  920,  920,  920,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  920,    0,  920,    0,  920,
  920,    0,    0,  920,    0,  920,  920,  920,  920,  920,
  920,  920,  920,  920,  920,  920,  920,    0,  920,    0,
    0,  920,  920,    0,    0,  920,  920,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  920,  920,  920,    0,  920,    0,    0,    0,  920,    0,
    0,    0,  920,    0,    0,    0,    0,  920,  920,  920,
  920,  920,    0,    0,    0,  920,    0,  920,    0,    0,
    0,    0,    0,  920,  920,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  784,    0,    0,    0,  920,  920,
  920,  920,  784,  784,  784,  784,    0,    0,  784,  784,
    0,  784,  784,  784,  784,  784,  784,  784,    0,    0,
    0,    0,    0,  784,    0,  784,  784,  784,  784,  784,
  784,    0,    0,  784,    0,    0,    0,  784,  784,    0,
  784,  784,  784,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  784,    0,  784,    0,  784,  784,    0,    0,
  784,    0,  784,  784,  784,  784,  784,  784,  784,  784,
  784,  784,  784,  784,    0,  784,    0,    0,  784,  784,
    0,    0,  784,  784,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  784,  784,  784,
    0,  784,    0,    0,    0,  784,    0,    0,    0,  784,
    0,    0,    0,    0,  784,  784,  784,  784,  784,    0,
    0,    0,  784,    0,  784,    0,    0,    0,    0,    0,
  784,  784,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  717,    0,    0,    0,  784,  784,  784,  784,   57,
   25,    0,   26,    0,    0,   27,  255,    0, 1003,    0,
   28,   62,   63,    0,   29,    0,    0,   25,    0,   26,
   65,    0,   27,   31,    0,    0,    0,   28,    0,    0,
   33,   29,    0,    0,    0,   34,    0,   72,   73,   35,
   31,    0,    0,    0,    0,    0,    0,   33,    0,    0,
    0,   37,   34,   38,   75,    0,   35,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  256,   37,   42,
   38,    0,    0,    0,   39,    0,   87,    0,    0,   88,
   89,    0,   40,   41,    0,    0,   42,    0,    0,  317,
    0,    0,    0,    0,   90,   91,   92,    0,   93,    0,
    0,    0,  504,  718,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  717,    0,
    0,    0,  105,  299,  107,  108,   57,   25,    0,   26,
    0,    0,   27,  255,    0, 1122,    0,   28,   62,   63,
  349,   29,    0,    0,   25,    0,   26,   65,    0,   27,
   31,    0,    0,    0,   28,    0,    0,   33,   29,    0,
    0,    0,   34,    0,   72,   73,   35,   31,    0,    0,
    0,    0,    0,    0,   33,    0,    0,    0,   37,   34,
   38,   75,  892,   35,   39,    0,    0,   77,    0,   79,
    0,   81,   40,   41,  256,   37,   42,   38,    0,    0,
    0,   39,    0,   87,    0,    0,   88,   89,    0,   40,
   41,    0,    0,   42,    0,    0,  317,    0,    0,    0,
    0,   90,   91,   92,    0,   93,    0,    0,    0,  504,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,   57,   25,    0,   26,    0,    0,   27,  255,
    0,    0,    0,   28,   62,   63,    0,   29,    0,  105,
  299,  107,  108,   65,    0,    0,   31,    0,    0,    0,
    0,    0,    0,   33,    0,    0,    0,  349,   34,    0,
   72,   73,   35,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   37,    0,   38,   75,    0,    0,
   39,    0,    0,   77,    0,   79,    0,   81,   40,   41,
  256,    0,   42,    0,    0,    0,    0,    0,    0,   87,
    0,    0,   88,   89,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
    0,   93,    0,    0,    0,  704,  961,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  687,    0,  105,  705,  107,  108,    0,
    0,   57,   25,    0,   26,    0,  706,   27,  255,    0,
    0,    0,   28,   62,   63,    0,   29,    0,    0,  186,
    0,  186,   65,    0,  186,   31,    0,    0,    0,  186,
    0,    0,   33,  186,    0,    0,    0,   34,    0,   72,
   73,   35,  186,    0,    0,    0,    0,    0,    0,  186,
    0,    0,    0,   37,  186,   38,   75,    0,  186,   39,
    0,    0,   77,    0,   79,    0,   81,   40,   41,  256,
  186,   42,  186,    0,   85,    0,  186,    0,   87,    0,
    0,   88,   89,    0,  186,  186,    0,    0,  186,    0,
    0,  186,    0,    0,    0,    0,   90,   91,   92,    0,
   93,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,  944,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,   57,   25,    0,
   26,    0,    0,   27,  255,    0,    0,    0,   28,   62,
   63,    0,   29,    0,  105,  299,  107,  108,   65,    0,
    0,   31,    0,    0,    0,    0,    0,    0,   33,    0,
    0,    0,  186,   34,    0,   72,   73,   35,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   37,
    0,   38,   75,    0,    0,   39,    0,    0,   77,    0,
   79,    0,   81,   40,   41,  256,    0,   42,    0,    0,
    0,    0,    0,    0,   87,    0,    0,   88,   89,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,    0,   93,    0,    0,    0,
  704,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  717,    0,
  105,  705,  107,  108,    0,    0,   57,   25,    0,   26,
    0,  706,   27,  255,    0,    0,    0,   28,   62,   63,
    0,   29,    0,    0,  186,    0,  186,   65,    0,  186,
   31,    0,    0,    0,  186,    0,    0,   33,  186,    0,
    0,    0,   34,    0,   72,   73,   35,  186,    0,    0,
    0,    0,    0,    0,  186,    0,    0,    0,   37,  186,
   38,   75,    0,  186,   39,    0,    0,   77,    0,   79,
    0,   81,   40,   41,  256,  186,   42,  186,    0,    0,
    0,  186,    0,   87,    0,    0,   88,   89,    0,  186,
  186,    0,    0,  186,    0,    0,  186,    0,    0,    0,
    0,   90,   91,   92,    0,   93,    0,    0,    0,  504,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,  944,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  880,    0,    0,    0,  105,
  299,  107,  108,   57,   25,    0,   26,    0,    0,   27,
  255,    0,    0,    0,   28,   62,   63,  186,   29,    0,
    0,   25,    0,   26,   65,    0,   27,   31,    0,    0,
    0,   28,    0,    0,   33,   29,    0,    0,    0,   34,
    0,   72,   73,   35,   31,    0,    0,    0,    0,    0,
    0,   33,    0,    0,    0,   37,   34,   38,   75,    0,
   35,   39,    0,    0,   77,    0,   79,    0,   81,   40,
   41,  256,   37,   42,   38,    0,    0,    0,   39,    0,
   87,    0,    0,   88,   89,    0,   40,   41,    0,    0,
   42,    0,    0,  317,    0,    0,    0,    0,   90,   91,
   92,    0,   93,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  616,    0,    0,    0,  105,  299,  107,  108,
  616,  616,    0,  616,    0,    0,  616,  616,    0,    0,
    0,  616,  616,  616,  318,  616,    0,    0,    0,    0,
    0,  616,    0,    0,  616,    0,    0,    0,    0,    0,
    0,  616,    0,    0,    0,    0,  616,    0,  616,  616,
  616,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  616,    0,  616,  616,    0,    0,  616,    0,
    0,  616,    0,  616,    0,  616,  616,  616,  616,    0,
  616,    0,    0,    0,    0,    0,    0,  616,    0,    0,
  616,  616,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  616,  616,  616,    0,  616,
    0,    0,    0,    0,    0,    0,    0,  616,    0,    0,
    0,    0,    0,  616,  616,  616,  616,    0,    0,    0,
  616,    0,  616,    0,    0,    0,    0,    0,  616,  616,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  616,  616,  616,  616,   48,    0,    0,
    0,   48,    0,   48,    0,    0,   48,    0,   48,   48,
    0,   48,    0,   48,    0,   48,    0,   48,   48,   48,
   48,    0,    0,   48,   48,    0,    0,    0,    0,   48,
    0,   48,   48,   48,    0,    0,   48,    0,   48,    0,
   48,    0,    0,   48,    0,   48,   48,   48,   48,    0,
    0,    0,   48,   48,   48,    0,    0,   48,   48,   48,
    0,    0,    0,    0,    0,    0,   48,   48,    0,   48,
   48,    0,   48,   48,   48,    0,    0,    0,   48,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   48,    0,   48,    0,
   48,    0,   48,    0,   81,   48,    0,   48,   48,    0,
   48,    0,   48,   48,   48,    0,   48,   48,   48,   48,
    0,    0,   48,   48,    0,    0,    0,    0,   48,    0,
   48,   48,   48,    0,    0,   48,    0,   48,    0,   48,
    0,    0,   48,    0,   48,   48,   48,   48,    0,    0,
    0,   48,   48,   48,   48,    0,   48,   48,   48,    0,
    0,    0,    0,    0,    0,   48,   48,    0,   48,   48,
    0,   48,   48,   48,    0,    0,    0,   48,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   48,    0,   48,    0,   48,
    0,   48,    0,   82,   48,    0,   48,   48,    0,   48,
    0,   48,   48,   48,    0,   48,   48,   48,   48,    0,
    0,   48,   48,    0,    0,    0,    0,   48,    0,   48,
   48,   48,    0,    0,   48,    0,   48,    0,   48,    0,
    0,   48,    0,   48,   48,   48,   48,    0,    0,    0,
   48,   48,   48,   48,    0,   48,   48,   48,    0,    0,
    0,    0,    0,    0,   48,   48,    0,   48,   48,    0,
   48,   48,   48,    0,    0,    0,   48,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   48,    0,   48,    0,   48,    0,
   48,    0,  104,   48,    0,   48,   48,    0,   48,    0,
   48,   48,   48,    0,   48,   48,   48,   48,    0,    0,
   48,   48,    0,    0,    0,    0,   48,    0,   48,   48,
   48,    0,    0,   48,    0,   48,    0,   48,    0,    0,
   48,    0,   48,   48,   48,   48,    0,    0,    0,   48,
   48,   48,   48,    0,   48,   48,   48,    0,    0,    0,
    0,    0,    0,   48,   48,    0,   48,   48,    0,   48,
   48,   48,    0,    0,    0,   48,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   48,    0,   48,    0,   48,    0,   48,
    0,  105,   48,    0,   48,   48,    0,   48,    0,   48,
   48,   48,    0,   48,   48,   48,   48,    0,    0,   48,
   48,    0,    0,    0,    0,   48,    0,   48,   48,   48,
    0,    0,   48,    0,   48,    0,   48,    0,    0,   48,
    0,   48,   48,   48,   48,    0,    0,    0,   48,   48,
   48,   48,    0,   48,   48,   48,    0,    0,    0,    0,
    0,    0,   48,   48,    0,   48,   48,    0,   48,   48,
   48,    0,    0,    0,   48,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   48,    0,    0,
    0,   48,    0,   48,   48,    0,   48,    0,   48,   48,
  226,   48,    0,   48,    0,   48,    0,   48,   48,   48,
   48,    0,    0,   48,   48,    0,    0,    0,    0,   48,
    0,   48,   48,   48,    0,    0,   48,    0,   48,  345,
   48,    0,    0,   48,    0,   48,   48,   48,   48,    0,
    0,    0,   48,   48,   48,    0,    0,   48,   48,   48,
   48,    0,  345,    0,    0,    0,   48,   48,    0,   48,
   48,  442,   48,   48,   48,  345,    0,    0,   48,    0,
  345,    0,    0,  345,    0,  345,    0,  345,  345,  345,
  345,    0,    0,    0,  443,  345,    0,    0,   48,  345,
    0,    0,    0,  345,  227,    0,    0,  444,    0,  366,
    0,  345,  446,    0,  345,    0,  345,  447,    0,  448,
  449,  450,  451,    0,    0,    0,    0,  452,    0,    0,
    0,  453,  366,    0,    0,  345,    0,    0,    0,  442,
  345,    0,    0,  454,    0,  366,  455,  345,  456,  277,
  366,  345,    0,  243,   48,  366,    0,  366,  366,  366,
  366,    0,  443,    0,  345,  366,    0,    0,    0,  366,
    0,    0,  457,  366,    0,  444,    0,    0,    0,    0,
  446,  366,    0,    0,  366,  447,  366,  448,  449,  450,
  451,    0,    0,    0,    0,  452,  345,    0,    0,  453,
    0,    0,    0, 1277,    0,    0,   57,   25,    0,   26,
  366,  454,   27,  255,  455,    0,  456,   28,   62,   63,
    0,   29,    0,    0,    0,    0,    0,   65, 1291,    0,
   31,    0,    0,    0,    0,    0,    0,   33,    0,    0,
  457,    0,   34,    0,   72,   73,   35,    0,  574,    0,
    0,    0,    0,    0,    0,  575,    0,    0,   37,    0,
   38,   75,    0,    0,   39,    0,  366,   77,    0,   79,
    0,   81,   40,   41,  256,    0,   42,    0,    0,    0,
    0,    0,    0,  576,    0,    0,   88,   89,    0,    0,
    0,    0,    0,    0,    0,    0, 1278,    0,    0,    0,
    0,   90,   91,   92,    0,   93,    0,    0,    0,    0,
    0,    0,    0,   95,  887,    0,  577,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,   57,   25,    0,   26,    0,    0,   27,  255,
    0,    0,    0,   28,   62,   63,    0,   29,    0,  105,
  464,  107,  108,   65,    0,    0,   31,    0,    0,    0,
    0,    0,    0,   33,    0,    0,    0,    0,   34,    0,
   72,   73,   35,    0,  574,    0,    0,    0,    0,    0,
    0,  575,    0,    0,   37,    0,   38,   75,    0,    0,
   39,    0,    0,   77,    0,   79,    0,   81,   40,   41,
  256,    0,   42,    0,    0,    0,    0,    0,    0,  576,
    0,    0,   88,   89,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
    0,   93,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,  577,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,   57,   25,
    0,   26,    0,    0,   27,  255,    0,    0,    0,   28,
   62,   63,    0,   29,    0,  105,  464,  107,  108,   65,
    0,    0,   31,    0,    0,    0,    0,    0,    0,   33,
    0,    0,    0,    0,   34,    0,   72,   73,   35,    0,
  574,    0,    0,    0,    0,    0,    0,  575,    0,    0,
   37,    0,   38,   75,    0,    0,   39,    0,    0,   77,
    0,   79,    0,   81,   40,   41,  256,    0,   42,    0,
    0,    0,    0,    0,    0,  576,    0,    0,   88,   89,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   90,   91,   92,    0,   93,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,   57,   25,    0,   26,    0,    0,
   27,  255,    0,    0,    0,   28,   62,   63,    0,   29,
    0,  105,  464,  107,  108,   65,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  256,    0,   42,    0,    0,   85,    0,    0,
    0,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,    0,   93,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
   57,   25,    0,   26,    0,    0,   27,  255,    0,    0,
    0,   28,   62,   63,    0,   29,    0,  105,  299,  107,
  108,   65,    0,    0,   31,    0,    0,    0,    0,    0,
    0,   33,    0,    0,    0,    0,   34,    0,   72,   73,
   35,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   37,    0,   38,   75,    0,    0,   39,    0,
    0,   77,    0,   79,    0,   81,   40,   41,  256,    0,
   42,    0,    0,    0,    0,    0,    0,   87,    0,    0,
   88,   89,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,    0,   93,
    0,    0,    0,    0,  848,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,   57,   25,    0,   26,
    0,    0,   27,  255,    0,    0,    0,   28,   62,   63,
    0,   29,    0,  105,  299,  107,  108,   65,    0,    0,
   31,    0,    0,    0,    0,    0,    0,   33,    0,    0,
    0,    0,   34,    0,   72,   73,   35,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   37,    0,
   38,   75,    0,    0,   39,    0,    0,   77,    0,   79,
    0,   81,   40,   41,  256,    0,   42,    0,    0,    0,
    0,    0,    0,   87,    0,    0,   88,   89,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   90,   91,   92,    0,   93,    0,    0,    0,  504,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,   57,   25,    0,   26,    0,    0,   27,  255,
    0,    0,    0,   28,   62,   63,    0,   29,    0,  105,
  299,  107,  108,   65,    0,    0,   31,    0,    0,    0,
    0,    0,    0,   33,    0,    0,    0,    0,   34,    0,
   72,   73,   35,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   37,    0,   38,   75,    0,    0,
   39,    0,    0,   77,    0,   79,    0,   81,   40,   41,
  256,    0,   42,    0,    0,    0,    0,    0,    0,   87,
    0,    0,   88,   89,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
    0,   93,    0,    0,    0,  498,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,   57,   25,
    0,   26,    0,    0,   27,  255,    0,    0,    0,   28,
   62,   63,    0,   29,    0,  105,  299,  107,  108,   65,
    0,    0,   31,    0,    0,    0,    0,    0,    0,   33,
    0,    0,    0,    0,   34,    0,   72,   73,   35,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   37,    0,   38,   75,    0,    0,   39,    0,    0,   77,
    0,   79,    0,   81,   40,   41,  256,    0,   42,    0,
    0,    0,    0,    0,    0,   87,    0,    0,   88,   89,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   90,   91,   92,    0,   93,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,   57,   25,    0,   26,    0,    0,
   27,  255,    0,    0,    0,   28,   62,   63,    0,   29,
    0,  105,  299,  107,  108,   65,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  256,    0,   42,    0,    0,    0,    0,    0,
    0,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,    0,   93,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
   57,   25,    0,   26,    0,    0,   27,  255,    0,    0,
    0,   28,   62,   63,    0,   29,    0,  105,  464,  107,
  108,   65,    0,    0,   31,    0,    0,    0,    0,    0,
    0,   33,    0,    0,    0,    0,   34,    0,   72,   73,
   35,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   37,    0,   38,   75,    0,    0,   39,    0,
    0,   77,    0,   79,    0,   81,   40,   41,  256,    0,
   42,    0,    0,    0,    0,    0,    0,   87,    0,    0,
   88,   89,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,    0,   93,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,   78,   78,    0,   78,
    0,    0,   78,   78,    0,    0,    0,   78,   78,   78,
    0,   78,    0,  105,  995,  107,  108,   78,    0,    0,
   78,    0,    0,    0,    0,    0,    0,   78,    0,    0,
    0,    0,   78,    0,   78,   78,   78,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   78,    0,
   78,   78,    0,    0,   78,    0,    0,   78,    0,   78,
    0,   78,   78,   78,   78,    0,   78,    0,    0,    0,
    0,    0,    0,   78,    0,    0,   78,   78,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   78,   78,   78,    0,   78,    0,    0,    0,    0,
    0,    0,    0,   78,    0,    0,    0,    0,    0,   78,
   78,   78,   78,    0,    0,    0,   78,    0,   78,    0,
    0,    0,    0,    0,   78,   78,    0,    0,    0,    0,
    0,    0,  150,  150,    0,  150,    0,    0,  150,  150,
    0,    0,    0,  150,  150,  150,    0,  150,    0,   78,
   78,   78,   78,  150,    0,    0,  150,    0,    0,    0,
    0,    0,    0,  150,    0,    0,    0,    0,  150,    0,
  150,  150,  150,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  150,    0,  150,  150,    0,    0,
  150,    0,    0,  150,    0,  150,    0,  150,  150,  150,
  150,    0,  150,    0,    0,    0,    0,    0,    0,  150,
    0,    0,  150,  150,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  150,  150,  150,
    0,  150,    0,    0,    0,    0,    0,    0,    0,  150,
    0,    0,    0,    0,    0,  150,  150,  150,  150,    0,
    0,    0,  150,    0,  150,    0,    0,    0,    0,    0,
  150,  150,    0,    0,    0,    0,    0,    0,   57,   25,
    0,   26,    0,    0,   27,  255,    0,    0,    0,   28,
   62,   63,    0,   29,    0,  150,  150,  150,  150,   65,
    0,    0,   31,    0,    0,    0,    0,    0,    0,   33,
    0,   28,    0,    0,   34,    0,   72,   73,   35,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   37,    0,   38,   75,   28,    0,   39,    0,    0,   77,
    0,   79,    0,   81,   40,   41,  256,   28,   42,    0,
    0,    0,   28,    0,    0,    0,    0,   28,    0,   28,
   28,   28,   28,    0,    0,   28,    0,   28,    0,    0,
    0,   28,    0,   90,   91,   92,    0,   93,    0,    0,
    0,    0,    0,   28,    0,   95,   28,    0,   28,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,   57,   25,    0,   26,  103,  104,   27,  255,
    0,    0,   28,   28,   62,   63,    0,   29,   28,   28,
    0,    0,    0,   65,    0,    0,   31,    0,    0,    0,
   48,  105,  257,   33,  108,    0,    0,    0,   34,    0,
   72,   73,   35,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   48,   37,    0,   38,   75,    0,    0,
   39,    0,    0,   77,    0,   79,   48,   81,   40,   41,
  256,   48,   42,    0,    0,    0,   48,    0,   48,   48,
   48,   48,    0,    0,   48,    0,   48,    0,    0,    0,
   48,    0,    0,    0,    0,    0,    0,   90,   91,   92,
    0,   93,   48,    0,    0,   48,    0,   48,    0,   95,
  644,    0,  644,    0,  644,   97,    0,  644,  100,  644,
  644,    0,  644,    0,  644,    0,  644,    0,  644,  644,
  644,   48,    0,    0,  644,  644,    0,  310,    0,    0,
  644,    0,  644,  644,    0,    0,    0,  644,    0,    0,
    0,  644,    0,    0,    0,  105,  257,    0,  108,    0,
    0,    0,  644,  644,    0,  644,    0,    0,    0,  644,
  644,    0,    0,    0,    0,    0,    0,  644,  644,   57,
   25,  644,   26,    0,  644,   27,  255,    0,    0,  644,
   28,   62,   63,    0,   29,    0,    0,    0,    0,    0,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,  644,  644,    0,    0,   34,    0,   72,   73,   35,
    0,    0,    0,    0,  644,    0,    0,    0,    0,    0,
    0,   37,    0,   38,   75,    0,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  256,    0,   42,
    0,    0,   85,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  644,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  643,    0,  643,
    0,    0,  643,    0,  643,  643,   95,  643,    0,  643,
    0,  643,    0,  643,  643,  643,    0,    0,    0,  643,
  643,    0,    0,    0,    0,  643,    0,  643,  643,    0,
    0,    0,  643,    0,    0,    0,  643,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  643,    0,
  643,    0,  105,  257,  643,  643,    0,    0,    0,    0,
    0,    0,  643,  643,    0,  643,  643,  643,    0,  643,
  643,    0,  643,  643,  643,  643,    0,  643,    0,  643,
    0,  643,  643,  643,    0,    0,    0,  643,  643,    0,
    0,    0,    0,  643,    0,  643,  643,    0,    0,    0,
  643,    0,    0,    0,  643,    0,    0,    0,    0,  643,
    0,    0,    0,    0,    0,    0,  643,    0,  643,    0,
    0,    0,  643,  643,    0,    0,    0,    0,    0,    0,
  643,  643,    0,    0,  643,    0,    0,  643,    0,   25,
    0,   26,  643,    0,   27,    0,    0, 1246,    0,   28,
  643,  663,    0,   29,    0,  664, 1247, 1248,    0,    0,
    0, 1249,   31,    0,    0,    0,    0, 1250,    0,   33,
    0,   25,    0,   26,   34,    0,   27,    0,   35, 1246,
    0,   28,    0,  663,    0,   29,    0,  664, 1247, 1248,
   37,    0,   38, 1249,   31,    0,   39,    0,    0, 1250,
    0,   33,    0,    0,   40,   41,   34,    0,   42,    0,
   35, 1251,    0,    0,    0,   48, 1252,   48,  643,    0,
   48,    0,   37,    0,   38,   48,    0,    0,   39,   48,
    0,    0,    0,    0,    0,    0,   40,   41,   48,    0,
   42,    0,    0, 1251,    0,   48,    0,   48, 1252,   48,
   48, 1253,   48,    0,   48,    0,   48,   48,   48,    0,
    0,   48,    0,   48,    0,    0,   48,    0,   48,    0,
   48,    0,   48,    0,    0,   48,    0,   48,    0,    0,
   48,   48,   48,    0,   48,    0,   48,   48,   48,    0,
   48,   48, 1254,   48,    0,   48,   48,    0,   48,    0,
   48,   48,    0,    0,   48,   48,    0,   48,    0,    0,
    0,    0,   48,   48,   48,    0,   48,    0,    0,   48,
    0,   48,  167,   25, 1254,   26,   48,    0,   27,    0,
   48,    0,   48,   28,   48,    0,    0,   29,    0,   48,
    0,    0,   48,    0,   48,    0,   31,    0,   48,    0,
    0,   48,  167,   33,    0,    0,   48,   48,   34,    0,
   48,    0,   35,   48,  555,    0,    0,    0,   48,    0,
    0,  556,    0,    0,   37,    0,   38,    0,    0,    0,
   39,    0,    0,  557,    0,    0,    0,    0,   40,   41,
    0,    0,   42,    0,   25,  558,   26,    0,    0,   27,
   48, 1173,    0,    0,   28,    0,    0,    0,   29,    0,
    0,    0,    0,    0,    0,    0,    0,   31,   25,    0,
   26,    0,    0,   27,   33,    0,    0,    0,   28,   34,
    0, 1174,   29,   35,    0,    0,   30,    0,    0,    0,
    0,   31,    0,    0,   48,   37,   32,   38,   33,    0,
    0,   39, 1175,   34,    0,    0,    0,   35,   36,   40,
   41,    0,    0,   42,    0,    0,  317,    0,   25,   37,
   26,   38,    0,   27,    0,   39,  559,    0,   28,    0,
    0,    0,   29,   40,   41,    0,    0,   42,    0,    0,
    0,   31,   25,    0,   26,    0,    0,   27,   33,    0,
    0,    0,   28,   34,    0,    0,   29,   35,    0,    0,
    0,    0,    0,    0,    0,   31,    0,    0,    0,   37,
    0,   38,   33,    0,    0,   39,    0,   34,    0,    0,
    0,   35,    0,   40,   41,    0,    0,   42,    0,    0,
  317,    0,    0,   37,    0,   38,   25,  349,   26,   39,
    0,   27,    0,    0,    0,    0,   28,   40,   41,    0,
   29,   42,    0,   25,  317,   26,    0,    0,   27,   31,
    0,   43,    0,   28,    0,    0,   33,   29,    0,    0,
    0,   34,    0,    0,    0,   35,   31,    0,    0,    0,
    0,    0,    0,   33,    0,    0,    0,   37,   34,   38,
    0,    0,   35,   39,    0,    0,    0,    0,    0,    0,
    0,   40,   41,    0,   37,   42,   38,   25,  506,   26,
   39,  324,   27,    0,    0,    0,    0,   28,   40,   41,
    0,   29,   42,    0,    0,  317,    0,    0,    0,    0,
   31,   25,    0,   26,    0,  349,   27,   33,    0,    0,
    0,   28,   34,    0,    0,   29,   35,    0,    0,    0,
    0,    0,    0,    0,   31,    0,    0,    0,   37,    0,
   38,   33,    0,    0,   39,    0,   34,    0,    0,    0,
   35,    0,   40,   41,    0,    0,   42,    0,    0,  317,
    0,   25,   37,   26,   38,    0,   27,    0,   39,  349,
    0,   28,    0,    0,    0,   29,   40,   41,    0,    0,
   42,    0,    0,  558,   31,  497,  622,  497,    0,    0,
  497,   33,    0,    0,    0,  497,   34,    0,    0,  497,
   35,    0,    0,    0,    0,    0,    0,    0,  497,    0,
    0,    0,   37,    0,   38,  497,    0,    0,   39,    0,
  497,    0,    0,    0,  497,    0,   40,   41,    0,    0,
   42,    0,    0,  731,    0,    0,  497,    0,  497,  187,
  624,  187,  497,    0,  187,    0,    0,    0,    0,  187,
  497,  497,    0,  187,  497,    0,  186,  497,  186,    0,
    0,  186,  187,    0,  349,    0,  186,    0,    0,  187,
  186,    0,    0,    0,  187,    0,    0,    0,  187,  186,
    0,    0,    0,    0,    0,    0,  186,    0,    0,    0,
  187,  186,  187,    0,    0,  186,  187,    0,    0,    0,
    0,    0,    0,    0,  187,  187,    0,  186,  187,  186,
  196,  187,  196,  186,  349,  196,    0,    0,    0,    0,
  196,  186,  186,    0,  196,  186,    0,    0,  186,    0,
    0,    0,    0,  196,    0,    0,    0,    0,  497,    0,
  196,    0,    0,    0,    0,  196,    0,    0,   35,  196,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   35,
    0,  196,    0,  196,   35,    0,    0,  196,   35,    0,
    0,   35,    0,    0,    0,  196,  196,    0,    0,  196,
    0,    0,  196,   35,   35,    0,    0,    0,   35,   35,
    0,    0,  187,    0,   35,    0,   35,   35,   35,   35,
    0,    0,    0,    0,   35,    0,    0,    0,   35,  186,
   35,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   35,    0,   35,   35,   33,   35,    0,    0,    0,   35,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   33,    0,    0,    0,   33,    0,    0,   33,    0,   35,
    0,    0,    0,    0,    0,   35,   35,    0,    0,   33,
   33,    0,    0,  196,   33,   33,   28,    0,   28,    0,
   33,    0,   33,   33,   33,   33,    0,    0,    0,    0,
   33,    0,    0,    0,   33,    0,   33,    0,    0,   28,
    0,    0,    0,    0,    0,    0,   33,    0,    0,   33,
    0,   33,   28,    0,    0,   33,    0,   28,    0,    0,
    0,    0,   28,    0,   28,   28,   28,   28,    0,    0,
    0,    0,   28,    0,    0,   33,   28,    0,    0,   48,
    0,   33,   33,    0,    0,    0,    0,    0,   28,    0,
   48,   28,    0,   28,    0,   48,    0,    0,    0,   48,
    0,    0,   48,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   48,   48,    0,   28,    0,   48,
   48,    0,   48,   28,   28,   48,    0,   48,   48,   48,
   48,    0,    0,   48,    0,   48,    0,    0,   48,   48,
    0,   48,   48,    0,    0,   48,    0,    0,    0,    0,
    0,   48,    0,    0,   48,    0,   48,   48,   48,    0,
   48,    0,   48,   48,   48,    0,    0,    0,   48,    0,
   48,   48,   48,   48,    0,    0,    0,    0,   48,    0,
   48,    0,   48,    0,   48,    0,   37,   48,    0,    0,
    0,    0,    0,    0,   48,    0,    0,   48,    0,   48,
   48,    0,   48,   48,    0,   48,    0,    0,    0,    0,
   48,    0,   48,   48,   48,   48,    0,    0,    0,    0,
   48,    0,    0,   48,   48,   48,    0,    0,    0,   38,
    0,    0,    0,    0,    0,    0,   48,    0,   48,   48,
   48,   48,   48,   48,    0,    0,    0,    0,   48,    0,
   48,   48,   48,   48,    0,    0,    0,    0,   48,    0,
    0,    0,   48,   48,    0,   48,    0,   48,   48,    0,
    0,  208,    0,    0,   48,    0,   48,   48,   48,   48,
    0,   48,    0,    0,    0,    0,   48,    0,   48,   48,
   48,   48,    0,    0,    0,    0,   48,    0,    0,    0,
   48,   48,    0,   48,    0,   48,   48,    0,   48,  210,
   48,    0,   48,    0,   48,   48,    0,   48,    0,   48,
    0,    0,    0,    0,   48,    0,   48,   48,   48,   48,
    0,   48,    0,    0,   48,    0,    0,    0,   48,    0,
    0,   48,    0,    0,   48,    0,    0,  311,  442,   48,
   48,    0,    0,   48,   48,   48,   48,   48,   48,   48,
    0,    0,   48,    0,   48,    0,    0,    0,   48,    0,
    0,  443,    0,    0,    0,    0,    0,    0,  442,   48,
   48,   48,   48,   48,  444,   48,    0,    0,  445,  446,
    0,    0,    0,    0,  447,    0,  448,  449,  450,  451,
    0,  443,    0,    0,  452,    0,    0,    0,  453,   48,
    0,    0,    0,    0,  444,    0,    0,    0,    0,  446,
  454,    0,    0,  455,  447,  456,  448,  449,  450,  451,
    0,    0,    0,    0,  452,    0,    0,    0,  453,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  457,
  454,    0,    0,  455,    0,  456,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  457,
  };
  protected static readonly short [] yyCheck = {            17,
   17,    4,   17,   17,  298,  297,    6,  502,   18,   52,
  504,  190,   20,   88,   89,  289,  459,  234,  189,  249,
   60,  541,   85,  158,  330,  326,  296,   60,  478,  316,
  294,  551,  892,  108, 1060,  348,  722,  561,  697,  698,
   78,   17,    0,   17,   59,  236,  348,  294,  268,  112,
  106,  114,  322,  112,   60,  114,   74,  256,  256,  256,
   78, 1096, 1097,  256,  268,   80,  256,   82,  256,  256,
   17,  256,  372,  256,   17,  256,  256,   95,   48,  335,
  268,  740,  256,  742,  368,  368, 1180,   93,  294,  368,
  343,   97,   98,   99,  100,  101,  102,  103,  104,  256,
  256,  282, 1196,  256,  256,  376,   17, 1142,  268,  256,
  256,  374, 1209,   60,  256,  256,  276,   64,  642,  264,
  370,  371,   17, 1055,  374,  368,  201,  202,  381,  429,
  360,   17,  402,  314,  257,   17,   17,   17,  391,  418,
  158,  158, 1239,  158,  158,  429,  429,  190,  368,  339,
   17,  358,  339,  416,  344,  256,  346,  344,  429,  346,
   17,  414,  352,  353,  325,  352,  353,    6,  367,  294,
  367,  418,  369,  429,  371,  428,  256,  376,   17,  257,
  325,  306,  158,  381,  158,  391,  429,  262,  381,  374,
   62,  234,  375,  339,   66,   67,   68,  498,   70,   71,
    0,  257,  422,   75,   76,  699,  423,  256,  414,  501,
   82,  158,   84,  288,   86,  158,  518,  358,  422,   91,
   92,   60,  369,  420,  294,   64,  423,  335,  370,  304,
  230,  249,  374,  424,  422,  541,  254,  418,  418,  429,
  341,  113,  429,  299,  418,  551,  286,  158,  325,   88,
   89,    0,  315,  286,  294,  225,  319,  418,  418,  561,
  323,  418,  418,  158,  323,  418,  418,  294,  369,  108,
  345,  289,  158, 1367,  292,  293,  158,  158,  158,  312,
  286,  256,  263,  424,  425,  426,  427,  305,  294,  369,
  341,  158,  310,  418,  312,  351,  311,  956,  316,  257,
 1394,  158,  256,  341,  379,  380,  294,  831,  994,  327,
  328,  418, 1406,  330, 1408,  256,  330,  414,  369,  158,
  369,  391,  256,  341,  349,  350,  305,  368,  256,  269,
  643,  428,  407,  408,  315, 1361,  372,   20,  374,  286,
  642,  418,  360,  361,  414,  305,  286,  365,  366,  367,
  368,  369,  370,  371,  372,  373,  374,  375,  364,  262,
 1141,  663,  201,  202,  391,  312,  871,  263,  862, 1301,
  376,  377,  378,  429,  368,  381,  382,  277, 1159,  397,
  423,  281,  343,  330,  256,  368,  258,  414,  429, 1249,
  433,  841, 1427,  429,  369,  298, 1328, 1329,  685, 1331,
  349,  350,  256,  391,  429,   88,   89,  463,  464, 1444,
 1342,  339, 1071, 1345, 1346,  306,  370,  425,  372,  315,
  374,  372,  313,  262,  296,  108,  414,  368, 1360, 1210,
  391,  439,  488,  374,  368,  429,  308,  701,  369,  367,
  374,  671,  342, 1102, 1103,  478,  429,  286,  372,  288,
 1109,  764,  371,  414,  948, 1396, 1397,  257,  473,  298,
  430,  431,  764,  372,  418,  304,  436,  428,  372,  974,
  374,  976,  272,  312,  357,  378,  379,  277,  429, 1260,
  429,  281,  500, 1264,  502,  339,  504,  349,  350,  376,
  367,  330,  376,  949,  371,  371,  296,  373,  369,  514,
  515, 1164,  373,  386,  272,  429,  345,  256,  526,  348,
  518, 1452,  568,  367,  570,  533,  572,  830,  201,  202,
  429,  977,  850,  323,  541,  429,  343,  541,  296,  831,
  371,  478,  373,  861,  551,  550,  828,  551, 1164,  256,
  379,  380,  342,  420, 1207,  429, 1209,  256,  343,  272,
  371,  781,  423,  840,  855,  323,  574,  575,  375,  266,
  566,  272, 1163, 1164,  381, 1021,  277,  429,  407,  408,
  281, 1164, 1022,  296,  391,  710, 1239,  272,  634,  262,
  375, 1207, 1183, 1209,  368,  296, 1106,  391,   21,  859,
  339,  256,  256,  367,  541,  369,  391,  414,  892,  420,
  323,  296,  474,  621,  551,  288, 1207,  314, 1209,  627,
  414,  428,  323, 1239, 1207,  298, 1209,  369,  367,  414,
   53,  304,  371,  376,  373,  374,  375,  376,  323,  372,
  339,  342,  381,  428,  418,  344,  343,  346, 1239,  478,
  305,  305,  514,  352,  353, 1164, 1239,  374, 1164,  705,
  367,  726,  369,  671,  371,  372,  369,  374,  376,  376,
  414,  701,  345,  367,  664,  348,  418,  685,  375,  371,
  733,  391,  747,  965,  428,  418,  694,  418,  371,  518,
  373,  699,  394,  395,  391,  760,  704,  917, 1207,  416,
 1209, 1207, 1164, 1209,  414,  701,  379,  380, 1164,  392,
  393,  418,  541,  420,  339,  418,  423,  414,  428,  344,
 1164,  346,  551,  728,  349,  350,  256,  352,  353,  412,
 1239,  428,  561, 1239,  407,  408,  744,  420,  746,  269,
  423,  357,  368,  339,  418, 1207,  357, 1209,  374,  374,
  758, 1207,  425, 1209,  428,  381,  286,  373,  369,  381,
  697,  698,  373, 1207, 1028, 1209,  439,  832,  776,  391,
  386,  367,  805,  781,  782,  386,  784, 1239, 1060, 1075,
  376,  418,  357, 1239,  256,  357,  381,  795,  796,  398,
  399,  428,  414,  357,  391, 1239,  391,  369,  373, 1063,
  372,  373,  374,  740,  429,  742,  428,  418,  370,  373,
 1106,  386,  374,  642,  386,  813,  339,  414,  826,  414,
  828,  344,  386,  346,  421,  871,  349,  350,  818,  352,
  353,  992,  840, 1053,  663,  843, 1100,  372,  367,  374,
 1136,  376,  850,  306,  357,  518,  418,  376, 1281,  401,
  313,  374,  860,  364,  862,  367,  369,  922,  386,  372,
  373,  413,  325,  373,  376, 1349,  376,  339,  697,  698,
  381,  382,  344,  386,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  367, 1268,  373,  561,  294,
  376,  899, 1274,  901,  376,  903,  368,  726,  370, 1281,
  372,  306,  374,  375,  376,  367,  429, 1171, 1115,  917,
  339,  740,  414,  742,  376,  344,  914,  346,  747,  421,
  349,  350, 1091,  352,  353,  369, 1218, 1411,  974,  369,
  367,  760,  372, 1225,  924,  764,  926,  381,  928,  376,
  948,  339,  372,  306,  374,  308,  344,  256,  346,  995,
  313,  349,  350,  379,  352,  353,  265,  429,  267,  367,
  384,  270,  325, 1447,  367, 1249,  275,  389,  376,  642,
  279,  370,  372,  376,  979,  374,  376,  370,  986,  288,
  988,  374,  990, 1468, 1469,  374,  295,  376,  385,  370,
  663,  300,  381,  374,  370,  304,  382,  383,  374,  400,
  429,  370,  831,  832,  372,  374,  374,  316, 1001,  318,
  396,  397,  372,  322,  374,  374,  376,  376,  390,  956,
 1028,  330,  331,  256,  370,  334,  372,  374,  337,  376,
  418,  429, 1040, 1041,  373,  370,  339,  372,    0,  374,
 1048,  344,  370,  346,  372, 1053,  349,  350,  369,  352,
  353,  376, 1060,  726, 1054, 1063,  418,  370, 1091,  372,
 1093,  374,  339,  892,  386,  387,  388,  344, 1075,  346,
  370, 1075,  372, 1081,  747,  352,  353,  414,  415, 1361,
 1088,  370, 1115,  372,  371,  370,  371,  760,  373,  374,
  375,  764, 1100,  922,  367,  256,  415, 1162,  371, 1106,
  373,  374, 1106,  376, 1112, 1113,  339,  418,  381,  418,
  256,  344, 1145,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  354,  355,  429,  956,  418, 1136,
 1163, 1164, 1136,  340, 1071,  368,  418,  370, 1075,  372,
  813,  374,  375,  376,  376, 1153,  385,  386,  387,  388,
 1183,  372, 1217,  374,  372,  418,  374,  390,  831,  832,
  370, 1169,  372, 1171,  376, 1102, 1103,  400,  401, 1106,
  373,  370, 1109,  372, 1207,  367, 1209,  374,  339,  376,
  413, 1246, 1247,  344,  418,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  429,  376,  374, 1136,
  376,  374,  374,  376,  376, 1270, 1239,  368, 1273,  370,
  376,  372,  376,  374,  375,  376, 1221,  364,  365,  892,
  372,   97,   98,   99,  100,  101,  102,  103,  104,  390,
  414,  368, 1278,  418,  371,  418,  373,  374,  418,  400,
  401,  914, 1071,  418,  367, 1291, 1075,  369,  371,  922,
  373,  374,  413,  376,  372,  392,  393,  372,  381,  354,
  355,  418, 1308,  376, 1310, 1094,  372,  373,  429,  349,
  350,  364,  365, 1102, 1103,  412,  372, 1106, 1058, 1059,
 1109, 1286,  372,  420,  367,  418,  423,  368,  371,  374,
  373,  374,  415,  376,  372,  257,  383,  384,  381,  261,
  389,  390,  372,  372,  372,  372, 1339, 1136,  294,  294,
  272,  374,  372,  372,  376,  277,  418, 1146,  374,  281,
  372,  371,  284, 1356,  256,  374,  418,    0,  375,  356,
  418,  372,  415, 1162,  296,  297, 1369, 1370,  381,  301,
  302, 1349, 1347,  374,  374,  307,  375,  309,  310,  311,
  312,  373,  418, 1361,  372,  317,  381,  374,  374,  321,
  374,  323,  374, 1396, 1397,  418,  376,  294,  429,  423,
 1378,  333,  372,  335,  336,  374,  338,  367,  418,  372,
  342,  373,  418,  343,  294,  374,  294,  374, 1217, 1218,
  418,  370,  418,  371,  418,  367, 1225,  256,  375,  256,
  362,  381,  256, 1411,  374,  256,  368,  369,  372,  372,
  368,  280,  381,  371,  256,  373,  374, 1246, 1247, 1452,
 1249, 1094,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  367,  372,  392,  393,  418,  368,  376, 1447,
  370, 1270,  418,  256, 1273,  418,  371,  418, 1453, 1454,
  326,  418,  376,  374,  412, 1460, 1461,  374,  376,  370,
 1468, 1469,  420,  376,  421,  423,  372,  372,  423,  381,
  347,  351,  367, 1146,  381,  256,  256,  381,  372,  368,
  372,  347,  370,  374,  370,  375,  367,  372,  364, 1162,
  372,  375,  370,  348,  368,    0,  418,  376,  418,  374,
  376,  377,  378,  374,  339,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,  392,  393,  394,  395,
  396,  348,  368,  375,  367,  381,  339,  367,  367,  376,
  368,  344,  356,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356, 1217, 1218,  371,  368,  374,  368,
  418,  368, 1225,  337,  372,  368,  305,  370,  418,  372,
  418,  374,  375,  376,  371,  418,  371,  369,  418,  367,
  418,  371,  376, 1246, 1247,  371, 1249,  390,  371,  371,
  381,  371, 1255,  256,  373,  367,  371,  381,  261,  262,
  369,  374,  256,  370,  372, 1268,  372, 1270,  373,  373,
 1273, 1274,  374,  374,  374,  372,  418,  376, 1281,  372,
  418,  284,  376,  372,  376,  418,  429,  372,  376,  418,
  372,  294,  498,  367,  297,  298,  372,  381,  368,  302,
  381,  370,  305,  368,  307,  315,  309,  310,  311,  312,
  263,  371,  371,  368,  317,  372,  372,    0,  321,    0,
  367,  372,  325,  376,  376,  368,    0,  418,  376,  368,
  333,  372,    0,  336,  372,  338,  339,  370,  418,  367,
  376,  344,  368,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  368,  372,  376,  370,  367,  362,
  566,  376,  368,  368,  367,  368,  368,  370,  371,  372,
  373,  374,  375,  376,  418,  378,  379,  376,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  418,  392,
  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,  372,  376,  416,  372,  418,  372,  420,  367,  376,
  423,  256,  257,  368,  368,  367,  429,  373,  376,  264,
  265,  266,  267,  268,  315,  270,  271,  376,  273,  274,
  275,  276,  277,  278,  279,  280,  376,  376,  376,  376,
  285,  376,  287,  288,  289,  290,  291,  292,  376,  263,
  295,    0,   51,   12,  299,  300,   52,  302,  303,  304,
    5, 1053,  914, 1053,  813, 1183, 1239, 1401, 1364,  314,
 1417,  316, 1352,  318,  319, 1381, 1347,  322,  663,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,  834,  337,  834, 1255,  340,  341,  834, 1461,  344,
  345,  677,  830, 1268, 1287, 1195, 1207, 1455, 1374, 1370,
 1369, 1454, 1145, 1310,  359,  360,  361,  805,  363, 1255,
  518,  855,  367,  368,  360, 1146,  371,  704,  575,   72,
  701,  376,  377,  378,  379,  380,  776,   93,  781,  384,
  671,  386,  391,  965,  392,  395,  393,  392,  393, 1129,
  394,  764, 1136,  396, 1217,  979,  158, 1075, 1041,  950,
  935,  897, 1031, 1033,  415, 1022,  516,  875, 1213, 1113,
  811,  810,  417,  418,  419,  420,   -1,  422,  256,  257,
   -1,   -1,   -1,   -1,  429,   -1,  264,  265,  266,  267,
  268,   -1,  270,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,   -1,   -1,    0,   -1,   -1,  285,   -1,  287,
  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,
   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,  855,
  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,   -1,  337,
   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,  367,
  368,   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,
  378,  379,  380,   -1,   -1,   -1,  384,  256,  386,   -1,
   -1,   -1,  261,  262,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,    0,  284,   -1,   -1,   -1,  417,
  418,  419,  420,   -1,  422,  294,   -1,   -1,  297,  298,
   -1,  429,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,   -1,
   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,  367,  368,
  369,  370,  371,  372,  373,  374,  375,  376,   -1,  378,
  379,   -1,   -1,  382,  383,  384,  385,  386,   -1,   -1,
  389,  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  413,  261,  262,  416,   -1,  418,
   -1,  420,   -1,   -1,  423,   -1,   -1,   -1,   -1,   -1,
  429,    0,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  294,   -1,
   -1,  297,  298,   -1,   -1,   -1,  302,   -1,   -1,  305,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,
   -1,  367,  368,  369,  370,  371,  372,   -1,  374,  375,
  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,
  256,   -1,   -1,  389,  390,  261,  262,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,    0,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,  284,   -1,
  416,   -1,  418,   -1,  420,   -1,   -1,  423,  294,   -1,
   -1,  297,  298,  429,   -1,   -1,  302,   -1,   -1,  305,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,
   -1,  367,  368,  369,  370,  371,  372,   -1,  374,  375,
  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,   -1,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,   -1,  256,   -1,   -1,
   -1,   -1,  261,  262,   -1,   -1,   -1,  413,   -1,   -1,
  416,   -1,  418,    0,  420,   -1,   -1,  423,   -1,   -1,
   -1,   -1,   -1,  429,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  294,   -1,   -1,  297,  298,
   -1,   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  339,   -1,   -1,   -1,  256,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,  367,  368,
   -1,  370,  371,  372,   -1,  374,  375,  376,   -1,  378,
  379,   -1,  256,  382,  383,  384,  385,   -1,  262,   -1,
  389,  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  413,   -1,   -1,  416,   -1,  418,
  294,   -1,   -1,   -1,  298,   -1,   -1,  339,   -1,   -1,
  429,    0,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  262,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,   -1,   -1,   -1,   -1,   -1,  298,
   -1,   -1,   -1,  367,  368,  369,  370,  371,  372,  373,
  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,
  384,  385,  386,   -1,   -1,  389,  390,  429,   -1,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,   -1,  256,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,  413,
   -1,   -1,  416,   -1,  418,   -1,  420,   -1,   -1,  423,
    0,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  371,  372,  373,  374,   -1,  294,   -1,  378,
  379,  298,   -1,  382,  383,  384,  385,  386,  387,  388,
  389,  390,   -1,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,   -1,   -1,   -1,   -1,
   -1,  420,  339,    0,  423,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  367,  368,   -1,  370,  371,  372,   -1,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,   -1,
    0,   -1,  389,  390,   -1,   -1,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,  257,  416,
   -1,  418,  261,   -1,  263,   -1,  265,   -1,  267,   -1,
   -1,  270,  429,  272,  273,   -1,  275,   -1,  277,   -1,
  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,
   -1,   -1,   -1,    0,  293,  294,  295,  296,  297,   -1,
   -1,  300,  301,  302,   -1,  304,   -1,  306,  307,  308,
  309,  310,  311,  312,  313,   -1,  315,  316,  317,  318,
   -1,   -1,  321,  322,  323,   -1,  325,   -1,   -1,   -1,
   -1,  330,  331,   -1,  333,  334,    0,  336,  337,  338,
   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  362,   -1,  364,  365,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  377,    0,
   -1,  261,   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,
  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,  279,
   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,  418,
  300,  301,  302,   -1,  304,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,   -1,
  257,  321,  322,  323,  261,   -1,    0,   -1,   -1,   -1,
  330,  331,   -1,  333,  334,  272,  336,  337,  338,   -1,
  277,   -1,  342,   -1,  281,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  296,
  297,   -1,  362,   -1,  301,  302,   -1,  257,  368,  369,
  307,  261,  309,  310,  311,  312,   -1,  377,   -1,   -1,
  317,   -1,  272,   -1,  321,   -1,  323,  277,   -1,    0,
   -1,  281,   -1,   -1,  284,   -1,  333,   -1,  335,  336,
   -1,  338,   -1,   -1,   -1,  342,  296,  297,   -1,   -1,
   -1,  301,  302,   -1,   -1,   -1,   -1,  307,  418,  309,
  310,  311,  312,   -1,   -1,  362,   -1,  317,   -1,   -1,
  257,  321,  369,  323,  261,   -1,    0,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,  272,  336,   -1,  338,   -1,
  277,   -1,  342,   -1,  281,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  296,
  297,   -1,  362,  257,  301,  302,   -1,  261,  368,  369,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,
  317,   -1,   -1,  277,  321,   -1,  323,  281,   -1,    0,
  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  296,  297,   -1,  342,  257,  301,  302,   -1,
  261,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  272,   -1,  317,   -1,  362,  277,  321,   -1,  323,
  281,  368,  369,  284,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  296,  297,   -1,  342,   -1,
  301,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,  362,   -1,
  321,   -1,  323,  257,   -1,  369,   -1,  261,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  272,   -1,
   -1,  342,   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  362,  296,  297,   -1,   -1,   -1,  301,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,   -1,  257,  321,   -1,  323,
  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,  272,  336,   -1,  338,   -1,  277,   -1,  342,   -1,
  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,  362,   -1,
  301,  302,   -1,  257,   -1,   -1,  307,  261,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,  272,   -1,
  321,   -1,  323,  277,   -1,   -1,   -1,  281,   -1,   -1,
  284,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,   -1,
   -1,  342,  296,  297,   -1,   -1,   -1,  301,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  362,   -1,  317,   -1,   -1,  257,  321,   -1,  323,
  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,  272,  336,   -1,  338,   -1,  277,   -1,  342,   -1,
  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,  362,   -1,
  301,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,  256,  336,   -1,  338,   -1,   -1,
   -1,  342,  264,  265,  266,  267,   -1,   -1,  270,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,   -1,   -1,
   -1,  362,   -1,  285,   -1,  287,  288,  289,  290,  291,
  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,
   -1,  256,  344,  345,   -1,   -1,   -1,  262,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
   -1,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,
   -1,   -1,  384,  298,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,   -1,   -1,  262,   -1,  417,  418,  419,  420,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,  429,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,  298,
   -1,   -1,   -1,  368,  369,  370,  371,  372,  373,  374,
  375,  376,   -1,  378,  379,   -1,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,   -1,  392,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  411,  412,  413,   -1,
  256,   -1,   -1,  418,   -1,  420,  262,   -1,  423,   -1,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,  368,
   -1,   -1,  371,   -1,  373,  374,   -1,   -1,   -1,  378,
  379,   -1,   -1,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  298,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  412,  413,   -1,   -1,   -1,   -1,   -1,
   -1,  420,  262,   -1,  423,   -1,   -1,   -1,   -1,   -1,
  429,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,
   -1,  367,  368,  369,  370,  371,  372,  373,  374,  375,
  376,   -1,  378,  379,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,   -1,  256,
   -1,   -1,   -1,   -1,  420,  262,   -1,  357,   -1,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,  369,
   -1,  371,   -1,  373,   -1,   -1,  376,   -1,  378,  379,
   -1,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  298,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,   -1,   -1,   -1,   -1,  418,   -1,
  420,  262,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,
  367,  368,   -1,  370,  371,  372,  373,  374,  375,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,  256,   -1,
   -1,   -1,   -1,  420,  262,   -1,  423,   -1,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,  369,   -1,
  371,  372,  373,  374,   -1,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,   -1,  387,  388,  389,  390,
  298,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,   -1,   -1,   -1,  418,   -1,  420,
  262,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,   -1,
  368,   -1,  370,  371,  372,  373,  374,  375,  376,   -1,
  378,  379,   -1,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,   -1,  392,  393,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,   -1,  256,   -1,   -1,
   -1,   -1,  420,  262,   -1,  423,   -1,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  370,  371,
  372,  373,  374,   -1,   -1,   -1,  378,  379,   -1,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  298,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,   -1,   -1,   -1,   -1,   -1,   -1,  420,   -1,
   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,  371,  372,  373,  374,  375,  376,   -1,  378,
  379,   -1,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,   -1,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,  256,  256,   -1,   -1,
   -1,  420,  262,   -1,  423,   -1,  265,   -1,  267,   -1,
  429,  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,
  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
   -1,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,   -1,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,   -1,  256,  256,   -1,   -1,  418,
  420,  262,   -1,  423,   -1,  265,   -1,  267,   -1,  429,
  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,
  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,
   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
  371,  372,  373,  374,  375,  376,   -1,  378,   -1,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
   -1,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,  256,   -1,  256,   -1,  418,  420,
  262,   -1,  423,   -1,  264,  265,   -1,  267,  429,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,  298,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  359,
  360,  361,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,  371,  374,  375,  376,   -1,  378,  379,   -1,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  261,
   -1,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  256,  413,  284,   -1,   -1,   -1,  262,  417,  418,   -1,
   -1,   -1,   -1,   -1,   -1,  297,   -1,  429,   -1,   -1,
  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,
   -1,   -1,  298,  325,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
  362,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  298,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,  418,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,  256,  429,   -1,   -1,   -1,   -1,  262,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
  378,  379,   -1,   -1,  382,  383,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,   -1,   -1,  394,  395,  396,  397,
  398,  399,  400,  401,  298,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  413,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,  429,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  298,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,  285,   -1,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,  256,  429,   -1,   -1,   -1,  327,
  262,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,   -1,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,  298,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,  377,
  378,  379,  380,   -1,  382,  383,  384,  385,  386,  387,
  388,  389,  256,  429,  392,  393,  394,  395,  396,  397,
  398,  399,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
  394,  395,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,  394,  395,  396,  397,
  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,   -1,   -1,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,   -1,   -1,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
   -1,   -1,  396,  397,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,
  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,   -1,   -1,  396,  397,
  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,   -1,   -1,   -1,   -1,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,
   -1,   -1,   -1,   -1,  398,  399,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,
   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,
   -1,  389,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1,  389,
  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  413,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  385,   -1,   -1,   -1,  389,  390,   -1,
  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  413,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,
   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,
  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  385,   -1,   -1,   -1,   -1,  390,   -1,  256,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,
   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,
  376,   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,  385,
   -1,   -1,   -1,   -1,  390,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  390,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  401,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  413,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,  429,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,  390,   -1,
   -1,   -1,   -1,   -1,  264,  265,  266,  267,   -1,  401,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,  413,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,  429,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,   -1,  363,   -1,   -1,   -1,  367,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,  292,
   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,   -1,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,  295,
   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,   -1,  363,   -1,   -1,
   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  417,  418,  419,  420,  264,  265,  266,  267,   -1,
   -1,  270,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,
  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,
  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,   -1,  337,   -1,
   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,   -1,  363,   -1,   -1,   -1,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,
  419,  420,  264,  265,  266,  267,   -1,   -1,  270,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,
  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
   -1,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,  256,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,  265,   -1,  267,
  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,
  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  316,  334,
  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,
  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,   -1,   -1,   -1,  359,  360,  361,   -1,  363,   -1,
   -1,   -1,  367,  368,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,  256,   -1,  275,  276,  277,
  418,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,
  318,  319,  320,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  418,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
   -1,  363,   -1,   -1,   -1,  367,  368,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,  417,  418,  419,  420,   -1,
   -1,  264,  265,   -1,  267,   -1,  428,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,  337,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,   -1,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,  372,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,  418,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,
  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  417,  418,  419,  420,   -1,   -1,  264,  265,   -1,  267,
   -1,  428,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,
  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,  370,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,
  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  418,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,   -1,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  417,  418,  419,  420,  261,   -1,   -1,
   -1,  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,
   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,
   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,  362,   -1,
  265,   -1,  267,   -1,  368,  270,   -1,  272,  273,   -1,
  275,   -1,  277,  377,  279,   -1,  281,  282,  283,  284,
   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,
  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,  316,  317,  318,  418,   -1,  321,  322,  323,   -1,
   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,
   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  261,   -1,  362,   -1,  265,
   -1,  267,   -1,  368,  270,   -1,  272,  273,   -1,  275,
   -1,  277,  377,  279,   -1,  281,  282,  283,  284,   -1,
   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,
  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
  316,  317,  318,  418,   -1,  321,  322,  323,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,
  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  261,   -1,  362,   -1,  265,   -1,
  267,   -1,  368,  270,   -1,  272,  273,   -1,  275,   -1,
  277,  377,  279,   -1,  281,  282,  283,  284,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,
  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,
  317,  318,  418,   -1,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,
  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  261,   -1,  362,   -1,  265,   -1,  267,
   -1,  368,  270,   -1,  272,  273,   -1,  275,   -1,  277,
  377,  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,  418,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,   -1,
   -1,  265,   -1,  267,  362,   -1,  270,   -1,  272,  273,
  368,  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,
   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,  261,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
  418,   -1,  284,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,  261,  336,  337,  338,  297,   -1,   -1,  342,   -1,
  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,  284,  317,   -1,   -1,  362,  321,
   -1,   -1,   -1,  325,  368,   -1,   -1,  297,   -1,  261,
   -1,  333,  302,   -1,  336,   -1,  338,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,  284,   -1,   -1,  357,   -1,   -1,   -1,  261,
  362,   -1,   -1,  333,   -1,  297,  336,  369,  338,  371,
  302,  373,   -1,  305,  418,  307,   -1,  309,  310,  311,
  312,   -1,  284,   -1,  386,  317,   -1,   -1,   -1,  321,
   -1,   -1,  362,  325,   -1,  297,   -1,   -1,   -1,   -1,
  302,  333,   -1,   -1,  336,  307,  338,  309,  310,  311,
  312,   -1,   -1,   -1,   -1,  317,  418,   -1,   -1,  321,
   -1,   -1,   -1,  325,   -1,   -1,  264,  265,   -1,  267,
  362,  333,  270,  271,  336,   -1,  338,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  418,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
  362,   -1,  300,   -1,  302,  303,  304,   -1,  306,   -1,
   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,  418,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  418,   -1,   -1,   -1,
   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,  372,   -1,  374,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,  306,   -1,   -1,   -1,   -1,   -1,
   -1,  313,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,  374,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
  306,   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,   -1,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,  419,
  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,   -1,  363,
   -1,   -1,   -1,   -1,  368,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
   -1,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,   -1,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,  419,
  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,   -1,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,   -1,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,  261,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,  284,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,  297,  334,   -1,
   -1,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  315,   -1,  317,   -1,   -1,
   -1,  321,   -1,  359,  360,  361,   -1,  363,   -1,   -1,
   -1,   -1,   -1,  333,   -1,  371,  336,   -1,  338,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,  264,  265,   -1,  267,  392,  393,  270,  271,
   -1,   -1,  362,  275,  276,  277,   -1,  279,  368,  369,
   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,
  261,  417,  418,  295,  420,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,  297,  329,  330,  331,
  332,  302,  334,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,  315,   -1,  317,   -1,   -1,   -1,
  321,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
   -1,  363,  333,   -1,   -1,  336,   -1,  338,   -1,  371,
  263,   -1,  265,   -1,  267,  377,   -1,  270,  380,  272,
  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,  362,   -1,   -1,  287,  288,   -1,  368,   -1,   -1,
  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,   -1,
   -1,  304,   -1,   -1,   -1,  417,  418,   -1,  420,   -1,
   -1,   -1,  315,  316,   -1,  318,   -1,   -1,   -1,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,  264,
  265,  334,  267,   -1,  337,  270,  271,   -1,   -1,  342,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,  364,  365,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  418,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  265,   -1,  267,
   -1,   -1,  270,   -1,  272,  273,  371,  275,   -1,  277,
   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,   -1,
   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,   -1,  417,  418,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,   -1,  265,  334,  267,   -1,  337,
  270,   -1,  272,  273,  342,  275,   -1,  277,   -1,  279,
   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,   -1,  295,  296,   -1,   -1,   -1,
  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,  377,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,
   -1,   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,  265,
   -1,  267,  342,   -1,  270,   -1,   -1,  273,   -1,  275,
  418,  277,   -1,  279,   -1,  281,  282,  283,   -1,   -1,
   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,
   -1,  265,   -1,  267,  300,   -1,  270,   -1,  304,  273,
   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,
  316,   -1,  318,  287,  288,   -1,  322,   -1,   -1,  293,
   -1,  295,   -1,   -1,  330,  331,  300,   -1,  334,   -1,
  304,  337,   -1,   -1,   -1,  265,  342,  267,  418,   -1,
  270,   -1,  316,   -1,  318,  275,   -1,   -1,  322,  279,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,  288,   -1,
  334,   -1,   -1,  337,   -1,  295,   -1,  265,  342,  267,
  300,  377,  270,   -1,  304,   -1,  306,  275,  308,   -1,
   -1,  279,   -1,  313,   -1,   -1,  316,   -1,  318,   -1,
  288,   -1,  322,   -1,   -1,  325,   -1,  295,   -1,   -1,
  330,  331,  300,   -1,  334,   -1,  304,  337,  306,   -1,
  308,  265,  418,  267,   -1,  313,  270,   -1,  316,   -1,
  318,  275,   -1,   -1,  322,  279,   -1,  325,   -1,   -1,
   -1,   -1,  330,  331,  288,   -1,  334,   -1,   -1,  337,
   -1,  295,  372,  265,  418,  267,  300,   -1,  270,   -1,
  304,   -1,  306,  275,  308,   -1,   -1,  279,   -1,  313,
   -1,   -1,  316,   -1,  318,   -1,  288,   -1,  322,   -1,
   -1,  325,  370,  295,   -1,   -1,  330,  331,  300,   -1,
  334,   -1,  304,  337,  306,   -1,   -1,   -1,  418,   -1,
   -1,  313,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,
  322,   -1,   -1,  325,   -1,   -1,   -1,   -1,  330,  331,
   -1,   -1,  334,   -1,  265,  337,  267,   -1,   -1,  270,
  418,  272,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,  265,   -1,
  267,   -1,   -1,  270,  295,   -1,   -1,   -1,  275,  300,
   -1,  302,  279,  304,   -1,   -1,  283,   -1,   -1,   -1,
   -1,  288,   -1,   -1,  418,  316,  293,  318,  295,   -1,
   -1,  322,  323,  300,   -1,   -1,   -1,  304,  305,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,  265,  316,
  267,  318,   -1,  270,   -1,  322,  418,   -1,  275,   -1,
   -1,   -1,  279,  330,  331,   -1,   -1,  334,   -1,   -1,
   -1,  288,  265,   -1,  267,   -1,   -1,  270,  295,   -1,
   -1,   -1,  275,  300,   -1,   -1,  279,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,  316,
   -1,  318,  295,   -1,   -1,  322,   -1,  300,   -1,   -1,
   -1,  304,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,  316,   -1,  318,  265,  418,  267,  322,
   -1,  270,   -1,   -1,   -1,   -1,  275,  330,  331,   -1,
  279,  334,   -1,  265,  337,  267,   -1,   -1,  270,  288,
   -1,  418,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,
   -1,  300,   -1,   -1,   -1,  304,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,
   -1,   -1,  304,  322,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,  316,  334,  318,  265,  337,  267,
  322,  418,  270,   -1,   -1,   -1,   -1,  275,  330,  331,
   -1,  279,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
  288,  265,   -1,  267,   -1,  418,  270,  295,   -1,   -1,
   -1,  275,  300,   -1,   -1,  279,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,  316,   -1,
  318,  295,   -1,   -1,  322,   -1,  300,   -1,   -1,   -1,
  304,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,  265,  316,  267,  318,   -1,  270,   -1,  322,  418,
   -1,  275,   -1,   -1,   -1,  279,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,  288,  265,  418,  267,   -1,   -1,
  270,  295,   -1,   -1,   -1,  275,  300,   -1,   -1,  279,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,
   -1,   -1,  316,   -1,  318,  295,   -1,   -1,  322,   -1,
  300,   -1,   -1,   -1,  304,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,  316,   -1,  318,  265,
  418,  267,  322,   -1,  270,   -1,   -1,   -1,   -1,  275,
  330,  331,   -1,  279,  334,   -1,  265,  337,  267,   -1,
   -1,  270,  288,   -1,  418,   -1,  275,   -1,   -1,  295,
  279,   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
  316,  300,  318,   -1,   -1,  304,  322,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,  316,  334,  318,
  265,  337,  267,  322,  418,  270,   -1,   -1,   -1,   -1,
  275,  330,  331,   -1,  279,  334,   -1,   -1,  337,   -1,
   -1,   -1,   -1,  288,   -1,   -1,   -1,   -1,  418,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,   -1,  261,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,
   -1,  316,   -1,  318,  277,   -1,   -1,  322,  281,   -1,
   -1,  284,   -1,   -1,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,  296,  297,   -1,   -1,   -1,  301,  302,
   -1,   -1,  418,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,  418,
  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,  335,  336,  261,  338,   -1,   -1,   -1,  342,
   -1,   -1,   -1,   -1,   -1,  272,   -1,   -1,   -1,   -1,
  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,  362,
   -1,   -1,   -1,   -1,   -1,  368,  369,   -1,   -1,  296,
  297,   -1,   -1,  418,  301,  302,  261,   -1,  263,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  297,   -1,   -1,  342,   -1,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,  362,  321,   -1,   -1,  261,
   -1,  368,  369,   -1,   -1,   -1,   -1,   -1,  333,   -1,
  272,  336,   -1,  338,   -1,  277,   -1,   -1,   -1,  281,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  296,  297,   -1,  362,   -1,  301,
  302,   -1,  261,  368,  369,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  272,   -1,  317,   -1,   -1,  277,  321,
   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,
  342,   -1,  301,  302,  261,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
  362,   -1,  321,   -1,  323,   -1,  368,  284,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  297,   -1,  261,  342,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,  362,  321,  284,   -1,   -1,   -1,  368,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,  297,  336,
  261,  338,  263,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,  284,   -1,  362,   -1,  364,  365,   -1,
   -1,  368,   -1,   -1,  333,   -1,  297,  336,  261,  338,
   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,  284,   -1,  362,   -1,  364,  365,   -1,  261,  368,
  263,   -1,  333,   -1,  297,  336,   -1,  338,   -1,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,  284,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,
   -1,  362,   -1,   -1,  297,   -1,   -1,  368,  261,  302,
  333,   -1,   -1,  336,  307,  338,  309,  310,  311,  312,
   -1,   -1,  315,   -1,  317,   -1,   -1,   -1,  321,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,  261,  362,
  333,  364,  365,  336,  297,  338,   -1,   -1,  301,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,  284,   -1,   -1,  317,   -1,   -1,   -1,  321,  362,
   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1,   -1,  302,
  333,   -1,   -1,  336,  307,  338,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,
  333,   -1,   -1,  336,   -1,  338,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,
  };

#line 6185 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		Expression.Error_InvalidExpressionStatement (report, expr.Location);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void push_current_class (TypeContainer tc, object partial_token)
{
	if (module.Evaluator != null && current_container is ModuleContainer){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();
		undo.AddTypeContainer (current_container, tc);
	}

	if (partial_token != null)
		current_container = current_container.AddPartial (tc);
	else
		current_container = current_container.AddTypeContainer (tc);

	++lexer.parsing_declaration;
	current_class = tc;
	ubag.PushTypeDeclaration (tc);
}

DeclSpace pop_current_class ()
{
	DeclSpace retval = current_class;

	current_class = current_class.Parent;
	current_container = current_class.PartialContainer;
	ubag.PopTypeDeclaration ();
	
	return retval;
}

// <summary>
//   Given the @class_name name, it creates a fully qualified name
//   based on the containing declaration space
// </summary>
MemberName
MakeName (MemberName class_name)
{
	Namespace ns = current_namespace.NS;

	if (current_container == module) {
		if (ns.Name.Length != 0)
			return new MemberName (ns.MemberName, class_name);
		else
			return class_name;
	} else {
		return new MemberName (current_container.MemberName, class_name);
	}
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

string CheckAttributeTarget (string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	report.Warning (658, 1, l,
		 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

static CSharpParser ()
{
	oob_stack = new Stack<object> ();
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file)
	: this (reader, file, file.NamespaceContainer.Module.Compiler.Report)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report)
{
	this.file = file;
	current_namespace = file.NamespaceContainer;
	
	this.module = current_namespace.Module;
	this.compiler = module.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	doc_support = settings.DocumentationFile != null;
	current_class = current_namespace.SlaveDeclSpace;
	current_container = current_class.PartialContainer; // == RootContest.ToplevelTypes
	oob_stack.Clear ();
	lexer = new Tokenizer (reader, file, compiler);
	
	use_global_stacks = true;
}

public void parse ()
{
	eof_token = Token.EOF;
	Tokenizer.LocatedToken.Initialize ();
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing");
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as Tokenizer.LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

public LocationsBag LocationsBag {
	get {
		return lbag;
	}
	set {
		lbag = value;
	}
}

public UsingsBag UsingsBag {
	get {
		return ubag;
	}
	set {
		ubag = value;
	}
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool lambda, ParametersCompiled parameters, Location loc)
{
	if (lang_version == LanguageVersion.ISO_1){
		FeatureIsNotAvailable (loc, "anonymous methods");
	}

	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);

	current_local_parameters = parameters;

	current_anonymous_method = lambda 
		? new LambdaExpression (loc) 
		: new AnonymousMethodExpression (loc);

	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	current_variable = (BlockVariableDeclaration) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((Tokenizer.LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int REFVALUE = 359;
  public const int REFTYPE = 360;
  public const int MAKEREF = 361;
  public const int ASYNC = 362;
  public const int AWAIT = 363;
  public const int GET = 364;
  public const int SET = 365;
  public const int LAST_KEYWORD = 366;
  public const int OPEN_BRACE = 367;
  public const int CLOSE_BRACE = 368;
  public const int OPEN_BRACKET = 369;
  public const int CLOSE_BRACKET = 370;
  public const int OPEN_PARENS = 371;
  public const int CLOSE_PARENS = 372;
  public const int DOT = 373;
  public const int COMMA = 374;
  public const int COLON = 375;
  public const int SEMICOLON = 376;
  public const int TILDE = 377;
  public const int PLUS = 378;
  public const int MINUS = 379;
  public const int BANG = 380;
  public const int ASSIGN = 381;
  public const int OP_LT = 382;
  public const int OP_GT = 383;
  public const int BITWISE_AND = 384;
  public const int BITWISE_OR = 385;
  public const int STAR = 386;
  public const int PERCENT = 387;
  public const int DIV = 388;
  public const int CARRET = 389;
  public const int INTERR = 390;
  public const int DOUBLE_COLON = 391;
  public const int OP_INC = 392;
  public const int OP_DEC = 393;
  public const int OP_SHIFT_LEFT = 394;
  public const int OP_SHIFT_RIGHT = 395;
  public const int OP_LE = 396;
  public const int OP_GE = 397;
  public const int OP_EQ = 398;
  public const int OP_NE = 399;
  public const int OP_AND = 400;
  public const int OP_OR = 401;
  public const int OP_MULT_ASSIGN = 402;
  public const int OP_DIV_ASSIGN = 403;
  public const int OP_MOD_ASSIGN = 404;
  public const int OP_ADD_ASSIGN = 405;
  public const int OP_SUB_ASSIGN = 406;
  public const int OP_SHIFT_LEFT_ASSIGN = 407;
  public const int OP_SHIFT_RIGHT_ASSIGN = 408;
  public const int OP_AND_ASSIGN = 409;
  public const int OP_XOR_ASSIGN = 410;
  public const int OP_OR_ASSIGN = 411;
  public const int OP_PTR = 412;
  public const int OP_COALESCING = 413;
  public const int OP_GENERICS_LT = 414;
  public const int OP_GENERICS_LT_DECL = 415;
  public const int OP_GENERICS_GT = 416;
  public const int LITERAL = 417;
  public const int IDENTIFIER = 418;
  public const int OPEN_PARENS_LAMBDA = 419;
  public const int OPEN_PARENS_CAST = 420;
  public const int GENERIC_DIMENSION = 421;
  public const int DEFAULT_COLON = 422;
  public const int OPEN_BRACKET_EXPR = 423;
  public const int EVAL_STATEMENT_PARSER = 424;
  public const int EVAL_COMPILATION_UNIT_PARSER = 425;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 426;
  public const int DOC_SEE = 427;
  public const int GENERATE_COMPLETION = 428;
  public const int COMPLETE_COMPLETION = 429;
  public const int UMINUS = 430;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
