// ------------------------------------------------------------------------------
// This file was autogenerated.
// ------------------------------------------------------------------------------
// 
namespace MonoQuery.Collections {
	using System;
	using System.Collections;
	using MonoQuery.SchemaClass;
	
	
	/// <summary>
	///     <para>
	///       A collection that stores <see cref='.MonoQueryParameter'/> objects.
	///    </para>
	/// </summary>
	/// <seealso cref='.MonoQueryParameterCollection'/>
	[Serializable()]
	public class MonoQueryParameterCollection : CollectionBase {
		
		/// <summary>
		///     <para>
		///       Initializes a new instance of <see cref='.MonoQueryParameterCollection'/>.
		///    </para>
		/// </summary>
		public MonoQueryParameterCollection() {
		}
		
		/// <summary>
		///     <para>
		///       Initializes a new instance of <see cref='.MonoQueryParameterCollection'/> based on another <see cref='.MonoQueryParameterCollection'/>.
		///    </para>
		/// </summary>
		/// <param name='value'>
		///       A <see cref='.MonoQueryParameterCollection'/> from which the contents are copied
		/// </param>
		public MonoQueryParameterCollection(MonoQueryParameterCollection value) {
			this.AddRange(value);
		}
		
		/// <summary>
		///     <para>
		///       Initializes a new instance of <see cref='.MonoQueryParameterCollection'/> containing any array of <see cref='.MonoQueryParameter'/> objects.
		///    </para>
		/// </summary>
		/// <param name='value'>
		///       A array of <see cref='.MonoQueryParameter'/> objects with which to intialize the collection
		/// </param>
		public MonoQueryParameterCollection(MonoQueryParameter[] value) {
			this.AddRange(value);
		}
		
		
		public MonoQueryParameterCollection(MonoQuerySchemaClassCollection value) {
			this.AddRange( value );
		}						
		
		/// <summary>
		/// <para>Represents the entry at the specified index of the <see cref='.MonoQueryParameter'/>.</para>
		/// </summary>
		/// <param name='index'><para>The zero-based index of the entry to locate in the collection.</para></param>
		/// <value>
		///    <para> The entry at the specified index of the collection.</para>
		/// </value>
		/// <exception cref='System.ArgumentOutOfRangeException'><paramref name='index'/> is outside the valid range of indexes for the collection.</exception>
		public MonoQueryParameter this[int index] {
			get {
				return ((MonoQueryParameter)(List[index]));
			}
			set {
				List[index] = value;
			}
		}
		
		public MonoQuerySchemaClassCollection ToBaseSchemaCollection()
		{
			MonoQuerySchemaClassCollection returnValues = new MonoQuerySchemaClassCollection();
			foreach( MonoQueryParameter par in this )
			{
				returnValues.Add( par );	
			}
			
			return returnValues;
		}
		
		/// <summary>
		///    <para>Adds a <see cref='.MonoQueryParameter'/> with the specified value to the 
		///    <see cref='.MonoQueryParameterCollection'/> .</para>
		/// </summary>
		/// <param name='value'>The <see cref='.MonoQueryParameter'/> to add.</param>
		/// <returns>
		///    <para>The index at which the new element was inserted.</para>
		/// </returns>
		/// <seealso cref='.MonoQueryParameterCollection.AddRange'/>
		public int Add(MonoQueryParameter value) {
			return List.Add(value);
		}
		
		/// <summary>
		/// <para>Copies the elements of an array to the end of the <see cref='.MonoQueryParameterCollection'/>.</para>
		/// </summary>
		/// <param name='value'>
		///    An array of type <see cref='.MonoQueryParameter'/> containing the objects to add to the collection.
		/// </param>
		/// <returns>
		///   <para>None.</para>
		/// </returns>
		/// <seealso cref='.MonoQueryParameterCollection.Add'/>
		public void AddRange(MonoQueryParameter[] value) {
			for (int i = 0; (i < value.Length); i = (i + 1)) {
				this.Add(value[i]);
			}
		}
		
		/// <summary>
		///     <para>
		///       Adds the contents of another <see cref='.MonoQueryParameterCollection'/> to the end of the collection.
		///    </para>
		/// </summary>
		/// <param name='value'>
		///    A <see cref='.MonoQueryParameterCollection'/> containing the objects to add to the collection.
		/// </param>
		/// <returns>
		///   <para>None.</para>
		/// </returns>
		/// <seealso cref='.MonoQueryParameterCollection.Add'/>
		public void AddRange(MonoQueryParameterCollection value) {
			for (int i = 0; (i < value.Count); i = (i + 1)) {
				this.Add(value[i]);
			}
		}
		
		
		public void AddRange(MonoQuerySchemaClassCollection value) 
		{
			foreach( MonoQueryParameter par in value ) 
			{
				this.Add( par );				
			}
		}						
		
		/// <summary>
		/// <para>Gets a value indicating whether the 
		///    <see cref='.MonoQueryParameterCollection'/> contains the specified <see cref='.MonoQueryParameter'/>.</para>
		/// </summary>
		/// <param name='value'>The <see cref='.MonoQueryParameter'/> to locate.</param>
		/// <returns>
		/// <para><see langword='true'/> if the <see cref='.MonoQueryParameter'/> is contained in the collection; 
		///   otherwise, <see langword='false'/>.</para>
		/// </returns>
		/// <seealso cref='.MonoQueryParameterCollection.IndexOf'/>
		public bool Contains(MonoQueryParameter value) {
			return List.Contains(value);
		}
		
		/// <summary>
		/// <para>Copies the <see cref='.MonoQueryParameterCollection'/> values to a one-dimensional <see cref='System.Array'/> instance at the 
		///    specified index.</para>
		/// </summary>
		/// <param name='array'><para>The one-dimensional <see cref='System.Array'/> that is the destination of the values copied from <see cref='.MonoQueryParameterCollection'/> .</para></param>
		/// <param name='index'>The index in <paramref name='array'/> where copying begins.</param>
		/// <returns>
		///   <para>None.</para>
		/// </returns>
		/// <exception cref='System.ArgumentException'><para><paramref name='array'/> is multidimensional.</para> <para>-or-</para> <para>The number of elements in the <see cref='.MonoQueryParameterCollection'/> is greater than the available space between <paramref name='arrayIndex'/> and the end of <paramref name='array'/>.</para></exception>
		/// <exception cref='System.ArgumentNullException'><paramref name='array'/> is <see langword='null'/>. </exception>
		/// <exception cref='System.ArgumentOutOfRangeException'><paramref name='arrayIndex'/> is less than <paramref name='array'/>'s lowbound. </exception>
		/// <seealso cref='System.Array'/>
		public void CopyTo(MonoQueryParameter[] array, int index) {
			List.CopyTo(array, index);
		}
		
		/// <summary>
		///    <para>Returns the index of a <see cref='.MonoQueryParameter'/> in 
		///       the <see cref='.MonoQueryParameterCollection'/> .</para>
		/// </summary>
		/// <param name='value'>The <see cref='.MonoQueryParameter'/> to locate.</param>
		/// <returns>
		/// <para>The index of the <see cref='.MonoQueryParameter'/> of <paramref name='value'/> in the 
		/// <see cref='.MonoQueryParameterCollection'/>, if found; otherwise, -1.</para>
		/// </returns>
		/// <seealso cref='.MonoQueryParameterCollection.Contains'/>
		public int IndexOf(MonoQueryParameter value) {
			return List.IndexOf(value);
		}
		
		/// <summary>
		/// <para>Inserts a <see cref='.MonoQueryParameter'/> into the <see cref='.MonoQueryParameterCollection'/> at the specified index.</para>
		/// </summary>
		/// <param name='index'>The zero-based index where <paramref name='value'/> should be inserted.</param>
		/// <param name=' value'>The <see cref='.MonoQueryParameter'/> to insert.</param>
		/// <returns><para>None.</para></returns>
		/// <seealso cref='.MonoQueryParameterCollection.Add'/>
		public void Insert(int index, MonoQueryParameter value) {
			List.Insert(index, value);
		}
		
		/// <summary>
		///    <para>Returns an enumerator that can iterate through 
		///       the <see cref='.MonoQueryParameterCollection'/> .</para>
		/// </summary>
		/// <returns><para>None.</para></returns>
		/// <seealso cref='System.Collections.IEnumerator'/>
		public new MonoQueryParameterEnumerator GetEnumerator() {
			return new MonoQueryParameterEnumerator(this);
		}
		
		/// <summary>
		///    <para> Removes a specific <see cref='.MonoQueryParameter'/> from the 
		///    <see cref='.MonoQueryParameterCollection'/> .</para>
		/// </summary>
		/// <param name='value'>The <see cref='.MonoQueryParameter'/> to remove from the <see cref='.MonoQueryParameterCollection'/> .</param>
		/// <returns><para>None.</para></returns>
		/// <exception cref='System.ArgumentException'><paramref name='value'/> is not found in the Collection. </exception>
		public void Remove(MonoQueryParameter value) {
			List.Remove(value);
		}
		
		public class MonoQueryParameterEnumerator : object, IEnumerator {
			
			private IEnumerator baseEnumerator;
			
			private IEnumerable temp;
			
			public MonoQueryParameterEnumerator(MonoQueryParameterCollection mappings) {
				this.temp = ((IEnumerable)(mappings));
				this.baseEnumerator = temp.GetEnumerator();
			}
			
			public MonoQueryParameter Current {
				get {
					return ((MonoQueryParameter)(baseEnumerator.Current));
				}
			}
			
			object IEnumerator.Current {
				get {
					return baseEnumerator.Current;
				}
			}
			
			public bool MoveNext() {
				return baseEnumerator.MoveNext();
			}
			
			bool IEnumerator.MoveNext() {
				return baseEnumerator.MoveNext();
			}
			
			public void Reset() {
				baseEnumerator.Reset();
			}
			
			void IEnumerator.Reset() {
				baseEnumerator.Reset();
			}
		}
	}
}
