/* libmondo-raid.c                                                subroutines for handling RAID

10/19
- added some comments

07/24
- created
*/


#include "my-stuff.h"
#include "mondostructures.h"
#include "libmondo-raid.h"
#include "libmondo-gui-EXT.h"
#include "libmondo-tools-EXT.h"
#include "lib-common-externs.h"







/*************************************************************************
 * is_this_raid_personality_registered() -- Hugo Rabson                  *
 *                                                                       *
 * Purpose:  See if a particular RAID personality (0, 1, etc.)           *
 *           is supported by the user's kernel.                          *
 * Called by:...                                                         *
 * Params:   raidno (0, 1, 2, 3, ...)                                    *
 * Returns:  TRUE (yes, supported) or FALSE (no, not supported)          *
 * NB:       I'm not sure what happens to linear or other non-numeric    *
 *           RAID formats. Ah, well. We'll see.                          *
 *************************************************************************/
bool
is_this_raid_personality_registered (int raidno)
{

	/** buffer ***********************************************************/
  char command[MAX_STR_LEN*2];

  strcpy (command, "cat /proc/mdstat | grep \"");
  if (raidno == -1)
    {
      strcat (command, "linear");
    }
  else
    {
      sprintf (command + strlen (command), "raid%d", raidno);
    }
  strcat (command, "\" > /dev/null 2> /dev/null");
  log_it ("Is raid %d registered? Command = '%s'", raidno, command);
  if (system (command))
    {
      return (FALSE);
    }
  else
    {
      return (TRUE);
    }
}





/*************************************************************************
 * which_raid_device_is_using_this_partition() -- Hugo Rabson            *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
which_raid_device_is_using_this_partition (struct raidlist_itself *raidlist,
					   char *device)
{
	/** int **********************************************************/
  int current_raiddev = 0;

  for (current_raiddev = 0; current_raiddev < raidlist->entries;
       current_raiddev++)
    {
      if (where_in_drivelist_is_drive
	  (&raidlist->el[current_raiddev].data_disks, device) >= 0
	  || where_in_drivelist_is_drive (&raidlist->el[current_raiddev].
					  spare_disks, device) >= 0
	  || where_in_drivelist_is_drive (&raidlist->el[current_raiddev].
					  parity_disks, device) >= 0
	  || where_in_drivelist_is_drive (&raidlist->el[current_raiddev].
					  failed_disks, device) >= 0)
	{
	  break;
	}
    }
  if (current_raiddev == raidlist->entries)
    {
      return (-1);
    }
  else
    {
      return (current_raiddev);
    }
}

/*************************************************************************
 * write_variableINT_to_raid_var_line() -- Hugo Rabson                   *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
write_variableINT_to_raid_var_line (struct raid_device_record *raidrec,
				    int lino, char *label, int value)
{
	/** buffers ******************************************************/
  char sz_value[MAX_STR_LEN];


  sprintf (sz_value, "%d", value);
  strcpy (raidrec->additional_vars.el[lino].label, label);
  strcpy (raidrec->additional_vars.el[lino].value, sz_value);
}







/*************************************************************************
 * where_in_drivelist_is_drive() -- Hugo Rabson                          *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
where_in_drivelist_is_drive (struct list_of_disks *disklist, char *device)
{

	/** int **************************************************************/
  int i = 0;



  for (i = 0; i < disklist->entries; i++)
    {
      if (!strcmp (disklist->el[i].device, device))
	{
	  break;
	}
    }
  if (i == disklist->entries)
    {
      return (-1);
    }
  else
    {
      return (i);
    }
}













