/* libmondo-archive.c

subroutines to handle the archiving of files


08/02
- unmount CD-ROM before burning (necessary for RH8/9)

07/29
- line 451, 458 of call_mindi_to_supply_boot_disks() --
  was ignoring user-specifeied boot loader --- FIXED

06/01
- commented out the call to interrogate_..._cdrw_...()

05/25
- fixed mondoarchive -Vi multi-CD verify bug (Tom Mortell)

05/23
- fixed bug on line 439 (Joshua Oreman)

05/25
- fixed mondoarchive -Vi multi-CD verify bug (Tom Mortell)

05/23
- fixed bug on line 439 (Joshua Oreman)

05/04
- back-port CD checker (to skip between-CD pause if possible) from 1.7x
- added computation of g_serial_string

04/26
- cleaned up archive_this_fileset()

04/25
- decreased ARCH_THREADS from 3 to 2
- pause_and_ask_for_cd() --- calls retract_CD_tray_and_defeat_autorun()

04/24
- added missing fclose() in make_slices_and_images()

04/05
- increased ARCH_THREADS from 2 to 3

03/15
- fixed problem w/ multi-ISO verify cycle (Tom Mortell)

02/10/2003
- added -e [do not eject while restoring]

11/29/2002
- make_iso_and_go_on() now copies Mondo's autorun file to CD
- set scratchdir dir to 1744 when burning CD

11/25
- cleaned up code a bit

11/21
- in call_mindi_...(), gracefully handle the user's input
  if they specify the boot loader but not the boot device

11/19
- offer to abort if GRUB is boot loader and /dev/md* is
  the boot device (bug in grub-install)
- if boot loader is R then write RAW as bootloader.name

11/12
- multithreaded make_afioballs_and_images()

11/09
- fixed slice_up_file_etc() for 0-compression users

11/08
- line 1198: added call to is_this_file_compressed() to stop
  slice_up_file_etc() from compressing files which are
  already compressed
- other hackery related to the above enhancement
- afio no longer forcibly compresses all files (i.e. I dropped
  the -U following suggestions from users); let's see if
  it works :)

10/01 - 10/31
- mondoarchive (with no parameters) wasn't working
  if user said yes when asked if BurnProof drive; FIXED
- if manual CD tray and writing to ISO's then prompt
  for each & every new CD
- moved a lot of subroutines here
  from mondo-archive.c and mondo-floppies.c

09/01 - 09/30
- if CD not burned OK then don't try to verify
- change 64k to TAPE_BLOCK_SIZE
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_
- orig_vfy_flag_val added to write_iso_and_go_on, to restore bkpinfo->verify_data's
  value if altered by verify_cd_image()

08/01 - 08/31
- use data structure to store the fname, checksum, mods & perms of each bigfile
  ... biggiestruct :)
- bigger tmp[]'s in a few places
- cleaned up the (user-friendly) counting of biggiefiles a bit
- if media_size[N]<=0 then catch it & abort, unless it's tape,
  in which case, allow it
- cleaned up a lot of log_it() calls
- fixed NULL filename-related bug in can_we_fit_these_files_on_media()
- deleted can_we_fit.....() subroutine because it was causing problems
  --- moved its code into the one subroutine which called it
- created [08/01]
*/


#include "../common/my-stuff.h"
#include "../common/mondostructures.h"
#include "libmondo-string-EXT.h"
#include "libmondo-stream-EXT.h"
#include "libmondo-devices-EXT.h"
#include "libmondo-tools-EXT.h"
#include "libmondo-gui-EXT.h"
#include "libmondo-fork-EXT.h"
#include "libmondo-files-EXT.h"
#include "libmondo-filelist-EXT.h"
#include "libmondo-tools-EXT.h"
#include "libmondo-verify-EXT.h"
#include "libmondo-archive.h"
#include "lib-common-externs.h"
#include <sys/sem.h>
#include <sys/types.h>
#include <sys/ipc.h>

#define DEFAULT_1722MB_DISK "/dev/fd0u1722"
#define BACKUP_1722MB_DISK "/dev/fd0H1722"
#define FILELIST_FNAME_RAW_SZ "%s/filelist.%d"
#define AFIOBALL_FNAME_RAW_SZ "%s/tmpfs/%d.afio.%s"

#ifndef _SEMUN_H
#define _SEMUN_H
union semun {
  int val;
  struct semid_ds *buf;
  unsigned short int *array;
  struct seminfo *__buf;
};

#endif

#define ARCH_THREADS 2 // simultaneous threads running afio in background
#define ARCH_BUFFER_NUM (ARCH_THREADS*2)
#define FORTY_SPACES "                                         "
extern int g_current_media_number, g_currentY;
extern bool g_text_mode;


extern int g_current_media_number;
extern long g_current_progress;
extern FILE*g_tape_stream;

extern long long g_tape_posK;
bool g_cd_recovery;

extern char g_mondo_home[MAX_STR_LEN];


char g_serial_string[MAX_STR_LEN];



int
write_image_to_floppy (char *device, char *datafile);


/* Semaphore-related code */

static int set_semvalue(void);
static void del_semvalue(void);
static int semaphore_p(void);
static int semaphore_v(void);

static int g_sem_id;
static int g_sem_key;

static int set_semvalue(void) // initializes semaphore
{
  union semun sem_union;
  sem_union.val = 1;
  if (semctl(g_sem_id, 0, SETVAL, sem_union) == -1) { return(0); }
  return(1);
}

static void del_semvalue(void) // deletes semaphore
{
  union semun sem_union;

  if (semctl(g_sem_id, 0, IPC_RMID, sem_union) == -1)
    { log_it("Failed to delete semaphore"); }
}

static int semaphore_p(void) // changes status to 'P' (waiting)
{
  struct sembuf sem_b;

  sem_b.sem_num = 0;
  sem_b.sem_op = -1; // P()
  sem_b.sem_flg = SEM_UNDO;
  if (semop(g_sem_id, &sem_b, 1) == -1)
    { log_it("semaphore_p failed"); return(0); }
  return(1);
}

static int semaphore_v(void) // changes status to 'V' (free)
{
  struct sembuf sem_b;

  sem_b.sem_num = 0;
  sem_b.sem_op = 1; // V()
  sem_b.sem_flg = SEM_UNDO;
  if (semop(g_sem_id, &sem_b, 1) == -1)
    { log_it("semaphore_v failed"); return(0); }
  return(1);
}


//------------------------------------------------------








/*************************************************************************
 * archive_this_fileset() -- Hugo Rabson                                         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
archive_this_fileset (struct s_bkpinfo *bkpinfo, char *filelist, char *fname,
	      int setno)
{

	/** int ****************************************************************/
  int retval = 0;
  int res = 0;
  int tries = 0;
  int i = 0;
  static int free_ramdisk_space = 9999;

	/** buffers *************************************************************/
  char command[MAX_STR_LEN];
  char zipparams[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];

  if (bkpinfo->compression_level > 0)
    {
      sprintf (tmp, "%s/do-not-compress-these", g_mondo_home);
      sprintf (zipparams, "-Z -b %ld -P %s -M 16m -G %d -T 3k", TAPE_BLOCK_SIZE, bkpinfo->zip_exe, bkpinfo->compression_level);
      if (does_file_exist(tmp))
	{ strcat (zipparams, " -E "); strcat (zipparams, tmp); }
      else
	{ log_it("%s not found. Cannot exclude zipfiles, etc.", tmp); }
    }
  else
    {
      sprintf (zipparams, "-b %ld", TAPE_BLOCK_SIZE);
    }
  if (!does_file_exist (filelist))
    {
      sprintf (tmp, "(archive_this_fileset) - filelist %s does not exist", filelist);
      log_to_screen (tmp);
      fatal_error( "Internel error. ");
    }
  sprintf (command, "rm -f %s %s. %s.gz %s.%s", fname, fname, fname, fname,
	   bkpinfo->zip_suffix);
  system (command);

  sprintf (command, "cat %s | afio -o %s %s 2>> %s", filelist, zipparams, fname, MONDO_LOGFILE);
  for(res=99,tries=0; tries<3 && res!=0; tries++)
    {
      res = system (command);
      if (res)
        {
          log_it ("(archive_this_fileset) '%s' failed", command);
          log_it( "Attempt #%d failed. Pausing 3 seconds and retrying...", tries+1);
          sleep(3);
        }
    }
  retval += res;
  if (retval) { log_it("Failed to write set %d", setno); }
  else if (tries>1) { log_it("Succeeded in writing set %d, on try #%d", setno, tries); }

  i = atoi( call_program_and_get_last_line_of_output ("df -m | grep dev/shm | grep -v none | tr -s ' ' '\t' | cut -f4"));
  if (i>0)
    {
      if (free_ramdisk_space > i)
        {
          free_ramdisk_space = i;
          log_it("min(free_ramdisk_space) is now %d", free_ramdisk_space);
        }
    }
  return (retval);
}









int backup_data(struct s_bkpinfo *bkpinfo)
{
int retval=0, res=0;
//char tmp[MAX_STR_LEN];

      if ((res=prepare_filelist (bkpinfo))) /* generate scratchdir/filelist.full */
	{ fatal_error ("Failed to generate filelist catalog"); }
      call_filelist_chopper (bkpinfo);
      copy_mondo_and_mindi_stuff_to_scratchdir (bkpinfo);
      if (figure_out_kernel_path_interactively_if_necessary(bkpinfo->kernel_path))
        { fatal_error ("Kernel not found. Please specify manually with the '-k' switch."); }
      if ((res = call_mindi_to_supply_boot_disks (bkpinfo)))
	{ fatal_error ("Failed to generate boot+data disks"); }

      retval += do_that_initial_phase (bkpinfo);
      retval += make_those_afios_phase (bkpinfo);
      retval += make_those_slices_phase (bkpinfo);
      retval += do_that_final_phase (bkpinfo);
      log_it ("Creation of archives... complete.");
      if (bkpinfo->verify_data) { sleep(2); }
      return(retval);
}






/*************************************************************************
 * call_mindi_to_supply_boot_disk() -- Hugo Rabson 			 *
 *                                                                       *
 * Purpose:   Call MINDI LINUX to generate boot+data disks for bootable  *
 *            Mondo CD and/or tape.                                      *
 * Called by: backup_data()                                              *
 * Params:    bkpinfo        configuration structure                     *
 * Returns:   0=success; nonzero=failure                                 *
 *************************************************************************/
int
call_mindi_to_supply_boot_disks (struct s_bkpinfo *bkpinfo)
{
	/** buffer *************************************************************/
  char *tmp;
        char *scratchdir;
	char command[MAX_STR_LEN*3];
	char *use_lzo_sz;
        char *use_comp_sz;
	char *bootldr_str;
	char *tape_device;
	char *last_filelist_number;
	char *broken_bios_sz;
	char *cd_recovery_sz;
	char *tape_size_sz;
	char *devs_to_exclude;
        char *use_lilo_sz;
        char *value;
	char *bootdev;



	/** char ***************************************************************/
	char ch = '\0';
	
	/** long     ***********************************************************/
  long lines_in_filelist = 0;

	/** int 	**************************************************************/
  int res	= 0;
  long estimated_total_noof_slices = 0;

malloc_global_string ( tmp );
malloc_global_string ( scratchdir );
malloc_global_string ( use_lzo_sz );
malloc_global_string ( use_comp_sz );
malloc_global_string ( bootldr_str );
malloc_global_string ( tape_device );
malloc_global_string ( last_filelist_number );
malloc_global_string ( broken_bios_sz );
malloc_global_string ( cd_recovery_sz );
malloc_global_string ( tape_size_sz );
malloc_global_string ( devs_to_exclude );
malloc_global_string ( use_lilo_sz );
malloc_global_string ( value );
malloc_global_string ( bootdev );

  strcpy( scratchdir, bkpinfo->scratchdir);
  sprintf (tmp,
	   "echo \"%s\" | tr -s ' ' '\n' | grep -x \"/dev/.*\" | tr -s '\n' ' ' | awk '{print $0\"\\n\";}'",
	   bkpinfo->exclude_paths);
  strcpy (devs_to_exclude, call_program_and_get_last_line_of_output (tmp));
  sprintf (tmp, "devs_to_exclude = '%s'", devs_to_exclude);
  log_it (tmp);
  mvaddstr_and_log_it (g_currentY, 0,
		       "Calling MINDI to create boot+data disks");
  sprintf (tmp, "%s/filelist.full", bkpinfo->tmpdir);
  lines_in_filelist = count_lines_in_file (tmp);
  sprintf (tmp, "%s/LAST-FILELIST-NUMBER", bkpinfo->tmpdir);
  strcpy (last_filelist_number, last_line_of_file (tmp));
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    {
      sprintf (tape_size_sz, "%ld", bkpinfo->media_size[1]);
      strcpy (tape_device, bkpinfo->media_device);
    }
  else
    {
      tape_size_sz[0] = '\0';
      tape_device[0] = '\0';
    }
  if (bkpinfo->use_lzo)
    {
      strcpy (use_lzo_sz, "yes");
    }
  else
    {
      strcpy (use_lzo_sz, "no");
    }
  if (bkpinfo->compression_level>0)
    {
      strcpy (use_comp_sz, "yes");
    }
  else
    {
      strcpy (use_comp_sz, "no");
    }

  strcpy (broken_bios_sz, "yes");	/* assume so */
  if (g_cd_recovery)
    {
      strcpy (cd_recovery_sz, "yes");
    }
  else
    {
      strcpy (cd_recovery_sz, "no");
    }
  if (bkpinfo->make_cd_use_lilo)
    {
      strcpy (use_lilo_sz, "yes");
    }
  else
    {
      strcpy (use_lilo_sz, "no");
    }
  log_it("bkpinfo->boot_loader = '%c'; bkpinfo->boot_device = '%s'", bkpinfo->boot_loader, bkpinfo->boot_device);
  if (!bkpinfo->nonbootable_backup && (bkpinfo->boot_loader == '\0' || bkpinfo->boot_device[0] == '\0'))
    {
      strcpy (bootdev, call_program_and_get_last_line_of_output
#ifdef __FreeBSD__
		("mount | grep ' / ' | head -1 | cut -d' ' -f1 | sed 's/\\([0-9]\\).*/\\1/'")
#else
	        ("mount | grep ' / ' | head -1 | cut -d' ' -f1 | sed 's/[0-9].*//'")
#endif
		);
      strcpy (bootdev, call_program_and_get_last_line_of_output
#ifdef __FreeBSD__
		("mount | grep ' / ' | head -1 | cut -d' ' -f1 | sed 's/\\([0-9]\\).*/\\1/'")
#else
	        ("mount | grep ' / ' | head -1 | cut -d' ' -f1 | sed 's/[0-9].*//'")
#endif
		);
      ch = which_boot_loader (bootdev);
      log_it("which_boot_loader() returned '%c'", ch);
      if (bkpinfo->boot_loader != '\0')
        {
          sprintf (tmp, "User specified boot loader. It is '%c'.",
    	       bkpinfo->boot_loader);
          log_it (tmp);
        }
      else
        {
          bkpinfo->boot_loader = ch;
        }
      if (bkpinfo->boot_device[0] != '\0')
        {
          sprintf (tmp, "User specified boot device. It is '%s'.",
    	       bkpinfo->boot_device);
          log_it (tmp);
        }
      else
        {
          strcpy (bkpinfo->boot_device, bootdev);
        }
    }

  if (bkpinfo->boot_loader != 'L' && bkpinfo->boot_loader != 'G' && bkpinfo->boot_loader != 'R' && !bkpinfo->nonbootable_backup)
    {
      fatal_error
	("Please specify your boot loader and device, e.g. -l GRUB -f /dev/hda. Type 'man mondoarchive' to read the manual.");
    }
  if (bkpinfo->boot_loader == 'L')
    {
      strcpy (bootldr_str, "LILO");
      if (!does_file_exist("/etc/lilo.conf"))
        { fatal_error("The de facto standard location for your boot loader's config file is /etc/lilo.conf but I cannot find it there. What is wrong with your Linux distribution?"); }
    }
  else if (bkpinfo->boot_loader == 'G')
    {
      strcpy (bootldr_str, "GRUB");
      if (!does_file_exist("/etc/grub.conf") && does_file_exist("/boot/grub/grub.conf"))
	{
	  run_program_and_log_output("ln -sf /boot/grub/grub.conf /etc/grub.conf", TRUE);
	}
      if (!does_file_exist("/etc/grub.conf")) 
	{ fatal_error("The de facto standard location for your boot loader's config file is /etc/grub.conf but I cannot find it there. What is wrong with your Linux distribution? Try 'ln -s /boot/grub/menu.lst /etc/grub.conf'..."); }
      /*
      else
	{
	  if (!run_program_and_log_output("cat /etc/grub.conf | grep \"md[0-9]\"", TRUE) | \
	      !run_program_and_log_output("cat /boot/grub/device.map | grep \"md[0-9]\"", TRUE))
	    {
	      if (!ask_me_yes_or_no("Owing to a bug in GRUB's grub-install, you may not use a software RAID device as a boot device. If you hassle me enough, I'll fix the bugs in grub-install. :) Otherwise, please use LILO."))
		{ fatal_error("Bug in grub-install. Mondoarchive will now exit."); }
	    }
	}
      */
    }
  else if (bkpinfo->boot_loader == 'R')
    {
      strcpy (bootldr_str, "RAW");
    }
  else
    {
      strcpy (bootldr_str, "unknown");
    }
  sprintf (tmp, "Your boot loader is %s and it boots from %s", bootldr_str,
	   bkpinfo->boot_device);
  log_to_screen (tmp);
  sprintf (tmp, "%s/BOOTLOADER.DEVICE", bkpinfo->tmpdir);
  write_one_liner_data_file (tmp, bkpinfo->boot_device);
  switch(bkpinfo->backup_media_type)
    {
      case cdr: strcpy(value, "cdr"); break;
      case cdrw: strcpy(value, "cdrw"); break;
      case cdstream: strcpy(value, "cdstream"); break;
      case tape: strcpy(value, "tape"); break;
      case udev: strcpy(value, "udev"); break;
      case iso: strcpy(value, "iso"); break;
      case nfs: strcpy(value, "nfs"); break;
      default: fatal_error("Unknown backup_media_type");
    }
  sprintf (tmp, "%s/BACKUP-MEDIA-TYPE", bkpinfo->tmpdir);
  write_one_liner_data_file (tmp, value);
  log_to_screen(bkpinfo->tmpdir);
  sprintf (tmp, "%s/BOOTLOADER.NAME", bkpinfo->tmpdir);
  write_one_liner_data_file (tmp, bootldr_str);
  sprintf (tmp, "%s/DIFFERENTIAL", bkpinfo->tmpdir);
  if (bkpinfo->differential)
    {
      write_one_liner_data_file (tmp, "1");
    }
  else
    {
      write_one_liner_data_file (tmp, "0");
    }
  estimated_total_noof_slices =
    size_of_all_biggiefiles_K (bkpinfo) / bkpinfo->optimal_set_size + 1;
/* add nfs stuff here? */
  sprintf (command, "mkdir -p %s/images", bkpinfo->scratchdir);
  system (command);
  sprintf (command, "mkdir -p %s/mnt/floppy", bkpinfo->scratchdir);
  system (command);
  sprintf (tmp, "BTW, I'm telling Mindi your kernel is '%s'",
	   bkpinfo->kernel_path);
//  log_it(tmp);
  sprintf (command,
	   "mindi --custom %s %s/images \"%s\" \"%s\" \"%s\" %ld \"%s\" %s \"%s\" %s %s %ld \"%s\" %s %s",
	   bkpinfo->tmpdir, bkpinfo->scratchdir, bkpinfo->kernel_path,
	   tape_device, tape_size_sz, lines_in_filelist, use_lzo_sz,
	   cd_recovery_sz, bkpinfo->image_devs, broken_bios_sz,
	   last_filelist_number, estimated_total_noof_slices,
	   devs_to_exclude, use_comp_sz, use_lilo_sz);
// Watch it! This next line adds a parameter...
  if (bkpinfo->nonbootable_backup) { strcat(command, " NONBOOTABLE"); }
  log_it (command);

  res = run_program_and_log_to_screen (command, "Generating boot+data disks");
  if (bkpinfo->nonbootable_backup) { res=0; } // hack
  if (!res)
    {
      log_to_screen ("Boot+data disks were created OK");
      sprintf (command, "mv -f %s/images/mindi.iso /root/images/mindi",
    	   bkpinfo->scratchdir);
      log_it (command);
      run_program_and_log_output (command, FALSE);
      if (bkpinfo->nonbootable_backup)
        {
          sprintf(command, "cp -f %s/all.tar.gz %s/images", bkpinfo->tmpdir, bkpinfo->scratchdir);
          if (system(command)) { fatal_error("Unable to create temporary duff tarball"); }
        }
      sprintf (tmp, "cp -f %s/images/all.tar.gz %s", bkpinfo->scratchdir, bkpinfo->tmpdir);
      if (system (tmp)) { fatal_error ("Cannot find all.tar.gz in tmpdir"); }
      if (res) { mvaddstr_and_log_it (g_currentY++, 74, "Errors."); }
      else {  mvaddstr_and_log_it (g_currentY++, 74, "Done."); }
    }
  else
    {
      log_to_screen ("Mindi failed to create your boot+data disks.");
      sprintf (command, "cat %s | grep \"Fatal error\"", "/var/log/mindi.log");
      strcpy (tmp, call_program_and_get_last_line_of_output (command));
      if (strlen (tmp) > 1)
        {
          log_to_screen (tmp);
        }
    }

  free(tmp); free(use_lzo_sz); free(scratchdir); 
  free(use_comp_sz); free(bootldr_str); free(tape_device);
  free(last_filelist_number); free(broken_bios_sz); free(cd_recovery_sz);
  free(tape_size_sz); free(devs_to_exclude); free(use_lilo_sz); free(value);
  free(bootdev);
  return (res);
}




#define MAX_NOOF_SETS_HERE 32767
#define BKPINFO_LOC_OFFSET (16+MAX_NOOF_SETS_HERE/8+16)
void *create_afio_files_in_background(void*inbuf)
{
  int archiving_set_no;
  char archiving_filelist_fname[MAX_STR_LEN];
  char archiving_afioball_fname[MAX_STR_LEN];
  struct s_bkpinfo*bkpinfo;
  char tmp[MAX_STR_LEN];
  int res=0, retval=0;
  int *p_archival_threads_running;
  int *p_last_set_archived;
  int *p_next_set_to_archive;
  char *p_list_of_fileset_flags;

  p_last_set_archived = (int*)inbuf;
  p_archival_threads_running = (int*)(inbuf+4);
  p_next_set_to_archive = (int*)(inbuf+8);
  p_list_of_fileset_flags = (char*)(inbuf+12);
  bkpinfo = (struct s_bkpinfo*)(inbuf+BKPINFO_LOC_OFFSET);
  /*
  if ((sem_id = semget((key_t)g_sem_key, 1, IPC_CREAT | S_IREAD | S_IWRITE))==-1)
    { fatal_error("CAFIB - unable to semget"); }
  log_it("Initialized a semaphore. Yay.");
  */
  //  sleep(1);
  sprintf(archiving_filelist_fname, FILELIST_FNAME_RAW_SZ, bkpinfo->tmpdir, 0);
  for (archiving_set_no = 0; does_file_exist (archiving_filelist_fname);
       sprintf (archiving_filelist_fname, FILELIST_FNAME_RAW_SZ, bkpinfo->tmpdir,
		archiving_set_no))
    {
      //      log_it("[%d] - waiting", (int)getpid());
      if (!semaphore_p()) { log_it("P sem failed (pid=%d)", (int)getpid()); fatal_error("Cannot get semaphore P"); }
      if (archiving_set_no < *p_next_set_to_archive)
	{
	  archiving_set_no= *p_next_set_to_archive; 
	}
      *p_next_set_to_archive = *p_next_set_to_archive + 1;
      if (!semaphore_v()) { fatal_error("Cannot get semaphore V"); }

      /* backup this set of files */
      sprintf (archiving_afioball_fname, AFIOBALL_FNAME_RAW_SZ, bkpinfo->tmpdir,
               archiving_set_no, bkpinfo->zip_suffix);
      sprintf (archiving_filelist_fname, FILELIST_FNAME_RAW_SZ, bkpinfo->tmpdir,
	       archiving_set_no);
      if (!does_file_exist(archiving_filelist_fname))
	{
	  log_it("%s[%d] - well, I would archive %d, except that it doesn't exist. I'll stop now.", FORTY_SPACES, getpid(), archiving_set_no);
	  break;
	}

      sprintf (tmp, AFIOBALL_FNAME_RAW_SZ, bkpinfo->tmpdir, archiving_set_no-ARCH_BUFFER_NUM, bkpinfo->zip_suffix);
      if (does_file_exist(tmp))
	{
	  log_it("%s[%d] - waiting for storer to catch up", FORTY_SPACES, getpid());
	  while (does_file_exist(tmp))
	    {
	      sleep(1);
	    }
	  log_it("[%d] - continuing", getpid());
	} 
      log_it("%s[%d] - archiving %d...", FORTY_SPACES, getpid(), archiving_set_no);
      res = archive_this_fileset (bkpinfo, archiving_filelist_fname, archiving_afioball_fname,
				  archiving_set_no);
      retval += res;
      if (res)
	{
	  sprintf (tmp,
		   "Errors occurred while archiving set %d. Please review logs.",
		   archiving_set_no);
	  log_to_screen (tmp);
	}
      if (!semaphore_p()) { fatal_error("Cannot get semaphore P"); }

      set_bit_N_of_array(p_list_of_fileset_flags, archiving_set_no, TRUE);

      if (*p_last_set_archived < archiving_set_no)
	{ *p_last_set_archived = archiving_set_no; } // finished archiving this one

      if (!semaphore_v()) { fatal_error("Cannot get semaphore V"); }
      log_it("%s[%d] - archived %d OK", FORTY_SPACES, getpid(), archiving_set_no);
      archiving_set_no ++;
    }
  if (!semaphore_p()) { fatal_error("Cannot get semaphore P"); }
  (*p_archival_threads_running) --;
  if (!semaphore_v()) { fatal_error("Cannot get semaphore V"); }
  //  log_it("[%d] - *p_archival_threads_running has been decremented. It is now %d.", getpid(), *p_archival_threads_running);
  log_it("%s[%d] - exiting", FORTY_SPACES, getpid());
  pthread_exit(NULL);
}







/*************************************************************************
 * do_that_final_phase() -- Hugo Rabson                             *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
do_that_final_phase (struct s_bkpinfo *bkpinfo)
{

	/** int ***************************************/
  int res = 0;
  int retval = 0;
//  int i;

	/** buffers ***********************************/
//  char blk[1024];
//  pid_t pid;

  mvaddstr_and_log_it (g_currentY, 0, "Writing any remaining data to media");
/*
  pid=fork();
  switch(pid)
    {
      case -1: fatal_error("Forking error");
      case 0: 
*/

  log_it ("Closing tape/CD ... ");
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    /* write tape/cdstream */
    {
      closeout_tape(bkpinfo);
    }
  else
    /* write final ISO */
    {
      res = write_final_iso_if_necessary (bkpinfo);
      retval += res;
      if (res)
	{
	  log_it ("write_final_iso_if_necessary returned an error");
	}
    }
  log_it ("Fork is exiting ... ");
/*
        exit(0);
      default:
        open_evalcall_form("Writing any remaining data to media");
        while(!waitpid(pid, (int*)0, WNOHANG))
          {
            sleep(1);
            update_evalcall_form(0);
          }
        close_evalcall_form();
*/

  mvaddstr_and_log_it (g_currentY++, 74, "Done.");
  /* final stuff */
  if (retval)
    {
      mvaddstr_and_log_it (g_currentY++, 74, "Errors.");
    }
  else
    {
      mvaddstr_and_log_it (g_currentY++, 74, "Done.");
    }

/*
    }
*/


  return (retval);
}



/*************************************************************************
 * do_that_initial_phase() -- Hugo Rabson                           *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
do_that_initial_phase (struct s_bkpinfo *bkpinfo)
{
	/** int ****************************************/
  int retval = 0;

	/** buffers ************************************/
  char command[MAX_STR_LEN*2];
  char tmpfile[MAX_STR_LEN];
  char data_file[MAX_STR_LEN];

      sprintf (data_file, "%s/all.tar.gz", bkpinfo->tmpdir);

  snprintf (g_serial_string, MAX_STR_LEN-1, \
call_program_and_get_last_line_of_output("dd \
if=/dev/random bs=16 count=1 2> /dev/null | \
hexdump | tr -s ' ' '0' | head -n1"));
  strip_spaces(g_serial_string);
  strcat(g_serial_string, "...word.");
  log_it("g_serial_string = '%s'", g_serial_string);
  assert(strlen(g_serial_string) < MAX_STR_LEN);
  sprintf(tmpfile, "%s/archives/SERIAL-STRING", bkpinfo->scratchdir);
  if (write_one_liner_data_file (tmpfile, g_serial_string)) { log_it("%ld: Failed to write serial string", __LINE__); }

  mvaddstr_and_log_it (g_currentY, 0, "Preparing to archive your data");
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    {
      if (bkpinfo->backup_media_type == cdstream)
        {
          openout_cdstream (bkpinfo->media_device, bkpinfo->cdrw_speed);
        }
      else
        {
          openout_tape (bkpinfo->media_device);	/* sets g_tape_stream */
        }
      if (!g_tape_stream)
	{
	  fatal_error ("Cannot open backup (streaming) device");
	}
      log_it ("Backup (stream) opened OK");
      write_data_disks_to_stream (data_file);
    }
  else
    {
      log_it ("Backing up to CD's");
    }

  sprintf (command, "rm -f %s/*.iso", bkpinfo->isodir);
  system (command);
  wipe_archives (bkpinfo->scratchdir);
  mvaddstr_and_log_it (g_currentY++, 74, "Done.");
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    {
      write_header_block_to_stream (0, "start-of-tape", BLK_START_OF_TAPE);
      write_header_block_to_stream (0, "start-of-backup", BLK_START_OF_BACKUP);
    }
  return (retval);
}








/*************************************************************************
 * format_disk_SUB() -- Hugo Rabson       											         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
format_disk_SUB (char *cmd, char *title)
{

	/** int ****************************************************************/
  int res = 0;
	int percentage = 0;
	int maxtracks = 0;
	int trackno = 0;
	int last_trkno = 0;

	/** buffers ************************************************************/
  char command[MAX_STR_LEN*2];
	char tempfile[MAX_STR_LEN];

	/** pointers ***********************************************************/
  FILE *pin;



/* if Debian then do bog-standard superformat; don't be pretty */
  if (strstr (cmd, "superformat"))
    {
      return (run_program_and_log_to_screen (cmd, title));
    }
/* if not Debian then go ahead & use fdformat */
  strcpy (tempfile,
	  call_program_and_get_last_line_of_output
	  ("mktemp -q /tmp/mondo.XXXXXXXX"));
  sprintf (command, "%s >> %s 2>> %s; rm -f %s", cmd, tempfile, tempfile,
	   tempfile);
  log_it (command);
  open_evalcall_form (title);
  if (!(pin = popen (command, "r")))
    {
      log_to_screen ("fmt err");
      return (1);
    }
  if (strstr (command, "1722"))
    {
      maxtracks = 82;
    }
  else
    {
      maxtracks = 80;
    }
  for (sleep (1); does_file_exist (tempfile); sleep (1))
    {
      trackno = get_trackno_from_logfile (tempfile);
      if (trackno < 0 || trackno > 80)
	{
	  log_it ("Weird track#");
	  continue;
	}
      percentage = trackno * 100 / maxtracks;
      if (trackno <= 5 && last_trkno > 40)
	{
	  close_evalcall_form ();
	  strcpy (title, "Verifying format");
	  open_evalcall_form (title);
	}
      last_trkno = trackno;
      update_evalcall_form (percentage);
    }
  close_evalcall_form ();
  pclose (pin);
  unlink (tempfile);
  return (res);
}

/*************************************************************************
 * format_disk() -- Hugo Rabson           											         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
format_disk (char *device)
{
	
	/** int ***************************************************************/
  int res = 0;

	/** buffer ************************************************************/
  char command[MAX_STR_LEN*2];
	char title[MAX_STR_LEN];



  if (!system ("which superformat > /dev/null 2> /dev/null"))
    {
      sprintf (command, "superformat %s", device);
    }
  else
    {
      sprintf (command, "fdformat %s", device);
    }
  sprintf (title, "Formatting disk %s", device);
  while ((res = format_disk_SUB (command, title)))
    {
      if (!ask_me_yes_or_no ("Failed to format disk. Retry?"))
	{
	  return (res);
	}
    }
  return (res);
}






bool get_bit_N_of_array(char*array, int N)
{
  int element_number;
  int bit_number;
  int mask;
  
  element_number = N / 8;
  bit_number = N % 8;
  mask = 1 << bit_number;
  if (array[element_number] & mask)
    { return(TRUE); }
  else
    { return(FALSE); }
}







/*************************************************************************
 * make_afioballs_and_images_OLD() -- Hugo Rabson                            *
 *                                                                       *
 * Purpose:   Single-threaded                                             *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
make_afioballs_and_images_OLD (struct s_bkpinfo *bkpinfo)
{

	/** int ***************************************************/
  int retval = 0;
  int curr_set_no = 0;
  int res = 0;

	/** buffers ***********************************************/
  char curr_filelist_fname[MAX_STR_LEN];
  char curr_afioball_fname[MAX_STR_LEN];
  char tmp[MAX_STR_LEN*2];
  char media_usage_comment[MAX_STR_LEN];




  sprintf (tmp, "%s/archives/filelist.full", bkpinfo->scratchdir);

  log_to_screen ("Archiving regular files");

  open_progress_form ("Backing up filesystem",
		      "I am backing up your live filesystem now.",
		      "Please wait. This may take a couple of hours.",
		      "Working...", get_last_filelist_number (bkpinfo) + 1);

  sprintf (curr_filelist_fname, "%s/filelist.%d", bkpinfo->tmpdir, 0);

  for (curr_set_no = 0; does_file_exist (curr_filelist_fname);
       sprintf (curr_filelist_fname, "%s/filelist.%d", bkpinfo->tmpdir,
		++curr_set_no))
    {
      /* backup this set of files */
      sprintf (curr_filelist_fname, "%s/filelist.%d", bkpinfo->tmpdir,
	       curr_set_no);
      sprintf (curr_afioball_fname, "%s/tmpfs/%d.afio.%s", bkpinfo->tmpdir,
	       curr_set_no, bkpinfo->zip_suffix);
      log_it ("Archiving set %d", curr_set_no);
      res =
	archive_this_fileset (bkpinfo, curr_filelist_fname, curr_afioball_fname,
		      curr_set_no);
      retval += res;
      if (res)
	{
	  sprintf (tmp,
		   "Errors occurred while archiving set %d. Perhaps your live filesystem changed?",
		   curr_set_no);
	  log_to_screen (tmp);
	}

      strcpy (media_usage_comment, percent_media_full_comment (bkpinfo));

      /* copy to CD (scratchdir) ... and an actual CD-R if necessary */
      if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
        {
          res = move_files_to_stream (bkpinfo, curr_afioball_fname, NULL);
        }
      else
        {
          res = move_files_to_cd (bkpinfo, curr_filelist_fname, curr_afioball_fname, NULL);
        }
      retval += res;
      g_current_progress++;
      update_progress_form (media_usage_comment);

      if (res)
	{
	  sprintf (tmp, "Failed to add archive %d's files to CD dir\n",
		   curr_set_no);
	  log_to_screen (tmp);
	  fatal_error
	    ("Is your hard disk is full? If not, please send the author the logfile.");
	}
    }
  close_progress_form ();
  sprintf (tmp, "Your regular files have been archived ");
  if (retval)
    {
      strcat (tmp, "(with errors).");
    }
  else
    {
      strcat (tmp, "successfully.");
    }
  log_to_screen (tmp);
  return (retval);
}





/*************************************************************************
 * make_afioballs_and_images() -- Hugo Rabson                            *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
make_afioballs_and_images (struct s_bkpinfo *bkpinfo)
{

	/** int ***************************************************/
  int retval = 0;
  int storing_set_no = 0;
  int res = 0;
  bool done_storing=FALSE;
  char result_str[MAX_STR_LEN];
  char *transfer_block;
  void*vp;
  void**pvp;

	/** buffers ***********************************************/
  char storing_filelist_fname[MAX_STR_LEN];
  char storing_afioball_fname[MAX_STR_LEN];
  char tmp[MAX_STR_LEN*2];
  char media_usage_comment[MAX_STR_LEN];
  pthread_t archival_thread[ARCH_THREADS];
  char *p_list_of_fileset_flags;
  int *p_archival_threads_running;
  int *p_last_set_archived;
  int *p_next_set_to_archive;
  int noof_threads;
  int i;

  transfer_block = malloc(sizeof(struct s_bkpinfo)+BKPINFO_LOC_OFFSET+32);
  memset((void*)transfer_block, 0, sizeof(struct s_bkpinfo)+BKPINFO_LOC_OFFSET+32);
  p_last_set_archived = (int*)transfer_block;
  p_archival_threads_running = (int*)(transfer_block+4);
  p_next_set_to_archive = (int*)(transfer_block+8);
  p_list_of_fileset_flags = (char*)(transfer_block+12);
  memcpy((void*)(transfer_block+BKPINFO_LOC_OFFSET), (void*)bkpinfo, sizeof(struct s_bkpinfo));
  pvp=&vp;
  vp=(void*)result_str;
  *p_archival_threads_running = 0;
  *p_last_set_archived = -1;
  *p_next_set_to_archive = 0;
  sprintf (tmp, "%s/archives/filelist.full", bkpinfo->scratchdir);
  log_to_screen ("Archiving regular files");
  open_progress_form ("Backing up filesystem",
		      "I am backing up your live filesystem now.",
		      "Please wait. This may take a couple of hours.",
		      "Working...", get_last_filelist_number (bkpinfo) + 1);

  srand((unsigned int)getpid());
  g_sem_key = 1234+random()%30000;
  if ((g_sem_id = semget((key_t)g_sem_key, 1, IPC_CREAT|S_IREAD|S_IWRITE))==-1)
    { fatal_error("MABAI - unable to semget"); }
  if (!set_semvalue())
    { fatal_error("Unable to init semaphore"); } // initialize semaphore
  //  log_it("g_sem_key = %d", g_sem_key);
  for(noof_threads=0; noof_threads<ARCH_THREADS; noof_threads++)
    {
      (*p_archival_threads_running) ++;
      if ((res = pthread_create(&archival_thread[noof_threads], NULL, create_afio_files_in_background, (void*)transfer_block)))
	{ fatal_error("Unable to create an archival thread"); }
    }

  while(!done_storing)
    {
      if (*p_archival_threads_running == 0 && *p_last_set_archived == storing_set_no-1) 
	{ 
	  log_it("No archival threads are running. The last stored set was %d and I'm looking for %d. Take off your make-up; the party's over... :-)", *p_last_set_archived, storing_set_no); 
	  done_storing = TRUE;
	}
      else if (!get_bit_N_of_array(p_list_of_fileset_flags, storing_set_no))
	{
	  //	  log_it("Waiting for fileset %d", storing_set_no);
	  sleep(1);
	}
      else
	// store set N
	{
	  sprintf (storing_filelist_fname, FILELIST_FNAME_RAW_SZ, bkpinfo->tmpdir,
		   storing_set_no);
	  sprintf (storing_afioball_fname, AFIOBALL_FNAME_RAW_SZ, bkpinfo->tmpdir,
		   storing_set_no, bkpinfo->zip_suffix);
	  log_it ("Storing set %d", storing_set_no);
	  while(!does_file_exist(storing_filelist_fname) || !does_file_exist(storing_afioball_fname))
	    {
	      log_it("Warning - either %s or %s doesn't exist yet. I'll pause 5 secs.", storing_filelist_fname, storing_afioball_fname);
	      sleep(5);
	    }
	  strcpy (media_usage_comment, percent_media_full_comment (bkpinfo));
	  /* copy to CD (scratchdir) ... and an actual CD-R if necessary */
	  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
	    {
	      res = move_files_to_stream (bkpinfo, storing_afioball_fname, NULL);
	    }
	  else
	    {
	      res = move_files_to_cd (bkpinfo, storing_filelist_fname, storing_afioball_fname, NULL);
	    }
	  retval += res;
	  g_current_progress++;
	  update_progress_form (media_usage_comment);
	  if (res)
	    {
	      sprintf (tmp, "Failed to add archive %d's files to CD dir\n",
		       storing_set_no);
	      log_to_screen (tmp);
	      fatal_error
		("Is your hard disk is full? If not, please send the author the logfile.");
		}
	  storing_set_no++;
	  //	  sleep(2);
	}
    }
  close_progress_form ();
  sprintf (tmp, "Your regular files have been archived ");
  log_it("Joining background threads to foreground thread");
  for(i=0; i<noof_threads; i++)
    {
      pthread_join(archival_thread[i], pvp);
      log_it("Thread %d of %d: closed OK", i, noof_threads);
    }
  del_semvalue();
  log_it("Done.");
  if (retval)
    {
      strcat (tmp, "(with errors).");
    }
  else
    {
      strcat (tmp, "successfully.");
    }
  log_to_screen (tmp);
  free(transfer_block);
  return (retval);
}







/*************************************************************************
 * make_iso_fs() -- Hugo Rabson                                          *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
make_iso_fs (struct s_bkpinfo *bkpinfo, char *destfile)
{
	/** int ***********************************************/
  int retval = 0;
  int res;

	/** buffers *******************************************/
  char old_pwd[MAX_STR_LEN];
  char tmp[MAX_STR_LEN*2];
  char result_sz[MAX_STR_LEN];
  char message_to_screen[MAX_STR_LEN];

  if (bkpinfo->backup_media_type == iso && bkpinfo->manual_cd_tray)
    {
      popup_and_OK("Please insert new media and press Enter.");
    }

  log_it ("make_iso_fs --- scratchdir=%s --- destfile=%s",
	   bkpinfo->scratchdir, destfile);
  getcwd (old_pwd, MAX_STR_LEN - 1);
  sprintf (tmp, "chmod 744 %s", bkpinfo->scratchdir);
  run_program_and_log_output(tmp, FALSE);
  chdir (bkpinfo->scratchdir);

  if (bkpinfo->call_before_iso[0] != '\0')
    {
      sprintf (message_to_screen, "Running pre-ISO call for CD#%d",
	       g_current_media_number);
      res =
	eval_call_to_make_ISO (bkpinfo, bkpinfo->call_before_iso, destfile,
		   g_current_media_number, MONDO_LOGFILE, message_to_screen);
      if (res)
	{
	  strcat (message_to_screen, "...failed");
	}
      else
	{
	  strcat (message_to_screen, "...OK");
	}
      log_to_screen (message_to_screen);
      retval += res;
    }

  if (bkpinfo->call_make_iso[0] != '\0')
    {
      log_it("bkpinfo->call_make_iso = %s", bkpinfo->call_make_iso);
      sprintf (tmp, "%s/archives/NOT-THE-LAST", bkpinfo->scratchdir);
      sprintf (message_to_screen, "Making an ISO (CD #%d)",
	       g_current_media_number);

      pause_and_ask_for_cdr (2);	/* if g_current_media_number >= 2 then pause & ask */

      res =
	eval_call_to_make_ISO (bkpinfo, bkpinfo->call_make_iso, bkpinfo->scratchdir,
		   g_current_media_number, MONDO_LOGFILE, message_to_screen);
      if (res)
	{
	  strcat (message_to_screen, "...failed");
	}
      else
	{
	  strcat (message_to_screen, "...OK");
	}
      log_to_screen (message_to_screen);
      retval += res;
    }
  else
    {
      sprintf (message_to_screen, "Running mkisofs to make CD #%d",
	       g_current_media_number);
      log_it (message_to_screen);
      sprintf (result_sz, "Call to mkisofs to make ISO (CD #%d) ",
	       g_current_media_number);
      if (bkpinfo->nonbootable_backup)
        {
          log_it("Making nonbootable backup");
// FIXME --- change mkisofs string to MONDO_MKISOFS_NONBOOTABLE and add ' .' at end
          res =
	    eval_call_to_make_ISO (bkpinfo,
		   "mkisofs -o _ISO_ -r -p MondoRescue -P www.microwerks.net/~hugo/ -A Mondo_Rescue_GPL -V _CD#_ .",
		   destfile, g_current_media_number, MONDO_LOGFILE,
		   message_to_screen);
        }
      else
        {
          log_it("Making bootable backup");
          if (bkpinfo->make_cd_use_lilo)
            {
// FIXME --- change mkisofs string to MONDO_MKISOFS_REGULAR_SYSLINUX/LILO depending on bkpinfo->make_cd_usE_lilo
// and add ' .' at end
              res =
                eval_call_to_make_ISO (bkpinfo,
                    "mkisofs -b images/mindi-boot.2880.img -c boot.cat -o _ISO_ -J -r -p MondoRescue -P www.microwerks.net/~hugo/ -A Mondo_Rescue_GPL -V _CD#_ .",
                    destfile, g_current_media_number, MONDO_LOGFILE,
                    message_to_screen);
            }
          else
            {
              res =
	        eval_call_to_make_ISO (bkpinfo,
		   "mkisofs -b isolinux.bin -c boot.cat -no-emul-boot -boot-load-size 4 -boot-info-table -o _ISO_ -r -p MondoRescue -P www.microwerks.net/~hugo/ -A Mondo_Rescue_GPL -V _CD#_ .",
		   destfile, g_current_media_number, MONDO_LOGFILE,
		   message_to_screen);
            }
        }
      if (res)
	{
	  strcat (result_sz, "...failed");
	}
      else
	{
	  strcat (result_sz, "...OK");
	}
      log_to_screen (result_sz);
      retval += res;
    }

  if (bkpinfo->backup_media_type == cdr || bkpinfo->backup_media_type == cdrw)
    {
      if (is_this_device_mounted(bkpinfo->media_device))
        {
          log_it("Warning - %s mounted. I'm unmounting it before I burn to it.", bkpinfo->media_device);
          sprintf(tmp, "umount %s", bkpinfo->media_device);
          run_program_and_log_output(tmp, FALSE);
        }
    }

  if (bkpinfo->call_burn_iso[0] != '\0')
    {
      log_it("bkpinfo->call_burn_iso = %s", bkpinfo->call_burn_iso);
      sprintf (message_to_screen, "Burning CD #%d",
	       g_current_media_number);
      pause_and_ask_for_cdr (2);
      res =
	eval_call_to_make_ISO (bkpinfo, bkpinfo->call_burn_iso, destfile,
		   g_current_media_number, MONDO_LOGFILE, message_to_screen);
      if (res)
	{
	  strcat (message_to_screen, "...failed");
	}
      else
	{
	  strcat (message_to_screen, "...OK");
	}
      log_to_screen (message_to_screen);
      retval += res;
    }

  if (bkpinfo->call_after_iso[0] != '\0')
    {
      sprintf (message_to_screen, "Running post-ISO call (CD #%d)",
	       g_current_media_number);
      res =
	eval_call_to_make_ISO (bkpinfo, bkpinfo->call_after_iso, destfile,
		   g_current_media_number, MONDO_LOGFILE, message_to_screen);
      if (res)
	{
	  strcat (message_to_screen, "...failed");
	}
      else
	{
	  strcat (message_to_screen, "...OK");
	}
      log_to_screen (message_to_screen);
      retval += res;
    }

  chdir (old_pwd);
  if (retval)
    {
      log_it ("WARNING - make_iso_fs returned an error");
    }
  return (retval);
}





/*************************************************************************
 * make_slices_and_images() -- Hugo Rabson                               *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
make_slices_and_images (struct s_bkpinfo *bkpinfo, char *biggielist_fname)
{

	/** pointers ********************************************/
  FILE *fin;
  char *p;

	/** buffers *********************************************/
  char tmp[MAX_STR_LEN*2];
  char bigfile_fname[MAX_STR_LEN];


	/** long ************************************************/
  long biggie_file_number = 0;
  long noof_biggie_files = 0;
  long estimated_total_noof_slices = 0;

	/** int *************************************************/
  int retval = 0;
  int res = 0;

	/** long long *******************************************/
  long long biggie_fsize;

  estimated_total_noof_slices =
    size_of_all_biggiefiles_K (bkpinfo) / bkpinfo->optimal_set_size + 4;

  log_it( "size of all biggiefiles = %ld",
	   size_of_all_biggiefiles_K (bkpinfo));
  log_it ("estimated_total_noof_slices = %ld KB / %ld KB = %ld",
	   size_of_all_biggiefiles_K (bkpinfo), bkpinfo->optimal_set_size,
	   estimated_total_noof_slices);

  if (length_of_file (biggielist_fname) < 6)
    {
      log_it ("No biggiefiles; fair enough...");
      return (0);
    }
  sprintf (tmp, "I am now backing up all large files.");
  log_to_screen (tmp);
  noof_biggie_files = count_lines_in_file (biggielist_fname);
  open_progress_form ("Backing up big files", tmp,
		      "Please wait. This may take some time.", "",
		      estimated_total_noof_slices);
  fin = fopen (biggielist_fname, "r");
  for (fgets (bigfile_fname, MAX_STR_LEN, fin); !feof (fin);
       fgets (bigfile_fname, MAX_STR_LEN, fin), biggie_file_number++)
    {
      if (bigfile_fname[strlen (bigfile_fname) - 1] < 32)
	{
	  bigfile_fname[strlen (bigfile_fname) - 1] = '\0';
	}
      biggie_fsize = length_of_file (bigfile_fname);
      if (!does_file_exist (bigfile_fname))
	{
	  sprintf (tmp, "Skipping bigfile %s (nonexistent)", bigfile_fname);
	}
      else
	{
	  sprintf (tmp, "Bigfile #%ld is '%s' (%ld KB)", biggie_file_number+1,
		   bigfile_fname, (long) biggie_fsize >> 10);
	  /*log_it(tmp); */
          if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
	    {
	      write_header_block_to_stream (biggie_fsize, bigfile_fname,
					  BLK_START_A_BIGGIE);
	    }
	  res =
	    slice_up_file_etc (bkpinfo, bigfile_fname, biggie_file_number,
			       noof_biggie_files);
          if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
	    {
	      write_header_block_to_stream (0,
					  calc_checksum_of_file
					  (bigfile_fname), BLK_STOP_A_BIGGIE);
	    }
	  retval += res;
	  p = strrchr (bigfile_fname, '/');
	  if (p)
	    {
	      p++;
	    }
	  else
	    {
	      p = bigfile_fname;
	    }
	  sprintf (tmp, "Archiving %s ... ", bigfile_fname);
	  if (res)
	    {
	      strcat (tmp, "Failed!");
	    }
	  else
	    {
	      strcat (tmp, "OK");
	    }
	}
#ifndef _XWIN
      if (!g_text_mode) { newtDrawRootText (0, 22, tmp); newtRefresh (); }
#endif
    }
  log_it ("Finished backing up bigfiles");
  log_it ("estimated slices = %ld; actual slices = %ld",
	   estimated_total_noof_slices, g_current_progress);
  close_progress_form ();
  fclose (fin);
  return (retval);
}



/*************************************************************************
 * make_those_afios_phase() -- Hugo Rabson                                *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
make_those_afios_phase (struct s_bkpinfo *bkpinfo)
{
	/** int ********************************************/
  int res = 0;
  int retval = 0;

  mvaddstr_and_log_it (g_currentY, 0, "Archiving regular files to media");

  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    {
      write_header_block_to_stream (0, "start-of-afioballs",
				  BLK_START_AFIOBALLS);
      res = make_afioballs_and_images_OLD (bkpinfo);
      write_header_block_to_stream (0, "stop-afioballs", BLK_STOP_AFIOBALLS);
    }
  else
    {
      res = make_afioballs_and_images (bkpinfo);
    }

  retval += res;
  if (res)
    {
      mvaddstr_and_log_it (g_currentY++, 74, "Errors.");
      log_it ("make_afioballs_and_images returned an error");
    }
  else
    {
      mvaddstr_and_log_it (g_currentY++, 74, "Done.");
    }
  return (retval);
}


/*************************************************************************
 * make_those_slices_phase() -- Hugo Rabson                               *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
make_those_slices_phase (struct s_bkpinfo *bkpinfo)
{

	/** int ******************************************************/
  int res = 0;
  int retval = 0;

	/** buffers ***************************************************/
  char biggielist[MAX_STR_LEN];
  char command[MAX_STR_LEN*2];
  char blah[MAX_STR_LEN];

  /* slice big files */

  mvaddstr_and_log_it (g_currentY, 0, "Archiving large files to media");
  sprintf (biggielist, "%s/archives/biggielist.txt", bkpinfo->scratchdir);
  sprintf (command, "cp %s/biggielist.txt %s", bkpinfo->tmpdir, biggielist);
  if (system (command))
    {
      log_it ("(make_those_slices_phase) '%s' failed", command);
    }
  sprintf (blah, "biggielist = %s", biggielist);
  log_it (blah);
  if (!does_file_exist (biggielist))
    {
      log_it ("BTW, the biggielist does not exist");
    }
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    {
      sprintf (blah, "%ld", count_lines_in_file (biggielist));
      write_header_block_to_stream (0, blah, BLK_START_BIGGIEFILES);
    }
  res = make_slices_and_images (bkpinfo, biggielist);
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    {
      write_header_block_to_stream (0, "end-of-biggiefiles",
				  BLK_STOP_BIGGIEFILES);
    }
  retval += res;
  if (res)
    {
      log_it ("make_slices_and_images returned an error");
      mvaddstr_and_log_it (g_currentY++, 74, "Errors.");
    }
  else
    {
      mvaddstr_and_log_it (g_currentY++, 74, "Done.");
    }
  return (retval);
}






/*************************************************************************
 * move_files_to_cd() -- Hugo Rabson                                     *
 *                                                                       *
 * Purpose:   Move files to the scratch directory where the files-to-be- *
 *            stored-on-the-next-CD are being stored until ISO is ready  *
 *            to be created.                                             *
 * Called by: add_afioballs_to_media, slice_up_files_etc()               *
 * Params:    bkpinfo        configuration structure                     *
 *            files_to_add   list of files to be moved to scratch dir.   *
 * Returns:   0=success; nonzero=failure                                 *
 * NB:        Last 'file' string must be NULL                            *
 *************************************************************************/
int
move_files_to_cd (struct s_bkpinfo *bkpinfo,
		 char *files_to_add, ...)
{

	/** int *************************************************************/
  int retval = 0;
	int res = 0;

	/** buffers *********************************************************/
  char tmp[MAX_STR_LEN*2],
       curr_file[MAX_STR_LEN], *cf;

	/** long *************************************************************/
  va_list ap;
  long long would_occupy;

  would_occupy = space_occupied_by_cd (bkpinfo->scratchdir);
  va_start(ap, files_to_add); // initialize the variable arguments
  for(cf = files_to_add; cf!=NULL; cf=va_arg(ap, char*))
    {
      if (!cf) {continue;}
      strcpy(curr_file, cf);
//      log_it("dum de dum -- '%s'", curr_file);
      if (!does_file_exist (curr_file))
	{
	  log_it("Warning - you're trying to add a non-existent file - '%s' to the CD", curr_file);
	}
      else
        {
          would_occupy += length_of_file (curr_file) / 1024;
        }
    }
  va_end(ap);

  if (bkpinfo->media_size[g_current_media_number]<=0) { fatal_error( "move_files_to_cd() - unknown media size"); }
  if (would_occupy / 1024 > bkpinfo->media_size[g_current_media_number])
    {
      res = write_iso_and_go_on (bkpinfo, FALSE);	/* FALSE because this is not the last CD we'll write */
      retval += res;
      if (res)
	{
	  log_it ("WARNING - write_iso_and_go_on returned an error");
	}
    }

  va_start(ap, files_to_add); // initialize the variable arguments
  for(cf = files_to_add; cf!=NULL; cf=va_arg(ap, char*))
    {
      if (!cf) {continue;}
      strcpy(curr_file, cf);
//      log_it("curr_file = %s", curr_file);

      sprintf (tmp, "mv -f %s %s/archives/", curr_file,
	       bkpinfo->scratchdir);
      res = run_program_and_log_output (tmp, FALSE);
      retval += res;
      if (res)
	{
	  log_it ("(move_files_to_cd) '%s' failed", tmp);
	}
      //      unlink (curr_file);
    }
  va_end(ap);

  if (retval)
    {
      log_it ("Warning - errors occurred while I was adding files to CD dir");
    }
  return (retval);
}










/*************************************************************************
 * offer_to_write_floppies() -- Hugo Rabson 										         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
offer_to_write_floppies (struct s_bkpinfo *bkpinfo, char *imagesdir)
{
	/** buffer *************************************************************/
  char tmp[MAX_STR_LEN];
	char comment[MAX_STR_LEN];
	char bootdisk_dev[MAX_STR_LEN];
	char datadisk_dev[MAX_STR_LEN];

	/** int ****************************************************************/
  int i	= 0;
	int res = 0;

	/** bool ***************************************************************/
  bool format_first;




  if (!ask_me_yes_or_no
      ("Write boot and data disk images to 3.5\" floppy disks?"))
    {
      return (0);
    }
  if (does_device_exist (DEFAULT_1722MB_DISK))
    {
      strcpy (bootdisk_dev, DEFAULT_1722MB_DISK);
    }
  else if (does_device_exist (BACKUP_1722MB_DISK))
    {
      sprintf (bootdisk_dev, "/dev/fd0H1722");
    }
  else
    {
      log_to_screen ("Can't find a 1.72MB floppy device *sigh*");
      return (1);
    }
  strcpy (datadisk_dev, "/dev/fd0");
  if (!does_device_exist (datadisk_dev))
    {
      log_to_screen ("Can't find a 1.44MB floppy device *sigh*");
      return (1);
    }
  format_first =
    ask_me_yes_or_no
    ("Do you want me to format the disks before I write to them?");
/* boot disk */
  if (ask_me_OK_or_cancel ("About to write 1.72MB boot disk"))
    {
      log_to_screen ("Writing boot floppy");
      if (format_first)
	{
	  format_disk (bootdisk_dev);
	}
      sprintf (tmp, "%s/mindi-boot.1722.img", imagesdir);
      write_image_to_floppy (bootdisk_dev, tmp);
    }
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    {
      log_to_screen
	("FYI, the data disks are stored on tape/CD for your convenience.");
      return (0);
    }
  for (i = 1; i < 99; i++)
    {
      sprintf (tmp, "%s/mindi-data-%d.img", imagesdir, i);
      log_it (tmp);
      if (!does_file_exist (tmp))
	{
	  log_it ("...not found");
	  break;
	}
      sprintf (comment, "About to write data disk #%d", i);
      if (ask_me_OK_or_cancel (comment))
	{
	  sprintf (comment, "Writing data disk #%3d", i);
	  log_to_screen (comment);
	  if (format_first)
	    {
	      res += format_disk (datadisk_dev);
	    }
	  res += write_image_to_floppy (datadisk_dev, tmp);
	}
    }
  return (res);
}










int offer_to_write_boot_floppies_to_physical_disks(struct s_bkpinfo *bkpinfo)
{
int res;
      mvaddstr_and_log_it (g_currentY, 0,
			   "Writing boot+data floppy images to disk");
      if (!does_file_exist ("/root/images/mindi/mindi-boot.1722.img"))
	{
	  mvaddstr_and_log_it (g_currentY++, 74, "No Imgs");
	  if (does_file_exist ("/root/images/mindi/mindi.iso"))
	    {
	      popup_and_OK
		("Boot+data floppy creation failed. However, FYI, you may burn /root/images/mindi/mindi.iso to a CD and boot from that instead if you wish.");
              res++;
	    }
	}
      else
	{
	  offer_to_write_floppies (bkpinfo, "/root/images/mindi");
	  mvaddstr_and_log_it (g_currentY++, 74, "Done.");
	}
  return(res);
}





/*************************************************************************
 * move_files_to_stream() -- Hugo Rabson                                 *
 *                                                                       *
 * Purpose:   Move files from filesystem to the tape. Split across tapes *
 *            if necessary.                                              *
 * Called by: add_afioballs_to_media, slice_up_files_etc()               *
 * Params:    bkpinfo        configuration structure                     *
 *            files_to_add   list of files to be moved to tape           *
 * Returns:   0=success; nonzero=failure                                 *
 * NB:        Last 'file' string must be NULL                            *
 *************************************************************************/
int
move_files_to_stream (struct s_bkpinfo *bkpinfo,
		 char *files_to_add, ...)
{

	/** int *************************************************************/
  int retval = 0;
	int res = 0;

	/** buffers *********************************************************/

	/** char ************************************************************/
	char start_chr;
	char stop_chr;
        char curr_file[MAX_STR_LEN], *cf;
	/** long long *******************************************************/
  long long length_of_incoming_file = 0;

  va_list ap;

  va_start(ap, files_to_add);
  for(cf = files_to_add; cf!=NULL; cf=va_arg(ap, char*))
    {
      if (!cf) {continue;}
      strcpy(curr_file, cf);
      if (!does_file_exist (curr_file))
        {
          log_it (
	       "Warning - you're trying to add a non-existent file - '%s' to the tape",
	       curr_file);
        }
/* create header chars */
      start_chr = BLK_START_AN_AFIO_OR_SLICE;
      stop_chr = BLK_STOP_AN_AFIO_OR_SLICE;
/* ask for new tape if necessary */
      length_of_incoming_file = length_of_file (curr_file);
      write_header_block_to_stream (length_of_incoming_file, curr_file,
			      start_chr);
      res = write_file_to_stream_from_file (bkpinfo, curr_file);
      retval += res;
      unlink (curr_file);
/* write closing header */
      write_header_block_to_stream (0, "finished-writing-file", stop_chr);
    }
  va_end(ap);

  if (retval)
    {
      log_it ("Warning - errors occurred while I was adding file to tape");
    }
  return (retval);
}






int interrogate_disk_currently_in_cdrw_drive(char*cdrw_dev, bool keep_looping)
{
  char tmp[MAX_STR_LEN];
  int res=0;

  if (!find_cdrw_device(cdrw_dev))
    {
      if (!system("which cdrecord &> /dev/null"))
        { sprintf(tmp, "cdrecord dev=%s -atip", cdrw_dev); }
      else if (!system("which dvdrecord &> /dev/null"))
        { sprintf(tmp, "cdrecord dev=%s -atip", cdrw_dev); }
      else
        { tmp[0] = '\0'; log_it("Oh well. I guess I'll just pray then."); }
      if (tmp[0])
        {
         if (!keep_looping)
           {
             retract_CD_tray_and_defeat_autorun();
             res = run_program_and_log_output(tmp, TRUE);
           }
         else
           {
             while((res=run_program_and_log_output(tmp, TRUE)))
               {
                 retract_CD_tray_and_defeat_autorun();
                 if (ask_me_yes_or_no("Unable to examine CD. Are you sure this is a valid CD-R(W) CD?"))
                   { log_it("Well, he insisted..."); break; }
               }
            }
        }
    }
//  retract_CD_tray_and_defeat_autorun();
  return(res);
}





/*************************************************************************
 * pause_and_ask_for_cdr() -- Hugo Rabson                                *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/

void
pause_and_ask_for_cdr (int ask_for_one_if_more_than_this)
{

	/** buffers **********************************************/
  char tmp[MAX_STR_LEN];
//  char command[MAX_STR_LEN];
  char szmsg[MAX_STR_LEN];
  char cdrom_dev[MAX_STR_LEN];
  char cdrw_dev[MAX_STR_LEN];
  char our_serial_str[64];
  bool ok_go_ahead_burn_it;
  int cd_number = -1;

  sprintf(szmsg, "I am about to burn CD #%d", g_current_media_number);
  log_to_screen(szmsg);
  log_to_screen("Scanning CD-ROM drive...");

gotos_make_me_puke:
  ok_go_ahead_burn_it = TRUE;
  if (!find_cdrom_device(cdrom_dev))
    {
      log_it( "paafcd: Retracting CD-ROM drive if possible" );
      retract_CD_tray_and_defeat_autorun();
      if (! is_this_device_mounted("/mnt/cdrom"))
        { mount_CDROM_here(cdrom_dev, "/mnt/cdrom"); }
      if (does_file_exist("/mnt/cdrom/archives/THIS-CD-NUMBER"))
        {
          cd_number = atoi(last_line_of_file("/mnt/cdrom/archives/THIS-CD-NUMBER"));
          strcpy(our_serial_str, call_program_and_get_last_line_of_output("cat /mnt/cdrom/archives/SERIAL-STRING 2> /dev/null"));
        }
      else
        { cd_number = -1; our_serial_str[0] = '\0'; }
      run_program_and_log_output("umount /mnt/cdrom", FALSE);
      log_it( "paafcd: cd_number = %d", cd_number);
      log_it( "our serial str = %s; g_serial_string = %s", our_serial_str, g_serial_string);
      if (cd_number > 0 && !strcmp(our_serial_str, g_serial_string))
        {
          ok_go_ahead_burn_it = FALSE;
          if (cd_number == g_current_media_number-1)
            { log_to_screen("I think you've left the previous CD in the drive."); }
          else
            { log_to_screen("Please remove this CD. It is part of the backup set you're making now."); }
        }
    }
  else
    {
      log_it("paafcd: Can't find CD-ROM drive. Perhaps it has a blank CD in it?");
      /*
      if (interrogate_disk_currently_in_cdrw_drive(cdrw_dev, FALSE))
        {
          ok_go_ahead_burn_it = FALSE;
          log_to_screen("There isn't a writable CD in the drive.");
        }
      */
    }

/*
  if (g_current_media_number > ask_for_one_if_more_than_this)
    {
      ok_go_ahead_burn_it = FALSE;
      log_it("paafcd: %d > %d, so I'll definitely pause.", g_current_media_number > ask_for_one_if_more_than_this);
    }
*/

  if (!ok_go_ahead_burn_it)
    {
      eject_device(cdrom_dev);
      sprintf (tmp,
	       "I am about to burn CD #%d of the backup set. Please insert a CD-R(W) and press Enter.",
	       g_current_media_number);
      popup_and_OK (tmp);
      goto gotos_make_me_puke;
    }
  else
    {
      log_it("paafcd: OK, going ahead and burning it.");
    }

  if (g_current_media_number > 1) { popup_and_OK(szmsg); } // 1.6x hack

  log_it ("paafcd: OK, I assume I have a blank/reusable CD in the drive...");

  log_to_screen ("Proceeding w/ CD in drive.");

//  interrogate_disk_currently_in_cdrw_drive(cdrw_dev, TRUE);
}



void set_bit_N_of_array(char*array, int N, bool true_or_false)
{
  int bit_number;
  int mask, orig_val, to_add;
  int element_number;

  element_number = N / 8;
  bit_number = N % 8;
  to_add = (1 << bit_number);
  mask = 255 - to_add;
  orig_val = array[element_number] & mask;
  //  log_it("array[%d]=%02x; %02x&%02x = %02x", element_number, array[element_number], mask, orig_val);
  if (true_or_false) { array[element_number] = orig_val | to_add; }
}










/*************************************************************************
 * slice_up_file_etc() -- Hugo Rabson                                    *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
slice_up_file_etc (struct s_bkpinfo *bkpinfo, char *filename,
		   long biggie_file_number, long noof_biggie_files)
{

	/** buffers ***************************************************/
  char tmp[MAX_STR_LEN];
  char checksum_line[MAX_STR_LEN];
  char command[MAX_STR_LEN*2];
  char *tempblock;
  char curr_slice_fname_uncompressed[MAX_STR_LEN];
  char curr_slice_fname_compressed[MAX_STR_LEN];
  char file_to_archive[MAX_STR_LEN];

	/** pointers ***************************************************/
  char *pB;
  FILE *fin, *fout;

	/** bool *******************************************************/
  bool finished = FALSE;

	/** long *******************************************************/
  long blksize = 0;
  long slice_num = 0;
  long i;
  long optimal_set_size;
  bool should_I_compress_slices;
  char suffix[MAX_STR_LEN]; // for compressed slices

	/** long long ***************************************************/
  long long length;

  /** int *********************************************************/
  int retval = 0;
  int res = 0;

	/** structures ***************************************************/
  struct s_filename_and_lstat_info biggiestruct;

  biggiestruct.for_backward_compatibility = '\n';
  if (!(tempblock = (char*)malloc(256*1024))) { fatal_error("malloc error 256*1024"); }
  optimal_set_size = bkpinfo->optimal_set_size;
  if (is_this_file_compressed(filename) || bkpinfo->compression_level == 0)
    {
      suffix[0] = '\0';
      //      log_it("%s is indeed compressed :-)", filename);
      should_I_compress_slices = FALSE;
    }
  else
    {
      strcpy(suffix, bkpinfo->zip_suffix);
      should_I_compress_slices = TRUE;
    }

  if (optimal_set_size < 999)
    {
      fatal_error ("bkpinfo->optimal_set_size is insanely small");
    }
  if (!strncmp (filename, "/dev/", 5))
    {
      strcpy (tmp, "IGNORE");
    }
  else
    {
      sprintf (command, "md5sum \"%s\"", filename);
      fin = popen (command, "r");
      fgets (checksum_line, MAX_STR_LEN, fin);
      pclose (fin);
      pB = strchr (tmp, ' ');
      if (pB)
	{
	  *pB = '\0';
	}
    }
  /* log_it(tmp); */
  strcpy (tmp, slice_fname (biggie_file_number, 0, bkpinfo->tmpdir, ""));
  //  log_it (tmp);
  lstat (filename, &biggiestruct.properties);
  strcpy (biggiestruct.filename, filename);
  pB = strchr(checksum_line, ' ');
  if (!pB) { pB = strchr(checksum_line, '\t'); }
  if (pB) { *pB='\0'; }
  strcpy (biggiestruct.checksum, checksum_line);

  fout = fopen (tmp, "w");
  fwrite((void*)&biggiestruct, 1, sizeof(biggiestruct), fout);
  fclose (fout);
  length = length_of_file (filename) / optimal_set_size / 1024;
  fin = fopen (filename, "r");
  if (!fin)
    {
      sprintf (tmp, "Cannot archive bigfile '%s': not found", filename);
      log_to_screen (tmp);
      free(tempblock);
      return (1);
    }
  if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
    { res = move_files_to_stream (bkpinfo, slice_fname (biggie_file_number, 0, bkpinfo->tmpdir, ""), NULL); }
  else
    { res = move_files_to_cd (bkpinfo, 	  slice_fname (biggie_file_number, 0, bkpinfo->tmpdir, ""), NULL); }
  for (slice_num = 1; !finished; slice_num++)
    {
      strcpy (curr_slice_fname_uncompressed,
	      slice_fname (biggie_file_number, slice_num, bkpinfo->tmpdir,
			   ""));
      strcpy (curr_slice_fname_compressed,
	      slice_fname (biggie_file_number, slice_num, bkpinfo->tmpdir, suffix));

      /*      sprintf(tmp,"Current file: [",biggie_file_number); */

      strcpy (tmp, percent_media_full_comment (bkpinfo));

      //      log_it("uncomp=%s; compd=%s", curr_slice_fname_uncompressed, curr_slice_fname_compressed);

/*
      sprintf(tmp,"File #%ld of %ld: [",biggie_file_number+1,noof_biggie_files);
      if (slice_num==1) {percentage=0;}
      else {percentage=(int)((slice_num-1)*20/length);}
      for(j=0; j<20 && j<percentage; j++) { strcat(tmp,"*"); }
      for(; j<20; j++) { strcat(tmp,"."); }
      strcat(tmp,"]");
*/
      update_progress_form (tmp);
      fout = fopen (curr_slice_fname_uncompressed, "w");
      for (i = 0; i < bkpinfo->optimal_set_size / 256; i++)
	{
	  blksize = fread (tempblock, 1, 256 * 1024, fin);
	  if (blksize > 0)
	    {
	      fwrite (tempblock, 1, blksize, fout);
	    }
	  else
	    {
	      break;
	    }
	}
      fclose (fout);
      if (i > 0) // length_of_file (curr_slice_fname_uncompressed) 
	{
	  if (!does_file_exist (curr_slice_fname_uncompressed))
	    {
	      log_it (
		       "Warning - '%s' doesn't exist. How can I compress slice?",
		       curr_slice_fname_uncompressed);
	    }
          if (should_I_compress_slices && bkpinfo->compression_level>0)
            {
	      sprintf (command, "%s -%d %s", bkpinfo->zip_exe,
		   bkpinfo->compression_level, curr_slice_fname_uncompressed);
    	      log_it (command);
	      res = system (command);
	      //	      did_I_compress_slice = TRUE;
            }
          else
            {
              sprintf (command, "mv %s %s 2>> %s", curr_slice_fname_uncompressed, curr_slice_fname_compressed, MONDO_LOGFILE);
              res=0; // don't do it :)
	      //	      did_I_compress_slice = FALSE;
            }
	  retval += res;
	  if (res)
	    {
	      log_it ("Failed to compress the slice");
	    }
	  /*
	  if (!res && !does_file_exist (curr_slice_fname_compressed))
	    {
	      log_it ("Compressed slice but I can't find it now!");
	      res++;
    }
	  */
	  if (bkpinfo->use_lzo && strcmp(curr_slice_fname_compressed, curr_slice_fname_uncompressed))
	    {
	      unlink (curr_slice_fname_uncompressed);
	    }
	  if (res)
	    {
	      sprintf (tmp, "Problem with slice # %ld", slice_num);
	    }
	  else
	    {
	      sprintf (tmp,
		       "%s - Bigfile #%ld, slice #%ld compressed OK          ",
		       filename, biggie_file_number + 1, slice_num);
	    }
#ifndef _XWIN
	  if (!g_text_mode)
	    {
	      newtDrawRootText (0, 22, tmp);
	      newtRefresh ();
	    }
	  else
	    {
	      log_it (tmp);
	    }
#else
		log_it(tmp);
#endif
		strcpy(file_to_archive, curr_slice_fname_compressed);
	  g_current_progress++;
	}
      else /* if i==0 then ... */
	{
	  finished = TRUE;
	  strcpy (file_to_archive, curr_slice_fname_uncompressed);
          if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
	    {
	      break;
	    }
	}

      //      log_it("file_to_archive = %s", file_to_archive);
      //      if (!does_file_exist(file_to_archive)) { log_it("WARNING - it doesn't exist"); }

      if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
        { res = move_files_to_stream (bkpinfo, file_to_archive, NULL); }
      else
        { res = move_files_to_cd (bkpinfo, file_to_archive, NULL); }
      retval += res;
      if (res)
	{
	  sprintf (tmp,
		   "Failed to add slice %ld of bigfile %ld to scratchdir",
		   slice_num, biggie_file_number+1);
	  log_to_screen (tmp);
	  fatal_error
	    ("Hard disk full. You should have bought a bigger one.");
	}
    }
  fclose (fin);
  sprintf (tmp, "Sliced bigfile #%ld", biggie_file_number + 1);
  if (retval)
    {
      strcat (tmp, "...FAILED");
    }
  else
    {
      strcat (tmp, "...OK!");
    }
  log_it (tmp);
  free(tempblock);
  return (retval);
}







/*************************************************************************
 * wipe_archives() -- Hugo Rabson                                        *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
wipe_archives (char *d)
{
	/** buffers **********************************************/
  char tmp[MAX_STR_LEN];
  char dir[MAX_STR_LEN];



  sprintf (dir, "%s/archives", d);
  sprintf (tmp, "rm -f %s/*.afio*", dir);
  system (tmp);
  sprintf (tmp, "rm -f %s/filelist.[0-9]*", dir);
  system (tmp);
  sprintf (tmp, "rm -f %s/slice*", dir);
  system (tmp);
  sprintf (tmp, "rm -f %s/cklist*", dir);
  system (tmp);
  sprintf (tmp, "rm -f %s/zero", dir);
  system (tmp);
  sprintf (tmp, "Wiped %s's archives", dir);
  log_it (tmp);
  sprintf (tmp, "ls -l %s", dir);
  run_program_and_log_output (tmp, FALSE);
}



/*************************************************************************
 * write_final_iso_if_necessary() -- Hugo Rabson                         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
write_final_iso_if_necessary (struct s_bkpinfo *bkpinfo)
{
	/** int ******************************************************/
  int res;

	/** buffers ***************************************************/
  char tmp[MAX_STR_LEN];


  /* I should really check if there are any slices or tarballs to be copied to CD-R(W)'s; the odds are approx. 1 in a million that there are no files here, so I'll just go ahead & make one more CD anyway */

  sprintf(tmp, "Writing the final ISO");
  log_it(tmp);
  center_string (tmp, 80);
#ifndef _XWIN
  if (!g_text_mode)
    {
      newtPushHelpLine (tmp);
    }
#endif
  res = write_iso_and_go_on (bkpinfo, TRUE);
#ifndef _XWIN
  if (!g_text_mode)
    {
      newtPopHelpLine ();
    }
#endif
  log_it ("Returning from writing final ISO (res=%d)", res);
  return (res);
}



/*************************************************************************
 * write_iso_and_go_on() -- Hugo Rabson                                  *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
write_iso_and_go_on (struct s_bkpinfo *bkpinfo, bool last_cd)
{
	/** pointers *****************************************************/
  FILE *fout;

	/** buffers ******************************************************/
  char tmp[MAX_STR_LEN];
  char cdno_fname[MAX_STR_LEN];
  char lastcd_fname[MAX_STR_LEN];
  char isofile[MAX_STR_LEN];

	/** bool *********************************************************/
  bool that_one_was_ok;
  bool using_nfs;
  bool orig_vfy_flag_val;

	/**int ************************************************************/
  int res = 0;

  orig_vfy_flag_val = bkpinfo->verify_data;
  if (bkpinfo->media_size[g_current_media_number]<=0) { fatal_error( "write_iso_and_go_on() - unknown media size"); }

  if (strlen (bkpinfo->nfs_mount) > 1)
    {
      using_nfs = TRUE;
    }
  else
    {
      using_nfs = FALSE;
    }
  log_it ("OK, time to make CD #%d", g_current_media_number);

  /* label the ISO with its number */

  sprintf (cdno_fname, "%s/archives/THIS-CD-NUMBER", bkpinfo->scratchdir);
  fout = fopen (cdno_fname, "w");
  fprintf (fout, "%d", g_current_media_number);
  fclose (fout);

  sprintf (tmp, "cp -f %s/autorun %s/", g_mondo_home, bkpinfo->scratchdir);
  if (run_program_and_log_output(tmp, FALSE))
    { log_it("Warning - unable to copy autorun to scratchdir"); }

  /* last CD or not? Label accordingly */
  sprintf (lastcd_fname, "%s/archives/NOT-THE-LAST", bkpinfo->scratchdir);
  if (last_cd)
    {
      unlink (lastcd_fname);
      log_it ("OK, you're telling me this is the last CD. Fair enough.");
    }
  else
    {
      fout = fopen (lastcd_fname, "w");
      fprintf (fout,
	       "You're listening to 90.3 WPLN, Nashville Public Radio.\n");
      fclose (fout);
    }
  if (space_occupied_by_cd (bkpinfo->scratchdir) / 1024 > bkpinfo->media_size[g_current_media_number])
    {
      sprintf (tmp,
	       "Warning! CD is too big. It occupies %ld KB, which is more than the %ld KB allowed.",
	       (long) space_occupied_by_cd (bkpinfo->scratchdir),
	       (long) bkpinfo->media_size[g_current_media_number]);
      log_to_screen (tmp);
    }
/*
  if (using_nfs)
    {
      sprintf(isofile,"%s/%d.iso",bkpinfo->tmpdir, g_current_media_number);
    }
  else
    {
      sprintf(isofile,"%s/%d.iso",bkpinfo->isodir, g_current_media_number);
    }
*/

/*
  if (bkpinfo->nonbootable_backup)
    {
      sprintf (isofile, "%s/temporary.iso", bkpinfo->tmpdir);
    }
  else
    {
*/
      sprintf (isofile, "%s/%s/%d.iso", bkpinfo->isodir, bkpinfo->nfs_remote_dir,
	       g_current_media_number);
      //    }
  for (that_one_was_ok = FALSE; !that_one_was_ok;)
    {
      res = make_iso_fs (bkpinfo, isofile);
      if (bkpinfo->verify_data && !res)
	{
	  log_to_screen
	    ("Please reboot from the 1st CD in Compare Mode, as a precaution.");
	  chdir ("/");
	  res += verify_cd_image (bkpinfo);
	}
      if (!res)
	{
	  that_one_was_ok = TRUE;
	}
      else
	{
	  sprintf (tmp, "Failed to burn CD #%d. Retry?",
		   g_current_media_number);
	  res = ask_me_yes_or_no (tmp);
	  if (!res)
	    {
	      if (ask_me_yes_or_no ("Abort the backup?"))
		{
		  fatal_error ("FAILED TO BACKUP");
		}
	      else
		{
		  break;
		}
	    }
	  else
	    {
	      log_it ("Retrying, at user's request...");
	      res = 0;
	    }
	}
    }
/*
  if (using_nfs)
    {
      sprintf(tmp,"mv -f %s %s/%s/", isofile, bkpinfo->isodir, bkpinfo->nfs_remote_dir);
      if (run_program_and_log_output(tmp, FALSE))
        { log_to_screen("Unable to move ISO to NFS dir"); }
    }
*/
  g_current_media_number++;
  if (g_current_media_number > MAX_NOOF_MEDIA) { fatal_error("Too many CD-R(W)'s. Use tape or net."); }
  wipe_archives (bkpinfo->scratchdir);
  sprintf (tmp, "rm -Rf %s/images/*gz %s/images/*data*img",
	   bkpinfo->scratchdir, bkpinfo->scratchdir);
  if (system (tmp))
    {
      log_it
	("Error occurred when I tried to delete the redundant IMGs and GZs");
    }

  if (last_cd)
    {
      log_it ("This was your last CD.");
    }
  else
    {
      log_it ("Continuing to backup your data...");
    }

  bkpinfo->verify_data = orig_vfy_flag_val;
  return (0);
}






int verify_data(struct s_bkpinfo *bkpinfo)
{
  int res=0, retval=0, cdno=0;
char tmp[MAX_STR_LEN];
long diffs=0;
  
      if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type))
	{
	  chdir ("/");
	  mvaddstr_and_log_it (g_currentY, 0,
			       "Verifying archives against live filesystem");
	  if (bkpinfo->backup_media_type == cdstream)
	    {
// patch by Tom Mortell - 2003/05/21
          g_current_media_number = cdno;
// end of patch
	      strcpy (bkpinfo->media_device, "/dev/cdrom");
	    }
	  verify_tape_backups (bkpinfo);
	  mvaddstr_and_log_it (g_currentY++, 74, "Done.");
	}
      else if (bkpinfo->backup_data)
	//bkpinfo->backup_media_type == cdrw || bkpinfo->backup_media_type == cdr))
        {
          log_it("Not verifying again. Per-CD/ISO verification already carried out.");
          system("cat /tmp/changed.files.* > /tmp/changed.files 2> /dev/null");
        }
      else
	{
// patch by Tom Mortell - 2003/05/21
          g_current_media_number = cdno;
// end of patch
	  if (bkpinfo->backup_media_type != iso)
	    {
	      if (find_cdrom_device(bkpinfo->media_device)) // replace 0,0,0 with /dev/cdrom
                {
                  log_it("verify_data() --- Warning: find_cdrom_device() failed");
                }
	    }
	  chdir ("/");
	  for (cdno = 1;
	       cdno < 99 && bkpinfo->verify_data;
	       cdno++)
	    {
	      insist_on_this_cd_number (bkpinfo, cdno);
	      res = verify_cd_image (bkpinfo);
	      retval += res;
	      if (res)
		{
		  sprintf (tmp,
			   "Warnings/errors were reported while checking CD #%d",
			   g_current_media_number);
		  log_to_screen (tmp);

		}
	    }
	  sprintf (tmp,
		   "cat %s | grep \"afio: \" | cut -d'\"' -f2 | sort -u | awk '{print \"/\"$0;};' | tr -s '/' '/' | grep -vx \"/afio:.*\" > /tmp/changed.files",
		   MONDO_LOGFILE);
	  if (system (tmp))
	    {
	      log_it
		("Warning - unable to check logfile to derive list of changed files");

	    }
          run_program_and_log_output("umount /mnt/cdrom", FALSE);
          if (bkpinfo->backup_media_type != iso)
            {
              run_program_and_log_output("eject /dev/cdrom", FALSE);
            }
	}
      diffs = count_lines_in_file ("/tmp/changed.files");

      if (diffs > 0)
	{
          if (retval==0) { retval=(int)(-diffs); }
	}
 return(retval);
}







/*************************************************************************
 * write_image_to_floppy_SUB() -- Hugo Rabson 										         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
write_image_to_floppy_SUB (char *device, char *datafile)
{
	/** int ****************************************************************/
  int res = 0;
	int percentage = 0;
	int blockno = 0;
	int maxblocks =0;

	/** buffers*************************************************************/
  char tmp[MAX_STR_LEN];
	char blk[1024];
	char title[MAX_STR_LEN];

	/** pointers ***********************************************************/
	char *p;
  FILE *fout, *fin;



  /* pretty stuff */
  if (!(p = strrchr (datafile, '/')))
    {
      p = datafile;
    }
  else
    {
      p++;
    }
  sprintf (title, "Writing %s to floppy", p);
  open_evalcall_form (title);
  /* functional stuff */
  for (p = device + strlen (device); p != device && isdigit (*(p - 1)); p--);
  maxblocks = atoi (p);
  if (!maxblocks) { maxblocks = 1440; }
  sprintf (tmp, "maxblocks = %d; p=%s", maxblocks, p);
  log_it (tmp);
  /* copy data from image to floppy */
  if (!(fin = fopen (datafile, "r")))
    {
      log_to_screen ("Cannot open img");
      return (1);
    }
  if (!(fout = fopen (device, "w")))
    {
      log_to_screen ("Cannot open fdd");
      return (1);
    }
  for (blockno = 0; blockno < maxblocks; blockno++)
    {
      percentage = blockno * 100 / maxblocks;
      if (fread (blk, 1, 1024, fin) != 1024)
	{
	  res++;
	  log_to_screen ("img read err");
	}
      if (fwrite (blk, 1, 1024, fout) != 1024)
	{
	  res++;
	  log_to_screen ("fdd write err");
	}
      if (((blockno + 1) % 128) == 0)
	{
	  system ("sync");	/* fflush doesn't work; dunno why */
	  update_evalcall_form (percentage);
	}
    }
  fclose (fin);
  fclose (fout);
  close_evalcall_form ();
  return (res);
}










/*************************************************************************
 * write_image_to_floppy() -- Hugo Rabson    										         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
write_image_to_floppy (char *device, char *datafile)
{
	/** int ***************************************************************/
  int res	= 0;


  while ((res = write_image_to_floppy_SUB (device, datafile)))
    {
      if (!ask_me_yes_or_no ("Failed to write image to floppy. Retry?"))
	{
	  return (res);
	}
    }
  return (res);
}





