%{!?ksource_dir: %define ksource_dir /lib/modules/%(uname -r)/build}
%define uts_release %( gcc -E -D__BOOT_KERNEL_H_ -dM %{ksource_dir}/include/linux/version.h | grep UTS | sed 's/^#define UTS_RELEASE //;s/"//g' )

Summary: Network device driver updates for Linux.
Name: netdrivers
Version: 3
Release: 4
Copyright: GPL
Group: System Environment/Kernel
Source0: ~becker/netdrivers/netdrivers-%{version}.tar.gz
URL:     http://www.scyld.com/network/index.html

Distribution: Scyld Beowulf
Vendor: Scyld Computing Corp.
Packager: Donald Becker <becker@scyld.com>
Buildroot: %{_tmppath}/%{name}-%{version}-root 

%description
PCI network device driver updates for all Linux kernel versions.
This package contains new, enhanced and updated network device drivers
from Scyld Computing Corporation.

%package modules
%{expand: %%define kernelvers   %(if [ -z "$LINUX" ] ; then LINUX=%{ksource_dir}; fi; (cat $LINUX/include/linux/version.h ; echo UTS_RELEASE) | cpp -P -D__BOOT_KERNEL_H_ | tr -d \")}
%{expand: %%define releaseextra .k%(echo %{kernelvers}|tr - _)}
Release: @PACKAGE_RELEASE@%{releaseextra}
Summary: Network device driver updates for Linux.
Group: System Environment/Kernel

%description modules
PCI network device driver updates for all Linux kernel versions.
This package contains new, enhanced and fixed network device drivers.

%define all_ppc ppc ppciseries ppcpseries ppc64
%define all_x86 i686 i386 i586 athlon x86_64

%prep
%setup -q

%build
# Build for beoboot
make -s EXTRACFLAGS="-D__BOOT_KERNEL_H_ -D__BOOT_KERNEL_BEOBOOT=1 -D__MODULE_KERNEL_i386=1" KERNVER="%{uts_release}"
mkdir -p beoboot/net
make install MODULEDIR=beoboot PREFIX=nodepmod KERNVER="%{uts_release}"
make -s clean

# Build for SMP
make -s EXTRACFLAGS="-D__BOOT_KERNEL_H_ -D__BOOT_KERNEL_SMP=1 -D__MODULE_KERNEL_%{_target_cpu}=1" KERNVER="%{uts_release}"
mkdir -p smp/net
make install MODULEDIR=smp PREFIX=nodepmod KERNVER="%{uts_release}"
make -s clean

# Build for UP
make -s EXTRACFLAGS="-D__BOOT_KERNEL_H_ -D__BOOT_KERNEL_UP=1 -D__MODULE_KERNEL_%{_target_cpu}=1" KERNVER="%{uts_release}"
mkdir -p up/net
make install MODULEDIR=up PREFIX=nodepmod KERNVER="%{uts_release}"
make -s clean

%ifarch i386
make -s EXTRACFLAGS="-D__BOOT_KERNEL_H_ -D__BOOT_KERNEL_BOOT=1 -D__MODULE_KERNEL_%{_target_cpu}=1" KERNVER="%{uts_release}"
mkdir -p BOOT/net
make install MODULEDIR=BOOT PREFIX=nodepmod KERNVER="%{uts_release}"
make -s clean
%endif


%install
if test "$RPM_BUILD_ROOT" != "/"; then
	rm -rf "$RPM_BUILD_ROOT"
fi

for type in debug enterprise beoboot smp up BOOT; do
    if [ -d $type ]; then
	pushd $type/net
	if [ $type = "up" ]; then
	  KVER=%{uts_release}
	else
	  KVER=%{uts_release}${type}
	fi
	%{__mkdir} -p $RPM_BUILD_ROOT/lib/modules/${KVER}/net
	%{__install} -m 0644 * $RPM_BUILD_ROOT/lib/modules/${KVER}/net/
	popd
    fi
done

%clean
if test "$RPM_BUILD_ROOT" != "/"; then
	rm -rf "$RPM_BUILD_ROOT"
fi

%post
if [ -x /sbin/depmod ] && [ -w /boot/System.map-%{uts_release} ] ; then /sbin/depmod -a -F /boot/System.map-%{uts_release} %{uts_release} ; fi
if [ -x /sbin/depmod ] && [ -w /boot/System.map-%{uts_release}smp ] ; then /sbin/depmod -a -F /boot/System.map-%{uts_release}smp %{uts_release}smp ; fi

%files modules
%defattr(-,root,root)
/lib/modules/*/*/*

%ifarch i386
%files
%endif

# Local variables:
#  compile-command: "rpm -ba netdrivers.spec"
# End:
