/*
 *                     The OCaml-gtk interface
 *
 * Copyright (c) 1997-99   David Monniaux, Pascal Cuoq, Sven Luther
 *
 * This file is distributed under the conditions described in
 * the file LICENSE.  
 */

/* $Id: mlgtk_stub.c,v 1.73 1999/11/25 12:25:44 cuoq Exp $ */

#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/alloc.h>
#include <caml/callback.h>
#include <caml/fail.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mlgdk.h"

#define Double_array_length(v) (Wosize_val(v)/(sizeof(double)/sizeof(value)))

/* ###### 3. Objects */
/* ### 3.1 Type utility functions */
/* ### 3.2 Object functions */

#define optionptr_ml(x) (Is_long(x) ? NULL : (void*) Field(x, 0))

#define GtkCurve_ml(object) (GTK_CURVE(object))
#define GtkCombo_ml(object) (GTK_COMBO(object))
#define GtkFileSelection_ml(object) (GTK_FILE_SELECTION(object))
#define GtkItem_ml(object) (GTK_ITEM(object))
#define GtkAdjustment_optionptr_ml(object) (GTK_ADJUSTMENT(optionptr_ml(object)))
#define GtkAlignment_ml(object) (GTK_ALIGNMENT(object))
#define GtkAspectFrame_ml(object) (GTK_ASPECT_FRAME(object))
#define GtkArrow_ml(object) (GTK_ARROW(object))
#define GtkLabel_ml(object) (GTK_LABEL(object))
#define GtkListItem_ml(object) (GTK_LIST_ITEM(object))
#define GtkButtonBox_ml(object) (GTK_BUTTON_BOX(object))
#define GtkObject_ml(object) (GTK_OBJECT((void*)object))
#define GtkWidget_ml(object) (GTK_WIDGET(object))
#define GtkBox_ml(object) (GTK_BOX(object))
#define GtkCList_ml(object) (GTK_CLIST(object))
#define GtkList_ml(object) (GTK_LIST(object))
#define GtkMenu_ml(object) (GTK_MENU(object))
#define GtkMenuItem_ml(object) (GTK_MENU_ITEM(object))
#define GtkMenuBar_ml(object) (GTK_MENU_BAR(object))
#define GtkMenuShell_ml(object) (GTK_MENU_SHELL(object))
#define GtkContainer_ml(object) (GTK_CONTAINER(object))
#define GtkPaned_ml(object) (GTK_PANED(object))
#define GtkTooltips_ml(object) (GTK_TOOLTIPS(object))
#define GtkWindow_ml(object) (GTK_WINDOW(object))
#define GtkButton_ml(object) (GTK_BUTTON(object))
#define GtkToggleButton_ml(object) (GTK_TOGGLE_BUTTON(object))
#define GtkProgressBar_ml(object) (GTK_PROGRESS_BAR(object))
#define GtkText_ml(object) (GTK_TEXT(object))
#define GtkDrawingArea_ml(object) (GTK_DRAWING_AREA(object))
#define GtkColorSelection_ml(object) (GTK_COLOR_SELECTION(object))
#define GtkNotebook_ml(object) (GTK_NOTEBOOK(object))
#define GtkEditable_ml(object) (GTK_EDITABLE(object))
#define GtkEntry_ml(object) (GTK_ENTRY(object))
#define GtkFrame_ml(object) (GTK_FRAME(object))
#define GtkCheckMenuItem_ml(object) (GTK_CHECK_MENU_ITEM(object))
#define GtkScrolledWindow_ml(object) (GTK_SCROLLED_WINDOW(object))
#define GtkStatusbar_ml(object) (GTK_STATUSBAR(object))
#define GtkTable_ml(object) (GTK_TABLE(object))
#define GtkDialog_ml(object) (GTK_DIALOG(object))
#define ml_GtkObject(object) ((value) object)

#ifdef DEBUG
#define check_GtkObject_ml(object, func_id) \
  if (GtkObject_ml(object) == NULL) \
    invalid_argument(func_id)
#else
#define check_GtkObject_ml(object, func_id) /**/
#endif

#ifdef GTKTHR
/* Support for Caml Posix threads */

/* Handling {enter,leave}_blocking_section :
  gtk_main() must run in "blocking_section" mode.
  We must leave_blocking_section() before invoking Caml memory
  management and callbacks.
  
  Note : C functions called from Caml cannot interrupt each other,
         except between {enter,leave}_blocking_section().
  Note : gtk callbacks seem to be reentrant, i.e. invoking gtk from a
         gtk callback may trigger another gtk callback immediately.
  TODO : Could gtk callbacks be called before entering gtk_main() ?
*/

static int gtkthr_blocking = 0; /* Protected by Gtk.mutex */

/* Entering GTK callbacks : either
   - gtk_main -> [callback]
       Gtk.mutex is locked, blocking_section is enabled.
   - gtk_main -> callback -> gtk_function -> ... -> [immediate callback]
       Gtk.mutex is locked, blocking_section is disabled.
   - user -> gtk_function -> ... -> [immediate callback]
       Gtk.mutex is locked, blocking_section is disabled.
*/

#define GTKTHR_LEAVE {                                        \
  int gtkthr_needs_reblock = 0;                               \
  if ( gtkthr_blocking ) {                                    \
    leave_blocking_section();                                 \
    gtkthr_blocking = 0;                                      \
    gtkthr_needs_reblock = 1;                                 \
  }

#define GTKTHR_RETURN \
  if ( gtkthr_needs_reblock ) {                                 \
    gtkthr_blocking = 1;                                        \
    enter_blocking_section();                                   \
  }                                                             \
}
#endif /* GTKTHR */

value mlgtk_window_of(value widget)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.window_of");
  return (value) (((GtkWidget*) widget)->window);
}

value mlgtk_style_of(value widget)
{
  value r, gc;
  GtkStyle *style;
  int i;
  check_GtkObject_ml(widget, "Gtk.Unsafe.style_of");
  style=((GtkWidget*)widget)->style;
  gc = alloc_tuple(5);
  for (i=0; i<5; i++) 
  {
    Field(gc , i) = (value)style->fg_gc[i];
  }

  Begin_roots1 (gc); 
  r=alloc_tuple(10);
  Field(r, 0) = (value) (style->font);
  Field(r, 1) = gc;
  Field(r, 2) = (value) (style->fg_gc[0]);
  Field(r, 3) = (value) (style->fg_gc[1]);
  Field(r, 4) = (value) (style->fg_gc[2]);
  Field(r, 5) = (value) (style->fg_gc[3]);
  Field(r, 6) = (value) (style->fg_gc[4]);
  Field(r, 7) = (value) (style->black_gc);
  Field(r, 8) = (value) (style->white_gc);
  Field(r, 9) = (value) style->colormap;
  End_roots ();
  return r;
}

value mlgtk_fg_gc_of(value widget, value state)
{
  GtkStyle *style;
  check_GtkObject_ml(widget, "Gtk.fg_gc_of");
  style =((GtkWidget*)widget)->style;
  return ((value) (style->fg_gc[Int_val(state)]));
}

value mlgtk_allocation_of(value widget)
{
  value r ;
  GtkAllocation allocation;
  check_GtkObject_ml(widget, "Gtk.Unsafe.allocation_of");
  allocation=((GtkWidget*)widget)->allocation;
  r=alloc_tuple(4);
  Field(r, 0) = Val_int(allocation.x);
  Field(r, 1) = Val_int(allocation.y);
  Field(r, 2) = Val_int(allocation.width);
  Field(r, 3) = Val_int(allocation.height);
  return r;
}

value mlgtk_state_of(value widget)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.state_of");
  return Val_int((int) (GTK_WIDGET_STATE ((GtkWidget*) widget)));
}

value mlgtk_int_poke(value ptr, value val)
{
  *((gint*) ptr) = Int_val(val);
  return Val_unit;
}

value mlgtk_int_peek(value ptr)
{
  return Val_int(*((gint*) ptr));
}

void free_object_data (gpointer block)
{
  /* TODO : GTKTHR_{LEAVE/RETURN} here when called as GtkDestroyNotify ? */
  remove_global_root(block);
  free (block);
}

value mlgtk_object_set_data (value widget, value s, value data)
{
  value *block ;
  check_GtkObject_ml (widget, "mlgtk_object_set_data");

  block = (value *) malloc (sizeof(value));
  *block = data;
  register_global_root(block);
  gtk_object_set_data_full (GtkObject_ml(widget), String_val(s),
    (gpointer) block, (GtkDestroyNotify)&free_object_data);
  return Val_unit;
}

value mlgtk_object_free_data (value widget, value s)
{
  value *block;
  check_GtkObject_ml (widget, "mlgtk_object_free_data");

  block = gtk_object_get_user_data (GtkObject_ml(widget));
  if ((value *)NULL==block) return Val_false;
  else {
    free_object_data((gpointer) block);
    gtk_object_set_data_full (GtkObject_ml(widget), String_val(s),
      (gpointer)NULL, (GtkDestroyNotify)&free_object_data);
    return Val_true;
  }
}

value mlgtk_object_get_data (value widget, value s)
{
  value *block ;
  check_GtkObject_ml (widget, "mlgtk_object_get_data");

  block = gtk_object_get_data (GtkObject_ml(widget), String_val(s));
  if ((value *)NULL==block) failwith ("No data associated to this widget.");
  else return *block;
}

/* ###### 4. Signals */
void mlgtk_callback_exec(GtkObject *object, value *closurep,
  int n_args, GtkArg *args)
{
  int i;
  value retval, car, cdr;

#ifdef GTKTHR
  GTKTHR_LEAVE
#endif

  car = cdr = retval = Val_int(0);

  /*fprintf(stderr, "callback with %d args\n", n_args);*/

Begin_roots3(car,cdr,retval);
  for (i=n_args-1; i>=0; i--)
    {
#ifdef DEBUG
      fprintf(stderr, "arg #%d type=%d\n", i,
        GTK_FUNDAMENTAL_TYPE(args[i].type));
#endif
      switch (GTK_FUNDAMENTAL_TYPE(args[i].type))
	{
	case GTK_TYPE_NONE:
	  car = Val_int(0);
	  break;

	case GTK_TYPE_INVALID:
	  car = Val_int(2);
	  break;

	case GTK_TYPE_INT:
	case GTK_TYPE_UINT:
	  car = alloc(1, 2); /* Int */
	  Field(car, 0) = Val_int(args[i].d.int_data);
	  break;

	case GTK_TYPE_LONG:
	case GTK_TYPE_ULONG:
	  car = alloc(1, 2); /* Int */
	  Field(car, 0) = Val_int(args[i].d.long_data);
	  break;

	case GTK_TYPE_BOOL:
	  car = alloc(1, 0); /* Bool */
	  Field(car, 0) = Val_bool(args[i].d.int_data);
	  break;

	case GTK_TYPE_CHAR:
	  car = alloc(1, 1); /* Char */
	  Field(car, 0) = Val_int(args[i].d.char_data);
	  break;

	case GTK_TYPE_FLOAT:
	  car = alloc(1, 3); /* Float */
	  Field(car, 0) = copy_double(args[i].d.float_data);
	  break;

	case GTK_TYPE_STRING:
	  car = alloc(1, 4); /* String */
	  Field(car, 0) = copy_string(args[i].d.string_data);
	  break;

	case GTK_TYPE_POINTER:
	case GTK_TYPE_BOXED:
	  car = alloc(1, 5); /* Pointer */
	  Field(car, 0) = (value) args[i].d.pointer_data;
	  break;

	default: car = Val_int(1); /* Other */
	}
      cdr = retval;
      retval = alloc(2, 0); /* BEWARE: Both car and cdr must be roots here */
      Field(retval, 0)=car;
      Field(retval, 1)=cdr;
    }
  fflush(stderr);
  retval = callback2_exn(*closurep, ml_GtkObject(object), retval);
End_roots();

#ifdef GTKTHR
  GTKTHR_RETURN
#endif
  if ( Is_exception_result(retval) ) mlraise(Extract_exception(retval));

  if (Is_long(retval))
    {
      switch (Int_val(retval))
	{
	case 0: /* unit */
	  switch (GTK_FUNDAMENTAL_TYPE(args[n_args].type))
	    {
	    case GTK_TYPE_NONE:
	      return;
	    }
	}
    }
  else
    {
      switch (Tag_val(retval))
	{
	case 0: /* bool */
	  switch (GTK_FUNDAMENTAL_TYPE(args[n_args].type))
	    {
	    case GTK_TYPE_BOOL:
	      *((gint*) (args[n_args].d.pointer_data)) = Int_val(Field(retval, 0));
	      return;
	    }

	case 1: /* char */
	  switch (GTK_FUNDAMENTAL_TYPE(args[n_args].type))
	    {
	    case GTK_TYPE_CHAR:
	      *((gchar*) (args[n_args].d.pointer_data)) = Int_val(Field(retval, 0));
	      return;
	    }

	case 2: /* int */
	  switch (GTK_FUNDAMENTAL_TYPE(args[n_args].type))
	    {
	    case GTK_TYPE_ENUM:
	    case GTK_TYPE_INT:
	    case GTK_TYPE_UINT:
	      *((gint*) (args[n_args].d.pointer_data)) = Int_val(Field(retval, 0));
	      return;

	    case GTK_TYPE_LONG:
	    case GTK_TYPE_ULONG:
	      *((glong*) (args[n_args].d.pointer_data)) = Int_val(Field(retval, 0));
	      return;
	    }

	case 3: /* float */
	  switch (GTK_FUNDAMENTAL_TYPE(args[n_args].type))
	    {
	    case GTK_TYPE_FLOAT:
	      *((gfloat*) (args[n_args].d.pointer_data)) = Double_val(Field(retval, 0));
	      return;
	    }

	case 4: /* string */
	  switch (GTK_FUNDAMENTAL_TYPE(args[n_args].type))
	    {
	    case GTK_TYPE_STRING:
	      *((gchar**) (args[n_args].d.pointer_data)) = String_val(Field(retval, 0));
	      return;
	    }	  
	}
    }
  fprintf(stderr, 
	  "Gtk callbacks, typecheck error in return value, wanted=%d\n",
	  GTK_FUNDAMENTAL_TYPE(args[n_args].type));
  failwith("Gtk.__callback_handler__");
}

void mlgtk_callback_destroy(value cbk)
{
#ifdef GTKTHR
  GTKTHR_LEAVE
#endif
  remove_global_root((void*)cbk);
#ifdef GTKTHR
  GTKTHR_RETURN
#endif
  free((void*)cbk);
}

value mlgtk_signal_connect(value object, value name, value func)
{
  value *cbk;
  check_GtkObject_ml(object, "Gtk.Unsafe.signal_connect");
  cbk = (value*) malloc(sizeof(value));
  register_global_root(cbk);
  *cbk = func;
  return Val_int(gtk_signal_connect_full(
    GtkObject_ml(object), String_val(name), NULL,
    (GtkCallbackMarshal) mlgtk_callback_exec, cbk,
    (GtkDestroyNotify) mlgtk_callback_destroy, FALSE, 1));
}

value mlgtk_signal_disconnect(value object, value index)
{
  gtk_signal_disconnect(GtkObject_ml(object), Int_val(index));
  return Val_unit;
}

/* ###### 5. Widgets */
/* ### 5.1 Alignment widget */
value mlgtk_alignment_new(value xalign, value yalign,
  value xscale, value yscale)
{
  return ml_GtkObject(
    gtk_alignment_new(Double_val(xalign), Double_val(yalign),
      Double_val(xscale), Double_val(yscale)));
}

value mlgtk_alignment_set(value alignment,
  value xalign, value yalign, value xscale, value yscale)
{
  gtk_alignment_set(GtkAlignment_ml(alignment),
    Double_val(xalign), Double_val(yalign),
    Double_val(xscale), Double_val(yscale));
  return Val_unit;
}

/* ### 5.2 Arrow widget */
value mlgtk_arrow_new(value arrow_type, value shadow_type)
{
  return ml_GtkObject(
    gtk_arrow_new(Int_val(arrow_type), Int_val(shadow_type)));
}

value mlgtk_arrow_set(value arrow, value arrow_type, value shadow_type)
{
  gtk_arrow_set(GtkArrow_ml(arrow), Int_val(arrow_type), Int_val(shadow_type));
  return Val_unit;
}

/* ### 5.3 Aspect frame widget */
value mlgtk_aspect_frame_new(value label, value xalign, value yalign,
  value ratio, value obey_child)
{
  return (value) gtk_aspect_frame_new(String_val(label), Double_val(xalign),
    Double_val(yalign), Double_val(ratio), Bool_val(obey_child));
}

value mlgtk_aspect_frame_set(value aspect_frame,
  value xalign, value yalign, value ratio, value obey_child)
{
  gtk_aspect_frame_set(GtkAspectFrame_ml(aspect_frame), Double_val(xalign),
    Double_val(yalign), Double_val(ratio), Bool_val(obey_child));
  return Val_unit;
}

/* ### 5.5 Box widget */
value mlgtk_box_pack_start(value container, value widget,
  value expand, value fill, value padding)
{
  check_GtkObject_ml(container, "Gtk.Unsafe.box_pack_start");
  check_GtkObject_ml(widget, "Gtk.Unsafe.box_pack_start");
  gtk_box_pack_start(
    GtkBox_ml(container), GtkWidget_ml(widget),
    Bool_val(expand), Bool_val(fill), Int_val(padding));
  return Val_unit;  
}

value mlgtk_box_pack_end(value container, value widget,
  value expand, value fill, value padding)
{
  check_GtkObject_ml(container, "Gtk.Unsafe.box_pack_end");
  check_GtkObject_ml(widget, "Gtk.Unsafe.box_pack_end");
  gtk_box_pack_end(
    GtkBox_ml(container), GtkWidget_ml(widget),
    Bool_val(expand), Bool_val(fill), Int_val(padding));
  return Val_unit;  
}

value mlgtk_box_set_homogeneous(value box, value homogeneous)
{
  check_GtkObject_ml(box, "Gtk.Unsafe.box_set_homogeneous");
  gtk_box_set_homogeneous(GtkBox_ml(box), Bool_val(homogeneous));
  return Val_unit;
}

value mlgtk_box_set_spacing(value box, value spacing)
{
  check_GtkObject_ml(box, "Gtk.Unsafe.box_set_spacing");
  gtk_box_set_spacing(GtkBox_ml(box), Int_val(spacing));
  return Val_unit;
}

value mlgtk_box_reorder_child(value box, value child, value pos)
{ 
  check_GtkObject_ml(box, "Gtk.Unsafe.box_reorder_child");
  check_GtkObject_ml(child, "Gtk.Unsafe.box_reorder_child");
  gtk_box_reorder_child(GtkBox_ml(box), GtkWidget_ml(child), Int_val(pos));
  return Val_unit;
}

value mlgtk_box_query_child_packing(value box, value child)
{
  gint expand, fill, padding;
  GtkPackType pack_type;
  value r;

  check_GtkObject_ml(box, "Gtk.Unsafe.box_query_child_packing");
  check_GtkObject_ml(child, "Gtk.Unsafe.box_query_child_packing");
  gtk_box_query_child_packing(GtkBox_ml(box), GtkWidget_ml(child),
    &expand, &fill, &padding, &pack_type);

  r=alloc_tuple(4);
  Field(r, 0)= Val_bool(expand);
  Field(r, 1)= Val_bool(fill);
  Field(r, 2)= Val_int(padding);
  Field(r, 3)= Val_int(pack_type);
  return r;  
}

value mlgtk_box_set_child_packing(value box, value child,
  value expand, value fill, value padding, value pack_type)
{
  check_GtkObject_ml(box, "Gtk.Unsafe.box_set_child_packing");
  check_GtkObject_ml(child, "Gtk.Unsafe.box_set_child_packing");
  gtk_box_set_child_packing(GtkBox_ml(box), GtkWidget_ml(child),
    Bool_val(expand), Bool_val(fill), Int_val(padding), Int_val(pack_type));
  return Val_unit;
}
value mlgtk_box_set_child_packing_bytecode(value *argv, int argc)
{
  return mlgtk_box_set_child_packing(argv[0], argv[1], argv[2], argv[3],
    argv[4], argv[5]);
}

/* ### 5.6 Button box widget */
value mlgtk_button_box_set_child_size_default(value width, value height)
{
  gtk_button_box_set_child_size_default(Int_val(width), Int_val(height));
  return Val_unit;
}

value mlgtk_button_box_set_child_ipadding_default(value ipad_x, value ipad_y)
{
  gtk_button_box_set_child_ipadding_default(Int_val(ipad_x), Int_val(ipad_y));
  return Val_unit;
}

value mlgtk_button_box_get_child_size_default(value dummy)
{
  int width, height;
  value r;
  gtk_button_box_get_child_size_default(&width, &height);
  r=alloc_tuple(2);
  Field(r, 0)=Val_int(width);
  Field(r, 1)=Val_int(height);
  return r;
}

value mlgtk_button_box_get_child_ipadding_default(value dummy)
{
  int ipad_x, ipad_y;
  value r;
  gtk_button_box_get_child_ipadding_default(&ipad_x, &ipad_y);
  r=alloc_tuple(2);
  Field(r, 0)=Val_int(ipad_x);
  Field(r, 1)=Val_int(ipad_y);
  return r;
}

value mlgtk_button_box_set_child_size(value widget, value width, value height)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.button_box_set_child_size");
  gtk_button_box_set_child_size(GtkButtonBox_ml(widget),
    Int_val(width), Int_val(height));
  return Val_unit;
}

value mlgtk_button_box_set_child_ipadding(value widget,
  value ipad_x, value ipad_y)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.button_box_set_child_ipadding");
  gtk_button_box_set_child_ipadding(GtkButtonBox_ml(widget),
    Int_val(ipad_x), Int_val(ipad_y));
  return Val_unit;
}

value mlgtk_button_box_set_layout(value widget, value layout_style)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.button_box_set_layout");
  gtk_button_box_set_layout(GtkButtonBox_ml(widget), Int_val(layout_style));
  return Val_unit;
}

value mlgtk_button_box_get_spacing(value widget)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.button_box_get_spacing");
  return Val_int(gtk_button_box_get_spacing(GtkButtonBox_ml(widget)));
}

value mlgtk_button_box_get_child_size(value widget)
{
  int width, height;
  value r;
  check_GtkObject_ml(widget, "Gtk.Unsafe.button_box_get_child_size");
  gtk_button_box_get_child_size(GtkButtonBox_ml(widget), &width, &height);
  r=alloc_tuple(2);
  Field(r,0)=Val_int(width);
  Field(r,1)=Val_int(height);
  return r;
}

value mlgtk_button_box_get_child_ipadding(value widget)
{
  value r;
  int ipad_x, ipad_y;
  check_GtkObject_ml(widget, "Gtk.Unsafe.button_box_get_child_ipadding");
  gtk_button_box_get_child_ipadding(GtkButtonBox_ml(widget), &ipad_x, &ipad_y);
  r=alloc_tuple(2);
  Field(r, 0)=Val_int(ipad_x);
  Field(r, 1)=Val_int(ipad_y);
  return r;
}

value mlgtk_button_box_get_layout(value widget)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.button_box_get_layout");
  return Val_int(gtk_button_box_get_layout(GtkButtonBox_ml(widget)));
}

/* ### 5.7 Button widget */
value mlgtk_button_new_with_label(value label)
{
  return ml_GtkObject(gtk_button_new_with_label(String_val(label)));
}

#if 0 /* this stub id optimized away */
value mlgtk_button_new(value dummy)
{
  return ml_GtkObject(gtk_button_new ());
}
#endif

value mlgtk_button_released(value button)
{
  gtk_button_released(GtkButton_ml(button));
  return Val_unit;
}

value mlgtk_button_pressed(value button)
{
  gtk_button_pressed(GtkButton_ml(button));
  return Val_unit;
}

value mlgtk_button_clicked(value button)
{
  gtk_button_clicked(GtkButton_ml(button));
  return Val_unit;
}

value mlgtk_button_enter(value button)
{
  gtk_button_enter(GtkButton_ml(button));
  return Val_unit;
}

value mlgtk_button_leave(value button)
{
  gtk_button_leave(GtkButton_ml(button));
  return Val_unit;
}

/* ### 5.8 Check button widget */
value mlgtk_check_button_new_with_label(value label)
{
  return ml_GtkObject(gtk_check_button_new_with_label(String_val(label)));
}

/* ### 5.9 Check menu item widget */
value mlgtk_check_menu_item_new_with_label(value str)
{
  return ml_GtkObject(gtk_check_menu_item_new_with_label(String_val(str)));
}

value mlgtk_check_menu_item_set_state(value object,value state)
{
  check_GtkObject_ml(object, "Gtk.Unsafe.check_menu_item_set_state");
  gtk_check_menu_item_set_state(GtkCheckMenuItem_ml(object),Bool_val(state));
  return Val_unit;
}

value mlgtk_check_menu_item_toggled(value object)
{
  gtk_check_menu_item_toggled(GtkCheckMenuItem_ml(object));
  return Val_unit;
}

/* ### 5.10 Compound list */
value mlgtk_clist_new(value columns)
{
  return ml_GtkObject(gtk_clist_new(Int_val(columns)));
}

value mlgtk_clist_set_border(value clist, value shadow_type)
{
  gtk_clist_set_shadow_type(GtkCList_ml(clist), Val_int(shadow_type));
  return Val_unit;
}

value mlgtk_clist_set_selection_mode(value clist, value selection_mode)
{
  gtk_clist_set_selection_mode(GtkCList_ml(clist), Int_val(selection_mode));
  return Val_unit;
}

value mlgtk_clist_freeze(value clist)
{
  gtk_clist_freeze(GtkCList_ml(clist));
  return Val_unit;
}

value mlgtk_clist_thaw(value clist)
{
  gtk_clist_thaw(GtkCList_ml(clist));
  return Val_unit;
}

value mlgtk_clist_column_titles_show(value clist)
{
  gtk_clist_column_titles_show(GtkCList_ml(clist));
  return Val_unit;
}

value mlgtk_clist_get_text (value clist, value row, value column)
{
  value return_value;
  gchar *gtk_string;
  check_GtkObject_ml (clist, "Gtk.Unsafe.clist_get_text") ;
  gtk_clist_get_text (GtkCList_ml(clist),
		     Int_val(row), Int_val(column), &gtk_string) ;
  /* THIS copy_string IS NOT A MEMORY LEAK.  */
  return_value = copy_string (gtk_string) ;
  return return_value ;
}

value mlgtk_clist_column_titles_hide(value clist)
{
  gtk_clist_column_titles_hide(GtkCList_ml(clist));
  return Val_unit;
}

value mlgtk_clist_set_column_title(value clist, value column, value title)
{
  gtk_clist_set_column_title(GtkCList_ml(clist), Int_val(column), String_val(title));
  return Val_unit;
}

value mlgtk_clist_set_column_widget(value clist, value column, value widget)
{
  gtk_clist_set_column_widget(GtkCList_ml(clist), Int_val(column), GtkWidget_ml(widget));
  return Val_unit;
}

value mlgtk_clist_set_column_justification(value clist, value column, value justification)
{
  gtk_clist_set_column_justification(GtkCList_ml(clist), Int_val(column), Int_val(justification));
  return Val_unit;
}

value mlgtk_clist_set_column_width(value clist, value column, value width)
{
  gtk_clist_set_column_width(GtkCList_ml(clist), Int_val(column), Int_val(width));
  return Val_unit;
}

value mlgtk_clist_set_row_height(value clist, value height)
{
  gtk_clist_set_row_height(GtkCList_ml(clist), Int_val(height));
  return Val_unit;
}

value mlgtk_clist_moveto(value clist, value row, value column,
  value row_align, value col_align)
{
  gtk_clist_moveto(GtkCList_ml(clist), Int_val(row), Int_val(column),
    Double_val(row_align), Double_val(col_align));
  return Val_unit; 
}

value mlgtk_clist_set_text(value clist, value row, value column, value text)
{
  gtk_clist_set_text(GtkCList_ml(clist), Int_val(row), Int_val(column), String_val(text));
  return Val_unit;
}

value mlgtk_clist_append(value clist, value textv)
{
  gchar *bufv[1024] ;
  int i,len ;

  len = Wosize_val(textv) ;
  if(len > 1024)
    len = 1024 ;

  memset((void *)bufv, 0, 1024*sizeof(gchar *)) ; 

  for(i=0; i<len; i++)
    bufv[i] = String_val(Field(textv,i)) ;
  return Val_int(gtk_clist_append(GtkCList_ml(clist), bufv)) ;
}

value mlgtk_clist_prepend(value clist, value textv)
{
  gchar *bufv[1024] ;
  int i,len ;

  len = Wosize_val(textv) ;
  if(len > 1024)
    len = 1024 ;

  memset((void *)bufv, 0, 1024*sizeof(gchar *)) ; 

  for(i=0; i<len; i++)
    bufv[i] = String_val(Field(textv,i)) ;
  return Val_int(gtk_clist_prepend(GtkCList_ml(clist), bufv)) ;
}

value mlgtk_clist_insert(value clist, value row, value textv)
{
  gchar *bufv[1024] ;
  int i,len ;

  len = Wosize_val(textv) ;
  if(len > 1024)
    len = 1024 ;

  memset((void *)bufv, 0, 1024*sizeof(gchar *)) ; 

  for(i=0; i<len; i++)
    bufv[i] = String_val(Field(textv,i)) ;
  gtk_clist_insert(GtkCList_ml(clist), Int_val(row), bufv) ;
  return Val_unit ;
}

value mlgtk_clist_set_shift(value clist, value row, value column,
  value vertical, value horizontal)
{
  gtk_clist_set_shift(GtkCList_ml(clist), Int_val(row), Int_val(column),
    Int_val(vertical), Int_val(horizontal));
  return Val_unit;
}

value mlgtk_clist_remove(value clist, value row)
{
  gtk_clist_remove(GtkCList_ml(clist), Int_val(row));
  return Val_unit;
}

value mlgtk_clist_select_row(value clist, value row, value column)
{
  gtk_clist_select_row(GtkCList_ml(clist), Int_val(row), Int_val(column));
  return Val_unit;
}

value mlgtk_clist_unselect_row(value clist, value row, value column)
{
  gtk_clist_unselect_row(GtkCList_ml(clist), Int_val(row), Int_val(column));
  return Val_unit;
}

value mlgtk_clist_clear(value clist)
{
  gtk_clist_clear(GtkCList_ml(clist));
  return Val_unit;
}

void free_clist_row_data (gpointer block)
{
  remove_global_root(block);
  free (block);
}

value mlgtk_clist_set_row_data (value clist, value row, value data)
{
  value *block ;
  check_GtkObject_ml(clist, "mlgtk_clist_set_row_data");

  block = (value *) malloc (sizeof(value));
  register_global_root(block);
  *block = data;
  gtk_clist_set_row_data_full (GtkCList_ml(clist), Int_val(row),
    (gpointer)block, (GtkDestroyNotify)&free_clist_row_data);
  return Val_unit;
}
value mlgtk_clist_get_row_data (value clist, value row)
{
  value *block;
  check_GtkObject_ml(clist, "mlgtk_clist_get_row_data");

  block = gtk_clist_get_row_data (GtkCList_ml(clist), Int_val(row));
  if ((value *)NULL==block) failwith ("No data associated to this row.");
  else return *block;
}

/* ### 5.11 Color selector */
value mlgtk_color_selection_set_color(value widget, value color)
{
  double color_g[4];
  check_GtkObject_ml(GtkColorSelection_ml(widget), "Gtk.Unsafe.color_selection_set_color");
  color_g[0]=Double_val(Field(color, 0));
  color_g[1]=Double_val(Field(color, 1));
  color_g[2]=Double_val(Field(color, 2));
  color_g[3]=Double_val(Field(color, 3));
  gtk_color_selection_set_color(GtkColorSelection_ml(widget), color_g);
  return Val_unit;
}

value mlgtk_color_selection_get_color(value widget)
{
  double color_g[4];
  value r;
  check_GtkObject_ml(widget, "Gtk.Unsafe.color_selection_set_color");
  color_g[3]=1.0;
  gtk_color_selection_get_color(GtkColorSelection_ml(widget), color_g);
  r=alloc_tuple(4);
  Field(r, 0)=Field(r, 1)=Field(r, 2)=Field(r, 3)=0;
  Field(r, 0)=copy_double(color_g[0]);
  Field(r, 1)=copy_double(color_g[1]);
  Field(r, 2)=copy_double(color_g[2]);
  Field(r, 3)=copy_double(color_g[3]);
  return r;
}

value mlgtk_color_selection_set_update_policy(value widget, value policy)
{
  gtk_color_selection_set_update_policy(GtkColorSelection_ml(widget),
    Int_val(policy));
  return Val_unit;
}

value mlgtk_color_selection_set_opacity(value widget, value flag)
{
  gtk_color_selection_set_opacity(GtkColorSelection_ml(widget),
    Int_val(flag));
  return Val_unit;
}

/* ### 5.12 Combo widget */
value mlgtk_combo_set_value_in_list(value combo, value val, value ok_if_empty)
{
  gtk_combo_set_value_in_list(GtkCombo_ml(combo), Int_val(val), Int_val(ok_if_empty));
  return Val_unit; 
}

value mlgtk_combo_set_use_arrows(value combo, value val)
{
  gtk_combo_set_use_arrows(GtkCombo_ml(combo), Int_val(val));
  return Val_unit;
}

value mlgtk_combo_set_use_arrows_always(value combo, value val)
{
  gtk_combo_set_use_arrows_always(GtkCombo_ml(combo), Int_val(val));
  return Val_unit;
}

value mlgtk_combo_set_case_sensitive(value combo, value val)
{
  gtk_combo_set_case_sensitive(GtkCombo_ml(combo), Int_val(val));
  return Val_unit;
}

value mlgtk_combo_set_item_string(value combo, value item, value item_value)
{
  gtk_combo_set_item_string(GtkCombo_ml(combo), GtkItem_ml(item), String_val(item_value));
  return Val_unit; 
}

value mlgtk_combo_set_popdown_strings(value combo, value strings)
{
  gtk_combo_set_popdown_strings(GtkCombo_ml(combo), (GList*) strings);
  return Val_unit;
}

value mlgtk_combo_get_entry (value COMBO)
{
  check_GtkObject_ml(COMBO, "Gtk.Unsafe.combo_get_entry");
  return ml_GtkObject ((GtkCombo_ml(COMBO))->entry) ;
}

value mlgtk_combo_get_button (value COMBO)
{
  check_GtkObject_ml(COMBO, "Gtk.Unsafe.combo_get_button");
  return ml_GtkObject ((GtkCombo_ml(COMBO))->button) ;
}

value mlgtk_combo_disable_activate (value COMBO)
{
  check_GtkObject_ml(COMBO, "Gtk.Unsafe.combo_disable_activate");
  return Val_unit;
}

/* ### 5.13 Container widget */
value mlgtk_container_border_width(value window, value width)
{
  gtk_container_border_width(GTK_CONTAINER(window), Int_val(width));
  return Val_unit;
}

value mlgtk_container_add(value container, value widget)
{
  check_GtkObject_ml(container, "Gtk.Unsafe.container_add");
  check_GtkObject_ml(widget, "Gtk.Unsafe.container_add");
  gtk_container_add(
    GtkContainer_ml(container), GtkWidget_ml(widget));
  return Val_unit;
}

value mlgtk_container_remove(value container, value widget)
{
  gtk_container_remove(GtkContainer_ml(container), GtkWidget_ml(widget));
  return Val_unit;
}

value mlgtk_container_block_resize(value container)
{
  gtk_container_set_resize_mode(GtkContainer_ml(container),
		  GTK_RESIZE_IMMEDIATE);
  return Val_unit;
}

value mlgtk_container_unblock_resize(value container)
{
  gtk_container_set_resize_mode(GtkContainer_ml(container),
		  GTK_RESIZE_IMMEDIATE);
  return Val_unit;
}

value mlgtk_container_need_resize(value container)
{
  gtk_container_check_resize(GtkContainer_ml(container));
  return Val_unit;
}

value mlgtk_container_foreach(value container, value func)
{
  value *cbk = (value*) malloc(sizeof(value));
  register_global_root(cbk);
  *cbk = func;
  gtk_container_foreach_full(GtkContainer_ml(container), NULL, 
    (GtkCallbackMarshal) mlgtk_callback_exec,
    cbk, (GtkDestroyNotify) mlgtk_callback_destroy);
  return Val_unit;
}

value mlgtk_container_focus(value container, value direction_type)
{
  gtk_container_focus(GtkContainer_ml(container), Int_val(direction_type));
  return Val_unit;
}

/* ### 5.15 Curve widget */
value mlgtk_curve_reset(value curve)
{
  gtk_curve_reset(GtkCurve_ml(curve));
  return Val_unit;
}

value mlgtk_curve_set_gamma(value curve, value gamma)
{
  gtk_curve_set_gamma(GtkCurve_ml(curve), Double_val(gamma));
  return Val_unit;
}

value mlgtk_curve_set_range(value curve, value min_x, value max_x,
  value min_y, value max_y)
{
  gtk_curve_set_range(GtkCurve_ml(curve), Double_val(min_x), Double_val(max_x),
    Double_val(min_y), Double_val(max_y));
  return Val_unit;
}

/* works only if gfloat = double */
value mlgtk_curve_get_vector(value curve, value vector)
{
  gtk_curve_get_vector(GtkCurve_ml(curve), Double_array_length(vector), (gfloat*) vector);
  return Val_unit;
}

value mlgtk_curve_set_vector(value curve, value vector)
{
  gtk_curve_set_vector(GtkCurve_ml(curve), Double_array_length(vector), (gfloat*) vector);
  return Val_unit;
}

value mlgtk_curve_set_curve_type(value curve, value type)
{
  gtk_curve_set_curve_type(GtkCurve_ml(curve), Int_val(type));
  return Val_unit;
}

/* ### 5.16 Gamma curve widget */

/* ### 5.17 Dialog widget */
value mlgtk_dialog_get_action_area(value dialog)
{
  check_GtkObject_ml(dialog, "Gtk.dialog_get_action_area");
  return ml_GtkObject(GtkDialog_ml(dialog)->action_area);
}

value mlgtk_dialog_get_vbox(value dialog)
{
  check_GtkObject_ml(dialog, "Gtk.dialog_get_vbox_area");
  return ml_GtkObject(GtkDialog_ml(dialog)->vbox);
}

/* ### 5.18 Drawing area widget */
value mlgtk_drawing_area_size(value darea,
  gint width, gint height)
{
  check_GtkObject_ml(darea, "Gtk.drawin_area_size");
  gtk_drawing_area_size(GtkDrawingArea_ml(darea),
    Int_val(width), Int_val(height));
  return Val_unit;
}

/* ### 5.19 Entry widget */
value mlgtk_entry_new(value dummy)
{
  return ml_GtkObject(gtk_entry_new());
}

value mlgtk_entry_new_with_max_length(value len)
{
  return ml_GtkObject( gtk_entry_new_with_max_length((guint16) Int_val(len)) ) ;
}

value mlgtk_entry_set_text(value entry,value text)
{
  check_GtkObject_ml(entry, "Gtk.Unsafe.entry_set_text");
  gtk_entry_set_text(GtkEntry_ml(entry),String_val(text ));
  return Val_unit;
}

value mlgtk_entry_append_text(value entry, value text)
{ 
  gtk_entry_append_text(GtkEntry_ml(entry),String_val(text ));
  return Val_unit;
}

value mlgtk_entry_prepend_text(value entry, value text)
{ 
  gtk_entry_prepend_text(GtkEntry_ml(entry),String_val(text ));
  return Val_unit;
}

value mlgtk_entry_set_position(value entry, value position)
{
  gtk_entry_set_position(GtkEntry_ml(entry), Int_val(position));
  return Val_unit;
}

value mlgtk_entry_set_visibility(value entry, value visibility)
{
  gtk_entry_set_visibility(GtkEntry_ml(entry), Bool_val(visibility));
  return Val_unit;
}

value mlgtk_entry_get_text(value entry)
{
  value return_value;
  gchar* gtk_string;
  check_GtkObject_ml(entry, "Gtk.Unsafe.entry_get_text");
  gtk_string = gtk_entry_get_text(GtkEntry_ml(entry));
  /* THIS copy_string IS NOT A MEMORY LEAK.  */
  return_value = copy_string( gtk_string );
  return return_value;
}

/* ### 5.21 File selection widget  */

/* GtkWidget* gtk_file_selection_new (gchar *TITLE) */
value mlgtk_file_selection_new (value TITLE)
{
  return ml_GtkObject(gtk_file_selection_new(String_val(TITLE)));
}

/*void gtk_file_selection_set_filename 
  (GtkFileSelection *FILESEL, gchar *FILENAME) */

value mlgtk_file_selection_set_filename (value FILESEL, 
				       value FILENAME)
{
  check_GtkObject_ml(FILESEL, "Gtk.Unsafe.file_selection_set_filename");
  gtk_file_selection_set_filename(GtkFileSelection_ml(FILESEL),
				  String_val(FILENAME));
  return Val_unit;
}

value mlgtk_file_selection_complete (value FILESEL, 
				       value PATTERN)
{
  check_GtkObject_ml(FILESEL, "Gtk.Unsafe.file_selection_complete");
  gtk_file_selection_complete(GtkFileSelection_ml(FILESEL),
				  String_val(PATTERN));
  return Val_unit;
}

/* gchar* gtk_file_selection_get_filename (GtkFileSelection *FILESEL) */
value mlgtk_file_selection_get_filename (value FILESEL)
{
  value return_value;
  gchar* gtk_string;
  check_GtkObject_ml(FILESEL, "Gtk.Unsafe.file_selection_get_filename");
  gtk_string = gtk_file_selection_get_filename(GtkFileSelection_ml(FILESEL));
  /* THIS copy_string IS NOT A MEMORY LEAK.  */
  return_value = copy_string(gtk_string);
  return return_value;
}

value mlgtk_file_selection_get_ok_button (value FILESEL)
{
  check_GtkObject_ml(FILESEL, "Gtk.Unsafe.file_selection_get_ok_button");
  return
    ml_GtkObject ((GtkFileSelection_ml(FILESEL))->ok_button) ;
}

value mlgtk_file_selection_get_cancel_button (value FILESEL)
{
  check_GtkObject_ml(FILESEL, "Gtk.Unsafe.file_selection_get_cancel_button");
  return
    ml_GtkObject ((GtkFileSelection_ml(FILESEL))->cancel_button) ;
}


/* ### 5.23 Frame widget   DONE */
value mlgtk_frame_new(value label)
{
  return ml_GtkObject(gtk_frame_new(String_val(label)));
}

value mlgtk_frame_set_shadow_type(value frame,value type)
{
  check_GtkObject_ml(frame, "Gtk.Unsafe.frame_set_shadow_type");
  gtk_frame_set_shadow_type(GtkFrame_ml(frame),Int_val(type));
  return Val_unit;
}

value mlgtk_frame_set_label(value frame,value label)
{
  check_GtkObject_ml(frame, "Gtk.Unsafe.frame_set_label");
  gtk_frame_set_label(GtkFrame_ml(frame), String_val(label));
  return Val_unit;
}

value mlgtk_frame_set_label_align(value frame,value xalign,value yalign)
{
  check_GtkObject_ml(frame, "Gtk.Unsafe.frame_set_label_align");
  gtk_frame_set_label_align(GtkFrame_ml(frame), Double_val(xalign), Double_val(yalign));
  return Val_unit;
}

/* ### 5.25 Horizontal box widget */
value mlgtk_hbox_new(value homogeneous, value spacing)
{
  return ml_GtkObject(gtk_hbox_new(Int_val(homogeneous), Int_val(spacing)));
}

/* ### Horizontal button box widget */
value mlgtk_hbutton_box_new(value dummy)
{
  return ml_GtkObject(gtk_hbutton_box_new ());
}

/* ### 5.27 Horizontal paned widget */
value mlgtk_hpaned_new(value dummy)
{
  return ml_GtkObject(gtk_hpaned_new());
}

/* ### 5.30 Horizontal scrollbar widget DONE */
value mlgtk_hscrollbar_new(value adj)
{
  return ml_GtkObject(gtk_hscrollbar_new(GtkAdjustment_optionptr_ml(adj)));
}

/* ### 5.31 Horizontal separator widget DONE */
value mlgtk_hseparator_new(value dummy)
{
  return ml_GtkObject(gtk_hseparator_new ());
}

/* ### 5.32 Image widget */

/* ### 5.33 Input dialog widget */

/* ### 5.34 Item widget */

/* ### 5.35 Label widget */
value mlgtk_label_new(value str)
{
  return ml_GtkObject(gtk_label_new(String_val(str)));
}

value mlgtk_label_set_text (value label, value str)
{
  check_GtkObject_ml(label, "Gtk.Unsafe.label_set");
  gtk_label_set_text(GtkLabel_ml(label),String_val(str));
  return Val_unit;  
}

/*
value mlgtk_label_set_justify (value label, value jtype)
{
  check_GtkObject_ml(label, "Gtk.Unsafe.label_set_justify");
  gtk_label_set_justify(GtkLabel_ml(label),);
  return Val_unit;
}
*/

value mlgtk_label_get (value label)
{
  char *t;
  check_GtkObject_ml(label, "Gtk.Unsafe.label_get");
  gtk_label_get(GtkLabel_ml(label), &t);
  /* THIS copy_string IS NOT A MEMORY LEAK.  */
  return copy_string(t);
}



/* ### 5.36 List widget */
value mlgtk_list_new(value dummy)
{
  return ml_GtkObject(gtk_list_new());
}

value mlgtk_list_insert_items(value list, value items, value index)
{
  gtk_list_insert_items(GtkList_ml(list), (GList*) items, Int_val(index));
  return Val_unit;
}


value mlgtk_list_append_items(value list, value items)
{
  gtk_list_append_items(GtkList_ml(list), (GList*) items);
  return Val_unit;
}

/* ### 5.37 List item widget */

value mlgtk_list_item_select         (value list_item)
{
  check_GtkObject_ml(list_item, "Gtk.Unsafe.list_item_select"); 
  gtk_list_item_select(GtkListItem_ml(list_item));
  return Val_unit;
}

value mlgtk_list_item_deselect       (value list_item)
{
  check_GtkObject_ml(list_item, "Gtk.Unsafe.list_item_deselect"); 
  gtk_list_item_deselect(GtkListItem_ml(list_item));
  return Val_unit;
}

value mlgtk_list_item_new_with_label(value s)
{
  return ml_GtkObject(gtk_list_item_new_with_label(String_val(s)));
}

/* ### 5.38 Menu widget */
value mlgtk_menu_new(value dummy)
{
  return ml_GtkObject(gtk_menu_new());
}

value mlgtk_menu_append(value menu, value child)
{
  check_GtkObject_ml(menu, "Gtk.Unsafe.menu_append"); 
  check_GtkObject_ml(child, "Gtk.Unsafe.menu_append"); 
  gtk_menu_append(GtkMenu_ml(menu), GtkWidget_ml(child));
  return Val_unit;
}

/*
void gtk_menu_prepend (GtkMenu *menu,
		       GtkWidget *child);
void gtk_menu_insert (GtkMenu *menu,
		      GtkWidget *child,
		      gint position);
*/
value mlgtk_menu_prepend (value menu, value child)
{
  check_GtkObject_ml(menu, "Gtk.Unsafe.menu_prepend"); 
  check_GtkObject_ml(child, "Gtk.Unsafe.menu_prepend"); 
  gtk_menu_prepend(GtkMenu_ml(menu), GtkWidget_ml(child));
  return Val_unit;  
}

value mlgtk_menu_insert (value menu, value child, value position)
{
  check_GtkObject_ml(menu, "Gtk.Unsafe.menu_insert"); 
  check_GtkObject_ml(child, "Gtk.Unsafe.menu_insert"); 
  gtk_menu_insert(GtkMenu_ml(menu), GtkWidget_ml(child), Int_val(position));
  return Val_unit;  
}

/*
void gtk_menu_popup (GtkMenu *menu,
		     GtkWidget *parent_menu_shell,
		     GtkWidget *parent_menu_item,
		     GtkMenuPositionFunc func,
		     gpointer data,
		     guint button,
		     guint32 activate_time);
*/
/*
value mlgtk_menu_popup (value menu, value parent_menu_shell,
		 value parent_menu_item, GtkMenuPositionFunc func,
		 value data, value button, value activate_time)
{
}
*/

/* void gtk_menu_popdown (GtkMenu *menu);*/
value mlgtk_menu_popdown (value menu)
{
  check_GtkObject_ml(menu, "Gtk.Unsafe.menu_popdown"); 
  gtk_menu_popdown (GtkMenu_ml(menu));
  return Val_unit;  
}

/* GtkWidget* gtk_menu_get_active (GtkMenu *menu);*/
value mlgtk_menu_get_active (value menu)
{
  check_GtkObject_ml(menu, "Gtk.Unsafe.menu_get_active"); 
  return ml_GtkObject(gtk_menu_get_active (GtkMenu_ml(menu)));
}

/* void gtk_menu_set_active (GtkMenu *menu, guint index); */
value mlgtk_menu_set_active (value menu, value index)
{ 
  check_GtkObject_ml(menu, "Gtk.Unsafe.menu_set_active"); 
  gtk_menu_set_active (GtkMenu_ml(menu), Int_val(index));
  return Val_unit;  
}

/*
void gtk_menu_set_accelerator_table (GtkMenu *menu, GtkAcceleratorTable *table);
*/
/*
value mlgtk_menu_set_accelerator_table (value menu, 
				      value table)
{
}
*/

/*
void gtk_menu_attach_to_widget (GtkMenu *menu,
				GtkWidget *attach_widget,
				GtkMenuDetachFunc detacher);
*/
/*
value mlgtk_menu_attach_to_widget (value menu,
				 value attach_widget,
				 GtkMenuDetachFunc detacher)
{
}
*/

/*
void gtk_menu_attach_to_widget (GtkMenu *menu,
				GtkWidget *attach_widget,
				GtkMenuDetachFunc detacher);
GtkWidget* gtk_menu_get_attach_widget (GtkMenu *menu);
void gtk_menu_detach (GtkMenu *menu);
*/
/*
value mlgtk_menu_get_attach_widget (value menu)
{
}
*/
/*
value mlgtk_menu_detach (value menu)
{
}
*/

/* ### 5.39 Menu bar widget DONE */
value mlgtk_menu_bar_new(value dummy)
{
  return ml_GtkObject(gtk_menu_bar_new());
}

value mlgtk_menu_bar_append(value obj1, value obj2)
{
  check_GtkObject_ml(obj1, "Gtk.Unsafe.menu_bar_append");
  check_GtkObject_ml(obj2, "Gtk.Unsafe.menu_bar_append");
  gtk_menu_bar_append(GtkMenuBar_ml(obj1), GtkWidget_ml(obj2));
  return Val_unit;
}

/*void       gtk_menu_bar_prepend  (GtkMenuBar *menu_bar, GtkWidget  *child);*/
value mlgtk_menu_bar_prepend(value obj1, value obj2)
{
  check_GtkObject_ml(obj1, "Gtk.Unsafe.menu_bar_prepend");
  check_GtkObject_ml(obj2, "Gtk.Unsafe.menu_bar_prepend");
  gtk_menu_bar_prepend(GtkMenuBar_ml(obj1), GtkWidget_ml(obj2));
  return Val_unit;
}

/*
void       gtk_menu_bar_insert   (GtkMenuBar *menu_bar,
                                  GtkWidget  *child,
                                  gint        position);
*/
value mlgtk_menu_bar_insert(value obj1, value obj2, value position)
{
  check_GtkObject_ml(obj1, "Gtk.Unsafe.menu_bar_insert");
  check_GtkObject_ml(obj2, "Gtk.Unsafe.menu_bar_insert");
  gtk_menu_bar_insert(GtkMenuBar_ml(obj1), GtkWidget_ml(obj2), Int_val(position));
  return Val_unit;
}



/* ### 5.40 Menu item widget */
value mlgtk_menu_item_new_with_label(value str)
{
  return ml_GtkObject(gtk_menu_item_new_with_label(String_val(str)));
}

value mlgtk_menu_item_set_submenu(value obj1, value obj2)
{
  check_GtkObject_ml(obj1, "Gtk.Unsafe.menu_item_set_submenu");
  check_GtkObject_ml(obj2, "Gtk.Unsafe.menu_item_set_submenu");
  gtk_menu_item_set_submenu(GtkMenuItem_ml(obj1), GtkWidget_ml(obj2));
  return Val_unit;
}

value mlgtk_menu_item_select (value menu_item)
{
  check_GtkObject_ml(menu_item, "Gtk.Unsafe.item_select");
  gtk_menu_item_select(GtkMenuItem_ml(menu_item));
  return Val_unit;
}  

value mlgtk_menu_item_deselect (value menu_item)
{
  check_GtkObject_ml(menu_item, "Gtk.Unsafe.item_deselect");
  gtk_menu_item_deselect(GtkMenuItem_ml(menu_item));
  return Val_unit;
}  

/* ### 5.41 Menu shell widget */

value mlgtk_menu_shell_append(value obj1, value obj2)
{
  check_GtkObject_ml(obj1, "Gtk.Unsafe.menu_shell_append");
  check_GtkObject_ml(obj2, "Gtk.Unsafe.menu_shell_append");
  gtk_menu_shell_append(GtkMenuShell_ml(obj1), GtkWidget_ml(obj2));
  return Val_unit;
}

value mlgtk_menu_shell_prepend(value obj1, value obj2)
{
  check_GtkObject_ml(obj1, "Gtk.Unsafe.menu_shell_prepend");
  check_GtkObject_ml(obj2, "Gtk.Unsafe.menu_shell_prepend");
  gtk_menu_shell_prepend(GtkMenuShell_ml(obj1), GtkWidget_ml(obj2));
  return Val_unit;
}

value mlgtk_menu_shell_insert(value obj1, value obj2, value position)
{
  check_GtkObject_ml(obj1, "Gtk.Unsafe.menu_shell_insert");
  check_GtkObject_ml(obj2, "Gtk.Unsafe.menu_shell_insert");
  gtk_menu_shell_insert(GtkMenuShell_ml(obj1), GtkWidget_ml(obj2), Int_val(position));
  return Val_unit;
}


/* ### 5.42 Misc widget */

/* ### 5.43 Notebook widget DONE */
value mlgtk_notebook_new(value dummy)
{
  return ml_GtkObject(gtk_notebook_new());
}

value mlgtk_notebook_append_page(value notebook,value page,value label)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_append_page");
  check_GtkObject_ml(page, "Gtk.Unsafe.notebook_append_page");
  check_GtkObject_ml(label, "Gtk.Unsafe.notebook_append_page");
  gtk_notebook_append_page(GtkNotebook_ml(notebook),GtkWidget_ml(page),
			   GtkWidget_ml(label));
  return Val_unit;
}
value mlgtk_notebook_append_page_menu(value notebook,value page,value label, value menu)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_append_page_menu");
  check_GtkObject_ml(page, "Gtk.Unsafe.notebook_append_page_menu");
  check_GtkObject_ml(label, "Gtk.Unsafe.notebook_append_page_menu");
  check_GtkObject_ml(menu, "Gtk.Unsafe.notebook_append_page_menu");
  gtk_notebook_append_page_menu(GtkNotebook_ml(notebook),GtkWidget_ml(page),
			   GtkWidget_ml(label), GtkWidget_ml(menu));
  return Val_unit;
}

value mlgtk_notebook_prepend_page(value notebook,value page,value label)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_prepend_page");
  check_GtkObject_ml(page, "Gtk.Unsafe.notebook_prepend_page");
  check_GtkObject_ml(label, "Gtk.Unsafe.notebook_prepend_page");
  gtk_notebook_prepend_page(GtkNotebook_ml(notebook),GtkWidget_ml(page),
			   GtkWidget_ml(label));
  return Val_unit;
}

value mlgtk_notebook_prepend_page_menu(value notebook,value page,value label,value menu)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_prepend_page_menu");
  check_GtkObject_ml(page, "Gtk.Unsafe.notebook_prepend_page_menu");
  check_GtkObject_ml(label, "Gtk.Unsafe.notebook_prepend_page_menu");
  check_GtkObject_ml(menu, "Gtk.Unsafe.notebook_prepend_page_menu");
  gtk_notebook_prepend_page_menu(GtkNotebook_ml(notebook),GtkWidget_ml(page),
			   GtkWidget_ml(label), GtkWidget_ml(menu));
  return Val_unit;
}

value mlgtk_notebook_insert_page(value notebook,value page,value label,
				 value pos)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_insert_page");
  check_GtkObject_ml(page, "Gtk.Unsafe.notebook_insert_page");
  check_GtkObject_ml(label, "Gtk.Unsafe.notebook_insert_page");
  gtk_notebook_insert_page(GtkNotebook_ml(notebook),GtkWidget_ml(page),
			   GtkWidget_ml(label),Int_val(pos));
  return Val_unit;
}
value mlgtk_notebook_insert_page_menu(value notebook,value page,value label,
				 value menu, value pos)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_insert_page_menu");
  check_GtkObject_ml(page, "Gtk.Unsafe.notebook_insert_page_menu");
  check_GtkObject_ml(label, "Gtk.Unsafe.notebook_insert_page_menu");
  check_GtkObject_ml(menu, "Gtk.Unsafe.notebook_insert_page_menu");
  gtk_notebook_insert_page_menu(GtkNotebook_ml(notebook),GtkWidget_ml(page),
			   GtkWidget_ml(label),GtkWidget_ml(menu),
			   Int_val(pos));
  return Val_unit;
}
value mlgtk_notebook_remove_page(value notebook,value page_num)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_remove_page");
  gtk_notebook_remove_page(GtkNotebook_ml(notebook), Int_val(page_num));
  return Val_unit;
}

value mlgtk_notebook_get_current_page(value notebook)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_get_current_page");
  return Val_int(gtk_notebook_get_current_page(GtkNotebook_ml(notebook)));
}

value mlgtk_notebook_get_nth_page(value notebook, value page_num)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_get_nth_page");
  return ml_GtkObject(gtk_notebook_get_nth_page(GtkNotebook_ml(notebook), Int_val(page_num)));
}

value mlgtk_notebook_page_num(value notebook, value child)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_page_num");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_page_num");
  return Val_int(gtk_notebook_page_num(GtkNotebook_ml(notebook),GtkWidget_ml(child)));
}

value mlgtk_notebook_set_page(value notebook,value page_num)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_page");
  gtk_notebook_set_page(GtkNotebook_ml(notebook), Int_val(page_num));
  return Val_unit;
}

value mlgtk_notebook_next_page(value notebook)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_next_page");
  gtk_notebook_next_page(GtkNotebook_ml(notebook));
  return Val_unit;
}

value mlgtk_notebook_prev_page(value notebook)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_prev_page");
  gtk_notebook_prev_page(GtkNotebook_ml(notebook));
  return Val_unit;
}

value mlgtk_notebook_set_show_border(value notebook,value show_border)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_show_border");
  gtk_notebook_set_show_border(GtkNotebook_ml(notebook), Int_val(show_border));
  return Val_unit;
}

value mlgtk_notebook_set_show_tabs(value notebook,value show_tabs)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_show_tabs");
  gtk_notebook_set_show_tabs(GtkNotebook_ml(notebook), Int_val(show_tabs));
  return Val_unit;
}

value mlgtk_notebook_set_tab_pos(value notebook,value pos)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_tab_pos");
  gtk_notebook_set_tab_pos(GtkNotebook_ml(notebook), Int_val(pos));
  return Val_unit;
}

value mlgtk_notebook_set_homogeneous_tabs(value notebook,value homogeneous)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_homogeneous_tabs");
  gtk_notebook_set_homogeneous_tabs(GtkNotebook_ml(notebook), Int_val(homogeneous));
  return Val_unit;
}

value mlgtk_notebook_set_tab_border(value notebook,value border_width)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_tab_border");
  gtk_notebook_set_tab_border(GtkNotebook_ml(notebook), Int_val(border_width));
  return Val_unit;
}

value mlgtk_notebook_set_tab_hborder(value notebook,value tab_hborder)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_tab_hborder");
  gtk_notebook_set_tab_hborder(GtkNotebook_ml(notebook), Int_val(tab_hborder));
  return Val_unit;
}

value mlgtk_notebook_set_tab_vborder(value notebook,value tab_vborder)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_tab_vborder");
  gtk_notebook_set_tab_vborder(GtkNotebook_ml(notebook), Int_val(tab_vborder));
  return Val_unit;
}

value mlgtk_notebook_set_scrollable(value notebook,value scrollable)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_scrollable");
  gtk_notebook_set_scrollable(GtkNotebook_ml(notebook), Int_val(scrollable));
  return Val_unit;
}

value mlgtk_notebook_popup_enable(value notebook)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_popup_enable");
  gtk_notebook_popup_enable(GtkNotebook_ml(notebook));
  return Val_unit;
}

value mlgtk_notebook_popup_disable(value notebook)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_popup_disable");
  gtk_notebook_popup_disable(GtkNotebook_ml(notebook));
  return Val_unit;
}

value mlgtk_notebook_get_tab_label(value notebook, value child)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_get_tab_label");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_get_tab_label");
  return ml_GtkObject(gtk_notebook_get_tab_label(GtkNotebook_ml(notebook), GtkWidget_ml(child)));
}

value mlgtk_notebook_set_tab_label(value notebook, value child, value tab_label)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_tab_label");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_set_tab_label");
  check_GtkObject_ml(tab_label, "Gtk.Unsafe.notebook_set_tab_label");
  gtk_notebook_set_tab_label(GtkNotebook_ml(notebook),GtkWidget_ml(child), GtkWidget_ml(tab_label));
  return Val_unit;
}

value mlgtk_notebook_set_tab_label_text(value notebook, value child,
		value tab_text)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_tab_label_text");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_set_tab_label_text");
  gtk_notebook_set_tab_label_text(GtkNotebook_ml(notebook),GtkWidget_ml(child),
                             String_val(tab_text));
  return Val_unit;
}

value mlgtk_notebook_get_menu_label(value notebook, value child)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_get_menu_label");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_get_menu_label");
  return ml_GtkObject(gtk_notebook_get_menu_label(GtkNotebook_ml(notebook), GtkWidget_ml(child)));
}

value mlgtk_notebook_set_menu_label(value notebook, value child, value menu_label)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_menu_label");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_set_menu_label");
  check_GtkObject_ml(menu_label, "Gtk.Unsafe.notebook_set_menu_label");
  gtk_notebook_set_menu_label(GtkNotebook_ml(notebook),GtkWidget_ml(child), GtkWidget_ml(menu_label));
  return Val_unit;
}

value mlgtk_notebook_set_menu_label_text(value notebook, value child,
		value menu_text)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_menu_label_text");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_set_menu_label_text");
  gtk_notebook_set_menu_label_text(GtkNotebook_ml(notebook),GtkWidget_ml(child),
                             String_val(menu_text));
  return Val_unit;
}

/* Not implemented, should put the result in a record or something such ... */
value mlgtk_notebook_query_tab_label_packing(value notebook, value child)
{
  gint expand, fill;
  GtkPackType pack_type;
  value r;
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_query_tab_label_packing");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_query_tab_label_packing");

  gtk_notebook_query_tab_label_packing(GtkNotebook_ml(notebook),
		  GtkWidget_ml(child), &expand, &fill, &pack_type);

  r=alloc_tuple(3);
  Field(r, 0)= Val_bool(expand);
  Field(r, 1)= Val_bool(fill);
  Field(r, 2)= Val_int(pack_type);
  return r;  
}

value mlgtk_notebook_set_tab_label_packing(value notebook, value child,
		value expand, value fill, value pack_type)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_tab_label_packing");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_set_tab_label_packing");
  gtk_notebook_set_tab_label_packing(GtkNotebook_ml(notebook),GtkWidget_ml(child),
		  Int_val(expand), Int_val(fill), Int_val(pack_type));
  return Val_unit;
}

value mlgtk_notebook_reorder_child(value notebook, value child, value position)
{
  check_GtkObject_ml(notebook, "Gtk.Unsafe.notebook_set_tab_label_packing");
  check_GtkObject_ml(child, "Gtk.Unsafe.notebook_set_tab_label_packing");
  gtk_notebook_reorder_child(GtkNotebook_ml(notebook),GtkWidget_ml(child),
		  Int_val(position));
  return Val_unit;
}

/* ### 5.45 Paned widget DONE */
value mlgtk_paned_add1(value ml_paned,value ml_widget)
{
  check_GtkObject_ml(ml_paned, "Gtk.Unsafe.paned_add1");
  check_GtkObject_ml(ml_widget, "Gtk.Unsafe.paned_add1");
  gtk_paned_add1(GtkPaned_ml(ml_paned),GtkWidget_ml(ml_widget));
  return Val_unit;
}


value mlgtk_paned_add2(value ml_paned,value ml_widget)
{
  check_GtkObject_ml(ml_paned, "Gtk.Unsafe.paned_add2");
  check_GtkObject_ml(ml_widget, "Gtk.Unsafe.paned_add2");
  gtk_paned_add2(GtkPaned_ml(ml_paned),GtkWidget_ml(ml_widget));
  return Val_unit;
}


value mlgtk_paned_handle_size(value ml_paned,value size)
{
  check_GtkObject_ml(ml_paned, "Gtk.Unsafe.paned_handle_size");
  gtk_paned_handle_size(GtkPaned_ml(ml_paned),(guint16)Int_val(size));
  return Val_unit;
}

value mlgtk_paned_gutter_size(value ml_paned,value size)
{
  check_GtkObject_ml(ml_paned, "Gtk.Unsafe.paned_gutter_size");
  gtk_paned_gutter_size(GtkPaned_ml(ml_paned),(guint16)Int_val(size));
  return Val_unit;
}

/* ### 5.46 Pixmap widget */
value mlgtk_pixmap_new (value pixmap, value mask)
{
  /* would befine to do this, but it is not implemented.
  check_GdkObject_ml(pixmap, "Gtk.Unsafe.mlgtk_pixmap_new");
  check_GdkObject_ml(mask, "Gtk.Unsafe.mlgtk_pixmap_new");
  */
  return ml_GtkObject (gtk_pixmap_new (GdkPixmap_ml(pixmap),
				       GdkBitmap_ml(mask))) ;
}

/* ### 5.47 Preview widget */

/* ### 5.48 Progress bar widget DONE */
value mlgtk_progress_bar_new(value dummy)
{
  return ml_GtkObject(gtk_progress_bar_new ());
}

value mlgtk_progress_bar_update(value pbar, value ratio)
{
  gtk_progress_bar_update(GtkProgressBar_ml(pbar), (gfloat) Double_val(ratio));
  return Val_unit;
}

/* ### 5.49 Radio button widget */
value mlgtk_radio_button_new_with_label(value group, value label)
{
  return ml_GtkObject(gtk_radio_button_new_with_label(
    optionptr_ml(group), String_val(label)));
}

/* ### 5.50 Radio menu item widget */
value mlgtk_radio_menu_item_new_with_label(value group, value label)
{
  return ml_GtkObject(gtk_radio_menu_item_new_with_label(
    optionptr_ml(group), String_val(label)));
}

/* ### 5.55 Scrolled window widget */
value mlgtk_scrolled_window_new (value dummy)
{
  return ml_GtkObject(gtk_scrolled_window_new (NULL, NULL));
  /* FIXME : should take 2 arguments GtkAdjustment */
}

value mlgtk_scrolled_window_add_with_viewport (
	  value scrolled_window, value widget)
{
  check_GtkObject_ml(scrolled_window, 
               "Gtk.Unsafe.scrolled_window_add_with_viewport");
  check_GtkObject_ml(widget, "Gtk.Unsafe.scrolled_window_add_with_viewport");
  gtk_scrolled_window_add_with_viewport(GtkScrolledWindow_ml(scrolled_window),
                                        GtkWidget_ml(widget));
  return Val_unit;
}

value mlgtk_table_new(value nbrows, value nbcols, value homogeneous)
{
  return ml_GtkObject(gtk_table_new(Int_val(nbrows),
                                    Int_val(nbcols),
                                    Int_val(homogeneous)));
}

gint mlgtk_convert_options(value option)
{
  gint r=0;
  while (option != Val_int(0))
    {
      r |= 1<< (Int_val(Field(option,0)));
      option = Field(option, 1);
    }
  return r;
}



value mlgtk_table_attach(value table, value child,
                         value left_attach, value right_attach,
                         value top_attach, value bottom_attach,
                         value xoptions, value yoptions,
                         value xpadding, value ypadding)
{
  gtk_table_attach(GtkTable_ml(table), GtkWidget_ml(child),
                   Int_val(left_attach), Int_val(right_attach),
                   Int_val(top_attach), Int_val(bottom_attach),
                   mlgtk_convert_options(xoptions),
                   mlgtk_convert_options(yoptions),
                   Int_val(xpadding), Int_val(ypadding));
  return Val_unit;
}

value mlgtk_true_table_attach (value *argv, int argn)
{
  return mlgtk_table_attach(argv[0], argv[1], argv[2], argv[3], argv[4],
                            argv[5], argv[6], argv[7], argv[8], argv[9]);
}



/* ### 5.57 Statusbar widget */
value mlgtk_statusbar_new (value unit)
{
  return ml_GtkObject(gtk_statusbar_new());
}
value mlgtk_statusbar_get_context_id (value statusbar, value context_desc)
{
  check_GtkObject_ml(statusbar, "mlgtk_statusbar_get_context_id");
  return Val_int(gtk_statusbar_get_context_id(GtkStatusbar_ml(statusbar),
    String_val(context_desc))); 
}
value mlgtk_statusbar_push (value statusbar, value context_id, value text)
{
  check_GtkObject_ml(statusbar, "mlgtk_statusbar_push");
  return Val_int(gtk_statusbar_push(GtkStatusbar_ml(statusbar),
    Int_val(context_id), String_val(text))); 
}
value mlgtk_statusbar_pop (value statusbar, value context_id)
{
  check_GtkObject_ml(statusbar, "mlgtk_statusbar_pop");
  gtk_statusbar_pop(GtkStatusbar_ml(statusbar), Int_val(context_id));
  return Val_unit;
}
value mlgtk_statusbar_remove (value statusbar, value context_id, value mesg_id)
{
  check_GtkObject_ml(statusbar, "mlgtk_statusbar_remove");
  gtk_statusbar_remove(GtkStatusbar_ml(statusbar), Int_val(context_id),
    Int_val(mesg_id));
  return Val_unit;
}

/* ### 5.59 Text widget */
value mlgtk_text_new(value dummy)
{
  GtkWidget* text;
  text = gtk_text_new (NULL,NULL); /* pcuoq : NULL at least until GtkAdjustment 
				      is documented */
  return ml_GtkObject(text);
}
value mlgtk_text_get_vadj(value text)
{
  check_GtkObject_ml(text, "Gtk.Unsafe.text_get_vadj");
  return (value) GTK_TEXT(text)->vadj ;
}
value mlgtk_text_get_hadj(value text)
{
  check_GtkObject_ml(text, "Gtk.Unsafe.text_get_hadj");
  return (value) GTK_TEXT(text)->hadj ;
}
value mlgtk_text_set_editable(value ml_text,value flag)
{
  check_GtkObject_ml(ml_text, "Gtk.Unsafe.text_set_editable");
  gtk_text_set_editable (GtkText_ml(ml_text), Bool_val(flag));
  return Val_unit;
}

/* Function: void gtk_text_insert (GtkText *TEXT, GdkFont *FONT,
           GdkColor *FORE, GdkColor *BACK, char *CHARS, gint LENGTH) */
value mlgtk_text_insert(value ml_text, value ml_font, value ml_chars, value start, value length)
{
  check_GtkObject_ml(ml_text, "Gtk.Unsafe.text_insert");
#ifdef DEBUG
  fprintf(stderr,"debug : %d %d\n",Int_val(start), Int_val(length));
#endif
  gtk_text_insert(GtkText_ml(ml_text),optionptr_ml(ml_font),NULL,NULL,
		  String_val(ml_chars)+Int_val(start), Int_val(length) );
  return Val_unit;
}
value mlgtk_text_freeze(value mltext)
{
  check_GtkObject_ml(mltext, "Gtk.Unsafe.text_freeze");
  gtk_text_freeze(GtkText_ml(mltext));
  return Val_unit;
}
value mlgtk_text_thaw(value mltext)
{
  check_GtkObject_ml(mltext, "Gtk.Unsafe.text_thaw");
  gtk_text_thaw(GtkText_ml(mltext));
  return Val_unit;
}
value mlgtk_text_forward_delete(value mltext,value n)
{
  check_GtkObject_ml(mltext, "Gtk.Unsafe.text_forward_delete");
  return Val_int( gtk_text_forward_delete(GtkText_ml(mltext),Int_val(n)) ) ;
}
value mlgtk_text_get_point(value mltext)
{
  int p ;
  check_GtkObject_ml(mltext, "Gtk.Unsafe.text_get_length");
  p = gtk_text_get_point(GtkText_ml(mltext)) ;
  return Val_int(p);
}
value mlgtk_text_set_point(value mltext, value p)
{
  check_GtkObject_ml(mltext, "Gtk.Unsafe.text_get_length");
  gtk_text_set_point(GtkText_ml(mltext), Int_val(p)) ;
  return Val_unit;
}
value mlgtk_text_get_length(value mltext)
{
  int length ;
  check_GtkObject_ml(mltext, "Gtk.Unsafe.text_get_length");
  length = gtk_text_get_length(GtkText_ml(mltext)) ;
  return Val_int(length);
}
value mlgtk_text_backward_delete(value mltext,value n)
{
  check_GtkObject_ml(mltext, "Gtk.Unsafe.text_backward_delete");
  return Val_int( gtk_text_backward_delete(GtkText_ml(mltext),Int_val(n)) ) ;
}

/* ### 5.60 Toggle button widget */
value mlgtk_toggle_button_new(value unit)
{
  return ml_GtkObject(gtk_toggle_button_new());
}

value mlgtk_toggle_button_set_active(value button, value flag)
{
  check_GtkObject_ml(button, "Gtk.Unsafe.toggle_button_set_active");
  gtk_toggle_button_set_active(GtkToggleButton_ml(button), Int_val(flag));
  return Val_unit;
}


value mlgtk_toggle_button_new_with_label(value label)
{
  return ml_GtkObject(gtk_toggle_button_new_with_label(String_val(label)));
}

value mlgtk_toggle_button_set_state(value button, value state)
{
  check_GtkObject_ml(button, "Gtk.Unsafe.toggle_button_set_state");  
  gtk_toggle_button_set_state(GtkToggleButton_ml(button), Int_val(state));
  return Val_unit;
}

value mlgtk_toggle_button_set_mode(value button, value mode)
{
  check_GtkObject_ml(button, "Gtk.Unsafe.toggle_button_set_mode");  
  gtk_toggle_button_set_mode(GtkToggleButton_ml(button), Int_val(mode));
  return Val_unit;
}

value mlgtk_toggle_button_toggled(value button)
{
  check_GtkObject_ml(button, "Gtk.Unsafe.toggle_button_toggled");  
  gtk_toggle_button_toggled(GtkToggleButton_ml(button));
  return Val_unit;
}

/* ### 5.62 Tool tips widget */
value mlgtk_tooltips_new(value dummy)
{
  return ml_GtkObject(gtk_tooltips_new ());
}

value mlgtk_tooltips_set_tip (value tooltips, value widget, value str,value private)
{
  check_GtkObject_ml(tooltips, "Gtk.Unsafe.tooltips_set_tip");
  check_GtkObject_ml(widget, "Gtk.Unsafe.tooltips_set_tip");
  gtk_tooltips_set_tip (GtkTooltips_ml(tooltips),
    GtkWidget_ml(widget), String_val(str), String_val(private));
  return Val_unit;
}

/* ### 5.65 Vertical box widget */
value mlgtk_vbox_new(value homogeneous, value spacing)
{
  return ml_GtkObject(gtk_vbox_new(Int_val(homogeneous), Int_val(spacing)));
}

/* ### Vertical button box widget */
value mlgtk_vbutton_box_new(value dummy)
{
  return ml_GtkObject(gtk_vbutton_box_new ());
}


/* ### 5.67 Vertical paned widget */
value mlgtk_vpaned_new(value dummy)
{
  return ml_GtkObject(gtk_vpaned_new());
}

/* ### Vertical scrollbar widget */
value mlgtk_vscrollbar_new(value adj)
{
  return ml_GtkObject(gtk_vscrollbar_new(GtkAdjustment_optionptr_ml(adj)));
}


/* ### 5.72 Vertical separator widget */
value mlgtk_vseparator_new(value dummy)
{
  return ml_GtkObject(gtk_vseparator_new ());
}

/* ### 5.73 Base widget */
value mlgtk_widget_show(value widget)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.widget_show");
  gtk_widget_show(GtkWidget_ml(widget));
  return Val_unit;
}

value mlgtk_widget_hide(value widget)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.widget_hide");
  gtk_widget_hide(GtkWidget_ml(widget));
  return Val_unit;
}

value mlgtk_widget_unparent (value widget)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.widget_unparent");
  gtk_widget_unparent(GtkWidget_ml(widget));
  return Val_unit;
}

value mlgtk_widget_reparent (value widget, value new_parent)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.widget_reparent");
  check_GtkObject_ml(new_parent, "Gtk.Unsafe.widget_reparent");
  gtk_widget_reparent(GtkWidget_ml(widget), GtkWidget_ml(new_parent));
  return Val_unit;
}


value mlgtk_widget_realize(value mlwidget)
{
  check_GtkObject_ml(mlwidget, "Gtk.Unsafe.widget_realize");
  gtk_widget_realize(GtkWidget_ml(mlwidget));
  return Val_unit;
}

value mlgtk_widget_unrealize(value mlwidget)
{
  check_GtkObject_ml(mlwidget, "Gtk.Unsafe.widget_unrealize");
  gtk_widget_unrealize(GtkWidget_ml(mlwidget));
  return Val_unit;
}


gint mlgtk_convert_events(value events)
{
  gint r=0;
  while (events!= Val_int(0))
    {
      r |= 2<< (Int_val(Field(events,0)));
      events = Field(events, 1);
    }
  return r;
}


value mlgtk_widget_set_events(value widget, value events)
{
  gtk_widget_set_events(GtkWidget_ml(widget), mlgtk_convert_events(events));
  return Val_unit;
}

/* void gtk_widget_set_sensitive (GtkWidget *widget,
                                           gint sensitive);
*/
value mlgtk_widget_set_sensitive (value widget,
                                           value sensitive)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.widget_set_sensitive");
  gtk_widget_set_sensitive(GtkWidget_ml(widget),Int_val(sensitive));
  return Val_unit;
}

value mlgtk_widget_set_usize (value widget, value x, value y)
{
  check_GtkObject_ml(widget, "Gtk.Unsafe.widget_set_usize");
  gtk_widget_set_usize(GtkWidget_ml(widget),Int_val(x),Int_val(y));
  return Val_unit;
}

value mlgtk_widget_draw(value widget, value mlrect)
{
  GdkRectangle rect ;
#ifdef DEBUG
  fprintf (stderr, "mlgtk_widget_draw.\n");
#endif
  check_GtkObject_ml(widget, "Gtk.Unsafe.widget_show");
  rect.x = Int_val (Field (mlrect,0)) ; 
  rect.y = Int_val (Field (mlrect,1)) ; 
  rect.width = Int_val (Field (mlrect,2)) ; 
  rect.height = Int_val (Field (mlrect,3)) ; 
  gtk_widget_draw(GtkWidget_ml(widget), &rect);
  return Val_unit;
}
/* ### 5.75 Window widget */
value mlgtk_window_new(value window_type)
{
  return ml_GtkObject(gtk_window_new(Int_val(window_type)));
}

value mlgtk_window_set_title(value window, value title)
{
  check_GtkObject_ml(window, "Gtk.Unsafe.window_set_title");
  gtk_window_set_title(GtkWindow_ml(window), String_val(title));
  return Val_unit;
}

/* ### Editable widget */
value 
mlgtk_editable_insert_text(value editable,value text,value length,value position)
{
  gint gposition;
  check_GtkObject_ml(editable, "Gtk.Unsafe.editable_insert_text");
  gposition=Int_val(position);
  gtk_editable_insert_text( GtkEditable_ml(editable), String_val(text),
			     Int_val(length), &gposition );
  return Val_int(gposition);
}


value mlgtk_editable_get_position(value editable)
{
  check_GtkObject_ml(editable, "Gtk.Unsafe.editable_get_position");
  return Val_int(gtk_editable_get_position(GtkEditable_ml(editable)));
}

value mlgtk_editable_select_region(value editable,value start,value end)
{
  check_GtkObject_ml(editable, "Gtk.Unsafe.editable_select_region"); 
  gtk_editable_select_region( GtkEditable_ml(editable), Int_val(start), Int_val(end) );
  return Val_unit;
}

value mlgtk_editable_get_chars(value editable,value start,value end)
{
  value return_value;
  gchar* gtk_string;
  check_GtkObject_ml(editable, "Gtk.Unsafe.editable_get_chars"); 
  gtk_string = gtk_editable_get_chars( GtkEditable_ml(editable), Int_val(start), Int_val(end) );
  return_value = copy_string( gtk_string );
  g_free( gtk_string );
  return return_value;
}

value mlgtk_object_destroy(value object)
{
  check_GtkObject_ml(object, "Gtk.Unsafe.object_destroy");
#ifndef WIN_NT
  gtk_signal_handlers_destroy(GtkObject_ml(object));
#endif
  gtk_object_destroy(GtkObject_ml(object));
  /*GtkObject_ml(object) = NULL;*/
  return Val_unit;
}

/************************
ACTIONS
************************/
value mlgtk_timeout_add(value delay, value func)
{
  value *cbk;
  cbk = (value*) malloc(sizeof(value));
  register_global_root(cbk);
  *cbk = func;
  return Val_int(gtk_timeout_add_full(Int_val(delay), NULL,
    (GtkCallbackMarshal) mlgtk_callback_exec, cbk,
    (GtkDestroyNotify) mlgtk_callback_destroy));
}

value mlgtk_timeout_remove(value index)
{
  gtk_timeout_remove(Int_val(index));
  return Val_unit;
}

/*
  Gtk is not very well documented, but I'd like to add this function
  one day if I can figure out how it works...

  guint gtk_input_add_full (gint source, 
	  GdkInputCondition condition, GdkInputFunction function, 
	  GtkCallbackMarshal marshal, gpointer data,
	  GtkDestroyNotify destroy); 
*/

value mlgtk_main_quit(value dummy)
{
  gtk_main_quit();
  return Val_unit;
}

value mlgtk_main_gtk(value dummy)
{
  int argc=0; char **argv;
  gtk_set_locale ();
  gtk_init(&argc, &argv);
  caml_main(argv);
  gtk_main();
  return Val_unit;
}

#ifndef GTKTHR

  int main(int argc, char **argv)
  {
    gtk_set_locale ();
   
    gtk_init(&argc, &argv);
    caml_main(argv);
    /*mlgdk_init();*/
    gtk_main();
    return 0;
  }

#else /* GTKTHR */

  static value gtkthr_synccb = Val_unit;
  
  value mlgtkthr_init(value dummy) {
    register_global_root(&gtkthr_synccb);
    gtk_set_locale ();
    gtk_init(0, NULL);
    return Val_unit;
  }
  
  static void inputf(gpointer data, gint source, GdkInputCondition ic) {
    value res;
    leave_blocking_section();
    gtkthr_blocking = 0;
    res = callback_exn(gtkthr_synccb, Val_unit);
    gtkthr_blocking = 1;
    enter_blocking_section();
  }

  value mlgtkthr_set_sync_callback(value fd_, value cb_) {
#ifdef WIN32
#error GTKTHR not tested on Win32
#define Handle_val(v) (*((HANDLE *)(v)))
    int fd = (int)Handle_val(fd_);
#else
    int fd = Int_val(fd_);
#endif
    gtk_input_add_full(fd, GDK_INPUT_READ, &inputf, NULL, NULL, NULL);
    modify(&gtkthr_synccb, cb_);
    return Val_unit;
  }

  /* Should be called with Gtk.mutex locked. */
  value mlgtkthr_main() {
    gtkthr_blocking = 1;
    enter_blocking_section();
    gtk_main();
    /* Unreachable ? */
    leave_blocking_section();
    gtkthr_blocking = 0;
    return Val_unit;
  }

  value mlgtkthr_main_iteration(value blocking) {
    return Val_int(gtk_main_iteration_do(Bool_val(blocking)));
  }

#endif /* GTKTHR */
