/* Copyright 2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM GTK wrapper class set

   MFFM GTK wrapper class set is free software; you can redistribute
   it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM GTK wrapper class set is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM GTK wrapper class set
 */
#ifndef PROGRESSBAR_H_
#define PROGRESSBAR_H_

#include <iomanip>
#include <gtk/gtk.h>

//#define TITLE "Progress"

class ProgressBar : public GtkInterface {
  GtkWidget* pBar;
  GtkAdjustment *adj;
  
  void internalInit(int upper){
    adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, upper, 0, 0, 0);
    pBar=gtk_progress_bar_new_with_adjustment(adj);
    gtk_progress_set_format_string (GTK_PROGRESS (pBar), "%v from [%l-%u] (=%p%%)");
    gtk_widget_show(pBar);
    *this<<pBar;
  }
public:
  ProgressBar(int upper){
#ifdef DEBUG
    cout<<"ProgressBar::ProgressBar()"<<endl;
#endif
    internalInit(upper);
  }
  ProgressBar(void){
#if DEBUG >1
    cout<<"ProgressBar::ProgressBar()"<<endl;
#endif
    internalInit(100);
  }
  ~ProgressBar(void){
#if DEBUG >1
    cout<<"ProgressBar::~ProgressBar()"<<endl;
#endif
    gtk_widget_hide(pBar);
  }

  ProgressBar& operator++(int){
    //gfloat val;
    gtk_progress_set_value (GTK_PROGRESS (pBar), gtk_progress_get_value(GTK_PROGRESS (pBar))+1);
    return *this;
  }
  ProgressBar& operator =(int what){
    gtk_progress_set_value (GTK_PROGRESS (pBar), what);
    return *this;
  }

  GtkWidget *getWidget(void){
    return pBar;
  }
};
#endif //PROGRESSBAR_H_
