// Copyright (c) 2010, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

class Constants
{
	public static function packageName() : String
	{
		return "mercurial-buildpackage";
	}
	
	public static function version() : String
	{
		return "0.8.2";
	}

	public static function sudo() : String
	{
		return "sudo";
	}
	
	public static function fakeroot() : String
	{
		return "fakeroot";
	}
	
	public static function port() : String
	{
		return "mercurial-port";
	}
	
	public static function pristineTar() : String
	{
		return "mercurial-pristinetar";
	}
	
	public static function importOrig() : String
	{
		return "mercurial-importorig";
	}
	
	public static function importDsc() : String
	{
		return "mercurial-importdsc";
	}
	
	public static function tagVersion() : String
	{
		return "mercurial-tagversion";
	}
	
	public static function buildPackage() : String
	{
		return "mercurial-buildpackage";
	}
	
	public static function copyright() : String
	{
		return "Copyright (c) 2010, Jens Peter Secher <jpsecher@gmail.com>";
	}

	public static function mainBranch() : String
	{
		return "default";
	}

	public static function upstreamBranch() : String
	{
		return "upstream";
	}

	public static function pristineBranch() : String
	{
		return "pristine";
	}

	public static function packageDirectory() : String
	{
		return "debian";
	}

	public static function xdeltaExtension() : String
	{
		return "xdelta";
	}

	public static function pristineExtension() : String
	{
		return "pristine";
	}

	public static function revisionExtension() : String
	{
		return "revision";
	}

	public static function tagsFile() : String
	{
		return ".hgtags";
	}

	//
	// Regular expression for matching files and directories that should be
	// ignored in an upstream tarball because they interfere with
	// mercurial-buildpackage and dpkg-source.
	//
	public static function interfere() : EReg
	{
		return ~/^\.(hg(ignore|tags)?|pc)$/;
	}

	//
	// Regular expression for matching special Mercurial files and directories
	// that should not be unlinked.
	//
	public static function precious() : EReg
	{
		return ~/^\.hg(ignore|tags)?$/;
	}

	//
	// Arguments to pass to tar for excluding special Mercurial files.
	//
	public static function tarExclude() : Array<String>
	{
		return [ "-I.hg", "-I.hgignore", "-I"+tagsFile() ];
	}

	//
	// Similarity percentage for file-move detection.
	//
	public static function similarity() : String
	{
		return "75";
	}
}
