##############################################################################
#
# Widget to set learning mode <Peter.Bienstman@ugent.be>
#
##############################################################################

from qt import *

from memaid_core import *
from learning_mode_frm import *



##############################################################################
#
# LearningModeDlg
#
##############################################################################

class LearningModeDlg(LearningModeFrm):
        
    ##########################################################################
    #
    # __init__
    #
    ##########################################################################
    
    def __init__(self, parent=None, name=None, modal=0, fl=0):
        
        LearningModeFrm.__init__(self,parent,name,modal,fl)

        if get_config("drill_badly_known") == False:
            self.scheduled_button.setOn(1)
        else:
            self.badly_known_button.setOn(1)

        self.threshold.setValue(get_config("threshold"))

        self.connect(self.ok_button, SIGNAL("clicked()"),
                     self.apply)
                
    ##########################################################################
    #
    # apply
    #
    ##########################################################################

    def apply(self):

        if self.scheduled_button.isOn():
            set_config("drill_badly_known", False)
        else:         
            set_config("drill_badly_known", True)

        set_config("threshold", self.threshold.value())

        rebuild_revision_queue()
        self.close()
        
