<?php
/**
 * Kazakh (Қазақша)
 *
 * @package MediaWiki
 * @subpackage Language
 *
 */


$separatorTransformTable = array(
	',' => "\xc2\xa0",
	'.' => ',',
);

$extraUserToggles = array(
	'nolangconversion'
);

$fallback8bitEncoding = 'windows-1251';

$linkPrefixExtension = true;

$namespaceNames = array(
	NS_MEDIA            => 'Таспа',
	NS_SPECIAL          => 'Арнайы',
	# NS_MAIN	            => '',
	NS_TALK	            => 'Талқылау',
	NS_USER             => 'Қатысушы',
	NS_USER_TALK        => 'Қатысушы_талқылауы',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK     => '$1_талқылауы',
	NS_IMAGE            => 'Сурет',
	NS_IMAGE_TALK       => 'Сурет_талқылауы',
	NS_MEDIAWIKI        => 'МедиаУики',
	NS_MEDIAWIKI_TALK   => 'МедиаУики_талқылауы',
	NS_TEMPLATE         => 'Үлгі',
	NS_TEMPLATE_TALK    => 'Үлгі_талқылауы',
	NS_HELP             => 'Анықтама',
	NS_HELP_TALK        => 'Анықтама_талқылауы',
	NS_CATEGORY         => 'Санат',
	NS_CATEGORY_TALK    => 'Санат_талқылауы'
);

$namespaceAliases = array(
	# Aliases to kk-tr namespaces
	'Taspa'               => NS_MEDIA,
	'Arnaýı'              => NS_SPECIAL,
	'Talqılaw'            => NS_TALK,
	'Qatıswşı'            => NS_USER,
	'Qatıswşı_talqılawı'  => NS_USER_TALK,
	'$1_talqılawı'        => NS_PROJECT_TALK,
	'Swret'               => NS_IMAGE,
	'Swret_talqılawı'     => NS_IMAGE_TALK,
	'MedïaWïkï'           => NS_MEDIAWIKI,
	'MedïaWïkï_talqılawı' => NS_MEDIAWIKI_TALK,
	'Ülgi'                => NS_TEMPLATE,
	'Ülgi_talqılawı'      => NS_TEMPLATE_TALK,
	'Anıqtama'            => NS_HELP,
	'Anıqtama_talqılawı'  => NS_HELP_TALK,
	'Sanat'               => NS_CATEGORY,
	'Sanat_talqılawı'     => NS_CATEGORY_TALK,
	# Aliases to kk-cn namespaces
	'تاسپا'              => NS_MEDIA,
	'ارنايى'              => NS_SPECIAL,
	'تالقىلاۋ'            => NS_TALK,
	'قاتىسۋشى'          => NS_USER,
	'قاتىسۋشى_تالقىلاۋى'=> NS_USER_TALK,
	'$1_تالقىلاۋى'        => NS_PROJECT_TALK,
	'سۋرەت'              => NS_IMAGE,
	'سۋرەت_تالقىلاۋى'    => NS_IMAGE_TALK,
	'مەدياۋيكي'           => NS_MEDIAWIKI,
	'مەدياۋيكي_تالقىلاۋى' => NS_MEDIAWIKI_TALK,
	'ٴۇلگٴى'              => NS_TEMPLATE,
	'ٴۇلگٴى_تالقىلاۋى'    => NS_TEMPLATE_TALK,
	'انىقتاما'            => NS_HELP,
	'انىقتاما_تالقىلاۋى'  => NS_HELP_TALK,
	'سانات'              => NS_CATEGORY,
	'سانات_تالقىلاۋى'    => NS_CATEGORY_TALK,
);

$quickbarSettings = array(
	'Ешқандай', 'Солға бекітілген', 'Оңға бекітілген', 'Солға қалқыған', 'Оңға қалқыған'
);

$skinNames = array(
	'standard'    => 'Дағдылы',
	'nostalgia'   => 'Аңсау',
	'cologneblue' => 'Көлн зеңгірлігі',
	'davinci'     => 'Да Винчи',
	'mono'        => 'Дара',
	'monobook'    => 'Дара кітап',
	'myskin'      => 'Өз мәнерім',
	'chick'       => 'Балапан',
	'simple'      => 'Кәдімгі'
);

$defaultDateFormat = 'ymd';

$dateFormats = array(
	'mdy time' => 'H:i',
	'mdy date' => 'xg j, Y',
	'mdy both' => 'H:i, xg j, Y',

	'dmy time' => 'H:i',
	'dmy date' => 'j F, Y',
	'dmy both' => 'H:i, j F, Y',

	'ymd time' => 'H:i',
	'ymd date' => 'Y" ж." xg j',
	'ymd both' => 'H:i, Y" ж." xg j',

	'ISO 8601 time' => 'xnH:xni:xns',
	'ISO 8601 date' => 'xnY-xnm-xnd',
	'ISO 8601 both' => 'xnY-xnm-xnd"T"xnH:xni:xns',
);

#-------------------------------------------------------------------
# Default messages
#-------------------------------------------------------------------

$messages = array(
# User preference toggles
'tog-underline'               => 'Сілтемені астынан сыз:',
'tog-highlightbroken'         => 'Жоқталған сілтемелерді <a href="" class="new">былай</a> пішімде (басқаша: былай <a href="" class="internal">?</a> сияқты).',
'tog-justify'                 => 'Ежелерді ені бойынша туралау',
'tog-hideminor'               => 'Жуықтағы өзгерістерде шағын түзетуді жасыр',
'tog-extendwatchlist'         => 'Бақылау тізімді ұлғайт (барлық жарамды өзгерістерді көрсет)',
'tog-usenewrc'                => 'Кеңейтілген Жуықтағы өзгерістер (JavaScript)',
'tog-numberheadings'          => 'Бөлім тақырыптарын өздік түрде номірле',
'tog-showtoolbar'             => 'Өңдеу қуралдар жолағын көрсет (JavaScript)',
'tog-editondblclick'          => 'Қос нұқымдап өңдеу (JavaScript)',
'tog-editsection'             => 'Бөлімдерді [өңдеу] сілтемесімен өңдеуін ендір',
'tog-editsectiononrightclick' => 'Бөлім атауын оң жақ нұқумен<br />өңдеуін ендір (JavaScript)',
'tog-showtoc'                 => 'Мазмұнын көрсет (3-тен артық бөлімі барыларға)',
'tog-rememberpassword'        => 'Кіргенімді бұл компьютерде ұмытпа',
'tog-editwidth'               => 'Өңдеу аумағы толық енімен',
'tog-watchcreations'          => 'Мен бастаған беттерді бақылау тізіміме қос',
'tog-watchdefault'            => 'Мен өңдеген беттерді бақылау тізіміме қос',
'tog-minordefault'            => 'Барлық түзетулерді әдепкіден шағын деп белгіле',
'tog-previewontop'            => 'Қарап шығуды өңдеу аумағының үстіне сал',
'tog-previewonfirst'          => 'Бірінші өңдегенде қарап шығу',
'tog-nocache'                 => 'Бет қосалқы қалтасын өшір',
'tog-enotifwatchlistpages'    => 'Бақыланған бет өзгергенде маған хат жібер',
'tog-enotifusertalkpages'     => 'Талқылауым өзгергенде маған хат жібер',
'tog-enotifminoredits'        => 'Шағын түзету туралы да маған хат жібер',
'tog-enotifrevealaddr'        => 'Е-пошта жайымды ескерту хатта ашық көрсет',
'tog-shownumberswatching'     => 'Бақылап тұрған қатысушылардың санын көрсет',
'tog-fancysig'                => 'Қам қолтаңба (өздік сілтемесіз;)',
'tog-externaleditor'          => 'Сыртқы өңдеуішті әдепкіден қолдан',
'tog-externaldiff'            => 'Сыртқы айырмағышты әдепкіден қолдан',
'tog-showjumplinks'           => '«Өтіп кету» қатынау сілтемелерін ендір',
'tog-uselivepreview'          => 'Тура қарап шығуды қолдану (JavaScript) (Сынақ түрінде)',
'tog-autopatrol'              => 'Түзетуімді күзетке белгіле',
'tog-forceeditsummary'        => 'Өңдеу сипаттамасы бос қалғанда маған ескерт',
'tog-watchlisthideown'        => 'Түзетуімді бақылау тізімнен жасыр',
'tog-watchlisthidebots'       => 'Бот түзетуін бақылау тізімнен жасыр',
'tog-nolangconversion'        => 'Тіл түрін аудармау',

'underline-always'  => 'Әрқашан',
'underline-never'   => 'Ешқашан',
'underline-default' => 'Шолғыш бойынша',

'skinpreview' => '(Қарап шығу)',

# Dates
'sunday'        => 'Жексенбі',
'monday'        => 'Дүйсенбі',
'tuesday'       => 'Сейсенбі',
'wednesday'     => 'Сәрсенбі',
'thursday'      => 'Бейсенбі',
'friday'        => 'Жұма',
'saturday'      => 'Сенбі',
'sun'           => 'Жек',
'mon'           => 'Дүй',
'tue'           => 'Бей',
'wed'           => 'Сәр',
'thu'           => 'Бей',
'fri'           => 'Жұм',
'sat'           => 'Сен',
'january'       => 'қаңтар',
'february'      => 'ақпан',
'march'         => 'наурыз',
'april'         => 'cәуір',
'may_long'      => 'мамыр',
'june'          => 'маусым',
'july'          => 'шілде',
'august'        => 'тамыз',
'september'     => 'қыркүйек',
'october'       => 'қазан',
'november'      => 'қараша',
'december'      => 'желтоқсан',
'january-gen'   => 'қантардың',
'february-gen'  => 'ақпанның',
'march-gen'     => 'наурыздың',
'april-gen'     => 'сәуірдің',
'may-gen'       => 'мамырдың',
'june-gen'      => 'маусымның',
'july-gen'      => 'шілденің',
'august-gen'    => 'тамыздың',
'september-gen' => 'қыркүйектің',
'october-gen'   => 'қазанның',
'november-gen'  => 'қарашаның',
'december-gen'  => 'желтоқсанның',
'jan'           => 'қан',
'feb'           => 'ақп',
'mar'           => 'нау',
'apr'           => 'cәу',
'may'           => 'мам',
'jun'           => 'мау',
'jul'           => 'шіл',
'aug'           => 'там',
'sep'           => 'қыр',
'oct'           => 'қаз',
'nov'           => 'қар',
'dec'           => 'жел',

# Bits of text used by many pages
'categories'            => 'Барлық санат тізімі',
'pagecategories'        => '{{PLURAL:$1|Санат|Санаттар}}',
'category_header'       => '«$1» санатындағы беттер',
'subcategories'         => 'Төменгі санаттар',
'category-media-header' => '«$1» санатындағы таспалар',

'linkprefix'        => '/^(.*?)([a-zäçéğıïñöşüýа-яёәіңғүұқөһA-ZÄÇÉĞİÏÑÖŞÜÝА-ЯЁӘІҢҒҮҰҚӨҺʺʹ«„]+)$/sDu',
'mainpage'          => 'Басты бет',
'mainpagetext'      => "<big>'''МедиаУики бағдарламасы сәтті орнатылды.'''</big>",
'mainpagedocfooter' => 'Уики бағдарламасын пайдалану ақпараты үшін [http://meta.wikimedia.org/wiki/Help:Contents Пайдаланушы нұсқауларымен] танысыңыз.

== Бастау ==

* [http://www.mediawiki.org/wiki/Help:Configuration_settings Баптау қалаулары тізімі]
* [http://www.mediawiki.org/wiki/Help:FAQ МедиаУики ЖСЖ]
* [http://mail.wikimedia.org/mailman/listinfo/mediawiki-announce МедиаУики хат тарату тізімі]',

'portal'          => 'Қауым порталы',
'portal-url'      => '{{ns:project}}:Қауым_порталы',
'about'           => 'Біз туралы',
'aboutsite'       => '{{SITENAME}} туралы',
'aboutpage'       => '{{ns:project}}:Біз_туралы',
'article'         => 'Мағлұмат',
'help'            => 'Анықтама',
'helppage'        => '{{ns:help}}:Мазмұны',
'bugreports'      => 'Қате есептемелері',
'bugreportspage'  => '{{ns:project}}:Қате_есептемелері',
'sitesupport'     => 'Демеушілік',
'sitesupport-url' => '{{ns:project}}:Жәрдем',
'faq'             => 'ЖСЖ',
'faqpage'         => '{{ns:project}}:ЖСЖ',
'edithelp'        => 'Өндеу анықтамасы',
'newwindow'       => '(жаңа терезеде ашылады)',
'edithelppage'    => '{{ns:help}}:Өңдеу',
'cancel'          => 'Болдырмау',
'qbfind'          => 'Табу',
'qbbrowse'        => 'Шолу',
'qbedit'          => 'Өңдеу',
'qbpageoptions'   => 'Осы бет',
'qbpageinfo'      => 'Мәтін аралығы',
'qbmyoptions'     => 'Беттерім',
'qbspecialpages'  => 'Арнайы беттер',
'moredotdotdot'   => 'Көбірек…',
'mypage'          => 'Жеке бетім',
'mytalk'          => 'Талқылауым',
'anontalk'        => 'IP талқылауы',
'navigation'      => 'Бағыттау',

# Metadata in edit box
'metadata_help' => 'Мета-деректер (түсіндірмелер үшін [[{{ns:project}}:Мета-деректер]] бетін қараңыз):',

'currentevents'     => 'Ағымдағы оқиғалар',
'currentevents-url' => 'Ағымдағы_оқиғалар',

'disclaimers'       => 'Жауапкершіліктен бас тарту',
'disclaimerpage'    => '{{ns:project}}:Жауапкершіліктен_бас_тарту',
'privacy'           => 'Жеке құпиясын сақтау',
'privacypage'       => '{{ns:project}}:Жеке_құпиясын_сақтау',
'errorpagetitle'    => 'Қате',
'returnto'          => '$1 дегенге оралу.',
'tagline'           => '{{GRAMMAR:ablative|{{SITENAME}}}}',
'search'            => 'Іздеу',
'searchbutton'      => 'Іздеу',
'go'                => 'Өту',
'searcharticle'     => 'Өту',
'history'           => 'Бет тарихы',
'history_short'     => 'Тарихы',
'updatedmarker'     => 'соңғы кіргеннен бері жаңартылған',
'info_short'        => 'Ақпарат',
'printableversion'  => 'Басып шығаруға',
'permalink'         => 'Тұрақты сілтеме',
'print'             => 'Басып шығару',
'edit'              => 'Өңдеу',
'editthispage'      => 'Бетті өңдеу',
'delete'            => 'Жою',
'deletethispage'    => 'Бетті жою',
'undelete_short'    => '{{PLURAL:$1|Бір|$1}} түзетуді қайтару',
'protect'           => 'Қорғау',
'protectthispage'   => 'Бетті қорғау',
'unprotect'         => 'Қорғамау',
'unprotectthispage' => 'Бетті қорғамау',
'newpage'           => 'Жаңа бет',
'talkpage'          => 'Бетті талқылау',
'specialpage'       => 'Арнайы бет',
'personaltools'     => 'Жеке құралдар',
'postcomment'       => 'Мәндеме жіберу',
'articlepage'       => 'Мағлұмат бетін қарау',
'talk'              => 'Талқылау',
'views'             => 'Көрініс',
'toolbox'           => 'Құралдар',
'userpage'          => 'Қатысушының бетін қарау',
'projectpage'       => 'Жоба бетін қарау',
'imagepage'         => 'Сурет бетін қарау',
'mediawikipage'     => 'Хабар бетін қарау',
'templatepage'      => 'Үлгі бетін қарау',
'viewhelppage'      => 'Анықтама бетін қарау',
'categorypage'      => 'Санат бетін қарау',
'viewtalkpage'      => 'Талқылау бетін қарау',
'otherlanguages'    => 'Басқа тілдерде',
'redirectedfrom'    => '($1 бетінен айдатылған)',
'redirectpagesub'   => 'Айдату беті',
'lastmodifiedat'    => 'Бұл беттің өзгертілген соңғы кезі: $2, $1.', # $1 date, $2 time
'viewcount'         => 'Бұл бет {{plural:$1|бір|$1}} рет қаралған.',
'copyright'         => 'Мағлұмат $1 құжаты бойынша қатынаулы.',
'protectedpage'     => 'Қорғаулы бет',
'jumpto'            => 'Мынаған өтіп кету:',
'jumptonavigation'  => 'бағыттау',
'jumptosearch'      => 'іздеу',

'badaccess'        => 'Рұқсат қатесі',
'badaccess-group0' => 'Сұранысқан әрекетіңізді жегуіңізге рұқсат етілмейді.',
'badaccess-group1' => 'Сұранысқан әрекетіңіз $1 тобының қатысушыларына шектеледі.',
'badaccess-group2' => 'Сұранысқан әрекетіңіз $1 топтары бірінің қатусышыларына шектеледі.',
'badaccess-groups' => 'Сұранысқан әрекетіңіз $1 топтары бірінің қатусышыларына шектеледі.',

'versionrequired'     => 'MediaWiki $1 нұсқасы қажет',
'versionrequiredtext' => 'Осы бетті қолдану үшін MediaWiki $1 нұсқасы қажет. [[{{ns:special}}:Version]] бетін қараңыз.',

'ok'                  => 'Жарайды',
'pagetitle'           => '$1 — {{SITENAME}}',
'retrievedfrom'       => '«$1» дегеннен алынған',
'youhavenewmessages'  => 'Сізде $1 бар ($2).',
'newmessageslink'     => 'жаңа хабарлар',
'newmessagesdifflink' => 'соңғы өзгерісіне',
'editsection'         => 'өңдеу',
'editold'             => 'өңдеу',
'editsectionhint'     => 'Бөлімді өңдеу: $1',
'toc'                 => 'Мазмұны',
'showtoc'             => 'көрсет',
'hidetoc'             => 'жасыр',
'thisisdeleted'       => 'Қараймыз ба, не қайтарамыз ба?: $1',
'viewdeleted'         => 'Қараймыз ба?: $1',
'restorelink'         => 'жойылған {{PLURAL:$1|бір|$1}} түзету',
'feedlinks'           => 'Арна:',
'feed-invalid'        => 'Жарамсыз жазылым арна түрі.',

# Short words for each namespace, by default used in the 'article' tab in monobook
'nstab-main'      => 'Мағлұмат',
'nstab-user'      => 'Жеке беті',
'nstab-media'     => 'Таспа беті',
'nstab-special'   => 'Арнайы',
'nstab-project'   => 'Жоба беті',
'nstab-image'     => 'Файл',
'nstab-mediawiki' => 'Жүйе хабары',
'nstab-template'  => 'Үлгі',
'nstab-help'      => 'Анықтама',
'nstab-category'  => 'Санат',

# Main script and global functions
'nosuchaction'      => 'Мұндай әрекет жоқ',
'nosuchactiontext'  => 'Осы URL жайымен енгізілген әрекетті
осы уики жорамалдап білмеді.',
'nosuchspecialpage' => 'Бұл арнайы бет емес',
'nospecialpagetext' => 'Сіз сұранысқан арнайы бет жарамсыз. Барлық жарамды арнайы беттер тізімін [[{{ns:special}}:Specialpages]] бетінде таба аласыз.',

# General errors
'error'                => 'Қате',
'databaseerror'        => 'Дерекқордың қатесі',
'dberrortext'          => 'Дерекқорға сұраныс жасалғанда синтаксис қатесі кездесті.
Бұл бағдарламаның қатесін көрсету мүмкін.
Дерекқорға соңғы болған сұраныс:
<blockquote><tt>$1</tt></blockquote>
мына функциясынан «<tt>$2</tt>».
MySQL қайтарған қатесі «<tt>$3: $4</tt>».',
'dberrortextcl'        => 'Дерекқорға сұраныс жасалғанда синтаксис қатесі кездесті.
Дерекқорға соңғы болған сұраныс:
«$1»
мына функциясынан: «$2».
MySQL қайтарған қатесі «$3: $4»',
'noconnect'            => 'Ғафу етіңіз! Бұл уикиде кейбір техникалық қиыншылықтар кездесті, сондықтан дерекқор серверіне қатынасу алмайды. <br />
$1',
'nodb'                 => '$1 дерекқоры талғанбады',
'cachederror'          => 'Төменде сұранған беттің қосалқы қалтадағы көшірмесі, осы бет жаңартылмаған болуы мүмкін.',
'laggedslavemode'      => 'Назар салыңыз: Бетте жуықтағы жаңалаулар болмауы мүмкін.',
'readonly'             => 'Дерекқоры құлыпталған',
'enterlockreason'      => 'Құлыптау себебін енгізіңіз, қай уақытқа дейін
құлыпталғанын қоса',
'readonlytext'         => 'Ағымда дерекқор жаңа жазба және тағы басқа өзгерістер жасаудан құлыпталынған. Бұл дерекқорды жөндету бағдарламаларын орындау үшін болуы мүмкін, бұны бітіргеннен соң қаліпті іске қайтарылады.

Құлыптаған әкімші бұны былай түсіндіреді: $1',
'missingarticle'       => 'Іздестірілген «$1» атаулы бет мәтіні дерекқорда табылмады.

Бұл дағдыда ескірген айырма сілтемесіне немесе жойылған бет тарихының сілтемесіне
ергеннен болуы мүмкін.

Егер бұл болжам дұрыс себеп болмаса, бағдарламамыздағы қатеге тап болуыңыз мүмкін.
Бұл туралы нақты URL жайын көрсетіп әкімшіге есептеме жіберіңіз.',
'readonly_lag'         => 'Жетек дерекқор серверлер бастауышпен қадамланғанда осы дерекқор өздік түрінде құлыпталынған',
'internalerror'        => 'Ішкі қате',
'filecopyerror'        => '«$1» файлы «$2» файлына көшірілмеді.',
'filerenameerror'      => '«$1» файл аты «$2» атына өзгертілмеді.',
'filedeleteerror'      => '«$1» файлы жойылмайды.',
'filenotfound'         => '«$1» файлы табылмады.',
'unexpected'           => 'Күтілмеген мағына: «$1» = «$2».',
'formerror'            => 'Қате: жіберу үлгіті емес',
'badarticleerror'      => 'Осындай әрекет мына бетте атқарылмайды.',
'cannotdelete'         => 'Айтылмыш бет не сурет жойылмайды. (Бұны басқа біреу жойған шығар.)',
'badtitle'             => 'Жарамсыз атау',
'badtitletext'         => 'Сұранысқан бет атауы жарамсыз, бос, тілара сілтемесі не уики-ара атауы мүлтік болған. Атауларда сүемелдемеген бірқатар әріптер болуы мүмкін.',
'perfdisabled'         => 'Ғафу етіңіз! Осы қасиет, дерекқордың жылдамылығына әсер етіп, ешкімге уикиді пайдалануға бермегесін, уақытша өшірілген.',
'perfdisabledsub'      => 'Мында $1 бетінің сақталған көшірмесі:', # obsolete?
'perfcached'           => 'Келесі дерек қосалқы қалтасынан алынған, сондықтан толықтай жаңаланмаған болуы мүмкін.',
'perfcachedts'         => 'Келесі дерек қосалқы қалтасынан алынған, соңғы жаңаланлған кезі: $1.',
'wrong_wfQuery_params' => 'wfQuery() функциясында жарамсыз баптар<br />
Функция: $1<br />
Сұраныс: $2',
'viewsource'           => 'Қайнарын қарау',
'viewsourcefor'        => '$1 қайнары',
'protectedtext'        => 'Бұл бет өңдеу болдырмау үшін құлыпталынған.

Бұл беттің қайнарын қарауыңызға және көшіріп алуңызға болады:',
'protectedinterface'   => 'Бұл бет бағдарламаның тілдесу мәтінін жетістіреді, сондықтан қиянат келтірмеу үшін өзгертуі құлыпталған.',
'editinginterface'     => "'''Назар салыңыз:''' Бағдарламаға тілдесу мәтінін жетістіретін MediaWiki бетін өңдеп жатырсыз. Бұл беттің өзгертуі барлық пайдаланушылар тілдесуіне әсер етеді.",
'sqlhidden'            => '(SQL сұранысы жасырылды)',

# Login and logout pages
'logouttitle'                => 'Қатысушы шығуы',
'logouttext'                 => '<strong>Енді жүйеден шықтыңыз.</strong><br />
Бұл компьютерден әлі де жүйеге кірместен {{SITENAME}} жобасын
шолуыңыз мүмкін, немесе басқа пайдаланушының жүйеге кіруі мүмкін.
Кейбір беттерде әлі де жүйеге кіргеніңіздей көрінуі мүмкіндігін
ескертеміз; бұл шолғыштың қосалқы қалтасын босату арқылы шешіледі.',
'welcomecreation'            => '== Қош келдіңіз, $1! ==

Тіркелгіңіз жасалды. {{SITENAME}} баптауыңызды қалауыңызбен өзгертуді ұмытпаңыз.',
'loginpagetitle'             => 'Қатысушы кіруі',
'yourname'                   => 'Қатысушы атыңыз',
'yourpassword'               => 'Құпия сөзіңіз',
'yourpasswordagain'          => 'Құпия сөзді қайталап енгізіңіз',
'remembermypassword'         => 'Менің кіргенімді бұл компьютерде ұмытпа',
'yourdomainname'             => 'Желі үйшігіңіз',
'externaldberror'            => 'Осында сыртқы теңдестіру дерекқорында қате болды, немесе сыртқы тіркелгіңізді жаңалауға рұқсат жоқ.',
'loginproblem'               => '<b>Кіруіңіз кезінде осында қиындыққа тап болдық.</b><br />Тағы да қайталап қараңыз.',
'alreadyloggedin'            => '<strong>$1 деген қатысушы, кіріпсіз түге!<strong><br />',
'login'                      => 'Кіру',
'loginprompt'                => '{{SITENAME}} торабына кіру үшін «cookies» қасиетін ендіруіңіз қажет.',
'userlogin'                  => 'Кіру / Тіркелгі жасау',
'logout'                     => 'Шығу',
'userlogout'                 => 'Шығу',
'notloggedin'                => 'Кірмегенсіз',
'nologin'                    => 'Тіркелгіңіз жоқ па? $1.',
'nologinlink'                => 'Жасаңыз',
'createaccount'              => 'Тіркелгі жаса',
'gotaccount'                 => 'Тіркелгіңіз бар ма?  $1.',
'gotaccountlink'             => 'Кіріңіз',
'createaccountmail'          => 'е-поштамен',
'badretype'                  => 'Енгізген құпия сөздеріңіз бір біріне сәйкес емес.',
'userexists'                 => 'Енгізген қатысушы атыңызды біреу пайдаланып жатыр. Басқа атау тандаңыз.',
'youremail'                  => 'Е-пошта жайыңыз *:',
'username'                   => 'Қатысушы атыңыз:',
'uid'                        => 'Қатысушы теңдестіруіңіз:',
'yourrealname'               => 'Шын атыңыз *:',
'yourlanguage'               => 'Тіліңіз:',
'yourvariant'                => 'Түрі',
'yournick'                   => 'Лақап атыңыз:',
'badsig'                     => 'Қам қолтаңбаңыз жарамсыз; HTML белгішелерін тексеріңіз.',
'email'                      => 'Е-поштаңыз',
'prefs-help-email-enotif'    => 'Егер соны баптасаңыз, осы е-пошта жайы сізге ескерту хат жіберуге қолданылады.',
'prefs-help-realname'        => '* Шын атыңыз (міндетті емес): енгізсеңіз, шығармаңыздың ауторлығын белгілеуі үшін қолданылады.',
'loginerror'                 => 'Кіру қатесі',
'prefs-help-email'           => '* Е-поштаңыз (міндетті емес): «Қатысушы» немесе «қатысушы талқылау» бетіңіздер арқылы басқаларға байланысу мүмкіндік береді. Өзіңіздің кім екеніңізді білдіртпейді.',
'nocookiesnew'               => 'Қатысушы тіркелгісі жасалды, тек әлі кірмегенсіз. {{SITENAME}} жобасына қатысушы кіру үшін «cookies» қасиеті қажет. Шолғышыңызда «cookies» қасиеті өшірілген. Соны ендіріңіз де жаңа қатысушы атыңызды және құпия сөзіңізді енгізіп кіріңіз.',
'nocookieslogin'             => 'Қатысушы кіру үшін {{SITENAME}} жобасы «cookies» қасиетін қолданады. Шолғышыңызда «cookies» қасиеті өшірілген. Соны ендіріңіз де қайталап кіріңіз.',
'noname'                     => 'Қатысушы атын дұрыс енгізбедіңіз.',
'loginsuccesstitle'          => 'Кіруіңіз сәтті өтті',
'loginsuccess'               => "'''Сіз енді {{SITENAME}} жобасына «$1» ретінде кіріп отырсыз.'''",
'nosuchuser'                 => 'Мында «$1» атаулы қатысушы жоқ. Емлеңізді тексеріңіз, немесе жаңа тіркелгі жасаңыз.',
'nosuchusershort'            => 'Мында «$1» деген қатысушы атауы жоқ. Емлеңізді тексеріңіз.',
'nouserspecified'            => 'Қатысушы атын енгізіуіңіз қажет.',
'wrongpassword'              => 'Енгізген құпия сөз жарамсыз. Қайталап көріңіз.',
'wrongpasswordempty'         => 'Құпия сөз босты бопты. Қайталап көріңіз.',
'mailmypassword'             => 'Құпия сөзімді хатпен жібер',
'passwordremindertitle'      => 'Құпия сөз туралы {{SITENAME}} жобасының ескертуі',
'passwordremindertext'       => 'Кейбіреу (IP жайы: $1, бәлкім, өзіңіз боларсыз)
{{SITENAME}} үшін бізден жаңа құпия сөзін жіберуін сұранысқан ($4).
«$2» қатысушының құпия сөзі «$3» болды енді.
Қазір кіруіңіз және құпия сөзіңізді ауыструыңыз қажет.

Егер басқа біреу бұл сұранысты жасаса, немесе құпия сөзіңізді ұмытсаңыз да,
және бұны өзгерткіңіз келмесе де, осы хабарламаға аңғармауыңызға да болады,
ескі құпия сөзіңізді әріғарай қолданып.',
'noemail'                    => 'Мында «$1» қатысушының е-поштасы жоқ.',
'passwordsent'               => 'Жаңа құпия сөз «$1» үшін
тіркелген е-пошта жайына жіберілді.
Қабылдағаннан кейін кіргенде соны енгізіңіз.',
'blocked-mailpassword'       => 'IP жайыңыздан өңдеу бұғатталған, сондықтан
қиянатшылықтан сақтану үшін құпия сөз жіберу қызметінің әрекеті рұқсат етілмейді.',
'eauthentsent'               => 'Куәландыру хаты аталған е-пошта жайына жіберілді.
Басқа е-пошта хатын жіберудің алдынан, тіркелгі шынынан сіздікі екенін
куәландыру үшін хаттағы нұсқауларға еріңіз.',
'throttled-mailpassword'     => 'Соңғы $1 сағатта құпия сөз ескерту хаты жіберілді түге.
Қиянатшылыққа кедергі болу үшін, $1 сағат сайын тек бір ғана құпия сөз ескерту
хаты жіберіледі.',
'mailerror'                  => 'Хат жіберу қатесі: $1',
'acct_creation_throttle_hit' => 'Ғафу етіңіз, сіз $1 тіркелгі жасапсыз түге. Онан артық істей алмайсыз.',
'emailauthenticated'         => 'Е-пошта жайыңыз куәландырылған кезі: $1.',
'emailnotauthenticated'      => 'Е-пошта жайыңыз әлі куәландырған жоқ.
Төмендегі қасиетттер үшін ешқандай хат жіберілмейді.',
'noemailprefs'               => 'Осы қасиеттер істеуі үшін е-пошта жайыңызды енгізіңіз.',
'emailconfirmlink'           => 'Е-пошта жайыңызды куәландырыңыз',
'invalidemailaddress'        => 'Осы е-пошта жайда жарамсыз пішім болған, қабыл етілмейді.
Дұрыс пішімделген жайды енгізіңіз, не аумақты бос қалдырыңыз.',
'accountcreated'             => 'Тіркелгі жасалды',
'accountcreatedtext'         => '$1 үшін қатысушы тіркелгісі жасалды.',

# Edit page toolbar
'bold_sample'     => 'Жуан мәтін',
'bold_tip'        => 'Жуан мәтін',
'italic_sample'   => 'Қиғаш мәтін',
'italic_tip'      => 'Қиғаш мәтін',
'link_sample'     => 'Сілтеме атауы',
'link_tip'        => 'Ішкі сілтеме',
'extlink_sample'  => 'http://www.example.com сілтеме атауы',
'extlink_tip'     => 'Сыртқы сілтеме (алдынан http:// енгізуін ұмытпаңыз)',
'headline_sample' => 'Тақырып мәтіні',
'headline_tip'    => '1-ші деңгейлі тақырып',
'math_sample'     => 'Формуланы мында енгізіңіз',
'math_tip'        => 'Математика формуласы (LaTeX)',
'nowiki_sample'   => 'Пішімделмейтін мәтінді осында енгізіңіз',
'nowiki_tip'      => 'Уики пішімін елемеу',
'image_sample'    => 'Example.jpg',
'image_tip'       => 'Кіріктірілген сурет',
'media_sample'    => 'Example.ogg',
'media_tip'       => 'Таспа файлының сілтемесі',
'sig_tip'         => 'Қолтаңбаңыз және уақыт белгісі',
'hr_tip'          => 'Дерелей сызық (үнемді қолданыңыз)',

# Edit pages
'summary'                   => 'Сипаттамасы',
'subject'                   => 'Тақырыбы/басы',
'minoredit'                 => 'Бұл шағын түзету',
'watchthis'                 => 'Бетті бақылау',
'savearticle'               => 'Бетті сақта!',
'preview'                   => 'Қарап шығу',
'showpreview'               => 'Қарап шығу',
'showlivepreview'           => 'Тура қарап шығу',
'showdiff'                  => 'Өзгерістерді көрсет',
'anoneditwarning'           => "'''Назар салыңыз:''' Сіз жүйеге кірмегенсіз. IP жайыңыз бұл беттің өңдеу тарихында жазылып алынады.",
'missingsummary'            => "'''Ескерту:''' Түзету сипаттамасын енгізбепсіз. «Сақтау» түймесін тағы бассаңыз, түзетуіңіз мәндемесіз сақталады.",
'missingcommenttext'        => 'Төменде мәндемеңізді енгізіңіз.',
'missingcommentheader'      => "'''Ескерту:''' Бұл мәндемеге тақырып/басжол жетістірмепсіз. Егер тағы да Сақтау түймесін нұқысаңыз, түзетуіңіз солсыз сақталады.",
'summary-preview'           => 'Сипаттамасын қарап шығу',
'subject-preview'           => 'Тақырыбын/басын қарап шығу',
'blockedtitle'              => 'Пайдаланушы бұғатталған',
'blockedtext'               => "<big>'''Қатысушы атыңыз не IP жайыңыз бұғатталған.'''</big>

бұғаттауды $1 істеген. Белгіленген себебі: ''$2''.

Осы бұғаттауды талқылау үшін $1 дегенмен не басқа [[{{ns:project}}:Әкімшілер|әкімшімен]] қатынасуыңызға болады.
[[{{ns:special:Preferences|Тіркелгі баптауларын]] қолданып жарамды е-пошта жайын енгізгенше дейін
«Қатысушыға хат жазу» қасиетін пайдаланылмайсыз. Ағымдық IP жайыңыз $3 болған. Бұны әрбір сұранысыңызға қосыңыз.",
'blockedoriginalsource'     => "Төменде '''$1''' дегеннің қайнары көрсетіледі:",
'blockededitsource'         => "Төменде '''$1''' дегенге жасалған '''түзетуңіздің''' мәтіні көрсетіледі:",
'whitelistedittitle'        => 'Өңдеу үшін кіруіңіз жөн.',
'whitelistedittext'         => 'Беттерді өңдеу үшін $1 жөн.',
'whitelistreadtitle'        => 'Оқу үшін кіруіңіз жөн',
'whitelistreadtext'         => 'Беттерді оқу үшін [[{{ns:special}}:Userlogin|кіруіңіз]] жөн.',
'whitelistacctitle'         => 'Сізге тіркелгі жасауға рұқсат берілмеген',
'whitelistacctext'          => 'Осы уикиде басқаларға тіркелгі жасау үшін [[{{ns:Special}}:Userlogin|кіруіңіз]] қажет және жанасымды рұқсаттарын билеу қажет.',
'confirmedittitle'          => 'Е-пошта жайын куәландыру хатын қайта өңдеу қажет',
'confirmedittext'           => 'Беттерді өңдеу үшін алдын ала Е-пошта жайыңызды куәландыруыңыз қажет. Жайыңызды [[{{ns:Special}}:Preferences|қатысушы баптауы]] арқылы енгізіңіз және тексерткіңіз.',
'loginreqtitle'             => 'Кіруіңіз қажет',
'loginreqlink'              => 'кіру',
'loginreqpagetext'          => 'Басқа беттерді көру үшін сіз $1 болуыңыз қажет.',
'accmailtitle'              => 'Құпия сөз жіберілді.',
'accmailtext'               => '$2 жайына «$1» құпия сөзі жіберілді.',
'newarticle'                => '(Жаңа)',
'newarticletext'            => 'Сілтемеге еріп әлі басталмаған бетке
келіпсіз. Бетті бастау үшін, төмендегі аумақта мәтініңізді
теріңіз (көбірек ақпарат үшін [[{{ns:help}}:Мазмұны|көмек бетін]]
қараңыз).Егер жаңылғаннан осында келген болсаңыз, шолғышыңыз
«Артқа» деген түймесін нұқыңыз.',
'anontalkpagetext'          => "----''Бұл тіркелгісіз (немесе тіркелгісін қолданбаған) пайдаланушының талқылау беті. Осы пайдаланушыны біз тек сандық IP жайымен теңдестіреміз. Осындай IP жайлар бірнеше пайдаланушыға ортақ болуы мүмкін. Егер сіз тіркелгісіз пайдаланушы болсаңыз және сізге қатыссыз мәндемелер жіберілгенін сезсеңіз, басқа тіркелгісіз пайдаланушылармен араластырмауы үшін [[{{ns:special}}:Userlogin|тіркелгі жасаңыз не кіріңіз]].''",
'noarticletext'             => 'Бұл бетте ағымда еш мәтін жоқ, басқа беттерден осы бет атауын [[{{ns:special}}:Search/{{PAGENAME}}|іздеп көруіңізге]] немесе осы бетті [{{fullurl:{{FULLPAGENAME}}|action=edit}} түзетуіңізге] болады.',
'clearyourcache'            => "'''Аңғартпа:''' Сақтағаннан кейін өзгерістерді көру үшін шолғыш қосалқы қалтасын босату керегі мүмкін. '''Mozilla  / Safari:''' ''Shift'' пернесін басып тұрып ''Reload'' (''Қайта жүктеу'') түймесін нұқыңыз (не ''Ctrl-Shift-R'' басыңыз); ''IE:'' ''Ctrl-F5'' басыңыз; '''Opera / Konqueror''' ''F5'' пернесін басыңыз.",
'usercssjsyoucanpreview'    => '<strong>Басалқы:</strong> Сақтау алдында жаңа CSS/JS файлын тексеру үшін «Қарап шығу» түймесін қолданыңыз.',
'usercsspreview'            => "'''Мынау CSS мәтінін тек қарап шығу екенін ұмытпаңыз, ол әлі сақталған жоқ!'''",
'userjspreview'             => "'''Мынау JavaScript қатысушы бағдарламасын тексеру/қарап шығу екенін ұмытпаңыз, ол әлі сақталған жоқ!'''",
'userinvalidcssjstitle'     => "'''Назар салыңыз:''' Мында «$1» атаулы безендіру мәнері жоқ. Пайдаланушының .css және .js файл атауы кіші әріпппен жазылатынын ұмытпаңыз, мысалға {{ns:user}}:Foo/monobook.css дегенді {{ns:user}}:Foo/Monobook.css дегенмен салыстырыңыз.",
'updated'                   => '(Жаңартылған)',
'note'                      => '<strong>Аңғартпа:</strong>',
'previewnote'               => '<strong>Мынау тек қарап шығу екенін ұмытпаңыз; түзетулер әлі сақталған жоқ!</strong>',
'session_fail_preview'      => '<strong>Ғафу етіңіз! Сессия деректері ысырап қалғандықтан өңдеуіңізді жөндей алмаймыз.
Мәтініңізді сақтап қайталап көріңіз. Егер әлі іс өтпейтін болса, шығып және кері кіріп көріңіз.</strong>',
'previewconflict'           => 'Бұл қарап шығу жоғарыдағы өңдеу аумағындағы мәтінге сақтаған кезіндегі дей ықпал етеді.',
'session_fail_preview_html' => "<strong>Ғафу етіңіз! Сессия деректері ысырап қалғандықтан өңдеуіңізді жөндей алмаймыз.</strong>

''Осы уикиде қам HTML ендірілген, JavaScript шабуылдардан қорғану үшін алдын ала қарап шығу жасырылған.''

<strong>Егер бұл өңдеу адал талап болса, қайтарып көріңіз. Егер әлі де істемесе, шығып, сосын кері кіріп көріңіз.</strong>",
'importing'                 => 'Сырттан алуда: $1',
'editing'                   => 'Өңдеуде: $1',
'editinguser'               => 'Қатысушыны өңдеуде: <b>$1</b>',
'editingsection'            => 'Өңдеуде: $1 (бөлімі)',
'editingcomment'            => 'Өңдеуде: $1 (мәндемесі)',
'editconflict'              => 'Өңдеу егесі: $1',
'explainconflict'           => 'Осы бетті сіз өңдей бастағанда басқа кейбіреу бетті өзгерткен.
Жоғарғы аумақта беттің ағымдық мәтіні бар.
Төменгі аумақта сіз өзгерткен мәтіні көрсетіледі.
Өзгертуіңізді ағымдық мәтінге үстеуіңіз жөн.
"Бетті сақта!" түймесіне басқанда
<b>тек</b> жоғарғы аумақтағы мәтін сақталады.<br />',
'yourtext'                  => 'Мәтініңіз',
'storedversion'             => 'Сақталған нұсқасы',
'nonunicodebrowser'         => '<strong>АҢҒАРТПА: Шолғышыңыз Unicode белгілеуіне үйлесімді емес, сондықтан латын емес әріптері бар беттерді өңдеу зіл болу мүмкін. Жұмыс істеуге ықтималдық беру үшін, <strong>төменгі өңдеу аумағында ASCII емес әріптер оналтылық санымен көрсетіледі</strong>.',
'editingold'                => '<strong>АҢҒАРТПА: Осы беттің ертерек нұсқасын
өңдеп жатырсыз.
Бұны сақтасаңыз, осы нусқадан соңғы барлық түзетулер жойылады.</strong>',
'yourdiff'                  => 'Айырмалар',
'copyrightwarning'          => '{{SITENAME}} жобасына қосылған бүкіл үлес $2 (көбірек ақпарат үшін: $1) құжатына сай жіберілген болып саналады. Егер жазуыңыздың еркін көшіріліп түзетілуін қаламасаңыз, мында ұсынбауыңыз жөн.<br />
Тағы, қосқан үлесіңіз - өзіңіздің жазғанығыз, не ашық ақпарат көздерінен алынған мағлұмат болғанын уәде етесіз.<br />
<strong>АВТОРЛЫҚ ҚҰҚЫҚПЕН ҚОРҒАУЛЫ АҚПАРАТТЫ РҰҚСАТСЫЗ ҚОСПАҢЫЗ!</strong>',
'copyrightwarning2'         => 'Есте тұрсын: барлық {{SITENAME}} жобасына берілген үлестер басқа улес берушілермен түзетуге, өзгертуге, не аластануға мүмкін. Алғыссыз түзетуге енжарлан болсаңыз, онда шығармаңызды мында жарияламаңыз.<br />
Тағы, осыны өзіңіз жазғаныңызды, не барша қазынасынан, немесе сондай-ақ ақысыз ашық қайнарынан көшіргеніңізді
дәл осындай бізге міндеттеме бересіз (көбірек ақпарат үшін $1 қужатын қараңыз).<br />
<strong>АУТОРЛЫҚ ҚҰҚЫҚПЕН ҚОРҒАУЛЫ АҚПАРАТТЫ РҰҚСАТСЫЗ ҚОСПАҢЫЗ!</strong>',
'longpagewarning'           => '<strong>НАЗАР САЛЫҢЫЗ: Бұл беттің мөлшері — $1 килобайт; кейбір
шолғыштарда бет мөлшері 32 кБ жетсе не оны асса өңдеу күрделі болуы мүмкін.
Бетті бірнеше кішкін бөлімдерге бөліп көріңіз.</strong>',
'longpageerror'             => '<strong>ҚАТЕ: Жіберетін мәтініңіздін мөлшері — $1 кБ, ең көбі $2 кБ
рұқсат етілген мөлшерінен асқан. Бұл сақтай алынбайды.</strong>',
'readonlywarning'           => '<strong>НАЗАР САЛЫҢЫЗ: Дерекқор жөндету үшін құлыпталған,
сондықтан дәл қазір түзетуіңізді сақтай алмайсыз. Сосын қолдануға үшін мәтәніңізді көшіріп,
өз компүтеріңізде файлға сақтаңыз.</strong>',
'protectedpagewarning'      => '<strong>НАЗАР САЛЫҢЫЗ: Бұл бет қорғалған. Тек әкімші рұқсаты бар қатысушылар өңдеу жасай алады.</strong>',
'semiprotectedpagewarning'  => "'''Аңғартпа:''' Бет [[{{ns:project}}:Жартылай қорғау саясаты|қорғалған]], сондықтан осыны тек рұқсаты бар қатысушылар өңдей алады.",
'templatesused'             => 'Бұл бетте қолданылған үлгілер:',
'templatesusedpreview'      => 'Бұны қарап шығуға қолданылған үлгілер:',
'templatesusedsection'      => 'Бұл бөлімде қолданылған үлгілер:',
'edittools'                 => '<!-- Мындағы мағлұмат өңдеу және қотару үлгіттріңің астында көрсетіледі. -->',
'nocreatetitle'             => 'Бетті бастау шектелген',
'nocreatetext'              => 'Бұл торапта жаңа бет бастауы шектелген.
Кері қайтып бар бетті өңдеуіңізге болады, немесе [[{{ns:special}}:Userlogin|кіруіңізге не тіркелгі жасауға]] болады.',
'cantcreateaccounttitle'    => 'Тіркелгі жасалмады',
'cantcreateaccounttext'     => 'Осы IP жайдан (<b>$1</b>) тіркелгі жасауы бұғатталған.
Бәлкім себебі, оқу орныңыздан, немесе Интернет жеткізушіден
үзбей бұзақылық болғаны.',

# History pages
'revhistory'                  => 'Нұсқалар тарихы',
'viewpagelogs'                => 'Осы бетке қатысты журналдарды қарау',
'nohistory'                   => 'Осы беттінің нұсқалар тарихы жоқ.',
'revnotfound'                 => 'Нұсқа табылмады',
'revnotfoundtext'             => 'Осы сұранысқан беттің ескі нұсқасы табылған жоқ.
Осы бетті ашуға пайдаланған URL жайын қайта тексеріп шығыңыз.',
'loadhist'                    => 'Бет тарихын жүктеуі',
'currentrev'                  => 'Ағымдық нұсқасы',
'revisionasof'                => '$1 кезіндегі нұсқасы',
'revision-info'               => '$1 кезіндегі $2 жасаған нұсқасы',
'previousrevision'            => '← Ескілеу нұсқасы',
'nextrevision'                => 'Жаңалау нұсқасы →',
'currentrevisionlink'         => 'Ағымдық нұсқасы',
'cur'                         => 'ағым.',
'next'                        => 'кел.',
'last'                        => 'соң.',
'orig'                        => 'түп.',
'histlegend'                  => 'Айырмасын көру: салыстырамын деген нұсқаларды таңдап, не <Enter> пернесін, не төмендегі түймені басыңыз.<br />
Шартты белгілер: (ағым.) = ағымдық нұсқамен айырмасы,
(соң.) = алдыңғы нұсқамен айырмасы, ш = шағын түзету',
'deletedrev'                  => '[жойылған]',
'histfirst'                   => 'Ең алғашқысына',
'histlast'                    => 'Ең соңғысына',
'rev-deleted-comment'         => '(мәндеме аластатылды)',
'rev-deleted-user'            => '(қатысушы аты аластатылды)',
'rev-deleted-text-permission' => '<div class="mw-warning plainlinks">
Осы беттің нұсқасы жария мұрағаттарынан аластатылған.
Бұл жайтқа [{{fullurl:{{ns:special}}:Log/delete|page={{PAGENAMEE}}}} жою журналында] егжей-тегжей мәліметтер болуы мүмкін.
</div>',
'rev-deleted-text-view'       => '<div class="mw-warning plainlinks">
Осы беттің нұсқасы жария мұрағаттарынан аластатылған.
Соны осы тораптың әкімшісі боп көруіңіз мүмкін;
бұл жайтқа [{{fullurl:{{ns:special}}:Log/delete|page={{PAGENAMEE}}}} жою журналында] егжей-тегжей мәлметтер болуы мүмкін.
</div>',
'rev-delundel'                => 'көрсет/жасыр',

'history-feed-title'          => 'Нұсқалар тарихы',
'history-feed-description'    => 'Бұл беттің уикидегі нұсқалар тарихы',
'history-feed-item-nocomment' => '$1 деген $2 кезінде', # user at time
'history-feed-empty'          => 'Сұранған бет жоқ.
Бұл бет уикиден жойылған, немесе қайта аталған.
Сәйкесі бар жаңа беттерді [[{{ns:special}}:Search|уикиден іздеп]] қараңыз.',

# Revision deletion
'revisiondelete'            => 'Нұсқаларды жою/қайтару',
'revdelete-nooldid-title'   => 'Нысана нұсқасы жоқ',
'revdelete-nooldid-text'    => 'Осы әрекетті орындау үшін ақырғы нұсқасын
не нұсқаларын енгізбепсіз.',
'revdelete-selected'        => '[[:$1]] дегеннің талғанылған нұсқасы:',
'revdelete-text'            => 'Жойылған нұсқаларды әлі де бет тарихында көруге болады,
бірақ оның мәтін мағлұматы баршаға қатыналмайды.

Осы уикидің басқа әкімшілері жасырын мағлұматқа қатынай алады,
және торап операторлары қосымша шектеу ендіргенше дейін,
осы тілдесу арқылы жойылғанды кері қайтара алады.',
'revdelete-legend'          => 'Нұсқанының шектеулері:',
'revdelete-hide-text'       => 'Нұсқа мәтінін жасыр',
'revdelete-hide-comment'    => 'Түзету мәндемесін жасыр',
'revdelete-hide-user'       => 'Өңдеуші атын (IP жайын) жасыр',
'revdelete-hide-restricted' => 'Осы шектеулерді баршаға сияқты әкімшілерге де қолдану',
'revdelete-log'             => 'Журнал мәндемесі:',
'revdelete-submit'          => 'Талғанған нұсқаға қолдану',
'revdelete-logentry'        => '[[$1]] дегенге нұсқа көрінісін өзгертті',

# Diffs
'difference'                => '(Нұсқалар арасындағы айырмашылық)',
'loadingrev'                => 'айырма үшін нұсқа жүктеу',
'lineno'                    => 'Жол $1:',
'editcurrent'               => 'Осы беттің ағымдық нұсқасын өңдеу',
'selectnewerversionfordiff' => 'Салыстыру үшін жаңалау нұсқасын талғаңыз',
'selectolderversionfordiff' => 'Салыстыру үшін ескілеу нұсқасын талғаңыз',
'compareselectedversions'   => 'Таңдаған нұсқаларды салыстыру',

# Search results
'searchresults'         => 'Іздестіру нәтижелері',
'searchresulttext'      => 'Осы {{SITENAME}} жобасында іздестіру туралы көбірек ақпарат үшін, [[{{ns:project}}:Іздеу|{{SITENAME}} іздеу нұсқауларын]] қараңыз.',
'searchsubtitle'        => "Іздестіру сұранысыңыз: '''[[:$1]]'''",
'searchsubtitleinvalid' => "Іздестіру сұранысыңыз: '''$1'''",
'badquery'              => 'Іздестіру сұраныс жарамсыз пішімделген',
'badquerytext'          => 'Ғафу етіңіз, сұранысыңызды орындай алмадық.
Бұл үш әріптен кем сөзді іздестіруге талаптанғаныңыздан
болуға мүмкін, ол әлі де сүйемелденбеген.
Тағы да бұл сөйлемді дұрыс енгізбегендіктен де болуға мүмкін,
мысалы, «балық және және қабыршақ».
Басқа сұраныс жасап көріңіз',
'matchtotals'           => '«$1» іздестіру сұранысы $2 беттің атауына
және $3 беттің мәтініне сәйкес.',
'noexactmatch'          => "'''Осында «$1» атаулы бет жоқ.''' Бұл бетті өзіңіз '''[[:$1|бастай  аласыз]].'''",
'titlematches'          => 'Бет атауы сәйкесі',
'notitlematches'        => 'Еш бет атауы сәйкес емес',
'textmatches'           => 'Бет мәтінің сәйкесі',
'notextmatches'         => 'Еш бет мәтіні сәйкес емес',
'prevn'                 => 'алдыңғы $1',
'nextn'                 => 'келесі $1',
'viewprevnext'          => 'Көрсетілуі: ($1) ($2) ($3) жазба.',
'showingresults'        => 'Төменде нөмір <b>$2</b> дегеннен бастап <b>$1</b> нәтижеге дейін көрсетілген.',
'showingresultsnum'     => 'Төменде нөмір <b>$2</b> дегеннен бастап <b>$3</b> нәтиже көрсетілген.',
'nonefound'             => "'''Аңғартпа''': Табу сәтсіз бітуі жиі «болған» және «деген» сияқты
тізімделмейтін жалпы сөздермен іздестіруден болуы мүмкін,
немесе бірден артық іздестіру шарт сөздерін егізгеннен (нәтижелерде тек
барлық шарт сөздер кедессе көрсетіледі) болуы мүмкін.",
'powersearch'           => 'Іздеу',
'powersearchtext'       => 'Мына есім аяларда іздеу:<br />$1<br />$2 Айдатуларды тізімдеу<br />Іздестіру сұранысы: $3 $9',
'searchdisabled'        => '{{SITENAME}} жобасында ішкі іздеуі өшірілген. Әзірше Google немесе Yahoo! арқылы іздеуге болады. Аңғартпа: {{SITENAME}} мағлұмат тізімідеулері оларда ескірген болуға мүмкін.',
'blanknamespace'        => '(Негізгі)',

# Preferences page
'preferences'           => 'Баптаулар',
'mypreferences'         => 'Баптауым',
'prefsnologin'          => 'Кірмегенсіз',
'prefsnologintext'      => 'Баптауларды қалау үшін алдын ала [[{{ns:special}}:Userlogin|кіруіңіз]] қажет.',
'prefsreset'            => 'Баптаулар арқаудан қайта орнатылды.',
'qbsettings'            => 'Мәзір аймағы',
'changepassword'        => 'Құпия сөз өзгерту',
'skin'                  => 'Безендіру',
'math'                  => 'Математика',
'dateformat'            => 'Күн-ай пішімі',
'datedefault'           => 'Еш қалаусыз',
'datetime'              => 'Уақыт',
'math_failure'          => 'Өңдету сәтсіз бітті',
'math_unknown_error'    => 'белгісіз қате',
'math_unknown_function' => 'белгісіз функция',
'math_lexing_error'     => 'лексика қатесі',
'math_syntax_error'     => 'синтаксис қатесі',
'math_image_error'      => 'PNG аударысы сәтсіз бітті; latex, dvips, gs және convert бағдарламаларының мүлтіксіз орнатуын тексеріңіз',
'math_bad_tmpdir'       => 'Математиканың уақытша қалтасына жазылмады, не қалта жасалмады',
'math_bad_output'       => 'Математиканың беріс қалтасына жазылмады, не қалта жасалмады',
'math_notexvc'          => 'texvc бағдарламасы жоғалтылған; баптау үшін math/README құжатын қараңыз.',
'prefs-personal'        => 'Жеке деректері',
'prefs-rc'              => 'Жуықтағы өзгерістер',
'prefs-watchlist'       => 'Бақылау',
'prefs-watchlist-days'  => 'Бақылау тізімінде көрсетерін күн саны:',
'prefs-watchlist-edits' => 'Кеңейтілген бақылау тізімі түзету көрсетерін саны:',
'prefs-misc'            => 'Қосымша',
'saveprefs'             => 'Сақта',
'resetprefs'            => 'Таста',
'oldpassword'           => 'Ағымдық құпия сөз:',
'newpassword'           => 'Жаңа құпия сөз:',
'retypenew'             => 'Жаңа құпия сөзді қайталаңыз:',
'textboxsize'           => 'Өңдеу',
'rows'                  => 'Жолдар:',
'columns'               => 'Бағандар:',
'searchresultshead'     => 'Іздеу',
'resultsperpage'        => 'Бет сайын нәтиже саны:',
'contextlines'          => 'Нәтиже сайын жол саны:',
'contextchars'          => 'Жол сайын әріп саны:',
'stubthreshold'         => 'Бітеме көрстетуін анықтау табалдырығы:',
'recentchangescount'    => 'Жуықтағы өзгерістердегі атаулар:',
'savedprefs'            => 'Баптауларыңыз сақталды.',
'timezonelegend'        => 'Уақыт белдеуі',
'timezonetext'          => 'Жергілікті уақытыңызбен сервер уақытының (UTC) арасындағы сағат саны.',
'localtime'             => 'Жергілікті уақыт',
'timezoneoffset'        => 'Ығыстыру¹',
'servertime'            => 'Сервер уақыты',
'guesstimezone'         => 'Шолғыштан алып толтыру',
'allowemail'            => 'Басқадан хат қабылдауын ендіру',
'defaultns'             => 'Мына есім аяларда әдепкіден іздеу:',
'default'               => 'әдепкі',
'files'                 => 'Файлдар',

# User rights
'userrights-lookup-user'     => 'Қатысушы топтарын меңгеру',
'userrights-user-editname'   => 'Қатысушы атын енгізіңіз:',
'editusergroup'              => 'Қатысушы топтарын өңдеу',
'userrights-editusergroup'   => 'Қатысушы топтарын өңдеу',
'saveusergroups'             => 'Қатысушы топтарын сақтау',
'userrights-groupsmember'    => 'Мүшелігі:',
'userrights-groupsavailable' => 'Қатынаулы топтар:',
'userrights-groupshelp'      => 'Қатысушыны үстейтін не аластатын топтарды талғаңыз.
Талғауы өшірілген топтар өзгертілімейді. Топтардың талғауын CTRL + Сол жақ нұқумен өшіруіңізге болады.',

# Groups
'group'            => 'Топ:',
'group-bot'        => 'Боттар',
'group-sysop'      => 'Әкімшілер',
'group-bureaucrat' => 'Төрешілер',
'group-all'        => '(барлығы)',

'group-bot-member'        => 'бот',
'group-sysop-member'      => 'әкімші',
'group-bureaucrat-member' => 'төреші',

'grouppage-bot'        => '{{ns:project}}:Боттар',
'grouppage-sysop'      => '{{ns:project}}:Әкімшілер',
'grouppage-bureaucrat' => '{{ns:project}}:Төрешілер',

# Recent changes
'changes'                           => 'өзгеріс',
'recentchanges'                     => 'Жуықтағы өзгерістер',
'recentchangestext'                 => 'Бұл бетте осы уикидегі болған жуықтағы өзгерістер байқалады.',
'rcnote'                            => '$3 кезіне дейін — төменде соңғы <strong>$2</strong> күндегі, соңғы <strong>$1</strong> өзгеріс көрсетілген.',
'rcnotefrom'                        => '<b>$2</b> кезінен бері — төменде өзгерістер <b>$1</b> дейін көрсетілген.',
'rclistfrom'                        => '$1 кезінен бері — жаңа өзгерістерді көрсет.',
'rcshowhideminor'                   => 'Шағын түзетуді $1',
'rcshowhidebots'                    => 'Боттарды $1',
'rcshowhideliu'                     => 'Тіркелгенді $1',
'rcshowhideanons'                   => 'Тіркелгісізді $1',
'rcshowhidepatr'                    => 'Күзеттегі түзетулерді $1',
'rcshowhidemine'                    => 'Түзетуімді $1',
'rclinks'                           => 'Соңғы $2 күнде болған, соңғы $1 өзгерісті көрсет<br />$3',
'diff'                              => 'айырм.',
'hist'                              => 'тар.',
'hide'                              => 'жасыр',
'show'                              => 'көрсет',
'minoreditletter'                   => 'ш',
'newpageletter'                     => 'Ж',
'boteditletter'                     => 'б',
'sectionlink'                       => '→',
'number_of_watching_users_pageview' => '[бақылаған $1 қатысушы]',
'rc_categories'                     => 'Санаттарға шектеу ("|" белгісімен бөліктеңіз)',
'rc_categories_any'                 => 'Қайсыбір',

# Upload
'upload'                      => 'Файл қотару',
'uploadbtn'                   => 'Қотар!',
'reupload'                    => 'Қайталап қотару',
'reuploaddesc'                => 'Қотару үлгітіне оралу.',
'uploadnologin'               => 'Кірмегенсіз',
'uploadnologintext'           => 'Файл қотару үшін
[[{{ns:special}}:Userlogin|кіруіңіз]] қажет.',
'upload_directory_read_only'  => 'Қотару қалтасына ($1) жазуға веб-серверге рұқсат берілмеген.',
'uploaderror'                 => 'Қотару қатесі',
'uploadtext'                  => "Төмендегі үлгіт файл қотаруға қолданылады, алдындағы суреттерді қарау үшін не іздеу үшін [[{{ns:special}}:Imagelist|қотарылған файлдар тізіміне]] барыңыз, қотару мен жою тағы да [[{{ns:special}}:Log/upload|қотару журналына]] жазылып алынады.

Суреттерді бетке кіргізу үшін, файлға тура байланыстратын
'''<nowiki>[[{{ns:image}}:File.jpg]]</nowiki>''',
'''<nowiki>[[{{ns:image}}:File.png|балама мәтін]]</nowiki>''' немесе
'''<nowiki>[[{{ns:media}}:File.ogg]]</nowiki>''' сілтеме пішімін қолданыңыз.",
'uploadlog'                   => 'қотару журналы',
'uploadlogpage'               => 'Қотару журналы',
'uploadlogpagetext'           => 'Төменде жуықтағы қотарылған файл тізімі.',
'filename'                    => 'Файл аты',
'filedesc'                    => 'Сипаттамасы',
'fileuploadsummary'           => 'Сипаттамасы:',
'filestatus'                  => 'Ауторлық құқықтары күйі',
'filesource'                  => 'Файл қайнары',
'copyrightpage'               => '{{ns:project}}:Ауторлық құқықтар',
'copyrightpagename'           => '{{SITENAME}} ауторлық құқықтары',
'uploadedfiles'               => 'Қотарылған файлдар',
'ignorewarning'               => 'Назар салуды елемеу және файлды әрдеқашан сақтау.',
'ignorewarnings'              => 'Әрқайсы назар салуларды елемеу',
'minlength'                   => 'Файл атында ең кемінде үш әріп болуы керек.',
'illegalfilename'             => '«$1» файл атауында бет атауларында рұқсат етілмеген нышандар бар. Файлды қайта атаңыз, сосын қайта жуктеп көріңіз.',
'badfilename'                 => 'Файлдың аты «$1» боп өзгертілді.',
'badfiletype'                 => '«.$1» ұсынылмаған сурет файлының кеңейтімі.',
'largefile'                   => 'Файл мөлшерін $1 Байттан асырмауға тырысыңыз, бұл файл мөлшері $2 Байт',
'largefileserver'             => 'Осы файлдың мөлшері сервердің қалауынан асып кеткен.',
'emptyfile'                   => 'Қотарылған файлыңыз бос сияқты. Бұл файл атауы жансақ енгізілгенінен болуы мүмкін. Қотарғыңыз келген файл шынында да осы файл болғанын тексеріп алыңыз.',
'fileexists'                  => 'Осындай атаулы файл бар түге. Қайта жазудың алдынан $1 тексеріп шығыңыз.',
'fileexists-forbidden'        => 'Осындай атаулы файл бар түге. Кері қайтыңыз да, және осы файлды басқа атымен қотарыңыз. [[{{ns:image}}:$1|thumb|center|$1]]',
'fileexists-shared-forbidden' => 'Осындай атаулы файл ортақ файл арқауында бар түге. Кері қайтыңыз да, осы файлды жаңа атымен қотарыңыз. [[{{ns:image}}:$1|thumb|center|$1]]',
'successfulupload'            => 'Қотару сәтті өтті',
'fileuploaded'                => '«$1» файлы сәтті қотарылды!
Осы сілтемеге еріп — $2, сипаттама бетіне барыңыз да, және осы файл туралы
ақпарат толтырыңыз: қайдан алынғанын, қашан жасалғанын, кім жасағанын,
тағы басқа білетіңізді. Бұл сурет болса, мынадай пішімімен кірістіруге болады: <tt><nowiki>[[Сурет:$1|thumb|Сипаттамасы]]</nowiki></tt>',
'uploadwarning'               => 'Қотару туралы назар салу',
'savefile'                    => 'Файлды сақтау',
'uploadedimage'               => '«[[$1]]» файлын қотарды',
'uploaddisabled'              => 'Файл қотаруы өшірілген',
'uploaddisabledtext'          => 'Осы уикиде файл қотаруы өшірілген.',
'uploadscripted'              => 'Осы файлда, веб шолғышты ағат түсіндікке келтіретің HTML белгілеу, не скрипт коды бар.',
'uploadcorrupt'               => 'Осы файл бүлдірілген, не әдепсіз кеңейтімі бар. Файлды тексеріп, қотаруын қайталаңыз.',
'uploadvirus'                 => 'Осы файлда вирус болуы мүмкін! Егжей-тегжей ақпараты: $1',
'sourcefilename'              => 'Қайнардағы файл аты',
'destfilename'                => 'Ақырғы файл аты',
'watchthisupload'             => 'Осы бетті бақылау',
'filewasdeleted'              => 'Осы атауы бар файл бұрын қотарылған, сосын жойылдырылған. Қайта қотару алдынан $1 дегенді тексеріңіз.',

'upload-proto-error'      => 'Жарамсыз хаттамалық',
'upload-proto-error-text' => 'Сырттан қотару үшін URL жайлары <code>http://</code> немесе <code>ftp://</code> дегендерден басталу қажет.',
'upload-file-error'       => 'Ішкі қате',
'upload-file-error-text'  => 'Серверде уақытша файл жасауы ішкі қатеге ұшырасты. Бұл жүйенің әкімшімен қатынасыңыз.',
'upload-misc-error'       => 'Белгісіз қотару қатесі',
'upload-misc-error-text'  => 'Қотару кезінде белгісіз қате ұшырасты. Қайсы URL жайы жарамды және қатынаулы екенін тексеріп шығыңыз да қайталап көріңіз. Егер бұл мәселе әлде де қалса, жүйе әкімшімен қатынасыңыз.',

# Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>
'upload-curl-error6'       => 'URL жайы жетілмеді',
'upload-curl-error6-text'  => 'Берілген URL жайы жетілмеді. Қайсы URL жайы дұрыс екенін және торап істе екенін қайталап қатаң тексеріңіз.',
'upload-curl-error28'      => 'Қотаруға берілген уақыт бітті',
'upload-curl-error28-text' => 'Тораптың жауап беруі тым ұзақ уақытқа созылды. Бұл торап істе екенін тексеріп шығыңыз, аз уақыт кідіре тұрыңыз да тағы қайталап көріңіз. Талабыңызды жүктелуі аздау кезінде қайталауға болмыс.',

'license'            => 'Лицензиясы',
'nolicense'          => 'Ештеңе талғанбаған',
'upload_source_url'  => ' (жарамды, баршаға қатынаулы URL жай)',
'upload_source_file' => ' (компьютеріңіздегі файл)',

# Image list
'imagelist'                 => 'Файл тізімі',
'imagelisttext'             => "Төменде ''$2'' сұрыпталған '''$1''' файл тізімі.",
'imagelistforuser'          => 'Мында тек $1 жүктеген суреттер көрсетіледі.',
'getimagelist'              => 'файл тізімдеуі',
'ilsubmit'                  => 'Іздеу',
'showlast'                  => 'Соңғы $1 файл $2 сұрыптап көрсет.',
'byname'                    => 'атымен',
'bydate'                    => 'күн-аймен',
'bysize'                    => 'мөлшерімен',
'imgdelete'                 => 'жою',
'imgdesc'                   => 'сипп.',
'imgfile'                   => 'файл',
'imglegend'                 => 'Шартты белгілер: (сипп.) — файл сипаттамасын көрсету/өңдеу.',
'imghistory'                => 'Файл тарихы',
'revertimg'                 => 'қайт.',
'deleteimg'                 => 'жою',
'deleteimgcompletely'       => 'Осы файлдың барлық нұсқаларын жой',
'imghistlegend'             => 'Шартты белгілер: (ағым.) = ағымдық файл, (жою) = ескі нұсқасын
жою, (қай.) = ескі нұсқасына қайтару.
<br /><i>Қотарылған файлды көру үшін күн-айына нұқыңыз</i>.',
'imagelinks'                => 'Сілтемелері',
'linkstoimage'              => 'Бұл файлға келесі беттер сілтейді:',
'nolinkstoimage'            => 'Бұл файлға еш бет сілтемейді.',
'sharedupload'              => 'Бұл файл ортақ арқауына қотарылған сондықтан басқа жобаларда қолдануы мүмкін.',
'shareduploadwiki'          => 'Былайғы ақпарат үшін $1 дегенді қараңыз.',
'shareduploadwiki-linktext' => 'файл сипаттамасы беті',
'noimage'                   => 'Мынадай атаулы файл жоқ, $1 мүмкіндігіңіз бар.',
'noimage-linktext'          => 'осыны қотару',
'uploadnewversion-linktext' => 'Бұл файлдың жаңа нұсқасын қотару',
'imagelist_date'            => 'Күн-айы',
'imagelist_name'            => 'Атауы',
'imagelist_user'            => 'Қатысушы',
'imagelist_size'            => 'Мөлшері (байт)',
'imagelist_description'     => 'Сипаттамасы',
'imagelist_search_for'      => 'Суретті атымен іздеу:',

# MIME search
'mimesearch' => 'Файлды MIME түрімен іздеу',
'mimetype'   => 'MIME түрі:',
'download'   => 'жүктеу',

# Unwatched pages
'unwatchedpages' => 'Бақыланбаған беттер',

# List redirects
'listredirects' => 'Айдату бет тізімі',

# Unused templates
'unusedtemplates'     => 'Пайдаланылмаған үлгілер',
'unusedtemplatestext' => 'Бұл бет басқа бетке кіріcтірілмеген үлгі есім аяысындағы барлық беттерді тізімдейді. Үлгілерді жою алдынан бұның басқа сілтемелерін тексеріп шығуын ұмытпаңыз',
'unusedtemplateswlh'  => 'басқа сілтемелер',

# Random redirect
'randomredirect' => 'Кездейсоқ айдату',

# Statistics
'statistics'             => 'Жоба санағы',
'sitestats'              => '{{SITENAME}} санағы',
'userstats'              => 'Қатысушы санағы',
'sitestatstext'          => "Мындағы дерекқорда бұлайша '''$1''' бет бар.
Бұның ішінде «талқылау» беттері, {{SITENAME}} жобасы туралы беттер, кішкене «бітеме»
беттер, айдатулар, мағлұмат бет деп саналмайтын, бәлкім, тағы да басқалар.
Осыны есептен шығарғанда, мында мағлұматты деп саналатын
'''$2''' бет бар шығар.

Торапқа '''$8''' файл қотарылған.

Осы уики жобасы орнатылғаннан бері бұлайша беттер '''$3''' рет қаралған,
және беттер '''$4''' рет өңделген.
Бұның нәтижесінде орта есеппен бір бет сайын '''$5''' өңдеу істелінген, және бір өңдеу сайын '''$6''' рет қарау келген.

Ағымдық [http://meta.wikimedia.org/wiki/Help:Job_queue тапсырым кезегі] ұзындылығы: '''$7'''.",
'userstatstext'          => "Мында '''$1''' тіркелген қатысушы бар, соның ішінде
'''$2''' (немесе '''$4 %''') $5 бар.",
'statistics-mostpopular' => 'Ең көп қаралған беттер',

'disambiguations'     => 'Айрықты беттер',
'disambiguationspage' => '{{ns:template}}:Disambig',
'disambiguationstext' => 'Келесі беттер <i>айрықты бетке</i> сілтейді. Бұның орнына белгілі тақырыпқа сілтеуі қажет.<br />Бетке $1 сілтеген жағдайда, бет айрықты деп саналады.<br />Басқа есім аясынан нұсқайтын сілтемелер мында <i>тізімделмейді</i>.',

'doubleredirects'     => 'Шынжырлы айдатулар',
'doubleredirectstext' => 'Әрбір жолдағы бірінші мен екінші айдату сілтемелері бар, сонымен бірге екінші айдату мәтіннің бірінші жолы бар. Әдетте бірінші сілтеме айдайтын «шын» ақырғы беттің атауы болуы қажет.',

'brokenredirects'     => 'Еш бетке келтірмейтін айдатулар',
'brokenredirectstext' => 'Келесі айдатулар жоқ беттерге сілтейді:',

# Miscellaneous special pages
'nbytes'                  => '$1 Байт',
'ncategories'             => '$1 санат',
'nlinks'                  => '$1 сілтеме',
'nmembers'                => '$1 буын',
'nrevisions'              => '$1 нұсқа',
'nviews'                  => '$1 рет қаралған',
'lonelypages'             => 'Еш бет сілтемеген беттер',
'lonelypagestext'         => 'Келесі беттерге осы жобадағы басқа беттер сілтемейді.',
'uncategorizedpages'      => 'Еш санатқа кірмеген беттер',
'uncategorizedcategories' => 'Еш санатқа кірмеген санаттар',
'uncategorizedimages'     => 'Еш санатқа кірмеген суреттер',
'unusedcategories'        => 'Пайдаланылмаған санаттар',
'unusedimages'            => 'Пайдаланылмаған файлдар',
'popularpages'            => 'Әйгілі беттер',
'wantedcategories'        => 'Басталмаған санаттар',
'wantedpages'             => 'Басталмаған беттер',
'mostlinked'              => 'Ең көп сілтенген беттер',
'mostlinkedcategories'    => 'Ең көп сілтенген санаттар',
'mostcategories'          => 'Ең көп санаттарға кірген беттер',
'mostimages'              => 'Ең көп сілтенген суреттер',
'mostrevisions'           => 'Ең көп түзетілген беттер',
'allpages'                => 'Барлық бет тізімі',
'prefixindex'             => 'Бет бастау тізімі',
'randompage'              => 'Кездейсоқ бет',
'shortpages'              => 'Ең қысқа беттер',
'longpages'               => 'Ең үлкен беттер',
'deadendpages'            => 'Еш бетке сілтемейтін беттер',
'deadendpagestext'        => 'Келесі беттер осы жобадағы басқа беттерге сілтемейді.',
'listusers'               => 'Барлық қатысушы тізімі',
'specialpages'            => 'Арнайы беттер',
'spheading'               => 'Баршаның арнайы беттері',
'restrictedpheading'      => 'Шектеулі арнайы беттер',
'recentchangeslinked'     => 'Қатысты түзетулер',
'rclsub'                  => '(«$1» бетінен сілтенген беттерге)',
'newpages'                => 'Ең жаңа беттер',
'newpages-username'       => 'Қатысушы аты:',
'ancientpages'            => 'Ең ескі беттер',
'intl'                    => 'Тіларалық сілтемелер',
'move'                    => 'Жылжыту',
'movethispage'            => 'Бетті жылжыту',
'unusedimagestext'        => '<p>Ескерту: Басқа веб тораптар файлдың
URL жайына тікелей сілтеуі мүмкін. Сондықтан, белсенді пайдалануына аңғармай,
осы тізімде қалуы мүмкін.</p>',
'unusedcategoriestext'    => 'Келесі санат беттер бар болып тұр, бірақ оған ешқандай бет, не санат кірмейді.',
'booksources'             => 'Кітап қайнарлары',
'categoriespagetext'      => 'Осында уикидегі барлық санаттарының тізімі беріліп тұр.',
'data'                    => 'Деректер',
'userrights'              => 'Қатысушылар құқықтарын меңгеру',
'groups'                  => 'Қатысушы топтары',
'booksourcetext'          => 'Төменде жаңа және қолданған кітаптар сататын
тораптарының сілтемелері тізімделген. Бұл тораптарда ізделген кітаптар
туралы былайғы ақпарат болуға мүмкін.',
'isbn'                    => 'ISBN белгісі',
'alphaindexline'          => '$1 — $2',
'version'                 => 'Жүйе нұсқасы',
'log'                     => 'Журналдар',
'alllogstext'             => 'Біріккен қотару, жою, қорғау, бұғаттау және әкімшілік журналдарын көрсету.
Журнал түрін, қатысушы атын, тиісті бетін талғап, тарылтып қарауыңызға болады.',
'logempty'                => 'Журналда сәйкес даналар жоқ.',

# Special:Allpages
'nextpage'          => 'Келесі бетке ($1)',
'allpagesfrom'      => 'Мына беттен бастап көрсету:',
'allarticles'       => 'Барлық бет тізімі',
'allinnamespace'    => 'Барлық бет ($1 есім аясы)',
'allnotinnamespace' => 'Барлық бет ($1 есім аясынан тыс)',
'allpagesprev'      => 'Алдыңғыға',
'allpagesnext'      => 'Келесіге',
'allpagessubmit'    => 'Өту',
'allpagesprefix'    => 'Мынадан басталған беттерді көрсету:',
'allpagesbadtitle'  => 'Алынған бет атауы жарамсыз болған, немесе тіл-аралық не уики-аралық бастауы бар болды. Атауда қолдануға болмайтын нышандар болуы мүмкін.',

# Special:Listusers
'listusersfrom' => 'Мына қатысушыдан бастап көрсету:',

# E-mail user
'mailnologin'     => 'Е-пошта жайы жіберілген жоқ',
'mailnologintext' => 'Басқа қатысушыға хат жіберу үшін
[[{{ns:special}}:Userlogin|кіруіңіз]] қажет, және [[{{ns:special}}:Preferences|баптауыңызда]]
куәландырылған е-пошта жайы болуы жөн.',
'emailuser'       => 'Қатысушыға хат жазу',
'emailpage'       => 'Қатысушыға хат жіберу',
'emailpagetext'   => 'Егер бұл қатысушы баптауларында куәландырған е-пошта
жайын енгізсе, төмендегі үлгіт арқылы бұған жалғыз е-пошта хатын жіберуге болады.
Қатысушы баптауыңызда енгізген е-пошта жайыңыз
«Кімнен» деген бас жолағында көрінеді, сондықтан
хат алушысы тура жауап бере алады.',
'usermailererror' => 'Mail нысаны қате қайтарды:',
'defemailsubject' => '{{SITENAME}} е-поштасының хаты',
'noemailtitle'    => 'Бұл е-пошта жайы емес',
'noemailtext'     => 'Осы қатысушы жарамды Е-пошта жайын енгізбеген,
немесе басқалардан хат қабылдауын өшірген.',
'emailfrom'       => 'Кімнен',
'emailto'         => 'Кімге',
'emailsubject'    => 'Тақырыбы',
'emailmessage'    => 'Хат',
'emailsend'       => 'Жіберу',
'emailccme'       => 'Хатымдың көшірмесін маған да жібер.',
'emailccsubject'  => '$1 дегенге жіберілген хатыңыздың көшірмесі: $2',
'emailsent'       => 'Хат жіберілді',
'emailsenttext'   => 'Е-пошта хатыңыз жіберілді.',

# Watchlist
'watchlist'            => 'Бақылауым',
'watchlistfor'         => "('''$1''' бақылаулары)",
'nowatchlist'          => 'Бақылау тізіміңізде ешбір дана жоқ',
'watchlistanontext'    => 'Бақылау тізіміңіздегі даналарды қарау, не өңдеу үшін $1 қажет.',
'watchlistcount'       => "'''Бақылау тізіміңізде (талқылау беттерді қоса) $1 дана бар.'''",
'clearwatchlist'       => 'Бақылау тізімін тазалау',
'watchlistcleartext'   => 'Соларды толық аластатуға батылсыз ба?',
'watchlistclearbutton' => 'Бақылау тізімін тазалау',
'watchlistcleardone'   => 'Бақылау тізіміңіз тазартылды. $1 дана аластатылды.',
'watchnologin'         => 'Кірмегенсіз',
'watchnologintext'     => 'Бақылау тізіміңізді өзгерту үшін [[{{ns:special}}:Userlogin|кіруіңіз]] жөн.',
'addedwatch'           => 'Бақылау тізіміне қосылды',
'addedwatchtext'       => "«[[:$1]]» беті [[{{ns:special}}:Watchlist|бақылау тізіміңізге]] қосылды.
Осы беттің және соның талқылау бетінің келешектегі өзгерістері мында тізімделеді.
Сонда беттің атауы табуға жеңілдетіп [[{{ns:special}}:Recentchanges|жуықтағы өзгерістер тізімінде]]
'''жуан әрпімен''' көрсетіледі.

Осы бетті соңынан бақылау тізімнен аластатыңыз келсе «Бақыламау» парағын нұқыңыз.",
'removedwatch'         => 'Бақылау тізіміңізден аластатылды',
'removedwatchtext'     => '«[[:$1]]» беті бақылау тізіміңізден аластатылды.',
'watch'                => 'Бақылау',
'watchthispage'        => 'Бетті бақылау',
'unwatch'              => 'Бақыламау',
'unwatchthispage'      => 'Бақылауды тоқтату',
'notanarticle'         => 'Мағлұмат беті емес',
'watchnochange'        => 'Көрсетілген мерзімде ешбір бақыланған дана өңделген жоқ.',
'watchdetails'         => "* Бақылау тізімінде (талқылау беттерісіз) '''$1''' бет бар.
* [[{{ns:special}}:Watchlist/edit|Бүкіл тізімді қарау және өзгерту]].
* [[{{ns:special}}:Watchlist/clear|Тізімдегі барлық дана аластату]].",
'wlheader-enotif'      => '* Ескерту хат жіберуі ендірілген.',
'wlheader-showupdated' => "* Соңғы кіргенімнен бері түзетілген беттерді '''жуан''' мәтінмен көрсет",
'watchmethod-recent'   => 'бақылаулы беттердің жуықтағы өзгерістерін тексеру',
'watchmethod-list'     => 'жуықтағы өзгерістерде бақылаулы беттерді тексеру',
'removechecked'        => 'Белгіленгенді бақылау тізімінен аластату',
'watchlistcontains'    => 'Бақылау тізіміңізде $1 бет бар.',
'watcheditlist'        => "Осында әліппем сұрыпталған бақыланған мағлұмат беттеріңіз тізімделінген.
Беттерді аластату үшін оның қасындағы қабашақтарды белгілеп, төмендегі ''Белгіленгенді аластат'' түймесін нұқыңыз
(мағлұмат бетін жойғанда талқылау беті де бірге жойылады).",
'removingchecked'      => 'Сұранған даналарды бақылау тізімнен аластауы…',
'couldntremove'        => '«$1» деген дана аластатылмады…',
'iteminvalidname'      => '«$1» данасының жарамсыз атауынан шатақ туды…',
'wlnote'               => 'Төменде соңғы <b>$2</b> сағаттағы, соңғы $1 өзгеріс көрсетілген.',
'wlshowlast'           => 'Соңғы $1 сағаттағы, $2 күндегі, $3 болған өзгерісті көрсету',
'wlsaved'              => 'Бұл бақылу тізіміңіздің сақталған нұсқасы.',
'wlhideshowown'        => 'Түзетуімді $1',
'wlhideshowbots'       => 'Боттарды $1',
'wldone'               => 'Іс бітті.',

'enotif_mailer'      => '{{SITENAME}} ескерту хат жіберу қызметі',
'enotif_reset'       => 'Барлық бет каралді деп белгіле',
'enotif_newpagetext' => 'Мынау жаңа бет.',
'changed'            => 'өзгертті',
'created'            => 'жасады',
'enotif_subject'     => '{{SITENAME}} жобасында $PAGEEDITOR $PAGETITLE атаулы бетті $CHANGEDORCREATED',
'enotif_lastvisited' => 'Соңғы кіруіңізден бері болған өзгерістер үшін $1 дегенді қараңыз.',
'enotif_body'        => 'Құрметті $WATCHINGUSERNAME,

{{SITENAME}} жобасыда $PAGEEDITDATE кезінде $PAGEEDITOR $PAGETITLE атаулы бетті $CHANGEDORCREATED, ағымдық нұсқасын $PAGETITLE_URL жайынан қараңыз.

$NEWPAGE

Өңдеуші сипаттамасы: $PAGESUMMARY $PAGEMINOREDIT

Өңдеушімен қатынасу:
е-пошта: $PAGEEDITOR_EMAIL
уики: $PAGEEDITOR_WIKI

Былайғы өзгерістер болғанда да сіз осы бетке барғанша дейін ешқандай басқа ескерту хаттар жіберілмейді. Сонымен қатар бақылау тізіміңіздегі бет ескертпелік белгісін әдепке күйіне келтіріңіз.

             Сіздің досты {{SITENAME}} ескерту қызметі

----
Бақылау тізіміңізді баптау үшін, мында барыңыз
{{fullurl:{{ns:special}}:Watchlist/edit}}

Сын-пікір беру және былайғы жәрдем алу үшін:
{{fullurl:{{ns:help}}:Мазмұны}}',

# Delete/protect/revert
'deletepage'                  => 'Бетті жою',
'confirm'                     => 'Растау',
'excontent'                   => 'болған мағлұматы: «$1»',
'excontentauthor'             => 'болған мағлұматы: «$1» (тек «[[Special:Contributions/$2|$2]]» үлесі)',
'exbeforeblank'               => 'тазарту алдындағы болған мағлұматы: «$1»',
'exblank'                     => 'бет босты болды',
'confirmdelete'               => 'Жоюды растау',
'deletesub'                   => '(«$1» жоюы)',
'historywarning'              => 'Назар салыңыз: Жоюға арналған бетте өз тарихы бар:',
'confirmdeletetext'           => 'Бетті немесе суретті барлық тарихымен
бірге дерекқордан әрдайым жойығыңыз келетін сияқты.
Бұны жоюдың зардабын түсініп шын ниеттенгеніңізді, және
[[{{ns:project}}:Саясат]]қа лайықты деп
сенгеніңізді растаңыз.',
'actioncomplete'              => 'Әрекет бітті',
'deletedtext'                 => '«$1» жойылды.
Жуықтағы жоюлар туралы жазбаларын $2 дегеннен қараңыз.',
'deletedarticle'              => '«[[$1]]» бетін жойды',
'dellogpage'                  => 'Жою_журналы',
'dellogpagetext'              => 'Төменде жуықтағы жоюлардың тізімі берілген.',
'deletionlog'                 => 'жою журналы',
'reverted'                    => 'Ертерек нұсқасына қайтарылған',
'deletecomment'               => 'Жоюдың себебі',
'imagereverted'               => 'Ертерек нұсқасына қайтару сәтті өтті.',
'rollback'                    => 'Түзетулерді қайтару',
'rollback_short'              => 'Қайтару',
'rollbacklink'                => 'қайтару',
'rollbackfailed'              => 'Қайтару сәтсіз аяқталды',
'cantrollback'                => 'Түзету қайтарылмайды. Бұл беттің соңғы үлескері тек бастауыш ауторы.',
'alreadyrolled'               => '[[{{ns:user}}:$2|$2]] ([[{{ns:user_talk}}:$2|талқылауы]]) дегенді жасаған [[:$1]]
бетінің соңғы өңдеуінен қайтару өтпеді; кейбіреу осы қазір бетті өңдеп не қайтарып жатыр түге.

Соңғы өңдеуді [[{{ns:user}}:$3|$3]] ([[{{ns:user_talk}}:$3|талқылауы]]) дегенді жасаған.',
'editcomment'                 => 'Түзетудің болған мәндемесі: "<i>$1</i>".', # only shown if there is an edit comment
'revertpage'                  => '[[{{ns:special}}:Contributions/$2|$2]] ([[{{ns:user_talk}}:$2|талқылауы]]) түзетуінен [[{{ns:user}}:$1|$1]] соңғы нұсқасына қайтарды',
'sessionfailure'              => 'Кіру сессиясында шатақ болған сияқты;
сессияға шабуылдаудардан қорғану үшін, осы әрекет тоқтатылды.
«Артқа» түймесін басыңыз, және бетті кері жүктеңіз, сосын қайталап көріңіз.',
'protectlogpage'              => 'Қорғау_журналы',
'protectlogtext'              => 'Төменде беттердің қорғау/қорғамау тізімі берілген.',
'protectedarticle'            => '«$1» қорғалды',
'unprotectedarticle'          => '«[[$1]]» қорғалмады',
'protectsub'                  => '(«$1» қорғауда)',
'confirmprotecttext'          => 'Осы бетті расында да қорғау қажет пе?',
'confirmprotect'              => 'Қорғауды растау',
'protectmoveonly'             => 'Тек жылжытудан қорғау',
'protectcomment'              => 'Қорғау себебі',
'unprotectsub'                => '(«$1» қорғамауда)',
'confirmunprotecttext'        => 'Осы бетті растан қорғамау қажет пе?',
'confirmunprotect'            => 'Қорғамауды растау',
'unprotectcomment'            => 'Қорғамау себебі',
'protect-unchain'             => 'Жылжытуға рұқсат беру',
'protect-text'                => '<strong>$1</strong> бетінің қорғау деңгейін қарай және өзгерте аласыз.',
'protect-viewtext'            => 'Тіркелгіңіз бет қорғанысы денгейлерін өзгертуге рұқсат бермейді.
Мына <strong>$1</strong> беттің ағымдық баптаулары:',
'protect-default'             => '(әдепкі)',
'protect-level-autoconfirmed' => 'Тіркелгісіз пайдаланушыларға тиым',
'protect-level-sysop'         => 'Тек әкімшілерге рұқсат',

# Restrictions (nouns)
'restriction-edit' => 'Өңдеу',
'restriction-move' => 'Жылжыту',

# Undelete
'undelete'                 => 'Жойылған беттерді қарау',
'undeletepage'             => 'Жойылған беттерді қарау және қайтару',
'viewdeletedpage'          => 'Жойылған беттерді қарау',
'undeletepagetext'         => 'Келесі беттер жойылды деп белгіленген, бірақ мағлұматы мұрағатта жатқан,
сондықтан кері қайтаруға әзір. Мұрағат мерзім бойынша тазаланып тұруы мүмкін.',
'undeleteextrahelp'        => "Бүкіл бетті қайтару үшін, барлық қабашақтарды бос қалдырып
'''''Қайтар!''''' түймесін нұқыңыз. Бөлекше қайтару орындау үшін, қайтарайын деген нұсқаларына сәйкес
қабашақтарын белгілеңіз де, және '''''Қайтар!''''' түймесін нұқыңыз. '''''Таста''''' түймесін
нұқығанда мәндеме аумағы мен барлық қабашақтар тазаланады.",
'undeletearticle'          => 'Жойылған бетті қайтару',
'undeleterevisions'        => '$1 нұсқа мұрағатталған',
'undeletehistory'          => 'Егер бет мағлұматын қайтарсаңыз,тарихында барлық нұсқалар да
қайтарылады. Егер жоюдан соң дәл солай атауымен жаңа бет жасалса, қайтарылған нұсқалар
тарихтың ең адында көрсетіледі, және көрсетіліп тұрған беттің ағымдық нұсқасы
өздік түрде алмастырылмайды.',
'undeletehistorynoadmin'   => 'Бұл бет жойылған. Жою себебі алдындағы өңдеген қатысушылар
егжей-тегжейлерімен бірге төмендегі сипаттамасында көрсетілген.
Осы жойылған нұсқалардың мәтіні тек әкімшілерге қатынаулы.',
'undeleterevision'         => '$1 кезіндегі жойылған нұсқасын',
'undeleterevision-missing' => 'Жарамсыз не жоғалған нұсқа. Сілтемеңіз жарамсыз болуы мүмкін, не
нұсқа қайтарылған түге немесе мұрағаттан аластатылған.',
'undeletebtn'              => 'Қайтар!',
'undeletereset'            => 'Таста',
'undeletecomment'          => 'Мәндемесі:',
'undeletedarticle'         => '«[[$1]]» қайтарды',
'undeletedrevisions'       => '$1 нұсқасы қайтарылған',
'undeletedrevisions-files' => '$1 нұсқа және $2 файл қайтарылды',
'undeletedfiles'           => '$1 файл қайтарылды',
'cannotundelete'           => 'Қайтару сәтсіз бітті; тағы біреу сізден бұрын сол бетті қайтарған болар.',
'undeletedpage'            => "<big>'''$1 қайтарылды'''</big>

Жуықтағы жою мен қайтару жөнінде [[{{ns:special}}:Log/delete|жою журналын]] қараңыз.",

# Namespace form on various pages
'namespace' => 'Есім аясы:',
'invert'    => 'Талғауды керілеу',

# Contributions
'contributions' => 'Қатысушы үлесі',
'mycontris'     => 'Үлесім',
'contribsub'    => '$1 үлесі',
'nocontribs'    => 'Осы іздеу шартына сәйкес өзгерістер табылған жоқ.',
'ucnote'        => 'Төменде осы қатысушының соңғы <b>$2</b> күндегі, соңғы <b>$1</b> өзгерісі көрсетледі.',
'uclinks'       => 'Соңғы $2 күндегі, соңғы $1 өзгерісін қарау.',
'uctop'         => ' (үсті)',
'newbies'       => 'жаңа қатысушылар',

'sp-newimages-showfrom' => '$1 кезінен бері — жаңа суреттерді көрсет',

'sp-contributions-newest'      => 'Ең жаңасына',
'sp-contributions-oldest'      => 'Ең ескісіне',
'sp-contributions-newer'       => 'Жаңалау $1',
'sp-contributions-older'       => 'Ескілеу $1',
'sp-contributions-newbies-sub' => 'Жаңа қатысушыларға',

# What links here
'whatlinkshere' => 'Сілтеген беттер',
'notargettitle' => 'Ақырғы атау жоқ',
'notargettext'  => 'Осы әрекет орындалатын нысана бет,
не қатысушы көрсетілмеген.',
'linklistsub'   => '(Сілтемелер тізімі)',
'linkshere'     => "'''[[:$1]]''' дегенге мына беттер сілтейді:",
'nolinkshere'   => "'''[[:$1]]''' дегенге еш бет сілтемейді.",
'isredirect'    => 'айдату беті',
'istemplate'    => 'кіріктіру',

# Block/unblock
'blockip'                     => 'Пайдаланушыны бұғаттау',
'blockiptext'                 => 'Төмендегі үлгіт пайдаланушының жазу рұқсатын
белгілі IP жайымен не атауымен бұғаттау үшін қолданылады.
Бұны тек бұзақылыққа кедергі істеу үшін және де
[[{{ns:project}}:Саясат|саясат]] бойынша атқаруыңыз жөн.
Төменде тиісті себебін толтырып көрсетіңіз (мысалы, дәйекке бұзақылықпен
өзгерткен беттерді келтіріп).',
'ipaddress'                   => 'IP жай',
'ipadressorusername'          => 'IP жай не қатысушы аты',
'ipbexpiry'                   => 'Бітетін мерзімі',
'ipbreason'                   => 'Себебі',
'ipbanononly'                 => 'Тек тіркелгісізді бұғаттау',
'ipbcreateaccount'            => 'Тіркелгі жасауын кедергілеу',
'ipbenableautoblock'          => 'Бұл қатысушының қолданған соңғы IP жайын, және әрқайсы кейін түзету істеуге үмітеліген жайларын өздік түрде бұғаттау',
'ipbsubmit'                   => 'Пайдаланушыны бұғаттау',
'ipbother'                    => 'Басқа мерзім',
'ipboptions'                  => '2 сағат:2 hours,1 күн:1 day,3 күн:3 days,1 апта:1 week,2 апта:2 weeks,1 ай:1 month,3 ай:3 months,6 ай:6 months,1 жыл:1 year,мәнгі:infinite',
'ipbotheroption'              => 'басқа',
'badipaddress'                => 'Жарамсыз IP жай',
'blockipsuccesssub'           => 'Бұғаттау сәтті өтті',
'blockipsuccesstext'          => '[[{{ns:special}}:Contributions/$1|$1]] деген бұғатталған.
<br />Бұғаттауларды [[{{ns:special}}:Ipblocklist|IP бұғаттау тізімінде]] қарап шығыңыз.',
'unblockip'                   => 'Пайдаланушыны бұғаттамау',
'unblockiptext'               => 'Төмендегі үлгіт белгілі IP жайымен не атауымен
бұрын бұғатталған пайдаланушының жазу рұқсатын қайтару үшін қолданылады.',
'ipusubmit'                   => 'Осы жайды бұғаттамау',
'unblocked'                   => '[[{{ns:user}}:$1|$1]] бұғаттауы өшірілді',
'ipblocklist'                 => 'Бұғатталған пайдаланушы / IP- жай тізімі',
'blocklistline'               => '$1, $2 «$3» дегенді бұғаттады ($4)',
'infiniteblock'               => 'мәнгі',
'expiringblock'               => 'бітуі: $1',
'anononlyblock'               => 'тек тіркелгісізді',
'noautoblockblock'            => 'өздік бұғаттау өшіріленген',
'createaccountblock'          => 'тіркелгі жасауы бұғатталған',
'ipblocklistempty'            => 'Бұғаттау тізімі бос.',
'blocklink'                   => 'бұғаттау',
'unblocklink'                 => 'бұғаттамау',
'contribslink'                => 'үлесі',
'autoblocker'                 => "IP жайыңызды жуықта «[[{{ns:user}}:1|$1]]» пайдаланған, сондықтан өздік түрде бұғатталған. $1 бұғаттау себебі: «'''$2'''».",
'blocklogpage'                => 'Бұғаттау_журналы',
'blocklogentry'               => '«[[$1]]» бұғаттады, бітетін мерзімі: $2',
'blocklogtext'                => 'Бұл пайдаланушыларды бұғаттау/бұғаттамау әрекеттерінің журналы. Өздік түрде
бұғатталған IP жайлар осында тізімделгемеген. Ағымдағы белсенді бұғаттауларын
[[{{ns:special}}:Ipblocklist|IP бұғаттау тізімінен]] қарауға болады.',
'unblocklogentry'             => '«$1» бұғаттауын өшірді',
'range_block_disabled'        => 'Ауқым бұғаттауын жасау әкімшілік мүмкіндігі өшірілген.',
'ipb_expiry_invalid'          => 'Бітетін уақыты жарамсыз.',
'ipb_already_blocked'         => '«$1» бұғатталған түге',
'ip_range_invalid'            => 'IP жай ауқымы жарамсыз.',
'proxyblocker'                => 'Прокси серверлерді бұғаттауыш',
'ipb_cant_unblock'            => 'Қате: IP $1 бұғаттауы табылмады. Оның бұғаттауы өшірлген сияқты.',
'proxyblockreason'            => 'IP жайыңыз ашық прокси серверге жататындықтан бұғатталған. Интернет қызметін жабдықтаушыңызбен, не техникалық медеу қызметімен қатынасыңыз, және оларға осы оте күрделі қауыпсіздік шатақ туралы ақпарат беріңіз.',
'proxyblocksuccess'           => 'Бітті.',
'sorbs'                       => 'DNSBL қара тізімі',
'sorbsreason'                 => 'Сіздің IP жайыңыз осы торапта қолданылған DNSBL қара тізіміндегі ашық прокси-сервер деп табылады.',
'sorbs_create_account_reason' => 'Сіздің IP жайыңыз осы торапта қолданылған DNSBL қара тізіміндегі ашық прокси-сервер деп табылады. Тіркелгі жасай алмайсыз.',

# Developer tools
'lockdb'              => 'Дерекқорды құлыптау',
'unlockdb'            => 'Дерекқорды құлыптамау',
'lockdbtext'          => 'Дерекқордын құлыпталуы барлық пайдаланушының
бет өңдеу, баптауын қалау, бақылау тізімін, тағы басқа
дерекқорды өзгертетін мүмкіндіктерін тоқтата тұрады.
Осы мақсатыңызды, және жөндеуіңіз біткенде
дерекқорды ашатыңызды растаңыз.',
'unlockdbtext'        => 'Дерекқодын ашылуы барлық пайдаланушының бет өңдеу,
баптауын қалау, бақылау тізімін, тағы басқа дерекқорды өзгертетін
мүмкіндіктерін қайта ашады.
Осы мақсатыңызды растаңыз.',
'lockconfirm'         => 'Иә, мен дерекқорды растан құлыптаймын.',
'unlockconfirm'       => 'Иә, мен дерекқорды растан құлыптамаймын.',
'lockbtn'             => 'Дерекқорды құлыпта',
'unlockbtn'           => 'Дерекқорды құлыптама',
'locknoconfirm'       => 'Растау белгісін қоймапсыз.',
'lockdbsuccesssub'    => 'Дерекқорды құлыптау сәтті өтті',
'unlockdbsuccesssub'  => 'Құлыпталған дерекқор ашылды',
'lockdbsuccesstext'   => 'Дерекқор құлыпталды.
<br />Жөндеуіңіз біткеннен кейін [[{{ns:special}}:Unlockdb|құлыптауын өшіруге]] ұмытпаңыз.',
'unlockdbsuccesstext' => 'Құлыпталған дерекқор сәтті ашылды.',
'lockfilenotwritable' => 'Дерекқор құлыптау файлы жазылмайды. Дерекқорды құлыптау не ашу үшін, веб-сервер файлға жазу рұқсаты болу қажет.',
'databasenotlocked'   => 'Дерекқор құлыпталған жоқ.',

# Make sysop
'makesysoptitle'     => 'Қатысушыны әкімші қылу',
'makesysoptext'      => 'Бұл үлгітті қарапайым қатысушыны әкімші қылу үшін төрешілер қолданады.
Жолаққа қатысушы атын енгізіңіз де, және бұл қатысушыны әкімші қылу үшін, түймені басыңыз.',
'makesysopname'      => 'Қатысушы аты:',
'makesysopsubmit'    => 'Бұл қатысушыны әкімші қыл',
'makesysopok'        => '<b>«$1» деген қатысушы енді әкімші боп тағайындалды</b>',
'makesysopfail'      => '<b>«$1» деген қатысушы әкімші боп тағайындалмады. (Атын дұрыс енгіздіңіз бе?)</b>',
'setbureaucratflag'  => 'Қатысушыны төреші қылу',
'rightslog'          => 'Қатысушы_құқықтары_журналы',
'rightslogtext'      => 'Бұл пайдаланушы құқықтарын өзгерту журналы.',
'rightslogentry'     => ' $1 топ мүшелгін $2 дегеннен $3 дегенге өзгертті',
'rights'             => 'Құқықтары:',
'set_user_rights'    => 'Қатысушы құқықтарын тағайындау',
'user_rights_set'    => '<b>«$1» деген қатысушының құқықтары жаңартылды</b>',
'set_rights_fail'    => '<b>«$1» деген қатысушының құқықтары тағайындалмады. (Атын дұрыс енгіздіңіз бе?)</b>',
'makesysop'          => 'Қатысушыны әкімші қылу',
'already_sysop'      => 'Бұл қатысушы әкімші бопты түге',
'already_bureaucrat' => 'Бұл қатысушы тореші бопты түге',
'rightsnone'         => '(ешқандай)',

# Move page
'movepage'                => 'Бетті жылжыту',
'movepagetext'            => "Төмендегі үлгітті қолданып беттерді қайта атайды,
барлық тарихын жаңа атауға жылжытады.
Бұрынғы бет атауы жаңа атауға айдататын бет болады.
Ескі атауына сілтейтін  сілтемелер өзгертілмейді; жылжытудан соң
шынжырлы айдатулар бар-жоғын тексеріңіз.
Сілтемелер бұрынғы жолдауымен былайғы өтуін тексеруіне
сіз міндетті боласыз.

Ескеріңіз, егер жылжытылатын атауда бет болса, сол ескі бетке айдату
болғанша және тарихы болса, бет '''жылжытылмайды'''.
Осының мағынасы: егер бетті қателік пен қайта аталса,
бұрынғы атауына қайта атауға болады,
бірақ бар беттің үстіне жазуға болмайды.

<b>НАЗАР САЛЫҢЫЗ!</b>
Бұл дәріпті бетке қатаң және кенет өзгеріс жасауға мүмкін;
әрекеттің алдынан осының зардаптарын түсінгеніңізге батыл
болыңыз.",
'movepagetalktext'        => "Келесі себептер '''болғанша''' дейін, талқылау беті өздік түрде бірге жылжытылады:
* Бос емес талқылау беті жаңа атауда болғанда, немесе
* Төмендегі қабышақта белгіні аластатқанда.

Осы орайда, қалауыңыз болса, бетті қолдан жылжыта не қоса аласыз.",
'movearticle'             => 'Бетті жылжыту',
'movenologin'             => 'Жүйеге кірмегенсіз',
'movenologintext'         => 'Бетті жылжыту үшін тіркелген болуыңыз және
 [[{{ns:special}}:Userlogin|кіруіңіз]] қажет.',
'newtitle'                => 'Жаңа атауға',
'movepagebtn'             => 'Бетті жылжыт',
'pagemovedsub'            => 'Жылжыту сәтті аяқталды',
'pagemovedtext'           => '«[[$1]]» беті «[[$2]]» бетіне жылжытылды.',
'articleexists'           => 'Былай атаулы бет бар болды, не таңдаған
атауыңыз жарамды емес.
Басқа атау тандаңыз',
'talkexists'              => "'''Беттің өзі сәтті жылжытылды, бірақ талқылау беті бірге жылжытылмады, оның себебі жаңа атаудың талқылау беті бар түге. Бұны қолмен қосыңыз.'''",
'movedto'                 => 'мынаған жылжытылды:',
'movetalk'                => 'Қатысты талқылау бетімен бірге жылжыту',
'talkpagemoved'           => 'Қатысты талқылау беті де жылжытылды.',
'talkpagenotmoved'        => 'Қатысты талқылау беті <strong>жылжытылмады</strong>.',
'1movedto2'               => '«[[$1]]» бетінде айдату қалдырып «[[$2]]» бетіне жылжытты',
'1movedto2_redir'         => '«[[$1]]» бетін «[[$2]]» айдату бетінің үстіне жылжытты',
'movelogpage'             => 'Жылжыту журналы',
'movelogpagetext'         => 'Төменде жылжытылған беттердің тізімі беріліп тұр.',
'movereason'              => 'Себебі',
'revertmove'              => 'қайтару',
'delete_and_move'         => 'Жою және жылжыту',
'delete_and_move_text'    => '==Жою қажет==

Ақырғы «[[$1]]» бет атауы бар түге.
Жылжытуға жол беру үшін жоямыз ба?',
'delete_and_move_confirm' => 'Иә, осы бетті жой',
'delete_and_move_reason'  => 'Жылжытуға жол беру үшін жойылған',
'selfmove'                => 'Қайнар және ақырғы атауы бірдей; бет өзіне жылжытылмайды.',
'immobile_namespace'      => 'Қайнар немесе ақырғы атауы арнайы түрінде болды; осындай есім аясы жағына және жағынан беттер жылжытылмайды.',

# Export
'export'          => 'Беттерді сыртқа беру',
'exporttext'      => 'XML пішіміне қапталған бөлек бет не беттер бумасы
мәтінің және өңдеу тарихын сыртқа бере аласыз. Осыны, басқа уики-ге
{{ns:special}}:Import page MediaWiki құралы арқылы, сырттан алуға болады.

Беттерді сыртқа беру үшін, атауларын төмендегі мәтін аумағына енгізіңіз,
бір жолда бір атау, және тандаңыз: не ағымдық нұсқасын, барлық ескі нұсқалары мен
және тарихы жолдары мен бірге, не дәл ағымдық нұсқасын, соңғы өңдеу туралы ақпараты мен бірге.

Соңғы жағдайда сілтемені де қолдануға болады, мысалы {{int:mainpage}} беті үшін [[{{ns:Special}}:Export/{{int:mainpage}}]].',
'exportcuronly'   => 'Толық тарихын емес, тек ағымдық нұсқасын кірістіріңіз',
'exportnohistory' => "----
'''Аңғартпа:''' Өнімділік әсері себептерінен, беттер толық тарихын сыртқа беруі өшірілген.",
'export-submit'   => 'Сыртқа бер',

# Namespace 8 related
'allmessages'               => 'Жүйе хабарлары',
'allmessagesname'           => 'Атауы',
'allmessagesdefault'        => 'Әдепкі мәтіні',
'allmessagescurrent'        => 'Ағымдық мәтіні',
'allmessagestext'           => 'Мында «MediaWiki:» есім аясындағы барлық қатынаулы жүйе хабар тізімі беріліп тұр.',
'allmessagesnotsupportedUI' => 'Your current interface language <b>$1</b> is not supported by Special:Allmessages at this site.',
'allmessagesnotsupportedDB' => "'''wgUseDatabaseMessages''' бабы өшірілген себебінен '''{{ns:special}}:AllMessages''' сипаты сүемелденбейді.",
'allmessagesfilter'         => 'Хабарды атауы бойынша сүзгілеу:',
'allmessagesmodified'       => 'Тек өзгертілгенді көрсет',

# Thumbnails
'thumbnail-more'  => 'Үлкейту',
'missingimage'    => '<b>Жоғалған сурет </b><br /><i>$1</i>',
'filemissing'     => 'Жоғалған файл',
'thumbnail_error' => 'Нобай құру қатесі: $1',

# Special:Import
'import'                     => 'Беттерді сырттан алу',
'importinterwiki'            => 'Уики-тасымалдап сырттан алу',
'import-interwiki-text'      => 'Сырттан алатын уики жобасын және бет атауын тандаңыз.
Нұсқа күн-айы және өңдеуші аттары сақталады.
Барлық уики-тасымалдап сырттан алу әрекеттер [[{{ns:special}}:Log/import|сырттан алу журналына]] жазылып алынады.',
'import-interwiki-history'   => 'Осы беттің барлық тарихи нұсқаларын көшіру',
'import-interwiki-submit'    => 'Сырттан алу',
'import-interwiki-namespace' => 'Мына есім аясына беттерді тасымалдау:',
'importtext'                 => 'Қайнар уикиден «Special:Export» қуралын қолданып, файлды сыртқа беріңіз, дискіңізге сақтаңыз, сосын мында қотарыңыз.',
'importstart'                => 'Беттерді сырттан алуы…',
'import-revision-count'      => '$1 нұсқа',
'importnopages'              => 'Сырттан алынатын беттер жоқ.',
'importfailed'               => 'Сырттан алу сәтсіз бітті: $1',
'importunknownsource'        => 'Cырттан алу қайнар түрі танымалсыз',
'importcantopen'             => 'Сырттан алу файлы ашылмайды',
'importbadinterwiki'         => 'Жарамсыз уики-аралық сілтеме',
'importnotext'               => 'Босты, не мәтіні жоқ',
'importsuccess'              => 'Сырттан алу сәтті аяқталды!',
'importhistoryconflict'      => 'Тарихының егес нұсқалары бар (бұл бетті алдында сырттан алынған сияқты)',
'importnosources'            => 'Ешқандай уики-тасымалдап сырттан алу қайнары белгіленмеген, және тарихын тікелей қотаруы өшірілген.',
'importnofile'               => 'Сырттан алынатын файл қотарылған жоқ.',
'importuploaderror'          => 'Сырттан алу файлдың қотаруы сәтсіз бітті; осы файл мөлшері рұқсат етілген мөлшерден асуы мүмкін.',

# Import log
'importlogpage'                    => 'Сырттан алу журналы',
'importlogpagetext'                => 'Басқа уикилерден өңдеу тарихымен бірге беттерді әкімшілік ретінде сырттан алу.',
'import-logentry-upload'           => 'файл қотаруымен сырттан «[[$1]]» беті алынды',
'import-logentry-upload-detail'    => '$1 нұсқа',
'import-logentry-interwiki'        => 'уики-тасымалданған $1',
'import-logentry-interwiki-detail' => '$2 дегеннен $1 нұсқа',

# Keyboard access keys for power users
'accesskey-search'                  => 'f',
'accesskey-minoredit'               => 'i',
'accesskey-save'                    => 's',
'accesskey-preview'                 => 'p',
'accesskey-diff'                    => 'v',
'accesskey-compareselectedversions' => 'v',
'accesskey-watch'                   => 'w',

# Tooltip help for some actions, most are in Monobook.js
'tooltip-search'                  => '{{SITENAME}} жобасынан іздестіру [alt-f]',
'tooltip-minoredit'               => 'Осыны шағын түзету деп белгілеу [alt-i]',
'tooltip-save'                    => 'Түзетуіңізді сақтау [alt-s]',
'tooltip-preview'                 => 'Сақтаудың алдынан түзетуіңізді қарап шығыңыз! [alt-p]',
'tooltip-diff'                    => 'Мәтінге қандай өзгерістерді жасағаныңызды қарау. [alt-v]',
'tooltip-compareselectedversions' => 'Беттің екі нұсқасының айырмасын қарау. [alt-v]',
'tooltip-watch'                   => 'Бұл бетті бақылау тізіміңізге үстеу [alt-w]',

# Stylesheets
'common.css'   => '/** Мындағы CSS әмірлері барлық безендіру мәнеріндерде қолданылады */',
'monobook.css' => '/* Мындағы CSS әмірлері «Дара кітап» безендіру мәнерін пайдаланушыларға әсер етеді */',

# Metadata
'nodublincore'      => 'Осы серверге «Dublin Core RDF» мета-деректері өшірілген.',
'nocreativecommons' => 'Осы серверге «Creative Commons RDF» мета-деректері өшірілген.',
'notacceptable'     => 'Осы уики сервері сіздің «пайдаланушы әрекеткіші» оқи алатын пішімі бар деректерді жібере алмайды.',

# Attribution
'anonymous'        => '{{SITENAME}} тіркелгісіз пайдаланушы(лар)',
'siteuser'         => '{{SITENAME}} қатысушы $1',
'lastmodifiedatby' => 'Бұл бетті $3 қатысушы соңғы өзгерткен кезі: $2, $1.', # $1 date, $2 time, $3 user
'and'              => 'және',
'othercontribs'    => 'Шығарма негізін $1 жазған.',
'others'           => 'басқалар',
'siteusers'        => '{{SITENAME}} қатысушы(лар) $1',
'creditspage'      => 'Бетті жазғандар',
'nocredits'        => 'Бұл бетті жазғандар туралы ақпарат жоқ.',

# Spam protection
'spamprotectiontitle'    => '«Спам»-нан қорғайтын сүзгі',
'spamprotectiontext'     => 'Бұл беттің сақтауын «спам» сүзгісі бұғаттады. Бұның себебі сыртқы торап сілтемесінен болуы мүмкін.',
'spamprotectionmatch'    => 'Келесі «спам» мәтіні сүзгіленген: $1',
'subcategorycount'       => 'Бұл санатта {{PLURAL:$1|бір|$1}} төменгі санат бар.',
'categoryarticlecount'   => 'Бұл санатта {{PLURAL:$1|бір|$1}} бет бар.',
'category-media-count'   => 'Бұл санатта {{PLURAL:$1|бір|$1}} файл бар.',
'listingcontinuesabbrev' => ' (жалғ.)',
'spambot_username'       => 'MediaWiki spam cleanup',
'spam_reverting'         => '$1 дегенге сілтемесі жоқ соңғы нұсқасына қайтарылды',
'spam_blanking'          => '$1 дегенге сілтемесі бар барлық нұсқалар тазартылды',

# Info page
'infosubtitle'   => 'Бет туралы ақпарат',
'numedits'       => 'Түзету саны (негізгі беті): $1',
'numtalkedits'   => 'Түзету саны (талқылау беті): $1',
'numwatchers'    => 'Бақылаушы саны: $1',
'numauthors'     => 'Әртүрлі ауторлар саны (негізгі беті): $1',
'numtalkauthors' => 'Әртүрлі аутор саны (талқылау беті): $1',

# Math options
'mw_math_png'    => 'Әрқашан PNG түрімен көрсет',
'mw_math_simple' => 'Кәдімгі болса HTML пішімімен, басқаша PNG түрімен',
'mw_math_html'   => 'Ықтимал болса HTML пішімімен, басқаша PNG түрімен',
'mw_math_source' => 'TeX пішімінде қалдыру (мәтіндік шолғыштарына)',
'mw_math_modern' => 'Осы заманның шолғыштарына ұсынылған',
'mw_math_mathml' => 'Ықтимал болса MathML пшімімен (сынақ түрінде)',

# Patrolling
'markaspatrolleddiff'        => 'Күзетте деп белгілеу',
'markaspatrolledtext'        => 'Осы бетті күзетуде деп белгілеу',
'markedaspatrolled'          => 'Күзетте деп белгіленді',
'markedaspatrolledtext'      => 'Талғанған нұсқа күзетте деп белгіленді.',
'rcpatroldisabled'           => 'Жуықтағы өзгерістер Күзеті өшірілген',
'rcpatroldisabledtext'       => 'Жуықтағы өзгерістер Күзеті қасиеті ағымда өшірілген.',
'markedaspatrollederror'     => 'Күзетте деп белгіленбейді',
'markedaspatrollederrortext' => 'Күзетте деп белгілеу үшін нұсқасын енгізіңіз.',

# Monobook.js: tooltips and access keys for monobook
'monobook.js' => "/* tooltips and access keys */
var ta = new Object();
ta['pt-userpage'] = new Array('.','Жеке бетім');
ta['pt-anonuserpage'] = new Array('.','Осы IP жайдың жеке беті');
ta['pt-mytalk'] = new Array('n','Талқылау бетім');
ta['pt-anontalk'] = new Array('n','Осы IP жай түзетулерін талқылау');
ta['pt-preferences'] = new Array('','Баптауым');
ta['pt-watchlist'] = new Array('l','Өзгерістерін бақылап тұрған беттер тізімім.');
ta['pt-mycontris'] = new Array('y','Үлестерімдің тізімі');
ta['pt-login'] = new Array('o','Кіруіңізді ұсынамыз, ол міндетті емес.');
ta['pt-anonlogin'] = new Array('o','Кіруіңізді ұсынамыз, бірақ, ол міндетті емес.');
ta['pt-logout'] = new Array('','Шығу');
ta['ca-talk'] = new Array('t','Мағлұмат бетті талқылау');
ta['ca-edit'] = new Array('e','Бұл бетті өңдей аласыз. Сақтаудың алдында «Қарап шығу» түймесін нұқыңыз.');
ta['ca-addsection'] = new Array('+','Бұл талқылау бетінде жаңа тарау бастау.');
ta['ca-viewsource'] = new Array('e','Бұл бет қорғалған, бірақ, қайнарын қарауға болады.');
ta['ca-history'] = new Array('h','Бұл беттін жуықтағы нұсқалары.');
ta['ca-protect'] = new Array('=','Бұл бетті қорғау');
ta['ca-unprotect'] = new Array('=','Бұл бетті қорғамау');
ta['ca-delete'] = new Array('d','Бұл бетті жою');
ta['ca-undelete'] = new Array('d','Бұл беттің жоюдың алдындағы болған түзетулерін қайтару');
ta['ca-move'] = new Array('m','Бұл бетті жылжыту');
ta['ca-nomove'] = new Array('m','Бұл бетті жылжытуға рұқсатыңыз жоқ');
ta['ca-watch'] = new Array('w','Бұл бетті бақылау тізіміңізге үстеу');
ta['ca-unwatch'] = new Array('w','Бұл бетті бақылау тізіміңізден аластату');
ta['ca-varlang-0'] = new Array('','Кирилл жазуы');
ta['ca-varlang-1'] = new Array('','Латын жазуы');
ta['ca-varlang-2'] = new Array('','Араб жазуы');
ta['search'] = new Array('f','Осы уикиден іздеу');
ta['p-logo'] = new Array('','Басты бетке');
ta['n-mainpage'] = new Array('z','Басты бетке барып кетіңіз');
ta['n-portal'] = new Array('','Жоба туралы, не істеуіңізге болатын, қайдан табуға болатын туралы');
ta['n-currentevents'] = new Array('','Ағымдағы оқиғаларға қатысты ақпарат');
ta['n-recentchanges'] = new Array('r','Осы уикидегі жуықтағы өзгерістер тізімі.');
ta['n-randompage'] = new Array('x','Кездейсоқ бетті жүктеу');
ta['n-help'] = new Array('','Анықтама табу орны.');
ta['n-sitesupport'] = new Array('','Бізге жәрдем етіңіз');
ta['t-whatlinkshere'] = new Array('j','Мында сілтеген барлық беттердің тізімі');
ta['t-recentchangeslinked'] = new Array('k','Мыннан сілтенген беттердің жуықтағы өзгерістері');
ta['feed-rss'] = new Array('','Бұл беттің RSS арнасы');
ta['feed-atom'] = new Array('','Бұл беттің Atom арнасы');
ta['t-contributions'] = new Array('','Осы қатысушының үлес тізімін қарау');
ta['t-emailuser'] = new Array('','Осы қатысушыға email жіберу');
ta['t-upload'] = new Array('u','Сурет не медиа файлдарын қотару');
ta['t-specialpages'] = new Array('q','Барлық арнайы беттер тізімі');
ta['t-print'] = new Array('','Осы беттің басып шығару нұсқасы');
ta['t-permalink'] = new Array('','Беттің осы нұсқасының тұрақты сілтемесі');
ta['ca-nstab-main'] = new Array('c','Мағлұмат бетін қарау');
ta['ca-nstab-user'] = new Array('c','Қатысушы бетін қарау');
ta['ca-nstab-media'] = new Array('c','Таспа бетін қарау');
ta['ca-nstab-special'] = new Array('','Бұл арнайы бет, беттің өзі өңделінбейді.');
ta['ca-nstab-project'] = new Array('a','Жоба бетін қарау');
ta['ca-nstab-image'] = new Array('c','Сурет бетін қарау');
ta['ca-nstab-mediawiki'] = new Array('c','Жүйе хабарын қарау');
ta['ca-nstab-template'] = new Array('c','Үлгіні қарау');
ta['ca-nstab-help'] = new Array('c','Анықтыма бетін қарау');
ta['ca-nstab-category'] = new Array('c','Санат бетін қарау');",

# Common.js: contains nothing but a placeholder comment
'common.js' => '/* Мындағы кез келген JavaScript әмірлері әрқайсы бет жүктелгенде барлық пайдаланушыларға жүктеледі. */

// BEGIN workaround for RTL
if (wgUserLanguage == "kk-cn"){
  document.direction="rtl";
  document.write(\'<style type="text/css">html {direction: rtl;}</style>\');
  document.write(\'<link rel="stylesheet" type="text/css" href="\'+stylepath+\'/common/common_rtl.css">\');
  document.write(\'<link rel="stylesheet" type="text/css" href="\'+stylepath+\'/\'+skin+\'/rtl.css">\');
}
// END workaround for RTL',

# Image deletion
'deletedrevision' => 'Мына ескі нұсқасын жойды: $1.',

# Browsing diffs
'previousdiff' => '← Алдыңғымен айырмасы',
'nextdiff'     => 'Келесімен айырмасы →',

'imagemaxsize' => 'Сурет түйіндеме бетіндегі суреттің мөлшерін шектеуі:',
'thumbsize'    => 'Нобай мөлшері:',
'showbigimage' => 'Жоғары ажыратылымды ($1×$2, $3 кБ) нұсқасын жүктеу',

'newimages'    => 'Ең жаңа файлдар қоймасы',
'showhidebots' => '(боттарды $1)',
'noimages'     => 'Көретін ештеңе жоқ.',

# Variants for Kazakh language
'variantname-kk-tr' => 'Latın',
'variantname-kk-kz' => 'Кирил',
'variantname-kk-cn' => 'توتە',
'variantname-kk'    => 'disable',

# Labels for User: and Title: on Special:Log pages
'specialloguserlabel'  => 'Қатысушы:',
'speciallogtitlelabel' => 'Атау:',

'passwordtooshort' => 'Құпия сөзіңіз тым қысқа. Ең кемінде $1 әріп болуы қажет.',

# Media Warning
'mediawarning' => "'''Назар салыңыз''': Бұл файл түрінде қаскүнемді әмірдің бар болуы ықтимал; файлды жегіп жүйеңізге зиян келтіруіңіз мүмкін.<hr />",

'fileinfo' => '$1 кБ, MIME түрі: <code>$2</code>',

# Metadata
'metadata'          => 'Мета-деректері',
'metadata-help'     => 'Осы файлда қосымша ақпарат бар. Бәлкім, осы ақпарат файлды жасап шығару, не сандылау үшін пайдаланған сандық камера, не мәтіналғырдан алынған. Егер осы файл негізгі күйінен өзгертілген болса, кейбір ежелелері өзгертілген фотосуретке лайық болмас.',
'metadata-expand'   => 'Егжей-тегжейін көрсет',
'metadata-collapse' => 'Егжей-тегжейін жасыр',
'metadata-fields'   => 'Осы хабарда тізімделген EXIF мета-дерек аумақтары,
сурет беті көрсету кезінде мета-дерек кесте жасырылығанда кірістірледі.
Басқасы әдепкіден жасырылады.
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* focallength',

# EXIF tags
'exif-imagewidth'                  => 'Ені',
'exif-imagelength'                 => 'Биіктігі',
'exif-bitspersample'               => 'Құраш сайын бит саны',
'exif-compression'                 => 'Қысым сұлбасы',
'exif-photometricinterpretation'   => 'Пиксел қиысуы',
'exif-orientation'                 => 'Мегзеуі',
'exif-samplesperpixel'             => 'Құраш саны',
'exif-planarconfiguration'         => 'Дерек реттеуі',
'exif-ycbcrsubsampling'            => 'Y құрашының C құрашына жарнақтауы',
'exif-ycbcrpositioning'            => 'Y құрашы және C құрашы мекендеуі',
'exif-xresolution'                 => 'Дерелей ажыратылымдығы',
'exif-yresolution'                 => 'Тірелей ажыратылымдығы',
'exif-resolutionunit'              => 'X және Y ажыратылымдықтарығының өлшемі',
'exif-stripoffsets'                => 'Сурет дереректерінің жайғасуы',
'exif-rowsperstrip'                => 'Белдік сайын жол саны',
'exif-stripbytecounts'             => 'Қысымдалған белдік сайын байт саны',
'exif-jpeginterchangeformat'       => 'JPEG SOI дегеннен ығысуы',
'exif-jpeginterchangeformatlength' => 'JPEG деректерінің байт саны',
'exif-transferfunction'            => 'Тасымалдау функциясы',
'exif-whitepoint'                  => 'Ақ нүкте түстілігі',
'exif-primarychromaticities'       => 'Алғы шептегі түстіліктері',
'exif-ycbcrcoefficients'           => 'Түс аясын тасымалдау матрицалық еселіктері',
'exif-referenceblackwhite'         => 'Қара және ақ анықтауыш қос колемдері',
'exif-datetime'                    => 'Файлдың өзгертілген күн-айы',
'exif-imagedescription'            => 'Сурет атауы',
'exif-make'                        => 'Камера өндірушісі',
'exif-model'                       => 'Камера үлгісі',
'exif-software'                    => 'Қолданылған бағдарлама',
'exif-artist'                      => 'Жығармашысы',
'exif-copyright'                   => 'Жығармашылық құқықтар иесі',
'exif-exifversion'                 => 'Exif нұсқасы',
'exif-flashpixversion'             => 'Сүйемделінген Flashpix нұсқасы',
'exif-colorspace'                  => 'Түс аясы',
'exif-componentsconfiguration'     => 'Әрқайсы құраш мәні',
'exif-compressedbitsperpixel'      => 'Сурет қысымдау тәртібі',
'exif-pixelydimension'             => 'Суреттің жарамды ені',
'exif-pixelxdimension'             => 'Суреттің жарамды биіктігі',
'exif-makernote'                   => 'Өндіруші ескертпелері',
'exif-usercomment'                 => 'Пайдаланушы мәндемелері',
'exif-relatedsoundfile'            => 'Қатысты дыбыс файлы',
'exif-datetimeoriginal'            => 'Жасалған кезі',
'exif-datetimedigitized'           => 'Сандықтау кезі',
'exif-subsectime'                  => 'Жасалған кезінің секунд бөлшектері',
'exif-subsectimeoriginal'          => 'Түпнұсқа кезінің секунд бөлшектері',
'exif-subsectimedigitized'         => 'Сандықтау кезінің секунд бөлшектері',
'exif-exposuretime'                => 'Ұсталым уақыты',
'exif-exposuretime-format'         => '$1 с ($2)',
'exif-fnumber'                     => 'Саңылау мөлшері',
'exif-fnumber-format'              => 'f/$1',
'exif-exposureprogram'             => 'Ұсталым бағдарламасы',
'exif-spectralsensitivity'         => 'Спектр бойынша сезгіштігі',
'exif-isospeedratings'             => 'ISO жылдамдық жарнақтауы (жарық сезгіштігі)',
'exif-oecf'                        => 'Оптоелектронды түрлету ықпалы',
'exif-shutterspeedvalue'           => 'Жапқыш жылдамдылығы',
'exif-aperturevalue'               => 'Саңылаулық',
'exif-brightnessvalue'             => 'Ашықтық',
'exif-exposurebiasvalue'           => 'Ұсталым өтемі',
'exif-maxaperturevalue'            => 'Барынша саңылау ашуы',
'exif-subjectdistance'             => 'Нысана қашықтығы',
'exif-meteringmode'                => 'Өлшеу тәртібі',
'exif-lightsource'                 => 'Жарық көзі',
'exif-flash'                       => 'Жарқылдағыш',
'exif-focallength'                 => 'Шоғырлау алшақтығы',
'exif-focallength-format'          => '$1 mm',
'exif-subjectarea'                 => 'Нысана ауқымы',
'exif-flashenergy'                 => 'Жарқылдағыш қарқыны',
'exif-spatialfrequencyresponse'    => 'Кеңістік-жиілік әсершілігі',
'exif-focalplanexresolution'       => 'Х бойынша шоғырлау жайпақтықтың ажыратылымдығы',
'exif-focalplaneyresolution'       => 'Y бойынша шоғырлау жайпақтықтың ажыратылымдығы',
'exif-focalplaneresolutionunit'    => 'Шоғырлау жайпақтықтың ажыратылымдық өлшемі',
'exif-subjectlocation'             => 'Нысана мекендеуі',
'exif-exposureindex'               => 'Ұсталым айқындауы',
'exif-sensingmethod'               => 'Сенсордің өлшеу әдісі',
'exif-filesource'                  => 'Файл қайнары',
'exif-scenetype'                   => 'Сахна түрі',
'exif-cfapattern'                  => 'CFA сүзгі кейіпі',
'exif-customrendered'              => 'Қосымша сурет өңдетуі',
'exif-exposuremode'                => 'Ұсталым тәртібі',
'exif-whitebalance'                => 'Ақ түсінің тендестігі',
'exif-digitalzoomratio'            => 'Сандық ауқымдау жарнақтауы',
'exif-focallengthin35mmfilm'       => '35 mm таспасының шоғырлау алшақтығы',
'exif-scenecapturetype'            => 'Түсірген сахна түрі',
'exif-gaincontrol'                 => 'Сахнаны меңгеру',
'exif-contrast'                    => 'Қарама-қарсылық',
'exif-saturation'                  => 'Қанықтық',
'exif-sharpness'                   => 'Айқындық',
'exif-devicesettingdescription'    => 'Жабдық баптау сипаттары',
'exif-subjectdistancerange'        => 'Сахна қашықтығының көлемі',
'exif-imageuniqueid'               => 'Суреттің бірегей нөмірі (ID)',
'exif-gpsversionid'                => 'GPS белгішесінің нұсқасы',
'exif-gpslatituderef'              => 'Солтүстік немесе Оңтүстік бойлығы',
'exif-gpslatitude'                 => 'Бойлығы',
'exif-gpslongituderef'             => 'Шығыс немесе Батыс ендігі',
'exif-gpslongitude'                => 'Ендігі',
'exif-gpsaltituderef'              => 'Биіктік көрсетуі',
'exif-gpsaltitude'                 => 'Биіктік',
'exif-gpstimestamp'                => 'GPS уақыты (атом сағаты)',
'exif-gpssatellites'               => 'Өлшеуге пйдаланылған Жер серіктері',
'exif-gpsstatus'                   => 'Қабылдағыш күйі',
'exif-gpsmeasuremode'              => 'Өлшеу тәртібі',
'exif-gpsdop'                      => 'Өлшеу дәлдігі',
'exif-gpsspeedref'                 => 'Жылдамдылық өлшемі',
'exif-gpsspeed'                    => 'GPS қабылдағыштың жылдамдылығы',
'exif-gpstrackref'                 => 'Қозғалыс бағытын көрсетуі',
'exif-gpstrack'                    => 'Қозғалыс бағыты',
'exif-gpsimgdirectionref'          => 'Сурет бағытын көрсетуі',
'exif-gpsimgdirection'             => 'Сурет бағыты',
'exif-gpsmapdatum'                 => 'Пайдаланылған геодезиялық түсірме деректері',
'exif-gpsdestlatituderef'          => 'Нысана бойлығын көрсетуі',
'exif-gpsdestlatitude'             => 'Нысана бойлығы',
'exif-gpsdestlongituderef'         => 'Нысана ендігін көрсетуі',
'exif-gpsdestlongitude'            => 'Нысана ендігі',
'exif-gpsdestbearingref'           => 'Нысана азимутын көрсетуі',
'exif-gpsdestbearing'              => 'Нысана азимуты',
'exif-gpsdestdistanceref'          => 'Нысана қашықтығын көрсетуі',
'exif-gpsdestdistance'             => 'Нысана қашықтығы',
'exif-gpsprocessingmethod'         => 'GPS өңдету әдісінің атауы',
'exif-gpsareainformation'          => 'GPS аумағының атауы',
'exif-gpsdatestamp'                => 'GPS күн-айы',
'exif-gpsdifferential'             => 'GPS сараланған түзету',

# EXIF attributes
'exif-compression-1' => 'Ұлғайтылған',
'exif-compression-6' => 'JPEG',

'exif-photometricinterpretation-2' => 'RGB',
'exif-photometricinterpretation-6' => 'YCbCr',

'exif-orientation-1' => 'Қалыпты', # 0th row: top; 0th column: left
'exif-orientation-2' => 'Дерелей шағылысқан', # 0th row: top; 0th column: right
'exif-orientation-3' => '180° бұрышқа айналған', # 0th row: bottom; 0th column: right
'exif-orientation-4' => 'Тірелей шағылысқан', # 0th row: bottom; 0th column: left
'exif-orientation-5' => 'Сағат тілшесіне қарсы 90° бұрышқа айналған және тірелей шағылысқан', # 0th row: left; 0th column: top
'exif-orientation-6' => 'Сағат тілше бойынша 90° бұрышқа айналған', # 0th row: right; 0th column: top
'exif-orientation-7' => 'Сағат тілше бойынша 90° бұрышқа айналған және тірелей шағылысқан', # 0th row: right; 0th column: bottom
'exif-orientation-8' => 'Сағат тілшесіне қарсы 90° бұрышқа айналған', # 0th row: left; 0th column: bottom

'exif-planarconfiguration-1' => 'талпақ пішім',
'exif-planarconfiguration-2' => 'тайпақ пішім',

'exif-xyresolution-i' => '$1 dpi',
'exif-xyresolution-c' => '$1 dpc',

'exif-colorspace-1'      => 'sRGB',
'exif-colorspace-ffff.h' => 'FFFF.H',

'exif-componentsconfiguration-0' => 'бар болмады',
'exif-componentsconfiguration-1' => 'Y',
'exif-componentsconfiguration-2' => 'Cb',
'exif-componentsconfiguration-3' => 'Cr',
'exif-componentsconfiguration-4' => 'R',
'exif-componentsconfiguration-5' => 'G',
'exif-componentsconfiguration-6' => 'B',

'exif-exposureprogram-0' => 'Анықталмаған',
'exif-exposureprogram-1' => 'Қолмен',
'exif-exposureprogram-2' => 'Бағдарламалы әдіс (қалыпты)',
'exif-exposureprogram-3' => 'Саңылау басыңқылығы',
'exif-exposureprogram-4' => 'Ысырма басыңқылығы',
'exif-exposureprogram-5' => 'Өнер бағдарламасы (анықтық терендігіне санасқан)',
'exif-exposureprogram-6' => 'Қимыл бағдарламасы (жапқыш шапшандылығына санасқан)',
'exif-exposureprogram-7' => 'Тірелей әдісі (арты шоғырлаусыз таяу түсірмелер)',
'exif-exposureprogram-8' => 'Дерелей әдісі (арты шоғырланған дерелей түсірмелер)',

'exif-subjectdistance-value' => '$1 m',

'exif-meteringmode-0'   => 'Белгісіз',
'exif-meteringmode-1'   => 'Біркелкі',
'exif-meteringmode-2'   => 'Бұлдыр дақ',
'exif-meteringmode-3'   => 'БірДақты',
'exif-meteringmode-4'   => 'КөпДақты',
'exif-meteringmode-5'   => 'Өрнекті',
'exif-meteringmode-6'   => 'Жыртынды',
'exif-meteringmode-255' => 'Басқа',

'exif-lightsource-0'   => 'Белгісіз',
'exif-lightsource-1'   => 'Күн жарығы',
'exif-lightsource-2'   => 'Күнжарықты шам',
'exif-lightsource-3'   => 'Қыздырғышты шам',
'exif-lightsource-4'   => 'Жарқылдағыш',
'exif-lightsource-9'   => 'Ашық күн',
'exif-lightsource-10'  => 'Бұлынғыр күн',
'exif-lightsource-11'  => 'Көленкелі',
'exif-lightsource-12'  => 'Күнжарықты шам (D 5700–7100 K)',
'exif-lightsource-13'  => 'Күнжарықты шам (N 4600–5400 K)',
'exif-lightsource-14'  => 'Күнжарықты шам (W 3900–4500 K)',
'exif-lightsource-15'  => 'Күнжарықты шам (WW 3200–3700 K)',
'exif-lightsource-17'  => 'Қалыпты жарық қайнары A',
'exif-lightsource-18'  => 'Қалыпты жарық қайнары B',
'exif-lightsource-19'  => 'Қалыпты жарық қайнары C',
'exif-lightsource-20'  => 'D55',
'exif-lightsource-21'  => 'D65',
'exif-lightsource-22'  => 'D75',
'exif-lightsource-23'  => 'D50',
'exif-lightsource-24'  => 'Студиялық ISO күнжарықты шам',
'exif-lightsource-255' => 'Басқа жарық қайнары',

'exif-focalplaneresolutionunit-2' => 'дюйм',

'exif-sensingmethod-1' => 'Анықталмаған',
'exif-sensingmethod-2' => '1-чипті аумақты түссезгіш',
'exif-sensingmethod-3' => '2-чипті аумақты түссезгіш',
'exif-sensingmethod-4' => '3-чипті аумақты түссезгіш',
'exif-sensingmethod-5' => 'Кезекті аумақты түссезгіш',
'exif-sensingmethod-7' => '3-сызықты түссезгіш',
'exif-sensingmethod-8' => 'Кезекті сызықты түссезгіш',

'exif-filesource-3' => 'DSC',

'exif-scenetype-1' => 'Тікелей түсірілген фотосурет',

'exif-customrendered-0' => 'Қалыпты өңдету',
'exif-customrendered-1' => 'Қосымша өңдету',

'exif-exposuremode-0' => 'Өздік ұсталымдау',
'exif-exposuremode-1' => 'Қолмен ұсталымдау',
'exif-exposuremode-2' => 'Өздік жарқылдау',

'exif-whitebalance-0' => 'Ақ түсінің өздік тендестіру',
'exif-whitebalance-1' => 'Ақ түсінің қолмен тендестіру',

'exif-scenecapturetype-0' => 'Қалыпты',
'exif-scenecapturetype-1' => 'Дерелей',
'exif-scenecapturetype-2' => 'Тірелей',
'exif-scenecapturetype-3' => 'Түнгі сахна',

'exif-gaincontrol-0' => 'Жоқ',
'exif-gaincontrol-1' => 'Төмен зораю',
'exif-gaincontrol-2' => 'Жоғары зораю',
'exif-gaincontrol-3' => 'Төмен баяулау',
'exif-gaincontrol-4' => 'Жоғары баяулау',

'exif-contrast-0' => 'Қалыпты',
'exif-contrast-1' => 'Ұян',
'exif-contrast-2' => 'Тұрпайы',

'exif-saturation-0' => 'Қалыпты',
'exif-saturation-1' => 'Төмен қанықты',
'exif-saturation-2' => 'Жоғары қанықты',

'exif-sharpness-0' => 'Қалыпты',
'exif-sharpness-1' => 'Ұян',
'exif-sharpness-2' => 'Тұрпайы',

'exif-subjectdistancerange-0' => 'Белгісіз',
'exif-subjectdistancerange-1' => 'Таяу түсірілген',
'exif-subjectdistancerange-2' => 'Жақын түсірілген',
'exif-subjectdistancerange-3' => 'Алыс түсірілген',

# Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef
'exif-gpslatitude-n' => 'Солтүстік бойлығы',
'exif-gpslatitude-s' => 'Оңтүстік бойлығы',

# Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef
'exif-gpslongitude-e' => 'Шығыс ендігі',
'exif-gpslongitude-w' => 'Батыс ендігі',

'exif-gpsstatus-a' => 'Өлшеу ұласуда',
'exif-gpsstatus-v' => 'Өлшеу өзара әрекетте',

'exif-gpsmeasuremode-2' => '2-бағыттық өлшем',
'exif-gpsmeasuremode-3' => '3-бағыттық өлшем',

# Pseudotags used for GPSSpeedRef and GPSDestDistanceRef
'exif-gpsspeed-k' => 'km/h',
'exif-gpsspeed-m' => 'mil/h',
'exif-gpsspeed-n' => 'Ж. түйін',

# Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef
'exif-gpsdirection-t' => 'Шын бағыт',
'exif-gpsdirection-m' => 'Магнитты бағыт',

# External editor support
'edit-externally'      => 'Бұл файлды сыртқы құрал/бағдарлама арқылы өңдеу',
'edit-externally-help' => 'Көбірек ақпарат үшін [http://meta.wikimedia.org/wiki/Help:External_editors орнату нұсқауларын] қараңыз.',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => 'барлығын',
'imagelistall'     => 'барлығы',
'watchlistall1'    => 'барлығы',
'watchlistall2'    => 'барлық',
'namespacesall'    => 'барлығы',

# E-mail address confirmation
'confirmemail'            => 'Е-пошта жайын куәландыру',
'confirmemail_noemail'    => '[[{{ns:special}}:Preferences|Қатысушы баптауыңызда]] жарамды е-пошта жайын енгізбепсіз.',
'confirmemail_text'       => 'Бұл уикиде е-пошта қасиеттерін пайдаланудың алдынан е-пошта жайыңызды
куәландыру қажет. Өзіңіздің жайыңызға куәландыру хатын жіберу үшін төмендегі түймені нұқыңыз.
Хаттың ішінде арнайы коды бар сілтеме кірістірледі;	е-пошта жайыңыздың жарамдығын куәландыру үшін
сілтемені шолғыштың мекен-жай жолағына енгізіп ашыңыз.',
'confirmemail_send'       => 'Куәландыру кодын жіберу',
'confirmemail_sent'       => 'Куәландыру Е-пошта хаты жіберілді.',
'confirmemail_sendfailed' => 'Куәландыру хаты жіберілмеді. Енгізілген жайды жарамсыз әрітеріне тексеріп шығыңыз.

Е-пошта қызметі қайтарғаны: $1',
'confirmemail_invalid'    => 'Куәландыру коды жарамсыз. Кодтың мерзімі біткен шығар.',
'confirmemail_needlogin'  => 'Е-пошта жайыңызды куәландыру үшін $1 қажет.',
'confirmemail_success'    => 'Е-пошта жайыңыз куәландырылды. Енді Уикиге кіріп жұмысқа кірісуге болады',
'confirmemail_loggedin'   => 'Е-пошта жайыңыз куәландырылды.',
'confirmemail_error'      => 'Куәландыруыңызды сақтағанда белгісіз қате болды.',
'confirmemail_subject'    => '{{SITENAME}} торабынан е-пошта жайыңызды куәландыру хаты',
'confirmemail_body'       => "Кейбіреу, мына $1 IP жайынан, өзіңіз болуы мүмкін,
{{SITENAME}} жобасындағы Е-пошта жайын қолданып «$2» тіркелгі жасапты.

Осы тіркелгі растан сіздікі екенін куәландыру үшін, және {{SITENAME}} жобасының
е-пошта қасиеттерін белсендіру үшін, мына сілтемені шолғышпен ашыңыз:

$3

Бұл сіздікі '''емес''' болса, сілтемеге ермеңіз. Куәландыру кодының
мерзімі $4 кезінде бітеді.",

# Inputbox extension, may be useful in other contexts as well
'tryexact'       => 'Дәл сәйкесін сынап көріңіз',
'searchfulltext' => 'Толық мәтінімен іздеу',
'createarticle'  => 'Бетті бастау',

# Scary transclusion
'scarytranscludedisabled' => '[Уики-ара кірегу өшірілген]',
'scarytranscludefailed'   => '[$1 бетіне үлгі өңдету сәтсіз бітті; кешіріңіз]',
'scarytranscludetoolong'  => '[URL жайы тым ұзын; кешіріңіз]',

# Trackbacks
'trackbackbox'      => '<div id="mw_trackbacks">
Бұл беттің аңыстаулары:<br />
$1
</div>',
'trackbackremove'   => '([$1 Жойылды])',
'trackbacklink'     => 'Аңыстау',
'trackbackdeleteok' => 'Аңыстау жоюы сәтті өтті.',

# Delete conflict
'deletedwhileediting' => 'Назар салыңыз:Сіз бұл беттің өңдеуін бастағанда, осы бет жойылды!',
'confirmrecreate'     => "Сіз бұл беттің өндеуін бастағанда [[{{ns:user}}:$1|$1]] ([[{{ns:user_talk}}:$1|талқылауы]]) осы бетті жойды, көрсеткен себебі:
: ''$2''
Осы бетті шынынан қайта жасауын растаңыз.",
'recreate'            => 'Қайта жасау',
'tooltip-recreate'    => 'Бұл бетті жойылуына қарамай қайта жасау',

'unit-pixel' => ' px',

# HTML dump
'redirectingto' => '[[$1]] бетіне айдатуда…',

# action=purge
'confirm_purge'        => 'Қосалқы қалтадағы осы бетін тазалаймыз ба?<br /><br />$1',
'confirm_purge_button' => 'Жарайды',

'youhavenewmessagesmulti' => '$1 дегенге жаңа хабарлар түсті',

'searchcontaining' => "Мына сөзі бар бет арасынан іздеу: ''$1''.",
'searchnamed'      => "Мына атаулы бет арасынан іздеу: ''$1''.",
'articletitles'    => "Атаулары мынадан басталған беттер: ''$1''",
'hideresults'      => 'Нәтижелерді жасыр',

# DISPLAYTITLE
'displaytitle' => '(Бұл беттің сілтемесі: [[$1]])',

'loginlanguagelabel' => 'Тіл: $1',

# Multipage image navigation
'imgmultipageprev' => '&larr; алдыңғы бетке',
'imgmultipagenext' => 'келесі бетке &rarr;',
'imgmultigo'       => 'Өту!',
'imgmultigotopre'  => 'Мына бетке өту',

# Table pager
'ascending_abbrev'         => 'өсу',
'descending_abbrev'        => 'кему',
'table_pager_next'         => 'Келесі бетке',
'table_pager_prev'         => 'Алдыңғы бетке',
'table_pager_first'        => 'Алғашқы бетке',
'table_pager_last'         => 'Соңғы бетке',
'table_pager_limit'        => 'Бет сайын $1 дана көрсет',
'table_pager_limit_submit' => 'Өту',
'table_pager_empty'        => 'Еш нәтиже жоқ',

# Auto-summaries
'autosumm-blank'   => 'Беттің барлық мағлұматын аластатты',
'autosumm-replace' => "Бетті '$1' дегенмен алмастырды",
'autoredircomment' => '[[$1]] дегенге айдады', # This should be changed to the new naming convention, but existed beforehand
'autosumm-new' => 'Жаңа бет мағлұматы: $1',
);

?>
