<?php
/**
 * Internationalization file for Semantic MediaWiki
 *
 * @file
 * @ingroup Language
 * @ingroup I18n
 * @ingroup SMWLanguage
 */

$messages = array();

/** English
 *  @author Markus Krötzsch
 */
$messages['en'] = array(
	'smw_edithelp'          => 'Editing help on properties',
	'smw_viewasrdf'         => 'RDF feed',
	'smw_finallistconjunct' => ', and', //used in "A, B, and C"
	'smw_factbox_head'      => 'Facts about $1',
	'smw_isspecprop'        => 'This property is a special property in this wiki.',
	'smw_isknowntype'       => 'This type is among the standard datatypes of this wiki.',
	'smw_isaliastype'       => 'This type is an alias for the datatype "$1".',
	'smw_isnotype'          => 'This type "$1" is not a standard datatype in the wiki, and has not been given a user definition either.',
	'smw_concept_description' => 'Description of concept "$1"', // used in the namespace "Concept:"
	'smw_no_concept_namespace'=> 'Concepts can only be defined on pages in the Concept: namespace.',
	'smw_multiple_concepts'   => 'Each concept page can have only one concept definition.',
	'smw_concept_cache_miss'  => 'The concept "$1" can not be used at the moment, since the wiki configuration requires it to be computed off-line.
If the problem does not go away after some time, ask your site administrator to make this concept available.',

	// URIs that should not be used in objects in cases where users can provide URIs
	'smw_uri_blacklist' => " http://www.w3.org/1999/02/22-rdf-syntax-ns#\n http://www.w3.org/2000/01/rdf-schema#\n http://www.w3.org/2002/07/owl#",
	'smw_baduri'        => 'URIs of the form "$1" are not allowed.',

	// Link to RSS feeds
	'smw_rss_link' => 'RSS',
	// Link to CSV feeds
	'smw_csv_link' => 'CSV',

	// Link to iCalendar and vCard files
	'smw_icalendar_link' => 'iCalendar',
	'smw_vcard_link' => 'vCard',

	// Messages and strings for inline queries
	'smw_iq_disabled'    => "Semantic queries have been disabled for this wiki.",
	'smw_iq_moreresults' => '… further results',
	'smw_iq_nojs'        => 'Use a JavaScript-enabled browser to view this element.',
	'smw_iq_altresults'  => 'Browse the result list directly.', // available link when JS is disabled

	// Messages and strings for ontology resued (import)
	'smw_unknown_importns'    => 'Import functions are not available for namespace "$1".',
	'smw_nonright_importtype' => '$1 can only be used for pages with namespace "$2".',
	'smw_wrong_importtype'    => '$1 can not be used for pages in the namespace "$2".',
	'smw_no_importelement'    => 'Element "$1" not available for import.',

	// Messages and strings for basic datatype processing
	'smw_parseerror'    => 'The given value was not understood.', // generic error, "something" went wrong
	'smw_decseparator'  => '.',
	'smw_kiloseparator' => ',',
	'smw_notitle'       => '"$1" cannot be used as a page name in this wiki.',
	'smw_wrong_namespace' => 'Only pages in namespace "$1" are allowed here.',
	'smw_unknowntype'   => 'Unsupported type "$1" defined for property.',
	'smw_manytypes'     => 'More than one type defined for property.',
	'smw_emptystring'   => 'Empty strings are not accepted.',
	'smw_maxstring'     => 'String representation $1 is too long for {{SITENAME}}.',
	'smw_notinenum'     => '"$1" is not in the list of possible values ($2) for this property.',
	'smw_noboolean'     => '"$1" is not recognized as a Boolean (true/false) value.',
	'smw_true_words'    => 'true,t,yes,y', // comma-separated synonyms for Boolean TRUE besides '1', primary value first
	'smw_false_words'   => 'false,f,no,n', // comma-separated synonyms for Boolean FALSE besides '0', primary value first
	'smw_nofloat'       => '"$1" is not a number.',
	'smw_infinite'      => 'Numbers as large as "$1" are not supported on {{SITENAME}}.',
	'smw_infinite_unit' => 'Conversion into unit "$1" resulted in a number that is too large for {{SITENAME}}.',

	// Currently unused, floats silently store units.  'smw_unexpectedunit' => 'this property supports no unit conversion',
	'smw_unsupportedprefix' => 'Prefixes for numbers ("$1") are not supported.',
	'smw_unsupportedunit'   => 'Unit conversion for unit "$1" not supported.',

	// Messages for geo coordinates parsing
	'smw_lonely_unit'     => 'No number found before the symbol "$1".', // $1 is something like °
	'smw_bad_latlong'     => 'Latitude and longitude must be given only once, and with valid coordinates.',
	'smw_abb_north'       => 'N',
	'smw_abb_east'        => 'E',
	'smw_abb_south'       => 'S',
	'smw_abb_west'        => 'W',
	'smw_label_latitude'  => 'Latitude:',
	'smw_label_longitude' => 'Longitude:',

	// some links for online maps; can be translated to different language versions of services, but need not
	'smw_service_online_maps' => " Find&nbsp;online&nbsp;maps|http://tools.wikimedia.de/~magnus/geo/geohack.php?params=\$9_\$7_\$10_\$8\n Google&nbsp;maps|http://maps.google.com/maps?ll=\$11\$9,\$12\$10&spn=0.1,0.1&t=k\n Mapquest|http://www.mapquest.com/maps/map.adp?searchtype=address&formtype=latlong&latlongtype=degrees&latdeg=\$11\$1&latmin=\$3&latsec=\$5&longdeg=\$12\$2&longmin=\$4&longsec=\$6&zoom=6",

	// Messages for datetime parsing
	'smw_nodatetime' => 'The date "$1" was not understood.',

	// Errors and notices related to queries
	'smw_toomanyclosing'    => 'There appear to be too many occurrences of "$1" in the query.',
	'smw_noclosingbrackets' => 'Some use of "<nowiki>[[</nowiki>" in your query was not closed by a matching "]]".',
	'smw_misplacedsymbol'   => 'The symbol "$1" was used in a place where it is not useful.',
	'smw_unexpectedpart'    => 'The part "$1" of the query was not understood.
Results might not be as expected.',
	'smw_emptysubquery'     => 'Some subquery has no valid condition.',
	'smw_misplacedsubquery' => 'Some subquery was used in a place where no subqueries are allowed.',
	'smw_valuesubquery'     => 'Subqueries not supported for values of property "$1".',
	'smw_overprintoutlimit' => 'The query contains too many printout requests.',
	'smw_badprintout'       => 'Some print statement in the query was misshaped.',
	'smw_badtitle'          => '"$1" is no valid page title.',
	'smw_badqueryatom'      => 'Some part "<nowiki>[[…]]</nowiki>" of the query was not understood.',
	'smw_propvalueproblem'  => 'The value of property "$1" was not understood.',
	'smw_noqueryfeature'    => 'Some query feature was not supported in this wiki and part of the query was dropped ($1).',
	'smw_noconjunctions'    => 'Conjunctions in queries are not supported in this wiki and part of the query was dropped ($1).',
	'smw_nodisjunctions'    => 'Disjunctions in queries are not supported in this wiki and part of the query was dropped ($1).',
	'smw_querytoolarge'     => 'The following query conditions could not be considered due to the wikis restrictions in query size or depth: $1.',
	'smw_devel_warning'     => 'This feature is currently under development, and might not be fully functional.
Backup your data before using it.',
	'smw_notemplategiven'   => 'Provide a value for the parameter "template" for this query format to work.',

	// Messages for pages of types and properties
	'smw_type_header'             => 'Properties of type "$1"',
	'smw_typearticlecount'        => 'Showing $1 {{PLURAL:$1|property|properties}} using this type.',
	'smw_attribute_header'        => 'Pages using the property "$1"',
	'smw_attributearticlecount'   => 'Showing $1 {{PLURAL:$1|page|pages}} using this property.',
	'smw_subproperty_header'      => 'Subproperties',
	'smw_subpropertyarticlecount' => 'This property has the following $1 {{PLURAL:$1|subproperty|subproperties}}.',
	'smw_concept_header'          => 'Pages of concept "$1"',
	'smw_conceptarticlecount'     => 'Showing $1 {{PLURAL:$1|page|pages}} belonging to that concept.',

	// Messages used in RSS feeds
	'smw_rss_description' => '$1 RSS feed',

	// Group name for SMW special pages
	'specialpages-group-smw_group' => 'Semantic MediaWiki',

	// Messages for Export RDF Special
	'exportrdf'               => 'Export pages to RDF', //name of this special
	'smw_exportrdf_docu'      => '<p>This page allows you to obtain data from a page in RDF format.
To export pages, enter the titles in the text box below, one title per line.</p>',
	'smw_exportrdf_recursive' => 'Recursively export all related pages.
Note that the result could be large!',
	'smw_exportrdf_backlinks' => 'Also export all pages that refer to the exported pages.
Generates browsable RDF.',
	'smw_exportrdf_lastdate'  => 'Do not export pages that were not changed since the given point in time.',

	// Messages for Properties Special
	'properties'             => 'Properties',
	'smw_properties_docu'    => 'The following properties are used in the wiki.',
	'smw_property_template'  => '$1 of type $2 ($3)', // <propname> of type <type> (<count>)
	'smw_propertylackspage'  => 'All properties should be described by a page!',
	'smw_propertylackstype'  => 'No type was specified for this property (assuming type $1 for now).',
	'smw_propertyhardlyused' => 'This property is hardly used within the wiki!',

	// Messages for Unused Properties Special
	'unusedproperties' => 'Unused properties',
	'smw_unusedproperties_docu' => 'The following properties exist although no other page makes use of them.',
	'smw_unusedproperty_template' => '$1 of type $2', // <propname> of type <type>

	// Messages for Wanted Properties Special
	'wantedproperties'            => 'Wanted properties',
	'smw_wantedproperties_docu'   => 'The following properties are used in the wiki but do not yet have a page for describing them.',
	'smw_wantedproperty_template' => '$1 ($2 uses)', // <propname> (<count> uses)

	// Messages for the refresh button
	'tooltip-purge' => 'Click here to refresh all queries and templates on this page',
	'smw_purge'     => 'Refresh',

	// Messages for Import Ontology Special
	'ontologyimport'              => 'Import ontology',
	'smw_oi_docu'                 => 'This special page allows to import ontologies.
The ontologies have to follow a certain format, specified at the <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">ontology import help page</a>.',
	'smw_oi_action'               => 'Import',
	'smw_oi_return'               => 'Return to <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology'           => 'No ontology supplied, or could not load ontology.',
	'smw_oi_select'               => 'Select the statements to import, and then click the import button.',
	'smw_oi_textforall'           => 'Header text to add to all imports (may be empty):',
	'smw_oi_selectall'            => 'Select or unselect all statements',
	'smw_oi_statementsabout'      => 'Statements about',
	'smw_oi_mapto'                => 'Map entity to',
	'smw_oi_comment'              => 'Add the following text:',
	'smw_oi_thisissubcategoryof'  => 'A subcategory of',
	'smw_oi_thishascategory'      => 'Is part of',
	'smw_oi_importedfromontology' => 'Import from ontology',

	// Messages for (data)Types Special
	'types'          => 'Types',
	'smw_types_docu' => 'The following is a list of all datatypes that can be assigned to properties.
Each datatype has a page where additional information can be provided.',
	'smw_typeunits'  => 'Units of measurement of type "$1": $2',

	/*Messages for SemanticStatistics Special*/
	'semanticstatistics' => 'Semantic statistics',
	'smw_semstats_text'  => 'This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>.
<b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those.
Some of the existing properties might be <a href="$6">unused properties</a>.
Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.',

	/*Messages for Flawed Attributes Special --disabled--*/
	'flawedattributes' => 'Flawed properties',
	'smw_fattributes'  => 'The pages listed below have an incorrectly defined property.
The number of incorrect properties is given in the brackets.',

	// Name of the URI Resolver Special (no content)
	'uriresolver' => 'URI resolver',
	'smw_uri_doc' => '<p>The URI resolver implements the <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>.
It takes care that humans don\'t turn into websites.</p>',

	// Messages for ask Special
	'ask'                   => 'Semantic search',
	'smw_ask_doculink'      => 'http://semantic-mediawiki.org/wiki/Help:Semantic_search',
	'smw_ask_sortby'        => 'Sort by column (optional)',
	'smw_ask_ascorder'      => 'Ascending',
	'smw_ask_descorder'     => 'Descending',
	'smw_ask_submit'        => 'Find results',
	'smw_ask_editquery'     => '[Edit query]',
	'smw_add_sortcondition' => '[Add sorting condition]',
	'smw_ask_hidequery'     => 'Hide query',
	'smw_ask_help'          => 'Querying help',
	'smw_ask_queryhead'     => 'Query',
	'smw_ask_printhead'     => 'Additional printouts (optional)',

	// Messages for the search by property special
	'searchbyproperty'      => 'Search by property',
	'smw_sbv_docu'          => '<p>Search for all pages that have a given property and value.</p>',
	'smw_sbv_noproperty'    => '<p>Enter a property.</p>',
	'smw_sbv_novalue'       => '<p>Enter a valid value for the property, or view all property values for "$1".</p>',
	'smw_sbv_displayresult' => 'A list of all pages that have property "$1" with value "$2"',
	'smw_sbv_displayresultfuzzy' => 'A list of all pages that have property "$1" with value "$2".
Since there have been only a few results, also nearby values are displayed.',
	'smw_sbv_property'      => 'Property',
	'smw_sbv_value'         => 'Value',
	'smw_sbv_submit'        => 'Find results',

	// Messages for the browsing special
	'browse'                     => 'Browse wiki',
	'smw_browselink'             => 'Browse properties',
	'smw_browse_article'         => 'Enter the name of the page to start browsing from.',
	'smw_browse_go'              => 'Go',
	'smw_browse_more'            => '…',
	'smw_browse_show_incoming'   => 'show properties that link here',
	'smw_browse_hide_incoming'   => 'hide properties that link here',
	'smw_browse_no_outgoing'     => 'This page has no properties.',
	'smw_browse_no_incoming'     => 'No properties link to this page.',
	'smw_inverse_label_default'  => '$1 of',
	'smw_inverse_label_property' => 'Inverse property label',

	// Messages for the page property special
	'pageproperty'  => 'Page property search',
	'smw_pp_docu'   => 'Search for all the fillers of a property on a given page.
Enter both a page and a property.',
	'smw_pp_from'   => 'From page',
	'smw_pp_type'   => 'Property',
	'smw_pp_submit' => 'Find results',

	// Generic messages for result navigation in all kinds of search pages
	'smw_result_prev'      => 'Previous',
	'smw_result_next'      => 'Next',
	'smw_result_results'   => 'Results',
	'smw_result_noresults' => 'No results.',
	
	// Messages for SMWAdmin
	'smwadmin' => 'Admin functions for Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Setting up storage for Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'The storage engine was set up successfully.',
	'smw_smwadmin_return' => 'Return to $1',
	'smw_smwadmin_updatestarted' => 'A new update process for refreshing the semantic data was started.
All stored data will be rebuilt or repaired where needed.
You can follow the progress of the update on this special page.',
	'smw_smwadmin_updatenotstarted' => 'There is already an update process running.
Not creating another one.',
	'smw_smwadmin_updatestopped' => 'All existing update processes have been stopped.',
	'smw_smwadmin_updatenotstopped' => 'To stop the running update process, you must activate the checkbox to indicate that you are really sure.',
	'smw_smwadmin_docu' => 'This special page helps you during installation and upgrade of <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Remember to back up valuable data before executing administrative functions.',
	'smw_smwadmin_db' => 'Database installation and upgrade',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki requires some extensions to the MediaWiki database in order to store the semantic data.
The below function ensures that your database is set up properly.
The changes made in this step do not affect the rest of the MediaWiki database, and can easily be undone if desired.
This setup function can be executed multiple times without doing any harm, but it is needed only once on installation or upgrade.',
	'smw_smwadmin_permissionswarn' => 'If the operation fails with SQL errors, the database user employed by your wiki (check your LocalSettings.php) probably does not have sufficient permissions.
Either grant this user additional persmissions to create and delete tables, temporarily enter the login of your database root in LocalSettings.php, or use the maintenance script <tt>SMW_setup.php</tt> which can use the credentials of AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Initialise or upgrade tables',
	'smw_smwadmin_announce' => 'Announce your wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki has a web service for announcing new semantic wiki sites.
This is used to maintain a list of public sites that use Semantic MediaWiki, mainly to help the <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki project</a> to get an overview of typical uses of Semantic MediaWiki.
See the Semantic MediaWiki homepage for <a href="http://semantic-mediawiki.org/wiki/Registry">further information about this service</a>.',
	'smw_smwadmin_announcebutton' => 'Press the following button to submit your wiki URL to that service.
The service will not register wikis that are not publicly accessible, and it will only store publicly accessible information.',
	'smw_smwadmin_datarefresh' => 'Data repair and upgrade',
	'smw_smwadmin_datarefreshdocu' => 'It is possible to restore all Semantic MediaWiki data based on the current contents of the wiki.
This can be useful to repair broken data or to refresh the data if the internal format has changed due to some software upgrade.
The update is executed page by page and will not be completed immediately.
The following shows if an update is in progress and allows you to start or stop updates (unless this feature was disabled by the site administrator).',
	'smw_smwadmin_datarefreshprogress' => 'An update is already in progress.</b>
It is normal that the update progresses only slowly since it only refreshes data in small chunks each time a user accesses the wiki.
To finish this update more quickly, you can invoke the MediaWiki maintenance script <tt>runJobs.php</tt> (use the option <tt>--maxjobs 1000</tt> to restrict the number of updates done in one batch).
Estimated progress of current update:',
	'smw_smwadmin_datarefreshbutton' => 'Start updating data',
	'smw_smwadmin_datarefreshstop' => 'Stop this update',
	'smw_smwadmin_datarefreshstopconfirm' => 'Yes, I am sure.',
	'smw_smwadmin_support' => 'Getting support',
	'smw_smwadmin_supportdocu' => 'Various resources might help you in case of problems:',
	'smw_smwadmin_installfile' => 'If you experience problems with your installation, start by checking the guidelines in the <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL file</a>.',
	'smw_smwadmin_smwhomepage' => 'The complete user documentation to Semantic MediaWiki is at <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Bugs can be reported to <a href="https://bugzilla.wikimedia.org/">MediaZilla</a>.',
	'smw_smwadmin_questions' => 'If you have further questions or suggestions, join the discussion on <a href="mailto:semediawiki-user@lists.sourceforge.net">semediawiki-user@lists.sourceforge.net</a>.'
);

/** Message documentation (Message documentation)
 * @author Helix84
 * @author Jon Harald Søby
 * @author Markus Krötzsch
 * @author Pietrodn
 */
$messages['qqq'] = array(
	'smw_finallistconjunct' => 'The last separator in a list. For example a list could look like this: "A, B, and C". The comma might not be appropriate in your language.

{{Identical|And}}',
	'smw_decseparator' => "This message is as a separator symbol for decimal digits in numbers, like \".\" in English 1,234.23. It is used for formatting number output '''and''' for reading user input. Therefore it should be carefully considered whether to change an existing value, since existing installations may depend on this value for their content to be read properly.

Note that spaces and space-like HTML entities are always ignored when reading numbers.",
	'smw_kiloseparator' => "This message is as a separator symbol for thousands in numbers, like \",\" in English 1,234.23. It is used for formatting number output '''and''' for reading user input. Therefore it should be carefully considered whether to change an existing value, since existing installations may depend on this value for their content to be read properly.

Note that spaces and space-like HTML entities are always ignored when reading numbers, whether or not a space symbol is used here.",
	'smw_label_latitude' => '{{Identical|Latitude}}',
	'smw_label_longitude' => '{{Identical|Longitude}}',
	'smw_subpropertyarticlecount' => '[[bugzilla:15207|Bug on Bugzilla about this message]]',
	'properties' => 'This is the title of the special page showing all properties.',
	'smw_property_template' => 'Used to display information about properties on Special:Properties. The parameters have the following meaning:
* $1: the property name
* $2: the name of the type of the property
* $3: the number of occurrences of this property in the wiki',
	'ontologyimport' => "''Ontology import'' (this message is the title of that special page) is a feature to import certain metadata files into the wiki.
This administrative function is still rather preliminary, and probably useful only to users with prior knowledge of metadata formats like RDF and OWL.
It is likely that most of those are able to speak English anyway, so the translation of all \"oi\" messages in Semantic MediaWiki has low priority.

Also note that the messages sometimes use technical terms related to the metadata standards, and that these terms may have special translations (or maybe are used in English) in any given language.",
	'smw_oi_action' => '{{Identical|Import}}',
	'smw_typeunits' => 'This message is used in the tooltip on Special:Types when a property supports custom units of measurement. The parameter $1 then is the type name, and $2 is a list of unit names.',
	'flawedattributes' => 'The "flawed properties" special is currently disabled.
The messages were kept here since some translations already existed.
This gives this message and "smw_fattributes" a very low priority for translation.',
	'smw_uri_doc' => "This message sketches the (very technical) function of this unlisted special page.
It probably does not need translation in most cases. The special page as such is used in all URIs used by Semantic MediaWiki.
When somebody resolves such a URI, the special page will redirect to the according wiki page or to the according metadata export (OWL/RDF/XML).
This is controlled by the HTTP request header. Semantic Web crawlers and browsers can thus request more metadata on a particular subject, while humans are referred to readable pages.
This method is called ''content negotiation''.",
	'smw_ask_submit' => '{{Identical|Find results}}',
	'smw_sbv_property' => '{{Identical|Property}}',
	'smw_sbv_value' => '{{Identical|Value}}',
	'smw_sbv_submit' => '{{Identical|Find results}}',
	'smw_browse_go' => '{{Identical|Go}}',
	'smw_pp_type' => '{{Identical|Property}}',
	'smw_pp_submit' => '{{Identical|Find results}}',
	'smw_result_prev' => '{{Identical|Previous}}',
	'smw_result_next' => '{{identical|Next}}',
	'smw_result_noresults' => '{{Identical|Sorry, no results}}',
);

/** Niuean (ko e vagahau Niuē)
 * @author Jose77
 */
$messages['niu'] = array(
	'smw_browse_go' => 'Fano',
);

/** Afrikaans (Afrikaans)
 * @author Arnobarnard
 * @author Naudefj
 */
$messages['af'] = array(
	'smw_finallistconjunct' => ', en',
	'smw_factbox_head' => 'Feite oor $1',
	'smw_isspecprop' => "Hierdie eienskap is 'n spesiale eienskap van hierdie wiki.",
	'smw_icalendar_link' => 'iKalender',
	'smw_parseerror' => 'Die gegewe waarde is onverstaanbaar.',
	'smw_unknowntype' => 'Onondersteunde tipe "$1" gedefinieer vir eienskap.',
	'smw_manytypes' => 'Meer as een tipe gedefinieer vir eienskap.',
	'smw_emptystring' => 'Leë stringe word nie aanvaar nie.',
	'smw_true_words' => 'waar,w,ja,j',
	'smw_false_words' => 'vals,v,nee,n',
	'smw_nofloat' => '"$1" is nie \'n nommer nie.',
	'smw_unsupportedprefix' => 'Voorvoegsels vir nommers ("$1") word nie ondersteun nie.',
	'smw_lonely_unit' => 'Geen nommer voor simbool "$1" gevind nie.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'O',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'Breedtegraad',
	'smw_label_longitude' => 'Lengtegraad',
	'smw_emptysubquery' => "'n Sub-navraag het geen geldige kondisie.",
	'smw_propertyhardlyused' => 'Hierdie eienskap word skaars gebruik in hierdie wiki!',
	'smw_unusedproperty_template' => '$1 van tipe $2',
	'smw_wantedproperty_template' => '$1 ($2 gebruike)',
	'smw_purge' => 'Verfris',
	'smw_oi_action' => 'importeer',
	'smw_oi_thisissubcategoryof' => "'n Subkategorie van",
	'smw_oi_thishascategory' => 'Is deel van',
	'types' => 'Tipes',
	'smw_ask_sortby' => 'Sorteer volgens kolom (optioneel)',
	'smw_ask_ascorder' => 'Toenemend',
	'smw_ask_descorder' => 'Afnemend',
	'smw_ask_submit' => 'Vind resultate',
	'smw_ask_editquery' => '[Wysig navraag]',
	'smw_ask_hidequery' => 'Versteek navraag',
	'smw_ask_help' => 'Navraag hulp',
	'smw_ask_queryhead' => 'Navraag',
	'smw_ask_printhead' => 'Addisionele uitdrukke (optioneel)',
	'searchbyproperty' => 'Soek volgens eienskap',
	'smw_sbv_property' => 'Eienskap',
	'smw_sbv_value' => 'Waarde',
	'smw_sbv_submit' => 'Vind resultate',
	'smw_browse_go' => 'Gaan',
	'smw_pp_from' => 'Vanaf bladsy',
	'smw_pp_type' => 'Eienskap',
	'smw_result_prev' => 'Vorige',
	'smw_result_next' => 'Volgende',
);

/** Arabic (العربية)
 * @author Mahmoud Zouari  mahmoudzouari@yahoo.fr http://www.cri.ensmp.fr
 * @author Meno25
 */
$messages['ar'] = array(
	'smw_edithelp' => 'تعديل المساعدة على الخصائص',
	'smw_viewasrdf' => 'تلقيم RDF',
	'smw_finallistconjunct' => '، و',
	'smw_factbox_head' => 'حقائق عن $1',
	'smw_isspecprop' => 'هذه الخاصية هى خاصية خاصة في هذا الويكي.',
	'smw_isknowntype' => 'هذا النوع هو من بين أنواع البيانات الموحدة من هذا الويكي.',
	'smw_isaliastype' => 'هذا النوع هو الاسم المستعار لنوع البيانات "$1".',
	'smw_isnotype' => 'هذا النوع "$1" هو ليس معيار البيانات في الويكي، ولم يعط تعريفا من قبل المستخدمين.',
	'smw_concept_description' => 'وصف المبدأ "$1"',
	'smw_no_concept_namespace' => 'المبادئ يمكن تعريفها فقط في الصفحات في نطاق Concept:',
	'smw_multiple_concepts' => 'كل صفحة مبدأ يمكن أن تحتوي على تعريف مبدأ واحد.',
	'smw_concept_cache_miss' => 'المبدأ "$1" لا يمكن استخدامه حاليا، بما أن ضبط الويكي يحتاجه إلى أن يتم حسابه خارجيا. لو أن المشكلة لم تنته بعد بعض الوقت، سل إداري موقعك ليجعل هذا المبدأ متوفرا.',
	'smw_baduri' => 'URIs من النوع "$1" غير مسموح بها.',
	'smw_rss_link' => 'آر إس إس',
	'smw_csv_link' => 'سي في إس',
	'smw_icalendar_link' => 'آي كالندر',
	'smw_vcard_link' => 'في كارد',
	'smw_iq_disabled' => 'استعلامات السيمانتيك تم تعطيلها في هذا الويكي.',
	'smw_iq_moreresults' => '… مزيد من النتائج',
	'smw_iq_nojs' => 'استخدم متصفحا يمكن جافا سكريبت لرؤية هذا العنصر.',
	'smw_iq_altresults' => 'استعرض قائمة النتائج مباشرة.',
	'smw_unknown_importns' => 'إمكانية استيراد ليست متوفرة للنطاق "$1".',
	'smw_nonright_importtype' => '$1 لا يمكن أن تستخدم إلا لصفحات مع النطاق "$2".',
	'smw_wrong_importtype' => '$1 لا يمكن استخدامها للصفحات في النطاق "$2".',
	'smw_no_importelement' => 'العنصر "$1" غير متوفر للاستيراد.',
	'smw_parseerror' => 'القيمة المعطاة لم يتم فهمها.',
	'smw_kiloseparator' => '،',
	'smw_notitle' => '"$1" لا يمكن أن تستخدم مثل هذا الاسم في صفحة ويكي.',
	'smw_wrong_namespace' => 'فقط الصفحات في النطاق "$1" مسموح بها هنا.',
	'smw_unknowntype' => 'نوع غير مدعوم "$1" لتعريف الممتلكات.',
	'smw_manytypes' => 'أكثر من نوع واحد لتعريف الخاصية.',
	'smw_emptystring' => 'السلاسل الفارغة غير مقبولة.',
	'smw_maxstring' => 'تمثيل السلسلة $1 طويل جدا ل{{SITENAME}}.',
	'smw_notinenum' => '"$1" ليس ضمن قائمة القيم الممكنة ($2) لهذه الخاصية.',
	'smw_noboolean' => '"$1" غير متعرف عليها كقيمة بووليان (صواب/خطأ).',
	'smw_true_words' => 'صحيح،ص،نعم،ن',
	'smw_false_words' => 'خطأ،خ،لا،ل',
	'smw_nofloat' => 'ليس عددا "$1".',
	'smw_infinite' => 'الأرقام الكبيرة مثل "$1" غير مدعومة في {{SITENAME}}.',
	'smw_infinite_unit' => 'التحويل إلى الوحدة "$1" نتج عنه رقم كبير جدا ل{{SITENAME}}.',
	'smw_unsupportedprefix' => 'غير مدعوم ("$1") البادئات لأرقام.',
	'smw_unsupportedunit' => 'غير مدعوم "$1" تحويل الوحدة للوحدة.',
	'smw_lonely_unit' => 'لم يتم العثور على رقم قبل الرمز "$1".',
	'smw_bad_latlong' => 'خطوط الطول والعرض يجب أن تعطى مرة واحدة فقط، وإحداثيات صحيحة.',
	'smw_abb_north' => 'شمال',
	'smw_abb_east' => 'شرق',
	'smw_abb_south' => 'جنوب',
	'smw_abb_west' => 'غرب',
	'smw_label_latitude' => 'دوائر العرض:',
	'smw_label_longitude' => 'خطوط الطول:',
	'smw_nodatetime' => 'التاريخ "$1" لم يفهم (الدعم للتواريخ مازال تجريبيا).',
	'smw_toomanyclosing' => 'يبدو أنه هناك الكثير من "$1" في الاستعلام.',
	'smw_noclosingbrackets' => '"]]" في استعلامك لم تكن مغلقة باستخدام "<nowiki>[[</nowiki>" بعض استخدام',
	'smw_misplacedsymbol' => 'الرمز "$1" تم استخدامه في مكان حيث هو ليس مفيدا.',
	'smw_unexpectedpart' => 'الجزء "$1" من الاستعلام لم يفهم.
النتائج قد لا تكون كما هو متوقع.',
	'smw_emptysubquery' => 'بعض الاستعلامات الفرعية ليس لها شرط صحيح.',
	'smw_misplacedsubquery' => 'بعض الاستعلامات الفرعية تم استخدمها في مكان غير مسموح فيه بالاستعلامات الفرعية.',
	'smw_valuesubquery' => 'الاستعلامات الفرعية غير مدعومة لقيم الخاصية "$1".',
	'smw_overprintoutlimit' => 'هذا الاستعلام يحتوي على عدد كبير جدا من طلبات الطبع.',
	'smw_badprintout' => 'بعض المطبوعات في الاستعلام لم تتشكل بصورة صحيحة.',
	'smw_badtitle' => '"$1" ليس عنوان صفحة صحيحا.',
	'smw_badqueryatom' => 'جزء ما "<nowiki>[[…]]</nowiki>" من الاستعلام لم يتم فهمه.',
	'smw_propvalueproblem' => 'قيمة الخاصية "$1" لم يتم فهمها.',
	'smw_noqueryfeature' => 'ميزة استعلام ما لم يتم دعمها في هذا الويكي وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_noconjunctions' => 'الوقوفات في الاستعلامات غير مدعومة في هذا الويكي وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_nodisjunctions' => 'المفارق في استعلامات ليست مدعومة في هذا الويكي وجزء من الاستعلام رفض $1.',
	'smw_querytoolarge' => 'شروط الاستفسار التالية لم يمكن اعتبارها نتيجة لقيود الويكي في حجم أو عمق الاستعلام: $1.',
	'smw_devel_warning' => 'هذه الخاصية حاليا قيد التطوير، وربما لا تعمل بشكل كامل.
احفظ بياناتك قبل استخدامها.',
	'smw_notemplategiven' => 'وفر قيمة للمحدد "template" لتعمل صيغة الاستعلام هذه.',
	'smw_type_header' => 'خصائص النوع "$1"',
	'smw_typearticlecount' => 'تستخدم هذا النوع {{PLURAL:$1|خاصية|خاصية}} عرض.',
	'smw_attribute_header' => 'الصفحات التي تستخدم الخاصية "$1"',
	'smw_attributearticlecount' => 'عرض $1 {{PLURAL:$1|صفحة|صفحة}} تستخدم هذه الخاصية.',
	'smw_subproperty_header' => 'خواص فرعية',
	'smw_subpropertyarticlecount' => 'هذه الخاصية لديها $1 {{PLURAL:$1|خاصية فرعية|خاصية فرعية}} تالية.',
	'smw_concept_header' => 'صفحات المبدأ "$1"',
	'smw_conceptarticlecount' => 'عرض $1 {{PLURAL:$1|صفحة|صفحة}} تنتمي إلى هذا المبدأ.',
	'smw_rss_description' => '$1 تلقيم آر إس إس',
	'specialpages-group-smw_group' => 'سيمانتيك ميدياويكي',
	'exportrdf' => 'آر دی‌ إف إلى صفحات تصدير',
	'smw_exportrdf_docu' => '<p> هذه الصفحة تتيح لك الحصول على بيانات من صفحة في شكل آر دی‌ إف.
التصدير إلى صفحات، أدخل العناوين في مربع النص أدناه، عنوان واحد لكل سطر.</p>',
	'smw_exportrdf_recursive' => 'تصدير جميع الصفحات ذات الصلة بشكل تكراري.
علما أنه يمكن أن تكون النتيجة كبيرة!',
	'smw_exportrdf_backlinks' => 'أيضا تصدير كل الصفحات التي تشير إلى الصفحات تم تصديرها.
يولد آر دي إف قابل للتصفح.',
	'smw_exportrdf_lastdate' => 'لا تصدر الصفحات التي لم تتغير منذ نقطة زمنية محددة.',
	'properties' => 'الخصائص',
	'smw_properties_docu' => 'الخصائص التالية تستخدم في الويكي.',
	'smw_property_template' => '$1 من نوع $2 ($3)',
	'smw_propertylackspage' => 'جميع الخصائص ينبغي أن توصف بصفحة!',
	'smw_propertylackstype' => 'لا نوع تم تحديده لهذه الخاصية (افتراض النوع $1 حاليا).',
	'smw_propertyhardlyused' => 'هذه الخاصية لا تكاد تستخدم داخل الويكي!',
	'unusedproperties' => 'خصائص غير مستخدمة',
	'smw_unusedproperties_docu' => 'الخصائص التالية موجودة على الرغم من أنه لا صفحة أخرى تستخدمها.',
	'smw_unusedproperty_template' => '$1 من نوع $2',
	'wantedproperties' => 'خصائص مطلوبة',
	'smw_wantedproperties_docu' => 'الخصائص التالية مستخدمة في الويكي ولكن ليس لديها حتى الآن صفحة لوصفها.',
	'smw_wantedproperty_template' => '$1 ($2 استخدام)',
	'tooltip-purge' => 'اضغط هنا لتحديث كافة الاستفسارات والقوالب على هذه الصفحة',
	'smw_purge' => 'تحديث',
	'ontologyimport' => 'استيراد أنتولوجي',
	'smw_oi_docu' => 'هذه الصفحة الخاصة تسمح باستيراد أنتولوجي.
الأنتولوجيات يجب أن تتبع صيغة معينة، محددة في <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">صفحة مساعدة استيراد الأنتولوجي</a>.',
	'smw_oi_action' => 'استيراد',
	'smw_oi_return' => 'رجوع إلى <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'لا توجد أنتولوجي، أو تعذر تحميل أنتولوجي.',
	'smw_oi_select' => 'اختر الجمل للاستيراد، وبعد ذلك انقر على زر الاستيراد.',
	'smw_oi_textforall' => 'بداية النص الذي سيضاف إلى جميع الواردات (قد تكون فارغة):',
	'smw_oi_selectall' => 'اختر أو احذف جميع الجمل',
	'smw_oi_statementsabout' => 'بيانات حول',
	'smw_oi_mapto' => 'خريطه لكيان',
	'smw_oi_comment' => 'أضف النص التالي:',
	'smw_oi_thisissubcategoryof' => 'تصنيف فرعي ل',
	'smw_oi_thishascategory' => 'هي جزء من',
	'smw_oi_importedfromontology' => 'الاستيراد من الأنتولوجيا',
	'types' => 'أنواع',
	'smw_types_docu' => 'التالي قائمة بجميع أنواع البيانات التي يمكن أن تسند إلى الخصائص.
كل نوع بيانات له صفحة حيث يمكن توفير معلومات إضافية.',
	'smw_typeunits' => 'وحدات القياس من النوع "$1": $2',
	'semanticstatistics' => 'إحصاءات سيمانتيك',
	'smw_semstats_text' => 'هذا الويكي يحتوي على <b>$1</b> قيمة خاصية لإجمالي <b>$2</b> different <a href="$3">خاصية</a>.
<b>$4</b> الخصائص لها صفة خاصة، ونوع البيانات المقصود محدد ل<b>$5</b> منها.
بعض الخصائص الموجودة ربما تكون <a href="$6">خصائص غير مستخدمة</a>.
الخصائص التي مازالت تفتقد صفحة موجودة في <a href="$7">قائمة الخصائص المطلوبة</a>.',
	'flawedattributes' => 'خصائص معيوبة',
	'smw_fattributes' => 'الصفحات المعروضة بالأسفل بها خاصية غير معرفة بشكل صحيح.
عدد الخصائص غير الصحيحة معطى في الاقواس.',
	'uriresolver' => 'محلل URI',
	'smw_uri_doc' => '<p>محلل URI ينفذ <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C على httpRange-14</a>. إنه يتأكد من أن البشر لا يتحولون إلى مواقع ويب.</p>',
	'ask' => 'بحث سيمانتيك',
	'smw_ask_sortby' => 'الترتيب حسب العمود (اختياري)',
	'smw_ask_ascorder' => 'تصاعدي',
	'smw_ask_descorder' => 'تنازلي',
	'smw_ask_submit' => 'إيجاد نتائج',
	'smw_ask_editquery' => '[عدل الاستعلام]',
	'smw_add_sortcondition' => '[أضف شرط ترتيب]',
	'smw_ask_hidequery' => 'إخفاء الاستعلام',
	'smw_ask_help' => 'مساعدة الاستعلام',
	'smw_ask_queryhead' => 'استعلام',
	'smw_ask_printhead' => 'مطبوعات إضافية (اختياري)',
	'searchbyproperty' => 'البحث حسب الخصائص',
	'smw_sbv_docu' => '<p>البحث عن كل الصفحات التي لها خصائص معينة وقيمة</p>',
	'smw_sbv_noproperty' => '<p>أدخل خاصية.</p>',
	'smw_sbv_novalue' => '<p>أدخل قيمة صحيحة للخاصية، أو انظر كل قيم الخصائص ل"$1"</p>',
	'smw_sbv_displayresult' => 'قائمة بكل الصفحات التي بها الخاصية "$1" بالقيمة "$2"',
	'smw_sbv_displayresultfuzzy' => 'قائمة بكل الصفحات التي لديها الخاصية "$1" بالقيمة "$2".
بما أنه كانت هناك فقط عدة نتائج، فالقيم المقاربة معروضة أيضا.',
	'smw_sbv_property' => 'خاصية',
	'smw_sbv_value' => 'قيمة',
	'smw_sbv_submit' => 'إيجاد نتائج',
	'browse' => 'استعرض يكي',
	'smw_browselink' => 'خصائص التصفح',
	'smw_browse_article' => 'أدخل اسم الصفحة لبدء التصفح منها.',
	'smw_browse_go' => 'اذهب',
	'smw_browse_show_incoming' => 'أظهر الخواص التي تصل هنا',
	'smw_browse_hide_incoming' => 'أخف الخواص التي تصل هنا',
	'smw_browse_no_outgoing' => 'هذه الصفحة ليس لديها خصائص.',
	'smw_browse_no_incoming' => 'لا خصائص تصل إلى هذه الصفحة.',
	'smw_inverse_label_default' => '$1 من',
	'smw_inverse_label_property' => 'علامة خاصية معكوسة',
	'pageproperty' => 'بحث خصائص الصفحة',
	'smw_pp_docu' => 'البحث عن جميع قيم خاصية على صفحة معينة.
أدخل صفحة وخاصية.',
	'smw_pp_from' => 'من صفحة',
	'smw_pp_type' => 'الخاصية',
	'smw_pp_submit' => 'إيجاد نتائج',
	'smw_result_prev' => 'السابق',
	'smw_result_next' => 'التالي',
	'smw_result_results' => 'النتائج',
	'smw_result_noresults' => 'لا توجد نتائج.',
	'smwadmin' => 'وظائف إدارية لسيمانتيك ميدياويكي',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 */
$messages['arz'] = array(
	'smw_edithelp' => 'تعديل المساعدة على الخصائص',
	'smw_viewasrdf' => 'تلقيم RDF',
	'smw_finallistconjunct' => '، و',
	'smw_factbox_head' => 'حقائق عن $1',
	'smw_isspecprop' => 'هذه الخاصية هى خاصية خاصة فى هذا الويكي.',
	'smw_isknowntype' => 'هذا النوع هو من بين أنواع البيانات الموحدة من هذا الويكي.',
	'smw_isaliastype' => 'هذا النوع هو الاسم المستعار لنوع البيانات "$1".',
	'smw_isnotype' => 'هذا النوع "$1" هو ليس معيار البيانات فى الويكي، ولم يعط تعريفا من قبل المستخدمين.',
	'smw_concept_description' => 'وصف المبدأ "$1"',
	'smw_no_concept_namespace' => 'المبادئ يمكن تعريفها فقط فى الصفحات فى نطاق Concept:',
	'smw_multiple_concepts' => 'كل صفحة مبدأ يمكن أن تحتوى على تعريف مبدأ واحد.',
	'smw_concept_cache_miss' => 'المبدأ "$1" لا يمكن استخدامه حاليا، بما أن ضبط الويكى يحتاجه إلى أن يتم حسابه خارجيا. لو أن المشكلة لم تنته بعد بعض الوقت، سل إدارى موقعك ليجعل هذا المبدأ متوفرا.',
	'smw_baduri' => 'URIs من النوع "$1" غير مسموح بها.',
	'smw_rss_link' => 'آر إس إس',
	'smw_csv_link' => 'سى فى إس',
	'smw_icalendar_link' => 'آى كالندر',
	'smw_vcard_link' => 'فى كارد',
	'smw_iq_disabled' => 'استعلامات السيمانتيك تم تعطيلها فى هذا الويكي.',
	'smw_iq_moreresults' => '… مزيد من النتائج',
	'smw_iq_nojs' => 'استخدم متصفحا يمكن جافا سكريبت لرؤية هذا العنصر.',
	'smw_iq_altresults' => 'استعرض قائمة النتائج مباشرة.',
	'smw_unknown_importns' => 'إمكانية استيراد ليست متوفرة للنطاق "$1".',
	'smw_nonright_importtype' => '$1 لا يمكن أن تستخدم إلا لصفحات مع النطاق "$2".',
	'smw_wrong_importtype' => '$1 لا يمكن استخدامها للصفحات فى النطاق "$2".',
	'smw_no_importelement' => 'العنصر "$1" غير متوفر للاستيراد.',
	'smw_parseerror' => 'القيمة المعطاة لم يتم فهمها.',
	'smw_kiloseparator' => '،',
	'smw_notitle' => '"$1" لا يمكن أن تستخدم مثل هذا الاسم فى صفحة ويكي.',
	'smw_wrong_namespace' => 'فقط الصفحات فى النطاق "$1" مسموح بها هنا.',
	'smw_unknowntype' => 'نوع غير مدعوم "$1" لتعريف الممتلكات.',
	'smw_manytypes' => 'أكثر من نوع واحد لتعريف الخاصية.',
	'smw_emptystring' => 'السلاسل الفارغة غير مقبولة.',
	'smw_maxstring' => 'تمثيل السلسلة $1 طويل جدا ل{{SITENAME}}.',
	'smw_notinenum' => '"$1" ليس ضمن قائمة القيم الممكنة ($2) لهذه الخاصية.',
	'smw_noboolean' => '"$1" غير متعرف عليها كقيمة بووليان (صواب/خطأ).',
	'smw_true_words' => 'صحيح،ص،نعم،ن',
	'smw_false_words' => 'خطأ،خ،لا،ل',
	'smw_nofloat' => 'ليس عددا "$1".',
	'smw_infinite' => 'الأرقام الكبيرة مثل "$1" غير مدعومة فى {{SITENAME}}.',
	'smw_infinite_unit' => 'التحويل إلى الوحدة "$1" نتج عنه رقم كبير جدا ل{{SITENAME}}.',
	'smw_unsupportedprefix' => 'غير مدعوم ("$1") البادئات لأرقام.',
	'smw_unsupportedunit' => 'غير مدعوم "$1" تحويل الوحدة للوحدة.',
	'smw_lonely_unit' => 'لم يتم العثور على رقم قبل الرمز "$1".',
	'smw_bad_latlong' => 'خطوط الطول والعرض يجب أن تعطى مرة واحدة فقط، وإحداثيات صحيحة.',
	'smw_abb_north' => 'شمال',
	'smw_abb_east' => 'شرق',
	'smw_abb_south' => 'جنوب',
	'smw_abb_west' => 'غرب',
	'smw_label_latitude' => 'دوائر العرض:',
	'smw_label_longitude' => 'خطوط الطول:',
	'smw_nodatetime' => 'التاريخ "$1" لم يفهم (الدعم للتواريخ مازال تجريبيا).',
	'smw_toomanyclosing' => 'يبدو أنه هناك الكثير من "$1" فى الاستعلام.',
	'smw_noclosingbrackets' => '"]]" فى استعلامك لم تكن مغلقة باستخدام "<nowiki>[[</nowiki>" بعض استخدام',
	'smw_misplacedsymbol' => 'الرمز "$1" تم استخدامه فى مكان حيث هو ليس مفيدا.',
	'smw_unexpectedpart' => 'الجزء "$1" من الاستعلام لم يفهم.
النتائج قد لا تكون كما هو متوقع.',
	'smw_emptysubquery' => 'بعض الاستعلامات الفرعية ليس لها شرط صحيح.',
	'smw_misplacedsubquery' => 'بعض الاستعلامات الفرعية تم استخدمها فى مكان غير مسموح فيه بالاستعلامات الفرعية.',
	'smw_valuesubquery' => 'الاستعلامات الفرعية غير مدعومة لقيم الخاصية "$1".',
	'smw_overprintoutlimit' => 'هذا الاستعلام يحتوى على عدد كبير جدا من طلبات الطبع.',
	'smw_badprintout' => 'بعض المطبوعات فى الاستعلام لم تتشكل بصورة صحيحة.',
	'smw_badtitle' => '"$1" ليس عنوان صفحة صحيحا.',
	'smw_badqueryatom' => 'جزء ما "<nowiki>[[…]]</nowiki>" من الاستعلام لم يتم فهمه.',
	'smw_propvalueproblem' => 'قيمة الخاصية "$1" لم يتم فهمها.',
	'smw_noqueryfeature' => 'ميزة استعلام ما لم يتم دعمها فى هذا الويكى وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_noconjunctions' => 'الوقوفات فى الاستعلامات غير مدعومة فى هذا الويكى وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_nodisjunctions' => 'المفارق فى استعلامات ليست مدعومة فى هذا الويكى وجزء من الاستعلام رفض $1.',
	'smw_querytoolarge' => 'شروط الاستفسار التالية لم يمكن اعتبارها نتيجة لقيود الويكى فى حجم أو عمق الاستعلام: $1.',
	'smw_devel_warning' => 'هذه الخاصية حاليا قيد التطوير، وربما لا تعمل بشكل كامل.
احفظ بياناتك قبل استخدامها.',
	'smw_notemplategiven' => 'وفر قيمة للمحدد "template" لتعمل صيغة الاستعلام هذه.',
	'smw_type_header' => 'خصائص النوع "$1"',
	'smw_typearticlecount' => 'تستخدم هذا النوع {{PLURAL:$1|خاصية|خاصية}} عرض.',
	'smw_attribute_header' => 'الصفحات التى تستخدم الخاصية "$1"',
	'smw_attributearticlecount' => 'عرض $1 {{PLURAL:$1|صفحة|صفحة}} تستخدم هذه الخاصية.',
	'smw_subproperty_header' => 'خواص فرعية',
	'smw_subpropertyarticlecount' => 'هذه الخاصية لديها $1 {{PLURAL:$1|خاصية فرعية|خاصية فرعية}} تالية.',
	'smw_concept_header' => 'صفحات المبدأ "$1"',
	'smw_conceptarticlecount' => 'عرض $1 {{PLURAL:$1|صفحة|صفحة}} تنتمى إلى هذا المبدأ.',
	'smw_rss_description' => '$1 تلقيم آر إس إس',
	'specialpages-group-smw_group' => 'سيمانتيك ميدياويكى',
	'exportrdf' => 'آر دی‌ إف إلى صفحات تصدير',
	'smw_exportrdf_docu' => '<p> هذه الصفحة تتيح لك الحصول على بيانات من صفحة فى شكل آر دی‌ إف.
التصدير إلى صفحات، أدخل العناوين فى مربع النص أدناه، عنوان واحد لكل سطر.</p>',
	'smw_exportrdf_recursive' => 'تصدير جميع الصفحات ذات الصلة بشكل تكراري.
علما أنه يمكن أن تكون النتيجة كبيرة!',
	'smw_exportrdf_backlinks' => 'أيضا تصدير كل الصفحات التى تشير إلى الصفحات تم تصديرها.
يولد آر دى إف قابل للتصفح.',
	'smw_exportrdf_lastdate' => 'لا تصدر الصفحات التى لم تتغير منذ نقطة زمنية محددة.',
	'properties' => 'الخصائص',
	'smw_properties_docu' => 'الخصائص التالية تستخدم فى الويكي.',
	'smw_property_template' => '$1 من نوع $2 ($3)',
	'smw_propertylackspage' => 'جميع الخصائص ينبغى أن توصف بصفحة!',
	'smw_propertylackstype' => 'لا نوع تم تحديده لهذه الخاصية (افتراض النوع $1 حاليا).',
	'smw_propertyhardlyused' => 'هذه الخاصية لا تكاد تستخدم داخل الويكي!',
	'unusedproperties' => 'خصائص غير مستخدمة',
	'smw_unusedproperties_docu' => 'الخصائص التالية موجودة على الرغم من أنه لا صفحة أخرى تستخدمها.',
	'smw_unusedproperty_template' => '$1 من نوع $2',
	'wantedproperties' => 'خصائص مطلوبة',
	'smw_wantedproperties_docu' => 'الخصائص التالية مستخدمة فى الويكى ولكن ليس لديها حتى الآن صفحة لوصفها.',
	'smw_wantedproperty_template' => '$1 ($2 استخدام)',
	'tooltip-purge' => 'اضغط هنا لتحديث كافة الاستفسارات والقوالب على هذه الصفحة',
	'smw_purge' => 'تحديث',
	'ontologyimport' => 'استيراد أنتولوجي',
	'smw_oi_docu' => 'هذه الصفحة الخاصة تسمح باستيراد أنتولوجي.
الأنتولوجيات يجب أن تتبع صيغة معينة، محددة فى <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">صفحة مساعدة استيراد الأنتولوجي</a>.',
	'smw_oi_action' => 'استيراد',
	'smw_oi_return' => 'رجوع إلى <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'لا توجد أنتولوجي، أو تعذر تحميل أنتولوجي.',
	'smw_oi_select' => 'اختر الجمل للاستيراد، وبعد ذلك انقر على زر الاستيراد.',
	'smw_oi_textforall' => 'بداية النص الذى سيضاف إلى جميع الواردات (قد تكون فارغة):',
	'smw_oi_selectall' => 'اختر أو احذف جميع الجمل',
	'smw_oi_statementsabout' => 'بيانات حول',
	'smw_oi_mapto' => 'خريطه لكيان',
	'smw_oi_comment' => 'أضف النص التالي:',
	'smw_oi_thisissubcategoryof' => 'تصنيف فرعى ل',
	'smw_oi_thishascategory' => 'هى جزء من',
	'smw_oi_importedfromontology' => 'الاستيراد من الأنتولوجيا',
	'types' => 'أنواع',
	'smw_types_docu' => 'التالى قائمة بجميع أنواع البيانات التى يمكن أن تسند إلى الخصائص.
كل نوع بيانات له صفحة حيث يمكن توفير معلومات إضافية.',
	'smw_typeunits' => 'وحدات القياس من النوع "$1": $2',
	'semanticstatistics' => 'إحصاءات سيمانتيك',
	'smw_semstats_text' => 'هذا الويكى يحتوى على <b>$1</b> قيمة خاصية لإجمالى <b>$2</b> different <a href="$3">خاصية</a>.
<b>$4</b> الخصائص لها صفة خاصة، ونوع البيانات المقصود محدد ل<b>$5</b> منها.
بعض الخصائص الموجودة ربما تكون <a href="$6">خصائص غير مستخدمة</a>.
الخصائص التى مازالت تفتقد صفحة موجودة فى <a href="$7">قائمة الخصائص المطلوبة</a>.',
	'flawedattributes' => 'خصائص معيوبة',
	'smw_fattributes' => 'الصفحات المعروضة بالأسفل بها خاصية غير معرفة بشكل صحيح.
عدد الخصائص غير الصحيحة معطى فى الاقواس.',
	'uriresolver' => 'محلل URI',
	'smw_uri_doc' => '<p>محلل URI ينفذ <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C على httpRange-14</a>. إنه يتأكد من أن البشر لا يتحولون إلى مواقع ويب.</p>',
	'ask' => 'بحث سيمانتيك',
	'smw_ask_sortby' => 'الترتيب حسب العمود (اختياري)',
	'smw_ask_ascorder' => 'تصاعدي',
	'smw_ask_descorder' => 'تنازلي',
	'smw_ask_submit' => 'إيجاد نتائج',
	'smw_ask_editquery' => '[عدل الاستعلام]',
	'smw_add_sortcondition' => '[أضف شرط ترتيب]',
	'smw_ask_hidequery' => 'إخفاء الاستعلام',
	'smw_ask_help' => 'مساعدة الاستعلام',
	'smw_ask_queryhead' => 'استعلام',
	'smw_ask_printhead' => 'مطبوعات إضافية (اختياري)',
	'searchbyproperty' => 'البحث حسب الخصائص',
	'smw_sbv_docu' => '<p>البحث عن كل الصفحات التى لها خصائص معينة وقيمة</p>',
	'smw_sbv_noproperty' => '<p>أدخل خاصية.</p>',
	'smw_sbv_novalue' => '<p>أدخل قيمة صحيحة للخاصية، أو انظر كل قيم الخصائص ل"$1"</p>',
	'smw_sbv_displayresult' => 'قائمة بكل الصفحات التى بها الخاصية "$1" بالقيمة "$2"',
	'smw_sbv_displayresultfuzzy' => 'قائمة بكل الصفحات التى لديها الخاصية "$1" بالقيمة "$2".
بما أنه كانت هناك فقط عدة نتائج، فالقيم المقاربة معروضة أيضا.',
	'smw_sbv_property' => 'خاصية',
	'smw_sbv_value' => 'قيمة',
	'smw_sbv_submit' => 'إيجاد نتائج',
	'browse' => 'استعرض يكي',
	'smw_browselink' => 'خصائص التصفح',
	'smw_browse_article' => 'أدخل اسم الصفحة لبدء التصفح منها.',
	'smw_browse_go' => 'اذهب',
	'smw_browse_show_incoming' => 'أظهر الخواص التى تصل هنا',
	'smw_browse_hide_incoming' => 'أخف الخواص التى تصل هنا',
	'smw_browse_no_outgoing' => 'هذه الصفحة ليس لديها خصائص.',
	'smw_browse_no_incoming' => 'لا خصائص تصل إلى هذه الصفحة.',
	'smw_inverse_label_default' => '$1 من',
	'smw_inverse_label_property' => 'علامة خاصية معكوسة',
	'pageproperty' => 'بحث خصائص الصفحة',
	'smw_pp_docu' => 'البحث عن جميع قيم خاصية على صفحة معينة.
أدخل صفحة وخاصية.',
	'smw_pp_from' => 'من صفحة',
	'smw_pp_type' => 'الخاصية',
	'smw_pp_submit' => 'إيجاد نتائج',
	'smw_result_prev' => 'السابق',
	'smw_result_next' => 'التالي',
	'smw_result_results' => 'النتائج',
	'smw_result_noresults' => 'لا توجد نتائج.',
	'smwadmin' => 'وظائف إدارية لسيمانتيك ميدياويكي',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'smw_viewasrdf' => 'RDF емисия',
	'smw_factbox_head' => 'Факти за $1',
	'smw_iq_disabled' => 'Съжаляваме. Семантичните заявки са изключени в това уики.',
	'smw_iq_nojs' => 'За преглед на този елемент е необходимо използването на браузър с включена поддръжка на Джаваскрипт.',
	'smw_iq_altresults' => 'Директно разглеждане на списъка с резултатите.',
	'smw_unknown_importns' => 'Функциите за внасяне са недостъпни за именно пространство „$1“.',
	'smw_nonright_importtype' => '$1 може да се използва само за страници от именното пространство „$2“.',
	'smw_wrong_importtype' => '$1 не може да се използва за страници от именното пространство „$2“.',
	'smw_no_importelement' => 'Елементът „$1“ не е наличен за внасяне.',
	'smw_notitle' => '„$1“ не може да се използва като име на страница в това уики.',
	'smw_wrong_namespace' => 'Тук са позволени само страници от именното пространство „$1“.',
	'smw_emptystring' => 'Празните низове са неприемливи.',
	'smw_nofloat' => '„$1“ не е число.',
	'smw_abb_north' => 'С',
	'smw_abb_east' => 'И',
	'smw_abb_south' => 'Ю',
	'smw_abb_west' => 'З',
	'smw_badtitle' => 'Съжаляваме, но „$1“ не е валидно заглавие на страница.',
	'smw_rss_description' => '$1 RSS емисия',
	'exportrdf' => 'Изнасяне на страниците към RDF',
	'smw_exportrdf_docu' => '<p>Тази страница позволява да се извлечат данните опт страница в RDF формат.
За изнасяне на страници, въведете заглавията в текстовата кутия по-долу (по едно заглавие на ред).</p>',
	'smw_exportrdf_recursive' => 'Рекурсивно изнасяне на всички свързани страници.
Обърнете внимание, че резултатът може да е огромен!',
	'smw_exportrdf_lastdate' => 'Без изнасяне на страници, които не са променяни от посоченото време.',
	'smw_property_template' => '$1 от типа $2 ($3)',
	'smw_unusedproperty_template' => '$1 от типа $2',
	'smw_wantedproperty_template' => '$1 ($2 използвания)',
	'smw_purge' => 'Опресняване',
	'ontologyimport' => 'Внасяне на онтология',
	'smw_oi_action' => 'Внасяне',
	'smw_oi_return' => 'Връщане към <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_comment' => 'Добавяне на следния текст:',
	'smw_oi_thisissubcategoryof' => 'Подкатегория на',
	'smw_oi_thishascategory' => 'Част е от',
	'types' => 'Типове',
	'semanticstatistics' => 'Семантични статистики',
	'ask' => 'Семантично търсене',
	'smw_ask_sortby' => 'Сортиране по колона (незадължително)',
	'smw_ask_ascorder' => 'Възходящ',
	'smw_ask_descorder' => 'Низходящ',
	'smw_ask_editquery' => '[Редактиране на заявката]',
	'smw_add_sortcondition' => '[Добавяне на условие за сортиране]',
	'smw_ask_hidequery' => 'Скриване на заявката',
	'smw_ask_queryhead' => 'Заявка',
	'smw_sbv_value' => 'Стойност',
	'smw_pp_from' => 'От страница',
	'smw_result_prev' => 'Предишни',
	'smw_result_next' => 'Следващи',
	'smw_result_results' => 'Резултати',
	'smw_result_noresults' => 'Съжаляваме, няма резултати.',
	'smwadmin' => 'Администраторски функции за Semantic MediaWiki',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'smw_browse_go' => 'Idi',
);

/** Chamorro (Chamoru)
 * @author Jatrobat
 */
$messages['ch'] = array(
	'smw_browse_go' => 'Hånao',
);

/** Czech (Česky)
 * @author Kjbenes
 * @author Matěj Grabovský
 */
$messages['cs'] = array(
	'smw_edithelp' => 'Nápověda při upravování vztahů a vlastností',
	'smw_viewasrdf' => 'RDF kanál',
	'smw_finallistconjunct' => ' a',
	'smw_factbox_head' => 'Skutečnosti o $1 &mdash; kliknutím na <span class="smwsearchicon">+</span> vyhledáte podobné stránky.',
	'smw_isspecprop' => 'Tato vlastnost je speciální vlastnost na této wiki.',
	'smw_isknowntype' => 'Tento typ patří meti standardní datové typy na této wiki.',
	'smw_isaliastype' => 'Tento typ je alias datového typu „$1“.',
	'smw_isnotype' => 'Tento typ „$1“ není standardní datový typ na této wiki a nebyl ani definován uživatelem.',
	'smw_concept_description' => 'Popis pojmu „$1”',
	'smw_no_concept_namespace' => 'Pojmy je možné definovat pouze na stránkách ve jmenném prostoru Concept:',
	'smw_multiple_concepts' => 'Každá stránka konceptu může mít jen jednu definici.',
	'smw_baduri' => 'Promiňte, URI z rozsahu „$1“ na tomto místě nejsou dostupné.',
	'smw_icalendar_link' => 'iCalendar',
	'smw_iq_disabled' => 'Promiňtě, semantické dotazy byly pro tuto wiki zakázány.',
	'smw_iq_moreresults' => '…další výsledky',
	'smw_iq_nojs' => 'Pro zobrazení tohoto prvku prosím použijte prohlížeč se zapnutým JavaScriptem.',
	'smw_iq_altresults' => 'Prohlížet přímo seznam výsledků.',
	'smw_unknown_importns' => 'Funkce importu nejsou dostupné pro jmenný prostor „$1“.',
	'smw_nonright_importtype' => '$1 je možné použít jen pro stránky ve jmenném prostoru „$2“.',
	'smw_wrong_importtype' => '$1 není možné použít pro stránky ve jmenném prostoru „$2“.',
	'smw_no_importelement' => 'Prvek „$1“ není dostupný pro import.',
	'smw_parseerror' => 'Zadaná hodnota nebyla pochopená.',
	'smw_notitle' => '„$1“ není možné použít na této wiki jako název stránky.',
	'smw_unknowntype' => 'Pro vlastnost je definován nepodporovaný typ „$1“.',
	'smw_manytypes' => 'Pro vlastnost byl definován více než jeden typ.',
	'smw_emptystring' => 'Prázdné řetězce nejsou povolené.',
	'smw_maxstring' => 'Reprezentace řetězce $1 je pro tuto wiki příliš dlouhá.',
	'smw_notinenum' => '„$1“ není v seznamu možných hodnot ($2) této vlastnosti.',
	'smw_noboolean' => '„$1“ nebylo rozpoznáno jako platná hodnota typu boolean (ano/ne).',
	'smw_nofloat' => '“$1” není číslem.',
	'smw_infinite' => 'Tak dlouhá čísla jako $1 nejsou na této stránce podporovaná.',
	'smw_infinite_unit' => 'Konverze na jednotky $1 dala jako výsledek číslo, které je pro tuto stránku příliš dlouhé.',
	'smw_unsupportedprefix' => 'Předpony pro čísla („$1“) nejsou podporované.',
	'smw_unsupportedunit' => 'Konverze pro jednotku "$1" není podporována.',
	'smw_lonely_unit' => 'Před symbolem „$1“ se nenachází číslo.',
	'smw_bad_latlong' => 'Zeměpisná šířka a délka musí být zadány jen jednou a s platnými souřadnicemi.',
	'smw_abb_north' => 'S',
	'smw_abb_east' => 'V',
	'smw_abb_south' => 'J',
	'smw_abb_west' => 'Z',
	'smw_label_latitude' => 'Zeměpisná šířka:',
	'smw_label_longitude' => 'Zeměpisná délka:',
	'smw_nodatetime' => 'Datum "$1" nedává smysl.',
	'smw_toomanyclosing' => 'Dotazovaný řetězec „$1“ má příliš mnoho výskytů.',
	'smw_noclosingbrackets' => 'Užití „<nowiki>[[</nowiki>” ve vašem dotazu nebylo ukončeno odpovídajícími „]]”.',
	'smw_misplacedsymbol' => 'Symbol „$1“ byl užitý na místě, kde nemá význam.',
	'smw_unexpectedpart' => 'Část dotazu „$1“ nedává smysl.
Výsledky pravděpodobně nesplní očekávání.',
	'smw_emptysubquery' => 'Některý poddotaz nemá platné podmínky.',
	'smw_misplacedsubquery' => 'Některý poddotaz byl použitý na místě, kde nejsou poddotazy povoleny.',
	'smw_valuesubquery' => 'Poddotazy nejsou podporovány pro hodnoty vlastnosti „$1“.',
	'smw_overprintoutlimit' => 'Obsah dotazu překračuje limity pro výpis.',
	'smw_badprintout' => 'Některý příkaz pro výpis byl v dotazu chybně utvořený.',
	'smw_badtitle' => 'Promiňte, ale „$1” není platný název stránky.',
	'smw_badqueryatom' => 'Některá část „<nowiki>[[…]]</nowiki>“ nebyla srozumitelná.',
	'smw_propvalueproblem' => 'Hodnota vlastnosti „$1“ nedávala smysl.',
	'smw_noqueryfeature' => 'Určitá část dotazu není na této wiki podporovaná a bude proto ignorována.',
	'smw_noconjunctions' => 'Konjunkce v dotazu není na této wiki podporována a bude proto ignorována.',
	'smw_nodisjunctions' => 'Disjunkce nejsou v dotazech na této wiki podporované a část dotazu byla ignorována ($1).',
	'smw_querytoolarge' => 'Následující podmínky dotazu nebudou zohledněné z důvodu omezení této wiki na délku nebo hĺoubku dotazu: $1.',
	'smw_devel_warning' => 'Tato vlastnost je momentálně ve vývoji a nemusí být zcela funkční. Předtím, než jí použijete si zazálohujte data.',
	'smw_notemplategiven' => 'Aby tento formát dotazu fungoval, uveďte hodnotu parametru „template”.',
	'smw_type_header' => 'Vlastností typu „$1“',
	'smw_typearticlecount' => 'Zobrazeno je $1 vlastností tohoto typu.',
	'smw_attribute_header' => 'Stránek používajících vlastnost „$1“',
	'smw_attributearticlecount' => 'Zobrazeno je $1 stránek, které používají tuto vlastnost.',
	'smw_subproperty_header' => 'Podvlastnosti',
	'smw_subpropertyarticlecount' => 'Této vlastnosti náleží $1 podvlastností',
	'exportrdf' => 'Export stránek do RDF',
	'smw_exportrdf_docu' => '<p>Tato stránka vám umožňuje exportovat části stránek do formátu RDF. Po zadaní názvů stránek do spodního textového pole (jeden název na řádek) můžete exportovat stránky.</p>',
	'smw_exportrdf_recursive' => 'Rekurzívně exportovat všechny související stránky. Pozor, výsledek může být velmi rozsáhlý!',
	'smw_exportrdf_backlinks' => 'Exportovat také stránky, které odkazují na exportované stránky. Vytvoří přehledné RDF.',
	'smw_exportrdf_lastdate' => 'Neexportovat stránky, které nebyly změněné od zadaného času.',
	'properties' => 'Vlastnosti',
	'smw_properties_docu' => 'Na této wiki se používají následující vlastnosti.',
	'smw_property_template' => '$1 typu $2 ($3)',
	'smw_propertylackspage' => 'Všechny vlastnosti by měly mít stránku s popisem!',
	'smw_propertylackstype' => 'Této vlastnosti nebyl definován žádný typ (předpokládá se prozatím typ $1)',
	'smw_propertyhardlyused' => 'Tato vlastnost se na wiki téměř nepoužívá!',
	'unusedproperties' => 'Nepoužité vlastnosti',
	'smw_unusedproperties_docu' => 'Nasledující vlastnosti existují i když je nevyužívá žádná jiná stránka.',
	'smw_unusedproperty_template' => '$1 typu $2',
	'wantedproperties' => 'Požadované vlastnosti',
	'smw_wantedproperties_docu' => 'Následující vlastnosti, které existují na této wiki, zatím nemají popisnou stránku.',
	'smw_wantedproperty_template' => '$1 (užité $2-krát)',
	'tooltip-purge' => 'Kliknutím zde obnovíte všechny dotazy a šablony na této stránce',
	'smw_purge' => 'Obnovit',
	'ontologyimport' => 'Importovat ontologii',
	'smw_oi_docu' => 'Tato speciální stránka umožňuje import ontologií. Ontologie musí dodržovat jistý formát, specifkovaný na <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">stránce pomocníka pro import ontologie</a>.',
	'smw_oi_action' => 'Importovat',
	'smw_oi_return' => 'Návrat na <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Ontologie není podporována nebo nebylo možné načíst ontologii.',
	'smw_oi_select' => 'Prosím, vyberte výroky, které se mají importovat a potom klikněte na tlačítko import.',
	'smw_oi_textforall' => 'Text hlavičky, která se přidá ke všem importům (může být prázdný):',
	'smw_oi_selectall' => 'Vybrat nebo odebrat všechny výroky o',
	'smw_oi_statementsabout' => 'Výroky o',
	'smw_oi_mapto' => 'Mapuje entitu na',
	'smw_oi_comment' => 'Přidá následující text:',
	'smw_oi_thisissubcategoryof' => 'Je podkategorií',
	'smw_oi_thishascategory' => 'Je částí',
	'smw_oi_importedfromontology' => 'Import z ontologie',
	'types' => 'Typy',
	'smw_types_docu' => 'Následuje seznam všech údajových typů, které je možné přiřadit vlastnostem. Každý údajový typ má stránku, kde je možné uvést dodatečné informace.',
	'smw_typeunits' => 'Jednotky typu „$1“: $2',
	'semanticstatistics' => 'Statistika sémantik',
	'smw_semstats_text' => 'Tato wiki obsahuje <b>$1</b> hodnot vlastností celkem <b>$2</b> rozličných <a href="$3">vlastností</a>.
<b>$4</b> vlastností nemá vlastní stránku a zamýšlený datový typ má uvedený <b>$5</b> z nich.
Některé z existujících vlastností mohou být <a href="$6">nepoužívané</a>.
Vlastnosti, kterým stále chybí stránka se nacházejí na <a href="$7">seznamu požadovaných vlastností</a>.',
	'flawedattributes' => 'Chybných atributů',
	'smw_fattributes' => 'Níže uvedené stránky mají nesprávně definovanou vlastnost. Počet nesprávných vlastností udává číslo v závorkách.',
	'uriresolver' => 'Překladač URI',
	'smw_uri_doc' => '<p>URI resolver se stará o implementaci <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG hledání na httpRange-14</a>. Stará se o to, aby se lidé nestali webstránkami.</p>',
	'ask' => 'Sémantické vyhledávání',
	'smw_ask_sortby' => 'Řadit podle sloupce',
	'smw_ask_ascorder' => 'Vzestupně',
	'smw_ask_descorder' => 'Sestupně',
	'smw_ask_submit' => 'Najdi výsledky',
	'smw_ask_editquery' => '[Upravit dotaz]',
	'smw_add_sortcondition' => '[Přidat podmínku na řazení]',
	'smw_ask_hidequery' => 'Skrýt dotaz',
	'smw_ask_help' => 'Pomocník pro dotazy',
	'smw_ask_queryhead' => 'Dotaz',
	'smw_ask_printhead' => 'Přídavné výpisy (volitelné)',
	'searchbyproperty' => 'Hledat podle hodnoty vlastnosti',
	'smw_sbv_docu' => '<p>Hledat na wiki článek, který má vlastnost s jistou hodnotou.</p>',
	'smw_sbv_noproperty' => '<p>Vložte prosím vlastnost.</p>',
	'smw_sbv_novalue' => '<p>Nebyla uvedena hodnota. Prosím, vložte jí ve formuláři nebo zobrazte všechny atributy typu $1</p>',
	'smw_sbv_displayresult' => 'Seznam všech článků, které mají vlastnost $1 s hodnotou $2.',
	'smw_sbv_property' => 'Vlastnost:',
	'smw_sbv_value' => 'Hodnota:',
	'smw_sbv_submit' => 'Hledat výsledky',
	'browse' => 'Prohledat wiki',
	'smw_browse_article' => 'Zadejte název stránky, od které chcete začít prohledávat.',
	'smw_browse_go' => 'Provést',
	'pageproperty' => 'Hledání vlastností stránky',
	'smw_pp_docu' => 'Hledání všech nositelů vlastnosti na zadané stránce.
Prosím, zadejte stránku i vlastnost.',
	'smw_pp_from' => 'Od stránky',
	'smw_pp_type' => 'Vlastnost',
	'smw_pp_submit' => 'Výsledky hledání',
	'smw_result_prev' => 'Zpět',
	'smw_result_next' => 'Dále',
	'smw_result_results' => 'Výsledky',
	'smw_result_noresults' => 'Bohužel nejsou žádné výsledky.',
	'smwadmin' => 'Funkce pro administraci Sémantické wiki',
);

/** German (Deutsch)
 * @author DaSch
 * @author Denny
 * @author Markus Krötzsch
 * @author Pill
 * @author Revolus
 */
$messages['de'] = array(
	'smw_edithelp' => 'Bearbeitungshilfe für Attribute',
	'smw_viewasrdf' => 'RDF-Feed',
	'smw_finallistconjunct' => ' und',
	'smw_factbox_head' => 'Fakten zu $1',
	'smw_isspecprop' => 'Dieses Attribut ist ein Spezialattribut in diesem Wiki.',
	'smw_isknowntype' => 'Dieser Datentyp gehört zu den Standardtypen in diesem Wiki.',
	'smw_isaliastype' => 'Dieser Datentyp ist ein Alias für den Typ “$1”.',
	'smw_isnotype' => 'Der Datentyp “$1” ist kein Standardtyp in diesem Wiki, und hat auch keine ausreichende Definition auf seiner Seite.',
	'smw_concept_description' => 'Beschreibung des Konzepts „$1“',
	'smw_no_concept_namespace' => "Konzepte können nur im ''Konzept:'' Namensraum erstellt werden.",
	'smw_multiple_concepts' => 'Jede Konzeptseite kann nur eine Konzeptdefinition beinhalten.',
	'smw_baduri' => 'URIs der Form „$1“ sind nicht zulässig.',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendar',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Semantische Anfragen sind in diesem Wiki zur Zeit nicht möglich.',
	'smw_iq_moreresults' => '… weitere Ergebnisse',
	'smw_iq_nojs' => 'Der Inhalt dieses Elementes kann mit einem Browser mit JavaScript-Unterstützung betrachtet werden.',
	'smw_iq_altresults' => 'Suchergebnisse als Liste anzeigen.',
	'smw_unknown_importns' => 'Für den Namensraum „$1“ sind leider keine Importfunktionen verfügbar.',
	'smw_nonright_importtype' => 'Das Element „$1“ kann nur für Seiten im Namensraum „$2“ verwendet werden.',
	'smw_wrong_importtype' => 'Das Element „$1“ kann nicht für Seiten im Namensraum „$2“ verwendet werden.',
	'smw_no_importelement' => 'Das Element „$1“ steht leider nicht zum Importieren zur Verfügung.',
	'smw_parseerror' => 'Der eingegebene Wert wurde nicht verstanden.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '“$1” kann nicht als Seitenname in diesem Wiki verwendet werden.',
	'smw_wrong_namespace' => 'Nur Seiten im Namensraum „$1“ sind hier zulässig.',
	'smw_unknowntype' => 'Dem Attribut wurde der unbekannte Datentyp „$1“ zugewiesen.',
	'smw_manytypes' => 'Dem Attribut wurden mehrere Datentypen zugewiesen.',
	'smw_emptystring' => 'Leere Zeichenfolgen werden nicht akzeptiert.',
	'smw_maxstring' => 'Die Zeichenkette „$1“ ist für diese Website zu lang.',
	'smw_notinenum' => '„$1“ gehört nicht zu den möglichen Werten dieses Attributs ($2).',
	'smw_noboolean' => '„$1“ ist kein Wahrheitswert (wahr/falsch).',
	'smw_true_words' => 'wahr,ja,true',
	'smw_false_words' => 'falsch,nein,false',
	'smw_nofloat' => '„$1“ ist keine Zahl.',
	'smw_infinite' => 'Die Zahl $1 ist zu lang.',
	'smw_infinite_unit' => 'Die Umrechnung in Einheit $1 ist nicht möglich: die Zahl ist zu lang.',
	'smw_unsupportedprefix' => 'Vorangestellte Zeichen bei Dezimalzahlen („$1“) werden nicht unterstützt.',
	'smw_unsupportedunit' => 'Umrechnung der Einheit „$1“ nicht unterstützt.',
	'smw_lonely_unit' => 'Keine Zahl vor dem “$1”-Zeichen gefunden.',
	'smw_bad_latlong' => 'Länge und Breite dürfen nur einmal und mit gültigen Werten angegeben werden.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'O',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'Breite:',
	'smw_label_longitude' => 'Länge:',
	'smw_nodatetime' => 'Das Datum „$1“ wurde nicht verstanden.',
	'smw_toomanyclosing' => 'In der Anfrage kommen zu viele „$1“ vor.',
	'smw_noclosingbrackets' => 'Ein Vorkommen von „<nowiki>[[</nowiki>“ in der Anfrage wurde nicht durch ein entsprechendes „]]“ abgeschlossen.',
	'smw_misplacedsymbol' => 'Das Symbol „$1“ wurde an einer Stelle verwendet, wo es keinen Sinn macht.',
	'smw_unexpectedpart' => 'Der Teil „$1“ der Anfrage wurde nicht verstanden. Die Ergebnisse sind eventuell nicht wie erwartet.',
	'smw_emptysubquery' => 'Keine Bedingung in Teilanfrage.',
	'smw_misplacedsubquery' => 'Eine Teilanfrage wurde an einer Stelle verwendet, an der keine Teilanfragen vorkommen dürfen.',
	'smw_valuesubquery' => 'Teilanfragen werden für Werte des Attributs „$1“ werden nicht unterstützt.',
	'smw_overprintoutlimit' => 'Die Anfrage enhält zu viele Ausgabeanweisungen.',
	'smw_badprintout' => 'Eine Ausgabeanweisung wurde nicht verstanden.',
	'smw_badtitle' => 'Leider ist „$1“ als Seitentitel nicht zulässig.',
	'smw_badqueryatom' => 'Ein Teil „<nowiki>[[…]]</nowiki>“ der Anfrage wurde nicht verstanden.',
	'smw_propvalueproblem' => 'Der Wert des Attributs „$1“ wurde nicht verstanden.',
	'smw_nodisjunctions' => 'Disjunktionen (ODER) in Anfragen sind in diesem Wiki nicht zulässig und ein Teil der Anfrage muss daher ignoriert werden ($1).',
	'smw_querytoolarge' => 'Die folgenden Anfragebedingungen konnten wegen den in diesem Wiki gültigen Beschränkungen für größe und Tiefe von Anfragen nicht berücksichtigt werden: $1.',
	'smw_devel_warning' => 'Diese Funktion befindet sich zur Zeit in Entwicklung und ist eventuell noch nicht voll einsatzfähig. Eventuell ist es ratsam, den Inhalt des Wikis vor der Benutzung dieser Funktion zu sichern.',
	'smw_notemplategiven' => 'Der Parameter „template“ muss angegeben werden, damit diese Anfrage durchgeführt werden kann.',
	'smw_type_header' => 'Attribute mit dem Datentyp „$1“',
	'smw_typearticlecount' => 'Es {{PLURAL:$1|wird 1 Attribut|werden $1 Attribute}} mit diesem Datentyp angezeigt:',
	'smw_attribute_header' => 'Seiten mit dem Attribut „$1“',
	'smw_attributearticlecount' => 'Es {{PLURAL:$1|wird 1 Seiten|werden $1 Seiten}} angezeigt, die dieses Attribut {{PLURAL:$1|verwendet|verwenden}}:',
	'smw_subproperty_header' => 'Unterattribute',
	'smw_subpropertyarticlecount' => 'Dieses Attribut hat {{PLURAL:$1|folgendes Unterattribut|folgende $1 Unterattribute}}:',
	'smw_concept_header' => 'Seiten des Konzepts „$1“',
	'smw_conceptarticlecount' => 'Es {{PLURAL:$1|wird 1 Seite|werden $1 Seiten}} angezeigt, die zu diesem Konzept {{PLURAL:$1|gehört|gehören}}:',
	'smw_rss_description' => 'RSS-Feed von $1',
	'exportrdf' => 'Seite als RDF exportieren',
	'smw_exportrdf_docu' => '<p>Hier können Informationen über einzelne Seiten im RDF-Format abgerufen werden. Bitte gib die Namen der gewünschten Seiten <i>zeilenweise</i> ein.</p>',
	'smw_exportrdf_recursive' => 'Exportiere auch alle relevanten Seiten rekursiv. Diese Einstellung kann zu sehr großen Ergebnissen führen!',
	'smw_exportrdf_backlinks' => 'Exportiere auch alle Seiten, die auf exportierte Seiten verweisen. Erzeugt RDF, das leichter durchsucht werden kann.',
	'smw_exportrdf_lastdate' => 'Exportiere keine Seiten, die seit dem angegebenen Zeitpunkt unverändert geblieben sind.',
	'properties' => 'Attribute',
	'smw_properties_docu' => 'In diesem Wiki gibt es die folgenden Attribute:',
	'smw_property_template' => '$1 mit Datentyp $2 ($3)',
	'smw_propertylackspage' => 'Alle Attribute sollten durch eine Seite beschrieben werden!',
	'smw_propertylackstype' => 'Für dieses Attribut wurde kein Datentyp angegeben ($1 wird vorläufig als Typ angenommen).',
	'smw_propertyhardlyused' => 'Dieses Attribut wird im Wiki kaum verwendet!',
	'unusedproperties' => 'Verwaiste Attribute',
	'smw_unusedproperties_docu' => 'Die folgenden Attributseiten existieren, obwohl sie nicht verwendet werden.',
	'smw_unusedproperty_template' => '$1 mit Datentyp $2',
	'wantedproperties' => 'Gewünschte Attribute',
	'smw_wantedproperties_docu' => 'Folgende Attribute haben bisher keine erläuterende Seite, obwohl sie bereits für die Beschreibung anderer Seiten verwendet werden.',
	'smw_wantedproperty_template' => '$1 ($2 Vorkommen)',
	'tooltip-purge' => 'Alle Anfrageergebnisse und Vorlagen auf dieser Seite auf den neuesten Stand bringen.',
	'smw_purge' => 'aktualisieren',
	'ontologyimport' => 'Importiere Ontologie',
	'smw_oi_docu' => 'Diese Spezialseite erlaubt es, Informationen aus einer externen Ontologie zu importieren. Die Ontologie sollte in einem vereinfachten RDF-Format vorliegen. Weitere Informationen sind in der englischsprachigen <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">Dokumentation zum Ontologieimport</a> zu finden.',
	'smw_oi_action' => 'Importieren',
	'smw_oi_return' => 'Zurück zum <a href="$1">Ontologieimport</a>.',
	'smw_oi_noontology' => 'Keine Ontologie unterstützt, oder Ontologie kann nicht geladen werden.',
	'smw_oi_select' => 'Bitte wähle die zu importierenden Statements aus und klicke dann auf die Import-Schaltfläche.',
	'smw_oi_textforall' => 'Text, der allen Importen vorangestellt werden soll (darf leer bleiben):',
	'smw_oi_selectall' => 'Auswählen oder abwählen aller Statements',
	'smw_oi_statementsabout' => 'Statements über',
	'smw_oi_mapto' => 'Auf Karte zeigen bei',
	'smw_oi_comment' => 'Füge den folgenden Text hinzu:',
	'smw_oi_thisissubcategoryof' => 'Unterkategorie von',
	'smw_oi_thishascategory' => 'Ist Teil von',
	'smw_oi_importedfromontology' => 'Importiere von Ontologie',
	'types' => 'Datentypen',
	'smw_types_docu' => 'Die folgenden Datentypen können Attributen zugewiesen werden. Jeder Datentyp hat eine eigene Seite, auf der genauere Informationen eingetragen werden können.',
	'smw_typeunits' => 'Maßeinheiten des Datentyps “$1”: $2',
	'semanticstatistics' => 'Statistik über semantische Daten',
	'smw_semstats_text' => 'In diesem Wiki wurden <b>$1</b> Werte für insgesamt <b>$2</b> verschiedene <a href="$3">Attribute</a> eingegeben. <b>$4</b> Attribute haben eine eigene Seite und der gewünschte Datentyp ist für <b>$5</b> von diesen angegeben worden. Einige der existierenden Attribute können <a href="$6">verwaiste Attribute</a> sein. Attribute, für die noch eine Seite angelegt werden sollte, sind in der <a href="$7">Liste der gewünschten Attribute</a> aufgeführt.',
	'flawedattributes' => 'Fehlerhafte Attribute',
	'smw_fattributes' => 'Die unten aufgeführten Seiten enthalten fehlerhafte Attribute. Die Anzahl der fehlerhaften Attribute ist in den Klammern angegeben.',
	'uriresolver' => 'URI-Auflöser',
	'smw_uri_doc' => '<p>Der URI-Auflöser setzt die Empfehlungen »<a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>« um. Er sorgt dafür, dass Menschen nicht zu Webseiten werden.</p>',
	'ask' => 'Semantische Suche',
	'smw_ask_sortby' => 'Sortiere nach Spalte (optional)',
	'smw_ask_ascorder' => 'Aufsteigend',
	'smw_ask_descorder' => 'Absteigend',
	'smw_ask_submit' => 'Finde Ergebnisse',
	'smw_ask_editquery' => '[Anfrage bearbeiten]',
	'smw_add_sortcondition' => '[Sortieranweisung hinzufügen]',
	'smw_ask_hidequery' => 'Anfrage ausblenden',
	'smw_ask_help' => 'Hilfe',
	'smw_ask_queryhead' => 'Anfrage',
	'smw_ask_printhead' => 'Zusätzliche Ausgaben (optional)',
	'searchbyproperty' => 'Suche mittels Attribut',
	'smw_sbv_docu' => '<p>Diese Spezialseite findet alle Seiten, die einen bestimmten Wert für das angegebene Attribut haben.</p>',
	'smw_sbv_noproperty' => '<p>Bitte den Namen eines Attributs eingeben</p>',
	'smw_sbv_novalue' => '<p>Bitte den gewünschten Wert eingeben oder alle Werte für das Attribut $1 ansehen.</p>',
	'smw_sbv_displayresult' => 'Eine Liste aller Seiten, die ein Attribut $1 mit dem Wert $2 haben.',
	'smw_sbv_property' => 'Attribut',
	'smw_sbv_value' => 'Wert',
	'smw_sbv_submit' => 'Finde Ergebnisse',
	'browse' => 'Wiki browsen',
	'smw_browselink' => 'Attribute anzeigen',
	'smw_browse_article' => 'Bitte gib den Titel einer Seite ein.',
	'smw_browse_go' => 'Los',
	'smw_browse_show_incoming' => 'zeige Attribute die hierhin verlinken',
	'smw_browse_hide_incoming' => 'verstecke Attribute die hierhin verlinken',
	'pageproperty' => 'Attributswerte einer Seite',
	'smw_pp_docu' => 'Suche nach allen Werten, die ein bestimmtes Attribut für die angegebene Seite hat.',
	'smw_pp_from' => 'Seite',
	'smw_pp_type' => 'Attribut',
	'smw_pp_submit' => 'Ergebnisse anzeigen',
	'smw_result_prev' => 'Zurück',
	'smw_result_next' => 'Vorwärts',
	'smw_result_results' => 'Ergebnisse',
	'smw_result_noresults' => 'Keine Ergebnisse gefunden.',
	'smwadmin' => 'Admin-Funktionen für Semantic MediaWiki',
);

/** Greek (Ελληνικά)
 * @author Consta
 */
$messages['el'] = array(
	'smw_sbv_property' => 'Ιδιότητα',
	'smw_pp_type' => 'Ιδιότητα',
	'smw_result_results' => 'Αποτελέσματα',
	'smw_result_noresults' => 'Συγνώμη, δεν υπάρχουν αποτελέσματα.',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'smw_edithelp' => 'Helpo pri redaktado de ecoj',
	'smw_viewasrdf' => 'RDF-fonto',
	'smw_finallistconjunct' => ', kaj',
	'smw_factbox_head' => 'Faktoj pri $1',
	'smw_isspecprop' => 'Ĉi tiu eco estas speciala eco en ĉi tiu vikio.',
	'smw_isknowntype' => 'Ĉi tiu datumtipo estas inter la normaj datumtipoj de ĉi tiu vikio.',
	'smw_isaliastype' => 'Ĉi tiu datumtipo estas kromnomo por la datumtipo "$1".',
	'smw_isnotype' => 'Ĉi tiu datumtipo "$1" ne estas norma datumtipo en la vikio, kaj ne estis donita difino de uzanto.',
	'smw_concept_description' => 'Priskribo de koncepto "$1"',
	'smw_no_concept_namespace' => 'Konceptoj povas nur esti difinita en paĝoj en la nomspaco Concept:.',
	'smw_baduri' => 'Bedaŭrinde, URI-oj de la kamparo "$1" ne estas permesita.',
	'smw_icalendar_link' => 'iKalendaro',
	'smw_iq_disabled' => 'Bedaŭrinde, semantikaj informmendoj estis malebligitaj por ĉi tiu vikio.',
	'smw_iq_moreresults' => '… pluaj rezultoj',
	'smw_iq_nojs' => 'Bonvolu uzi retumilon kiu povas montri JavaScript-on por rigardi ĉi tiun elementon.',
	'smw_iq_altresults' => 'Rigardu la rezulto-liston rekte.',
	'smw_unknown_importns' => 'Import-funkcioj ne estas uzeblaj por nomspaco "$1".',
	'smw_nonright_importtype' => '$1 nur eblas esti uzata por paĝoj en nomspaco "$2".',
	'smw_wrong_importtype' => '$1 ne eblas esti uzata por paĝoj en nomspaco "$2".',
	'smw_no_importelement' => 'Elemento "$1" ne estas havebla por importi.',
	'smw_parseerror' => 'La donata valuto ne estis komprenita.',
	'smw_notitle' => '"$1" ne eblas esti uzata kiel paĝnomo en ĉi tiu vikio.',
	'smw_unknowntype' => 'Nesubtenita datumtipo "$1" difinita por eco.',
	'smw_emptystring' => 'Malplenaj ĉenoj ne estas akceptitaj.',
	'smw_maxstring' => 'Ĉena reprezentado $1 estas tro longa por {{SITENAME}}.',
	'smw_noboolean' => '"$1" ne estas agnoskita kiel Bulea (vera/falsa) valuto.',
	'smw_true_words' => 'vera,v,jes,j',
	'smw_false_words' => 'falsa,f,ne,n',
	'smw_nofloat' => '"$1" ne estas nombro.',
	'smw_abb_east' => 'O',
	'smw_abb_west' => 'U',
	'smw_label_latitude' => 'Latitudo:',
	'smw_label_longitude' => 'Longitudo:',
	'smw_nodatetime' => 'La dato "$1" ne estis komprenita.',
	'smw_badtitle' => 'Bedaŭrinde, "$1" ne estas valida paĝa titolo.',
	'smw_propvalueproblem' => 'La valuto de eco "$1" ne estis komprenita.',
	'exportrdf' => 'Eksportu paĝojn al RDF',
	'properties' => 'Ecoj',
	'smw_properties_docu' => 'La jenaj ecoj estas uzataj en la vikio.',
	'smw_property_template' => '$1 de datumtipo $2 ($3)',
	'unusedproperties' => 'Neuzitaj ecoj',
	'smw_unusedproperty_template' => '$1 de datumtipo $2',
	'wantedproperties' => 'Volitaj ecoj',
	'smw_wantedproperty_template' => '$1 ($2 uzoj)',
	'smw_purge' => 'Refreŝigu',
	'smw_oi_action' => 'Importu',
	'smw_oi_statementsabout' => 'Komentoj pri',
	'smw_oi_comment' => 'Aldonu la jenan tekston:',
	'smw_oi_thisissubcategoryof' => 'Subkategorio de',
	'smw_oi_thishascategory' => 'Estas parto de',
	'types' => 'Datumtipoj',
	'smw_types_docu' => 'Jen listo de ĉiuj datentipoj kiu povas esti asignitaj al ecoj.
Ĉiu datentipo havas paĝon kie plua informo povas esti aldonita.',
	'semanticstatistics' => 'Semantikaj Statistikoj',
	'flawedattributes' => 'Fuŝaj Ecoj',
	'ask' => 'Semantika serĉo',
	'smw_ask_submit' => 'Trovu rezultojn',
	'smw_ask_editquery' => '[Redaktu serĉomendo]',
	'smw_add_sortcondition' => '[Aldoni ordigan kondiĉon]',
	'smw_ask_hidequery' => 'Kaŝi serĉmendon',
	'smw_ask_help' => 'Helpo pri serĉomendoj',
	'smw_ask_queryhead' => 'Serĉomendo',
	'searchbyproperty' => 'Serĉu laŭ eco',
	'smw_sbv_noproperty' => '<p>Bonvolu enigi econ.</p>',
	'smw_sbv_property' => 'Eco',
	'smw_sbv_value' => 'Valuto',
	'smw_sbv_submit' => 'Trovu rezultojn',
	'browse' => 'Foliumi vikion',
	'smw_browse_go' => 'Ek',
	'smw_browse_show_incoming' => 'malkaŝi ecojn kiu enligiĝas ĉi tien',
	'smw_browse_hide_incoming' => 'kaŝi ecojn kiu enligiĝas ĉi tien',
	'smw_inverse_label_default' => '$1 el',
	'pageproperty' => 'Serĉo de paĝaj ecoj',
	'smw_pp_from' => 'De paĝo',
	'smw_pp_type' => 'Eco',
	'smw_pp_submit' => 'Trovu rezultojn',
	'smw_result_prev' => 'Antaŭe',
	'smw_result_next' => 'Sekve',
	'smw_result_results' => 'Rezultoj',
	'smw_result_noresults' => 'Bedaŭrinde, neniuj rezultoj',
	'smwadmin' => 'Administradaj funkcioj por Semantic MediaWiki',
);

/** Spanish (Español)
 * @author Carmen Jorge García-Reyes
 * @author Javier Calzada Prado
 */
$messages['es'] = array(
	'smw_edithelp' => 'Ayuda a la redacción de relaciones y atributos',
	'smw_viewasrdf' => 'Ver como RDF',
	'smw_finallistconjunct' => ' y',
	'smw_factbox_head' => 'Hechos relativos a à $1 — Búsqueda de páginas similares con <span class="smwsearchicon">+</span>.',
	'smw_baduri' => 'Lo sentimos. Las URIs del dominio $1 no están disponibles en este emplazamiento',
	'smw_iq_disabled' => 'Lo sentimos. Las búsquedas en los artículos de este wiki no están autorizadas.',
	'smw_iq_moreresults' => '&hellip; siguientes resultados',
	'smw_iq_nojs' => 'Use un navegador con JavaScript habilitado para ver este elemento.',
	'smw_unknown_importns' => 'Ninguna función de importación está disponible para el espacio de nombres "$1".',
	'smw_nonright_importtype' => 'El elemento "$1" no puede ser empleado más que para los artículos del espacio de nombres "$2".',
	'smw_wrong_importtype' => 'El elemento "$1" no puede ser utilizado para los artículos del espacio de nombres dominio "$2".',
	'smw_no_importelement' => 'El elemento "$1" no está disponible para la importación.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_unknowntype' => 'El tipo de datos "$1" no soportado ha sido devuelto al atributo.',
	'smw_manytypes' => 'Demasiados tipos de datos han sido asignados al atributo.',
	'smw_emptystring' => 'No se aceptan cadenas vacías.',
	'smw_maxstring' => 'La representación de la cadena $1 es demasiado grande para este sitio.',
	'smw_notinenum' => '"$1" no esta en la lista de posibles valores ($2) para este atributo.',
	'smw_noboolean' => '"$1" no es reconocido como un valor booleano (verdadero/falso).',
	'smw_true_words' => 'verdadero,t,si,s,true',
	'smw_false_words' => 'falso,f,no,n,false',
	'smw_nofloat' => '"$1" no es un número.',
	'smw_infinite' => 'El número $1 es demasiado largo.',
	'smw_infinite_unit' => 'La conversión en la unidad $1 es imposible : el número es demasiado largo.',
	'smw_unsupportedprefix' => 'prefijos ("$1") no esta soportados actualmente',
	'smw_unsupportedunit' => 'La conversión de la unidad "$1" no está soportada',
	'smw_abb_west' => 'O',
	'smw_label_latitude' => 'Latitud :',
	'smw_label_longitude' => 'Longitud :',
	'smw_nodatetime' => 'La fecha "$1" no ha sido comprendida.',
	'smw_devel_warning' => 'Esta función está aún en desarrollo y quizá aun no sea operativa. Es quizá recomendable hacer una copia de seguridad del wiki antes de utilizar esta función.',
	'smw_type_header' => 'Atributos de tipo “$1”',
	'smw_typearticlecount' => 'Mostrando $1 atributos usando este tipo.',
	'smw_attribute_header' => 'Paginas usando el atributo “$1”',
	'smw_attributearticlecount' => 'Mostrando $1 páginas usando este atributo.',
	'exportrdf' => 'Exportar el artículo como RDF',
	'smw_exportrdf_docu' => '<p> En esta página, las partes de contenido de un artículo pueden ser exportadas a formato RDF. Introduzca el nombre de las páginas deseadas en el cuadro de texto que se encuentra debajo, <i>un nombre por línea </i>.<p/>',
	'smw_exportrdf_recursive' => 'Exportar igualmente todas las páginas pertinentes de forma recurrente. Esta posibilidad puede conseguir un gran número de resultados !',
	'smw_exportrdf_backlinks' => 'Exportar igualmente todas las páginas que reenvían a páginas exportadas. Resulta un RDF en el que se facilita la navegación.',
	'tooltip-purge' => 'Volver a actualizar todas las búsquedas y borradores de esta página.',
	'smw_purge' => 'Volver a actualizar',
	'ontologyimport' => 'Importar la ontología',
	'smw_oi_docu' => 'Esta página especial permite importar datos de una ontología externa. Dicha ontología debe estar en un formato RDF simplificado. Información adicional disponible en <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">Documentación relativa a la importación de ontologías en lengua inglesa.',
	'smw_oi_action' => 'Importar',
	'smw_oi_return' => 'Volver a <a href="$1">Importar la ontología</a>.',
	'types' => 'Tipos de datos',
	'smw_types_docu' => 'Los tipos de datos siguientes pueden ser asignados a los atributos. Cada tipo de datos tiene su propio artículo, en el que puede figurar información más precisa.',
	'flawedattributes' => 'Flawed Attributes',
	'smw_fattributes' => 'The pages listed below have an incorrectly defined attribute. The number of incorrect attributes is given in the brackets.',
	'uriresolver' => 'Traductor de URI',
	'smw_uri_doc' => '<p>El traductor de URI implementa <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Esto se preocupa de cosas que los humanos no lo hacen en los sitios web..</p>',
	'ask' => 'Búsqueda semántica',
	'smw_ask_sortby' => 'Ordenar por columna',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Buscar resultados',
	'searchbyproperty' => 'Buscar por atributo',
	'smw_sbv_docu' => '<p>Buscar por todas las páginas que tiene un atributo y valor dado.</p>',
	'smw_sbv_noproperty' => '<p>Por favor introduzca un atributo.</p>',
	'smw_sbv_novalue' => '<p>Por favor introduzca un valor, o ver todos los valores de atributo para $1.</p>',
	'smw_sbv_displayresult' => 'Una lista de todas las páginas que tienen un atributo $1 con el valor $2.',
	'smw_sbv_property' => 'Atributo',
	'smw_sbv_value' => 'Valor',
	'smw_sbv_submit' => 'Buscar resultados',
	'browse' => 'Explorar artículos',
	'smw_browse_article' => 'Introduzca el nombre de la página para empezar a explorar.',
	'smw_browse_go' => 'Ir',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Siguiente',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Lo siento, no hay resultados.',
);

/** Finnish (Suomi)
 * @author Cimon Avaro
 * @author Nike
 */
$messages['fi'] = array(
	'smw_edithelp' => 'Muokkausohjeita ominaisuuksista',
	'smw_viewasrdf' => 'RDF-syöte',
	'smw_finallistconjunct' => ' ja',
	'smw_iq_moreresults' => '… lisää tuloksia',
	'smw_parseerror' => 'Tarjottua arvoa ei ymmärretty.',
	'smw_emptystring' => 'Tyhjiä merkkijonoja ei hyväksytä.',
	'smw_noboolean' => '”$1” ei ole tunnistettavissa totuusarvoksi.',
	'smw_true_words' => 'kyllä,k,y',
	'smw_false_words' => 'ei,e,n',
	'smw_nofloat' => '”$1” ei ole luku.',
	'smw_unsupportedprefix' => 'Lukujen etuliitteitä (”$1”) ei tueta.',
	'smw_unsupportedunit' => 'Yksikön ”$1” yksikkömuunnosta ei tueta.',
	'smw_lonely_unit' => 'Symbolin ”$1” edestä puuttuu luku.',
	'smw_bad_latlong' => 'Pituuspiiri ja leveysaste voidaan määritellä vain kerran ja toimivilla koordinaateilla.',
	'smw_abb_north' => 'Pohj.',
	'smw_abb_east' => 'It.',
	'smw_abb_south' => 'Etel.',
	'smw_abb_west' => 'Länt.',
	'smw_label_latitude' => 'Korkeusaste:',
	'smw_label_longitude' => 'Pituuspiiri:',
	'smw_nodatetime' => 'Päiväystä ”$1” ei tunnistettu.',
	'smw_emptysubquery' => 'Jollakin alikyselyllä ei ole kelvollista ehtoa.',
	'smw_badtitle' => '”$1” ei ole kelvollinen sivun nimi.',
	'smw_devel_warning' => 'Tämä ominaisuutta kehitetään aktiivisesti, eikä välttämättä ole kaikin osin toimiva. Varmuuskopioi tietosi ennen käyttöä.',
	'exportrdf' => 'Vie sivut RDF:nä',
	'smw_purge' => 'Päivitä',
	'ontologyimport' => 'Tuo ontologia',
	'smw_oi_importedfromontology' => 'Tuo ontologiasta',
	'types' => 'Tyypit',
	'smw_ask_ascorder' => 'Nouseva',
	'smw_ask_descorder' => 'Laskeva',
	'smw_ask_editquery' => '[Muokkaa kyselyä]',
	'smw_add_sortcondition' => '[Lisää lajitteluehto]',
	'smw_sbv_property' => 'Ominaisuus',
	'smw_sbv_value' => 'Arvo',
	'browse' => 'Selaa wikiä',
	'smw_result_prev' => 'Edellinen',
	'smw_result_next' => 'Seuraava',
	'smw_result_results' => 'Tulokset',
	'smw_result_noresults' => 'Ei hakutuloksia.',
);

/** French (Français)
 * @author Grondin
 * @author IAlex
 * @author McDutchie
 * @author Meithal
 * @author Pierre Matringe
 * @author Sherbrooke
 * @author Verdy p
 * @author Zetud
 */
$messages['fr'] = array(
	'smw_edithelp' => "Aide à la rédaction de relations et d'attributs",
	'smw_viewasrdf' => 'Voir comme RDF',
	'smw_finallistconjunct' => ' et',
	'smw_factbox_head' => 'Faits relatifs à $1 &mdash; Recherche de pages similaires avec <span class="smwsearchicon">+</span>.',
	'smw_isspecprop' => 'Cette propriété est spéciale sur ce wiki.',
	'smw_isknowntype' => 'Ce type fait partie des types de données standards de ce wiki.',
	'smw_isaliastype' => 'Ce type est un alias du type de données “$1”.',
	'smw_isnotype' => "Le type « $1 » n'est pas un type de données standard sur ce wiki, et n'a pas non plus été défini par un utilisateur.",
	'smw_concept_description' => 'Description du concept « $1 »',
	'smw_no_concept_namespace' => "Les concepts peuvent uniquement être définis dans les pages dans l'espace de noms Concept:.",
	'smw_multiple_concepts' => 'Chaque page de concept ne peut avoir qu’une seule définition.',
	'smw_concept_cache_miss' => "Le concept « $1 » ne peut être utilisé en ce moment, puisque la configuration du wiki requiert qu'il soit lancé hors-ligne. Si le problème persiste après quelques instants, demander à votre administrateur du site de rendre disponible ce concept.",
	'smw_baduri' => 'Désolé. Les URIs du domaine $1 ne sont pas disponible à cet emplacement',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendrier',
	'smw_vcard_link' => 'vCarte',
	'smw_iq_disabled' => 'Désolé. Les recherches dans les articles de ce wiki ne sont pas autorisées.',
	'smw_iq_moreresults' => '&hellip; autres résultats',
	'smw_iq_nojs' => 'Utilisez un navigateur avec JavaScript activé pour voir cet élément.',
	'smw_iq_altresults' => 'Parcourir directement la liste des résultats.',
	'smw_unknown_importns' => "Aucune fonction d'importation n'est disponible pour l'espace de noms « $1 ».",
	'smw_nonright_importtype' => "L'élément « $1 » ne peut être employé que pour des articles de l'espace de noms « $2 ».",
	'smw_wrong_importtype' => "$1 ne peut pas être employé pour des articles dans l'espace de noms « $2 ».",
	'smw_no_importelement' => 'L\'élément "$1" n\'est pas disponible pour l\'importation.',
	'smw_parseerror' => "La donnée indiquée n'a pas été comprise.",
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => '“$1” ne peut être utilisé comme nom de page sur ce wiki.',
	'smw_wrong_namespace' => 'Seules les pages dans l’espace « $1 » sont autorisées ici.',
	'smw_unknowntype' => 'Le type de données "$1" non supporté a été retourné à l\'attribut.',
	'smw_manytypes' => "Plusieurs types de données ont été assignés à l'attribut.",
	'smw_emptystring' => 'Les chaînes vides ne sont pas acceptées.',
	'smw_maxstring' => 'La chaîne de représentation $1 est trop grande pour ce site.',
	'smw_notinenum' => '"$1" ne fait pas partie des valeurs possibles ($2) pour cet attribut.',
	'smw_noboolean' => '"$1" n\'est pas reconnu comme valeur booléenne (vrai/faux).',
	'smw_true_words' => 'vrai,v,oui,true',
	'smw_false_words' => 'faux,f,non,false',
	'smw_nofloat' => '"$1" n\'est pas un nombre.',
	'smw_infinite' => 'Le nombre $1 est trop long.',
	'smw_infinite_unit' => "La conversion en l'unité $1 a donné un nombre trop grand pour {{SITENAME}}.",
	'smw_unsupportedprefix' => 'Des préfixes ("$1") ne sont pas supportés actuellement',
	'smw_unsupportedunit' => "La conversion de l'unité « $1 » n'est pas supportée.",
	'smw_lonely_unit' => 'Aucun nombre trouvé avant le symbole “$1”.',
	'smw_bad_latlong' => "Latitude et longitude ne doivent être indiqués qu'une seule fois, et avec des coordonnées valides.",
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'O',
	'smw_label_latitude' => 'Latitude :',
	'smw_label_longitude' => 'Longitude :',
	'smw_nodatetime' => 'La date "$1" n\'a pas été comprise.',
	'smw_toomanyclosing' => "Il semble y avoir trop d'occurences de “$1” dans la requête.",
	'smw_noclosingbrackets' => "Certains “[[” dans votre requête n'ont pas été clos par des “]]” correspondants.",
	'smw_misplacedsymbol' => "Le symbole “$1” a été utilisé à un endroit où il n'est pas utile.",
	'smw_unexpectedpart' => "La partie « $1 » de la requête n'a pas été comprise. Les résultats peuvent être inattendus.",
	'smw_emptysubquery' => 'Certaines sous-requêtes ont une condition invalide.',
	'smw_misplacedsubquery' => "Certaines sous-requêtes ont été utilisées à un endroit où aucune sous-requête n'est permise.",
	'smw_valuesubquery' => 'Sous-requête non supportée pour les valeurs de la propriété “$1”.',
	'smw_overprintoutlimit' => "La requête contient trop d'instructions de formatage.",
	'smw_badprintout' => "Certaines instructions de formatage dans la requête n'ont pas été comprises.",
	'smw_badtitle' => "Désolé, mais “$1” n'est pas un titre de page valable.",
	'smw_badqueryatom' => "Les parties “[[…]]” de la requête n'ont pas été comprises.",
	'smw_propvalueproblem' => "La valeur de la propriété « $1 » n'a pas été comprise.",
	'smw_noqueryfeature' => 'Quelques fonctionnalité de requêtes ne sont pas supportés sur ce wiki et une partie d’entre elles ont été retirées ($1).',
	'smw_noconjunctions' => 'Les conjonctions dans les requêtes ne sont pas supportées sur ce wiki et une parties d’entres elles ont été retirées ($1).',
	'smw_nodisjunctions' => 'Les disjonctions dans les requêtes ne sont pas supportées sur ce wiki et des parties de la requête ont été ignorées ($1).',
	'smw_querytoolarge' => "Les conditions suivantes de la requête n'ont pu être évaluées en raison des restrictions de ce wiki à la taille ou à la profondeur des requêtes : $1.",
	'smw_devel_warning' => "Cette fonction est encore en développement et n'est peut-être pas encore opérationnelle. Il est peut-être judicieux de faire une sauvegarde du contenu du wiki avant toute utilisation de cette fonction.",
	'smw_notemplategiven' => 'Veuillez fournir une valeur pour le paramètre « modèle » pour ce format de requête afin de travailler.',
	'smw_type_header' => 'Attributs de type “$1”',
	'smw_typearticlecount' => 'Afficher {{PLURAL:$1|la propriété|les $1 propriétés}} utilisant ce type.',
	'smw_attribute_header' => "Pages utilisant l'attribut “$1”",
	'smw_attributearticlecount' => 'Afficher {{PLURAL:$1|la page|les $1 pages}} utilisant cette propriété.',
	'smw_subproperty_header' => 'Sous-propriétés',
	'smw_subpropertyarticlecount' => 'Cette propriété dispose {{PLURAL:$1|de la sous-propriété suivante| des $1 sous-propriétés suivantes}}.',
	'smw_concept_header' => 'Page du concept « $1 »',
	'smw_conceptarticlecount' => 'Afficher {{PLURAL:$1|la page|les $1 pages}} reposant sur ce concept',
	'smw_rss_description' => 'fil RSS $1',
	'specialpages-group-smw_group' => 'MediaWiki sémantique',
	'exportrdf' => "Exporter l'article en RDF",
	'smw_exportrdf_docu' => "<p>Cette page permet d'obtenir des données d'une page au format RDF. Veuillez entrer le nom des pages souhaitées dans la boîte de texte ci-dessous, un nom par ligne.</p>",
	'smw_exportrdf_recursive' => 'Exporter également toutes les pages pertinentes de manière récursive. Cette possibilité peut aboutir à un très grand nombre de résultats !',
	'smw_exportrdf_backlinks' => 'Exporter également toutes les pages qui renvoient à des pages exportées. Produit un RDF dans lequel la navigation est facilitée.',
	'smw_exportrdf_lastdate' => 'Ne pas exporter les pages non modifiées depuis le moment indiqué.',
	'properties' => 'Propriétés',
	'smw_properties_docu' => 'Sur ce wiki, sont utilisées les propriétés suivantes.',
	'smw_property_template' => '$1 du type $2 ($3)',
	'smw_propertylackspage' => 'Toute propriété devrait être décrite par une page !',
	'smw_propertylackstype' => "Aucun type n'a été spécifié pour cette propriété (type actuellement supposé : $1).",
	'smw_propertyhardlyused' => 'Cette propriété est à peine utilisée sur ce wiki !',
	'unusedproperties' => 'Propriétés inutilisées',
	'smw_unusedproperties_docu' => "Les propriétés suivantes existent, bien qu'aucune page ne les utilise.",
	'smw_unusedproperty_template' => '$1 de type $2',
	'wantedproperties' => 'Propriétés demandées',
	'smw_wantedproperties_docu' => "Les propriétés suivantes sont utilisées sur ce wiki mais n'ont pas encore de page pour les décrire.",
	'smw_wantedproperty_template' => '$1 ($2 utilisations)',
	'tooltip-purge' => 'Réactualiser toutes les recherches et tous les brouillons de cette page.',
	'smw_purge' => 'Réactualiser',
	'ontologyimport' => 'Importer une ontologie',
	'smw_oi_docu' => "Cette page spéciale permet d'importer des ontologies. Elles doivent être dans un certain format, spécifié dans la <a href=\"http://semantic-mediawiki.org/wiki/Help:Ontology_import\">documentation relative à l'importation d'ontologies</a> (en anglais).",
	'smw_oi_action' => 'Importer',
	'smw_oi_return' => 'Revenir à <a href="$1">Importer l\'ontologie</a>.',
	'smw_oi_noontology' => "Aucune ontologie fournie, ou impossible de charger l'ontologie.",
	'smw_oi_select' => 'Veuillez sélectionner le texte à importer, puis cliquez sur le bouton « importer ».',
	'smw_oi_textforall' => "Texte d'en-tête à ajouter à toutes les importations (peut être vide) :",
	'smw_oi_selectall' => 'Sélectionner ou désélectionner tous les textes',
	'smw_oi_statementsabout' => 'Textes sur',
	'smw_oi_mapto' => "Carte de l'entité sur",
	'smw_oi_comment' => 'Ajouter le texte suivant :',
	'smw_oi_thisissubcategoryof' => 'Sous-catégorie de',
	'smw_oi_thishascategory' => 'Fait partie de',
	'smw_oi_importedfromontology' => "Importer de l'ontologie",
	'types' => 'Types de données',
	'smw_types_docu' => 'Les types de données suivants peuvent être assignées aux attributs. Chaque type de données a son propre article, dans lequel peuvent figurer des informations plus précises.',
	'smw_typeunits' => 'Unités de mesure de type « $1 » : $2',
	'semanticstatistics' => 'Statistiques sémantiques',
	'smw_semstats_text' => 'Ce wiki contient <b>$1</b> valeurs de propriété pour un total de <b>$2</b> <a href="$3">propriétés</a> différentes. 
<b>$4</b> propriétés ont leur propre page, et le type de données voulu est spécifié pour <b>$5</b> de celles-ci. 
Certaines des propriétés existantes peuvent faire être <a href="$6">inutilisées</a>. Les propriétés qui n\'ont pas encore de page se trouvent dans la <a href="$7">liste des propriétés demandées</a>.',
	'flawedattributes' => 'Attributs défectueux',
	'smw_fattributes' => "Les pages ci-dessous ont un attribut qui n'est pas défini correctement. Le nombre d'attributs incorrects est donné entre les parenthèses.",
	'uriresolver' => "Résolveur d'URI",
	'smw_uri_doc' => '<p>Le résolveur d\'URI implémente la <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">Conclusion du TAG du W3C à propos du httpRange-14</a>. Il peut veiller à ce que les humains ne deviennent pas des sites web.',
	'ask' => 'Recherche sémantique',
	'smw_ask_sortby' => 'Trier par colonnes',
	'smw_ask_ascorder' => 'Croissant',
	'smw_ask_descorder' => 'Décroissant',
	'smw_ask_submit' => 'Trouver des résultats',
	'smw_ask_editquery' => '[Éditer la requête]',
	'smw_add_sortcondition' => '[Ajoute les conditions de tri]',
	'smw_ask_hidequery' => 'Masquer la requête',
	'smw_ask_help' => 'Aide à la requête',
	'smw_ask_queryhead' => 'Requête',
	'smw_ask_printhead' => 'Conditions supplémentaires (facultatif)',
	'searchbyproperty' => 'Rechercher par attribut',
	'smw_sbv_docu' => '<p>Rechercher toutes les pages qui ont un attribut donné avec un certaine valeur.</p>',
	'smw_sbv_noproperty' => '<p>Veuillez entrer un attribut.</p>',
	'smw_sbv_novalue' => '<p>Veuillez entrer une valeur ou consulter toutes les valeurs des attributs pour $1.</p>',
	'smw_sbv_displayresult' => 'Liste de toutes les pages qui ont un attribut $1 avec la valeur $2.',
	'smw_sbv_displayresultfuzzy' => "Une liste de toutes les pages qui ont la propriété « $1 » avec la valeur « $2 ». Puisqu'il n'y a que quelques résultats, les valeurs proches sont également affichées.",
	'smw_sbv_property' => 'Propriété',
	'smw_sbv_value' => 'Valeur',
	'smw_sbv_submit' => 'Trouver des résultats',
	'browse' => 'Parcourir le wiki',
	'smw_browselink' => 'Chercher les propriétés',
	'smw_browse_article' => 'Entrez le nom de la page à partir de laquelle commencer la navigation.',
	'smw_browse_go' => 'Démarrer',
	'smw_browse_show_incoming' => 'afficher les propriétés qui pointent ici',
	'smw_browse_hide_incoming' => 'cacher les propriétés qui pointent ici',
	'smw_browse_no_outgoing' => 'Cette page n’a aucune propriété.',
	'smw_browse_no_incoming' => 'Aucune propriété ne pointe vers cette page.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Inverser le label de propriété',
	'pageproperty' => 'Rechercher dans les propriétés de la page',
	'smw_pp_docu' => "Rechercher toutes les valeurs d'une propriété dans une page donnée. Veuillez entrer la page et une propriété.",
	'smw_pp_from' => 'De la page',
	'smw_pp_type' => 'Propriété',
	'smw_pp_submit' => 'Afficher les résultats',
	'smw_result_prev' => 'Précédent',
	'smw_result_next' => 'Suivant',
	'smw_result_results' => 'Résultats',
	'smw_result_noresults' => 'Désolé, aucun résultat.',
	'smwadmin' => 'Fonctions administrateur pour Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Install le stockage pour Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Le moteur de stockage a été installé avec succès.',
	'smw_smwadmin_return' => 'Revenir vers $1',
	'smw_smwadmin_updatestarted' => 'Un nouveau processus pour le rafraichissement de semantic data a commencé.
Toutes les données stockées seront reconstruites voire réparées si nécessaire.
Vous pouvez suivre la progression de la mise à jour sur cette page spéciale.',
	'smw_smwadmin_updatenotstarted' => 'Un processus de mise à jour est déjà en cours d’exécution.
Ne pas en créer un autre.',
	'smw_smwadmin_updatestopped' => 'Tous les processus de mise à jour ont été arrêtés.',
	'smw_smwadmin_updatenotstopped' => 'Par arrêter le processus en cours de mise à jour, vous devez cocher la case pour indiquer que vous en être vraiment sûr.',
	'smw_smwadmin_docu' => 'Cette page spéciale vous aide pendant l’installation et la mise à niveau de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
N’oubliez pas de sauvegarder les données avant les fonctions d’administration du site.',
	'smw_smwadmin_db' => 'Installation et mise à niveau de la base de donnée',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki requiert plusieurs extensions pour la base de donnée MediaWiki en ordre pour stocker les données de sémantique.
La fonction ci-dessous s’assure que votre base donnée a été proprement installée.
Les modifications faites lors de cette étape n’affecteront pas le reste de la base de donnée Mediawiki, et peut être défaite à volonté.
Cette fonction d’installation peut être lancée plusieurs fois sans causer le moindre dégats, mais une seule installation ou mise à niveau est nécessaire.',
	'smw_smwadmin_permissionswarn' => 'Si l’opération échoue avec des erreurs SQL, l’utilisateur de la base donnée utilisée par votre wiki, (regarder votre LocalSettings.php) risque probablement de ne pas avoir les permissions suffisantes.
Il faut soit permettre à cet utilisateur de disposer des permissions pour créer et supprimer les tables, soit entrer temporairement la connection en root à votre base de données dans le LocalSettings.php, soit utiliser le script de maintenance <tt>SMW_setup.php</tt> lequel peut utiliser les accréditations de AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Initialise les tables de mise à niveau',
	'smw_smwadmin_announce' => 'Annoncer votre wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki dispose d’un service internet pour annoncer des nouveaux sites wiki sémantiques.
Ceci est utilisé pour maintenir une liste des sites publiques utilisant Semantic MediaWiki, principalement pour aider <a href="http://semantic-mediawiki.org/wiki/SMW_Project">le projet Semantic MediaWiki</a> afin d’obtenir une vue d’ensemble des usages typiques de celui-ci.
Voyez la page d’accueil de Semantic MediaWiki <a href="http://semantic-mediawiki.org/wiki/Registry">de plus amples information concernant ce service</a>.',
	'smw_smwadmin_announcebutton' => 'Appuyer sur le bouton suivant pour soumettre l’adresse internet de votre wiki à ce service.
Le service n’enregistrera pas les wiki qui ne sont pas accessibles au public, et il ne stockera uniquement les informations publiquement accessibles.',
	'smw_smwadmin_datarefresh' => 'Réparation et mise à niveau des données',
	'smw_smwadmin_datarefreshdocu' => 'Il est possible de restaurer toutes les données Semantic MediaWiki basées sur les contenus courants de ce wiki.
Ceci peut être utile pour réparer des données cassées ou pour rafraichir les données si le format interne a changé lors des remises à niveau.
La mise à jour est exécutée page par page et se sera pas achevée immédiatement.
La page suivante affiche si une mise à jour est en cours d’exécution et vous permet de commencer ou d’arrêter celles-ci (à moins que cette fonctionnalié soit désactivée par l’administrateur du site).',
	'smw_smwadmin_datarefreshprogress' => 'Une mise à jour est en cours d’exécution.</b>
C’est normal qu’une mise à jour ne progresse lentement depuis qu’il rafraichit uniquement les données dans petits tronçons à chaque fois qu’un utilisateur accède au wiki.
Pour terminer cette mise à jour plus rapidement, vous pouvez invoquer le script de maintenance Mediawiki <tt>runJobs.php</tt> (utiliser l’option <tt>--maxjobs 1000</tt> pour restreindre le nombre des mises à jours par script lancé).
Progression estimée de la mise à jour actuelle :',
	'smw_smwadmin_datarefreshbutton' => 'Commencer la mise à jour des données',
	'smw_smwadmin_datarefreshstop' => 'Arrêter cette mise à jour',
	'smw_smwadmin_datarefreshstopconfirm' => 'Oui, j’en suis sûr.',
	'smw_smwadmin_support' => 'Obtention d’un support',
	'smw_smwadmin_supportdocu' => 'Diverses ressources pourraient vous aider en cas de problèmes :',
	'smw_smwadmin_installfile' => 'Si vous expérimentez des problème avec votre installation, commencer par regarder le guide en ligne dans le <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">fichier INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentation complète de l’utilisateur de Semantic MediaWiki se trouve sur <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Les bogues peuvent être soumis sur <a href="https://bugzilla.wikimedia.org/">MediaZilla</a>.',
	'smw_smwadmin_questions' => 'Vous avez d’autres questions ou des suggestion, rejoignez la discussion sur <a href="mailto:semediawiki-user@lists.sourceforge.net">semediawiki-user@lists.sourceforge.net</a>.',
);

/** Western Frisian (Frysk)
 * @author Snakesteuben
 */
$messages['fy'] = array(
	'smw_oi_action' => 'Ymportearje',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'smw_edithelp' => 'Axuda de edición nas propiedades',
	'smw_viewasrdf' => 'Fonte de noticias RDF',
	'smw_finallistconjunct' => 'e',
	'smw_factbox_head' => 'Feitos acerca de $1',
	'smw_isspecprop' => 'Esta propiedade é especial neste wiki.',
	'smw_isknowntype' => 'Este tipo está entre os tipos de datos deste wiki.',
	'smw_isaliastype' => 'Este tipo é un alias para o tipo de datos “$1”.',
	'smw_isnotype' => 'O tipo “$1” non é un tipo de datos estándar no wiki, e ningún usuario lle deu unha definición.',
	'smw_concept_description' => 'Descrición do concepto “$1”',
	'smw_no_concept_namespace' => 'O conceptos só poden ser definidos nas páxinas que están no espazo de nomes Concepto:.',
	'smw_multiple_concepts' => 'Cada páxina de conceptos só pode conter unha definición dun concepto.',
	'smw_concept_cache_miss' => 'O concepto "$1" non pode ser usado desde que a configuración do wiki o require para calcular a desconexión. Se o problema non se resolve en breve, pregúntelle ao administrador do wiki para que o concepto poida estar dispoñible.',
	'smw_baduri' => 'Sentímolo, os URIs da forma “$1” non están permitidos.',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendario',
	'smw_vcard_link' => 'vTarxeta',
	'smw_iq_disabled' => 'Sentímolo. As preguntas semánticas foron deshabilitadas para este wiki.',
	'smw_iq_moreresults' => '… máis resultados',
	'smw_iq_nojs' => 'Por favor, use un nevegador co JavaScript permitido para ver este elemento.',
	'smw_iq_altresults' => 'Procurar directamente pola lista de resultados.',
	'smw_unknown_importns' => 'As funcións de importación non están dispoñibles no espazo de nomes “$1”.',
	'smw_nonright_importtype' => '$1 só pode ser usado para as páxinas co espazo de nomes “$2”.',
	'smw_wrong_importtype' => '$1 non pode ser usado para as páxinas no espazo de nomes “$2”.',
	'smw_no_importelement' => 'O elemento “$1” non está dispoñible para importar.',
	'smw_parseerror' => 'O valor dado non foi entendido.',
	'smw_notitle' => '“$1” non pode ser usado como nome de páxina neste wiki.',
	'smw_wrong_namespace' => 'Aquí só están permitidas as páxinas no espazo de nomes "$1".',
	'smw_unknowntype' => 'Tipo “$1” non soportado definido para a propiedade.',
	'smw_manytypes' => 'Máis dun tipo definido para a propiedade.',
	'smw_emptystring' => 'As cordas baleiras non están aceptadas.',
	'smw_maxstring' => 'A representación da corda $1 é demasiado longa para {{SITENAME}}.',
	'smw_notinenum' => '“$1” non é a lista de posibles valores ($2) para esta propiedade.',
	'smw_noboolean' => '“$1” non é recoñecido como un valor booleano (verdadeiro/falso).',
	'smw_true_words' => 'verdadeiro,v,si,s',
	'smw_false_words' => 'falso,f,non,n',
	'smw_nofloat' => '“$1” non é un número.',
	'smw_infinite' => 'Os números tan longos como “$1” non están soportados en {{SITENAME}}.',
	'smw_infinite_unit' => 'A conversión na unidade “$1” deu como resultado un número que é moi grande para {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Os prefixos para os números (“$1”) non están soportados.',
	'smw_unsupportedunit' => 'Non está soportada a unidade de conversión para a unidade “$1”.',
	'smw_lonely_unit' => 'Non foi atopado ningún número antes do símbolo “$1”.',
	'smw_bad_latlong' => 'A latitude e mais a lonxitude deben darse só unha vez e con coordenadas válidas.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'Latitude:',
	'smw_label_longitude' => 'Lonxitude:',
	'smw_nodatetime' => 'A data “$1” non foi entendida.',
	'smw_toomanyclosing' => 'Parece que hai demasiados acontecementos de “$1” na pregunta.',
	'smw_noclosingbrackets' => 'Algún uso de “<nowiki>[[</nowiki>” na súa pregunta non foi pechado polo seu “]]” correspondente.',
	'smw_misplacedsymbol' => 'O símbolo “$1” foi usado nun lugar no que non era útil.',
	'smw_unexpectedpart' => 'A parte “$1” da pregunta non foi entendida.
Pode que os resultados non sexan os agardados.',
	'smw_emptysubquery' => 'Algunha subcuestión non ten unha condición válida.',
	'smw_misplacedsubquery' => 'Algunha subcuestión foi usada nun lugar onde non están permitidas.',
	'smw_valuesubquery' => 'As subcuestións non están soportadas para os valores da propiedade “$1”.',
	'smw_overprintoutlimit' => 'A pregunta contén demasiadas solicitudes de copias impresas.',
	'smw_badprintout' => 'Algunha declaración imprimida da pregunta non foi entendida.',
	'smw_badtitle' => 'Sentímolo, pero “$1” non é un título de páxina válido.',
	'smw_badqueryatom' => 'Unha parte “<nowiki>[[…]]</nowiki>” da pregunta non foi entendida.',
	'smw_propvalueproblem' => 'O valor da propiedade “$1” non foi entendido.',
	'smw_noqueryfeature' => 'Algunha característica da pregunta non está soportada neste wiki, polo que unha parte foi excluída ($1).',
	'smw_noconjunctions' => 'As conxuncións nas preguntas non están soportadas neste wiki, polo que unha parte foi excluída ($1).',
	'smw_nodisjunctions' => 'Non están soportadas as disxuncións nas preguntas neste wiki e parte desta foi ignorada ($1).',
	'smw_querytoolarge' => 'As seguintes condicións da pregunta non poden ser consideradas debido ás restricións do wiki no tamaño ou profundidade desta: $1.',
	'smw_devel_warning' => 'Actualmente esta característica está en desenvolvemento e pode que non funcione en toda a súa totalidade.
Faga unha copia de seguridade dos seus datos antes de usala.',
	'smw_notemplategiven' => 'Por favor, proporcione un valor para o parámetro “modelo” do formato desta pregunta para poder funcionar.',
	'smw_type_header' => 'Propiedades do tipo “$1”',
	'smw_typearticlecount' => 'Amosando $1 {{PLURAL:$1|propiedade|propiedades}} que {{PLURAL:$1|usa|usan}} este tipo.',
	'smw_attribute_header' => 'Páxinas que usan a propiedade “$1”',
	'smw_attributearticlecount' => 'Amosando $1 {{PLURAL:$1|páxina|páxinas}} que {{PLURAL:$1|usa|usan}} esta propiedade.',
	'smw_subproperty_header' => 'Subpropiedades',
	'smw_subpropertyarticlecount' => 'Esta propiedade ten {{PLURAL:$1|a seguinte subpropiedade|as seguintes $1 subpropiedades}}.',
	'smw_concept_header' => 'Páxinas do concepto "$1"',
	'smw_conceptarticlecount' => 'Amosando $1 {{PLURAL:$1|páxina|páxinas}} que {{PLURAL:$1|pertence|pertencen}} a ese concepto.',
	'exportrdf' => 'Exportar páxinas a RDF',
	'smw_exportrdf_docu' => '<p>Esta páxina permítelle obter datos dunha páxina en formato RDF.
Para exportar páxinas, insira os títulos na caixa de embaixo (un título por liña).</p>',
	'smw_exportrdf_recursive' => 'Exportar igualmente todas as páxinas relacionadas.
Déase conta de que o resultado pode ser longo!',
	'smw_exportrdf_backlinks' => 'Exportar tamén todas as páxinas que se refiren ás páxinas exportadas.
Xera un RDF que se pode navegar.',
	'smw_exportrdf_lastdate' => 'Non exportar páxina que non tiveron cambios desde a data dada.',
	'properties' => 'Propiedades',
	'smw_properties_docu' => 'As seguintes propiedades son usadas neste wiki.',
	'smw_property_template' => '$1 de tipo $2 ($3)',
	'smw_propertylackspage' => 'Todas as propiedades deberían estar descritas nunha páxina!',
	'smw_propertylackstype' => 'Non foi especificado ningún tipo para esta propiedade (asúmese o tipo $1 polo de agora).',
	'smw_propertyhardlyused' => 'Esta propiedade apenas é usada neste wiki!',
	'unusedproperties' => 'Propiedades non usadas',
	'smw_unusedproperties_docu' => 'As seguintes propiedades existen aínda que ningunha páxina faga uso delas.',
	'smw_unusedproperty_template' => '$1 de tipo $2',
	'wantedproperties' => 'Propiedades requiridas',
	'smw_wantedproperties_docu' => 'As seguintes propiedades son usadas no wiki pero aínda non teñen ningunha páxina que as describa.',
	'smw_wantedproperty_template' => '$1 ($2 usos)',
	'tooltip-purge' => 'Faga clic aquí para refrescar todas as dúbidas e modelos desta páxina',
	'smw_purge' => 'Refrescar',
	'ontologyimport' => 'Importar ontoloxías',
	'smw_oi_docu' => 'Esta páxina especial permite importar ontoloxías.
As ontoloxías teñen que seguir un certo formato, especificado na <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">páxina de axuda acerca das ontoloxías</a>.',
	'smw_oi_action' => 'Importar',
	'smw_oi_return' => 'Voltar a <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Non foi proporcionada ningunha ontoloxía ou non se pode cargar.',
	'smw_oi_select' => 'Por favor, seleccione as instrucións que quere importar e logo prema no botón "Importar".',
	'smw_oi_textforall' => 'Texto da cabeceira para engadir a todas as importacións (pode quedar baleiro):',
	'smw_oi_selectall' => 'Seleccionar ou cancelar a selección de todas as instrucións',
	'smw_oi_statementsabout' => 'Instrucións acerca de',
	'smw_oi_mapto' => 'Entidade do mapa a',
	'smw_oi_comment' => 'Engadir o seguinte texto:',
	'smw_oi_thisissubcategoryof' => 'Unha subcategoría de',
	'smw_oi_thishascategory' => 'É parte de',
	'smw_oi_importedfromontology' => 'Importar desde a ontoloxía',
	'types' => 'Tipos',
	'smw_types_docu' => 'O que segue é unha lista de todos os tipos de datos que poden ser asignados ás propiedades.
Cada tipo de datos ten unha páxina onde vén proporcionada información adicional sobre el.',
	'smw_typeunits' => 'Unidades de medida do tipo “$1”: $2',
	'semanticstatistics' => 'Estatísticas semánticas',
	'smw_semstats_text' => 'Este wiki contén <b>$1</b> valores de propiedade, dun total de <b>$2</b> <a href="$3">propiedades</a> diferentes.
<b>$4</b> propiedades teñen unha páxina propia e o tipo de datos desexado está especificado para <b>$5</b> de elas.
Algunhas das propiedades existentes poden <a href="$6">non ser usadas</a>.
As propiedades ás que aínda lles falta unha páxina atópanse na <a href="$7">lista de propiedades desexadas</a>.',
	'flawedattributes' => 'Propiedades defectuosas',
	'smw_fattributes' => 'As páxinas listadas embaixo teñen propiedades definidas incorrectamente.
O númeor de propiedades incorrectas está dado entre parénteses.',
	'uriresolver' => 'Solucionador de URI',
	'smw_uri_doc' => '<p>O solucionador de URI pon en práctica o <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">descubrimento da ETIQUETA de W3C en httpRange-14</a>. Vixía que os humanos non entren en sitios web.</p>',
	'ask' => 'Procura semántica',
	'smw_ask_sortby' => 'Ordenar por columnas (opcional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Atopar os resultados',
	'smw_ask_editquery' => '[Editar a pregunta]',
	'smw_add_sortcondition' => '[Engadir a condición da orde]',
	'smw_ask_hidequery' => 'Agochar a dúbida',
	'smw_ask_help' => 'Axuda sobre as dúbidas',
	'smw_ask_queryhead' => 'Dúbida',
	'smw_ask_printhead' => 'Copias impresas adicionais (opcional)',
	'searchbyproperty' => 'Procurar por propiedade',
	'smw_sbv_docu' => '<p>Procurar por todas as páxinas que teñen a propiedade e o valor dados.</p>',
	'smw_sbv_noproperty' => '<p>Por favor, insira unha propiedade.</p>',
	'smw_sbv_novalue' => '<p>Por favor, insira un valor válido para a propiedade ou vexa todos os valores das propiedades para “$1”.</p>',
	'smw_sbv_displayresult' => 'Unha lista de todas as páxinas que teñen a propiedade “$1” co valor “$2”',
	'smw_sbv_displayresultfuzzy' => 'Unha lista con todas as páxinas que teñen a propiedade "$1" co valor "$2".
Como houbo só uns poucos resultados, tamén os resultados próximos son amosados.',
	'smw_sbv_property' => 'Propiedades',
	'smw_sbv_value' => 'Valor',
	'smw_sbv_submit' => 'Atopar os resultados',
	'browse' => 'Navegar polo wiki',
	'smw_browselink' => 'Propiedades de navegación',
	'smw_browse_article' => 'Insira o nome da páxina para comezar o formulario de procura.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'amosar as propiedades que ligan cara a aquí',
	'smw_browse_hide_incoming' => 'agochar as propiedades que ligan cara a aquí',
	'smw_browse_no_outgoing' => 'Esta páxina non ten propiedades.',
	'smw_browse_no_incoming' => 'Ningunha propiedade liga con esta páxina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Lapela de propiedade inversa',
	'pageproperty' => 'Procura de páxinas de propiedades',
	'smw_pp_docu' => 'Procurar por todos os filtros dunha propiedade nunha páxina dada.
Por favor, insira ambas, a páxina e mais a propiedade.',
	'smw_pp_from' => 'Da páxina',
	'smw_pp_type' => 'Propiedades',
	'smw_pp_submit' => 'Atopar os resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Seguinte',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Sentímolo, non hai resultados.',
	'smwadmin' => 'Funcións do administrador Semantic MediaWiki',
	'smw_smwadmin_return' => 'Voltar a "$1"',
	'smw_smwadmin_datarefreshbutton' => 'Comezar a actualizar os datos',
	'smw_smwadmin_datarefreshstop' => 'Deter esta actualización',
	'smw_smwadmin_datarefreshstopconfirm' => 'Si, estou seguro.',
	'smw_smwadmin_support' => 'Obtendo asistencia',
	'smw_smwadmin_mediazilla' => 'Pode informar dos erros en <a href="https://bugzilla.wikimedia.org/">MediaZilla</a>.',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 */
$messages['grc'] = array(
	'smw_oi_action' => 'Εἰσάγειν',
	'smw_browse_go' => 'Ἱέναι',
);

/** Hebrew (עברית)
 * @author Udi Oron אודי אורון
 */
$messages['he'] = array(
	'smw_edithelp' => 'עזרה בנושא עריכת יחסים ותכונות',
	'smw_finallistconjunct' => ', וגם',
	'smw_factbox_head' => 'עובדות על אודות $1 &mdash; לחץ <span class="smwsearchicon">+</span> בכדי למצוא דפים דומים.',
	'smw_iq_moreresults' => '&hellip; תוצאות נוספות',
	'smw_unknowntype' => '[אופס! טיפוס לא מוכר "$1" הוגדר עבור תכונה זו]',
	'smw_manytypes' => '[אופס! הוגדר יותר מטיפוס אחד לתכונה זו]',
	'smw_emptystring' => '[אופס! לא ניתן להשתמש כאן במחרוזות ריקות]',
	'smw_maxstring' => '[מצטערת, ייצוג המחרוזת כ-$1 ארוך מדי עבור אתר זה.]',
	'smw_notinenum' => '[אופס! "$1" לא נמצא בערכים האפשריים ($2) לתכונה זו]',
	'smw_noboolean' => '[אופס! "$1" אינה תכונה מטיפוס נכון-לאנכון]',
	'smw_true_words' => 't,yes,y,כן,נכון,אמת,חיובי,כ',
	'smw_false_words' => 'f,no,n,לא,לא נכון,לא-נכון,שקר,שלישי,ל',
	'smw_nofloat' => '[אופס! "$1" אינו מספר מטיפוס נקודה צפה]',
	'smw_infinite' => '[מצטרת, $1 הוא מספר גדול מדי לאתר זה .]',
	'smw_infinite_unit' => '[מצטערת, תוצאת ההמרה ליחידה $1 היא מספר גדול מדי לאתר זה.]',
	'smw_unsupportedunit' => 'אין תמיכה להמרת יחידות לטיפוס "$1"',
	'smw_abb_north' => 'צפון',
	'smw_abb_east' => 'מזרח',
	'smw_abb_south' => 'דרום',
	'smw_abb_west' => 'מערב',
	'smw_label_latitude' => 'קו רוחב:',
	'smw_label_longitude' => 'קו אורך:',
	'smw_nodatetime' => '[אופס! התאריך "$1" אינו מובן. מצד שני התמיכה בתאריכים היא עדיין ניסיונית.]',
	'tooltip-purge' => 'לחץ כאן הכדי לרענן את כל התבניות והשאילתות בדף זה',
	'smw_purge' => 'רענן תבניות ושאילתות',
	'types' => 'טיפוסים',
	'smw_types_docu' => 'ברשימה זו מופיעים כל טיפוסי המידע שתכונות יכולות להשתמש בהם . לכל טיפוס מידע יש דף המסביר על אודותיו.',
	'ask' => 'חיפוש סמנטי',
	'smw_ask_sortby' => 'מיין לפי טור',
	'smw_ask_ascorder' => 'בסדר עולה',
	'smw_ask_descorder' => 'בסדר יורד',
	'smw_ask_submit' => 'חפש תוצאות',
	'smw_result_prev' => 'הקודם',
	'smw_result_next' => 'הבא',
	'smw_result_results' => 'תוצאות',
	'smw_result_noresults' => 'מצטערת, אין תוצאות',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'smw_edithelp' => 'गुणधर्मोंकी सहायता बदल रहें हैं',
	'smw_viewasrdf' => 'RDF फ़ीड',
	'smw_finallistconjunct' => ', और',
	'smw_factbox_head' => '$1 के बारेमें फ़ैक्ट्स',
	'smw_icalendar_link' => 'आइकैलेंडर',
	'smw_iq_moreresults' => '… आगे के रिज़ल्ट',
	'smw_true_words' => 'सही,t,हां,y',
	'smw_false_words' => 'गलत,f,ना,n',
	'smw_nofloat' => '“$1” यह संख्या नहीं हैं।',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'अक्षांश:',
	'smw_label_longitude' => 'रेखांश:',
	'smw_type_header' => '“$1” प्रकारके गुणधर्म',
	'properties' => 'गुणधर्म',
	'unusedproperties' => 'इस्तेमाल न किये हुए गुणधर्म',
	'smw_unusedproperty_template' => '$2 प्रकारके $1',
	'wantedproperties' => 'चाहिये होनेवाले गुणधर्म',
	'smw_oi_action' => 'आयात',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'smw_browse_go' => 'Lakat',
);

/** Croatian (Hrvatski)
 * @author Dalibor Bosits
 */
$messages['hr'] = array(
	'smw_oi_action' => 'Uvezi',
	'smw_browse_go' => 'Kreni',
);

/** Haitian (Kreyòl ayisyen)
 * @author Jvm
 * @author Masterches
 */
$messages['ht'] = array(
	'smw_edithelp' => 'Èd nan redaksyon pwopryete yo ak relasyon',
	'smw_viewasrdf' => 'Wè tankou fòma RDF',
	'smw_finallistconjunct' => ', epi',
	'smw_factbox_head' => 'Bagay an relasyon ak $1',
	'smw_isspecprop' => 'Pwopryete sa espesyal toutbon nan wiki sa',
	'smw_isknowntype' => 'Tip sa ap fè pati de tip done estanda nan wiki sa.',
	'smw_isaliastype' => 'Tip sa se yon alyas pou done "$1".',
	'smw_isnotype' => 'Tip "$1" sa pa yon tip estandè nan wiki a, li pa defini pa yon itilizatè tou.',
	'smw_baduri' => 'Eskize nou, URIs yo pou domèn "$1" pa otorize, oubyen li pa disponib nan plas isit la.',
	'smw_icalendar_link' => 'iKalandrye',
	'smw_iq_disabled' => 'Eskize nou. Rechèch nan atik wiki sa a pa otorize oubyen nou dezaktive l.',
	'smw_iq_moreresults' => '… lòt rezilta yo',
	'smw_iq_nojs' => 'Souple, itilize yon navigatè (bwozè entènèt) ki aksepte JavaScript aktive pou ou kapab wè eleman sa, bagay sa.',
	'smw_iq_altresults' => 'Fouye, gade lis rezilta yo dirèkteman.',
	'smw_unknown_importns' => 'Fonksyon pou ou kapab chaje fichye (rekipere pou ou menm) pa disponib pou espas non sa "$1".',
	'smw_nonright_importtype' => 'Ou dwe itilize eleman $1 sa sèlman pou paj ki genyen non espas sa "$2".',
	'smw_wrong_importtype' => '$1 pa dwe itilize pou paj ki nan non espas "$2".',
	'smw_no_importelement' => 'Eleman "$1" pa disponib pou rekipere, pou chaje.',
	'smw_parseerror' => 'Valè ou bay oubyen sa li retounen pa klè, nou pa kapab konprann li.',
	'smw_notitle' => 'Nou pa kapab itilize "$1" tankou non yon paj nan wiki sa.',
	'smw_unknowntype' => 'Tip done "$1" yo ki pa sipòte retounen nan atribi a.',
	'smw_manytypes' => 'Plizyè tip done pase  nan atribi.',
	'smw_emptystring' => 'Chèn mo ou bay an pa dwe vid.',
	'smw_maxstring' => 'Chèn reprezantasyon $1 an two long pou {{SITENAME}}.',
	'smw_notinenum' => '"$1" pa nan lis valè posib pou ($2) pou atribi, pwopryete a.',
	'smw_noboolean' => '"$1" pa rekonèt tankou yon valè bouleyen (vre/fo).',
	'smw_true_words' => 'vre,v,wi,w',
	'smw_false_words' => 'fo,f,non,n',
	'smw_nofloat' => '"$1" pa yon nonmb.',
	'smw_infinite' => 'Nonmb $1 an twò lon.',
	'smw_infinite_unit' => 'Konvèsyon inite pou $1 bay yon nonmb twò gran pou {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Prefiks pou nonmb ("$1") yo pa sipòte nan sistèm an.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'smw_edithelp' => 'Adjuta super le modification del proprietates',
	'smw_viewasrdf' => 'Syndication RDF',
	'smw_finallistconjunct' => ', e',
	'smw_factbox_head' => 'Factos super $1',
	'smw_isspecprop' => 'Iste proprietate es special in iste wiki.',
	'smw_isknowntype' => 'Iste typo es inter le typos de datos standard de iste wiki.',
	'smw_isaliastype' => 'Iste typo es un alias pro le typo de datos "$1".',
	'smw_isnotype' => 'Iste typo "$1" non es un typo de datos standard in le wiki, ni ha essite date a illo un definition de usator.',
	'smw_concept_description' => 'Description del concepto "$1"',
	'smw_no_concept_namespace' => 'Le conceptos pote solmente esser definite in paginas in le spatio de nomines Concept:.',
	'smw_multiple_concepts' => 'Cata pagina de concepto pote haber un sol definition de concepto.',
	'smw_concept_cache_miss' => 'Le concepto "$1" non pote esser usate al momento, post que le configuration del wiki require que illo sia computate foras de linea. Si le problema non dispare post alcun tempore, demanda al administrator de tu sito de render disponibile iste concepto.',
	'smw_baduri' => 'Le adresses URI del forma "$1" non es permittite.',
	'smw_rss_link' => 'RSS',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendar',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Le consultas semantic ha essite disactivate pro iste wiki.',
	'smw_iq_moreresults' => '… ulterior resultatos',
	'smw_iq_nojs' => 'Usa un navigator capace de executar JavaScript pro visualisar iste elemento.',
	'smw_iq_altresults' => 'Percurrer directemente le lista de resultatos.',
	'smw_unknown_importns' => 'Le functiones de importation non es disponibile pro le spatio de nomines de "$1".',
	'smw_nonright_importtype' => '$1 pote solmente esser usate pro paginas con le spatio de nomines "$2".',
	'smw_wrong_importtype' => '$1 non pote esser usate pro paginas in le spatio de nomines "$2".',
	'smw_no_importelement' => 'Le elemento "$1" non es disponibile pro importation.',
	'smw_parseerror' => 'Le valor date non esseva comprendite.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => '"$1" non pote esser usate como nomine de pagina in iste wiki.',
	'smw_unknowntype' => 'Typo non supportate "$1" definite pro proprietate.',
	'smw_manytypes' => 'Plus de un typo definite pro proprietate.',
	'smw_emptystring' => 'Series de characteres vacue non es acceptate.',
	'smw_maxstring' => 'Le representation de serie de characteres $1 es troppo longe pro {{SITENAME}}.',
	'smw_notinenum' => '"$1" non es in le lista de valores possibile ($2) pro iste proprietate.',
	'smw_noboolean' => '"$1" non es recognoscite como un valor boolean (ver/false).',
	'smw_true_words' => 'ver,v,si,s',
	'smw_false_words' => 'false,f,no,n',
	'smw_nofloat' => '"$1" non es un numero.',
	'smw_infinite' => 'Le numeros tanto grande como "$1" non es supportate in {{SITENAME}}.',
	'smw_infinite_unit' => 'Le conversion in unitate "$1" resultava in un numero troppo grande pro {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Le prefixos pro numeros ("$1") non es supportate.',
	'smw_unsupportedunit' => 'Le conversion del unitate "$1" non es supportate.',
	'smw_lonely_unit' => 'Nulle numero trovate ante le symbolo "$1".',
	'smw_bad_latlong' => 'Le latitude e longitude debe esser date solmente un vice, e con coordinatas valide.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'Latitude:',
	'smw_label_longitude' => 'Longitude:',
	'smw_nodatetime' => 'Le data "$1" non esseva comprendite.',
	'smw_toomanyclosing' => 'Il pare haber troppo de occurrentias de "$1" in le consulta.',
	'smw_noclosingbrackets' => 'Alcun uso de "<nowiki>[[</nowiki>" in tu consulta non esseva claudite per un correspondente "]]".',
	'smw_misplacedsymbol' => 'Le symbolo "$1" esseva usate in un loco ubi illo non es utile.',
	'smw_unexpectedpart' => 'Le parte "$1" del consulta non esseva comprendite.
Le resultatos pote non esser como expectate.',
	'smw_emptysubquery' => 'Alcun subconsulta ha nulle condition valide.',
	'smw_misplacedsubquery' => 'Alcun subconsulta esseva usate in un loco ubi nulle subconsultas es permittite.',
	'smw_valuesubquery' => 'Le subconsultas non es supportate pro valores del proprietate "$1".',
	'smw_overprintoutlimit' => 'Le consulta contine troppo de requestas "printout".',
	'smw_badprintout' => 'Alcun commando "print" in le consulta esseva mal formate.',
	'smw_badtitle' => '"$1" non es un titulo de pagina valide.',
	'smw_badqueryatom' => 'Alcun parte "<nowiki>[[…]]</nowiki>" del consulta non esseva comprendite.',
	'smw_propvalueproblem' => 'Le valor del proprietate "$1" non esseva comprendite.',
	'smw_noqueryfeature' => 'Alcun functionalitate de consulta non esseva supportate in iste wiki; un parte del consulta ha essite omittite ($1).',
	'smw_noconjunctions' => 'Le conjunctiones in consultas non es supportate in iste wiki; un parte del consulta ha essite ommittite ($1).',
	'smw_nodisjunctions' => 'Le disjunctiones in consultas non es supportate in iste wiki; un parte del consulta ha essite omittite ($1).',
	'smw_querytoolarge' => 'Le sequente conditiones de consulta non pote esseva considerate a causa del restrictiones de iste wiki concernente le grandor o profunditate del consultas: $1.',
	'smw_devel_warning' => 'Iste function es actualmente sub disveloppamento, e pote non esser completemente functional.
Face un copia de reserva de tu datos ante que tu lo usa.',
	'smw_notemplategiven' => 'Forni un valor pro le parametro "template" pro facer functionar iste formato de consulta.',
	'smw_type_header' => 'Proprietates del typo "$1"',
	'smw_typearticlecount' => 'Presentation de $1 {{PLURAL:$1|proprietate|proprietates}} que usa iste typo.',
	'smw_attribute_header' => 'Paginas que usa le proprietate "$1"',
	'smw_attributearticlecount' => 'Presentation de $1 {{PLURAL:$1|pagina|paginas}} que usa iste proprietate.',
	'smw_subproperty_header' => 'Subproprietates',
	'smw_subpropertyarticlecount' => 'Iste proprietate ha le sequente $1 {{PLURAL:$1|subproprietate|subproprietates}}.',
	'smw_concept_header' => 'Paginas del concepto "$1"',
	'smw_conceptarticlecount' => 'Presentation de $1 {{PLURAL:$1|pagina|paginas}} que appertine a ille concepto.',
	'smw_rss_description' => 'Syndication RSS de $1',
	'specialpages-group-smw_group' => 'MediaWiki semantic',
	'exportrdf' => 'Exportar paginas verso RDF',
	'smw_exportrdf_docu' => '<p>Iste pagina permitte obtener le datos de un pagina in formato RDF.
Pro exportar pagina, entra le titulos in le quadro de texto in basso, un titulo per linea.</p>',
	'smw_exportrdf_recursive' => 'Exportar recursivemente tote le paginas connexe.
Nota que le resultato pote esser grande!',
	'smw_exportrdf_backlinks' => 'Exportar equalmente tote le paginas con referentias al paginas exportate.
Genera un RDF navigabile.',
	'smw_exportrdf_lastdate' => 'Non exportar paginas que non esseva cambiate post le momento specificate.',
	'properties' => 'Proprietates',
	'smw_properties_docu' => 'Le sequente proprietates es usate in le wiki.',
	'smw_property_template' => '$1 del typo $2 ($3)',
	'smw_propertylackspage' => 'Tote le proprietates debe esser describite per un pagina!',
	'smw_propertylackstype' => 'Nulle typo esseva specificate pro iste proprietate (es assumite le typo $1 pro le momento).',
	'smw_propertyhardlyused' => 'Iste proprietate es a pena usate in iste wiki!',
	'unusedproperties' => 'Proprietates non usate',
	'smw_unusedproperties_docu' => 'Le sequente proprietates existe ben que nulle altere pagina los utilisa.',
	'smw_unusedproperty_template' => '$1 del typo $2',
	'wantedproperties' => 'Proprietates desirate',
	'smw_wantedproperties_docu' => 'Le sequente proprietates es uate in le wiki sed non ha ancora un pagina pro describer los.',
	'smw_wantedproperty_template' => '$1 ($2 usos)',
	'tooltip-purge' => 'Clicca hic pro refrescar tote le consultas e patronos in iste pagina',
	'smw_purge' => 'Refrescar',
	'ontologyimport' => 'Importar ontologia',
	'smw_oi_docu' => 'Iste pagina special permitte le importation de ontologias.
Le ontologias debe sequer un certe formato, specificate in le <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">pagina de adjuta pro le importation de ontologias</a>.',
	'smw_oi_action' => 'Importar',
	'smw_oi_return' => 'Retornar a <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Nulle ontologia fornite, o impossibile cargar le ontologia.',
	'smw_oi_select' => 'Selige le assertiones a importar, e postea clicca super le button Importar.',
	'smw_oi_textforall' => 'Texto de capite pro adder a tote le importationes (pote esser vacue):',
	'smw_oi_selectall' => 'Selige o disselige tote le assertiones',
	'smw_oi_statementsabout' => 'Assertiones super',
	'smw_oi_mapto' => 'Mappar entitate a',
	'smw_oi_comment' => 'Adder le sequente texto:',
	'smw_oi_thisissubcategoryof' => 'Un subcategoria de',
	'smw_oi_thishascategory' => 'Face parte de',
	'smw_oi_importedfromontology' => 'Importar ab ontologia',
	'types' => 'Typos',
	'smw_types_docu' => 'Lo sequente es un lista de tote le typos de datos assignabile a proprietates.
Cata typo de datos ha un pagina ubi informationes additional pote esser fornite.',
	'smw_typeunits' => 'Unitates de mesura del typo "$1": $2',
	'semanticstatistics' => 'Statisticas semantic',
	'smw_semstats_text' => 'Iste wiki contine <b>$1</b> valores de proprietate pro un total de <b>$2</b> diverse <a href="$3">proprietates</a>.
<b>$4</b> proprietates ha lor proprie paginas, e le typo de datos intendite es specificate pro <b>$5</b> de illos.
Alcunes del proprietates existente pote esser <a href="$6">proprietates non usate</a>.
Le proprietates al quales manca ancora un pagina se trova in le <a href="$7">lista de proprietates desirate</a>.',
	'flawedattributes' => 'Proprietates problematic',
	'smw_fattributes' => 'Le paginas listate infra ha un proprietate incorrectemente definite.
Le numero de proprietates incorrecte es date inter parentheses.',
	'uriresolver' => 'Resolvitor de URI',
	'smw_uri_doc' => '<p>Le resolvitor de URL implementa le <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">conclusion del Gruppo de Architectura Technic del W3C a proposito de httpRange-14</a>.
Illo assecura que le humanos non se transforma in sitos web.</p>',
	'ask' => 'Recerca semantic',
	'smw_ask_sortby' => 'Ordinar per columna (optional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Cercar resultatos',
	'smw_ask_editquery' => '[Modificar consulta]',
	'smw_add_sortcondition' => '[Adder condition de ordinamento]',
	'smw_ask_hidequery' => 'Celar consulta',
	'smw_ask_help' => 'Adjuta super le consultas',
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Listages additional (optional)',
	'searchbyproperty' => 'Cercar per proprietate',
	'smw_sbv_docu' => '<p>Cercar tote le paginas que ha un proprietate e valor date.</p>',
	'smw_sbv_noproperty' => '<p>Entra un proprietate.</p>',
	'smw_sbv_novalue' => '<p>Entra un valor valide pro le proprietate, o vide tote le valores possibile del proprietate "$1".</p>',
	'smw_sbv_displayresult' => 'Un lista de tote le paginas que ha le proprietate "$1" con valor "$2"',
	'smw_sbv_displayresultfuzzy' => 'Un lista de tote le paginas que ha le proprietate "$1" con valor "$2".
Post que il ha pauc resultatos, le valores proxime es equalmente monstrate.',
	'smw_sbv_property' => 'Proprietate',
	'smw_sbv_value' => 'Valor',
	'smw_sbv_submit' => 'Cercar resultatos',
	'browse' => 'Percurrer le wiki',
	'smw_browselink' => 'Percurrer proprietates',
	'smw_browse_article' => 'Entra le nomine del pagina ab le qual tu vole initiar le exploration.',
	'smw_browse_go' => 'Ir',
	'smw_browse_more' => '…',
	'smw_browse_show_incoming' => 'monstrar le proprietates con ligamines verso hic',
	'smw_browse_hide_incoming' => 'celar le proprietates con ligamines verso hic',
	'smw_browse_no_outgoing' => 'Iste pagina non ha proprietates.',
	'smw_browse_no_incoming' => 'Nulle proprietate ha un ligamine a iste pagina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiquetta de proprietate inverse',
	'pageproperty' => 'Recerca de proprietates de paginas',
	'smw_pp_docu' => 'Cercar tote le filtros de un proprietate in un pagina date.
Entra e un pagina e un proprietate.',
	'smw_pp_from' => 'Ab pagina',
	'smw_pp_type' => 'Proprietate',
	'smw_pp_submit' => 'Cercar resultatos',
	'smw_result_prev' => 'Precedente',
	'smw_result_next' => 'Sequente',
	'smw_result_results' => 'Resultatos',
	'smw_result_noresults' => 'Nulle resultato.',
	'smwadmin' => 'Functiones admin pro MediaWiki Semantic',
);

/** Indonesian (Bahasa Indonesia)
 * @author Rex
 */
$messages['id'] = array(
	'smw_result_noresults' => 'Tidak ada hasil yang dapat ditampilkan.',
);

/** Italian (Italiano)
 * @author Cruccone
 * @author Darth Kule
 * @author Davide Eynard, David Laniado
 * @author Pietrodn
 */
$messages['it'] = array(
	'smw_edithelp' => 'Aiuto sulla modifica delle propriet&agrave;',
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => ' e',
	'smw_factbox_head' => 'Fatti riguardanti $1',
	'smw_isspecprop' => "Questa propriet&agrave; &egrave; una propriet&agrave; speciale all'interno di questo wiki.",
	'smw_isknowntype' => 'Questo tipo &egrave; fra i tipi di dato standard di questo wiki',
	'smw_isaliastype' => 'Questo tipo &egrave; un alias per il tipo di dato “$1”.',
	'smw_isnotype' => "Il tipo “$1” non &egrave; un tipo di dato standard nel wiki, n&eacute; &egrave; stato ancora definito dall'utente.",
	'smw_concept_description' => 'Descrizione del concetto "$1"',
	'smw_no_concept_namespace' => 'I concetti possono essere definiti solo sulle pagine nel namespace Concept:.',
	'smw_multiple_concepts' => 'Ogni pagina concetto può avere una sola definizione di concetto.',
	'smw_concept_cache_miss' => 'Il concetto "$1" non può essere usato ora, siccome la configurazione della wiki richiede che sia elaborato off-line. Se il problema non si risolve dopo un po\' di tempo, chiedi all\'amministratore del tuo sito di rendere disponibile questo concetto.',
	'smw_baduri' => 'Spiacenti. Gli URI del tipo “$1” non sono consentiti.',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendar',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Spiacenti. Le query semantiche sono state disabilitate per questo wiki.',
	'smw_iq_moreresults' => '&hellip; risultati successivi',
	'smw_iq_nojs' => 'Per favore, usate un browser che supporti Javascript per visualizzare questo elemento.',
	'smw_iq_altresults' => "Visualizza direttamente l'elenco dei risultati.",
	'smw_unknown_importns' => 'Le funzioni di importazione non sono disponibili per il namespace “$1”.',
	'smw_nonright_importtype' => '$1 pu&ograve; essere utilizzato solo per pagine con namespace “$2”.',
	'smw_wrong_importtype' => '$1 non pu&ograve; essere utilizzate per pagine nel namespace “$2”.',
	'smw_no_importelement' => "L'elemento “$1” non &egrave; disponibile per l'importazione.",
	'smw_parseerror' => 'Il valore dato non è stato compreso.',
	'smw_notitle' => "“$1” non pu&ograve; essere utilizzato come nome di una pagina all'interno di questo wiki.",
	'smw_unknowntype' => '&Egrave; stato definito un tipo non supportato “$1” per la propriet&agrave;.',
	'smw_manytypes' => '&Egrave; stato definito pi&ugrave; di un tipo per la propriet&agrave;.',
	'smw_emptystring' => 'Le stringhe vuote non sono accettate.',
	'smw_maxstring' => 'La stringa $1 &egrave; troppo lunga per {{SITENAME}}.',
	'smw_notinenum' => '“$1” non &egrave; nella lista dei valori possibili ($2) per questa propriet&agrave;.',
	'smw_noboolean' => '“$1” non &egrave; riconosciuto come valore Booleano (vero/falso).',
	'smw_true_words' => 'vero,v,si,s,true,t,yes,y',
	'smw_false_words' => 'falso,f,no,n,false',
	'smw_nofloat' => '“$1” non &egrave; un numero.',
	'smw_infinite' => 'I numeri grandi come “$1” non sono supportati su {{SITENAME}}.',
	'smw_infinite_unit' => "La conversione nell'unit&agrave; di misura “$1” ha generato un numero che &egrave; troppo grande per {{SITENAME}}.",
	'smw_unsupportedprefix' => 'I prefissi per i numeri (“$1”) non sono supportati.',
	'smw_unsupportedunit' => "La conversione per l'unit&agrave; di misura “$1” non &egrave; supportata.",
	'smw_lonely_unit' => 'Non &egrave; stato trovato nessun numero prima del simbolo “$1”.',
	'smw_bad_latlong' => 'Latitudine e longitudine devono essere inserite solo una volta, e con coordinate valide.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'O',
	'smw_label_latitude' => 'Latitudine:',
	'smw_label_longitude' => 'Longitudine:',
	'smw_nodatetime' => 'Non &egrave; stato possibile comprendere la data “$1”.',
	'smw_toomanyclosing' => "Sembrano esserci troppe ripetizioni di “$1” all'interno della query.",
	'smw_noclosingbrackets' => 'Alcune "<nowiki>[[</nowiki>" all\'interno della query non sono state chiuse con le corrispondenti "]]".',
	'smw_misplacedsymbol' => 'Il simbolo “$1” &grave; stato usato in un punto in cui &egrave; inutile.',
	'smw_unexpectedpart' => 'Non &egrave; stato possibile comprendere la parte “$1” della query. Il risultato potrebbe essere diverso da quello atteso.',
	'smw_emptysubquery' => 'Qualche subquery ha una condizione non valida.',
	'smw_misplacedsubquery' => 'Qualche subquery &egrave; stata utilizzata in una posizione in cui non era consentito.',
	'smw_valuesubquery' => 'Le subquery non sono supportate per i valori della propriet&agrave; “$1”.',
	'smw_overprintoutlimit' => 'La query contiene troppe richieste di printout.',
	'smw_badprintout' => "Comando print malformato all'interno della query.",
	'smw_badtitle' => 'Spiacenti, “$1” non &egrave; un titolo valido.',
	'smw_badqueryatom' => 'Non è stato possibile comprendere parte "<nowiki>[[…]]</nowiki>" della query.',
	'smw_propvalueproblem' => 'Non &egrave; stato possibile comprendere il valore della propriet&agrave; “$1”.',
	'smw_noqueryfeature' => 'Qualche funzionalità di query non è stata supportata in questa wiki e parte della query è stata rimossa ($1).',
	'smw_noconjunctions' => 'Le congiunzioni nelle query non sono supportate in questa wiki e parte della query è stata rimossa ($1).',
	'smw_nodisjunctions' => "La disgiunzione all'interno delle query non &egrave; supportata in questo wiki, quindi parte della query &egrave; stata ignorata ($1).",
	'smw_querytoolarge' => "Le seguenti condizioni all'interno della query non sono state considerate a causa delle restrizioni di dimensione o profondit&agrave; delle query impostate per questo wiki: $1.",
	'smw_devel_warning' => 'Questa funzione &egrave; attualmente in fase di sviluppo e potrebbe non essere completamente funzionante: si consiglia di eseguire un backup dei dati prima di usarla.',
	'smw_notemplategiven' => 'Per favore fornisci un valore per il parametro "template" per far funzionare questo formato di query.',
	'smw_type_header' => 'Propriet&agrave; del tipo “$1”',
	'smw_typearticlecount' => 'Visualizzazione di $1 {{PLURAL:$1|proprietà|proprietà}} che usano questo tipo.',
	'smw_attribute_header' => 'Pagine che usano la propriet&agrave; “$1”',
	'smw_attributearticlecount' => 'Visualizzazione di $1 {{PLURAL:$1|pagina che usa|pagine che usano}} questa proprietà.',
	'smw_subproperty_header' => 'Sottoproprietà',
	'smw_subpropertyarticlecount' => 'Questa proprietà ha {{PLURAL:$1|la seguente|le seguenti $1}} sottoproprietà.',
	'smw_concept_header' => 'Pagine del concetto "$1"',
	'smw_conceptarticlecount' => 'Mostro {{PLURAL:$1|una pagina|$1 pagine}} appartenenti a quel concetto.',
	'exportrdf' => 'Esporta le pagine in RDF',
	'smw_exportrdf_docu' => '<p>Questa pagina consente di ottenere dati da una pagina in formato RDF. Per esportare delle pagine, inseritene i titoli nella casella di testo sottostante, un titolo per riga.</p>',
	'smw_exportrdf_recursive' => 'Esporta ricorsivamente tutte le pagine correlate. Nota: il risultato potrebbe essere molto grande!',
	'smw_exportrdf_backlinks' => 'Esporta anche le pagine che si riferiscono a quelle esportate. Genera un RDF navigabile.',
	'smw_exportrdf_lastdate' => 'Non esportare le pagine che non hanno sub&igrave;to modifiche dal momento specificato.',
	'properties' => 'Propriet&agrave;',
	'smw_properties_docu' => "Le seguenti propriet&agrave; sono utilizzate all'interno del wiki.",
	'smw_property_template' => '$1 di tipo $2 ($3)',
	'smw_propertylackspage' => 'Tutte le propriet&agrave; dovrebbero essere descritte da una pagina!',
	'smw_propertylackstype' => 'Non &egrave; stato specificato nessun tipo per questa propriet&agrave; (per il momento si suppone sia di tipo $1).',
	'smw_propertyhardlyused' => 'Questa propriet&agrave; non &egrave; quasi mai usata nel wiki!',
	'unusedproperties' => 'Propiet&agrave; non utilizzate',
	'smw_unusedproperties_docu' => "Le seguenti propriet&agrave; esistono nonostante nessun'altra pagina ne faccia uso.",
	'smw_unusedproperty_template' => '$1 di tipo $2',
	'wantedproperties' => 'Propriet&agrave; senza descrizione',
	'smw_wantedproperties_docu' => 'Le seguenti propriet&agrave; sono usate nel wiki ma non hanno ancora una pagina che le descriva.',
	'smw_wantedproperty_template' => '$1 ($2 usi)',
	'tooltip-purge' => 'Clicca qui per riaggiornare tutte le query e i template di questa pagina',
	'smw_purge' => 'Aggiorna',
	'ontologyimport' => 'Importa ontologia',
	'smw_oi_docu' => 'Questa pagina speciale permette di importare ontologie. Le ontologie devono seguire un certo formato, specificato nella <a href="http://semantic-mediawiki.org/index.php/Help:Ontology_import">pagina di aiuto per l\'importazione di ontologie (in inglese)</a>.',
	'smw_oi_action' => 'Importa',
	'smw_oi_return' => 'Ritorna a <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => "Nessuna ontologia fornita, o non &egrave; stato possibile caricare l'ontologia.",
	'smw_oi_select' => 'Per favore selezionare le asserzioni da importare, e poi cliccare il tasto di importazione.',
	'smw_oi_textforall' => 'Testo di intestazione da aggiungere a tutti gli import (pu&ograve; essere vuoto):',
	'smw_oi_selectall' => 'Seleziona o deseleziona tutte le asserzioni',
	'smw_oi_statementsabout' => 'Asserzioni su',
	'smw_oi_mapto' => 'Mappa entit&agrave; con',
	'smw_oi_comment' => 'Aggiungere il testo seguente:',
	'smw_oi_thisissubcategoryof' => 'Sottoclasse di',
	'smw_oi_thishascategory' => '&Egrave; parte di',
	'smw_oi_importedfromontology' => 'Importa da ontologia',
	'types' => 'Tipi',
	'smw_types_docu' => 'La seguente &egrave; una lista di tutti i tipi di dati che possono essere assegnati alle propiet&agrave;. Ogni tipo di dato ha una pagina dove si possono trovare informazioni aggiuntive.',
	'smw_typeunits' => 'Unit&agrave; di misura di tipo “$1”: $2',
	'semanticstatistics' => 'Statistiche Semantiche',
	'smw_semstats_text' => 'Questo wiki contiene <b>$1</b> valori di propriet&agrave; per un totale di <b>$2</b> differenti <a href="$3">propriet&agrave;</a>. <b>$4</b> propriet&agrave; hanno una propria pagina, e il tipo di dato inteso &egrave; specificato per <b>$5</b> di queste. Alcune delle propriet&agrave; esistenti possono essere <a href="$6">propriet&agrave; non utilizzate</a>.  Le propriet&agrave; che ancora non hanno una pagina si possono trovare nella <a href="$7">lista delle propriet&agrave; senza descrizione</a>.',
	'flawedattributes' => 'Propriet&agrave; scorrette',
	'smw_fattributes' => 'Le pagine elencate di seguito hanno una propriet&agrave; definita in modo non corretto. Il numero di propriet&agrave; incorrette &egrave; indicato fra parentesi.',
	'uriresolver' => 'Risolutore di URI',
	'smw_uri_doc' => '<p>Il risolutore di URI implementa il <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Fa in modo che gli esseri umani non diventino siti Web.',
	'ask' => 'Ricerca semantica',
	'smw_ask_sortby' => 'Ordina per colonna (opzionale)',
	'smw_ask_ascorder' => 'Crescente',
	'smw_ask_descorder' => 'Decrescente',
	'smw_ask_submit' => 'Trova risultati',
	'smw_ask_editquery' => '[Modifica query]',
	'smw_add_sortcondition' => '[Aggiungi condizione di ordinamento]',
	'smw_ask_hidequery' => 'Nascondi query',
	'smw_ask_help' => 'Help sulle query',
	'smw_ask_queryhead' => 'Interrogazione',
	'smw_ask_printhead' => 'Output aggiuntivi (opzionali)',
	'searchbyproperty' => 'Cerca per propriet&agrave;',
	'smw_sbv_docu' => '<p>Cerca tutte le pagine che hanno propriet&agrave; e valore specificati.</p>',
	'smw_sbv_noproperty' => '<p>Per favore inserire una propriet&agrave;.</p>',
	'smw_sbv_novalue' => '<p>Per favore inserire un valore valido per la propriet&agrave;, o visualizzare tutti i valori di propriet&agrave; per “$1.”</p>',
	'smw_sbv_displayresult' => 'Lista di tutte le pagine che hanno propriet&agrave; “$1” con valore “$2”',
	'smw_sbv_displayresultfuzzy' => 'Una lista di tutte le pagine che hanno la proprietà "$1" col valore "$2".
Siccome ci sono solo pochi risultati, sono visualizzati anche i valori vicini.',
	'smw_sbv_property' => 'Propriet&agrave;',
	'smw_sbv_value' => 'Valore',
	'smw_sbv_submit' => 'Trova risultati',
	'browse' => 'Esplora il wiki',
	'smw_browselink' => 'Sfoglia le proprietà',
	'smw_browse_article' => "Inserire il nome della pagina da cui iniziare l'esplorazione",
	'smw_browse_go' => 'Vai',
	'smw_browse_show_incoming' => 'mostra le proprietà che linkano qui',
	'smw_browse_hide_incoming' => 'nascondi le proprietà che linkano qui',
	'smw_browse_no_outgoing' => 'Questa pagina non ha proprietà.',
	'smw_browse_no_incoming' => 'Nessuna proprietà linka a questa pagina.',
	'smw_inverse_label_default' => '$1 di',
	'smw_inverse_label_property' => 'Etichetta della proprietà inversa',
	'pageproperty' => 'Ricerca propriet&agrave; della pagina',
	'smw_pp_docu' => 'Cerca tutti i valori che soddisfano una propriet&agrave; su una data pagina. Inserire sia la pagina sia la propriet&agrave;',
	'smw_pp_from' => 'Da pagina',
	'smw_pp_type' => 'Propriet&agrave;',
	'smw_pp_submit' => 'Trova risultati',
	'smw_result_prev' => 'Precedente',
	'smw_result_next' => 'Successivo',
	'smw_result_results' => 'Risultati',
	'smw_result_noresults' => 'Spiacenti, nessun risultato.',
	'smwadmin' => 'Funzioni amministrative per Semantic MediaWiki',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'smw_edithelp' => 'Pitulung panyuntingan ing sifat-sifat',
	'smw_viewasrdf' => 'RDF feed',
	'smw_finallistconjunct' => ', lan',
	'smw_factbox_head' => 'Fakta-fakta ngenani $1',
	'smw_isspecprop' => 'Sifat iki iku sawijining sifat kusus ing wiki iki.',
	'smw_isknowntype' => 'Jenis iki kalebu jenis baku data ing wiki iki.',
	'smw_isaliastype' => 'Jenis iki sawijining alias kanggo jenis data “$1”.',
	'smw_isnotype' => 'Jenis “$1” iki dudu sawijining jenis data baku ing wiki, lan uga ora diwènèhi sawijining définisi déning sang panganggo.',
	'smw_baduri' => 'Nuwun sèwu, URI awujud “$1” ora diidinaké.',
	'smw_icalendar_link' => 'iKalèndher',
	'smw_iq_disabled' => 'Nuwun sèwu. Kwéri sémantik kanggo wiki iki dipatèni.',
	'smw_iq_moreresults' => '… pituwas sabanjuré',
	'smw_iq_nojs' => 'Mangga nganggo sawijining panjlajah wèb JavaScript kanggo ndeleng unsur iki.',
	'smw_iq_altresults' => 'Sigra mirsani daftar pituwas.',
	'smw_unknown_importns' => 'Fungsi impor ora ana kanggo bilik nama “$1”.',
	'smw_nonright_importtype' => '$1 namung bisa dienggo ing kaca-kaca sajroning bilik nama “$2”.',
	'smw_wrong_importtype' => '$1 ora bisa dienggo ing kaca-kaca ing bilik nama “$2”.',
	'smw_no_importelement' => 'Unsur “$1” ora kasedyakaké kanggi diimpor.',
	'smw_parseerror' => 'Bijih sing diwènèhaké ora dimangertèni.',
	'smw_notitle' => '“$1” ora bisa dienggo minangka jeneng kaca ing wiki iki.',
	'smw_unknowntype' => 'Jenis “$1” sing ora disengkuyung, didéfinisi kanggo sifat.',
	'smw_manytypes' => 'Sifaté didéfinisi luwih saka sajenis.',
	'smw_emptystring' => 'Rangkéan kosong ora ditampa.',
	'smw_maxstring' => 'Réprésèntasi string $1 kedawan kanggo {{SITENAME}}.',
	'smw_notinenum' => '“$1” ora ana ing daftar bijih-bijih sing mungkin ($2) kanggo sifat iki.',
	'smw_noboolean' => '“$1” ora ditepungi minangka sawijining bijih Boolean (bener/salah).',
	'smw_true_words' => 'bener,t,ya,y',
	'smw_false_words' => 'salah,s,ora,o',
	'smw_nofloat' => '“$1” iku dudu angka.',
	'smw_infinite' => 'Angka sing gedhéné kaya "$1" ora disengkuyung ing {{SITENAME}}.',
	'smw_infinite_unit' => 'Konvèrsi menyang sijian utawa unit “$1” mituwasaké angka sing kegedhèn kanggo {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Préfiks kanggo angka-angka (“$1”) ora disengkuyung.',
	'smw_unsupportedunit' => 'Konvèrsi unit kanggo unit “$1” ora disengkuyung.',
	'smw_lonely_unit' => 'Ora ditemokaké angka sangarepé simbul “$1”.',
	'smw_bad_latlong' => 'Latituda lan longituda namung olèh diwènèhaké sapisan, lan mawa koordinat sing absah.',
	'smw_abb_north' => 'L',
	'smw_abb_east' => 'W',
	'smw_abb_south' => 'Kdl',
	'smw_abb_west' => 'Kln',
	'smw_label_latitude' => 'Latituda:',
	'smw_label_longitude' => 'Longituda:',
	'smw_nodatetime' => 'Tanggal “$1” ora dimangertèni.',
	'smw_toomanyclosing' => 'Katoné ana kakèhan “$1” sajroning kwéri.',
	'smw_noclosingbrackets' => 'Sawetara panrapan “<nowiki>[[</nowiki>” ing kwéri panjenengan ora ditutup déning “]]” sing cocog.',
	'smw_misplacedsymbol' => 'Simbul “$1” dienggo ing sawijining panggonan sing ora miguna.',
	'smw_unexpectedpart' => 'Bagéyan “$1” saka kwéri ora dimangertèni.
Pituwasé bisa-bisa ora kaya sing diarepaké.',
	'smw_emptysubquery' => 'Sawetara subkwéri ora nduwé kondisi absah.',
	'smw_misplacedsubquery' => 'Sawetara subkwéri dienggo ing panggonan sing ora diparengaké anané subkwéri.',
	'smw_valuesubquery' => 'Subkwéri ora disengkuyung kanggo bijih saka sifat “$1”.',
	'smw_overprintoutlimit' => 'Kwériné kakèhan ngandhut panyuwunan cithakan.',
	'smw_badprintout' => 'Sawetara déklarasi print sajroning kwéri formulasiné salah.',
	'smw_badtitle' => 'Nuwun sèwu, nanging "$1" iku dudu irah-irahan utawa judhul kaca sing absah.',
	'smw_badqueryatom' => 'Ora mudheng “<nowiki>[[…]]</nowiki>” sawetara bagéyan kwéri.',
	'smw_propvalueproblem' => 'Bijih sifat "$1" ora dimangertèni.',
	'smw_nodisjunctions' => 'Pamisahan ing kwéri ora disengkuyung ing wiki iki lan sabagéyan saka kwéri dadi dilirwakaké ($1).',
	'smw_querytoolarge' => 'Sarat kwéri sing kapacak ing ngisor iki ora bisa digalih amerga anané rèstriksi wiki ing ukuran utawa jeroné: $1.',
	'smw_devel_warning' => "Fitur iki saiki isih dikembangaké, lan mbok-menawa durung sakabèhé fungsional.
''Backup'' dhisik data panjenengan sadurungé nganggo fitur iki.",
	'smw_type_header' => 'Sifat-sifat saka jenis "$1"',
	'smw_typearticlecount' => 'Nuduhaké $1 sifat nganggo jenis iki.',
	'smw_attribute_header' => 'Kaca-kaca sing nganggo sifat “$1”',
	'smw_attributearticlecount' => 'Nuduhaké $1 kaca nganggo sifat iki.',
	'exportrdf' => 'Èkspor kaca-kaca menyang RDF',
	'smw_exportrdf_docu' => '<p>Kaca iki marengaké panjenengan kanggo olèh data saka sawijining kaca ing format RDF.
Kanggo ngèkspor kaca-kaca, mangga lebokna irah-irahan ing kothak tèks ing ngisor iki, sairah-irahan per baris.</p>',
	'smw_exportrdf_recursive' => 'Ngèkspor kabèh kaca sing ana gandhèngané minangka rékursif.
Pènget: pituwasé bisa gedhé!',
	'smw_exportrdf_backlinks' => 'Uga ngèkspor kabèh kaca ing ngrujuk ing kaca-kaca sing dièkspor.
Nggawé berkas RDF sing bisa dijlajah.',
	'smw_exportrdf_lastdate' => 'Aja ngèkspor kaca-kaca sing ora diowahi wiwit sawijining wektu tartamtu.',
	'properties' => 'Sifat-sifat',
	'smw_properties_docu' => 'Sifat-sifat ing ngisori iki dienggo ing wiki iki.',
	'smw_property_template' => '$1 saka jenis $2 ($3)',
	'smw_propertylackspage' => 'Kabèh sifat kudu didèskripsi déning sawijining kaca!',
	'smw_propertylackstype' => 'Ora ana jenis sing dispésifikasi kanggo sifat iki (ngasumsi jenis $1 kanggo saiki).',
	'smw_propertyhardlyused' => 'Sifat iki mèh ora dienggo sajroning wiki iki!',
	'unusedproperties' => 'Sifat-sifat sing ora dienggo',
	'smw_unusedproperties_docu' => 'Sifat-sifat sing kapacak iki ana, senadyan ora ana kaca liya sing nganggo.',
	'smw_unusedproperty_template' => '$1 saka jenis $2',
	'wantedproperties' => 'Sifat sing dipéngini',
	'smw_wantedproperties_docu' => 'Sifat-sifat iki dienggo ing wiki, nanging durung duwé kaca sing ndéskripsi.',
	'smw_wantedproperty_template' => '$1 (dienggo kaping $2)',
	'tooltip-purge' => 'Kliken ing kéné kanggo nganyari kabèh kwéri lan cithakan ing kaca iki',
	'smw_purge' => 'Anyarana',
	'ontologyimport' => 'Impor ontologi',
	'smw_oi_docu' => 'Kaca astaméwa iki marengaké panjenengan ngimpor ontologi.
Ontologi-ontologiné nanging kudu cocog karo sawijining format, ditrangaké ing <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">kaca pitulung impor ontologi</a>.',
	'smw_oi_action' => 'Impor',
	'smw_oi_return' => 'Bali menyang <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Ora mènèhi ontologi, utawa ora ngunggahaké ontologi.',
	'smw_oi_select' => 'Mangga milihen déklarasi endi sing arep diimpor, lan banjur klik tombol impor.',
	'smw_oi_textforall' => 'Tèks sirah kanggo nambah menyang kabèh impor (mbok-menawa kosong):',
	'smw_oi_selectall' => 'Pilih utawa batal-pilih kabèh déklarasi',
	'smw_oi_statementsabout' => 'Déklarasi perkara',
	'smw_oi_mapto' => 'Gandhèngna èntitas karo',
	'smw_oi_comment' => 'Tambah tèks iki:',
	'smw_oi_thisissubcategoryof' => 'Sawijining subkategori saka',
	'smw_oi_thishascategory' => 'Iku bagéyan saka',
	'smw_oi_importedfromontology' => 'Impor saka ontologi',
	'types' => 'Jenis-jenis',
	'smw_types_docu' => 'Ing ngisor iki kapacak sawijining daftar kabèh jenis data sing bisa ditunjukaké menyang sifat-sifat.
Saben jenis data duwé kaca ing ngendi informasi tambahan bisa diwènèhaké.',
	'smw_typeunits' => 'Unit-unit pangukuran jenis “$1”: $2',
	'semanticstatistics' => 'Statistik sémantik',
	'smw_semstats_text' => 'Wiki iki ngemot <b>$1</b> bijih-bijih sifat kanggo gunggungé <b>$2</b> <a href="$3">sifat-sifat</a> sing béda-béda.
<b>$4</b> sifat duwé kaca dhéwé, lan jenis data sing dimaksud iku dispésifikasi kanggo <b>$5</b> saka iku.
Sawetara saka sifat sing ana mbok-menawa <a href="$6">sifat sing ora dienggo</a>.
Sifat-sifat sing isih ora duwé kaca ditemokaké ing <a href="$7">daftar sifat-sifat sing dipèngèni</a>.',
	'flawedattributes' => 'Sifat-sifaté Ora Pepak',
	'smw_fattributes' => 'Kaca-kaca sing kapacak ing ngisor iki duwé sifat sing didéfinisi ora bener.
Cacahé sifat sing ora bener iki diwènèhaké antara tandha kurung.',
	'uriresolver' => 'URI Resolver',
	'smw_uri_doc' => "<p>''URI resolver''-é ngimplèmèntasi <a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG finding on httpRange-14</a>. Iku ngurusi supaya manungsa ora owah lan dadi situs-situs wèb.</p>",
	'ask' => 'Panggolèkan sémantik',
	'smw_ask_sortby' => 'Sortir miturut kolom (opsional)',
	'smw_ask_ascorder' => 'Munggah saka ngisor menyang ndhuwur',
	'smw_ask_descorder' => 'Mudhun saka ndhuwur menyang ngisor',
	'smw_ask_submit' => 'Pituwas panggolèkan',
	'smw_ask_editquery' => '[Sunting kwéri]',
	'smw_add_sortcondition' => '[Tambah sarat nyortir]',
	'smw_ask_hidequery' => 'Delikna kwéri',
	'smw_ask_help' => 'Pitulung kwéri',
	'smw_ask_queryhead' => 'Kwéri',
	'smw_ask_printhead' => 'Cithakan tambahan (opsional)',
	'searchbyproperty' => 'Golèk miturut sifat',
	'smw_sbv_docu' => '<p>Golèk kabèh kaca sing duwé sifat lan bijih tartamtu.</p>',
	'smw_sbv_noproperty' => '<p>Mangga lebokna sawijining sifat.</p>',
	'smw_sbv_novalue' => '<p>Mangga lebokna bijih absah kanggo sifat iki, utawa tuduhna kabèh bijih-bijihé sifat kanggo “$1.”</p>',
	'smw_sbv_displayresult' => 'Sawijining daftar kabèh kaca sing duwé sifat “$1” mawa bijih “$2”',
	'smw_sbv_property' => 'Sifat',
	'smw_sbv_value' => 'Bijih (nilai)',
	'smw_sbv_submit' => 'Golèk pituwas (kasil)',
	'browse' => 'Jlajaha wiki',
	'smw_browse_article' => 'Lebokna irah-irahan kaca sing arep didadèkaké kaca awal olèhé panjenengan njlajah-njlajah.',
	'smw_browse_go' => 'Tumuju',
	'pageproperty' => 'Panggolèkan sifat kaca',
	'smw_pp_docu' => 'Nggolèki kabèh pangisi sawijining sifat ing sawijining kaca.
Tulung isèkna loro-loroné sawijining kaca lan sifat.',
	'smw_pp_from' => 'Saka kaca',
	'smw_pp_type' => 'Sifat',
	'smw_pp_submit' => 'Pituwas panggolèkan',
	'smw_result_prev' => 'Sadurungé',
	'smw_result_next' => 'Sabanjuré',
	'smw_result_results' => 'Pituwas (kasil)',
	'smw_result_noresults' => 'Nuwun sèwu, ora ana pituwasé (kasilé).',
);

/** Georgian (ქართული)
 * @author Malafaya
 */
$messages['ka'] = array(
	'smw_finallistconjunct' => ', და',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Lovekhmer
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'smw_finallistconjunct' => 'និង',
	'smw_label_latitude' => 'រយះទទឹង៖',
	'smw_label_longitude' => 'រយះបណ្តោយ៖',
	'smw_oi_action' => 'នាំចូល',
	'types' => 'ប្រភេទ',
	'smw_ask_ascorder' => 'លំដាប់ឡើង',
	'smw_ask_descorder' => 'លំដាប់ចុះ',
	'smw_ask_submit' => 'ស្វែងរកលទ្ធផល',
	'smw_sbv_value' => 'តំលៃ',
	'browse' => 'រាវរកវិគី',
	'smw_browse_go' => 'ទៅ',
	'smw_pp_from' => 'ពីទំព័រ',
	'smw_pp_submit' => 'ស្វែងរកលទ្ធផល',
	'smw_result_prev' => 'មុន',
	'smw_result_next' => 'បន្ទាប់',
	'smw_result_results' => 'លទ្ធផល',
	'smw_result_noresults' => 'សូមអភ័យទោស! មិនមានលទ្ធផលទេ។',
);

/** Korean (한국어)
 * @author Albamhandae
 */
$messages['ko'] = array(
	'smw_edithelp' => '도움말을 수정하려면 속성을',
	'smw_viewasrdf' => '으로 볼 rdf',
	'smw_finallistconjunct' => ', 그리고',
	'smw_factbox_head' => '사실에 대한 $1',
	'smw_isspecprop' => '이 속성은이 위키는 특별한 속성입니다.',
	'smw_isknowntype' => '이 유형은 표준 데이터 형식의들 사이에이 위키.',
	'smw_isaliastype' => '이 유형은 데이터의 별칭을 “$1”.',
	'smw_isnotype' => '이 유형이 “$1” 아닌 표준 데이터 형식은 위키가, 그리고 사용자 정의를 부여하지 않았습니다.',
	'smw_baduri' => '죄송합니다, uri의 범위에서 “$1” 해당 장소에서 사용할 수 없다.',
	'smw_iq_disabled' => '죄송합니다. 이 위키에 대한 의미 론적 검색어가 해제되었습니다.',
	'smw_iq_moreresults' => '&hellip; 다른 경기 결과',
	'smw_iq_nojs' => '자바 스크립트 - 활성화된 브라우저를 사용하는이 요소를 참조하거나, 직접 <a href="$1">찾아보기 결과 목록</a>.',
	'smw_unknown_importns' => '져올 네임 스페이스를 사용할 수있는 기능이없습니다 “$1”.',
	'smw_nonright_importtype' => '$1 페이지에 대해서만 사용할 수있습니다 네임 스페이스 “$2”.',
	'smw_wrong_importtype' => '$1 페이지에 대해 사용할 수없습니다 네임 스페이스 “$2”.',
	'smw_no_importelement' => '원소 “$1” 에 사용할 수없습니다 져올.',
	'smw_notitle' => '“$1” 대한 이름으로 사용하실 수없습니다이 위키는 페이지입니다.',
	'smw_unknowntype' => '지원되지 않는 종류 “$1” 정의에 대한 속성을.',
	'smw_manytypes' => '하나 이상의 속성에 대한 정의를 입력합니다.',
	'smw_emptystring' => '빈 문자열은 허용되지 않습니다.',
	'smw_maxstring' => '문자열 표현 $1 이 너무 긴이 사이트에 대한.',
	'smw_notinenum' => '“$1” 이 아닙니다의 목록에서이 속성능한 값 ($2) 에 대한.',
	'smw_noboolean' => '“$1” 가 인식되지 않습니다으로 부울 (참 / 거짓) 값.',
	'smw_true_words' => '참,예,진정한',
	'smw_false_words' => '거짓,아니오',
	'smw_nofloat' => '“$1” 이 아닌 숫자입니다.',
	'smw_infinite' => '숫자와 대형으로 “$1” 는 지원되지 않습니다이 사이트에서.',
	'smw_infinite_unit' => '전환으로 단위를 “$1” 결과는이 사이트에 대한 숫자가 너무 큽니다.',
	'smw_unsupportedprefix' => '접두사에 대한 숫자("$1")는 지원되지 않습니다.',
	'smw_unsupportedunit' => '단위 변환에 대한 단위를 “$1” 이 지원되지 않습니다.',
	'smw_lonely_unit' => '전에 번호를 찾을 수 없음을 상징 “$1”.',
	'smw_bad_latlong' => '위도와 경도를 한 번만 부여해야합니다, 그리고 올바른 좌표와 함께합니다.',
	'smw_abb_north' => '북',
	'smw_abb_east' => '동부',
	'smw_abb_south' => '남쪽',
	'smw_abb_west' => '서부',
	'smw_label_latitude' => '위도:',
	'smw_label_longitude' => '경도:',
	'smw_nodatetime' => '의 날짜 “$1” 는 이해할 수 없다.',
	'smw_toomanyclosing' => '이 쿼리에서 사용하는 표현이 “$1” 너무 많은 시간입니다.',
	'smw_noclosingbrackets' => '일부의 사용 "[[" 검색어에 의해 폐쇄되지 않았습니다 매칭 "]]".',
	'smw_misplacedsymbol' => '의 상징 "$1" 이전에 사용하는 장소에 유용 않다.',
	'smw_unexpectedpart' => '이 부분은 "$1" 의 쿼리는 이해할 수 없다. 결과가 예상대로되지 않을 수도있습니다.',
	'smw_emptysubquery' => '특정 쿼리 조건이없습니다.',
	'smw_misplacedsubquery' => '등장하는 장소에서 하위 쿼리 질의를 사용할 수 없음.',
	'smw_valuesubquery' => '의 속성에 대한 값을 질의를 지원하지 않습니다 “$1”.',
	'smw_overprintoutlimit' => '쿼리에 너무 많은 인쇄를 요청합니다.',
	'smw_badprintout' => '검색어에 인쇄 성명 커보였다.',
	'smw_badtitle' => '죄송하지만, "$1" 이 올바르지 않습니다 페이지 이름입니다.',
	'smw_badqueryatom' => '일부 “[&#x005B;&hellip;]]” 의 쿼리는 식별할 수없는.',
	'smw_propvalueproblem' => '의 값은 속성 "$1" 는 이해할 수 없다',
	'smw_nodisjunctions' => '진술과 함께 "또는" 이 검색어는이 위키에서 지원되지 않습니다하고 검색어의 일부를 제외했습니다 ($1).',
	'smw_querytoolarge' => '다음과 같은 검색어를 조건을 초과 쿼리 크기에 대한 제한이 위키 또는 깊이: $1.',
	'smw_devel_warning' => '이 기능은 현재 개발, 그리고 의도한대로 작동하지 않을 수도있습니다. 을 만들어야합니다은 위키의 데이터를 저장하기 전에이를 사용합니다.',
	'smw_type_header' => '등록 정보의 유형 “$1”',
	'smw_typearticlecount' => '이 유형을 사용하여 보여주 $1 의 등록 정보를합니다.',
	'smw_attribute_header' => '페이지를 사용하여 속성이 “$1”',
	'smw_attributearticlecount' => '이 속성을 사용하여 보여주 $1 페이지입니다.',
	'exportrdf' => '수출에 페이지를 RDF',
	'smw_exportrdf_docu' => '<p>이 페이지를 사용하면 RDF 포맷의 페이지에서 데이터를 구하려합니다. 을 수출 페이지, 아래 텍스트 상자에 제목을 입력을 한 줄에 제목입니다.</p>',
	'smw_exportrdf_recursive' => '재귀적으로 모든 관련 페이지에 수출합니다. 참고 사항이 될 결과에 큰!',
	'smw_exportrdf_backlinks' => '또한 내보낸 페이지를 참조하는 모든 페이지 내보내기합니다. 일람 RDF를 생성합니다.',
	'smw_exportrdf_lastdate' => '수출하지 마십시오하는 페이지가 주어진 시점 이후에 변경되지 않았습니다.',
	'properties' => '등록 정보',
	'smw_properties_docu' => '위키에 다음과 같은 속성을하는 데 사용됩니다.',
	'smw_property_template' => '$1 달러의 유형 $2 ($3)',
	'smw_propertylackspage' => '등록 정보를 모두 한 페이지에 의해 설명해야한다!',
	'smw_propertylackstype' => '이 속성에 대해 지정된 유형이었다 없음 (정하면 종류 $1 에 대한 현재).',
	'smw_propertyhardlyused' => '이 속성은 거의 사용 내에있는 위키!',
	'unusedproperties' => '사용하지 않는 속성을',
	'smw_unusedproperties_docu' => '다음과 같은 속성이 존재 다른 페이지를 활용합니다 비록 그들이없습니다.',
	'smw_unusedproperty_template' => '$1 달러의 유형 $2',
	'wantedproperties' => '원하는 속성을',
	'smw_wantedproperties_docu' => '위키에서 사용되는 다음과 같은 속성이 있지만 아직없는 그들을 설명하는 페이지입니다.',
	'smw_wantedproperty_template' => '$1 ($2 사용)',
	'tooltip-purge' => '여기를 클릭하여이 페이지를 새로 고치 모든 쿼리와 템플릿',
	'smw_purge' => '새로 고침',
	'ontologyimport' => '져올 존재론',
	'smw_oi_docu' => '이 특별 페이지를 통해를가 져올 존재론. 가 존재론 필요가 다음과 일정한 형식, 지정된 부분에 <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import"> 존재론 져올 도움말 페이지 </a>.',
	'smw_oi_action' => '져올',
	'smw_oi_return' => '돌아 <a href="$1"> 스페셜 : 존재론져올</a>.',
	'smw_oi_noontology' => '아니오 존재론 제공하거나 로드할 수없습니다 존재론.',
	'smw_oi_select' => '문장을 선택하십시오를가 져올을 누른가 져오기 버튼을 클릭하십시오.',
	'smw_oi_textforall' => '헤더 텍스트를 추가 모든 수입 (수있습니다 빈):',
	'smw_oi_selectall' => '모든 문장을 선택하거나 선택을 해제',
	'smw_oi_statementsabout' => '제표에 대한',
	'smw_oi_mapto' => '지도 사업체에',
	'smw_oi_comment' => '다음 텍스트를 추가:',
	'smw_oi_thisissubcategoryof' => '하위 카테고리 중',
	'smw_oi_thishascategory' => '의 일부인',
	'smw_oi_importedfromontology' => '에서가 져올 존재론',
	'types' => '유형',
	'smw_types_docu' => '다음은 목록에있는 모든 데이터를 속성을 할당할 수있습니다. 각 데이터 형식이있는 페이지가 어디에 추가 정보를 제공할 수있습니다.',
	'smw_typeunits' => '측정 단위의 유형 “$1”: $2',
	'semanticstatistics' => '의미 론적 통계',
	'smw_semstats_text' => '이 위키를 포함 <b>$1</b> 속성에 대한 값을 총 <b>$2</b> 서로 다른 <a href="$3">등록 정보</a>입니다. <b>$4</b> 속성을 갖고 자신의 페이지를, 그리고 의도에 대한 데이터 형식이 지정되어 <b>$5</b>의 해당합니다. 기존의 등록 정보의 일부에 의해 수도 <a href="$6">사용하지 않는 속성을 </a>입니다. 속성이 여전히 부족에서 찾을 수있는 페이지는 <a href="$7">목록은 싶었다 등록 정보 </a>입니다.',
	'flawedattributes' => '결함 속성',
	'smw_fattributes' => '아래에 나열된 페이지를 잘못 정의된 속성을 갖고있습니다. 잘못된 속성의 개수가 주어질 브래킷에있습니다.',
	'uriresolver' => '열린우리당 확인자',
	'smw_uri_doc' => '<p>열린우리당 확인자 <a href="http://www.w3.org/2001/tag/issues.html#httprange-14"> w3c 태그를 구현합니다 규명에 httprange-14</a>입니다. 인간을 치료하는 데 걸리는 웹사이트로 나타나지 않습니다.</p>',
	'ask' => '의미 론적 검색',
	'smw_ask_sortby' => '열로 정렬',
	'smw_ask_ascorder' => '오름차순',
	'smw_ask_descorder' => '내림차순',
	'smw_ask_submit' => '검색 결과 찾기',
	'searchbyproperty' => '검색을 통해 재산',
	'smw_sbv_docu' => '<p>주어진 속성이있는 모든 페이지를 검색 및 값입니다.</p>',
	'smw_sbv_noproperty' => '<p>한 속성을 입력하세요.</p>',
	'smw_sbv_novalue' => '<p>유효한 값을 입력하시기 바랍니다의 재산, 또는 내용에 대한 모든 속성 값을 “$1.”</p>',
	'smw_sbv_displayresult' => '모든 페이지의 목록이있는 속성이 "$1" 와 값 “$2”',
	'smw_sbv_property' => '부동산',
	'smw_sbv_value' => '값',
	'smw_sbv_submit' => '검색 결과 찾기',
	'browse' => '위키 뉴스',
	'smw_browse_article' => '페이지의 이름을 입력하여 검색을 시작합니다.',
	'smw_browse_go' => '바둑',
	'pageproperty' => '검색 페이지에서 등록 정보에서',
	'smw_pp_docu' => '검색에 대한 모든 fillers의 속성이 주어진 페이지에서입니다. 한 페이지와 속성을 모두 입력하시기 바랍니다.',
	'smw_pp_from' => '페이지에서',
	'smw_pp_type' => '부동산',
	'smw_pp_submit' => '검색 결과 찾기',
	'smw_result_prev' => '이전',
	'smw_result_next' => '내년',
	'smw_result_results' => '결과',
	'smw_result_noresults' => '죄송합니다, 결과가없습니다.',
);

/** Krio (Krio)
 * @author Jose77
 */
$messages['kri'] = array(
	'smw_browse_go' => 'Go to am',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'smw_browse_go' => 'Agto',
);

/** Ripoarisch (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'smw_finallistconjunct' => ', un',
	'smw_csv_link' => 'CSV',
	'smw_true_words' => 'wohr,wor,woo,woh,wo,w,j,jo,joh,true,t,yes,y',
	'smw_false_words' => 'verkiehrt,verkihrt,verkirt,verkeht,verkeet,verket,vokiehrt,vokihrt,vokirt,vokeht,vokeet,voket,ferkiehrt,ferkihrt,ferkirt,ferkeht,ferkeet,ferket,fokiehrt,fokihrt,fokirt,fokeht,fokeet,foket,fallsch,falsch,näh,nää,nä,false,f,no,n',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'O',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_browse_go' => 'Loß Jonn!',
	'smw_result_next' => 'Wigger',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'smw_finallistconjunct' => ', an',
	'smw_factbox_head' => 'Fakten iwwer $1',
	'smw_concept_description' => 'Beschreiwung vum Konzept "$1"',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iKalenner',
	'smw_iq_moreresults' => '… weider Resultater',
	'smw_iq_nojs' => 'Benotzt w.e.g e Browser matt JavaScript fir dëst Element ze gesinn',
	'smw_nonright_importtype' => '$1 kann nëmme fir Säiten am Nummraum "$2" benotzt ginn.',
	'smw_wrong_importtype' => '$1 kann net fir Säiten am Nummraum "$2" benotzt ginn.',
	'smw_no_importelement' => 'D\'Element "$1" kann net importéiert ginn.',
	'smw_notitle' => '"$1" kann net als Numm vun enger Säit op dëser Wiki benotzt ginn.',
	'smw_wrong_namespace' => 'Nëmme Säiten aus dem Nummraum "$1" sinn hei erlaabt.',
	'smw_emptystring' => 'Eidel Zeeche ginn net akzeptéiert.',
	'smw_true_words' => 'wouer,w,jo,j',
	'smw_false_words' => 'falsch,f,neen,n',
	'smw_nofloat' => '"$1" ass keng Zuel.',
	'smw_infinite' => 'Zuelen esou grouss wéi "$1" ginn op {{SITENAME}} net ënnerstetzt.',
	'smw_lonely_unit' => 'Virum Symbol "$1" gouf keng Zuel fonnt.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'O',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'Geografesch Breet:',
	'smw_label_longitude' => 'Geografesch Längt:',
	'smw_misplacedsymbol' => 'D\'Symbol "$1" gouf op ener Plaz benotzt wou et net nëtzlech ass.',
	'smw_badtitle' => 'Pardon, awer "$1" ass kee gëltegen Titel vun enger Säit.',
	'smw_attribute_header' => 'Säiten déi d\'Eegeschaft "$1" benotzen',
	'smw_concept_header' => 'Säite vum Konzept "$1"',
	'exportrdf' => 'Säiten als RDF exportéieren',
	'properties' => 'Eegeschaften',
	'smw_properties_docu' => 'Dës Eegeschafte ginn op dëser Wiki benotzt.',
	'smw_property_template' => '$1 vum Typ $2 ($3)',
	'unusedproperties' => 'Onbenotzen Eegeschaften',
	'smw_unusedproperty_template' => '$1 vum Typ $2',
	'wantedproperties' => 'Gewënschten Eegeschaften',
	'smw_wantedproperty_template' => '$1 ($2 mol benotzt)',
	'smw_purge' => 'Aktualiséieren',
	'smw_oi_action' => 'Importéieren',
	'smw_oi_statementsabout' => 'Texter iwwer',
	'smw_oi_comment' => 'Dësen Text derbäisetzen',
	'smw_oi_thisissubcategoryof' => 'Ënnerkategorie vu(n)',
	'smw_oi_thishascategory' => 'Ass een Deel vu(n)',
	'types' => 'Typen',
	'semanticstatistics' => 'Semantesch Statistiken',
	'ask' => 'Semantesch Sich',
	'smw_ask_submit' => 'Resultater sichen',
	'smw_ask_editquery' => '[Ufro änneren]',
	'smw_ask_hidequery' => 'Ufro verstoppen',
	'smw_ask_queryhead' => 'Ufro',
	'searchbyproperty' => 'No Eegeschafte sichen',
	'smw_sbv_property' => 'Eegeschaft',
	'smw_sbv_value' => 'Wert',
	'smw_sbv_submit' => 'Resultater sichen',
	'smw_browse_go' => 'Lass',
	'smw_browse_no_outgoing' => 'Dës Säit huet keng Eegeschaften',
	'smw_inverse_label_default' => '$1 vu(n)',
	'pageproperty' => 'An den Eegeschafte vun der Säit sichen',
	'smw_pp_from' => 'Vun der Säit',
	'smw_pp_type' => 'Eegeschaft',
	'smw_pp_submit' => 'Resultater sichen',
	'smw_result_prev' => 'Vireg',
	'smw_result_next' => 'Nächst',
	'smw_result_results' => 'Resultater',
	'smw_result_noresults' => 'Pardon, et gouf näischt fonnt.',
	'smw_smwadmin_return' => 'Zréck op $1',
	'smw_smwadmin_datarefreshstop' => 'Dësn Update stoppen',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jo, ech si sécher.',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'smw_finallistconjunct' => 'ഉം',
	'smw_factbox_head' => '$1നെ കുറിച്ചുള്ള സത്യങ്ങള്‍',
	'smw_icalendar_link' => 'iകലണ്ടര്‍',
	'smw_iq_moreresults' => '… കൂടുതല്‍ ഫലങ്ങള്‍',
	'smw_iq_nojs' => 'ഈ എലമെന്റ് കാണുവാന്‍ ദയവായി ജാവാസ്ക്രിപ് എനേബിള്‍ ചെയ്ത ബ്രൗസര്‍ ഉപയോഗിക്കുക.',
	'smw_unknown_importns' => 'ഇറക്കുമതി ഫങ്ങ്ഷന്‍സ് “$1” എന്ന നേംസ്പേസില്‍ ലഭ്യമല്ല.',
	'smw_nonright_importtype' => '“$2” എന്ന നേംസ്പേസിലുള്ള താളുകളില്‍ മാത്രമേ $1 ഉപയോഗിക്കാന്‍ പറ്റൂ.',
	'smw_wrong_importtype' => '“$2” എന്ന നേംസ്പേസിലുള്ള താളുകളില്‍ $1 ഉപയോഗിക്കുവാന്‍ പറ്റില്ല.',
	'smw_parseerror' => 'താങ്കള്‍ ചേര്‍ത്ത മൂല്യം മനസ്സിലാക്കാന്‍ സാധിച്ചില്ല.',
	'smw_true_words' => 'ശരി,ശരി,അതെ,അതെ',
	'smw_false_words' => 'തെറ്റ്,തെറ്റ്,അല്ല,അല്ല',
	'smw_nofloat' => '“$1” ഒരു സംഖ്യയല്ല.',
	'smw_infinite' => '“$1” എന്ന സംഖ്യയുടെയത്ര വലിപ്പമുള്ള സംഖ്യകള്‍ {{SITENAME}} സം‌രംഭത്തില്‍ പിന്‍‌താങ്ങുന്നില്ല.',
	'smw_unsupportedunit' => '“$1” എന്ന ഏകകത്തിന്റെ ഏകകമാറ്റം പിന്‍‌താങ്ങുന്നില്ല.',
	'smw_lonely_unit' => '“$1” എന്ന ചിഹ്നത്തിനു മുന്‍പ് സംഖ്യകള്‍ കണ്ടില്ല.',
	'smw_abb_north' => 'വടക്ക്',
	'smw_abb_east' => 'കിഴക്ക്',
	'smw_abb_south' => 'തെക്ക്',
	'smw_abb_west' => 'പടിഞ്ഞാറ്‌',
	'smw_label_latitude' => 'അക്ഷാംശം:',
	'smw_label_longitude' => 'രേഖാംശം:',
	'smw_misplacedsymbol' => '“$1” എന്ന ചിഹ്നം അതു ഉപയോഗിക്കാന്‍ പാടില്ലാത്ത ഒരു സ്ഥലത്ത് ഉപയോഗിച്ചിരിക്കുന്നു.',
	'smw_badtitle' => 'ക്ഷമിക്കണം, “$1”  എന്നതു സാധുവായൊരു തലക്കെട്ട് അല്ല.',
	'exportrdf' => 'RDFലേക്ക് താളുകള്‍ എക്സ്‌പോര്‍ട്ട് ചെയ്യുക',
	'smw_wantedproperty_template' => '$1 ($2 ഉപയോഗങ്ങള്‍)',
	'smw_oi_action' => 'ഇറക്കുമതി',
	'smw_oi_thisissubcategoryof' => '-ന്റെ ഉപവിഭാഗം',
	'smw_oi_thishascategory' => '-ന്റെ ഭാഗമാണ്‌',
	'types' => 'തരങ്ങള്‍',
	'smw_ask_ascorder' => 'ആരോഹണം',
	'smw_ask_descorder' => 'അവരോഹണം',
	'smw_ask_submit' => 'ഫലങ്ങള്‍ കാണുക',
	'smw_sbv_value' => 'മൂല്യം',
	'smw_sbv_submit' => 'ഫലങ്ങള്‍ കാണുക',
	'browse' => 'വിക്കിയില്‍ പരതുക',
	'smw_browse_go' => 'പോകൂ',
	'smw_pp_from' => 'ഈ താളില്‍ നിന്ന്',
	'smw_pp_submit' => 'ഫലങ്ങള്‍ കാണുക',
	'smw_result_prev' => 'മുമ്പത്തെ',
	'smw_result_next' => 'അടുത്തത്',
	'smw_result_results' => 'ഫലങ്ങള്‍',
	'smw_result_noresults' => 'ക്ഷമിക്കുക, ഫലങ്ങള്‍ ഒന്നുമില്ല',
);

/** Marathi (मराठी)
 * @author Kaustubh
 */
$messages['mr'] = array(
	'smw_edithelp' => 'गुणधर्मांवरील मदत संपादा',
	'smw_viewasrdf' => 'RDF फीड',
	'smw_finallistconjunct' => ', व',
	'smw_factbox_head' => '$1 च्या फॅक्ट्स',
	'smw_isspecprop' => 'हा गुणधर्म या विकिवरील विशेष गुणधर्म आहे.',
	'smw_isknowntype' => 'हा प्रकार या विकिवरील ठराविक डाटा प्रकारांपैकी एक आहे.',
	'smw_isaliastype' => 'हा प्रकार “$1” या डाटाप्रकारची पुनरुक्ती आहे.',
	'smw_isnotype' => 'हा  “$1” प्रकार या विकिवरील ठराविक डाटा प्रकारांपैकी नाही, व त्याची सदस्य व्याख्या सुद्धा दिलेली नाही.',
	'smw_baduri' => 'माफ करा, “$1” अर्जाचे URI वापरण्यास परवानगी नाही.',
	'smw_icalendar_link' => 'इ-कैलेंडर',
	'smw_iq_disabled' => 'माफ करा. या विकिवर सिमँटिक पॄच्छा करण्यास बंदी आहे.',
	'smw_iq_moreresults' => '… पुढचे निकाल',
	'smw_iq_nojs' => 'हा एलेमेंट पाहण्यासाठी जावास्क्रीप्ट युक्त ब्राउजर वापरा.',
	'smw_iq_altresults' => 'थेट निकाल यादी चाळा.',
	'smw_unknown_importns' => '“$1” या नामविश्वासाठी आयात कार्ये उपलब्ध नाहीत.',
	'smw_nonright_importtype' => '$1 हे फक्त “$2” या नामविश्वातील पानांसाठीच वापरता येते.',
	'smw_wrong_importtype' => '$1 हे “$2” या नामविश्वातील पानांसाठी वापरता येत नाही.',
	'smw_no_importelement' => '“$1” हा एलेमेंट आयातीसाठी उपलब्ध नाही.',
	'smw_parseerror' => 'दिलेली किंमत समजलेली नाही.',
	'smw_notitle' => 'या विकिवर “$1” हे पानाच्या शीर्षकात वापरता येत नाही.',
	'smw_unknowntype' => 'गुणधर्माचा प्रकार “$1” वापरता येत नाही.',
	'smw_manytypes' => 'गुणधर्माला एकापेक्षा जास्त प्रकार दिलेले आहेत.',
	'smw_emptystring' => 'रिकाम्या किंमती वापरता येत नाहीत.',
	'smw_maxstring' => '{{SITENAME}} साठी $1 हे स्ट्रींग रिप्रेझेंटेशन खूप लांब आहे.',
	'smw_notinenum' => 'या गुणधर्माच्या योग्य किंमतींच्या ($2) यादीत “$1” नाही आहे.',
	'smw_noboolean' => '“$1” ही योग्य बुलियन (बरोबर/चूक) किंमत नाही.',
	'smw_true_words' => 'बरोबर,t,हो,y',
	'smw_false_words' => 'चूक,f,नाही,n',
	'smw_nofloat' => '“$1” ही संख्या नाही.',
	'smw_infinite' => '{{SITENAME}} वर “$1” एवढ्या मोठ्या संख्या वापरता येत नाहीत.',
	'smw_infinite_unit' => '“$1” एककात बदल केल्यानंतर येणारी संख्या ही {{SITENAME}} वर वापरता येण्यासारख्या संख्यांपेक्षा खूप मोठी आहे.',
	'smw_unsupportedprefix' => 'संख्या (“$1”) साठी उपपदे वापरता येत नाहीत.',
	'smw_unsupportedunit' => '“$1” हे एकक बदलता येत नाही.',
	'smw_lonely_unit' => '“$1” चिन्हाच्या आधी कुठलीही संख्या सापडली नाही.',
	'smw_bad_latlong' => 'अक्षांश व रेखांश फक्त एकदाच देता येतील, ते सुद्धा योग्य किंमतींसकट.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'अक्षांश:',
	'smw_label_longitude' => 'रेखांश:',
	'smw_nodatetime' => '“$1” हा दिनांक समजला नाही.',
	'smw_toomanyclosing' => 'या पृच्छेमध्ये “$1” खूप ठिकाणी आलेले आहे.',
	'smw_noclosingbrackets' => 'तुमच्या पृच्छेत कुठेतरी वापरलेले “<nowiki>[[</nowiki>” हे योग्य अशा जुळणार्‍या “]]” ने बंद केलेले नाही.',
	'smw_misplacedsymbol' => '“$1” चिन्ह जिथे उपयोगी नाही अशा ठिकाणी वापरलेले आहे.',
	'smw_unexpectedpart' => 'पृच्छेचा “$1” हा भाग समजलेला नाही.
निकाल योग्य असतीलच याची खात्री नाही.',
	'smw_emptysubquery' => 'कुठल्यातरी उपपृच्छेमध्ये योग्य कंडिशन दिलेली नाही.',
	'smw_misplacedsubquery' => 'एक उपपृच्छा अशा ठिकाणी दिलेली आहे जिथे उपपृच्छा वापरायला परवानगी नाही.',
	'smw_valuesubquery' => '“$1” गुणधर्माच्या किंमतींसाठी उपपृच्छा वापरता येत नाहीत.',
	'smw_overprintoutlimit' => 'या पृच्छेमध्ये खूप जास्त प्रिंट विनंत्या आहेत.',
	'smw_badprintout' => 'या पृच्छेमधील काही प्रिंट मागण्या अयोग्य प्रकारे दिलेल्या आहेत.',
	'smw_badtitle' => 'माफ करा, पण “$1” हे योग्य पानाचे शीर्षक नाही.',
	'smw_badqueryatom' => 'पृच्छेचा काही भाग “<nowiki>[[…]]</nowiki>” समजलेला नाही.',
	'smw_propvalueproblem' => '“$1” गुणधर्माची किंमत समजलेली नाही.',
	'smw_nodisjunctions' => 'पृच्छे मध्ये तुकडे या विकिवर चालत नाहीत, त्यामुळे पृच्छेचा तुकडा टाकून दिला  ($1).',
	'smw_querytoolarge' => 'पृच्छेचा आकार अथवा खोलीवर असणार्‍या ह्या विकिवरील मर्यादांमुळे खालील पृच्छा अटी लक्षात घेता आलेल्या नाहीत: $1.',
	'smw_devel_warning' => 'हे फिचर सध्या प्रायोगिक अवस्थेत आहे, आणि कदाचित त्यामुळे पूर्णपणे काम करणार नाही.
कृपया तुमचा डाटा वापरण्यापूर्वी त्याची प्रत करून ठेवा.',
	'smw_type_header' => '“$1” प्रकारचे गुणधर्म',
	'smw_typearticlecount' => 'हा प्रकार वापरणारे $1 गुणधर्म दाखवित आहे.',
	'smw_attribute_header' => '“$1” गुणधर्म वापरणारी पृष्ठे',
	'smw_attributearticlecount' => 'हा गुणधर्म वापरणारी $1 पाने दाखवित आहे..',
	'smw_rss_description' => '$1 आरएसएस फीड',
	'specialpages-group-smw_group' => 'सिमँटिक मीडियाविकि',
	'exportrdf' => 'RDF कडे पाने निर्यात करा',
	'smw_exportrdf_docu' => '<p>हे पान तुम्हाला एखाद्या पानावरील मजकूर RDF मध्ये घेण्यास मदत करते.
पाने निर्यात करण्याकरीता, खाली एका ओळीत एक याप्रमाणे पानांची शीर्षके लिहा.</p>',
	'smw_exportrdf_recursive' => 'सर्व जुळलेली पाने आपोआप निर्यात करा.
कृपया नोंद घ्या की निकाल खूप मोठा असू शकतो!',
	'smw_exportrdf_backlinks' => 'निर्यात केलेल्या पानांचे संदर्भ देणारी पाने सुद्धा निर्यात करा.
ब्राउजेबल RDF तयार होईल.',
	'smw_exportrdf_lastdate' => 'दिलेल्या वेळेनंतर ज्या पानांमध्ये बदल झालेले नाहीत अशी पाने निर्यात करू नका.',
	'properties' => 'गुणधर्म',
	'smw_properties_docu' => 'या विकिवर खालील गुणधर्म वापरलेले आहेत.',
	'smw_property_template' => '$2 प्रकारची $1 ($3)',
	'smw_propertylackspage' => 'एका पानावर सर्व गुणधर्मांची माहिती असणे आवश्यक आहे!',
	'smw_propertylackstype' => 'या गुणधर्माचा प्रकार दिलेला नाही (आत्तापुरता $1 हा प्रकार गृहीत धरत आहे).',
	'smw_propertyhardlyused' => 'या विकिवर हा गुणधर्म क्वचितच वापरला जातो!',
	'unusedproperties' => 'न वापरलेले गुणधर्म',
	'smw_unusedproperties_docu' => 'खालील गुणधर्म कुठल्याही पानावर वापरण्यात आलेले नाहीत.',
	'smw_unusedproperty_template' => '$2 प्रकारचे $1',
	'wantedproperties' => 'पाहिजे असलेले गुणधर्म',
	'smw_wantedproperties_docu' => 'या विकिवर वापरण्यात आलेल्या खालील गुणधर्मांसाठी माहिती पृष्ठे अस्तित्वात नाहीत.',
	'smw_wantedproperty_template' => '$1 ($2 वापरतो)',
	'tooltip-purge' => 'या पानावरील सर्व साचे व पृच्छा ताज्या-तवान्या करण्यासाठी इथे टिचकी द्या',
	'smw_purge' => 'ताजेतवाने करा',
	'ontologyimport' => 'ऑन्टोलॉजी आयात करा',
	'smw_oi_docu' => 'हे विशेष पृष्ठ ओन्टोलोजी आयात करण्याची परवानगी देते.
ओन्टोलोजी एका विशिष्ट रुपरेशेत असणे आवश्यक आहे, जी रुपरेषा <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">ओन्टोलोजी आयात माहिती पृष्ठ</a> इथे दिलेली आहे.',
	'smw_oi_action' => 'आयात',
	'smw_oi_return' => '<a href="$1">Special:OntologyImport</a> कडे परत जा.',
	'smw_oi_noontology' => 'कुठलीही ओन्टोलोजी दिलेली नाही, किंवा लोड करू शकलेलो नाही.',
	'smw_oi_select' => 'कृपया आयात करण्यासाठीची स्टेटमेंट्स निवडा, व आयात कळीवर टिचकी द्या.',
	'smw_oi_textforall' => 'सर्व आयातींमध्ये वाढविण्यासाठी हेडर मजकूर (रिकामा चालेल):',
	'smw_oi_selectall' => 'सर्व स्टेटमेंट्स निवडा किंवा निवड काढून टाका',
	'smw_oi_statementsabout' => 'स्टेटमेंट्स अबाउट',
	'smw_oi_mapto' => 'एन्टिटी ला मप करा',
	'smw_oi_comment' => 'खालील मजकूर वाढवा:',
	'smw_oi_thisissubcategoryof' => 'चा उपवर्ग',
	'smw_oi_thishascategory' => 'चा भाग आहे',
	'smw_oi_importedfromontology' => 'ओन्टोलोजी मधून आयात करा',
	'types' => 'प्रकार',
	'smw_types_docu' => 'खाली गुणधर्माशी जोडता येणार्‍या सर्व डाटा प्रकारांची यादी आहे.
प्रत्येक डाटा प्रकाराचे एक पाने आहे जिथे जास्तीची माहिती देता येईल.',
	'smw_typeunits' => '“$1” प्रकारची मापनाची एकके: $2',
	'semanticstatistics' => 'सिमँटिक सांख्यिकी',
	'smw_semstats_text' => 'ह्या विकिमध्ये <b>$1</b> गुणधर्मांच्या किंमती आहेत ज्या एकूण <b>$2</b> वेगवेगळ्या <a href="$3">गुणधर्म</a> दर्शवितात.
<b>$4</b> गुणधर्मांना स्वत:ची पाने आहेत, व त्यापैकी <b>$5</b> गुणधर्मांना जुळणारे डाटा प्रकार दिलेले आहेत.
यातील काही गुणधर्म हे <a href="$6">न वापरलेले गुणधर्म</a> असण्याची शक्यता आहे.
ज्या गुणधर्मांना स्वत:चे पान नाही असे गुणधर्म <a href="$7">पाहिजे असलेल्या गुणधर्मांची यादी</a> मध्ये सापडतील.',
	'flawedattributes' => 'चुकीचे गुणधर्म',
	'smw_fattributes' => 'खाली दिलेल्या यादीतील पानांना चुकीचे गुणधर्म आहेत.
चुकीच्या गुणधर्मांची संख्या कंसात दिलेली आहे.',
	'uriresolver' => 'URI रिजल्व्हर',
	'smw_uri_doc' => '<p>URI रिझॉल्वर मध्ये एक <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C टॅग आहे जो httpRange-14 शोधण्यास मदत करतो</a>. हा मनुष्यप्राणी संकेतस्थळामध्ये बदलणार नाही याची काळजी घेतो.</p>',
	'ask' => 'सिमंटिक शोध',
	'smw_ask_sortby' => 'रकान्या प्रमाणे लावा (वैकल्पिक)',
	'smw_ask_ascorder' => 'चढत्या श्रेणीने',
	'smw_ask_descorder' => 'उतरत्या श्रेणीने',
	'smw_ask_submit' => 'निकाल शोधा',
	'smw_ask_editquery' => '[पृच्छा संपादा]',
	'smw_add_sortcondition' => '[लावण्याची अट वाढवा]',
	'smw_ask_hidequery' => 'पृच्छा लपवा',
	'smw_ask_help' => 'पृच्छा करण्यासाठी मदत',
	'smw_ask_queryhead' => 'पॄच्छा',
	'smw_ask_printhead' => 'जास्तीच्या छापील प्रती (वैकल्पिक)',
	'searchbyproperty' => 'गुणधर्माप्रमाणे शोधा',
	'smw_sbv_docu' => '<p>दिलेला गुणधर्म व किंमत असणारी सर्व पाने शोधा.</p>',
	'smw_sbv_noproperty' => '<p>कृपया एक गुणधर्म द्या.</p>',
	'smw_sbv_novalue' => '<p>कृपया या गुणधर्माची एक योग्य किंमत द्या, किंवा “$1” साठीच्या सर्व किंमती पहा.</p>',
	'smw_sbv_displayresult' => 'गुणधर्म  “$1” व त्याची किंमत “$2” असणार्‍ सर्व पानांची यादी',
	'smw_sbv_property' => 'गुणधर्म',
	'smw_sbv_value' => 'किंमत',
	'smw_sbv_submit' => 'निकाल शोधा',
	'browse' => 'विकि न्याहाळा',
	'smw_browse_article' => 'विकि ज्या पानापासून न्याहाळायचा त्या पानाचे नाव लिहा',
	'smw_browse_go' => 'चला',
	'pageproperty' => 'पान गुणधर्म शोध',
	'smw_pp_docu' => 'दिलेल्या पानावरील एखाद्या गुणधर्माच्या सर्व किंमतींचा शोध घ्या.
कृपया पान व गुणधर्म दोन्ही द्या.',
	'smw_pp_from' => 'पानावरून',
	'smw_pp_type' => 'गुणधर्म',
	'smw_pp_submit' => 'निकाल शोधा',
	'smw_result_prev' => 'मागील',
	'smw_result_next' => 'पुढील',
	'smw_result_results' => 'निकाल',
	'smw_result_noresults' => 'माफ करा, निकाल नाहीत.',
);

/** Maltese (Malti)
 * @author Roderick Mallia
 */
$messages['mt'] = array(
	'smw_result_prev' => "Ta' qabel",
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'smw_abb_north' => 'Веньэльйонкс',
	'smw_abb_east' => 'Чилисемайонкс',
	'smw_abb_south' => 'Чиньэльйонкс',
	'smw_abb_west' => 'Чивалгомайонкс',
	'smw_label_latitude' => 'Келезэ:',
	'smw_label_longitude' => 'Кувалмозо:',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'smw_abb_north' => 'M',
	'smw_abb_east' => 'T',
	'smw_abb_south' => 'H',
	'smw_abb_west' => 'C',
	'smw_oi_action' => 'Tiquicōhuāz',
	'smw_browse_go' => 'Yāuh',
	'smw_result_prev' => 'Achtopa',
	'smw_result_next' => 'Niman',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'smw_edithelp' => 'Bewerkingshulp bij eigenschappen',
	'smw_viewasrdf' => 'RDF-feed',
	'smw_finallistconjunct' => ', en',
	'smw_factbox_head' => 'Feiten over $1',
	'smw_isspecprop' => 'Dit is een speciale eigenschap in de wiki.',
	'smw_isknowntype' => 'Dit is een standaard gegevenstype in deze wiki.',
	'smw_isaliastype' => 'Dit type is een alias voor het gegevenstype "$1".',
	'smw_isnotype' => 'Het type "$1" is geen standaard gegevenstype in deze wiki. Er is ook nog geen gebruikersdefinitie voor opgegeven.',
	'smw_concept_description' => 'Beschrijving van het concept "$1"',
	'smw_no_concept_namespace' => "Concepten kunnen alleen gedefinieerd worden op pagina's in de naamruimte Concept:",
	'smw_multiple_concepts' => 'Iedere conceptpagina kan maar één conceptdefinitie bevatten.',
	'smw_concept_cache_miss' => 'Het concept "$1" kan op het moment niet gebruikt worden omdat de dit volgende de instellingen van de wiki offline berekend moet worden.
Als het probleem over enige tijd nog niet verholpen is, vraag de beheerder dan om dit concept beschikbaar te maken.',
	'smw_baduri' => "URI's uit de reeks “$1” zijn hier niet beschikbaar.",
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendar',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Zoekopdrachten binnen tekst zijn uitgeschakeld in deze wiki.',
	'smw_iq_moreresults' => '… overige resultaten',
	'smw_iq_nojs' => 'Gebruiker een browser waarin JavaScript is ingeschakeld om dit element te zien.',
	'smw_iq_altresults' => 'De resultatenlijst direct bekijken',
	'smw_unknown_importns' => 'Importfuncties zijn niet beschikbaar voor de naamruimte “$1”.',
	'smw_nonright_importtype' => "$1 kan alleen gebruikt worden voor pagina's in de naamruimte “$2”.",
	'smw_wrong_importtype' => "$1 kan niet gebruikt worden in pagina's in de naamruimte “$2”.",
	'smw_no_importelement' => 'Element “$1” is niet beschikbaar voor import.',
	'smw_parseerror' => 'De opgegeven waarde is niet begrepen.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" kan niet gebruikt worden als paginanaam.',
	'smw_wrong_namespace' => 'Hier zijn alleen pagina\'s uit de naamruimte "$1" toegestaan.',
	'smw_unknowntype' => 'Type “$1” is niet beschikbaar voor de gedefinieerde eigenschap.',
	'smw_manytypes' => 'Meer dan één type gedefinieerd voor eigenschap.',
	'smw_emptystring' => 'Lege strings zijn niet toegestaan.',
	'smw_maxstring' => 'Stringrepresentatie $1 is te lang voor deze site.',
	'smw_notinenum' => '“$1” komt niet voor in de lijst met mogelijke waarden ($2) voor deze eigenschap.',
	'smw_noboolean' => '“$1” is niet herkend als een booleaanse waarde (waar/onwaar).',
	'smw_true_words' => 'waar,w,ja,j,true',
	'smw_false_words' => 'onwaar,o,nee,n,false',
	'smw_nofloat' => '“$1” is geen getal.',
	'smw_infinite' => 'Getallen zo groot als “$1” zijn niet ondersteund door deze site.',
	'smw_infinite_unit' => 'Conversie naar eenheid “$1” resulteerde in een getal dat te groot is voor deze site.',
	'smw_unsupportedprefix' => 'Voorvoegsels voor getallen (“$1”) worden niet ondersteund.',
	'smw_unsupportedunit' => 'Eenheidconversie voor eenheid “$1” is niet ondersteund.',
	'smw_lonely_unit' => 'Er is geen getal aangetroffen voor het symbool "$1".',
	'smw_bad_latlong' => 'Lengte en breedte moeten één keer opgegeven worden, met geldige coördinaten.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'O',
	'smw_abb_south' => 'Z',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'Breedte:',
	'smw_label_longitude' => 'Lengte:',
	'smw_nodatetime' => 'De datum “$1” werd niet begrepen.',
	'smw_toomanyclosing' => '“$1” lijkt te vaak voor te komen in de zoekopdracht.',
	'smw_noclosingbrackets' => 'In uw zoekopdracht is het gebruik van “<nowiki>[[</nowiki>” niet gesloten door een bijbehorende “]]”.',
	'smw_misplacedsymbol' => 'Het symbool “$1” is gebruikt op een plaats waar het niet gebruikt hoort te worden.',
	'smw_unexpectedpart' => 'Het deel “$1” van de zoekopdracht is niet begrepen. De resultaten kunnen afwijken van de verwachting.',
	'smw_emptysubquery' => 'Er is een subzoekopdracht met een onjuiste conditie.',
	'smw_misplacedsubquery' => 'Er is een subzoekopdracht gebruikt op een plaats waar subzoekopdrachten niet gebruikt mogen worden.',
	'smw_valuesubquery' => 'Subzoekopdrachten worden niet ondersteund voor waarden van eigenschap “$1”.',
	'smw_overprintoutlimit' => 'De zoekopdracht bevat te veel printoutverzoeken.',
	'smw_badprintout' => 'Er is een print statement in de zoekopdracht onjuist geformuleerd.',
	'smw_badtitle' => '“$1” is geen geldige paginanaam.',
	'smw_badqueryatom' => 'Een onderdeel “<nowiki>[[…]]</nowiki>” van de zoekopdracht is niet begrepen.',
	'smw_propvalueproblem' => 'De waarde van eigenschap “$1” is niet begrepen.',
	'smw_noqueryfeature' => 'Een bepaalde vraagoptie wordt niet ondersteund in deze wiki en een deel van de zoekopdracht is genegeerd ($1).',
	'smw_noconjunctions' => 'Verbindingen in zoekopdrachten worden in deze wiki niet ondersteund en een deel van de zoekopdracht is genegeerd ($1).',
	'smw_nodisjunctions' => 'Scheidingen in zoekopdrachten worden niet ondersteund in deze wiki en er is een deel van de zoekopdracht genegeerd ($1).',
	'smw_querytoolarge' => 'De volgende zoekopdrachtcondities zijn niet in acht genomen vanwege beperkingen in de grootte of diepte van zoekopdrachten in deze wiki: $1.',
	'smw_devel_warning' => 'Deze functie wordt op het moment ontwikkeld en is wellicht niet volledig functioneel. Maak een back-up voordat u deze functie gebruikt.',
	'smw_notemplategiven' => 'Geef een waarde voor de parameter "sjabloon" op om deze zoekopdracht te laten werken.',
	'smw_type_header' => 'Eigenschappen voor type “$1”',
	'smw_typearticlecount' => 'Er {{PLURAL:$1|is $1 eigenschap die gebruik maakt|zijn $1 eigenschappen die gebruik maken}} van dit type.',
	'smw_attribute_header' => "Pagina's die de eigenschap “$1” gebruiken",
	'smw_attributearticlecount' => "Er {{PLURAL:$1|is $1 pagina die deze eigenschap gebruikt|zijn $1 pagina's die deze eigenschappen gebruiken}}.",
	'smw_subproperty_header' => 'Subeigenschappen',
	'smw_subpropertyarticlecount' => 'Deze eigenschap heeft de volgende $1 {{PLURAL:$1|subeigenschap|subeigenschappen}}.',
	'smw_concept_header' => 'Pagina\'s met het concept "$1"',
	'smw_conceptarticlecount' => "$1 {{PLURAL:$1|pagina|pagina's}} die bij dat concept {{PLURAL:$1|hoort|horen}} worden weergegeven.",
	'exportrdf' => "Export pagina's naar RDF",
	'smw_exportrdf_docu' => "<p>Deze pagina maakt het mogelijk gegevens te verkrijgen van een pagina in RDF-formaat. Geef titels in het onderstaande invoerveld in om pagina's te exporteren. Iedere pagina op een eigen regel.</p>",
	'smw_exportrdf_recursive' => "Exporteer alle gerelateerde pagina's recursief. Het resultaat kan groot zijn!",
	'smw_exportrdf_backlinks' => "Exporteer ook alle pagina's die verwijzen naar de te exporteren pagina's. Genereert door te bladeren RDF.",
	'smw_exportrdf_lastdate' => "Exporteer geen pagina's die sinds het opgegeven punt niet gewijzigd zijn.",
	'properties' => 'Eigenschappen',
	'smw_properties_docu' => 'De volgende eigenschappen worden in de wiki gebruikt.',
	'smw_property_template' => '$1 van type $2 ($3)',
	'smw_propertylackspage' => 'Alle eigenschappen moeten op een pagina beschreven worden!',
	'smw_propertylackstype' => 'Er is geen type opgegeven voor deze eigenschap (type $1 wordt verondersteld).',
	'smw_propertyhardlyused' => 'Deze eigenschap wordt vrijwel niet gebruikt in de wiki!',
	'unusedproperties' => 'Ongebruikte eigenschappen',
	'smw_unusedproperties_docu' => 'De volgende eigenschappen bestaan, hoewel ze niet gebruikt worden.',
	'smw_unusedproperty_template' => '$1 van type $2',
	'wantedproperties' => 'Gewenste eigenschappen',
	'smw_wantedproperties_docu' => 'De volgende eigenschapen worden gebruikt in de wiki, maar hebben geen pagina waarop ze worden beschreven.',
	'smw_wantedproperty_template' => '$1 ($2 keren gebruikt)',
	'tooltip-purge' => 'Klik hier om alle zoekopdrachten en sjablonen op deze pagina bij te werken',
	'smw_purge' => 'Verversen',
	'ontologyimport' => 'Importeer ontologie',
	'smw_oi_docu' => 'Via deze speciale pagina is het mogelijk een ontologie te importeren. Een ontologie moet een bepaalde opmaak hebben, die is gespecificeerd op de <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">ontologie importhelppagina</a>.',
	'smw_oi_action' => 'Importeer',
	'smw_oi_return' => 'Keer terug naar <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Geen ontologie opgegeven, of de ontologie kon niet geladen worden.',
	'smw_oi_select' => 'Selecteer de te importeren declaraties en klik dan op de knop Importeer.',
	'smw_oi_textforall' => 'Koptekst voor alle imports (mag leeg blijven):',
	'smw_oi_selectall' => 'Selecteer of deselecteer alle declaraties',
	'smw_oi_statementsabout' => 'Declaraties over',
	'smw_oi_mapto' => 'Koppel entiteit aan',
	'smw_oi_comment' => 'Voeg de volgende tekst toe:',
	'smw_oi_thisissubcategoryof' => 'Een subcategorie van',
	'smw_oi_thishascategory' => 'Is deel van',
	'smw_oi_importedfromontology' => 'Importeer van ontologie',
	'types' => 'Typen',
	'smw_types_docu' => 'Hieronder staat een lijst van alle datatypen die aan eigenschappen kunnen worden toegewezen. Ieder datatype heeft een pagina waar aanvullende informatie opgegeven kan worden.',
	'smw_typeunits' => 'Eenheden van type "$1": $2',
	'semanticstatistics' => 'Semantische statistieken',
	'smw_semstats_text' => 'Deze wiki bevat <b>$1</b> eigenschapwaaren voor <b>$2</b> verschillden <a href="$3">eigenschappen</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Eigenschappen waar nog geen pagina voor is zijn te vinden op de <a href="$7">lijst met gewenste eigenschappen</a>.',
	'flawedattributes' => 'Incomplete eigenschappen',
	'smw_fattributes' => 'De onderstaande pagina\\s hebben een onjuist gedefinieerde eigenschap. Het aantal onjuiste eigenschappen staat tussen de haakjes.',
	'uriresolver' => 'URI-resolver',
	'smw_uri_doc' => '<p>De URI-resolver implementeert de <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Het zorgt ervoor dat mensen niet veranderen in websites.</p>',
	'ask' => 'Semantisch zoeken',
	'smw_ask_sortby' => 'Sort op kolom',
	'smw_ask_ascorder' => 'Oplopend',
	'smw_ask_descorder' => 'Aflopend',
	'smw_ask_submit' => 'Zoek resultaten',
	'smw_ask_editquery' => '[zoekopdracht bewerken]',
	'smw_add_sortcondition' => '[sorteervoorwaarde toevoegen]',
	'smw_ask_hidequery' => 'Zoekopdracht verbergen',
	'smw_ask_help' => 'Hulp bij zoekopdrachten',
	'smw_ask_queryhead' => 'Zoekopdracht',
	'smw_ask_printhead' => 'Additionele afdrukken (optioneel)',
	'searchbyproperty' => 'Zoek op eigenschap',
	'smw_sbv_docu' => "<p>Zoek naar alle pagina's die een bepaalde eigenschap en waarde hebben.</p>",
	'smw_sbv_noproperty' => '<p>Voer een eigenschap in.</p>',
	'smw_sbv_novalue' => '<p>Voer een geldige waarde in voor de eigenschap, of bekijk alle waarden voor eigenschap “$1.”</p>',
	'smw_sbv_displayresult' => "Een lijst met alle pagina's waarop eigenschap “$1” de waarde “$2” heeft",
	'smw_sbv_displayresultfuzzy' => 'Een lijst van alle pagina\'s met de eigenschap "$1" met waarde "$2".
Omdat er een beperkt aantal resultaten is, worden ook nabije waarden weergegeven.',
	'smw_sbv_property' => 'Eigenschap',
	'smw_sbv_value' => 'Waarde',
	'smw_sbv_submit' => 'Zoek resultaten',
	'browse' => 'Wiki bekijken',
	'smw_browselink' => 'Eigenschappen bekijken',
	'smw_browse_article' => 'Voer de naam in van de pagina waar u met browsen wilt beginnen.',
	'smw_browse_go' => 'OK',
	'smw_browse_show_incoming' => 'eigenschappen weergeven die hierheen verwijzen',
	'smw_browse_hide_incoming' => 'eigenschappen verbergen die hierheen verwijzen',
	'smw_browse_no_outgoing' => 'Deze pagina heeft geen eigenschappen.',
	'smw_browse_no_incoming' => 'Er verwijzen geen eigenschappen naar deze pagina.',
	'smw_inverse_label_default' => '$1 van',
	'smw_inverse_label_property' => 'Tegenovergesteld eigenschapslabel',
	'pageproperty' => 'Eigenschap pagina zoeken',
	'smw_pp_docu' => 'Zoek naar alle fillers voor een eigenschap op een gegeven pagina.
Voer zowel een pagina als een eigenschap in.',
	'smw_pp_from' => 'Van pagina',
	'smw_pp_type' => 'Eigenschap',
	'smw_pp_submit' => 'Zoek resultaten',
	'smw_result_prev' => 'Vorige',
	'smw_result_next' => 'Volgende',
	'smw_result_results' => 'Resultaten',
	'smw_result_noresults' => 'Geen resultaten.',
	'smwadmin' => 'Administratieve functies voor Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Opslag instellen voor Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'De opslag is ingesteld.',
	'smw_smwadmin_return' => 'Terug naar $1',
	'smw_smwadmin_updatestarted' => 'Er is een proces gestart voor het bijwerken van de semantische gegevens.
Alle opgeslagen gegevens worden opnieuw opgebouwd of gerepareerd als dat nodig is.
U kunt de voortgang volgen via deze speciale pagina.',
	'smw_smwadmin_updatenotstarted' => 'Er loopt al een bijwerkproces.
Er wordt geen nieuw proces gestart.',
	'smw_smwadmin_updatestopped' => 'Alle lopende bijwerkprocessen zijn afgebroken.',
	'smw_smwadmin_updatenotstopped' => 'Om de lopende processes te stoppen, moet u het vinkje inschakelen om aan te geven dat u het zeker weet.',
	'smw_smwadmin_docu' => 'Deze speciale pagina assisteert u tijdens de installatie en het bijwerken van <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Denk eraan een back-up te maken van uw waardevolle gegevens voordat u beheershandelingen uitvoert.',
	'smw_smwadmin_db' => 'Database installeren en bijwerken',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki heeft een aantal uitbreidingen aan de database van MediaWiki nodig om de semantische gegevens op te kunnen slaan.
De onderstaande functionaliteit zorgt ervoor dat uw database juist is ingesteld.
De wijzigingen die in deze stap worden gemaakt, hebben geen invloed op de bestaande database van MediaWiki, en zijn eventueel eenvoudig ongedaan te maken.
Deze instelfunctie kan meerdere keren worden uitgevoerd zonder schade aan te richten, hoewel het uiteraard slechts noodzakelijk is deze een keer uit te voeren per installatie of upgrade.',
	'smw_smwadmin_permissionswarn' => 'Als de handeling faalt met SQL-fouten, heeft de databasegebruiker van uw wiki (zie LocalSettings.php) waarschijnlijk onvoldoende rechten.
Geef deze gebruiker de benodigde extra rechten om tabellen aan te maken en te verwijderen, geef tijdelijk de aanmeldgegevens van de hoofdgebruiker van uw databasesysteem aan in LocalSettings.php, of gebruik het beheerscript <tt>SMW_setup.php</tt> dat de instellingen van AdminSettings.php kan gebruiken.',
	'smw_smwadmin_dbbutton' => 'Tabellen initialiseren of bijwerken',
	'smw_smwadmin_announce' => 'Uw wiki aankondigen',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki heeft een webservice voor het aankondigen van nieuwe semantische wikisites.
Deze dienst wordt gebruikt om een lijst bij te houden van publiek toegankelijke sites die Semantic MediaWiki gebruiken, voornamelijk om het <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki-project</a> inzicht te geven in het typische gebruik van Semantic MediaWiki.
Op de homepage van Semantic MediaWiki staat <a href="http://semantic-mediawiki.org/wiki/Registry">meer informatie over deze dienst</a>.',
	'smw_smwadmin_announcebutton' => "Klik op de knop om de URL van uw wiki naar de dienst te sturen.
De dienst registreert geen wiki's die niet publiek toegankelijk zijn en slaat alleen publiek toegankelijke informatie op.",
	'smw_smwadmin_datarefresh' => 'Gegevens repareren en bijwerken',
	'smw_smwadmin_datarefreshdocu' => 'Het is mogelijk om alle gegevens van Semantic MediaWiki opnieuw te genereren op basis van de huidige inhoud van de wiki.
Dit kan handig zijn om gegevens te repareren of de gegevens te verversen als de interne opmaak gewijzigd is bij een softwareupdate.
De gegevens worden pagina voor pagina bijgewerkt en het kan enige tijd duren voor de taak is afgerond.
Hieronder wordt weergegeven of er op dit moment een taak loopt en stelt u in staat een taak te stoppen of te starten (tenzij deze mogelijkheid door de sitebeheerder is uitgeschaked).',
	'smw_smwadmin_datarefreshprogress' => "Er loopt een bijwerktaak</b>
Het is normaal dat de voortgang langzaam is omdat de gegevens ververst worden in kleine porties iedere keer als een gebruiker de wiki raadpleegt.
Om het bijwerken sneller te laten verlopen, kunt u het beheerscript <tt>runJobs.php</tt> draaien. Gebruik de optie <tt>--maxjobs 1000</tt> om aan het aantal bij te werken pagina's per handeling te beperken.
Geschatte voortgang van de huidige taak:",
	'smw_smwadmin_datarefreshbutton' => 'Gegevens bijwerken',
	'smw_smwadmin_datarefreshstop' => 'Bijwerken afbreken',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, ik weet het zeker.',
	'smw_smwadmin_support' => 'Ondersteuning krijgen',
	'smw_smwadmin_supportdocu' => 'Een aantal bronnen kunnen u ondersteunen als u problemen ondervindt:',
	'smw_smwadmin_installfile' => 'Als u problemen ondervindt bij uw installatie, controleer dan de richlijnen in het bestand <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'De volledige gebruikersdocumentatie voor Semantic MediaWiki is te vinden op <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Bugs en suggesties kunt u rapporteren in <a href="https://bugzilla.wikimedia.org/">MediaZilla</a>.',
	'smw_smwadmin_questions' => 'Als u verdere vragen of suggesties hebt, neem dan deel aan het overleg op <a href="mailto:semediawiki-user@lists.sourceforge.net">semediawiki-user@lists.sourceforge.net</a>.',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'smw_edithelp' => 'Redigeringshjelp for egenskaper',
	'smw_viewasrdf' => 'RDF-kilde',
	'smw_finallistconjunct' => ' og',
	'smw_factbox_head' => 'Fakta om $1',
	'smw_isspecprop' => 'Denne egenskapen er en spesialegenskap på denne wikien.',
	'smw_isknowntype' => 'Denne datatypen er blant standardtypene på denne wikien.',
	'smw_isaliastype' => 'Denne datatypen er et alias for typen «$1».',
	'smw_isnotype' => 'Datatypen «$1» er ikke en standardtype på denne wikien, og har ikke blitt gitt en brukerdefinsjon.',
	'smw_concept_description' => 'Beskrivelse av konseptet «$1»',
	'smw_no_concept_namespace' => 'Konsepter kan kun defineres på sider i Concept:-navnerommet.',
	'smw_multiple_concepts' => 'Hver konseptside kan kun ha én konseptdefinisjon.',
	'smw_baduri' => 'Beklager, URI-er på formen «$1» er ikke tillatt.',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iKalender',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Beklager. Semantiske spørringer er slått av på denne wikien.',
	'smw_iq_moreresults' => '… flere resultater',
	'smw_iq_nojs' => 'Bruk en nettleser med JavaScript-støtte for å vise dette elementet.',
	'smw_iq_altresults' => 'Gå gjennom resultatlisten direkte.',
	'smw_unknown_importns' => 'Importeringsfunksjoner er ikke tilgjengelige for navnerommet «$1».',
	'smw_nonright_importtype' => '$1 kun kun brukes for sider i navnerommet «$2».',
	'smw_wrong_importtype' => '$1 kan ikke brukes for sider i navnerommet «$2».',
	'smw_no_importelement' => 'Elementet «$1» er ikke tilgjengelig for importering.',
	'smw_parseerror' => 'Den gitte verdien ble ikke forstått.',
	'smw_notitle' => '«$1» kan ikke brukes som sidenavn på denne wikien.',
	'smw_unknowntype' => 'Typen «$1» som er definert for egenskapen støttes ikke.',
	'smw_manytypes' => 'Mer enn én type definert for egenskapen.',
	'smw_emptystring' => 'Tomme strenger godtas ikke.',
	'smw_maxstring' => 'Strengrepresenteringen $1 er for lang for {{SITENAME}}.',
	'smw_notinenum' => '«$1» er ikke i listen over mulige verdier ($2) for denne egenskapen.',
	'smw_noboolean' => '«$1» gjenkjennes ikke som en Boolean-verdi (true/false).',
	'smw_true_words' => 'true,t,yes,y,ja,j,sant,s',
	'smw_false_words' => 'false,f,no,n,nei,usant,u',
	'smw_nofloat' => '«$1» er ikke et tall.',
	'smw_infinite' => 'Tall så store som «$1» støttes ikke på {{SITENAME}}.',
	'smw_infinite_unit' => 'Konvertering til enheten «$1» resulterte i et tall som er for stort for {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Prefiks for tall («$1») støttes ikke.',
	'smw_unsupportedunit' => 'Enhetskonvertering for enheten «$1» støttes ikke.',
	'smw_lonely_unit' => 'Intet tall funnet foran symbolet «$1».',
	'smw_bad_latlong' => 'Bredde- og lengdegrad kan kun oppgis én gang, og med gyldige koordinater.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'Ø',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'V',
	'smw_label_latitude' => 'Breddegrad:',
	'smw_label_longitude' => 'Lengdegrad:',
	'smw_nodatetime' => 'Datoen «$1» ble ikke forstått.',
	'smw_toomanyclosing' => '«$1» opptrer for mange ganger i spørringen.',
	'smw_noclosingbrackets' => 'Bruken av «<nowiki>[[</nowiki>» i spørringen din ble ikke stengt av «]]».',
	'smw_misplacedsymbol' => 'Symbolet «$1» ble brukt på et sted hvor det ikke er nyttig.',
	'smw_unexpectedpart' => '«$1»-delen av spørringen var uforståelig.
Resultatene kan være uventede.',
	'smw_emptysubquery' => 'En underspørring har ingen gyldige betingelser.',
	'smw_misplacedsubquery' => 'En underspørring ble brukt på et sted hvor underspørringer ikke tillates.',
	'smw_valuesubquery' => 'Underspørringer støtes ikke for verdier av egenskapen «$1».',
	'smw_overprintoutlimit' => 'Spørringen inneholder for mange skriveforespørsler.',
	'smw_badprintout' => 'Noen skriveuttrykk i spørringen hadde ugyldig form.',
	'smw_badtitle' => 'Beklager, «$1» er ikke en gyldig sidetittel.',
	'smw_badqueryatom' => 'En del («<nowiki>[[…]]</nowiki>») av spørringen ble ikke forstått.',
	'smw_propvalueproblem' => 'Verdien av egenskapen «$1» ble ikke forstått.',
	'smw_noqueryfeature' => 'Noen spørringsfunksjoner ble ikke støttet i denne wikien, og deler av spørringen ble hoppet over ($1).',
	'smw_noconjunctions' => 'Konjunksjoner i spørringer støttes ikke i denne wikien, og deler av spørringen ble hoppet over ($1).',
	'smw_nodisjunctions' => 'Disjunksjoner i spørringer støttes ikke på denne wikien, og deler av spøringen ble utelatt ($1).',
	'smw_querytoolarge' => 'Følgende spørringsbetingelser kunne ikke tas til hensyn på grunn av wikiens begrensninger i spørringsstørrelse eller dybde: $1',
	'smw_devel_warning' => 'Denne funksjonen er under utvikling, og fungerer muligens ikke som den skal.
Ta en kopi av dataene før du bruker den.',
	'smw_notemplategiven' => 'Oppgi en verdi for parameteret «mal» for at dette spørringsformatet skal fungere.',
	'smw_type_header' => 'Egenskaper av typen «$1»',
	'smw_typearticlecount' => 'Viser $1 egenskaper av denne typen.',
	'smw_attribute_header' => 'Sider som bruker egenskapen «$1»',
	'smw_attributearticlecount' => 'Viser $1 sider som bruker denne egenskapen.',
	'smw_subproperty_header' => 'Underegenskaper',
	'smw_subpropertyarticlecount' => 'Denne egenskapen har følgende {{PLURAL:$|underegenskap|$1 underegenskaper}}.',
	'exportrdf' => 'Eksporter sider til RDF',
	'smw_exportrdf_docu' => '<p>Denne siden lar deg skaffe data fra en side i RDF-format.
Skriv inn titler i tekstboksten nedenfor for å eksportere sider, én tittel per linje.</p>',
	'smw_exportrdf_recursive' => 'Eksporter alle relaterte sider rekursivt.
Merk at resultatet kan være stort.',
	'smw_exportrdf_backlinks' => 'Eksporter også alle sider som refererer til de eksporterte sidene.
Lager en RDF som kan gås gjennom.',
	'smw_exportrdf_lastdate' => 'Ikke eksporter sider som ikke ble endret siden gitte tidspunkt.',
	'properties' => 'Egenskaper',
	'smw_properties_docu' => 'Følgende egenskaper brukes på wikien.',
	'smw_property_template' => '$1 av type $2 ($3)',
	'smw_propertylackspage' => 'Alle egenskaper burde beskrives av en side.',
	'smw_propertylackstype' => 'Ingen type ble oppgitt for denne egenskapen (antar at typen er $1 foreløpig).',
	'smw_propertyhardlyused' => 'Denne egenskapen brukes nesten ikke på wikien.',
	'unusedproperties' => 'Ubrukte egenskaper',
	'smw_unusedproperties_docu' => 'Følgende egenskaper finnes, selv om ingen andre sider bruker dem.',
	'smw_unusedproperty_template' => '$1 av type $2',
	'wantedproperties' => 'Ønskede egenskaper',
	'smw_wantedproperties_docu' => 'Fæøgemde egenskaper brukes på wikien, men har ikke en side med forklaring.',
	'smw_wantedproperty_template' => '$1 (brukt $2 ganger)',
	'tooltip-purge' => 'Klikk her for å gjenoppfriske alle spørringer og maler på denne siden',
	'smw_purge' => 'Gjenoppfrisk',
	'ontologyimport' => 'Importer ontologi',
	'smw_oi_docu' => 'Denne spesialsiden lar deg importere ontologier.
Ontologiene må følge et visst format, spesifisert på <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">hjelpesiden for ontologiimport</a>.',
	'smw_oi_action' => 'Importer',
	'smw_oi_return' => 'Tilbake til <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Ingen ontologi oppgitt, eller den kunne ikke lastes.',
	'smw_oi_select' => 'Velg hvilke erklæringer som skal importeres, og klikk på importeringsknappen.',
	'smw_oi_textforall' => 'Introduksjonstekst som skal legges til alle importeringer (kan være tom):',
	'smw_oi_selectall' => 'velg eller fjern alle erklæringer',
	'smw_oi_statementsabout' => 'Erklæringer om',
	'smw_oi_mapto' => 'Kartentitet til',
	'smw_oi_comment' => 'Legg til følgende tekst:',
	'smw_oi_thisissubcategoryof' => 'En underkategori av',
	'smw_oi_thishascategory' => 'Er del av',
	'smw_oi_importedfromontology' => 'Importer fra ontologi',
	'types' => 'Typer',
	'smw_types_docu' => 'Følgende er en liste over alle datatyper som egenskaper kan ha.
Hver datatype har en side der ekstra informasjon kan oppgis.',
	'smw_typeunits' => 'Måleenheter av typen «$1»: $2',
	'semanticstatistics' => 'Semantisk statistikk',
	'smw_semstats_text' => 'Denne wikien inneholder <b>$1</b> egenskapsverdier for totalt <b>$2</b> forskjellige <a href="$3">egenskaper</a>.
<b>$4</b> egenskaper har en egen side, og den mente datatypen er oppgitt for <b>$5</b> av disse.
Noen av de eksisterende egenskapene kan være <a href="$6">ubrukte egenskaper</a>.
Egenskaper som fortsatt ikke har en egen side finnes på <a href="$7">listen over ønskede egenskaper</a>.',
	'flawedattributes' => 'Ugyldige egenskaper',
	'smw_fattributes' => 'Sidene som listes opp nedenfor har en ukorrekt definert egenskap.
Antallet ukorrekte egenskaper gis i parentes.',
	'uriresolver' => 'URI-løser',
	'smw_uri_doc' => "<b>URI-løseren implementerer ''<a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG finding on httpRange-14</a>''. Den gjør så mennesker ikke blir til nettsider.</p>",
	'ask' => 'Semantisk søk',
	'smw_ask_sortby' => 'Sorter etter kolonne (valgfritt)',
	'smw_ask_ascorder' => 'Stigende',
	'smw_ask_descorder' => 'Synkende',
	'smw_ask_submit' => 'Finn resultater',
	'smw_ask_editquery' => '[Rediger spørring]',
	'smw_add_sortcondition' => '[Legg til sorteringsbetingelse]',
	'smw_ask_hidequery' => 'Skjul spørring',
	'smw_ask_help' => 'Spørringshjelp',
	'smw_ask_queryhead' => 'Spørring',
	'smw_ask_printhead' => 'Ekstra utskrifter (valgfritt)',
	'searchbyproperty' => 'Søk etter egenskap',
	'smw_sbv_docu' => '<p>Søk etter alle sider som har en gitt egenskap og verdi.</p>',
	'smw_sbv_noproperty' => '<p>Skriv inn en egenskap.</p>',
	'smw_sbv_novalue' => '<p>Skriv inn en gyldig verdi for egenskapen, eller vis alle egenskapsverdier for «$1».</p>',
	'smw_sbv_displayresult' => 'En liste over alle sider som har egenskapen «$1» med verdien «$2»',
	'smw_sbv_property' => 'Egenskap',
	'smw_sbv_value' => 'Verdi',
	'smw_sbv_submit' => 'Finn resultater',
	'browse' => 'Bla gjennom wikien',
	'smw_browse_article' => 'Skriv inn navnet på siden du vil starte å bla fra.',
	'smw_browse_go' => 'Gå',
	'pageproperty' => 'Sideegenskapsøk',
	'smw_pp_docu' => 'Søk etter all egenskapstekst på en gitt side.
Skriv inn både sidenavn og egenskap.',
	'smw_pp_from' => 'Fra side',
	'smw_pp_type' => 'Egenskap',
	'smw_pp_submit' => 'Finn resultater',
	'smw_result_prev' => 'Forrige',
	'smw_result_next' => 'Neste',
	'smw_result_results' => 'Resultater',
	'smw_result_noresults' => 'Beklager, ingen resultater',
	'smwadmin' => 'Administratorfunksjoner for Semantic MediaWiki',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'smw_edithelp' => "Ajuda a la redaccion de relacions e d'atributs",
	'smw_viewasrdf' => 'Veire coma RDF',
	'smw_finallistconjunct' => ' e',
	'smw_factbox_head' => 'Faches relatius a $1 &mdash; Recèrca de paginas similaras amb <span class="smwsearchicon">+</span>.',
	'smw_isspecprop' => 'Aquesta proprietat es una proprietat especiala sus aqueste wiki.',
	'smw_isknowntype' => "Aqueste tipe fa partida dels tipes de donadas estandards d'aqueste wiki.",
	'smw_isaliastype' => 'Aqueste tipe es un aliàs del tipe de donadas “$1”.',
	'smw_isnotype' => 'Lo tipe “$1” es pas un tipe de donadas estandard sus aqueste wiki, e tanpauc es pas estat definit per un utilizaire.',
	'smw_concept_description' => 'Descripcion del concèpte « $1 »',
	'smw_no_concept_namespace' => 'Los concèptes pòt unicament èsser definits dins la pagina dins lo Concèpte : espaci de nom.',
	'smw_multiple_concepts' => 'Cada pagina de concèpte pòt pas aver qu’una sola definicion.',
	'smw_concept_cache_miss' => 'Lo concèpte « $1 » pòt pas èsser utilizat pelmoment moment, perque la configuracion del wiki requerís que siá aviat fòra linha. Se lo problèma persistís aprèp qualques instants, demandatz a vòstre administrator del sit de rendre disponible aqueste concèpte.',
	'smw_baduri' => 'O planhèm. Las URIs del domeni $1 son pas disponiblas a aqueste emplaçament',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendièr',
	'smw_vcard_link' => 'vCarta',
	'smw_iq_disabled' => "O planhèm. Las recèrcas dins los articles d'aqueste wiki son pas autorizadas.",
	'smw_iq_moreresults' => '… autres resultats',
	'smw_iq_nojs' => 'Utilizatz un navigador amb JavaScript per veire aqueste element.',
	'smw_iq_altresults' => 'Percórrer dirèctament la lista dels resultats.',
	'smw_unknown_importns' => 'Cap de foncion d\'impòrt es pas disponible per l\'espaci de nomenatge "$1".',
	'smw_nonright_importtype' => 'L\'element "$1" pòt pas èsser emplegat que per d\'articles de l\'espaci de nomenatge "$2".',
	'smw_wrong_importtype' => 'L\'element "$1" pòt pas èsser emplegat que per d\'articles de l\'espaci de nomenatge domeni "$2".',
	'smw_no_importelement' => 'L\'element "$1" es pas disponible per l\'importacion.',
	'smw_parseerror' => 'La donada indicada es pas estada compresa.',
	'smw_kiloseparator' => ',',
	'smw_notitle' => '“$1” pòt pas èsser utilizat coma nom de pagina sus aqueste wiki.',
	'smw_wrong_namespace' => "Solas las paginas de l'espaci de noms « $1 » son autorizadas aicí.",
	'smw_unknowntype' => 'Lo tipe de donadas "$1" pas suportat es estat tornat a l\'atribut.',
	'smw_manytypes' => "Maites tipes de donadas son estats assignats a l'atribut.",
	'smw_emptystring' => 'Las cadenas voidas son pas acceptadas.',
	'smw_maxstring' => 'La cadena de representacion $1 es tròp granda per aqueste sit.',
	'smw_notinenum' => '\\"$1\\" fa pas partida de las valors possiblas ($2) per aqueste atribut.',
	'smw_noboolean' => '\\"$1\\" es pas reconegut coma una valor boleana (verai/fals).',
	'smw_true_words' => 'verai,v,òc,true',
	'smw_false_words' => 'fals,f,non,false',
	'smw_nofloat' => '"$1" es pas un nombre.',
	'smw_infinite' => 'Los nombres tant longs coma “$1” son pas suportats sus {{SITENAME}}.',
	'smw_infinite_unit' => "La conversion dins l'unitat $1 es impossibla : lo nombre es tròp long.",
	'smw_unsupportedprefix' => 'De prefixes ("$1") son pas suportats actualament',
	'smw_unsupportedunit' => 'La conversion de l\'unitat "$1" es pas suportada',
	'smw_lonely_unit' => 'Cap de nombre pas trobat abans lo simbòl “$1”.',
	'smw_bad_latlong' => "Latitud e longitud devon pas èsser indicats qu'un sol còp, e amb de coordenadas validas.",
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'O',
	'smw_label_latitude' => 'Latitud :',
	'smw_label_longitude' => 'Longitud :',
	'smw_nodatetime' => 'La data "$1" es pas estada compresa.',
	'smw_toomanyclosing' => "Sembla que i a tròp d'ocuréncias de “$1” dins la requèsta.",
	'smw_noclosingbrackets' => "D'unes “<nowiki>[[</nowiki>” dins vòstra requèsta son pas estats clauses per de “]]” correspondents.",
	'smw_misplacedsymbol' => 'Lo simbòl “$1” es estat utilizat a un endrech ont es pas util.',
	'smw_unexpectedpart' => 'La partida “$1” de la requèsta es pas estada compresa. Los resultats pòdon èsser imprevists.',
	'smw_emptysubquery' => "D'unas sosrequèstas an una condicion invalida.",
	'smw_misplacedsubquery' => "D'unas sosrequèstas son estadas utilizadas a un endrech ont cap de sosrequèsta es pas permesa.",
	'smw_valuesubquery' => 'Sosrequèsta pas suportada per las valors de la proprietat “$1”.',
	'smw_overprintoutlimit' => "La requèsta conten tròp d'instruccions de formatatge.",
	'smw_badprintout' => "D'unas instruccions de formatatge dins la requèsta son pas estadas compresas.",
	'smw_badtitle' => 'O planhèm, mas “$1” es pas un títol de pagina valable.',
	'smw_badqueryatom' => 'Las partidas “<nowiki>[[…]]</nowiki>” de la requèsta son pas estadas compresas.',
	'smw_propvalueproblem' => 'La valor de la proprietat “$1” es pas estada compresa.',
	'smw_noqueryfeature' => 'Qualques foncionalitats de requèstas son pas suportadas sus aqueste wiki e una partida d’entre elas es estada levada ($1).',
	'smw_noconjunctions' => 'Las conjoncions dins las requèstas son pas suportadas sus aqueste wiki e una partida d’entre elas es estada levada ($1).',
	'smw_nodisjunctions' => 'Las disjoncions dins las requèstas son pas suportadas sus aqueste wiki e de partidas de la requèsta son estadas ignoradas($1).',
	'smw_querytoolarge' => "Las condicions seguentas de la requèsta an pas pogut èsser evaluadas en rason de las restriccions d'aqueste wiki a la talha o a la prigondor de las requèstas : $1.",
	'smw_devel_warning' => "Aquesta foncion es encara en desvolopament e benlèu es pas encara operacionala. Pòt èsser judiciós de far un salvament del contengut del wiki abans tota utilizacion d'aquesta foncion.",
	'smw_notemplategiven' => 'Provesissètz una valor pel paramètre « modèl » per aqueste format de requèsta per trabalhar.',
	'smw_type_header' => 'Atributs de tipe “$1”',
	'smw_typearticlecount' => "Afichar {{PLURAL:$1|la proprietat qu'utiliza|las $1 proprietats qu'utilizan}} aqueste tipe.",
	'smw_attribute_header' => "Paginas utilizant l'atribut “$1”",
	'smw_attributearticlecount' => "Afichar {{PLURAL:$1|la pagina qu'utiliza|las $1 paginas qu'utilizan}} aquesta proprietat.",
	'smw_subproperty_header' => 'Sosproprietats',
	'smw_subpropertyarticlecount' => 'Aquesta proprietat dispausa {{PLURAL:$1|de la sosproprietat seguenta|de las $1 sosproprietats seguentas}}.',
	'smw_concept_header' => 'Paginas del concèpte « $1 »',
	'smw_conceptarticlecount' => 'Afichar {{PLURAL:$1|la pagina que repausa|las $1 paginas que repausan}} sus aqueste concèpte.',
	'smw_rss_description' => '$1 fial RSS',
	'exportrdf' => "Exportar l'article en RDF",
	'smw_exportrdf_docu' => "<p>Sus aquesta pagina, de partidas del contengut d'un article pòdon èsser exportadas dins lo format RDF. Picatz lo nom de las paginas desiradas dins la bóstia de tèxt çaijós, <i>un nom per linha </i>.</p>",
	'smw_exportrdf_recursive' => "Exportar tanben totas las paginas pertinentas d'un biais recursiu. Aquesta possibilitat pòt abotir a un fòrt grand nombre de resultats !",
	'smw_exportrdf_backlinks' => 'Exportar tanben totas las paginas que renvian a de paginas exportadas. Produsís un RDF dins lo qual la navigacion es mai aisida.',
	'smw_exportrdf_lastdate' => 'Exportar pas las paginas pas modificadas dempuèi lo moment indicat.',
	'properties' => 'Proprietats',
	'smw_properties_docu' => 'Sus aqueste wiki, son utilizadas las proprietats seguentas.',
	'smw_property_template' => '$1 del tipe $2 ($3)',
	'smw_propertylackspage' => 'Tota proprietat deuriá èsser descricha per una pagina !',
	'smw_propertylackstype' => 'Cap de tipe es pas estat especificat per aquesta proprietat (tipe actualament supausat : $1).',
	'smw_propertyhardlyused' => 'Aquesta proprietat es fòrça utilizada sus aqueste wiki !',
	'unusedproperties' => 'Proprietats inutilizadas',
	'smw_unusedproperties_docu' => 'Las proprietats seguentas existisson, quitament se cap de pagina las utiliza pas.',
	'smw_unusedproperty_template' => '$1 de tipe $2',
	'wantedproperties' => 'Proprietats demandadas',
	'smw_wantedproperties_docu' => 'Las proprietats seguentas son utilizadas sus aqueste wiki mas an pas encara de pagina per las descriure.',
	'smw_wantedproperty_template' => '$1 ($2 utilizacions)',
	'tooltip-purge' => "Reactualizar totas las recèrcas e totes los borrolhons d'aquesta pagina.",
	'smw_purge' => 'Reactualizar',
	'ontologyimport' => 'Importar una ontologia',
	'smw_oi_docu' => "Aquesta pagina especiala permet d'importar d'entresenhas d'una ontologia extèrna. Aquesta ontologia deu èsser dins un format RDF simplificat. D'entresenhas suplementàrias son disponiblas dins la <a href=\"http://semantic-mediawiki.org/wiki/Help:Ontology_import\">Documentacion relativa a l'impòrt d'ontologia</a> en lenga anglesa.",
	'smw_oi_action' => 'Importar',
	'smw_oi_return' => 'Tornar a <a href="$1">Importar l\'ontologia</a>.',
	'smw_oi_noontology' => "Cap d'ontologia provesida, o impossible de cargar l'ontologia.",
	'smw_oi_select' => "Seleccionatz lo tèxt d'importar, puèi clicatz sul boton « importar ».",
	'smw_oi_textforall' => "Tèxt d'apondre en entèsta a totas las importacions (pòt demorar void) :",
	'smw_oi_selectall' => 'Seleccionar o deseleccionar totes los tèxtes',
	'smw_oi_statementsabout' => 'Tèxtes sus',
	'smw_oi_mapto' => "Mapa de l'entitat sus",
	'smw_oi_comment' => 'Apondre lo tèxt seguent :',
	'smw_oi_thisissubcategoryof' => 'Soscategoria de',
	'smw_oi_thishascategory' => 'Fa partida de',
	'smw_oi_importedfromontology' => "Importar d'ontologia",
	'types' => 'Tipes',
	'smw_types_docu' => "Los tipes de donadas seguents pòdon èsser assignadas als atributs. Cada tipe de donadas a son pròpri article, dins lo qual pòdon figurar d'entresenhas mai precisas.",
	'smw_typeunits' => 'Unitats de mesura de tipe “$1” : $2',
	'semanticstatistics' => 'Estatisticas semanticas',
	'smw_semstats_text' => 'Aqueste wiki conten <b>$1</b> valors de proprietat per una soma de <b>$2</b> <a href="$3">proprietats</a> diferentas. <b>$4</b> proprietats an lor pagina pròpria, e lo tipe de donadas volgut es especifica per <b>$5</b> d\'aquestas. D\'unas de las proprietats existentas pòdon far partida de las <a href="$6">proprietats inutilizadas</a>. Las proprietats qu\'an pas encara de pagina se tròban sus la <a href="$7">lista de las proprietats demandadas</a>.',
	'flawedattributes' => 'Atributs defectuoses',
	'smw_fattributes' => "Las paginas çaijós an un atribut qu'es pas definit corrèctament. Lo nombre d'atributs incorrèctes es donat entre las parentèsis.",
	'uriresolver' => "Resolveire d'URI",
	'smw_uri_doc' => '<p>Lo resolveire d\'URI implementa la <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">conclusion del TAG del W3C a prepaus del httpRange-14</a>. Pòt velhar a que los umans vengan pas de sits web.',
	'ask' => 'Recèrca semantica',
	'smw_ask_sortby' => 'Triar per colomnas',
	'smw_ask_ascorder' => 'Creissent',
	'smw_ask_descorder' => 'Descreissent',
	'smw_ask_submit' => 'Trobar de resultats',
	'smw_ask_editquery' => '[Editar la requèsta]',
	'smw_add_sortcondition' => '[Apond las condicions de triada]',
	'smw_ask_hidequery' => 'Amagar la requèsta',
	'smw_ask_help' => 'Ajuda a la requèsta',
	'smw_ask_queryhead' => 'Requèsta',
	'smw_ask_printhead' => 'Condicions suplementàrias (facultatiu)',
	'searchbyproperty' => 'Recercar per atribut',
	'smw_sbv_docu' => "<p>Recercar totas las paginas qu'an un atribut donat amb una cèrta valor.</p>",
	'smw_sbv_noproperty' => '<p>Picatz un atribut.</p>',
	'smw_sbv_novalue' => '<p>Picatz una valor o consultatz totas las valors dels atributs per $1.</p>',
	'smw_sbv_displayresult' => "Lista de totas las paginas qu'an un atribut $1 amb la valor $2.",
	'smw_sbv_displayresultfuzzy' => 'Una lista de totas las paginas que son la proprietat « $1 » amb la valor « $2 ». Perque i a pas que qualques resultats, las valors pròchas tanben son afichadas.',
	'smw_sbv_property' => 'Proprietat',
	'smw_sbv_value' => 'Valor',
	'smw_sbv_submit' => 'Trobar de resultats',
	'browse' => 'Percórrer lo wiki',
	'smw_browselink' => 'Cercar las proprietats',
	'smw_browse_article' => 'Picatz lo nom de la pagina a partir de la quala volètz començar la navigacion.',
	'smw_browse_go' => 'Validar',
	'smw_browse_show_incoming' => 'afichar las proprietats que puntan aicí',
	'smw_browse_hide_incoming' => 'amagar las proprietats que puntan aicí',
	'smw_browse_no_outgoing' => 'Aquesta pagina a pas cap de proprietat.',
	'smw_browse_no_incoming' => 'Cap de proprietat punta pas cap a aquesta pagina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Inversar lo label de proprietat',
	'pageproperty' => 'Recercar dins las proprietats de la pagina',
	'smw_pp_docu' => "Recercar totas las valors d'una proprietat dins una pagina donada. Picatz la pagina e una proprietat.",
	'smw_pp_from' => 'De la pagina',
	'smw_pp_type' => 'Proprietat',
	'smw_pp_submit' => 'Trobar de resultats',
	'smw_result_prev' => 'Precedent',
	'smw_result_next' => 'Seguent',
	'smw_result_results' => 'Resultats',
	'smw_result_noresults' => 'O planhèm, pas de resultats.',
	'smwadmin' => "Foncions d'administrator per Semantic MediaWiki",
);

/** Polish (Polski)
 * @author Maikking
 * @author Sp5uhe
 * @author Łukasz Bolikowski
 */
$messages['pl'] = array(
	'smw_edithelp' => 'Pomoc edycyjna odnośnie relacji i atrybutów',
	'smw_finallistconjunct' => ' i',
	'smw_factbox_head' => 'Fakty o $1 &mdash; Kliknij <span class="smwsearchicon">+</span> aby znaleźć podobne strony.',
	'smw_baduri' => 'Niestety, URI z przestrzeni "$1" nie są w tym miejscu dostępne.',
	'smw_iq_disabled' => 'Niestety, w tym wiki wyłączono możliwość tworzenia zapytań w artykułach.',
	'smw_iq_moreresults' => '&hellip; dalsze wyniki',
	'smw_iq_nojs' => 'Aby obejrzeć ten element, włącz w przeglądarce obsługę JavaScript.',
	'smw_unknown_importns' => 'Brak możliwości importu z przestrzeni nazw "$1".',
	'smw_nonright_importtype' => '$1 może być użyte tylko dla artykułów z przestrzeni nazw "$2".',
	'smw_wrong_importtype' => '$1 nie może być użyte dla artykułów z przestrzeni nazw "$2".',
	'smw_no_importelement' => 'Nie można zaimportować elementu "$1".',
	'smw_parseerror' => 'Podana wartość jest niezrozumiała.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '„$1” nie może być użyte jako nazwa strony.',
	'smw_unknowntype' => '"$1" jako typ atrybutu nie jest wspierany.',
	'smw_manytypes' => 'Zdefiniowano więcej niż jeden typ dla atrybutu.',
	'smw_emptystring' => 'Puste łańcuchy znakowe są niedozwolone.',
	'smw_maxstring' => 'Reprezentacja znakowa $1 jest za długa jak na to miejsce.',
	'smw_notinenum' => '“$1” nie jest na liście dozwolonych wartości ($2) dla tego atrybutu.',
	'smw_noboolean' => '“$1” nie zostało rozpoznane jako wartość logiczna (prawda/fałsz).',
	'smw_true_words' => 'prawda,t,yes,y,tak,true',
	'smw_false_words' => 'fałsz,f,no,n,nie,false',
	'smw_nofloat' => '„$1” nie jest liczbą.',
	'smw_infinite' => 'Liczby tak duże jak $1 nie są w tym miejscu wspierane.',
	'smw_infinite_unit' => 'Konwersja do jednostki $1 zwróciła liczbę, która jest za duża jak na to miejsce.',
	'smw_unsupportedprefix' => 'Przedrostki dla liczb (“$1”) nie są obecnie wspierane.',
	'smw_unsupportedunit' => 'Konwersja dla jednostki "$1" nie jest wspierana.',
	'smw_lonely_unit' => 'Przed symbolem "$1" nie umieszczono żadnej cyfry.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'W',
	'smw_label_latitude' => 'Długość:',
	'smw_label_longitude' => 'Szerokość:',
	'smw_nodatetime' => 'Data "$1" nie została zrozumiana.',
	'smw_misplacedsymbol' => 'Symbolu „$1” użyto w niewłaściwym miejscu.',
	'smw_badtitle' => '„$1” nie jest prawidłowym tytułem strony.',
	'smw_propvalueproblem' => 'Wartość "$1" nie została rozpoznana.',
	'smw_devel_warning' => 'Ta opcja jest obecnie w fazie rozwoju, może nie być w pełni funkcjonalna. Przed użyciem zabezpiecz swoje dane.',
	'smw_type_header' => 'Atrybuty typu “$1”',
	'smw_typearticlecount' => 'Pokazano $1 atrybutów używających tego typu.',
	'smw_attribute_header' => 'Strony używające atrybutu “$1”',
	'smw_attributearticlecount' => 'Pokazano $1 stron używających tego atrybutu.',
	'exportrdf' => 'Eksport stron do RDF',
	'smw_exportrdf_docu' => '<p>Ta strona pozwala eksportować fragmenty artykułu w formacie RDF.  Aby wyeksportować artykuły, wpisz ich tytuły w poniższym polu tekstowym, po jednym tytule w wierszu.</p>',
	'smw_exportrdf_recursive' => 'Rekursywny eksport wszystkich powiązanych stron.  Zwróć uwagę, że wynik może być olbrzymi!',
	'smw_exportrdf_backlinks' => 'Eksportuj także wszystkie strony, które odwołują się do eksportowanych stron.  Tworzy przeglądalny RDF.',
	'properties' => 'Właściwości',
	'tooltip-purge' => 'Kliknij tutaj, aby odświeżyć wszystkie zapytania i szablony na tej stronie',
	'smw_purge' => 'Odśwież',
	'ontologyimport' => 'Importuj ontologię',
	'smw_oi_docu' => 'Ta strona specjalna pozwala na import ontologii.  Ontologie muszą być reprezentowane w odpowiednim formacie, opisanym na <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">stronie pomocy poświęconej importowi ontologii</a>.',
	'smw_oi_action' => 'Import',
	'smw_oi_return' => 'Powrót do <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Nie podano ontologii, lub podana ontologia nie mogła być załadowana.',
	'smw_oi_select' => 'Wybierz zdania do importu, a następnie kliknij przycisk importu.',
	'smw_oi_textforall' => 'Nagłówek do dodania dla wszystkich importów (może być pusty):',
	'smw_oi_selectall' => 'Zaznacz lub odznacz wszystkie zdania',
	'smw_oi_statementsabout' => 'Zdania o',
	'smw_oi_mapto' => 'Mapuj encję na',
	'smw_oi_comment' => 'Dodaj następujący tekst:',
	'smw_oi_thisissubcategoryof' => 'Jest podkategorią',
	'smw_oi_thishascategory' => 'Jest częścią',
	'smw_oi_importedfromontology' => 'Import z ontologii',
	'types' => 'Typy',
	'smw_types_docu' => 'Poniżej znajduje się lista wszystkich typów które mogą być przypisane atrybutom.  Każdy typ posiada artykuł, w którym mogą znajdować się dodatkowe informacje.',
	'uriresolver' => 'Resolver URI',
	'smw_uri_doc' => '<p>Resolver URI implementuje <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Dzięki temu ludzie nie zamieniają się w strony WWW.</p>',
	'ask' => 'Szukanie semantyczne',
	'smw_ask_sortby' => 'Sortuj po kolumnie',
	'smw_ask_ascorder' => 'Rosnąco',
	'smw_ask_descorder' => 'Malejąco',
	'smw_ask_submit' => 'Szukaj wyników',
	'smw_ask_hidequery' => 'Ukryj zapytanie',
	'searchbyproperty' => 'Szukaj po atrybucie',
	'smw_sbv_docu' => '<p>Szukanie wszystkich stron, które mają dany atrybut i wartość.</p>',
	'smw_sbv_noproperty' => '<p>Wpisz atrybut.</p>',
	'smw_sbv_novalue' => '<p>Wpisz wartość, lub zobacz wszystkie wartości atrybutów dla $1.</p>',
	'smw_sbv_displayresult' => 'Lista wszystkich stron, które mają atrybut $1 z wartością $2.',
	'smw_sbv_property' => 'Atrybut',
	'smw_sbv_value' => 'Wartość',
	'smw_sbv_submit' => 'Znajdź wyniki',
	'browse' => 'Przeglądaj artykuły',
	'smw_browse_article' => 'Wpisz nazwę artykułu, od którego chcesz rozpocząć przeglądanie.',
	'smw_browse_go' => 'Idź',
	'pageproperty' => 'Szukanie własności stron',
	'smw_pp_docu' => 'Wyszukiwanie wszystkich wartości danej właściwości na zadanej stronie.
Podaj zarówno stronę, jak i właściwość.',
	'smw_pp_from' => 'Od strony',
	'smw_pp_type' => 'Własność',
	'smw_pp_submit' => 'Znajdź wyniki',
	'smw_result_prev' => 'Poprzednie',
	'smw_result_next' => 'Następne',
	'smw_result_results' => 'Wyniki',
	'smw_result_noresults' => 'Niestety, brak wyników.',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'smw_finallistconjunct' => '، او',
	'properties' => 'ځانتياوې',
	'unusedproperties' => 'ناکارېدلې ځانتياوې',
	'wantedproperties' => 'غوښتل شوې ځانتياوې',
	'smw_sbv_value' => 'ارزښت',
	'smw_browse_go' => 'ورځه',
	'smw_result_prev' => 'پخواني',
	'smw_result_next' => 'راتلونکي',
	'smw_result_results' => 'پايلې',
	'smw_result_noresults' => 'اوبښۍ، هېڅ کومه پايله نشته.',
);

/** Portuguese (Português)
 * @author 555
 * @author Lijealso
 * @author Malafaya
 */
$messages['pt'] = array(
	'smw_edithelp' => 'Ajuda de edição sobre propriedades',
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => 'e',
	'smw_factbox_head' => 'Dados acerca $1',
	'smw_isspecprop' => 'Esta propriedade é uma propriedade especial neste wiki.',
	'smw_isknowntype' => 'Este tipo está entre os tipos de dados padrão deste wiki.',
	'smw_isaliastype' => 'Este tipo é um alias do tipo de dados “$1”.',
	'smw_isnotype' => 'Este tipo “$1” não é um tipo de dados padrão no wiki, e também não lhe foi dada uma definição de utilizador.',
	'smw_concept_description' => 'Descrição do conceito "$1"',
	'smw_no_concept_namespace' => 'Conceitos podem ser definidos apenas através das páginas do espaço nominal Concept:.',
	'smw_multiple_concepts' => 'Cada página de conceito pode possuir apenas uma definição de conceito.',
	'smw_concept_cache_miss' => 'O conceito "$1" não poderá ser utilizado neste momento, uma vez que a configuração deste wiki necessita ser refeita off-line. Caso o problema não seja resolvido automaticamente dentro de algum tempo, peça a um administrador deste wiki que este conceito seja disponibilizado.',
	'smw_baduri' => 'Desculpe, URIs da forma “$1” não são permitidos.',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendário',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Desculpe. Pesquisas semânticas foram desactivadas neste wiki.',
	'smw_iq_moreresults' => '… mais resultados',
	'smw_iq_nojs' => 'Por favor, use um navegador com JavaScript activado para visualizar este elemento.',
	'smw_iq_altresults' => 'Navegar pela lista de resultados directamente.',
	'smw_unknown_importns' => 'As funções de importação não estão disponíveis para o espaço nominal “$1”.',
	'smw_nonright_importtype' => '$1 só pode ser usado com páginas no espaço nominal “$2”.',
	'smw_wrong_importtype' => '$1 não pode ser usado com páginas no espaço nominal “$2”.',
	'smw_no_importelement' => 'Elemento “$1” não disponível para importação.',
	'smw_parseerror' => 'O valor fornecido não foi compreendido.',
	'smw_notitle' => '“$1” não pode ser usado como nome de página neste wiki.',
	'smw_unknowntype' => 'Tipo não suportado “$1”  definido para propriedade.',
	'smw_manytypes' => 'Mais do que um tipo definido para a propriedade.',
	'smw_emptystring' => 'Cadeias de caracteres vazias não são aceites.',
	'smw_maxstring' => 'Representação de cadeia de caracteres $1 é demasiado longa para {{SITENAME}}.',
	'smw_notinenum' => '“$1” não está na lista de valores possíveis ($2) para esta propriedade.',
	'smw_noboolean' => '“$1” não é reconhecido como um valor boleano (verdadeiro/falso).',
	'smw_true_words' => 'verdadeiro,v,sim,s',
	'smw_false_words' => 'falso,f,não,nao,n',
	'smw_nofloat' => '“$1” não é um número.',
	'smw_infinite' => 'Números tão grandes como “$1” não são suportados em {{SITENAME}}.',
	'smw_infinite_unit' => 'A conversão para a unidade “$1” resultou num número demasiado grande para {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Prefixos em números (“$1”) não são suportados.',
	'smw_unsupportedunit' => 'Conversão de unidade para unidade “$1” não suportada.',
	'smw_lonely_unit' => 'Nenhum número encontrado antes do símbolo “$1”.',
	'smw_bad_latlong' => 'A latitude e a longitude só podem ser fornecidas uma vez, e com coordenadas válidas.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'E',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'O',
	'smw_label_latitude' => 'Latitude:',
	'smw_label_longitude' => 'Longitude:',
	'smw_nodatetime' => 'A data “$1” não foi compreendida.',
	'smw_toomanyclosing' => 'Parece haver demasiadas ocorrências de “$1” na pesquisa.',
	'smw_noclosingbrackets' => 'Um uso de “<nowiki>[[</nowiki>” na sua pesquisa não foi fechada por um “]]” correspondente.',
	'smw_misplacedsymbol' => 'O símbolo “$1” foi usado num sítio onde não é útil.',
	'smw_unexpectedpart' => 'A parte “$1” da pesquisa não foi compreendida.
Os resultados podem não ser os esperados.',
	'smw_emptysubquery' => 'Uma subpesquisa tem uma condição inválida.',
	'smw_misplacedsubquery' => 'Uma subpesquisa foi usada num local onde não são permitidas subpesquisas.',
	'smw_valuesubquery' => 'Subpesquisas não suportadas para valores da propriedade “$1”.',
	'smw_overprintoutlimit' => 'Esta pesquisa contém demasiados pedidos de saídas.',
	'smw_badprintout' => 'Uma frase de saída na pesquisa estava mal formada.',
	'smw_badtitle' => 'Desculpe, mas “$1” não é um título de página válido.',
	'smw_badqueryatom' => 'Uma parte “<nowiki>[[…]]</nowiki>” da pesquisa não foi compreendida.',
	'smw_propvalueproblem' => 'O valor da propriedade “$1” não foi compreendido.',
	'smw_nodisjunctions' => 'Disjunções em pesquisas não são suportadas neste wiki e parte da pesquisa foi descartada ($1).',
	'smw_querytoolarge' => 'As seguintes condições da pesquisa não puderam ser consideradas devido às restrições dos wikis em tamanho ou profundidade de pesquisa: $1.',
	'smw_devel_warning' => 'Esta funcionalidade está neste momento em desenvolvimento, e pode não estar totalmente funcional.
Faça uma cópia de segurança dos seus dados antes de a usar.',
	'smw_type_header' => 'Propriedades do tipo “$1”',
	'smw_typearticlecount' => 'Exibindo $1 {{PLURAL:$1|propriedade que usa|propriedades que usam}} este tipo.',
	'smw_attribute_header' => 'Páginas que usam a propriedade “$1”',
	'smw_attributearticlecount' => 'Exibindo $1 {{PLURAL:$1|página que usa|páginas que usam}} esta propriedade.',
	'smw_subproperty_header' => 'Subpropriedades',
	'smw_subpropertyarticlecount' => 'Esta propriedade possui {{PLURAL:$1|a seguinte subpropriedade|as seguintes $1 subpropriedades}}.',
	'smw_concept_header' => 'Páginas do conceito "$1"',
	'smw_conceptarticlecount' => 'Exibindo {{PLURAL:$1|uma página pertencente|$1 páginas pertencentes}} à este conceito.',
	'smw_rss_description' => 'Feed RSS de $1',
	'exportrdf' => 'Exportar páginas para RDF',
	'smw_exportrdf_docu' => '<p>Esta página permite-lhe obter dados de uma página no formato RDF.
Para exportar páginas, introduza os seus títulos na caixa de texto abaixo, um título por linha.</p>',
	'smw_exportrdf_recursive' => 'Exportar recursivamente todas as páginas relacionadas.
Note que o resultado poderá ser grande!',
	'smw_exportrdf_backlinks' => 'Também exporta todas as páginas que referem as páginas exportadas.
Gera RDF navegável.',
	'smw_exportrdf_lastdate' => 'Não exporte páginas que não foram alteradas desde o tempo dado.',
	'properties' => 'Propriedades',
	'smw_properties_docu' => 'As seguintes propriedades são usadas neste wiki.',
	'smw_property_template' => '$1 de tipo $2 ($3)',
	'smw_propertylackspage' => 'Todas as propriedades devem ser descritas por uma página!',
	'smw_propertylackstype' => 'Nenhum tipo foi especificado para esta propriedade (assumindo tipo $1 por agora).',
	'smw_propertyhardlyused' => 'Esta propriedade dificilmente é usada neste wiki!',
	'unusedproperties' => 'Propriedades não usadas',
	'smw_unusedproperties_docu' => 'As seguintes propriedade existem apesar de nenhuma página fazer uso delas.',
	'smw_unusedproperty_template' => '$1 de tipo $2',
	'wantedproperties' => 'Propriedades em falta',
	'smw_wantedproperties_docu' => 'As seguintes propriedades são usadas no wiki mas ainda não têm uma página que as descreva.',
	'smw_wantedproperty_template' => '$1 ($2 usos)',
	'tooltip-purge' => 'Carregue aqui para refrescar todas as pesquisas e predefinições nesta página',
	'smw_purge' => 'Refrescar',
	'ontologyimport' => 'Importar ontologia',
	'smw_oi_docu' => 'Esta página especial permite importar ontologias.
As ontologias têm de seguir um certo formato, especificado na <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">página de ajuda à importação de ontologias</a>.',
	'smw_oi_action' => 'Importar',
	'smw_oi_return' => 'Voltar para <a href="$1">{{ns:Special}}:OntologyImport</a>.',
	'smw_oi_noontology' => 'Nenhuma ontologia fornecida, ou não foi possível carregar ontologia.',
	'smw_oi_select' => 'Por favor, seleccione as frases a importar, e depois carregue no botão de importar.',
	'smw_oi_textforall' => 'Texto do cabeçalho a adicionar a todas as importações (pode ser vazio):',
	'smw_oi_selectall' => 'Seleccionar ou desseleccionar todas as frases',
	'smw_oi_statementsabout' => 'Frases sobre',
	'smw_oi_mapto' => 'Mapear entidade para',
	'smw_oi_comment' => 'Adicione o seguinte texto:',
	'smw_oi_thisissubcategoryof' => 'Uma subcategoria de',
	'smw_oi_thishascategory' => 'É parte de',
	'smw_oi_importedfromontology' => 'Importar de ontologia',
	'types' => 'Tipos',
	'smw_types_docu' => 'As seguinte lista contém todos os tipos de dados que podem ser atribuídos a propriedades.
Cada tipo de dados tem uma página onde informação adicional pode ser providenciada.',
	'smw_typeunits' => 'Unidades de medida de tipo “$1”: $2',
	'semanticstatistics' => 'Estatísticas de semântica',
	'smw_semstats_text' => 'Este wiki contém <b>$1</b> valores de propriedades num total de <b>$2</b> <a href="$3">propriedades</a> diferentes.
<b>$4</b> propriedades têm uma página própria, e o tipo de dados pretendido é especificado por b>$5</b> delas.
Algumas das propriedades existentes poderão ser <a href="$6">propriedades não usadas</a>.
As propriedades a que faltam uma página poderão ser encontradas na <a href="$7">lista de propriedades em falta</a>.',
	'flawedattributes' => 'Propriedades Problemáticas',
	'smw_fattributes' => 'As páginas listadas abaixo contêm uma propriedade incorrectamente definida.
O número de propriedades incorrectas é dada entre parênteses rectos.',
	'uriresolver' => 'Resolvedor de URIs',
	'smw_uri_doc' => '<p>O resolvedor de URIs implementa a <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">descoberta TAG da W3C sobre o httpRange-14</a>. Trata que humanos não se tornem em sítios web.</p>',
	'ask' => 'Pesquisa semântica',
	'smw_ask_sortby' => 'Ordenar por coluna (opcional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Procurar resultados',
	'smw_ask_editquery' => '[Editar pesquisa]',
	'smw_add_sortcondition' => '[Adicionar condição de ordenação]',
	'smw_ask_hidequery' => 'Esconder pesquisa',
	'smw_ask_help' => 'Ajuda sobre pesquisas',
	'smw_ask_queryhead' => 'Pesquisa',
	'smw_ask_printhead' => 'Saídas adicionais (opcional)',
	'searchbyproperty' => 'Procurar por propriedade',
	'smw_sbv_docu' => '<p>Buscar todas as páginas que possuem uma determinada propriedade e valor.</p>',
	'smw_sbv_noproperty' => '<p>Por favor, introduza uma propriedade.</p>',
	'smw_sbv_novalue' => '<p>Por favor, introduza um valor válido para a propriedade, ou veja todos os valores da propriedade “$1.”</p>',
	'smw_sbv_displayresult' => 'Segue-se uma lista de todas as páginas que possuem a propriedade “$1” com valor “$2”',
	'smw_sbv_displayresultfuzzy' => 'Uma lista de todas as páginas que têm a propriedade "$1" com o valor "$2".
Uma vez que houve poucos resultados, valores próximos são também apresentados.',
	'smw_sbv_property' => 'Propriedade',
	'smw_sbv_value' => 'Valor',
	'smw_sbv_submit' => 'Procurar resultados',
	'browse' => 'Navegue pela wiki',
	'smw_browselink' => 'Navegar pelas propriedades',
	'smw_browse_article' => 'Introduza o nome da página a partir da qual deseja começar a navegar.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'exibir propriedades que apontem para cá',
	'smw_browse_hide_incoming' => 'ocultar propriedades que apontem para cá',
	'smw_browse_no_outgoing' => 'Esta página não possui propriedades.',
	'smw_browse_no_incoming' => 'Nenhuma propriedade linca para esta página.',
	'smw_inverse_label_default' => '$1 de',
	'pageproperty' => 'Busca de propriedades de página',
	'smw_pp_docu' => 'Buscar todos os conteúdos de uma propriedade numa dada página.
Por favor, introduza ambas a página e a propriedade.',
	'smw_pp_from' => 'Da página',
	'smw_pp_type' => 'Propriedade',
	'smw_pp_submit' => 'Procurar resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Seguinte',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Desculpe, não há resultados.',
	'smwadmin' => 'Funções administrativas do Semantic MediaWiki',
);

/** Tarifit (Tarifit)
 * @author Jose77
 */
$messages['rif'] = array(
	'smw_browse_go' => 'Raḥ ɣa',
);

/** Romanian (Română)
 * @author KlaudiuMihaila
 */
$messages['ro'] = array(
	'smw_sbv_value' => 'Valoare',
	'smw_result_noresults' => 'Ne pare rău, nici un rezultat.',
);

/** Russian (Русский)
 * @author QuestPC
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'smw_edithelp' => 'Редактирование справки по свойствам',
	'smw_viewasrdf' => 'RDF источник',
	'smw_finallistconjunct' => ' и',
	'smw_factbox_head' => 'Факты: $1',
	'smw_isspecprop' => 'Это свойство является специальным для данного сайта.',
	'smw_isknowntype' => 'Этот тип данных принадлежит к стандартным типам данных данного сайта.',
	'smw_isaliastype' => 'Этот тип данных является альтернативным именем типа данных “$1”.',
	'smw_isnotype' => 'Тип данных “$1” не был определен.',
	'smw_concept_description' => 'Описание представления «$1»',
	'smw_no_concept_namespace' => 'Представления могут определяться только на страницах, принадлежащих пространству имён «Представление:» («Concept:»).',
	'smw_multiple_concepts' => 'Страница представления может содержать только одно определение представления.',
	'smw_concept_cache_miss' => 'Представление «$1» в настоящий момент не может быть использовано, так как настройка вики-сайта требует, чтобы его результат определялся в фоновом режиме. Если данное сообщение не исчезнет через некоторое время, обратитесь к администратору вики-сайта для включения данного представления.',
	'smw_baduri' => 'Извините, но ссылки из диапазона "$1" не доступны отсюда.',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iКалендарь',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Извините, но встроенные запросы отключены для этого сайта.',
	'smw_iq_moreresults' => '&hellip; следующие результаты',
	'smw_iq_nojs' => 'Используйте браузер с поддержкой JavaScript для просмотра данного элемента.',
	'smw_iq_altresults' => 'Просмотреть список результатов.',
	'smw_unknown_importns' => 'Ошибка: Функции импорта не доступны для пространства имен "$1".',
	'smw_nonright_importtype' => 'Ошибка: $1 может быть использован только для статей с пространством имен "$2".',
	'smw_wrong_importtype' => 'Ошибка: $1 не может быть использован для статей с пространством имен "$2".',
	'smw_no_importelement' => 'Ошибка: Элемент "$1" не доступен для импорта.',
	'smw_parseerror' => 'Переданное значение не было понято.',
	'smw_decseparator' => ',',
	'smw_notitle' => '“$1” не может быть использован как заголовок статьи на данном сайте.',
	'smw_unknowntype' => 'Тип "$1" не поддерживается для данного свойства.',
	'smw_manytypes' => 'Более одного типа определено для свойства.',
	'smw_emptystring' => 'Пустые строки недопустимы.',
	'smw_maxstring' => 'Ошибка: Строковое представление $1 слишком длинное для этого сайта.',
	'smw_notinenum' => '"$1" не входит в список допустимых значений ($2) для этого свойства.',
	'smw_noboolean' => '"$1" не является булевым значением (да/нет).',
	'smw_true_words' => 'да,t,yes,д,истина,и,true',
	'smw_false_words' => 'нет,f,no,n,н,ложь,л,false',
	'smw_nofloat' => '"$1" не является числом.',
	'smw_infinite' => 'Ошибка: Столь длинные числа как $1 не поддерживаются этим сайтом.',
	'smw_infinite_unit' => 'Ошибка: Преобразование значения в единицы измерения “$1” привело к слишком длинному числу для этого сайта.',
	'smw_unsupportedprefix' => 'Префиксы для чисел ("$1") не поддерживаются в настоящее время.',
	'smw_unsupportedunit' => 'Преобразование единиц измерения для "$1" не поддерживается.',
	'smw_lonely_unit' => 'Числовое значение перед символом “$1” отсутствует.',
	'smw_bad_latlong' => 'Широта и долгота должны быть заданы только один раз, и с корректными координатами.',
	'smw_abb_north' => 'С',
	'smw_abb_east' => 'В',
	'smw_abb_south' => 'Ю',
	'smw_abb_west' => 'З',
	'smw_label_latitude' => 'Широта:',
	'smw_label_longitude' => 'Долгота:',
	'smw_nodatetime' => 'Дата "$1" не распознана.',
	'smw_toomanyclosing' => 'Ошибка: Слишком много вхождений “$1” в данном запросе.',
	'smw_noclosingbrackets' => 'Открывающаяся пара скобок «<nowiki>[[</nowiki>» не была закрыта парой соответствующих ей закрывающих скобок «]]» в данном запросе.',
	'smw_misplacedsymbol' => 'Ошибка: Использование символа “$1” в данном месте лишено смысла.',
	'smw_unexpectedpart' => 'Ошибка: Часть “$1” запроса не была распознана. Результаты могут отличаться от ожидаемых.',
	'smw_emptysubquery' => 'Ошибка: В одном из подзапросов не указано правильного знака условия.',
	'smw_misplacedsubquery' => 'Ошибка: Подзапрос используется в месте, где подзапросы не разрешены.',
	'smw_valuesubquery' => 'Ошибка: Подзапросы не поддерживаются для значений свойства “$1”.',
	'smw_overprintoutlimit' => 'Ошибка: Запрос содержит слишком много требований вывода.',
	'smw_badprintout' => 'Ошибка: Некоторое выражение вывода в запросе неправильно составлено.',
	'smw_badtitle' => 'Извините, но “$1” не является правильным заголовком статьи.',
	'smw_badqueryatom' => 'Часть запроса «<nowiki>[[…]]</nowiki>» не была разобрана.',
	'smw_propvalueproblem' => 'Ошибка: Значение свойства “$1” не разобрано.',
	'smw_noqueryfeature' => 'Часть запроса была опущена, так как некоторые из возможностей языка запросов не поддерживаются на этом вики-сайте ($1).',
	'smw_noconjunctions' => 'Часть запроса была опущена, так как операция «Логическое И» не поддерживается на этом вики-сайте ($1).',
	'smw_nodisjunctions' => 'Ошибка: Дизъюнкции (логическое ИЛИ) не поддерживаются данным сайтом, поэтому использующая их часть запроса была проигнорирована ($1).',
	'smw_querytoolarge' => 'Ошибка: Указанные условия запроса “$1” не могут быть выполнены из-за ограничения на глубину или размер запроса.',
	'smw_devel_warning' => 'Эта функция в настоящее время находится в разработке. Сделайте резервную копию прежде чем её использовать.',
	'smw_notemplategiven' => 'Чтобы данный запрос выполнялся, необходимо задать значение для параметра «template».',
	'smw_type_header' => 'Свойства типа “$1”',
	'smw_typearticlecount' => '{{PLURAL:$1|Отображается|Отображаются|Отображаются}} $1 {{PLURAL:$1|свойство|свойства|свойств}} этого типа.',
	'smw_attribute_header' => 'Страницы, использующие свойство “$1”',
	'smw_attributearticlecount' => '{{PLURAL:$1|Отображается|Отображаются|Отображаются}} $1 {{PLURAL:$1|страница, использующая|страницы, использующие|страниц, использующие}} это свойство.',
	'smw_subproperty_header' => 'Подсвойства',
	'smw_subpropertyarticlecount' => 'Это свойство имеет $1 {{PLURAL:$1|подсвойство|подсвойства|подсвойств}}.',
	'smw_concept_header' => 'Страницы, использующие представление «$1»',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Показана|Показаны|Показаны}} $1 {{PLURAL:$1|страница|страницы|страниц}}, {{PLURAL:$1|принадлежащая|принадлежащие|принадлежащие}} данному представлению.',
	'smw_rss_description' => '$1 источник RSS',
	'exportrdf' => 'Экспорт страниц в RDF',
	'smw_exportrdf_docu' => '<p>Эта страница позволяет экспортировать части статьи в формате RDF. Наберите заголовки необходимых статей по одному на строку.</p>',
	'smw_exportrdf_recursive' => 'Рекурсивный экспорт всех связанных страниц. Результат этой операции может быть очень большим!',
	'smw_exportrdf_backlinks' => 'Также экспортировать все страницы, которые ссылаются на экспортируемые страницы. Генерирует RDF с поддержкой полноценной навигации.',
	'smw_exportrdf_lastdate' => 'Не экспортировать страницы, которые не менялись с указанной даты.',
	'properties' => 'Свойства',
	'smw_properties_docu' => 'Следующие свойства используются на данном сайте.',
	'smw_property_template' => '$1 имеет тип $2, количество использований ($3)',
	'smw_propertylackspage' => 'Каждое свойство должно иметь свою страницу описания!',
	'smw_propertylackstype' => 'Данному свойству не сопоставлен тип данных (по умолчанию будет использоваться тип $1).',
	'smw_propertyhardlyused' => 'Это свойство изначально предопределено для данного сайта!',
	'unusedproperties' => 'Неиспользуемые свойства',
	'smw_unusedproperties_docu' => 'Следующие свойства определены, но не используются ни в одной из статей.',
	'smw_unusedproperty_template' => '$1 имеет тип $2',
	'wantedproperties' => 'Неописанные свойства',
	'smw_wantedproperties_docu' => 'Следующие свойства используются в статьях данного сайта, но не имеют соответствующих им страниц описаний.',
	'smw_wantedproperty_template' => '$1 ($2 использований)',
	'tooltip-purge' => 'Нажмите здесь для обновления всех запросов и шаблонов на этой странице',
	'smw_purge' => 'Обновить',
	'ontologyimport' => 'Импорт онтологии',
	'smw_oi_docu' => 'Это специальная страница для импорта онтологий. Формат онтологии приведен на <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">странице справки</a>.',
	'smw_oi_action' => 'Импорт',
	'smw_oi_return' => 'Вернуться к <a href="$1">Импорту онтологий</a>.',
	'smw_oi_noontology' => 'Онтология не задана или не может быть загружена.',
	'smw_oi_select' => 'Пожалуйста, выберите утверждения для импорта и нажмите кнопку Импорт.',
	'smw_oi_textforall' => 'Текст заголовка для импорта (может быть пустым):',
	'smw_oi_selectall' => 'Включите/отключите все утверждения',
	'smw_oi_statementsabout' => 'Утверждения о',
	'smw_oi_mapto' => 'Отобразить сущность на',
	'smw_oi_comment' => 'Добавьте текст:',
	'smw_oi_thisissubcategoryof' => 'Является подкатегорией для',
	'smw_oi_thishascategory' => 'Является частью',
	'smw_oi_importedfromontology' => 'Импортировать из онтологии',
	'types' => 'Типы',
	'smw_types_docu' => 'Список поддерживаемых типов свойств. Каждый тип имеет страницу, на которую можно поместить его расширенное описание.',
	'smw_typeunits' => 'Единицы измерения типа “$1”: $2',
	'semanticstatistics' => 'Семантическая статистика',
	'smw_semstats_text' => 'Данный сайт содержит <b>$1</b> значений свойств, общее количество различных <a href="$3">свойств</a> равно <b>$2</b>. <b>$4</b> свойств имеют страницу описания. Определенный тип данных задан на соответствующей странице описания для <b>$5</b> из общего числа свойств. Некоторые из существующих свойств могут <a href="$6">не использоваться</a>. Свойства, для которых не созданы страницы описания, могут быть найдены по специальной ссылке <a href="$7">список неописанных свойств</a>.',
	'flawedattributes' => 'Поврежденные свойства',
	'smw_fattributes' => 'Статьи, указанные ниже, содержат неправильно определенные свойства. Количество неверных свойств указано в скобках.',
	'uriresolver' => 'Преобразователь URI',
	'smw_uri_doc' => '<p>Преобразователь URI осуществляет <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C поиск http тэгов с использованием Range-14</a>. Данная возможность упрощает поиск семантической информации.</p>',
	'ask' => 'Семантический поиск',
	'smw_ask_sortby' => 'Сортировать по столбцу',
	'smw_ask_ascorder' => 'По возрастанию',
	'smw_ask_descorder' => 'По убыванию',
	'smw_ask_submit' => 'Найти',
	'smw_ask_editquery' => '[Редактировать запрос]',
	'smw_add_sortcondition' => '[Добавить условие сортировки]',
	'smw_ask_hidequery' => 'Скрыть запрос',
	'smw_ask_help' => 'Помощь по составлению запросов',
	'smw_ask_queryhead' => 'Запрос',
	'smw_ask_printhead' => 'Дополнительные поля вывода (не являются обязательными)',
	'searchbyproperty' => 'Искать по свойству',
	'smw_sbv_docu' => '<p>Искать все страницы, которые содержат указаннок свойство и значение.</p>',
	'smw_sbv_noproperty' => '<p>Укажите свойство.</p>',
	'smw_sbv_novalue' => '<p>Укажите значение или просмотрите все значения свойства $1.</p>',
	'smw_sbv_displayresult' => 'Список всех страниц, которые содержат свойство $1 со значением $2.',
	'smw_sbv_displayresultfuzzy' => 'Список всех страниц, содержащих свойство «$1» со значением «$2».
Так как количество точных результатов невелико, также показаны страницы, содержащие близкие значения данного свойства.',
	'smw_sbv_property' => 'Свойство',
	'smw_sbv_value' => 'значение',
	'smw_sbv_submit' => 'Найти',
	'browse' => 'Просмотреть сайт',
	'smw_browselink' => 'Просмотреть свойства',
	'smw_browse_article' => 'Введите имя страницы для начала просмотра.',
	'smw_browse_go' => 'Перейти',
	'smw_browse_show_incoming' => 'показать свойства, ссылающиеся сюда',
	'smw_browse_hide_incoming' => 'скрыть свойства, ссылающиеся сюда',
	'smw_browse_no_outgoing' => 'Эта страница не содержит свойств.',
	'smw_browse_no_incoming' => 'Нет свойства, ссылающихся на эту страницу.',
	'smw_inverse_label_default' => '$1 из',
	'smw_inverse_label_property' => 'Метка обратного свойства',
	'pageproperty' => 'Страница поиска свойств',
	'smw_pp_docu' => 'Искать все значения свойства на указанной странице. Пожалуйста введите имя страницы и имя свойства.',
	'smw_pp_from' => 'Со страницы',
	'smw_pp_type' => 'Свойство',
	'smw_pp_submit' => 'Поиск результатов',
	'smw_result_prev' => 'Предыдущая',
	'smw_result_next' => 'Следующая',
	'smw_result_results' => 'Результаты',
	'smw_result_noresults' => 'Извините, но ничего не найдено.',
	'smwadmin' => 'Администрирование Semantic MediaWiki',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'smw_edithelp' => 'Pomoc pri upravovaní vzťahov a atribútov',
	'smw_viewasrdf' => 'RDF kanál',
	'smw_finallistconjunct' => ' a',
	'smw_factbox_head' => 'Skutočnosti o $1 &mdash; Kliknutím na <span class="smwsearchicon">+</span> vyhľadáte podobné stránky.',
	'smw_isspecprop' => 'Táto vlastnosť je špeciálna vlastnosť na tejto wiki.',
	'smw_isknowntype' => 'Tento typ patrí medzi štandardné údajové typy na tejto wiki.',
	'smw_isaliastype' => 'Tento typ je alias údajového typu „$1“.',
	'smw_isnotype' => 'Tento typ „$1“ nie je štandardný údajový typ na tejto wiki a nebol ani definovaný používateľom.',
	'smw_concept_description' => 'Popis pojmu „$1”',
	'smw_no_concept_namespace' => 'Pojmy je možné definovať iba na stránkach v mennom priestore Concept:',
	'smw_multiple_concepts' => 'Každý pojem môže mať iba jednu definíciu pojmu.',
	'smw_concept_cache_miss' => 'Pojem „$1” nemožno momentálne použiť, pretože konfigurácia wiki vyžaduje, aby sa vypočítal, keď wiki nebude pripojená. Ak problém po určitej dobe nezmizne, požiadajte správcu, aby tento pojem sprístupnil.',
	'smw_baduri' => 'Prepáčte, URI z rozsahu "$1" na tomto mieste nie sú dostupné.',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iCalendar',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Prepáčte. Inline queries have been disabled for this wiki.',
	'smw_iq_moreresults' => '&hellip; ďalšie výsledky',
	'smw_iq_nojs' => 'Na zobrazenie tohto prvku prosím použite prehliadač so zapnutým JavaScriptom.',
	'smw_iq_altresults' => 'Prehliadať priamo zoznam výsledkov.',
	'smw_unknown_importns' => 'Funkcie importu nie sú dostupné pre menný priestor "$1".',
	'smw_nonright_importtype' => '$1 je možné použiť iba pre stránky z menného priestoru "$2".',
	'smw_wrong_importtype' => '$1 nie je možné použiť pre stránky z menného priestoru "$2".',
	'smw_no_importelement' => 'Prvok "$1" nie je dostupný na import.',
	'smw_parseerror' => 'Zadaná hodnota nebola pochopená.',
	'smw_notitle' => '„$1“ nie je možné na tejto wiki použiť ako názov stránky.',
	'smw_wrong_namespace' => 'Sú tu povolené iba stránky v mennom priestore „$1”.',
	'smw_unknowntype' => 'Pre atribút je definovaný nepodporovaný typ "$1".',
	'smw_manytypes' => 'Pre atribút bol definovaný viac ako jeden typ.',
	'smw_emptystring' => 'Prázdne reťazcie nie sú akceptované.',
	'smw_maxstring' => 'Reprezentácia reťazca $1 je pre túro stránku príliš dlhá.',
	'smw_notinenum' => '„$1“ nie je v zozname možných hodnôt ($2) tejto vlastnosti.',
	'smw_noboolean' => '"$1" nebolo rozpoznané ako platná hodnota typy boolean (áno/nie).',
	'smw_true_words' => 'áno,true',
	'smw_false_words' => 'nie,false',
	'smw_nofloat' => '"$1" nie je číslo s plávajúcou desatinnou čiarkou.',
	'smw_infinite' => 'Čísla také dlhé ako $1 nie sú na tejto stránke podporované.',
	'smw_infinite_unit' => 'Konverzia na jednotky $1 dala ako výsledok číslo, ktoré je pre túto stránku príliš dlhé.',
	'smw_unsupportedprefix' => 'Predpony čísiel („$1“) nie sú podporované.',
	'smw_unsupportedunit' => 'konverzia jednotiek "$1" nie je podporované',
	'smw_lonely_unit' => 'Pred symbolom „$1“ sa nenachádza číslo.',
	'smw_bad_latlong' => 'Zemepisná šírka a dĺžka musia byť zadané iba raz a s platnými súradnicami.',
	'smw_abb_north' => 'S',
	'smw_abb_east' => 'V',
	'smw_abb_south' => 'J',
	'smw_abb_west' => 'Z',
	'smw_label_latitude' => 'Zemepisná šírka:',
	'smw_label_longitude' => 'Zemepisná dĺžka:',
	'smw_nodatetime' => 'Nevedel som interpretovať dátum "$1".',
	'smw_toomanyclosing' => 'Zdá sa, že požiadavka obsahuje príliš mnoho výskytov „$1“.',
	'smw_noclosingbrackets' => 'Niektoré použitie „<nowiki>[[</nowiki>” vo vašej požiadavke nebolo ukončené zodpovedajúcim „]]”.',
	'smw_misplacedsymbol' => 'Symbol „$1“ bol použitý na mieste, kde nemá význam.',
	'smw_unexpectedpart' => 'Časť požiadavky „$1“ nebola pochopená.
Výsledky nemusia byť podľa očakávaní.',
	'smw_emptysubquery' => 'Niektorá subpožiadavka nemá platný stav.',
	'smw_misplacedsubquery' => 'Niektorá subpožiadavka bola použitá na mieste, kde nie sú povolené subpožiadavky.',
	'smw_valuesubquery' => 'Subpožiadavky nie sú podporované pre hodnoty vlastnosti „$1“.',
	'smw_overprintoutlimit' => 'Požiadavka obsahuje príliš mnoho požiadaviek na výpis.',
	'smw_badprintout' => 'Niektorý príkaz na výpis v požiadavke bol chybne utvorený.',
	'smw_badtitle' => 'Prepáčte, ale „$1“ nie je platný názov stránky.',
	'smw_badqueryatom' => 'Niektorá časť „<nowiki>[[…]]</nowiki>“ nebola pochopená.',
	'smw_propvalueproblem' => 'Hodnota vlastnosti „$1“ nebola pochopená.',
	'smw_noqueryfeature' => 'Táto wiki nepodporuje istú časť požiadavky a jej časť bola ignorovaná ($1).',
	'smw_noconjunctions' => 'Táto wiki nepodporuje konjunkcie v požiadavkách a časť požiadavky bola ignorovaná ($1).',
	'smw_nodisjunctions' => 'Disjunkcie nie sú v požiadavkách na tejto wiki podporované a časť požiadavky bola ignorovaná ($1).',
	'smw_querytoolarge' => 'Nasledovné podmienky požiadavky nebudú zohľadnené z dôvodu obmedzení tejto wiki na dĺžku alebo hĺbku požiadavky: $1.',
	'smw_devel_warning' => 'Táto vlastnosť je momentálne vo vývoji a nemusí byť celkom funkčná. Predtým, než ju použijete si zálohujte dáta.',
	'smw_notemplategiven' => 'Aby tento formát požiadavky fungoval, poskytnite prosím hodnotu parametra „template”.',
	'smw_type_header' => 'Vlastnosti typu „$1“',
	'smw_typearticlecount' => '{{PLURAL:$1|Zobrazuje sa $1 vlastnosť|Zobrazujú sa $1 vlastnosti|Zobrazuje sa $1 vlastností}} tohto typu.',
	'smw_attribute_header' => 'Stránky používajúce vlastnosť „$1“',
	'smw_attributearticlecount' => 'Zobrazuje sa $1 {{PLURAL:$1|stránka|stránky|stránok}}, ktoré používajú túto vlastnosť.',
	'smw_subproperty_header' => 'Podvlastnosti',
	'smw_subpropertyarticlecount' => 'Táto vlastnosť má {{PLURAL:|nasledovnú podvlastnosť|nasledovné $1 podvlastnosti|nasledovných $1 podvlastností}}.',
	'smw_concept_header' => 'Návrh „$1”',
	'smw_conceptarticlecount' => 'Zobrazuje sa $1 {{PLURAL:$1|stránka patriaca|stránky patriace|stránok patriacich}} tomuto návrhu.',
	'exportrdf' => 'Exportovať stránky do RDF',
	'smw_exportrdf_docu' => '<p>Táto stránka vám umožňuje exportovať časti stránok do formátu RDF. Po zadaní názvov stránok do spodného textového poľa, jeden názov na riadok, môžete exportovať stránky.</p>',
	'smw_exportrdf_recursive' => 'Rekurzívne exportovať všetky súvisiace stránky. Pozor, výsledok môže byť veľmi veľký!',
	'smw_exportrdf_backlinks' => 'Tieť exportovať všetky stránky, ktoré odkazujú na exportované stránky. Vytvorí prehliadateľné RDF.',
	'smw_exportrdf_lastdate' => 'Neexportovať stránky, ktoré neboli zmenené od zadaného času.',
	'properties' => 'Vlastnosti',
	'smw_properties_docu' => 'Na tejto wiki sa používajú nasledovné vlastnosti.',
	'smw_property_template' => '$1 typu $2 ($3)',
	'smw_propertylackspage' => 'Všetky vlastnosti by mali mať popisnú stránku!',
	'smw_propertylackstype' => 'Pre túto vlastnosť nebol uvedený žiadny typ (nateraz sa predpokladá typ $1).',
	'smw_propertyhardlyused' => 'Táto vlastnosť sa na wiki takmer nepoužíva!',
	'unusedproperties' => 'Nepoužité vlastnosti',
	'smw_unusedproperties_docu' => 'Nasledovné vlastnosti existujú napriek tomu, že ich nevyužíva žiadna iná stránka.',
	'smw_unusedproperty_template' => '$1 typu $2',
	'wantedproperties' => 'Žiadané vlastnosti',
	'smw_wantedproperties_docu' => 'Nasledovné vlastnosti, ktoré existujú na tejto wiki, zatiaľ nemajú popisnú stránku.',
	'smw_wantedproperty_template' => '$1 (použité $2-krát)',
	'tooltip-purge' => 'Kliknutím sem obnovíte všetky dotazy a šablóny na tejto stránke',
	'smw_purge' => 'Obnoviť',
	'ontologyimport' => 'Importovať ontológiu',
	'smw_oi_docu' => 'Táto špeciálna stránka umožňuje import ontológií. Ontológie musia dodržiavať istý formát, špecifkovaný na <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">stránke pomocníka pre import ontógie</a>.',
	'smw_oi_action' => 'Importovať',
	'smw_oi_return' => 'Návrat na <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Ontológia nie je podporovaná alebo nebolo možné načítať ontológiu.',
	'smw_oi_select' => 'Prosím, vyberte výroky, ktoré sa majú importovať a porom kliknite na tlačidlo import.',
	'smw_oi_textforall' => 'Text hlavičky, ktorý sa pridá k všetkým importom (môže byť prázdny):',
	'smw_oi_selectall' => 'Vybrať alebo odobrať všetky výroky o',
	'smw_oi_statementsabout' => 'Výroky o',
	'smw_oi_mapto' => 'Mapuje entitu na',
	'smw_oi_comment' => 'Pridá nasledovný text:',
	'smw_oi_thisissubcategoryof' => 'Je podkategóriou',
	'smw_oi_thishascategory' => 'Je časťou',
	'smw_oi_importedfromontology' => 'Import z ontológie',
	'types' => 'Typy',
	'smw_types_docu' => 'Nasleduje zoznam všetkých údajových typov, ktoré je možné priradiť atribútom. Každý údajový typ má stránku, kde je možné poskytnúť dodatočné informácie.',
	'smw_typeunits' => 'Jednotky typu „$1“: $2',
	'semanticstatistics' => 'Sémantická štatistika',
	'smw_semstats_text' => 'Táto wiki obsahuje <b>$1</b> hodnôt vlastností celkom <b>$2</b> rozličných <a href="$3">vlastností</a>.
<b>$4</b> vlastností nemá vlastnú stránku a zamýšľaný údajový typ má uvedený <b>$5</b> z nich.
Niektoré z existujúcich vlastností môžu byť <a href="$6">nepoužité</a>.
Vlastnosti, ktorým stále chýba stránka sa nachádzajú na <a href="$7">zozname žiadaných vlastností</a>.',
	'flawedattributes' => 'Chybných atribútov',
	'smw_fattributes' => 'Nižšie uvedené stránky majú nesprávne definovaný atribút. Počet nesprávnych atribútov udáva číslo v zátvorkách.',
	'uriresolver' => 'Prekladač URI',
	'smw_uri_doc' => '<p>URI resolver sa stará o implementáciu <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG hľadanie na httpRange-14</a>. Stará sa o to, aby sa ľudia nestali webstránkami.</p>',
	'ask' => 'Sémantické vyhľadávanie',
	'smw_ask_sortby' => 'Zoradiť podľa stĺpca',
	'smw_ask_ascorder' => 'Vzostupne',
	'smw_ask_descorder' => 'Zostupne',
	'smw_ask_submit' => 'Nájdi výsledky',
	'smw_ask_editquery' => '[Upraviť požiadavku]',
	'smw_add_sortcondition' => '[Pridať podmienku na zoradenie]',
	'smw_ask_hidequery' => 'Skryť požiadavku',
	'smw_ask_help' => 'Pomocník pre požiadavky',
	'smw_ask_queryhead' => 'Požiadavka',
	'smw_ask_printhead' => 'Ďalšie výpisy (voliteľné)',
	'searchbyproperty' => 'Hľadať podľa hodnoty atribútu',
	'smw_sbv_docu' => '<p>Hľadať na wiki článok, ktorý má atribút s istou hodnotou.</p>',
	'smw_sbv_noproperty' => '<p>Nebol poskytnutý atribút. Prosím, poskytnite ho vo formulári.</p>',
	'smw_sbv_novalue' => '<p>Nebola poskytnutá hodnota. Prosím, poskytnite ju vo formulári alebo zobrazte všetky atribúty typu $1</p>',
	'smw_sbv_displayresult' => 'Zoznam všetkých článkov, ktoré majú atribút $1 $2.',
	'smw_sbv_displayresultfuzzy' => 'Zoznam všetkých stránok, ktoré majú vlastnosť „$1” s hodnotou „$2”.
Keďže výsledkov bolo len niekoľko, zobrazujú sa aj blízke hodnoty.',
	'smw_sbv_property' => 'Atribút:',
	'smw_sbv_value' => 'Hodnota:',
	'smw_sbv_submit' => 'Hľadať výsledky',
	'browse' => 'Prehliadať wiki',
	'smw_browselink' => 'Prehliadať vlastnosti',
	'smw_browse_article' => 'Zadajte názov stránky, od ktorej chcete začať prehliadať.',
	'smw_browse_go' => 'Vykonať',
	'smw_browse_show_incoming' => 'zobraziť vlastnosti, ktoré sem odkazujú',
	'smw_browse_hide_incoming' => 'skryť vlastnosti, ktoré sem odkazujú',
	'smw_browse_no_outgoing' => 'Táto stránka neobsahuje vlastnosti.',
	'smw_browse_no_incoming' => 'Žiadne vlastnosti neodkazujú na túto stránku.',
	'smw_inverse_label_default' => '$1 z',
	'smw_inverse_label_property' => 'Označenie inverznej vlastnosti',
	'pageproperty' => 'Hľadanie vlastností stránky',
	'smw_pp_docu' => 'Hľadanie všetkých výplní vlastnosti na zadanej stránke.
Prosím, zadajte stránku aj vlastnosť.',
	'smw_pp_from' => 'Od stránky',
	'smw_pp_type' => 'Vlastnosť',
	'smw_pp_submit' => 'Výsledky hľadania',
	'smw_result_prev' => 'Späť',
	'smw_result_next' => 'Ďalej',
	'smw_result_results' => 'Výsledky',
	'smw_result_noresults' => 'Prepáčte, žiadne výsledky.',
	'smwadmin' => 'Správcovské funkcie Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Nastavenie úložiska pre Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Úložisko bolo úspešne nastavené.',
	'smw_smwadmin_return' => 'Späť na $1',
	'smw_smwadmin_updatestarted' => 'Začal sa nový proces aktualizácie sémantických údajov.
Všetky uložené údaje budú znova zostavené alebo opravené tam, kde je to potrebné.
Na tejto špeciálnej stránke môžete sledovať priebeh aktualizácie.',
	'smw_smwadmin_updatenotstarted' => 'Už beží proces aktualizácie.
Nespustí sa ďalší.',
	'smw_smwadmin_updatestopped' => 'Všetky bežiace procesy aktualizácie boli zastavené.',
	'smw_smwadmin_updatenotstopped' => 'Bežiaci proces aktualizácie môžete zastaviť označením zaškrtávacieho poľa, čím potvrdíte, že ste si naozaj istý.',
	'smw_smwadmin_docu' => 'Táto špeciálna stránka vám pomôže počas inštalácie a aktualizácie <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Pamätajte na zálohovanie dôležitých údajov pred vykonávaním správcovských funkcií.',
	'smw_smwadmin_db' => 'Inštalácia a aktualizácia databázy',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki vyžaduje niektoré rozšírenia databázy MediaWiki, aby molo ukladať sémantické údaje.
Funkcia nižšie zabezpečuje správne nastavenie databázy.
Zmeny vykonané v tomto kroku neovplyvňujú zvyšok databázy MediaWiki a ak je to potrebné, je ich možno jednoducho vrátiť.
Túto funkcia nastavenia možno vykonať viacnásobne bez akejkoľvek ujmy, ale je potrebná iba raz počas inštalácie či aktualizácie.',
	'smw_smwadmin_permissionswarn' => 'Ak táto operácia zlyhá na chybách SQL, používateľ databázy, ktorého využíva vaša wiki (pozrite sa do LocalSettings.php) pravdepodobne nemá dostatočné privilégiá.
Buď udeľte tomuto používateľovi ďalšie privilégiá na vytváranie a mazanie tabuliek, dočasne zadajte prihlasovacie údaje používateľa root databázy do LocalSettings.php alebo použite skript na údržbu t>SMW_setup.php</tt>, ktorý dokáže využiť oprávnenia z AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Inicializovať alebo aktualizovať tabuľky',
	'smw_smwadmin_announce' => 'Oznámiť vašu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki má webovú službu na oznamovanie nových sémantických wiki lokalít.
Tým pomáha  udržiavať zoznam verejných lokalít používajúcich Semantic MediaWiki. najmä aby pomohla <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektu Semantic MediaWiki</a> získať prehľad typických využití Semantic MediaWiki.
ďalšie informácie o tejto službe nájdete na <a href="http://semantic-mediawiki.org/wiki/Registry">domovskej stránke Semantic MediaWiki</a>.',
	'smw_smwadmin_announcebutton' => 'Stlačením nasledovného tlačidla odošlete URL vašej wiki tejto službe.
Služba nebude registrovať wiki, ktoré nie sú verejne prístupné a bude ukladať iba verejne dostupné informácie.',
	'smw_smwadmin_datarefresh' => 'Oprava a aktualizácia dát',
	'smw_smwadmin_datarefreshdocu' => 'Je možné obnoviť všetky údaje Semantic MediaWiki na základe aktuálneho obsahu wiki.
To sa hodí na opravu poškodených údajov alebo obnovu údajov ak sa pri aktualizácii softvéru zmenil vnútorný formát ukladania údajov.
Aktualizáciu je možné spustiť na špeciálnej stránke a nebude dokočená okamžite.
Tu sa zobrazuje priebeh aktualizácie a môžete tu spustiť alebo zastaviť aktualizácie (ak túto funkciu správca nevypol).',
	'smw_smwadmin_datarefreshprogress' => 'Aktualizácia už prebieha.</b>
Je normálne, že aktualizácie prebieha pomaly, pretože obnovuje údaje iba po malých kúskoch naraz, keď používateľ zobrazí stránku wiki.
Rýchlejšie dokončenie tejto aktualizácie môžete dosiahnuť vyvolaním údržbového skriptu MediaWiki <tt>runJobs.php</tt> (použite voľbu <tt>--maxjobs 1000</tt> na obmedzenie počtu aktualizácii v jednej dávke).
Odhadovaný priebeh aktualizácie:',
	'smw_smwadmin_datarefreshbutton' => 'Spustiť aktualizáciu údajov',
	'smw_smwadmin_datarefreshstop' => 'Zastaviť túto aktualizáciu',
	'smw_smwadmin_datarefreshstopconfirm' => 'Áno, som si istý.',
	'smw_smwadmin_support' => 'Ako získať podporu',
	'smw_smwadmin_supportdocu' => 'V prípade problémov vám môžu pomôcť rozličné zdroje:',
	'smw_smwadmin_installfile' => 'Ak budete mať s inštaláciou problém, začnite kontrolou smerníc <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">v súbore INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Úplná používateľská dokumentácia Semantic MediaWiki sa nachádza na <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Chyby môžete oznamovať v systéme <a href="https://bugzilla.wikimedia.org/">MediaZilla</a>.',
	'smw_smwadmin_questions' => 'Ak máte ďalšie otázky alebo návrhy, zapojte sa do konferencie <a href="mailto:semediawiki-user@lists.sourceforge.net">semediawiki-user@lists.sourceforge.net</a>.',
);

/** Swedish (Svenska)
 * @author Boivie
 * @author Flrn
 * @author Lejonel
 * @author Leo Johannes
 * @author M.M.S.
 * @author Najami
 */
$messages['sv'] = array(
	'smw_edithelp' => 'Redigeringshjälp för egenskaper',
	'smw_viewasrdf' => 'RDF-matning',
	'smw_finallistconjunct' => ', och',
	'smw_factbox_head' => 'Fakta om $1',
	'smw_isspecprop' => 'Den här egenskapen är en specialegenskap på den här wikin.',
	'smw_isknowntype' => 'Den här datatypen är bland standardtyperna på den här wikin.',
	'smw_isaliastype' => 'Den här datatypen är ett alias för typen "$1".',
	'smw_isnotype' => 'Datatypen "$1" är inte en standardtyp på den här wikin, och har inte blivit givet en användardefinition.',
	'smw_concept_description' => 'Beskrivning av konceptet "$1"',
	'smw_no_concept_namespace' => 'Koncept kan endast defineras på sidor i namnrymden Concept:',
	'smw_multiple_concepts' => 'Varje konceptsida kan endast ha en konceptdefinition.',
	'smw_baduri' => 'Beklagar, URI-er på formen "$1" är inte tillåtet.',
	'smw_csv_link' => 'CSV',
	'smw_icalendar_link' => 'iKalender',
	'smw_vcard_link' => 'vCard',
	'smw_iq_disabled' => 'Beklagar. Semantiska efterfrågningar har slagits av på den här wikin.',
	'smw_iq_moreresults' => '… mer resultat',
	'smw_iq_nojs' => 'Var god använd en webbläsare som stödjer JavaScript för att visa det här elementet.',
	'smw_iq_altresults' => 'Gå igenom resultatslistan direkt.',
	'smw_unknown_importns' => 'Importeringfunktioner är inte tillgängliga för namnrymden "$1".',
	'smw_nonright_importtype' => '$1 kan endast användas för sidor i namnrymden "$2".',
	'smw_wrong_importtype' => '$1 kan inte användas för sidor i namnrymden "$2".',
	'smw_no_importelement' => 'Elementet "$1" är inte tillgänglig för importering.',
	'smw_parseerror' => 'Det angivna värdet förståddes inte.',
	'smw_notitle' => '"$1" kan inte användas som sidnamn på den här wikin.',
	'smw_wrong_namespace' => 'Endast sidor i namnrymden "$1" tillåts här.',
	'smw_unknowntype' => 'Typen "$1" som är definierad för egenskapen stödjs inte.',
	'smw_manytypes' => 'Mer än en typ definierad för egenskapen.',
	'smw_emptystring' => 'Tomma stränger accepteras inte.',
	'smw_maxstring' => 'Strängrepresentationen $1 är för lång för {{SITENAME}}.',
	'smw_notinenum' => '"$1" är inte i listan över möjliga värden ($2) för den här egenskapen.',
	'smw_noboolean' => '"$1" är inte erkänt som ett Boolean-värde (sant/falskt).',
	'smw_true_words' => 'sant,s,ja,j',
	'smw_false_words' => 'falskt,f,nej,n',
	'smw_nofloat' => '"$1" är inte ett tal.',
	'smw_infinite' => 'Tal så stora som "$1" stödjs inte på {{SITENAME}}.',
	'smw_infinite_unit' => 'Konvertering till enheten "$1" resulterade i ett tal som är för stort för {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Prefix för tal ("$1") stödjs inte.',
	'smw_unsupportedunit' => 'Enhetskonvertering för enheten "$1" stödjs inte.',
	'smw_lonely_unit' => 'Inget tal hittat förän symbolen "$1".',
	'smw_bad_latlong' => 'Bredd och längdgrad kan endast uppges en gång, och med giltiga koordinater.',
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'Ö',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'V',
	'smw_label_latitude' => 'Latitud:',
	'smw_label_longitude' => 'Longitud:',
	'smw_nodatetime' => 'Datumet "$1" förståddes inte.',
	'smw_toomanyclosing' => '"$1" uppträder för många gånger i efterfrågningen.',
	'smw_noclosingbrackets' => 'Användningen av "<nowiki>[[</nowiki>" i din efterfrågning stängdes inte av "]]".',
	'smw_misplacedsymbol' => 'Symbolen "$1" användes på en plats där den inte är användbar.',
	'smw_unexpectedpart' => 'Delen "$1" av efterfrågningen förstods inte.
Vissa resultat kan bli oväntade.',
	'smw_emptysubquery' => 'Någon underfråga har inget giltigt villkor.',
	'smw_misplacedsubquery' => 'Någon underfråga användes på ett ställe där inga underfrågor tillåts.',
	'smw_valuesubquery' => 'Underfrågor stöds inte för värden på egenskapen “$1”.',
	'smw_overprintoutlimit' => 'Efterfrågningen innehåller för många utskriftsbegäran.',
	'smw_badprintout' => 'Något utskriftsuttryck i frågan var felutformad.',
	'smw_badtitle' => 'Beklagar, "$1" är inte en giltig sidtitel.',
	'smw_badqueryatom' => 'Någon del “<nowiki>[[…]]</nowiki>” av frågan förstods inte.',
	'smw_propvalueproblem' => 'Värdet på egenskap “$1” förstods inte.',
	'smw_noqueryfeature' => 'För någon frågefunktion saknades det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_noconjunctions' => 'För konjunktioner i frågor saknas det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_nodisjunctions' => 'För disjunktioner i frågor saknas det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_querytoolarge' => 'Följande frågevillkor kunde inte tas hänsyn till på grund av wikins begränsningar i frågestorlek eller -djup: $1.',
	'smw_devel_warning' => 'Denna funktion är under utveckling, och fungerar kanske inte fullt ut.
Gör backup på din data innan du använder den.',
	'smw_notemplategiven' => 'För att den här frågan ska fungera behöver du ange ett värde på parametern "template".',
	'smw_type_header' => 'Egenskaper av typen “$1”',
	'smw_typearticlecount' => 'Visar $1 {{PLURAL:$1|egenskap|egenskaper}} som använder den här typen.',
	'smw_attribute_header' => 'Sidor som använder egenskapen "$1"',
	'smw_attributearticlecount' => 'Visar $1 {{PLURAL:$1|sida|sidor}} som använder den här egenskapen.',
	'smw_subproperty_header' => 'Underegenskaper',
	'smw_subpropertyarticlecount' => 'Denna egenskap har följande $1 {{PLURAL:$1|underegenskap|underegenskaper}}.',
	'exportrdf' => 'Exportera sidor till RDF',
	'smw_exportrdf_docu' => '<p>Den här sidan låter dig hämta data från en sida i RDF-format.
Skriv sidtitlar i textrutan härunder för att exportera sidor (en titel per rad).</p>',
	'smw_exportrdf_recursive' => 'Exportera alla relaterade sidor rekursivt.
Observera att resultatet kan bli stort!',
	'smw_exportrdf_backlinks' => 'Exportera också alla sidor som refererar till de exporterade sidorna.
Skapar en RDF som kan gås igenom.',
	'smw_exportrdf_lastdate' => 'Exportera inte sidor som inte ändrats efter den uppgivna tidpunkten.',
	'properties' => 'Egenskaper',
	'smw_properties_docu' => 'Följande egenskaper används i wikin',
	'smw_property_template' => '$1 av typen $2 ($3)',
	'smw_propertylackspage' => 'Alla egenskaper ska beskrivas av en sida!',
	'smw_propertylackstype' => 'Ingen typ specificerades för denna egenskap (antar typ $1 tills vidare).',
	'smw_propertyhardlyused' => 'Denna egenskap används knappt i wikin!',
	'unusedproperties' => 'Oanvända egenskaper',
	'smw_unusedproperties_docu' => 'Följande egenskaper finns fastän ingen annan sida använder dem.',
	'smw_unusedproperty_template' => '$1 av typen $2',
	'wantedproperties' => 'Önskade egenskaper',
	'smw_wantedproperties_docu' => 'Följande egenskaper används i wikin men har ännu inte en sida som beskriver dem.',
	'smw_wantedproperty_template' => '$1 (använd $2 gånger)',
	'tooltip-purge' => 'Klicka här för att ladda om alla frågor och mallar på den här sidan',
	'smw_purge' => 'Uppdatera',
	'ontologyimport' => 'Importera ontologi',
	'smw_oi_docu' => 'Denna specialsida tillåter import av ontologier.
Ontologierna måste följa ett visst format, specificerat på <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">hjälpsidan för ontologiimport</a>.',
	'smw_oi_action' => 'Importera',
	'smw_oi_return' => 'Tillbaka till <a href="$1">Special:OntologyImport</a>.',
	'smw_oi_noontology' => 'Ingen ontologi att tillgå, eller kunde inte ladda ontologi.',
	'smw_oi_select' => 'Välj vilka deklarationer som ska importeras, och klicka sen på importknappen.',
	'smw_oi_textforall' => 'Överskrift som läggs till alla importer (kan vara tom):',
	'smw_oi_selectall' => 'Välj eller välj bort alla deklarationer',
	'smw_oi_statementsabout' => 'Deklarationer om',
	'smw_oi_mapto' => 'Kartentitet till',
	'smw_oi_comment' => 'Lägg till följande text:',
	'smw_oi_thisissubcategoryof' => 'En underkategori till',
	'smw_oi_thishascategory' => 'Är del av',
	'smw_oi_importedfromontology' => 'Importera från ontologi',
	'types' => 'Typer',
	'smw_types_docu' => 'Följande är en lista över alla datatyper som egenskaper kan ha.
Varje datatyp har en sida där ytterligare information kan uppges.',
	'smw_typeunits' => 'Mätenhet för typ “$1”: $2',
	'semanticstatistics' => 'Semantisk statistik',
	'smw_semstats_text' => 'Denna wikin innehåller <b>$1</b> egenskapsvärden för totalt <b>$2</b> olika <a href="$3">egenskaper</a>.
<b>$4</b> egenskaper har en egen sida, och den avsedda datatypen är specificerad för <b>$5</b> av dessa.
Några av de existerande egenskaperna kan vara <a href="$6">oanvända egenskaper</a>.
Egenskaper som fortfarande saknar en egen sida finns på <a href="$7">listan över önskede egenskaper</a>.',
	'flawedattributes' => 'Ogiltiga Egenskaper',
	'smw_fattributes' => 'Sidorna som listas nedan har en felaktigt definerad egenskap.
Antalet felaktiga egenskaper visas inom parenteserna.',
	'uriresolver' => 'URI-lösare',
	'smw_uri_doc' => "<b>URI-lösaren implementerar ''<a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG fynden i httpRange-14</a>''. Den ser till så att människor inte blir webbsidor.</p>",
	'ask' => 'Semantisk sökning',
	'smw_ask_sortby' => 'Sortera efter kolumn (valfritt)',
	'smw_ask_ascorder' => 'Stigande',
	'smw_ask_descorder' => 'Sjunkande',
	'smw_ask_submit' => 'Hitta resultat',
	'smw_ask_editquery' => '[Redigera fråga]',
	'smw_add_sortcondition' => '[Lägg till sorteringsvillkor]',
	'smw_ask_hidequery' => 'Dölj fråga',
	'smw_ask_help' => 'Frågehjälp',
	'smw_ask_queryhead' => 'Fråga',
	'smw_ask_printhead' => 'Ytterligare utskrifter (valbart)',
	'searchbyproperty' => 'Sök efter egenskap',
	'smw_sbv_docu' => '<p>Sök efter alla sidor som har en given egenskap och värde.</p>',
	'smw_sbv_noproperty' => '<p>Skriv in en egenskap.</p>',
	'smw_sbv_novalue' => '<p>Skriv in ett giltigt värde för egenskapen, eller visa alla egenskapsvärden för “$1.”</p>',
	'smw_sbv_displayresult' => 'En lista över alla sidor som har egenskapen “$1” med värdet “$2”',
	'smw_sbv_property' => 'Egenskap',
	'smw_sbv_value' => 'Värde',
	'smw_sbv_submit' => 'Hitta resultat',
	'browse' => 'Bläddra igenom wikin',
	'smw_browse_article' => 'Skriv namnet på sidan du vill börja bläddra från.',
	'smw_browse_go' => 'Gå',
	'smw_browse_no_incoming' => 'Inga egenskaper länkar till den här sidan.',
	'smw_inverse_label_default' => '$1 av',
	'pageproperty' => 'Sidegenskapssökning',
	'smw_pp_docu' => 'Sök efter allt innehåll för en egenskap på en given sida.
Skriv in både en sida och en egenskap.',
	'smw_pp_from' => 'Från sida',
	'smw_pp_type' => 'Egenskap',
	'smw_pp_submit' => 'Hitta resultat',
	'smw_result_prev' => 'Föregående',
	'smw_result_next' => 'Nästa',
	'smw_result_results' => 'Resultat',
	'smw_result_noresults' => 'Beklagar, inga resultat.',
	'smwadmin' => 'Administratörsfunktioner för Semantic MediaWiki',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'smw_finallistconjunct' => ', మరియు',
	'smw_iq_moreresults' => '… మరిన్ని ఫలితాలు',
	'smw_true_words' => 'true,t,yes,y,అవును,సత్యం',
	'smw_false_words' => 'false,f,no,n,కాదు,అసత్యం',
	'smw_nofloat' => '“$1” అనేది సంఖ్య కాదు.',
	'smw_abb_north' => 'ఉ',
	'smw_abb_east' => 'తూ',
	'smw_abb_south' => 'ద',
	'smw_abb_west' => 'ప',
	'smw_label_latitude' => 'అక్షాంశం:',
	'smw_label_longitude' => 'రేఖాంశం:',
	'properties' => 'లక్షణాలు',
	'smw_wantedproperty_template' => '$1 ($2 వాడుకలు)',
	'types' => 'రకాలు',
	'smw_ask_ascorder' => 'ఆరోహణ',
	'smw_ask_descorder' => 'అవరోహణ',
	'smw_sbv_value' => 'విలువ',
	'smw_browse_go' => 'వెళ్ళు',
	'smw_result_prev' => 'గత',
	'smw_result_next' => 'తదుపరి',
	'smw_result_results' => 'ఫలితాలు',
	'smw_result_noresults' => 'క్షమించండి, ఫలితాలేమీ లేవు.',
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'smw_sbv_value' => 'Қимат',
);

/** Thai (ไทย)
 * @author Octahedron80
 */
$messages['th'] = array(
	'smw_oi_action' => 'นำเข้า',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'smw_edithelp' => 'Trợ giúp sửa đổi tại thuộc tính',
	'smw_viewasrdf' => 'Tin RDF',
	'smw_finallistconjunct' => ', và',
	'smw_factbox_head' => 'Sự thật về $1',
	'smw_isspecprop' => 'Thuộc tính này là thuộc tính đặc biệt trong wiki này.',
	'smw_isknowntype' => 'Kiểu này là một trong những kiểu dữ liệu chuẩn của wiki này.',
	'smw_isaliastype' => 'Kiểu này là tên hiệu của kiểu dữ liệu “$1”.',
	'smw_isnotype' => 'Kiểu “$1” này không phải là kiểu dữ liệu chuẩn trên wiki, và cũng chưa được cung cấp định nghĩa người dùng.',
	'smw_baduri' => 'Rất tiếc, không cho phép URI có dạng “$1”.',
	'smw_icalendar_link' => 'iCalendar',
	'smw_iq_disabled' => 'Rất tiếc. Chức năng truy vấn ngữ nghĩa đã bị tắt tại wiki này.',
	'smw_iq_moreresults' => '… kết quả khác',
	'smw_iq_nojs' => 'Xin hãy dùng trình duyệt có kích hoạt JavaScript để xem thành phần này.',
	'smw_iq_altresults' => 'Xem qua trực tiếp danh sách kết quả.',
	'smw_unknown_importns' => 'Nhập các hàm chưa có tại không gian tên “$1”.',
	'smw_nonright_importtype' => '$1 chỉ dùng được tại những trang thuộc không gian tên “$2”.',
	'smw_wrong_importtype' => '$1 không thể dùng được tại những trang thuộc không gian tên “$2”.',
	'smw_no_importelement' => 'Thành phần “$1” không có để nhập.',
	'smw_parseerror' => 'Không hiểu giá trị cung cấp.',
	'smw_notitle' => 'Không thể dùng “$1” làm tên trang trên wiki này.',
	'smw_unknowntype' => 'Không hỗ trợ kiểu “$1” trong thuộc tính.',
	'smw_manytypes' => 'Thuộc tính này có nhiều hơn một kiểu',
	'smw_emptystring' => 'Không chấp nhận chuỗi trống.',
	'smw_maxstring' => 'Đại diện chuỗi $1 quá dài đối với {{SITENAME}}.',
	'smw_notinenum' => '“$1” không nằm trong danh sách các giá trị khả dĩ ($2) cho thuộc tính này.',
	'smw_noboolean' => '“$1” không phải là giá trị Boole (đúng/sai).',
	'smw_true_words' => 'true,t,yes,y,đúng,đ,có,c',
	'smw_false_words' => 'false,f,no,n,sai,s,không,k',
	'smw_nofloat' => '“$1” không phải là số.',
	'smw_infinite' => '{{SITENAME}} không hỗ trợ các số lớn như “$1”.',
	'smw_infinite_unit' => 'Chuyển đổi thành đơn vị “$1” đẫn tới một con số quá lớn đối với {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Không hỗ trợ tiền tố cho các số (“$1”).',
	'smw_unsupportedunit' => 'Không hỗ trợ chuyển đổi đơn vị cho đơn vị “$1”.',
	'smw_lonely_unit' => 'Không tìm thấy số trước ký hiệu “$1”.',
	'smw_bad_latlong' => 'Vĩ độ và kinh độ phải được cung cấp chỉ một lần, và với giá trị tọa độ hợp lệ.',
	'smw_abb_north' => 'B',
	'smw_abb_east' => 'Đ',
	'smw_abb_south' => 'N',
	'smw_abb_west' => 'T',
	'smw_label_latitude' => 'Vĩ độ:',
	'smw_label_longitude' => 'Kinh độ:',
	'smw_nodatetime' => 'Không hiểu ngày “$1”.',
	'smw_toomanyclosing' => 'Dường có quá nhiều lần xuất hiện “$1” trong câu truy vấn.',
	'smw_noclosingbrackets' => 'Lần sử dụng “<nowiki>[[</nowiki>” nào đó trong câu truy vấn của bạn không được đóng bằng “]]”.',
	'smw_misplacedsymbol' => 'Ký hiệu “$1” được dùng tại nơi nó không hữu ích.',
	'smw_unexpectedpart' => 'Phần “$1” của câu truy vấn không hiểu được.
Kết quả có thể không như mong đợi.',
	'smw_emptysubquery' => 'Một truy vấn con nào đó không có điều kiện hợp lệ.',
	'smw_misplacedsubquery' => 'Một truy vấn con nào đó được dùng tại nơi không cho phép dùng truy vấn con.',
	'smw_valuesubquery' => 'Truy vấn con không hỗ trợ các giá trị của tham số “$1”.',
	'smw_overprintoutlimit' => 'Câu truy vấn chứa quá nhiều yêu cầu trang in.',
	'smw_badprintout' => 'Lệnh yêu cầu in nào đó trong câu truy vấn có dạng sai.',
	'smw_badtitle' => 'Tên trang “$1” không hợp lệ.',
	'smw_badqueryatom' => 'Phần “<nowiki>[[…]]</nowiki>” nào đó của câu truy vấn không hiểu được.',
	'smw_propvalueproblem' => 'Không hiểu giá trị của thuộc tính “$1”.',
	'smw_nodisjunctions' => 'Phân tách trong câu truy vấn không hỗ trợ trong wiki này và một phần câu truy vấn bị bỏ qua ($1).',
	'smw_querytoolarge' => 'Các điều kiện truy vấn sau đây không được xem xét do hạn chế của wiki trong độ dài hoặc độ sâu truy vấn: $1.',
	'smw_devel_warning' => 'Tính năng này hiện đang được phát triển, và có thể không hoạt động đầy đủ.
Hãy sao lưu dữ liệu của bạn trước khi dùng nó.',
	'smw_notemplategiven' => 'Xin hãy cung cấp giá trị cho tham số “template” để đinh dạng truy vấn này có thể hoạt động.',
	'smw_type_header' => 'Tính chất của loại “$1”',
	'smw_typearticlecount' => 'Hiển thị $1 thuộc tính sử dụng kiểu này.',
	'smw_attribute_header' => 'Những trang dùng thuộc tính “$1”',
	'smw_attributearticlecount' => 'Hiển thị $1 trang dùng thuộc tính này.',
	'exportrdf' => 'Xuất trang ra RDF',
	'smw_exportrdf_docu' => '<p>Trang này cho phép bạn lấy dữ liệu từ trang theo dạng RDF.
Để xuất trang, gõ vào tựa đề trong khung dưới đây, một dòng một tựa đề.</p>',
	'smw_exportrdf_recursive' => 'Xuất đệ quy tất cả các trang liên quan.
Chú ý rằng kết quả không thể quá lớn!',
	'smw_exportrdf_backlinks' => 'Cũng xuất tất cả các trang chỉ đến trang được xuất.
Tạo ra RDF có thể duyệt được.',
	'smw_exportrdf_lastdate' => 'Đừng xuất trang không thay đổi từ một thời điểm cho trước.',
	'properties' => 'Thuộc tính',
	'smw_properties_docu' => 'Các thuộc tính được dùng trong wiki.',
	'smw_property_template' => '$1 thuộc loại $2 ($3)',
	'smw_propertylackspage' => 'Tất cả các thuộc tính nên được mô tả bằng một trang!',
	'smw_propertylackstype' => 'Không có loại này được chỉ định cho thuộc tính này (từ giờ giả thiết loại $1).',
	'smw_propertyhardlyused' => 'Thuộc tính này khó sử dụng trong wiki!',
	'unusedproperties' => 'Thuộc tính không sử dụng',
	'smw_unusedproperties_docu' => 'Các thuộc tính sau tồn tại mặc dù không có trang nào dùng chúng.',
	'smw_unusedproperty_template' => '$1 thuộc loại $2',
	'wantedproperties' => 'Thuộc tính cần nhất',
	'smw_wantedproperties_docu' => 'Các thuộc tính sau được dùng trong wiki nhưng chưa có trang nào mô tả chúng.',
	'smw_wantedproperty_template' => '$1 ($2 lần sử dụng)',
	'tooltip-purge' => 'Nhấn vào đây để làm tươi tất cả các truy vấn và tiêu bản trên trang này',
	'smw_purge' => 'Làm tươi',
	'ontologyimport' => 'Nhập bản thể học',
	'smw_oi_docu' => 'Trang đặc biệt này cho phép nhập bản thể.
Các bản thể phải theo một định dạng nhất định, được chỉ định tại <a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">trang trợ giúp nhập bản thể</a>.',
	'smw_oi_action' => 'Nhập',
	'smw_oi_return' => 'Trở về <a href="$1">{{ns:Special}}:OntologyImport</a>.',
	'smw_oi_noontology' => 'Không có bản thể nào được cung cấp, hoặc không thể tải bản thể.',
	'smw_oi_select' => 'Xin hãy chọn những bản cần nhập, rồi nhấn nút nhập.',
	'smw_oi_textforall' => 'Văn bản tiêu đề để thêm vào tất cả các lần nhập (có thể trống):',
	'smw_oi_selectall' => 'Chọn hoặc bỏ chọn tất cả các bản',
	'smw_oi_statementsabout' => 'Bản ghi về',
	'smw_oi_mapto' => 'Thực thể bản đồ của',
	'smw_oi_comment' => 'Thêm đoạn văn bản sau:',
	'smw_oi_thisissubcategoryof' => 'Thể loại con của',
	'smw_oi_thishascategory' => 'Là một phần của',
	'smw_oi_importedfromontology' => 'Nhập từ bản thể',
	'types' => 'Các dạng',
	'smw_types_docu' => 'Sau đây là danh sách tất cả các kiểu dữ liệu có thể gán vào thuộc tính.
Mỗi kiểu dữ liệu có một trang tại đó có thông tin bổ sung.',
	'smw_typeunits' => 'Đơn vị đo lường thuộc loại “$1”: $2',
	'semanticstatistics' => 'Thống kê ngữ nghĩa',
	'smw_semstats_text' => 'Wiki này có chứa <b>$1</b> giá trị thuộc tính cho tổng cộng <b>$2</b> <a href="$3">thuộc tính</a> khác nhau.
<b>$4</b> thuộc tính có trang riêng, và kiểu dữ liệu dự tính được chỉ định cho <b>$5</b> trong số đó.
Một số thuộc tính hiện có có thể là <a href="$6">thuộc tính chưa sử dụng</a>.
Các thuộc tính còn thiếu một trang có thể tìm thấy tại <a href="$7">danh sách các thuộc tính cần có</a>.',
	'flawedattributes' => 'Thuộc tính hỏng',
	'smw_fattributes' => 'Những trang liệt kê phía dưới có thuộc tính được định nghĩa không chính xác.
Số thuộc tính không đúng được ghi trong ngoặc đơn.',
	'uriresolver' => 'Bộ giải URI',
	'smw_uri_doc' => '<p>Bộ giải URI hiện thực <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">THẺ W3C tìm thấy tại httpRange-14</a>. Nó lo việc con người không quay lại trang web.</p>',
	'ask' => 'Tìm kiếm ngữ nghĩa',
	'smw_ask_sortby' => 'Sắp xếp theo cột (tùy chọn)',
	'smw_ask_ascorder' => 'Tăng dần',
	'smw_ask_descorder' => 'Giảm dần',
	'smw_ask_submit' => 'Kết quả tìm kiếm',
	'smw_ask_editquery' => '[Sửa truy vấn]',
	'smw_add_sortcondition' => '[Thêm điều kiện sắp xếp]',
	'smw_ask_hidequery' => 'Ẩn truy vấn',
	'smw_ask_help' => 'Trợ giúp truy vấn',
	'smw_ask_queryhead' => 'Truy vấn',
	'smw_ask_printhead' => 'Trang in bổ sung (tùy chọn)',
	'searchbyproperty' => 'Tìm theo thuộc tính',
	'smw_sbv_docu' => '<p>Tìm tất cả các trang có thuộc tính và giá trị cho trước.</p>',
	'smw_sbv_noproperty' => '<p>Xin nhập một thuộc tính.</p>',
	'smw_sbv_novalue' => '<p>Xin nhập vào một giá trị hợp lệ cho thuộc tính, hoặc xem tất cả các giá trị thuộc tính của “$1.”</p>',
	'smw_sbv_displayresult' => 'Danh sách tất cả các trang có thuộc tính “$1” có giá trị “$2”',
	'smw_sbv_property' => 'Thuộc tính',
	'smw_sbv_value' => 'Giá trị',
	'smw_sbv_submit' => 'Kết quả tìm kiếm',
	'browse' => 'Duyệt wiki',
	'smw_browse_article' => 'Gõ vào tên trang để bắt đầu duyệt.',
	'smw_browse_go' => 'Xem',
	'pageproperty' => 'Tìm kiếm thuộc tính trang',
	'smw_pp_docu' => 'Tìm tất cả các lấp chỗ trống của một thuộc tính tại một trang cho trước.
Xin nhập vào cả một trang và một thuộc tính.',
	'smw_pp_from' => 'Từ trang',
	'smw_pp_type' => 'Thuộc tính',
	'smw_pp_submit' => 'Kết quả tìm kiếm',
	'smw_result_prev' => 'Trước',
	'smw_result_next' => 'Sau',
	'smw_result_results' => 'Kết quả',
	'smw_result_noresults' => 'Không có kết quả nào.',
);

/** Volapük (Volapük)
 * @author Malafaya
 */
$messages['vo'] = array(
	'smw_abb_north' => 'N',
	'smw_abb_east' => 'L',
	'smw_abb_south' => 'S',
	'smw_abb_west' => 'V',
	'smw_sbv_value' => 'Völad',
);

/** Chinese (China) (‪中文(中国大陆)‬)
 * @author Roc Michael
 */
$messages['zh-cn'] = array(
	'smw_edithelp' => '与关联(relations)及属性(attributes)有关的编辑协助',
	'smw_finallistconjunct' => '， 和',
	'smw_factbox_head' => '关于$1 的小文件',
	'smw_isspecprop' => '在此wiki系统内，此一性质为一种特殊性质',
	'smw_isknowntype' => '此一型态系为这个wiki系统内的标准的资料型态之一',
	'smw_isaliastype' => '此一型态系为资料型态“$1＂的别称',
	'smw_isnotype' => '在此wiki系统内，此一“$1＂型态并非是一项标准的资料型态，并且尚未被用户赋予其定义',
	'smw_baduri' => '抱歉，在此处无法取得从“$1＂范围的，URIs. (译注原文为：Sorry, URIs of the form “$1＂ are not allowed.)',
	'smw_iq_disabled' => '抱歉，联机查询在此wiki已被设置为无效',
	'smw_iq_moreresults' => '&hellip; 高级查询',
	'smw_iq_nojs' => '请使用内建JavaScript的浏览器以浏览此元素.',
	'smw_unknown_importns' => '导入功能对“$1＂的名字空间无效＂.',
	'smw_nonright_importtype' => '$1仅能用于名字空间为“$2＂的页面。',
	'smw_wrong_importtype' => '$1无法用于名字空间为“$2＂的页面。',
	'smw_no_importelement' => '无法导入“$1＂元素',
	'smw_notitle' => '在此wiki内，是无法用“$1＂来当作页面名称的',
	'smw_unknowntype' => '不支持为性质所定义的“$1＂形态。',
	'smw_manytypes' => '定义此性质的型态已超过了一种以上。',
	'smw_emptystring' => '不接受空白字串。',
	'smw_maxstring' => '对本站而言，$1所代表的字串太长了。',
	'smw_notinenum' => '“$1＂ 并非在此属性有可能的值 ($2)的列表之中',
	'smw_noboolean' => '“$1＂无法被视为布林值(true/false)。',
	'smw_true_words' => '是,t,yes,y,true',
	'smw_false_words' => '否,f,no,n,false',
	'smw_nofloat' => '“$1＂ 并非为是数字',
	'smw_infinite' => '在此站内并不支持像是“$1＂如此庞大的数目字。',
	'smw_infinite_unit' => '对此站而言转换“$1＂单位所产生的数目字过于庞大。',
	'smw_unsupportedprefix' => '数字(“$1＂) 的字首目前尚未被支持',
	'smw_unsupportedunit' => '单位转换无法适用于“$1＂此一单位',
	'smw_lonely_unit' => '在“$1＂此一单位之前并无数目字',
	'smw_bad_latlong' => '纬度和经度只能以有效的座标值标示一次',
	'smw_label_latitude' => '纬度：',
	'smw_label_longitude' => '经度：',
	'smw_nodatetime' => '日期值“$1＂无法被识别，对日期值的支持目前尚属实验性质。',
	'smw_toomanyclosing' => '在此查询中“$1＂显然出现太多次了',
	'smw_noclosingbrackets' => '在您的查询中“[&#x005B;＂ 并未以对应的“]]＂来予以封闭',
	'smw_misplacedsymbol' => '“$1＂此一符号用于某项无用之处',
	'smw_unexpectedpart' => '查询的“$1＂部份无法被识别，可能会出现预料之外的结果',
	'smw_emptysubquery' => '某些子查询并不具备有效的查询条件',
	'smw_misplacedsubquery' => '某些子查询被用在不宜于使用子查询之处',
	'smw_valuesubquery' => '“$1＂质性的值并不适用于子查询',
	'smw_overprintoutlimit' => '此查询含有太多的输出要求',
	'smw_badprintout' => '在此查询中，有些输出叙述已被弄错了',
	'smw_badtitle' => '抱歉！“$1＂ 并非是有效的页面名称',
	'smw_badqueryatom' => '在此查询中，部份的“[#x005B;&hellip]]＂无法被识别。',
	'smw_propvalueproblem' => '质性“$1＂的值无法被识别',
	'smw_nodisjunctions' => '在此wiki系统内分开查询是不被支持的，并有部份查询已被遗漏 ($1)。(译注原文为：Disjunctions in queries are not supported in this wiki and part of the query was dropped ($1).)',
	'smw_querytoolarge' => '基于此wiki系统对查询的规模及在深度方面的限制，以下的查询条件无法被接受：$1',
	'smw_devel_warning' => '此元件尚于开发中，也许无法完成发挥功效，在使用它之前，请先备份您的资料',
	'smw_type_header' => '“$1＂型态的性质',
	'smw_typearticlecount' => '以此型态显示 $1 性质',
	'smw_attribute_header' => '使用性质“$1＂的页面',
	'smw_attributearticlecount' => '以此性质显示$1页面.',
	'exportrdf' => '输出页面至RDF 。',
	'smw_exportrdf_docu' => '<p>此一页面可让您获取RDF格式页面的资料，要输出页面，请在下方的文字框内键入页面的抬头，一项一行。</p>',
	'smw_exportrdf_recursive' => '逐项输出所有的相关的页面，请注意输出的结果可能颇为庞大。',
	'smw_exportrdf_backlinks' => '并且输出与输出页面有关的页面，产生可供人阅读的RDF。(browsable RDF)',
	'smw_exportrdf_lastdate' => '无须输出那些在所设之时间点以后就未再被更动过的页面',
	'properties' => '性质',
	'smw_properties_docu' => '以下的性质已被用于此wiki内',
	'smw_property_template' => ' $1 　型态为：$2　使用次数：($3)',
	'smw_propertylackspage' => '所有的性质应以某一页面加以描述。',
	'smw_propertylackstype' => '此一性质尚未被指定形态，先暂定为$1型态。',
	'smw_propertyhardlyused' => '此一性质难以用于此wiki内',
	'unusedproperties' => '未使用的性质',
	'smw_unusedproperties_docu' => '下方的性质虽已存在，但无其他的页面使用它们。',
	'smw_unusedproperty_template' => '$2型态的$1',
	'wantedproperties' => '待建立的性质',
	'smw_wantedproperties_docu' => '下方的性质虽已用于此wiki内，但却未事先以任何页面去定义它们。',
	'smw_wantedproperty_template' => '$1 (已用于$2处)',
	'tooltip-purge' => '按此处以更新此页全部的查询项目及样板。',
	'smw_purge' => '更新',
	'ontologyimport' => '输入知识本体(ontology)',
	'smw_oi_docu' => '此特殊页可用以输入知识本体(ontology)，此知识本体(ontology)必须依循特定的格式，此特定格式在<a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">知识本体(ontology)的导入求助页面。</a>',
	'smw_oi_action' => '输入',
	'smw_oi_return' => '回车<a href="$1">Special:OntologyImport</a>',
	'smw_oi_noontology' => '无知识本体(ontology)可提供或者无法载入知识本体',
	'smw_oi_select' => '请选择某叙述以输入然后按输入键',
	'smw_oi_textforall' => '用以添加于所有输入的标题文字(也许是空白)：',
	'smw_oi_selectall' => '选取或放弃选取全部的叙述',
	'smw_oi_statementsabout' => '相关描述',
	'smw_oi_mapto' => '对映本质(entity)至',
	'smw_oi_comment' => '添加以下的文字：',
	'smw_oi_thisissubcategoryof' => '所属的次分类',
	'smw_oi_thishascategory' => '此部分附属于(Is part of)',
	'smw_oi_importedfromontology' => '从知识本体(ontology)输入',
	'types' => '型态',
	'smw_types_docu' => '以下为所有资料型态的列表，资料型态可用于指定性质，每项资料型态皆有提供附加信息的页面。',
	'smw_typeunits' => '“$1＂型态的量测单位：$2',
	'semanticstatistics' => '语意统计(Semantic Statistics)',
	'smw_semstats_text' => '此wiki含有<b>$1</b>性质的值以用于总计<b>$2</b> 不同于 <a href="$3">性质</a>。 <b>$4</b>性质有着专属的专面，且预期所需的资料型态因着<b>$5</b>，而已被指定了，有些现有的性质也许为<a href="$6">未使用的性质</a>。您可在 <a href="$7">待建立的性质列表</a>中，找到那些尚未建立专属页面的性质。(译注原文为：This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.)',
	'flawedattributes' => '错误的性质',
	'smw_fattributes' => '在下方处被列出的页面有着一项非正确定义的属性，非正确的属性的数量置于中括号内',
	'ask' => '语意搜寻',
	'smw_ask_sortby' => '依栏位排序',
	'smw_ask_ascorder' => '升幂',
	'smw_ask_descorder' => '降幂',
	'smw_ask_submit' => '搜自导引结果',
	'smw_ask_editquery' => '[编辑查询]',
	'smw_ask_hidequery' => '隐藏查询',
	'smw_ask_help' => '查询协助',
	'smw_ask_queryhead' => '查询',
	'smw_ask_printhead' => '其他查询(选择性的)',
	'searchbyproperty' => '依性质搜寻',
	'smw_sbv_docu' => '<p>依所指定的性质及其值来搜寻页面</p>',
	'smw_sbv_noproperty' => '请输入某项性质',
	'smw_sbv_novalue' => '<p>请为该性质输入一项有效值，或请查阅“$1.＂的全部的性质的值</p>',
	'smw_sbv_displayresult' => '所有“$1＂性质项目中，皆带有“$2＂值的页面列表',
	'smw_sbv_property' => '性质',
	'smw_sbv_value' => '值',
	'smw_sbv_submit' => '搜自导引结果',
	'browse' => '浏览wiki',
	'smw_browse_article' => '在开始浏览的表单中输入页面名称',
	'smw_browse_go' => '前往',
	'pageproperty' => '页面性质搜寻',
	'smw_pp_docu' => '搜寻某一页面全部性质的过滤条件，请同时输入页面及性质',
	'smw_pp_from' => '开始页面(From page)',
	'smw_pp_type' => '性质',
	'smw_pp_submit' => '搜自导引结果',
	'smw_result_prev' => '前一页',
	'smw_result_next' => '下一页',
	'smw_result_results' => '结果',
	'smw_result_noresults' => '抱歉，无您所要的结果。',
);

/** Chinese (Taiwan) (‪中文(台灣)‬)
 * @author Roc michael
 */
$messages['zh-tw'] = array(
	'smw_edithelp' => '與關聯(relations)及屬性(attributes)有關的編輯協助',
	'smw_finallistconjunct' => '， 和',
	'smw_factbox_head' => '關於$1 的小檔案',
	'smw_isspecprop' => '在此wiki系統內，此一性質為一種特殊性質',
	'smw_isknowntype' => '此一型態係為這個wiki系統內的標準的資料型態之一',
	'smw_isaliastype' => '此一型態係為資料型態“$1”的別稱',
	'smw_isnotype' => '在此wiki系統內，此一“$1”型態並非是一項標準的資料型態，並且尚未被用戶賦予其定義',
	'smw_concept_description' => '"$1"概念的描述',
	'smw_no_concept_namespace' => '概念僅能在屬於概念此一名字空間的頁面內予以定義',
	'smw_multiple_concepts' => '每個概念頁面僅能有一項概念定義',
	'smw_baduri' => '抱歉，在此處不允許“$1”的URI. (譯註原文為：Sorry, URIs of the form “$1” are not allowed.)',
	'smw_iq_disabled' => '抱歉，線上查詢在此wiki已被設定為無效',
	'smw_iq_moreresults' => '&hellip; 進階查詢',
	'smw_iq_nojs' => '請使用內建JavaScript的瀏覽器以瀏覽此元素.',
	'smw_iq_altresults' => '直接瀏覽結果清單',
	'smw_unknown_importns' => '匯入功能對“$1”的名字空間無效”.',
	'smw_nonright_importtype' => '$1僅能用於名字空間為“$2”的頁面。',
	'smw_wrong_importtype' => '$1無法用於名字空間為“$2”的頁面。',
	'smw_no_importelement' => '無法匯入“$1”元素',
	'smw_parseerror' => '所賦予的值無法被理解',
	'smw_notitle' => '在此wiki內，是無法用“$1”來當作頁面名稱的',
	'smw_unknowntype' => '不支援為性質所定義的“$1”形態。',
	'smw_manytypes' => '定義此性質的型態已超過了一種以上。',
	'smw_emptystring' => '不接受空白字串。',
	'smw_maxstring' => '對本站而言，$1所代表的字串太長了。',
	'smw_notinenum' => '“$1” 並非在此屬性有可能的值 ($2)的清單之中',
	'smw_noboolean' => '“$1”無法被視為布林值(true/false)。',
	'smw_true_words' => '是,t,yes,y,true',
	'smw_false_words' => '否,f,no,n,false',
	'smw_nofloat' => '“$1” 並非為是數字',
	'smw_infinite' => '在此站內並不支援像是“$1”如此龐大的數目字。',
	'smw_infinite_unit' => '對此站而言轉換“$1”單位所產生的數目字過於龐大。',
	'smw_unsupportedprefix' => '數字(“$1”) 的字首目前尚未被支援',
	'smw_unsupportedunit' => '單位轉換無法適用於“$1”此一單位',
	'smw_lonely_unit' => '在“$1”此一單位之前並無數目字',
	'smw_bad_latlong' => '緯度和經度只能以有效的座標值標示一次',
	'smw_label_latitude' => '緯度：',
	'smw_label_longitude' => '經度：',
	'smw_nodatetime' => '日期值“$1”無法被識別，對日期值的支援目前尚屬實驗性質。',
	'smw_toomanyclosing' => '在此查詢中“$1”顯然出現太多次了',
	'smw_noclosingbrackets' => '在您的查詢中“[&#x005B;” 並未以對應的“]]”來予以封閉',
	'smw_misplacedsymbol' => '“$1”此一符號用於某項無用之處',
	'smw_unexpectedpart' => '查詢的“$1”部份無法被識別，可能會出現預料之外的結果',
	'smw_emptysubquery' => '某些子查詢並不具備有效的查詢條件',
	'smw_misplacedsubquery' => '某些子查詢被用在不宜於使用子查詢之處',
	'smw_valuesubquery' => '“$1”質性的值並不適用於子查詢',
	'smw_overprintoutlimit' => '此查詢含有太多的輸出要求',
	'smw_badprintout' => '在此查詢中，有些輸出敘述已被弄錯了',
	'smw_badtitle' => '抱歉！“$1” 並非是有效的頁面名稱',
	'smw_badqueryatom' => '在此查詢中，部份的“[#x005B;&hellip]]”無法被識別。',
	'smw_propvalueproblem' => '質性“$1”的值無法被識別',
	'smw_noqueryfeature' => '某些查詢元件並不被此一wiki所支援且部份的查詢已被中止 ($1)。',
	'smw_nodisjunctions' => '在此wiki系統內分開查詢是不被支援的，並有部份查詢已被遺漏 ($1)。(譯註原文為：Disjunctions in queries are not supported in this wiki and part of the query was dropped ($1).)',
	'smw_querytoolarge' => '基於此wiki系統對查詢的規模及在深度方面的限制，以下的查詢條件無法被接受：$1',
	'smw_devel_warning' => '此元件尚於開發中，也許無法完成發揮功效，在使用它之前，請先備份您的資料',
	'smw_type_header' => '“$1”型態的性質',
	'smw_typearticlecount' => '以此型態顯示 $1 性質',
	'smw_attribute_header' => '使用性質“$1”的頁面',
	'smw_attributearticlecount' => '以此性質顯示$1頁面.',
	'smw_subproperty_header' => '子性質',
	'smw_subpropertyarticlecount' => '此性質具有如下的$1子性質',
	'exportrdf' => '輸出頁面至RDF 。',
	'smw_exportrdf_docu' => '<p>此一頁面可讓您獲取RDF格式頁面的資料，要輸出頁面，請在下方的文字框內鍵入頁面的抬頭，一項一行。</p>',
	'smw_exportrdf_recursive' => '逐項輸出所有的相關的頁面，請注意輸出的結果可能頗為龐大。',
	'smw_exportrdf_backlinks' => '並且輸出與輸出頁面有關的頁面，產生可供人閱讀的RDF。(browsable RDF)',
	'smw_exportrdf_lastdate' => '無須輸出那些在所設之時間點以後就未再被更動過的頁面',
	'properties' => '性質',
	'smw_properties_docu' => '以下的性質已被用於此wiki內',
	'smw_property_template' => ' $1 　型態為：$2　使用次數：($3)',
	'smw_propertylackspage' => '所有的性質應以某一頁面加以描述。',
	'smw_propertylackstype' => '此一性質尚未被指定形態，先暫定為$1型態。',
	'smw_propertyhardlyused' => '此一性質難以用於此wiki內',
	'unusedproperties' => '未使用的性質',
	'smw_unusedproperties_docu' => '下方的性質雖已存在，但無其他的頁面使用它們。',
	'smw_unusedproperty_template' => '$2型態的$1',
	'wantedproperties' => '待建立的性質',
	'smw_wantedproperties_docu' => '下方的性質雖已用於此wiki內，但卻未事先以任何頁面去定義它們。',
	'smw_wantedproperty_template' => '$1 (已用於$2處)',
	'tooltip-purge' => '按此處以更新此頁全部的查詢項目及樣板。',
	'smw_purge' => '更新',
	'ontologyimport' => '輸入知識本體(ontology)',
	'smw_oi_docu' => '此特殊頁可用以輸入知識本體(ontology)，此知識本體(ontology)必須依循特定的格式，此特定格式在<a href="http://semantic-mediawiki.org/wiki/Help:Ontology_import">知識本體(ontology)的匯入求助頁面。</a>',
	'smw_oi_action' => '輸入',
	'smw_oi_return' => '返回<a href="$1">Special:OntologyImport</a>',
	'smw_oi_noontology' => '無知識本體(ontology)可提供或者無法載入知識本體',
	'smw_oi_select' => '請選擇某敘述以輸入然後按輸入鍵',
	'smw_oi_textforall' => '用以添加於所有輸入的標題文字(也許是空白)：',
	'smw_oi_selectall' => '選取或放棄選取全部的敘述',
	'smw_oi_statementsabout' => '相關描述',
	'smw_oi_mapto' => '對映本質(entity)至',
	'smw_oi_comment' => '添加以下的文字：',
	'smw_oi_thisissubcategoryof' => '所屬的次分類',
	'smw_oi_thishascategory' => '此部分附屬於(Is part of)',
	'smw_oi_importedfromontology' => '從知識本體(ontology)輸入',
	'types' => '型態',
	'smw_types_docu' => '以下為所有資料型態的清單，資料型態可用於指定性質，每項資料型態皆有提供附加資訊的頁面。',
	'smw_typeunits' => '“$1”型態的量測單位：$2',
	'semanticstatistics' => '語意統計(Semantic Statistics)',
	'smw_semstats_text' => '此wiki含有<b>$1</b>性質的值以用於總計<b>$2</b> 不同於 <a href="$3">性質</a>。 <b>$4</b>性質有著專屬的專面，且預期所需的資料型態因著<b>$5</b>，而已被指定了，有些現有的性質也許為<a href="$6">未使用的性質</a>。您可在 <a href="$7">待建立的性質清單</a>中，找到那些尚未建立專屬頁面的性質。(譯註原文為：This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.)',
	'flawedattributes' => '錯誤的性質',
	'smw_fattributes' => '在下方處被列出的頁面有著一項非正確定義的屬性，非正確的屬性的數量置於中括號內',
	'ask' => '語意搜尋',
	'smw_ask_sortby' => '依欄位排序',
	'smw_ask_ascorder' => '升冪',
	'smw_ask_descorder' => '降冪',
	'smw_ask_submit' => '搜尋的結果',
	'smw_ask_editquery' => '[編輯查詢]',
	'smw_add_sortcondition' => '[新增排序條件]',
	'smw_ask_hidequery' => '隱藏查詢',
	'smw_ask_help' => '查詢協助',
	'smw_ask_queryhead' => '查詢',
	'smw_ask_printhead' => '其他查詢(選擇性的)',
	'searchbyproperty' => '依性質搜尋',
	'smw_sbv_docu' => '<p>依所指定的性質及其值來搜尋頁面</p>',
	'smw_sbv_noproperty' => '請輸入某項性質',
	'smw_sbv_novalue' => '<p>請為該性質輸入一項有效值，或請查閱“$1.”的全部的性質的值</p>',
	'smw_sbv_displayresult' => '所有“$1”性質項目中，皆帶有“$2”值的頁面清單',
	'smw_sbv_property' => '性質',
	'smw_sbv_value' => '值',
	'smw_sbv_submit' => '搜尋的結果',
	'browse' => '瀏覽wiki',
	'smw_browse_article' => '在開始瀏覽的表單中輸入頁面名稱',
	'smw_browse_go' => '前往',
	'pageproperty' => '頁面性質搜尋',
	'smw_pp_docu' => '搜尋某一頁面全部性質的過濾條件，請同時輸入頁面及性質',
	'smw_pp_from' => '開始頁面(From page)',
	'smw_pp_type' => '性質',
	'smw_pp_submit' => '搜尋的結果',
	'smw_result_prev' => '前一頁',
	'smw_result_next' => '下一頁',
	'smw_result_results' => '結果',
	'smw_result_noresults' => '抱歉，無您所要的結果。',
	'smwadmin' => '管理員使用的語意維基功能',
);

