<?php

/**
 * Internationalisation file for the SyntaxHighlight extension
 *
 * @addtogroup Extensions
 */

function efSyntaxHighlight_GeSHiMessages() {
	$messages = array(

/* English (Brion Vibber) */
'en' => array(
'syntaxhighlight-specify' => 'You need to specify a language like this:',
'syntaxhighlight-supported' => 'Supported languages for syntax highlighting:',
'syntaxhighlight-err-loading' => '(error loading supported language list)',
'syntaxhighlight-err-language' => 'Invalid language.',
'geshi.css' => '/* CSS placed here will be applied to GeSHi syntax highlighting */',
),

/* German (Raymond) */
'de' => array(
'syntaxhighlight-specify'      => 'Die gewünschte Sprache muss wie folgt definiert werden:',
'syntaxhighlight-supported'    => 'Unterstützte Sprachen für die Syntax-Hervorhebung:',
'syntaxhighlight-err-loading'  => '(Fehler beim Laden der Sprachenliste)',
'syntaxhighlight-err-language' => 'Ungültige Sprache.',
'geshi.css'                    => '/* CSS in dieser MediaWiki-Systemnachricht wird auf die GeSHi-Syntaxhervorhebung angewendet */',
),

/* Estonian [[et:Kasutaja:M2s17]] */
'et' => array(
'syntaxhighlight-specify' => 'Sa pead täpsustama keelt nõnda:',
'syntaxhighlight-supported' => 'Süntaksi esiletoomise on toetatud järgnevates keeltes:',
'syntaxhighlight-err-loading' => '(toetatud keelte loetelu laadimisel esines viga)',
'syntaxhighlight-err-language' => 'antud keel on mittekehtiv',
'geshi.css' => '/* CSS mis on asetatud siia, määrab GeSHi süntaksi esiletoomise stiili */',
),

/* French */
'fr' => array(
'syntaxhighlight-specify' => 'Vous devez spécifier un langage comme ceci :',
'syntaxhighlight-supported' => 'Langages supportés pour la coloration syntaxique :',
'syntaxhighlight-err-loading' => '(erreur en chargeant la liste des langages supportés)',
'syntaxhighlight-err-language' => 'Language invalide.',
),

/* Indonesian (Ivan Lanin) */
'id' => array(
'syntaxhighlight-specify' => 'Anda harus menentukan suatu bahasa seperti ini:',
'syntaxhighlight-supported' => 'Bahasa-bahasa yang didukung oleh pewarnaan sintaks:',
'syntaxhighlight-err-loading' => '(kesalahan pemuatan daftar bahasa yang didukung)',
'syntaxhighlight-err-language' => 'Bahasa tak sah.',
),

/* Italian (BrokenArrow) */
'it' => array(
'syntaxhighlight-specify' => 'È necessario specificare un linguaggio in questo modo:',
'syntaxhighlight-supported' => 'Linguaggi di cui è possibile evidenziare la sintassi in colore:',
'syntaxhighlight-err-loading' => '(errore nel caricamento dell\'elenco dei linguaggi supportati)',
),

/* Japanese */
'ja' => array(
'syntaxhighlight-specify' => '以下のように言語を指定する必要があります:',
'syntaxhighlight-supported' => 'シンタックスハイライト機能に対応している言語は以下の通りです:',
'syntaxhighlight-err-loading' => '（対応言語のロード時にエラーが発生しました）',
'syntaxhighlight-err-language' => '不正な言語名です。',
),

/* Kazakh Cyrillic (AlefZet) */
'kk-kz' => array(
'syntaxhighlight-specify' => 'Тілді былайша көрсетуіңіз қажет:',
'syntaxhighlight-supported' => 'Синтаксисі көмескі жарықталатын сүйемелденген тілдер:',
'syntaxhighlight-err-loading' => '(сүйемелденген тілдер тізімін жүктеу қатесі)',
'syntaxhighlight-err-language' => 'Жарамсыз тіл.',
'geshi.css' => '/* Мындағы CSS әмірлері GeSHi синтаксисті көмескі жарықтауға қолданылады */',
),
/* Kazakh Latin (AlefZet) */
'kk-tr' => array(
'syntaxhighlight-specify' => 'Tildi bılaýşa körsetwiñiz qajet:',
'syntaxhighlight-supported' => 'Sïntaksïsi kömeski jarıqtalatın süýemeldengen tilder:',
'syntaxhighlight-err-loading' => '(süýemeldengen tilder tizimin jüktew qatesi)',
'syntaxhighlight-err-language' => 'Jaramsız til.',
'geshi.css' => '/* Mındağı CSS ämirleri GeSHi sïntaksïsti kömeski jarıqtawğa qoldanıladı */',
),
/* Kazakh Arabic (AlefZet) */
'kk-cn' => array(
'syntaxhighlight-specify' => 'تٸلدٸ بىلايشا كٶرسەتۋٸڭٸز قاجەت:',
'syntaxhighlight-supported' => 'سينتاكسيسٸ كٶمەسكٸ جارىقتالاتىن سٷيەمەلدەنگەن تٸلدەر:',
'syntaxhighlight-err-loading' => '(سٷيەمەلدەنگەن تٸلدەر تٸزٸمٸن جٷكتەۋ قاتەسٸ)',
'syntaxhighlight-err-language' => 'جارامسىز تٸل.',
'geshi.css' => '/* مىنداعى CSS ٵمٸرلەرٸ GeSHi سينتاكسيستٸ كٶمەسكٸ جارىقتاۋعا قولدانىلادى */',
),

/* nld / Dutch (Siebrand Mazeland) */
'nl' => array(
'syntaxhighlight-specify' => 'Geef een taal op zoals:',
'syntaxhighlight-supported' => 'Ondersteunde talen voor syntaxismarkering:',
'syntaxhighlight-err-loading' => '(fout bij het laden van de lijst met ondersteunde talen)',
),

/* Portuguese (Lugusto) */
'pt' => array(
'syntaxhighlight-specify'      => 'Você precisa especificar uma linguagem, tal como:',
'syntaxhighlight-supported'    => 'Linguagens suportadas no realce de sintaxe:',
'syntaxhighlight-err-loading'  => '(erro ao carregar a lista de linguagens suportadas)',
'syntaxhighlight-err-language' => 'Linguagem inválida.',
'geshi.css'                    => '/* O código CSS aqui colocado será aplicado ao realce de sintaxe GeSHi */',
),

/* Russian */
'ru' => array(
'syntaxhighlight-specify' => 'Вы должны указать язык следующим образом:',
'syntaxhighlight-supported' => 'Поддерживаемые языки:',
'syntaxhighlight-err-loading' => '(невозможно загрузить список языков)',
'syntaxhighlight-err-language' => 'Указан неподдерживаемый язык.',
'geshi.css' => '/* CSS-код, размещённый здесь, будет применён для подсветки синтаксиса GeSHI */',
),

/* Swedish */
'sv' => array(
'syntaxhighlight-specify' => 'Du måste ange vilket språk som används, så här:',
'syntaxhighlight-supported' => 'Det finns stöd för följande språk:',
'syntaxhighlight-err-loading' => '(fel vid laddning av listan över stödda språk)',
'syntaxhighlight-err-language' => 'Ogiltigt språk.',
'geshi.css' => '/* CSS som skrivs här används för syntax highlighting med GeSHI */',
),

/* Cantonese (Shinjiman) */
'yue' => array(
'syntaxhighlight-specify' => '你需要指定一種語言，好似咁:',
'syntaxhighlight-supported' => '語法醒目標示所支援嘅語言:',
'syntaxhighlight-err-loading' => '(支援語言清單載入錯誤)',
'syntaxhighlight-err-language' => '無效嘅語言。',
'geshi.css' => '/* 放響呢度嘅CSS會以GeSHi語法醒目提示方式顯示 */',
),

/* Chinese (Simplified) (Shinjiman) */
'zh-hans' => array(
'syntaxhighlight-specify' => '您需要指定一种语言，像这样:',
'syntaxhighlight-supported' => '语法高亮所支持的语言:',
'syntaxhighlight-err-loading' => '(支持语言列表载入错误)',
'syntaxhighlight-err-language' => '无效的语言。',
'geshi.css' => '/* 放在这里的CSS会以GeSHi语法高亮方式显示 */',
),

/* Chinese (Traditional) (Shinjiman) */
'zh-hant' => array(
'syntaxhighlight-specify' => '您需要指定一種語言，像這樣:',
'syntaxhighlight-supported' => '語法醒目標示所支援的語言:',
'syntaxhighlight-err-loading' => '(支援語言清單載入錯誤)',
'syntaxhighlight-err-language' => '無效的語言。',
'geshi.css' => '/* 放在這裏的CSS會以GeSHi語法醒目提示方式顯示 */',
),

	);

	/* Kazakh default, fallback to kk-kz */
	$messages['kk'] = $messages['kk-kz'];
	/* Chinese defaults, fallback to zh-hans or zh-hant */
	$messages['zh-cn'] = $messages['zh-hans'];
	$messages['zh-hk'] = $messages['zh-hant'];
	$messages['zh-sg'] = $messages['zh-hans'];
	$messages['zh-tw'] = $messages['zh-hant'];
	/* Cantonese default, fallback to yue */
	$messages['zh-yue'] = $messages['yue'];

	return $messages; 

}