<?php
# Debian version of geshi syntax highlighting.
# You need the php-geshi package to make use of it...

# GeSHiHighlight.php
#
# By: E. Rogan Creswick (aka: Largos)
# creswick@gmail.com
# wiki.ciscavate.org
#
# License: GeSHi Highlight is released under the Gnu Public License (GPL), and comes with no warranties.
# The text of the GPL can be found here: http://www.gnu.org/licenses/gpl.html
# Loosely based on SyntaxHighlight.php by Coffman, (www.wickle.com)
#
#
#  Changelog:
#
#  3/15/2006 - Added generic directory separation code (contributed by Stanislav Zahariev)
#              Also, thanks to Leah@(Leah, put your info here if you want) for pointing out this problem also.
#
#  ?/??/2005 - Added code for automatic language detection. (contributed by JeffK)
#  
#  ?/??/2005 - initial version
 
define('DS', DIRECTORY_SEPARATOR);
define('GPATH', '/usr/share/php-geshi');
 
include('/usr/share/php-geshi/geshi.php');
 
class SyntaxSettings {};
$wgSyntaxSettings = new SyntaxSettings;
 
$wgExtensionFunctions[] = 'wfSyntaxExtension';
function wfSyntaxExtension()
{
        global $wgParser;
 
        $langArray = geshi_list_languages(GPATH . DS . 'geshi');
 
        foreach ($langArray as $lang) {
                $wgParser->setHook($lang,
				create_function(
                                '$text',
                                '$geshi = new GeSHi(rtrim(ltrim($text, "\n\r")), "' . $lang . '", "' . GPATH . DS . 'geshi"); return $geshi->parse_code();'
                        )
                );
        }


}
 
/**
 * function: geshi_list_languages
 * -------------------------
 * List supported languages by reading the files in the geshi/geshi subdirectory
 * (added by JeffK -- Jeff, any more contact info?)
 *
 */
function geshi_list_languages($path)
{
        $lang_list = array();
 
        if (false !== ($handle = opendir($path))) {
                /* Loop over the directory. */
                while (false !== ($file = readdir($handle))) {
                        /* Drop the current and parent dir entries */
                        if('.' !== $file && '..' !== $file) {
                                /* Drop files that dont end with .php */
                                if ('.php' == substr($file, strrpos($file, '.'), 4)) {
                                        $lang_list[] = substr($file, 0, -4);
                                }
                        }
                }
 
                closedir($handle);
        }
 
        return $lang_list;
}
?>
