/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_CLOUDRESOURCE_H_
#define MCLOUD_API_CLOUDRESOURCE_H_

#include <memory>
#include <string>
#include <ctime>

namespace mcloud {
namespace api {

/*!
    \class CloudResource
    \brief CloudResource is an abstract object that provides common interfaces for CloudContent and CloudFolder.
 */

class CloudResource {
  public:
    typedef std::shared_ptr<CloudResource>  Ptr;

    enum class Property {
        Content,  ///< content resource
        Folder    ///< folder resource
    };

    virtual ~CloudResource() = default;

    virtual const std::string &id() const = 0;

    virtual const std::string &name() const = 0;

    virtual const std::time_t &created_date() const = 0;

    virtual const std::time_t &updated_date() const = 0;

    virtual const std::string &parent_catalog_id() const = 0;

    virtual const std::string &etag() const = 0;

    virtual const std::string &owner() const = 0;

    virtual Property property() const = 0;
};

}
}

#endif // MCLOUD_API_CLOUDRESOURCE_H_
