package com.sap.dbtech.util.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.vsp001.Packet;

/*
 
 created by D031096
 
 ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
 
 
 */
public class Authentication {
    
    private byte[] salt;
    
    private byte[] clientchallenge;
    
    private byte[] serverchallenge;
    
    private int maxpasswordLen = 0;
    
    private static SecureRandom srnd = new SecureRandom();
    
    public Authentication() throws java.security.NoSuchAlgorithmException {
        clientchallenge = new byte[64];
        int retrycount = 10; //workaround for buggy vm on IBM J9SE VM (build 2.2, J2RE 1.4.2 IBM J9 2.2 Linux amd64-64)
        while (true) {
            try {
                srnd.nextBytes(
                        getClientchallenge());
                return;
            } catch (Exception e) {
                if (--retrycount <= 0) {
                  throw new java.security.NoSuchAlgorithmException(e.toString());
                }
            }
        }
    }
    
    /**
     * @return Returns the clientchallenge.
     */
    public byte[] getClientchallenge() {
        return clientchallenge;
    }
    
    /**
     * @return Returns the clientchallenge.
     */
    public byte[] getClientProof(byte[] password) throws SQLExceptionSapDB {
        try {
            return SCRAMMD5.scrammMD5(salt, password, clientchallenge,
                    serverchallenge);
        } catch (NoSuchAlgorithmException ex) {
            throw new SQLExceptionSapDB
			(MessageTranslator.translate
				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
				 "NoSuchAlgorithmException - algorithm \"MD5\" not supported by the java vm"));		

        }
    }

    /**
     * @param serverchallenge
     *            Parses the serverchallenge and split it into salt and real
     *            server challenge.
     */
    public void parseServerChallenge(byte[] vData)
    throws SQLExceptionSapDB {
        DataPartVariable vd = new DataPartVariable( new StructuredBytes (
                vData), 1);
        if (!vd.nextRow() || !vd.nextField()) {
            throw new SQLExceptionSapDB
			(MessageTranslator.translate
				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
				 Tracer.Hex2String(vData)));		
        }
        this.salt = vd.getBytes(vd.getCurrentOffset(),vd.getCurrentFieldLen());
        if (!vd.nextField()) {
            throw new SQLExceptionSapDB
			(MessageTranslator.translate
				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
				 Tracer.Hex2String(vData)));		
        }
        this.serverchallenge = vd.getBytes(vd.getCurrentOffset(),vd.getCurrentFieldLen());

    }
    /**
     * @param serverchallenge
     *            Parses the serverchallenge and split it into salt and real
     *            server challenge.
     */
    public void parseServerChallengeReply(DataPartVariable vData)
    throws SQLExceptionSapDB {
        if (!vData.nextRow() || !vData.nextField()) {
            throw new SQLExceptionSapDB
			(MessageTranslator.translate
				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
        }
        String algo = vData.getString(vData.getCurrentOffset(), vData
                .getCurrentFieldLen());
        if (!algo.equals(SCRAMMD5.algorithmname)) {
            throw new SQLExceptionSapDB
			(MessageTranslator.translate
				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
        }
        if (!vData.nextField() || vData.getCurrentFieldLen() < 8) {
            throw new SQLExceptionSapDB
			(MessageTranslator.translate
				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
        }
        if (vData.getCurrentFieldLen() == 40){
	        /*first version of challenge response 
	         *should only occurs with database version 7.6.0.0 <= kernel <= 7.6.0.7*/
	        this.salt = vData.getBytes(vData.getCurrentOffset(), 8);
	        this.serverchallenge = vData.getBytes(vData.getCurrentOffset() + 8,
	                vData.getCurrentFieldLen() - 8);
       } else {
           DataPartVariable vd = new DataPartVariable( new StructuredBytes (
                   vData.getBytes(vData.getCurrentOffset(), vData.getCurrentFieldLen())), 1);
           if (!vd.nextRow() || !vd.nextField()) {
               throw new SQLExceptionSapDB
   			(MessageTranslator.translate
   				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
   				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
           }
           this.salt = vd.getBytes(vd.getCurrentOffset(),vd.getCurrentFieldLen());
           if (!vd.nextField()) {
               throw new SQLExceptionSapDB
   			(MessageTranslator.translate
   				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
   				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
           }
           this.serverchallenge = vd.getBytes(vd.getCurrentOffset(),vd.getCurrentFieldLen());
           
           /*from Version 7.6.0.10 on also the max password length will be delivered*/
           if (vData.nextField()){
               DataPartVariable mp_vd = new DataPartVariable( new StructuredBytes (
                       vData.getBytes(vData.getCurrentOffset(), vData.getCurrentFieldLen())), 1);
               if (!mp_vd.nextRow() || !mp_vd.nextField()) {
                   throw new SQLExceptionSapDB
       			(MessageTranslator.translate
       				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
       				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
               }
               do {
                 if (mp_vd.getString(mp_vd.getCurrentOffset(),mp_vd.getCurrentFieldLen()).equals(Packet.csp1_maxpasswordlen_tag_C)){
                     if (!mp_vd.nextField()) {
                         throw new SQLExceptionSapDB
             			(MessageTranslator.translate
             				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
             				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
                     }else{
                        try {
                            this.maxpasswordLen = Integer.parseInt(mp_vd.getString(mp_vd.getCurrentOffset(),mp_vd.getCurrentFieldLen())) ;
                        } catch (NumberFormatException e) {
                            throw new SQLExceptionSapDB
                 			(MessageTranslator.translate
                 				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
                 				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
                        } 
                     }
                 } else {
                     if (!mp_vd.nextField()) {
                         throw new SQLExceptionSapDB
             			(MessageTranslator.translate
             				(MessageKey.ERROR_CONNECTION_WRONGSERVERCHALLENGERECEIVED,
             				 Tracer.Hex2String(vData.getBytes(0,vData.size()))));		
                     }
                 }     
               } while (mp_vd.nextField());
           }
       }  
    }
    
    public int getMaxpasswordLen() {
        return maxpasswordLen;
    }
}
